﻿Imports Eustat.Comun.V35.Web.GridView
Imports Eustat.Comun.V35.Web
Imports Eustat.Comun.V35.Fmk.Ng.MapNG
Imports System.Data

Partial Class WebUserControls_ctlInfo
    Inherits System.Web.UI.UserControl
    Implements IGestion
    Private _sesion As AppSession

#Region "Eventos genericos"
    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If (_sesion Is Nothing) Then
            _sesion = New AppSession
        End If
    End Sub
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        txtNumc.Text = _sesion.Numc
        txtAenc.Text = _sesion.Aenc
        txtTrim.Text = _sesion.Trim
        txtSem.Text = _sesion.Semana
    End Sub

#End Region

    ''' <summary>
    ''' Cambiar el constructor por defecto de las clases de origen de datos para la consulta de viviendas
    ''' 
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Protected Sub ObjectDataSource1_ObjectCreating(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceEventArgs) Handles ObjectDataSourceInfo.ObjectCreating
        ' Create an instance of the business object using a non-default constructor.
        Dim e_Info As Eustat.GEDW.V35.Ng.ConInfo = New Eustat.GEDW.V35.Ng.ConInfo(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Trim, _sesion.Idioma)
        e.ObjectInstance = e_Info
    End Sub




    Public Function GuardarCambios() As Boolean Implements IGestion.GuardarCambios
        Try
            _sesion.CambiosEnPagina = False
            Dim resul As Boolean = False
            Dim htCambios As Hashtable = New Hashtable()
            Page.Validate()
            If (Page.IsValid) Then
                Dim InfoLN As ConInfo = New Eustat.GEDW.V35.Ng.ConInfo(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Trim, _sesion.Idioma)

                Dim dsAux As DataSet = InfoLN.GetInfo()

                Dim dsGuardar As DataSet = dsAux.Copy()

                For Each dt As GridViewRow In gvInfo.Rows
                    Dim txtTelef1 As String = CType(dt.FindControl("txtTlfno1"), TextBox).Text.Replace(" ", "")
                    Dim txtTelef2 As String = CType(dt.FindControl("txtTlfno2"), TextBox).Text.Replace(" ", "")
                    Dim txtEmail As String = CType(dt.FindControl("txtEmail"), TextBox).Text
                    Dim nindInd As String = CType(dt.FindControl("lblNind"), WebControls.Label).Text

                    Dim selectedRow As DataRow = dsGuardar.Tables(0).Select(ConInfo.IdentColumnNind & " = '" & nindInd & "'")(0)

                    selectedRow(ConInfo.IdentColumnTelef1) = IIf(String.IsNullOrEmpty(txtTelef1), DBNull.Value, txtTelef1)
                     
                    selectedRow(ConInfo.IdentColumnTelef2) = IIf(String.IsNullOrEmpty(txtTelef2), DBNull.Value, txtTelef2)

                    selectedRow(ConInfo.IdentColumnEmail) = IIf(String.IsNullOrEmpty(txtEmail), DBNull.Value, txtEmail)
                Next

                InfoLN.actualizarDatos(dsGuardar)

                resul = True
            End If
            Return resul
        Catch ex As Exception
            Throw ex
        End Try
    End Function


    Protected Sub gvInfo_RowDataBound(ByVal sender As Object, ByVal e As System.EventArgs) Handles gvInfo.RowDataBound
        For Each dt As GridViewRow In gvInfo.Rows
            Dim txtTelef1 As Eustat.Comun.V35.Web.TextBox = CType(dt.FindControl("txtTlfno1"), Eustat.Comun.V35.Web.TextBox)
            Dim txtTelef2 As Eustat.Comun.V35.Web.TextBox = CType(dt.FindControl("txtTlfno2"), Eustat.Comun.V35.Web.TextBox)

            txtTelef1.Attributes.Add("onBlur", "javascript:aplicaMascara(document.getElementById('" + txtTelef1.ClientID + "'));")
            txtTelef2.Attributes.Add("onBlur", "javascript:aplicaMascara(document.getElementById('" + txtTelef2.ClientID + "'));")
            txtTelef1.Attributes.Add("onFocus", "javascript:eliminarMascara(document.getElementById('" + txtTelef1.ClientID + "'));")
            txtTelef2.Attributes.Add("onFocus", "javascript:eliminarMascara(document.getElementById('" + txtTelef2.ClientID + "'));")
        Next
    End Sub

    Function aplicarMascara(ByVal param As Object) As String
        Dim espacio As String = " "
        Dim telefono As String = IIf(String.IsNullOrEmpty(param.ToString()), String.Empty, param)
        If (telefono.Length = 9 AndAlso IsNumeric(telefono)) Then
            Return telefono.Substring(0, 3) + espacio + telefono.Substring(3, 3) + espacio + telefono.Substring(6, 3)
        Else
            Return telefono
        End If
    End Function
End Class
