﻿Imports Eustat.Comun.V35.Web.GridView
Imports Eustat.Comun.V35.Web
Imports Eustat.Comun.V35.Fmk.Ng.MapNG
Imports System.Data

Partial Class WebUserControls_ctlColectivo
    Inherits System.Web.UI.UserControl
    Implements IGestion
    Private _sesion As AppSession

    Private _descripcionPendienteRellenar As String = ""

#Region "Eventos genericos"
    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If (_sesion Is Nothing) Then
            _sesion = New AppSession
        End If

    End Sub
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If (Not IsPostBack) Then
            Dim ResultadosLN As Resultados = New Eustat.GEDW.V35.Ng.Resultados(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Idioma)
            Dim reviv As String = ResultadosLN.GetDatosRviv()
            _sesion.ResultVivienda = reviv


            Dim ResultadoCuestLN As ResultadoCuest = New ResultadoCuest(_sesion.Operacion)
            Dim drColl As DataRow() = CType(ResultadoCuestLN.GetResultadoCuest, DataSet).Tables(0).Select(Globales.COL_RESULTCUEST_ID & "=" & Globales.PENDIENTE)
            _descripcionPendienteRellenar = drColl(0)(IIf(_sesion.Idioma = Globales.C_IDIOMA_CASTELLANO, Globales.COL_RESULTCUEST_LITCAS, Globales.COL_RESULTCUEST_LITEUS))
        End If
      

    End Sub

#End Region

    ''' <summary>
    ''' Cambiar el constructor por defecto de las clases de origen de datos para la consulta de viviendas
    ''' 
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Protected Sub ObjectDataSource1_ObjectCreating(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceEventArgs) Handles ObjectDataSource3.ObjectCreating
        ' Create an instance of the business object using a non-default constructor.
        Dim e_Muestra As Eustat.GEDW.V35.Ng.ConColectivo = New Eustat.GEDW.V35.Ng.ConColectivo(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Idioma)
        e.ObjectInstance = e_Muestra
        _sesion.ColectivoInfo = e_Muestra
    End Sub


    'Evento para visualizar la encuesta concreta
    Protected Sub ClickLupa(ByVal sender As Object, ByVal e As EventArgs)

        If _sesion.IC.TieneIC Then
            ActualizarMuestra()
        End If
        Dim img As ImageButton = CType(sender, ImageButton)
        Dim tableC As DataControlFieldCell = CType(img.Parent, DataControlFieldCell)
        Dim gridR As GridViewRow = CType(tableC.Parent, GridViewRow)

        Dim estadoFamiliar As String = CType(gridR.Cells(12).Controls(0), DataBoundLiteralControl).Text.Trim()
        'Si es la primera vez que accedo guardo el resultado de vivienda como localizada
        If (estadoFamiliar.Equals(Globales.PENDIENTE)) Then
            Dim ResultadosLN As Resultados = New Eustat.GEDW.V35.Ng.Resultados(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Idioma)
            ResultadosLN.ActualizarDatosResultViv(Globales.RVIV_LOCALIZADA)
            _sesion.ResultVivienda = Globales.RVIV_LOCALIZADA
        End If

        Dim idioma As String = _sesion.ColectivoInfo.ObtenerIdiomaCFam()
        If (String.IsNullOrEmpty(idioma)) Then
            idioma = _sesion.Idioma
        End If

        Dim nind As String = CType(gridR.Cells(14).Controls(0), DataBoundLiteralControl).Text.ToString().Trim()

        'no establecido valor de querystring por seguridad. Contactar con Eustat
        Dim querystring As String = ""

        'Almaceno el resultado de contactado en la vivienda
        Dim contacto As ConContactos = New ConContactos(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Trim)
        contacto.ActualizarRContactoVivienda()
        Dim strRuta As String = "winenc = window.open('" + ObtenerURLAcceso(_sesion.Operacion, querystring, _sesion.Idioma) + "','Encuesta');"

        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "newWindow", "javascrip:" & strRuta & ";", True)

        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "modWindow", "javascrip:ShowPopup();", True)

    End Sub

    'Evento para visualizar la encuesta concreta
    Protected Sub ClickLupa2(ByVal sender As Object, ByVal e As EventArgs)
        If _sesion.IC.TieneIC Then
            ActualizarMuestra()
        End If

        If (GuardarCambios()) Then
            Dim img As ImageButton = CType(sender, ImageButton)
            Dim tableC As DataControlFieldCell = CType(img.Parent, DataControlFieldCell)
            Dim gridR As GridViewRow = CType(tableC.Parent, GridViewRow)

            Dim nind As String
            Dim ctlInfPersonal As ctldplstPersonasViv = CType(gridR.FindControl("ctlInformanteInd"), ctldplstPersonasViv)

            Dim strRuta As String

            Dim idioma As String = _sesion.ColectivoInfo.ObtenerIdiomaCInd()
            If (String.IsNullOrEmpty(idioma)) Then
                idioma = _sesion.Idioma
            End If

            Dim querystring As String = ""
          
            'encuestas demograficas implementadas en Canal Web 2.0
            Dim informante As String
            informante = ctlInfPersonal.SeleccionarValor()
            nind = CType(gridR.Cells(14).Controls(0), DataBoundLiteralControl).Text.ToString().Trim()
            'no establecido valor de querystring por seguridad. Contactar con Eustat
            querystring = ""
            strRuta = "winenc = window.open('" + ObtenerURLAcceso(_sesion.Operacion, querystring, _sesion.Idioma) + "','Encuesta');"

            ScriptManager.RegisterStartupScript(Page, Page.GetType(), "newWindow", "javascrip:" & strRuta & ";", True)

            ScriptManager.RegisterStartupScript(Page, Page.GetType(), "modWindow", "javascrip:ShowPopup();", True)
        End If
    End Sub


    Protected Function ConvertirValorSexo(ByVal o As Object) As String
        Dim result As String = ""
        If (Not IsDBNull(o)) Then
            If (o.ToString().Equals("2") Or o.ToString().Equals("6")) Then
                result = GetLocalResourceObject("lblMujer").ToString()
            ElseIf (o.ToString().Equals("1")) Then
                result = GetLocalResourceObject("lblVaron").ToString()
            End If
        End If
        Return result
    End Function

    Protected Function ConvertirValorSita(ByVal o As Object) As String
        Dim result As String = ""
        If (Not IsDBNull(o)) Then
            If (o.ToString().Equals(Globales.INDIVIDUO_BAJA.ToString())) Then
                result = GetLocalResourceObject("lblBaja").ToString()
            ElseIf (o.ToString().Equals(Globales.INDIVIDUO_ALTA.ToString())) Then
                result = GetLocalResourceObject("lblAlta").ToString()
            ElseIf (o.ToString().Equals(Globales.INDIVIDUO_PERMANECE.ToString())) Then
                result = GetLocalResourceObject("ListItemSi").ToString()
            End If
        End If
        Return result
    End Function

    'Función para mostrar la fecha en el idioma correcto
    Protected Function ContenidoFecha(ByVal oDate As Object) As String
        Dim result As String = String.Empty
        If Globalization.CultureInfo.CurrentCulture.ToString() = "es-ES" Then
            result = oDate.ToString()
        ElseIf Globalization.CultureInfo.CurrentCulture.ToString() = "eu-ES" Then
            Dim arrayFecha As Array = oDate.ToString().Split("/")
            result = arrayFecha(2) + "/" + arrayFecha(1) + "/" + arrayFecha(0)
        End If
        Return result
    End Function

    Protected Sub GridView2_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles GridView2.RowDataBound
        If (_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar) Then
            e.Row.Cells(5).Visible = True
            e.Row.Cells(6).Visible = True
        Else
            e.Row.Cells(5).Visible = False
            e.Row.Cells(6).Visible = False
        End If
        If (e.Row.RowType = DataControlRowType.DataRow) Then
            Dim indFamiliar As String = CType(e.Row.Cells(10).Controls(0), DataBoundLiteralControl).Text.Trim()
            Dim indPersonal As String = CType(e.Row.Cells(11).Controls(0), DataBoundLiteralControl).Text.Trim()
            Dim ctlestadoFamiliar As Label = CType(e.Row.FindControl("lblNomResFam"), Label)
            Dim estadoFamiliar As String = CType(e.Row.Cells(12).Controls(0), DataBoundLiteralControl).Text.Trim()
            Dim estadoPersonal As String = CType(e.Row.Cells(13).Controls(0), DataBoundLiteralControl).Text.Trim()
            If String.IsNullOrEmpty(estadoPersonal) AndAlso indPersonal.Equals(Globales.VALOR_SI_IND) Then
                CType(e.Row.FindControl("litNomResPer"), Literal).Text = _descripcionPendienteRellenar
            End If
            Dim ctlInfPersonal As ctldplstPersonasViv = CType(e.Row.FindControl("ctlInformanteInd"), ctldplstPersonasViv)
            ctlInfPersonal.EdadMinima = _sesion.EncuestaSeleccionadaInfo.EdadMinInd
            ctlInfPersonal.EdadMinimaNindIncluir = _sesion.EncuestaSeleccionadaInfo.EdadMinCuesPropio
            ctlInfPersonal.NindIncluir =CType(e.Row.Cells(14).Controls(0), DataBoundLiteralControl).Text.ToString().Trim()
            ctlInfPersonal.MostrarEdad = True
            ctlInfPersonal.CargarDatos()
            Dim dt As DataSet = _sesion.ColectivoInfo.GetDatos()

            Dim infor As DataRow() = dt.Tables(0).Select(ConColectivo.ColumnIndFam & " = '" & Globales.VALOR_SI_IND & "'")

            'comprobamos si debemos visualizar el icono de familiar
            Dim imgFamiliar As ImageButton = CType(e.Row.FindControl("imgDetalle"), ImageButton)
            imgFamiliar.ImageUrl = ConfigurationManager.AppSettings("Images") & "quiz.png"
            If (_sesion.ResultVivienda.Equals(Globales.RVIV_LOCALIZADA) Or String.IsNullOrEmpty(_sesion.ResultVivienda)) Then
                Dim estadoValidoFam As Boolean = (estadoFamiliar.Equals(Globales.COMPLETO) OrElse estadoFamiliar.Equals(Globales.INCOMPLETO) OrElse estadoFamiliar.Equals(Globales.PENDIENTE))
                If (indFamiliar.Equals(Globales.VALOR_SI_IND) And estadoValidoFam) Then
                    imgFamiliar.Visible = True
                Else
                    imgFamiliar.Visible = False
                End If
            Else
                imgFamiliar.Visible = False
            End If
            'visualizacion de estado de familiar
            Dim estadoValidoVisFam As Boolean = (estadoFamiliar.Equals(Globales.COMPLETO)) OrElse (estadoFamiliar.Equals(Globales.INCOMPLETO))
            If (estadoValidoVisFam And indFamiliar.Equals(Globales.VALOR_SI_IND)) Then
                ctlestadoFamiliar.Visible = True
            Else
                If ((estadoFamiliar.Equals(Globales.PENDIENTE) And indFamiliar.Equals(Globales.VALOR_SI_IND)) _
                    Or ((estadoFamiliar.Equals(Globales.PENDIENTE) And infor.Length = 0)) _
                    Or (Not (estadoValidoVisFam) And Not (estadoFamiliar.Equals(Globales.PENDIENTE)))) Then
                    ctlestadoFamiliar.Visible = True
                Else
                    ctlestadoFamiliar.Visible = False
                End If
            End If

            Dim imgPersonal As ImageButton = CType(e.Row.FindControl("imgDetalle2"), ImageButton)
            imgPersonal.ImageUrl = ConfigurationManager.AppSettings("Images") & "quiz.png"
            If (_sesion.ResultVivienda.Equals(Globales.RVIV_LOCALIZADA)) Then
                If (Not (_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar) OrElse estadoFamiliar.Equals(Globales.COMPLETO)) Then
                    Dim estadoValidoInd As Boolean = (estadoPersonal.Equals(Globales.COMPLETO) OrElse estadoPersonal.Equals(Globales.INCOMPLETO) OrElse estadoPersonal.Equals(Globales.PENDIENTE))
                    If (indPersonal.Equals(Globales.VALOR_SI_IND) And estadoValidoInd) Then
                        imgPersonal.Visible = True
                    Else
                        imgPersonal.Visible = False
                        ctlInfPersonal.Visible = False
                    End If
                Else
                    imgPersonal.Visible = False
                    ctlInfPersonal.Visible = False
                End If
            Else
                imgPersonal.Visible = False
                ctlInfPersonal.Visible = False
            End If
            Dim edad As Integer = TryCast(e.Row.DataItem, DataRowView)(ConColectivo.ColumnIndEdad)
            If edad >= Globales.VALOR_EDAD_IC Then
                CType(e.Row.FindControl("lblNombInd"), Label).CssClass = "resaltar"
                CType(e.Row.FindControl("lblEdadInd"), Label).CssClass = "resaltar"
            End If
        End If
    End Sub

    Public Function GuardarCambios() As Boolean Implements IGestion.GuardarCambios
        Try

            _sesion.CambiosEnPagina = False
            Dim resul As Boolean = False
            Dim htCambios As Hashtable = New Hashtable()
            Page.Validate()
            If (Page.IsValid) Then
                For Each row As GridViewRow In GridView2.Rows
                    Dim cmbInfPersonal As ctldplstPersonasViv = CType(row.FindControl("ctlInformanteInd"), ctldplstPersonasViv)
                    Dim nind As String = CType(row.Cells(14).Controls(0), DataBoundLiteralControl).Text.ToString().Trim()
                    If (cmbInfPersonal.Visible) Then
                        htCambios.Add(nind, cmbInfPersonal.SeleccionarValor)
                    End If
                Next
                Dim ColectivoInfo As ConColectivo = New Eustat.GEDW.V35.Ng.ConColectivo(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Idioma)
                ColectivoInfo.guardarDatosInformantePer(htCambios)
                htCambios.Clear()
                resul = True
            End If
            Return resul
        Catch ex As Exception
            Throw ex
        End Try
    End Function


    Private Sub ActualizarMuestra()
        If Not (_sesion.GestionEncuestaMuestra) Is Nothing AndAlso _sesion.Numc = _sesion.GestionEncuestaMuestra.Numc And _sesion.Aenc = _sesion.GestionEncuestaMuestra.Aenc And _sesion.Trim = _sesion.GestionEncuestaMuestra.Tenc And _sesion.Semana = _sesion.GestionEncuestaMuestra.Sem Then
            _sesion.GestionEncuestaMuestra.Actualizar()
        End If
    End Sub
End Class
