﻿
Partial Class ctldplstPersonasViv
    Inherits System.Web.UI.UserControl

    Private Const PREFIJO_INFORMANTE_IC As String = "PrefijoInformanteIC"

    Private _sesion As New AppSession

    Public Delegate Sub Evento(ByVal sender As Object, ByVal e As EventArgs, ByVal num As Integer)
    Public Event dplstPersonasVivienda_SelectedIndexChanged As Evento

   


    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If (Not IsPostBack) Then
            CargarDatos()
        End If
        ' Recoger información de la sesión ...

    End Sub

    Public Sub CargarDatos()
        'Personas
        Dim PersonasLN As Integrantes
        If (Not String.IsNullOrEmpty(_sesion.Trim)) Then
            PersonasLN = New Integrantes(_sesion.Aenc, _sesion.Numc, _sesion.Operacion, _sesion.Trim)
        Else
            PersonasLN = New Integrantes(_sesion.Aenc, _sesion.Numc, _sesion.Operacion)
        End If
        If EdadMinima > 0 Then
            If EdadMinimaNindIncluir > 0 Then
                PersonasLN.GetIntegrantes(EdadMinima, NindIncluir, EdadMinimaNindIncluir)
            Else
                PersonasLN.GetIntegrantes(EdadMinima)
            End If
        Else
            PersonasLN.GetIntegrantes(Menores)
        End If

        Dim dsIntegrantes As System.Data.DataSet
        dsIntegrantes = PersonasLN.GetDsIntegrantes()
        If _sesion.IC.TieneIC Then
            If _sesion.GestionEncuestaMuestra Is Nothing OrElse (_sesion.Numc <> _sesion.GestionEncuestaMuestra.NUMC Or _sesion.Aenc <> _sesion.GestionEncuestaMuestra.AENC Or _sesion.Trim <> _sesion.GestionEncuestaMuestra.TENC Or _sesion.Semana <> _sesion.GestionEncuestaMuestra.SEM) Then
                _sesion.GestionEncuestaMuestra = New Muestra(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Trim, _sesion.Semana)
            End If
            If Not _sesion.GestionEncuestaMuestra Is Nothing AndAlso Not String.IsNullOrEmpty(_sesion.GestionEncuestaMuestra.ICNombre) Then
                Dim dr As Data.DataRow = dsIntegrantes.Tables(0).NewRow
                dr(PersonasLN.ColumnaDescripcion) = GetLocalResourceObject(PREFIJO_INFORMANTE_IC) & " " & _sesion.GestionEncuestaMuestra.ICNombre
                dr(PersonasLN.ColumnaDescripcionNomEdad) = GetLocalResourceObject(PREFIJO_INFORMANTE_IC) & " " & _sesion.GestionEncuestaMuestra.ICNombre
                dr(PersonasLN.ColumnaId) = IC.VALOR_PERSONA_CONFIANZA
                dsIntegrantes.Tables(0).Rows.Add(dr)
            End If
        End If
        dplstPersonas.DataSource = dsIntegrantes
        dplstPersonas.DataTextField = IIf(MostrarEdad, PersonasLN.ColumnaDescripcionNomEdad, PersonasLN.ColumnaDescripcion)
        dplstPersonas.DataValueField = PersonasLN.ColumnaId
        dplstPersonas.DataBind()
        If (Not IsNothing(dplstPersonas.Items.FindByValue(_selectedvalue))) Then
            dplstPersonas.SelectedValue = _selectedvalue
        Else
            dplstPersonas.SelectedValue = ""
        End If
    End Sub

    Private _numfila As Integer = 1
    Public Property NumFila As Integer
        Get
            Return _numfila

        End Get
        Set(ByVal value As Integer)
            _numfila = value
            dplstPersonas.Attributes.Add("AccessKey", (_numfila - 1).ToString())
        End Set
    End Property

    Private _selectedvalue As String
    Public Property SeleccionarValor As String
        Get
            Return dplstPersonas.SelectedValue
        End Get
        Set(ByVal value As String)
            _selectedvalue = value
            If (Not IsNothing(dplstPersonas.Items.FindByValue(value))) Then
                dplstPersonas.SelectedValue = value
            Else
                dplstPersonas.SelectedValue = ""
            End If
        End Set
    End Property

    Overloads ReadOnly Property isValid As Boolean
        Get
            Return dplstPersonas.IsValid
        End Get
    End Property

    Private _menores As Boolean
    Overloads Property Menores As Boolean
        Get
            Return _menores
        End Get
        Set(ByVal value As Boolean)
            _menores = value
        End Set
    End Property

    Private _edadMinima As Integer
    Overloads Property EdadMinima As Integer
        Get
            Return _edadMinima
        End Get
        Set(ByVal value As Integer)
            _edadMinima = value
        End Set
        
    End Property


    Private _edadMinimaNindIncluir As Integer
    Overloads Property EdadMinimaNindIncluir As Integer
        Get
            Return _edadMinimaNindIncluir
        End Get
        Set(ByVal value As Integer)
            _edadMinimaNindIncluir = value
        End Set

    End Property

    Private _nindIncluir As String
    Overloads Property NindIncluir As String
        Get
            Return _nindIncluir
        End Get
        Set(ByVal value As String)
            _nindIncluir = value
        End Set

    End Property

    Private _mostrarEdad As Boolean = False
    Public Property MostrarEdad As Boolean
        Get
            Return _mostrarEdad
        End Get
        Set(ByVal value As Boolean)
            _mostrarEdad = value
        End Set
    End Property


    Overloads Property Visible As Boolean
        Get
            Return dplstPersonas.Visible
        End Get
        Set(ByVal value As Boolean)
            dplstPersonas.Visible = value
        End Set
    End Property

    Overloads Property AutoPostBack As Boolean
        Get
            Return dplstPersonas.AutoPostBack
        End Get
        Set(ByVal value As Boolean)
            dplstPersonas.AutoPostBack = value
        End Set
    End Property

    Overloads Property Enabled As Boolean
        Get
            Return dplstPersonas.Enabled
        End Get
        Set(ByVal value As Boolean)
            dplstPersonas.Enabled = value
        End Set
    End Property

    Overloads Property SelectedIndex As Integer
        Get
            Return dplstPersonas.SelectedIndex
        End Get
        Set(ByVal value As Integer)
            dplstPersonas.SelectedIndex = value
        End Set
    End Property



    Protected Sub dplstPersonas_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dplstPersonas.SelectedIndexChanged
        Dim combo As DropDownList = CType(sender, DropDownList)
        _sesion.CambiosEnPagina = True
        Me.SeleccionarValor = CType(sender, DropDownList).SelectedValue
        RaiseEvent dplstPersonasVivienda_SelectedIndexChanged(sender, e, combo.Attributes("AccessKey").ToString())
    End Sub
End Class

