﻿
Imports Microsoft.Office.Interop
Imports Microsoft.Office.Interop.Excel
Imports Microsoft.Office.Interop.Excel.Constants
Imports System.Diagnostics
Imports System.Data



Partial Public Class ctlMuestra
    Inherits System.Web.UI.UserControl
    Implements IMuestra

#Region "CONSTANTES"
#Region "EXCEL"
    Private Const C_EXCEL_COL_DATOS_IC As String = "O" 

    Private Const C_EXCEL_COL_FILTRO_IC As String = "J"
    Private Const C_EXCEL_COL_FILTRO_FIN_IC As String = "K" 'columna de fin hasta donde se deben combinar(merge) las celdas
    Private Const C_EXCEL_FILA_FILTRO_IC As String = "9"
#End Region

#End Region

    Dim bytesFicheroExcel() As Byte

    Private _sesion As AppSession

    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If (_sesion Is Nothing) Then
            _sesion = New AppSession
        End If
        If _sesion.EstadoGVMuestra Is Nothing Then
            _sesion.EstadoGVMuestra = New EstadoGridView()
        End If
        _sesion.EstadoGVMuestra.InicializarEstado(gvResultados)

    End Sub


    Protected Sub Page_Unload(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Unload
        _sesion.EstadoGVMuestra.GuardarEstado(gvResultados)
    End Sub

    Sub Refrescar() Implements IMuestra.Refrescar
        gvResultados.DataBind()
    End Sub

    Sub VisualizarExcel(ByVal valor As Boolean) Implements IMuestra.VisualizarExcel
        lkExcel.Visible = valor
        imgExcel.Visible = valor
        imgExcel.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
    End Sub

    Property NumPag As Integer Implements IMuestra.NumPag
        Get
            Return gvResultados.PageIndex
        End Get
        Set(ByVal value As Integer)
            gvResultados.PageIndex = value
        End Set
    End Property




    Sub VisualizarErrorExcel(ByVal valor As Boolean) Implements IMuestra.VisualizarErrorExcel
        lblErrorAviso.Visible = valor
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load 
        'Trimestre
        Dim TrimLN As Trimestre = New Trimestre(_sesion.Operacion)
        Dim dtTrim As DataSet = TrimLN.GetDsTrim()
        If (Not IsNothing(dtTrim)) Then
            gvResultados.Columns(1).Visible = True
        Else
            gvResultados.Columns(1).Visible = False
        End If
        'Semana
        Dim SemLN As Semana = New Semana(_sesion.Operacion)
        Dim dtSem As DataSet = SemLN.GetDsSem()
        If (Not IsNothing(dtSem)) Then
            gvResultados.Columns(2).Visible = True
        Else
            gvResultados.Columns(2).Visible = False
        End If
        If Not Page.IsPostBack Then
            _sesion.EstadoGVMuestra.CargarEstado(gvResultados)
        End If

    End Sub

    Protected Sub gvResultados_PreRender(ByVal sender As Object, ByVal e As System.EventArgs) Handles gvResultados.PreRender
        If Not Page.Request.Params("__EVENTTARGET") Is Nothing AndAlso Page.Request.Params("__EVENTTARGET").Contains(gvResultados.UniqueID) AndAlso Page.Request.Params("__EVENTTARGET").EndsWith("DdlPageSize") Then
           
            gvResultados.DataBind()
        End If
            Page.Validate()
            If (Page.IsValid) Then
                Dim mostrar As Boolean = (System.Configuration.ConfigurationManager.AppSettings.Get("MOSTRAR_EXCEL").ToString().Equals("S"))
                lkExcel.Visible = (gvResultados.Rows.Count > 0 And mostrar)
                imgExcel.Visible = (gvResultados.Rows.Count > 0 And mostrar)
                imgExcel.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
            Else
                lkExcel.Visible = False
                imgExcel.Visible = False
        End If
        If (Not (_sesion.EncuestaSeleccionadaInfo.CambioDireccion)) Then
            gvResultados.Columns(8).Visible = False
            gvResultados.Columns(9).Visible = False
        Else
            gvResultados.Columns(8).Visible = True
            gvResultados.Columns(9).Visible = True
        End If
    End Sub

    Protected Sub gvResultados_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvResultados.RowDataBound
        If (e.Row.RowType = DataControlRowType.DataRow) Then
            Dim imgDetalle As ImageButton = CType(e.Row.FindControl("imgDetalle"), ImageButton)

            imgDetalle.ImageUrl = ConfigurationManager.AppSettings("Images") & "hr.png"
            Dim mostrar As Boolean = (System.Configuration.ConfigurationManager.AppSettings.Get("MOSTRAR_EXCEL").ToString().Equals("S"))
            lkExcel.Visible = (gvResultados.Rows.Count > 0 And mostrar)
            imgExcel.Visible = (gvResultados.Rows.Count > 0 And mostrar)
            imgExcel.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"

            Dim imgIC As Image = CType(e.Row.FindControl("imgIC"), System.Web.UI.WebControls.Image)
            If _sesion.IC.TieneIC Then
                imgIC.ImageUrl = ConfigurationManager.AppSettings("Images") & "icono-ic-" & _sesion.Idioma.Substring(0, 2) & ".png"
                imgIC.Visible = _sesion.IC.EsIC(TryCast(e.Row.DataItem, DataRowView)(ConMuestra.IdentColumnIC).ToString)
            Else
                imgIC.Visible = False
            End If
        End If
    End Sub

    Protected Sub ObjectDataSource1_Selecting(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceSelectingEventArgs) Handles ObjectDataSource1.Selecting
        Page.Validate()
        If Not Page.IsValid Then
            e.Cancel = True
        End If
    End Sub

    'Evento para validación de numc concreto
    Protected Sub ClickValidar(ByVal sender As Object, ByVal e As EventArgs)


    End Sub

    ''' <summary>
    ''' Cambiar el constructor por defecto de las clases de origen de datos para la consulta de viviendas
    ''' 
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Protected Sub ObjectDataSource1_ObjectCreating(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceEventArgs) Handles ObjectDataSource1.ObjectCreating
        ' Create an instance of the business object using a non-default constructor.

        Dim e_Muestra As Eustat.GEDW.V35.Ng.ConMuestra = New Eustat.GEDW.V35.Ng.ConMuestra(_sesion.Operacion, _sesion.Idioma, _sesion.UsuarioActual, _sesion.EncuestaSeleccionadaInfo)
        e_Muestra.LitS = Resources.ConsultaViviendas.litS
        e_Muestra.LitN = Resources.ConsultaViviendas.litN
        e_Muestra.LitF = Resources.ConsultaViviendas.litF
        e_Muestra.LitC = Resources.ConsultaViviendas.litC
        e.ObjectInstance = e_Muestra
        _sesion.ConsultaVivInfo = e.ObjectInstance
        'CargarDatosEnSesion()
    End Sub


    Protected Sub gvResultados_RowCommand(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewCommandEventArgs) Handles gvResultados.RowCommand
        Try
            If e.CommandName = "Consulta" Then

                Dim vars As String() = e.CommandArgument.ToString().Split("_")
                _sesion.Numc = vars(0).ToString()
                _sesion.Aenc = vars(1).ToString()
                If gvResultados.Columns(1).Visible = True Then
                    _sesion.Trim = CType(CType(e.CommandSource, ImageButton).NamingContainer, GridViewRow).Cells(1).Text
                End If
                _sesion.PestañaActiva = Globales.PESTANIA_VIV
                _sesion.CambiosEnPagina = False
                Response.Redirect("~/GestionEncuesta.aspx", False)
                Context.ApplicationInstance.CompleteRequest()
            End If
        Catch ex As Exception
            Throw ex
        End Try
    End Sub

    Protected Sub gvResultados_RowCreated(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvResultados.RowCreated
        If (e.Row.RowType = DataControlRowType.DataRow) Then
            Dim img As System.Web.UI.WebControls.LinkButton = CType(e.Row.FindControl("lnkValidar"), System.Web.UI.WebControls.LinkButton)
            Dim img2 As System.Web.UI.WebControls.ImageButton = CType(e.Row.FindControl("imgDetalle"), System.Web.UI.WebControls.ImageButton)

            ScriptManager.GetCurrent(Page).RegisterPostBackControl(img)
            ScriptManager.GetCurrent(Page).RegisterPostBackControl(img2)

        End If

    End Sub

    

#Region "Excel"

    Protected Sub lkExcel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lkExcel.Click
        lblErrorAviso.Visible = False
        Dim err As String = String.Empty
        Dim ExcelApplication As Excel.Application

        Dim mostrarTrim As Boolean = False
        Dim mostrarSem As Boolean = False

        'Trimestre
        Dim TrimLN As Trimestre = New Trimestre(_sesion.Operacion)
        Dim dtTrim As DataSet = TrimLN.GetDsTrim()
        If (Not IsNothing(dtTrim)) Then
            mostrarTrim = True
        Else
            mostrarTrim = False
        End If
        'Semana
        Dim SemLN As Semana = New Semana(_sesion.Operacion)
        Dim dtSem As DataSet = SemLN.GetDsSem()
        If (Not IsNothing(dtSem)) Then
            mostrarSem = True
        Else
            mostrarSem = False
        End If

        Dim numColumnaFinal As Integer = 78
        Dim numColumnaInicial As Integer = 65
        ' Guardar el idioma actual
        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        Try

            Dim regmax As Integer = CType(System.Configuration.ConfigurationManager.AppSettings.Get("REGMAX_EXCEL"), Integer)
            If (_sesion.ConsultaVivInfo.GetDatos().Tables(0).Rows.Count > regmax) Then
                lblErrorAviso.Text = String.Format(Resources.ConsultaViviendas.LabelErrorNumReg, regmax.ToString())
                lblErrorAviso.Visible = True
            Else
                lblErrorAviso.Text = String.Empty
                lblErrorAviso.Visible = False
                'Plantillas Excel
                '-------------------------------------------------

                Dim libroexcel As Excel.Workbook
                Dim hojaExcel As Excel.Worksheet

                Dim filename As String = ""

                Dim bytes() As Byte = Nothing

                Dim plantilla As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATH") + System.Configuration.ConfigurationManager.AppSettings.Get("NOM_PLANTILLA_EXCEL")
                ExcelApplication = New Excel.Application

                ' Cambiar el idioma a castellano, para que no casque la generación del Excel
                System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")

                ExcelApplication.Workbooks.Add(plantilla)
                libroexcel = ExcelApplication.Workbooks(1)
                libroexcel.Activate()

                hojaExcel = libroexcel.Sheets(1)

                hojaExcel.Activate()

                Dim hojas(libroexcel.Sheets.Count - 1) As Excel.Worksheet
                Dim i As Integer = 0
                For i = 0 To libroexcel.Sheets.Count - 1
                    hojas(i) = libroexcel.Sheets.Item(i + 1)
                Next

                hojaExcel.Range("D2").Value = String.Format(Resources.ConsultaViviendas.LiteralNombreEncuestaResource1.ToString(), _sesion.Operacion) & " " & "Fecha:" & Now.Date.ToShortDateString()
                hojaExcel.Range("D2:N2").Font.Bold = True
                hojaExcel.Range("D2:N2").MergeCells = True
                hojaExcel.Range("D2:N2").HorizontalAlignment = Excel.XlHAlign.xlHAlignJustify
                hojaExcel.Range("D2:N2").VerticalAlignment = Excel.XlVAlign.xlVAlignCenter


                hojaExcel.Range("A4:N8").HorizontalAlignment = Excel.XlHAlign.xlHAlignLeft
                hojaExcel.Range("A4:N8").VerticalAlignment = Excel.XlVAlign.xlVAlignTop
                hojaExcel.Range("A4").Value = Resources.ConsultaViviendas.lblAnioResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectAnio.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectAnio)
                hojaExcel.Range("B4").Value = Resources.ConsultaViviendas.lblNumcResource1 & " " & _sesion.FiltrosConsultaInfo.SelectNumcDesde
                hojaExcel.Range("B4:C4").MergeCells = True
                hojaExcel.Range("D4").Value = Resources.ConsultaViviendas.lblNumcHastaResource1 & " " & _sesion.FiltrosConsultaInfo.SelectNumcHasta
                hojaExcel.Range("D4:E4").MergeCells = True
                hojaExcel.Range("F4").Value = Resources.ConsultaViviendas.LabelTerritorioHistoricoResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectTh.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectTh)
                hojaExcel.Range("F4:G4").MergeCells = True
                hojaExcel.Range("H4").Value = Resources.ConsultaViviendas.LabelComarcaResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectCom.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectCom)
                hojaExcel.Range("H4:J4").MergeCells = True
                hojaExcel.Range("K4").Value = Resources.ConsultaViviendas.LabelMunicipioResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectMun.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectMun)
                hojaExcel.Range("K4:M4").MergeCells = True
                If (mostrarTrim) Then
                    hojaExcel.Range("A5").Value = Resources.ConsultaViviendas.lblTrimResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectTrim.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectTrim)
                End If
                If (mostrarSem) Then
                    hojaExcel.Range("B5").Value = Resources.ConsultaViviendas.lblSemResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectSem.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectSem)
                End If
                hojaExcel.Range("A6").Value = Resources.ConsultaViviendas.LabelFechaFamDesdeResource1 & " " & _sesion.FiltrosConsultaInfo.SelecFecFamDesde
                hojaExcel.Range("A6:C6").MergeCells = True
                hojaExcel.Range("D6").Value = Resources.ConsultaViviendas.LabelFechaFamHastaResource1 & " " & _sesion.FiltrosConsultaInfo.SelecFecFamHasta
                hojaExcel.Range("D6:E6").MergeCells = True
                hojaExcel.Range("F6").Value = Resources.ConsultaViviendas.LabelFechaIndDesdeResource1 & " " & _sesion.FiltrosConsultaInfo.SelecFecIndDesde
                hojaExcel.Range("F6:H6").MergeCells = True
                hojaExcel.Range("I6").Value = Resources.ConsultaViviendas.LabelFechaIndHastaResource1 & " " & _sesion.FiltrosConsultaInfo.SelecFecIndHasta
                hojaExcel.Range("I6:J6").MergeCells = True

                hojaExcel.Range("A7").Value = Resources.ConsultaViviendas.LabelSituacionResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectSituac.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectSituac)
                hojaExcel.Range("A7:C7").MergeCells = True
                hojaExcel.Range("D7").Value = Resources.ConsultaViviendas.LabelRcontactoResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectRCont.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectRCont)
                hojaExcel.Range("D7:F7").MergeCells = True
                hojaExcel.Range("G7").Value = Resources.ConsultaViviendas.LabelREncuestaResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectRViv.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectRViv)
                hojaExcel.Range("G7:I7").MergeCells = True
                hojaExcel.Range("A8").Value = Resources.ConsultaViviendas.LabelRcuestFamResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectRFam.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectRFam)
                hojaExcel.Range("A8:C8").MergeCells = True
                hojaExcel.Range("D8").Value = Resources.ConsultaViviendas.LabelMetodoFamResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelecMetodoFam.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelecMetodoFam)
                hojaExcel.Range("D8:F8").MergeCells = True
                hojaExcel.Range("G8").Value = Resources.ConsultaViviendas.LabelEncFamResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelecEncFam.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelecEncFam)
                hojaExcel.Range("G8:I8").MergeCells = True
                hojaExcel.Range("A9").Value = Resources.ConsultaViviendas.LabelRcuestPerResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectRPer.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectRPer)
                hojaExcel.Range("A9:C9").MergeCells = True
                hojaExcel.Range("D9").Value = Resources.ConsultaViviendas.LabelMetodoIndResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelecMetodoInd.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelecMetodoInd)
                hojaExcel.Range("D9:F9").MergeCells = True
                hojaExcel.Range("G9").Value = Resources.ConsultaViviendas.LabelEncIndResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelecEncInd.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelecEncInd)
                hojaExcel.Range("G9:I9").MergeCells = True

                If _sesion.IC.TieneIC Then
                    hojaExcel.Range(C_EXCEL_COL_FILTRO_IC & C_EXCEL_FILA_FILTRO_IC).Value = Resources.ConsultaViviendas.LabelViviendaICResource1 & " " & IIf(_sesion.FiltrosConsultaInfo.SelectIC.Equals(Resources.ConsultaViviendas.LabelElija), "", _sesion.FiltrosConsultaInfo.SelectIC)
                    hojaExcel.Range(C_EXCEL_COL_FILTRO_IC & C_EXCEL_FILA_FILTRO_IC & ":" & C_EXCEL_COL_FILTRO_FIN_IC & C_EXCEL_FILA_FILTRO_IC).MergeCells = True
                End If

                'hojaExcel.Range("A10").Value = "Año"
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.lblNumcAuxResource1
                numColumnaInicial = numColumnaInicial + 1
                If (mostrarTrim) Then
                    hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.lblTrimResource1
                    numColumnaInicial = numColumnaInicial + 1
                    numColumnaFinal = numColumnaFinal + 1
                End If
                If (mostrarSem) Then
                    hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.lblSemResource1
                    numColumnaInicial = numColumnaInicial + 1
                    numColumnaFinal = numColumnaFinal + 1
                End If
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.LabelTerritorioHistoricoResource1
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.LabelMunicipioResource1
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.LabelEntidadPob
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.LabelSituacionResource1
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.LabelRcontactoResource1
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.LabelREncuestaResource1
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.LabelRcuestFamResource1
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.LabelMetodoFamResource1
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.lblAgenteFam
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.lblInformInd
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.LabelRcuestPerResource1
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.LabelMetodoIndResource1
                numColumnaInicial = numColumnaInicial + 1
                hojaExcel.Range(Chr(numColumnaInicial) & "11").Value = Resources.ConsultaViviendas.lblAgenteInd
                numColumnaInicial = numColumnaInicial + 1
                If _sesion.EncuestaSeleccionadaInfo.CambioDireccion Then
                    If _sesion.IC.TieneIC Then
                        numColumnaFinal = numColumnaFinal + 1
                        hojaExcel.Range(Chr(numColumnaFinal) & "11").Value = Resources.ConsultaViviendas.lblViviendaIC
                    End If
                    numColumnaFinal = numColumnaFinal + 1
                    hojaExcel.Range(Chr(numColumnaFinal) & "11").Value = Resources.ConsultaViviendas.lblCambioDireccion
                    hojaExcel.Range(Chr(numColumnaFinal) & "11").Font.Bold = True
                    hojaExcel.Range(Chr(numColumnaFinal) & "11").Borders.LineStyle = Excel.XlLineStyle.xlDouble
                    numColumnaFinal = numColumnaFinal + 1
                    hojaExcel.Range(Chr(numColumnaFinal) & "11").Value = Resources.ConsultaViviendas.lblTipoVivienda
                    hojaExcel.Range(Chr(numColumnaFinal) & "11").Font.Bold = True
                    hojaExcel.Range(Chr(numColumnaFinal) & "11").Borders.LineStyle = Excel.XlLineStyle.xlDouble
                Else
                    If _sesion.IC.TieneIC Then
                        numColumnaFinal = numColumnaFinal + 1
                        hojaExcel.Range(Chr(numColumnaFinal) & "11").Value = Resources.ConsultaViviendas.lblViviendaIC
                    End If
                End If

                hojaExcel.Range("A11:" & Chr(numColumnaInicial) & "11").Font.Bold = True
                hojaExcel.Range("A11:" & Chr(numColumnaInicial) & "11").Borders.LineStyle = Excel.XlLineStyle.xlDouble

                If _sesion.IC.TieneIC Then
                    hojaExcel.Range(C_EXCEL_COL_DATOS_IC & "11").Font.Bold = True
                    hojaExcel.Range(C_EXCEL_COL_DATOS_IC & "11").Borders.LineStyle = Excel.XlLineStyle.xlDouble
                End If

                Dim dtResultados As DataSet = _sesion.ConsultaVivInfo.CargarExcel()
                Dim numcAnt As String = String.Empty
                Dim aencAnt As String = String.Empty
                Dim filaExcel As Integer = 12
                For Each row As DataRow In dtResultados.Tables(0).Rows
                    Dim numColumnaResult As Integer = 65
                    Dim aencAct As String = row.Item(0).ToString()
                    Dim numcAct As String = row.Item(1).ToString()
                    If (numcAct <> numcAnt) Then
                        numcAnt = numcAct
                        aencAnt = aencAct
                        'Año
                        'hojaExcel.Range("A" & filaExcel).Value = row.Item(0).ToString()
                        'Numc
                        hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = "'" & row.Item(1).ToString()
                        numColumnaResult = numColumnaResult + 1
                        If (mostrarTrim) Then
                            hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = row.Item(Eustat.GEDW.V35.Ng.Globales.ALIAS_CONSULTAVIV_TRIM).ToString()
                            numColumnaResult = numColumnaResult + 1 
                        End If
                        If (mostrarSem) Then
                            hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = row.Item(Eustat.GEDW.V35.Ng.Globales.ALIAS_CONSULTAVIV_SEM).ToString()
                            numColumnaResult = numColumnaResult + 1 
                        End If
                        'Territorio
                        hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = row.Item(2).ToString()
                        numColumnaResult = numColumnaResult + 1
                        'Municipio
                        hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = row.Item(3).ToString()
                        numColumnaResult = numColumnaResult + 1
                        'Entidad
                        hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = row.Item(22).ToString()
                        numColumnaResult = numColumnaResult + 1
                        'Situación
                        hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = row.Item(4).ToString()
                        numColumnaResult = numColumnaResult + 1
                        'Resultado Contacto
                        hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = row.Item(6).ToString()
                        numColumnaResult = numColumnaResult + 1
                        'Resultado Viv
                        hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = row.Item(5).ToString()
                        numColumnaResult = numColumnaResult + 1
                        'Resultado C. Familiar
                        Dim resfam As String = String.Empty
                        Dim dtRowSelect As DataRow() = dtResultados.Tables(0).Select(ConMuestra.IdentColumnNumc & " = '" & numcAct & "' and " & ConMuestra.IdentColumnAenc & " = " & aencAct & " and " & ConMuestra.IdentColumnRFam & " is not null")
                        If (dtRowSelect.Length > 0) Then
                            resfam = dtRowSelect(0)(11).ToString()
                        End If
                        hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = resfam
                        numColumnaResult = numColumnaResult + 1
                        hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = row.Item(17).ToString()
                        numColumnaResult = numColumnaResult + 1
                        hojaExcel.Range(Chr(numColumnaResult) & filaExcel).Value = row.Item(19).ToString()
                        numColumnaResult = numColumnaResult + 1

                        If _sesion.IC.TieneIC AndAlso _sesion.IC.EsIC(row.Item(Eustat.GEDW.V35.Ng.Globales.ALIAS_CONSULTAVIV_IC).ToString) Then
                            hojaExcel.Range(C_EXCEL_COL_DATOS_IC & filaExcel).Value = row.Item(Eustat.GEDW.V35.Ng.Globales.ALIAS_CONSULTAVIV_IC).ToString()
                            hojaExcel.Range("A" & filaExcel & ":" & Chr(numColumnaFinal) & filaExcel).Font.Color = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Red)
                        End If
                        If _sesion.EncuestaSeleccionadaInfo.CambioDireccion Then
                            hojaExcel.Range(Chr(numColumnaFinal - 1) & filaExcel).Value = row.Item(Eustat.GEDW.V35.Ng.Globales.COL_CONSULTAVIV_CAMBIODIR).ToString()
                            hojaExcel.Range(Chr(numColumnaFinal) & filaExcel).Value = row.Item(Eustat.GEDW.V35.Ng.Globales.COL_CONSULTAVIV_TVIV).ToString()
                        End If
                        Dim indper As String = String.Empty
                        Dim infper As String = String.Empty
                        Dim formper As String = String.Empty
                        Dim dtRowSelect2 As DataRow() = dtResultados.Tables(0).Select(ConMuestra.IdentColumnNumc & " = '" & numcAct & "' and " & ConMuestra.IdentColumnAenc & " = " & aencAct & " and " & ConMuestra.IdentColumnRPer & " is not null")
                        If (dtRowSelect2.Length = 0) Then
                            filaExcel = filaExcel + 1
                        Else
                            For Each dtMyRow As DataRow In dtRowSelect2
                                Dim numColumnaResultIndividuales As Integer = 75
                                If (mostrarTrim) Then
                                    numColumnaResultIndividuales = numColumnaResultIndividuales + 1
                                End If
                                If (mostrarSem) Then
                                    numColumnaResultIndividuales = numColumnaResultIndividuales + 1
                                End If
                                indper = dtMyRow.Item(13).ToString()
                                infper = dtMyRow.Item(12).ToString()
                                formper = dtMyRow.Item(18).ToString()

                                'Resultado C. Individual
                                hojaExcel.Range(Chr(numColumnaResultIndividuales) & filaExcel).Value = indper
                                numColumnaResultIndividuales = numColumnaResultIndividuales + 1
                                'Resultado Informante individual
                                hojaExcel.Range(Chr(numColumnaResultIndividuales) & filaExcel).Value = infper
                                numColumnaResultIndividuales = numColumnaResultIndividuales + 1
                                hojaExcel.Range(Chr(numColumnaResultIndividuales) & filaExcel).Value = formper
                                numColumnaResultIndividuales = numColumnaResultIndividuales + 1
                                hojaExcel.Range(Chr(numColumnaResultIndividuales) & filaExcel).Value = row.Item(20).ToString()
                                numColumnaResultIndividuales = numColumnaResultIndividuales + 1
                                If _sesion.IC.TieneIC AndAlso _sesion.IC.EsIC(row.Item(Eustat.GEDW.V35.Ng.Globales.ALIAS_CONSULTAVIV_IC).ToString) Then
                                    hojaExcel.Range("A" & filaExcel & ":" & Chr(numColumnaFinal) & filaExcel).Font.Color = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Red)
                                End If
                                filaExcel = filaExcel + 1
                            Next
                        End If
                    End If
                Next

                'Guardar el fichero
                Guardar(ExcelApplication, libroexcel, hojas)
                End If

        Catch ex As Exception
            err = ex.Message
        Finally
            ' Devolver el idioma que tenía antes de generar el Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI

            If (Not String.IsNullOrEmpty(err)) Then
                lblErrorAviso.Text = "<b>" & "No se han podido exportar los datos ya que ha ocurrido un error: </b>" & err
                lblErrorAviso.Visible = True
            End If
        End Try
    End Sub

    Private Sub Guardar(ByVal ExcelApplication As Excel.Application, ByVal libroexcel As Excel.Workbook, ByVal hojas() As Excel.Worksheet)
        Try
            'Dim id_excel As Int32 = ExcelApplication.Hinstance
            'Dim id_excel As Int32 = ExcelApplication.Hwnd
            'Dim id_excel As Int64 = ExcelApplication.HinstancePtr
            Dim i As Integer = 0

            Dim ruta As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATHSALIDA") + "Muestra" + _sesion.Agente.Trim + ".xls"
            Dim f As IO.FileInfo = New IO.FileInfo(ruta)
            If f.Exists Then
                f.Delete()
            End If

            libroexcel.SaveAs(ruta)

            If Not libroexcel Is Nothing Then
                For i = 0 To hojas.Length - 1
                    Finalizar(hojas(i))
                Next
                libroexcel.Close(False)
                Finalizar(libroexcel)
                ExcelApplication.Quit()
                Finalizar(ExcelApplication)
            End If

            System.GC.Collect()

            'matarProcesoExcel(id_excel)

            Dim fileStream As System.IO.FileStream = Nothing

            Try
                fileStream = New System.IO.FileStream(ruta, System.IO.FileMode.Open, System.IO.FileAccess.Read)
                ReDim bytesFicheroExcel(fileStream.Length - 1)
                fileStream.Read(bytesFicheroExcel, 0, fileStream.Length)
                _sesion.bytesFicheroExcel = bytesFicheroExcel
                _sesion.mostrarExcel = True
            Finally
                If Not fileStream Is Nothing Then
                    fileStream.Close()
                End If
            End Try

            'EliminarArchivos(ruta)
        Catch ex As Exception
            If ExcelApplication IsNot Nothing Then
                Dim id_excel As Int64 = ExcelApplication.HinstancePtr
                matarProcesoExcel(id_excel)
            End If
            Throw ex
        End Try
    End Sub

    Private Sub matarProcesoExcel(ByVal id_excel As Int64)
        'MATAMOS EL PROCESO EXCEL ASP.NET
        Try
            Dim Procesos() As System.Diagnostics.Process = Process.GetProcessesByName("EXCEL")
            For Each pProccess As System.Diagnostics.Process In Procesos
                Dim baseAdd As Int64 = pProccess.MainModule.BaseAddress.ToInt64
                If (baseAdd = id_excel) Then
                    pProccess.Kill()
                End If
            Next
        Catch ex As Exception
            Throw ex
        End Try
    End Sub

    Private Sub Finalizar(ByRef Referencias As Object)
        Try
            'Bucle de eliminacion
            Do Until _
                 System.Runtime.InteropServices.Marshal.ReleaseComObject(Referencias) <= 0
            Loop
        Catch ex As Exception
            Referencias = Nothing
            Throw ex
        End Try
        Referencias = Nothing
    End Sub




#End Region





End Class
