﻿<%@ Page Language="VB" AutoEventWireup="false" CodeFile="Accesibilidad.aspx.vb" Inherits="WebUserControls_CabeceraContents_Accesibilidad" meta:resourcekey="PageResource1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Accesibilidad</title>
</head>
<body>
    <form id="form1" runat="server">
        <div id="info">
            <p class="eustataccesibilidad"><asp:Literal ID="Literal1" runat="server" 
                    meta:resourcekey="Literal1Resource1" 
                    Text="La Administración Pública debe garantizar el derecho de todos los ciudadanos a la accesibilidad, tanto en el mundo físico como en el virtual, con independencia de que puedan padecer problemas físicos, sensoriales o cognitivos."></asp:Literal></p>

            <p class="eustataccesibilidad"><asp:Literal ID="Literal2" runat="server" 
                    meta:resourcekey="Literal2Resource1" 
                    Text="Por lo que se refiere al mundo virtual, hay que tener en cuenta, además, que los usuarios con discapacidad son uno de los públicos más interesados en utilizar servicios online, ya que pueden tener problemas de movilidad que les dificulte desplazarse para realizar trámites en las oficinas administrativas."></asp:Literal></p>

            <p class="eustataccesibilidad"><asp:Literal ID="Literal3" runat="server" 
                    meta:resourcekey="Literal3Resource1" 
                    Text="La Unión Europea, en la &lt;a href=&quot;http://www.juntadeandalucia.es/economiayhacienda/accesibilidad/Resolucion250302.pdf&quot; tabindex=&quot;-1&quot; target=&quot;_blank&quot;&gt;resolución del Consejo de 25 de marzo de 2002&lt;/a&gt;, anima a los Estados miembros a tener en cuenta la necesidad de que los contenidos digitales sean accesibles y, siguiendo esta recomendación, la &lt;a href=&quot;http://www.boe.es/boe/dias/2002/07/12/pdfs/A25388-25403.pdf&quot; tabindex=&quot;-1&quot; target=&quot;_blank&quot;&gt;Ley 34/2002, de 11 de julio, de servicios de la sociedad de la información y de comercio electrónico&lt;/a&gt;, dispone que las Administraciones públicas adoptarán las medidas necesarias para que la información disponible en sus respectivas páginas de Internet pueda ser accesible a personas con discapacidad y de edad avanzada, de acuerdo con los criterios de accesibilidad al contenido generalmente reconocidos, antes del 31 de diciembre de 2005."></asp:Literal></p>

            <p class="eustataccesibilidad"><asp:Literal ID="Literal4" runat="server" 
                    meta:resourcekey="Literal4Resource1" 
                    Text="En coherencia con este objetivo, el Gobierno Vasco ha establecido que todos los sitios web o portales dependientes de &quot;euskadi.net&quot;, tendrán que cumplir, al menos, con el primer nivel de prioridad de las directrices &lt;a href=&quot;http://www.w3.org/WAI/&quot; tabindex=&quot;-1&quot; target=&quot;_blank&quot;&gt;WAI (Web Accessibility Initiative)&lt;/a&gt; del consorcio W3C (World Wide Web Consortium)."></asp:Literal></p>

            <p class="eustataccesibilidad"><asp:Literal ID="Literal5" runat="server" 
                    meta:resourcekey="Literal5Resource1" 
                    Text="Siguiendo esta directriz, el diseño de esta nueva web euskadi.net se ha realizado teniendo en cuenta las pautas de accesibilidad de la mencionada iniciativa WAI."></asp:Literal></p>

            <p class="eustataccesibilidad"><asp:Literal ID="Literal6" runat="server" 
                    meta:resourcekey="Literal6Resource1" 
                    Text="Para ello, las páginas se han programado y maquetado utilizando los lenguajes de codificación XHTML y CSS2, mediante los cuales se mejora la usabilidad de las mismas, tanto para los visitantes no discapacitados, como para los discapacitados. Así mismo, usando estos lenguajes se consigue una navegación más clara y consistente, con independencia del tipo de dispositivo que se utilice para la visualización de las páginas."></asp:Literal></p>

            <p class="eustataccesibilidad"><asp:Literal ID="Literal7" runat="server" 
                    meta:resourcekey="Literal7Resource1" 
                    Text="Entre las principales medidas adoptadas para mejorar la accesibilidad, se encuentran las siguientes:"></asp:Literal></p>

            <ul class="eustataccesibilidadlista">
                <li><asp:Literal ID="Literal8" runat="server" meta:resourcekey="Literal8Resource1" 
                        Text="&lt;strong&gt;Imágenes&lt;/strong&gt;. Se han incluido versiones alternativas en modo texto."></asp:Literal></li>
                <li><asp:Literal ID="Literal9" runat="server" meta:resourcekey="Literal9Resource1" 
                        Text="&lt;strong&gt;Tamaño del texto&lt;/strong&gt;. Las fuentes utilizadas tienen dimensiones relativas, de forma que el usuario puede controlar su tamaño desde el navegador que esté utilizando."></asp:Literal></li>
                <li><asp:Literal ID="Literal10" runat="server" 
                        meta:resourcekey="Literal10Resource1" 
                        Text="&lt;strong&gt;Diseño, navegación e interactividad&lt;/strong&gt;. Se ha tratado de conseguir una navegación coherente en todo el sitio web, siguiendo los mismos esquemas estructurales en todas las páginas. Además se han incluido enlaces directos para acceder al contenido de las páginas y se ha evitado el uso de Javascript para interactuar con el sitio. Así mismo se ha separado la información de su presentación gráfica de manera que los usuarios que lo deseen puedan navegar por los contenidos a mayor velocidad, deshabilitando la descarga de hojas de estilos en su navegador."></asp:Literal></li>
            </ul>
           
            <p class="eustataccesibilidad"><asp:Literal ID="Literal11" runat="server" 
                    meta:resourcekey="Literal11Resource1" 
                    Text="Ahora bien, buena parte de los contenidos preexistentes en la versión anterior de euskadi.net incumplían algunas de las pautas de accesibilidad. Parte de ellos ya han sido corregidos en la fase de migración al nuevo euskadi.net. La adecuación de los restantes contenidos para que, finalmente, todos ellos sean accesibles, se realizará de forma progresiva durante los próximos meses, siguiendo una dinámica de mejora continua de la accesibilidad a la información y servicios ofrecidos en euskadi.net."></asp:Literal></p>

            <p class="eustataccesibilidad"><a href="http://www.w3.org/WAI/WCAG1A-Conformance" tabindex="-1" target="_blank"><img alt="<%=GetLocalResourceObject("ImageAlt") %>" src="<%=ConfigurationManager.AppSettings("Images") & "wai_a.gif" %>"/></a></p>
        </div>
    </form>
</body>
</html>
