Imports Eustat.Comun.V35.Ng

Partial Class WebUserControls_Cabecera
    Inherits System.Web.UI.UserControl

#Region "SESION"
    Private _sesion As New AppSession
#End Region

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        '***ESTILO CABECERA***'
        Dim css As HtmlLink = New HtmlLink()
        css = New HtmlLink()
        css.Href = ConfigurationManager.AppSettings("Style") & "cabecera/eustat_cabecera.css"
        css.Attributes.Add("rel", "stylesheet")
        css.Attributes.Add("type", "text/css")
        Page.Header.Controls.Add(css)
        css.Dispose()

        '*** CARGAR OPCIONES CABECERA ***'
        If Not Page.IsPostBack Then
            Dim cab As New Cabecera()
            BulletedListOpcionesCabecera.DataSource = cab.GetCabecera()
            BulletedListOpcionesCabecera.DataTextField = cab.ColumnaNombre
            BulletedListOpcionesCabecera.DataValueField = cab.ColumnaUrl
            BulletedListOpcionesCabecera.DataBind()
        End If
        BulletedListOpcionesCabecera.Items(0).Attributes.Add("class", "resaltado")
        ScriptManager.RegisterStartupScript(Me, Me.GetType(), "modaldialogcabecera", "$(function() {$('#BulletedListOpcionesCabeceraContent').EWCHeaderOptionsContent();});" & Chr(13), True)

        '*** IDENTIFICACCIN ***'
        If Not Page.IsPostBack Then
            If Not String.IsNullOrEmpty(_sesion.UsuarioActual) Then 'Usuario Registrado
                LiteralAgenteUsuario.Visible = True
                LiteralAgenteUsuario.Text = _sesion.UsuarioActual
            Else
                If Not String.IsNullOrEmpty(_sesion.Agente) Then    'Agente
                    LiteralAgenteUsuario.Visible = True
                    LiteralAgenteUsuario.Text &= _sesion.Agente
                End If
            End If

        End If

        '***INICIALIZAR VALORES ESTATICOS
        ImageLogoEustat.ImageUrl = ConfigurationManager.AppSettings("Images") & "logo_eustat.gif"
        ImageLogoEuskadi.ImageUrl = ConfigurationManager.AppSettings("Images") & "logo_euskadinet.gif"

        '*** CONTROL DE IDIOMA ***'
        Idioma()
    End Sub

    Protected Sub Page_PreRender(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.PreRender
        Dim ind As Integer = 0

        For Each item As ListItem In BulletedListOpcionesCabecera.Items
            If ind > 0 Then
                ScriptManager.RegisterStartupScript(Me, Me.GetType(), "opendialogcabecera" & ind, "$(function() { $('#" & BulletedListOpcionesCabecera.ClientID & "').EWCHeaderOptions({ ind: " & ind & ", txtbtn: '" & GetLocalResourceObject("BulletedListOpcionesCabeceraDialogCerrar") & "', updateImg: '" & ConfigurationManager.AppSettings("Images") & "ajax_updating.gif', title: '" & BulletedListOpcionesCabecera.Items(ind).Text & "', url: '" & Me.TemplateSourceDirectory & "/" & BulletedListOpcionesCabecera.Items(ind).Value & "', content: 'BulletedListOpcionesCabeceraContent'}); });" & Chr(13), True)
            End If
            ind += 1
        Next
        _sesion.IdiomaChange = False
    End Sub

    Protected Overrides Sub Render(ByVal writer As System.Web.UI.HtmlTextWriter)
        MyBase.Render(writer)
    End Sub

    ''' <summary>
    ''' Evento de cambio de idioma.
    ''' </summary>
    ''' <param name="sender">Control de formulario que alza el evento.</param>
    ''' <param name="e">Argumentos del evento.</param>
    ''' <remarks></remarks>
    Protected Sub LinkButtonIdioma_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles LinkButtonEuskera.Click, LinkButtonCastellano.Click
        Dim senderLink As LinkButton = CType(sender, LinkButton)

        _sesion.IdiomaChange = True
        _sesion.Idioma = senderLink.CommandArgument
        ' Establecer idioma en el cambio del mismo
        EstablecerIdioma(_sesion.Idioma)
        Server.Transfer(Request.Path)
    End Sub

    ''' <summary>
    ''' Evento de opciones de cabecera.
    ''' </summary>
    ''' <param name="sender">Opciones de cabecera.</param>
    ''' <param name="e">argumentos del evento.
    ''' - Index: indice de la opcion que ha sido accionada. 
    ''' </param>
    ''' <remarks></remarks>
    Protected Sub BulletedListOpcionesCabecera_Click(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.BulletedListEventArgs) Handles BulletedListOpcionesCabecera.Click
        If e.Index = 0 Then
            ModGeneral.CerrarSesion(Me)
        End If
    End Sub

    ''' <summary>
    ''' Cambiar estilos del control de idioma dependiendo del idioma activo.
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub Idioma()
        If System.Threading.Thread.CurrentThread.CurrentCulture.Name = ConfigurationManager.AppSettings("Castellano") Then
            LinkButtonCastellano.Enabled = False
            LinkButtonCastellano.CssClass = "idioma_activo"
            LinkButtonEuskera.Enabled = True
            LinkButtonEuskera.CssClass = "idioma"
        Else
            LinkButtonCastellano.Enabled = True
            LinkButtonCastellano.CssClass = "idioma"
            LinkButtonEuskera.Enabled = False
            LinkButtonEuskera.CssClass = "idioma_activo"
        End If
    End Sub
End Class
