﻿Imports System.IO
Imports System.Data
Imports System.Xml
Imports System.Xml.Schema


Imports Microsoft.Office.Interop
Imports Microsoft.Office.Interop.Excel
Imports Microsoft.Office.Interop.Excel.Constants
Imports System.Diagnostics

Partial Class Validacion
    Inherits System.Web.UI.Page
    Dim bytesFicheroExcelVal() As Byte

    Private _maxLimitUpload As Integer = 4096
    Private _strMsgXmlValidation As String
    Private _sesion As AppSession

    Private _mostrarResultadosCodificadas As Boolean
    Private _mostrarResultadosFinalizadasParcial As Boolean

    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If (_sesion Is Nothing) Then
            _sesion = New AppSession
        End If
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim sm As ScriptManager = ScriptManager.GetCurrent(Me.Page)
        If Not IsPostBack() Then
            CargarDatos()
        End If
        LiteralNombreEncuesta.Text = String.Format(LiteralNombreEncuesta.Text, _sesion.Operacion)
        Dim imgProgreso As Image = CType(UpdateProg1.FindControl("imgProcesando"), Image)
        imgProgreso.ImageUrl = ConfigurationManager.AppSettings("Images") & "ajax_updating.gif"
    End Sub

    Private Sub EstablecerOpcionesVisualizacionResultados()
        Select Case _sesion.Operacion

            Case "operacion que use resultados de codificadas"
                _mostrarResultadosCodificadas = True
                _mostrarResultadosFinalizadasParcial = True
            Case Else
                _mostrarResultadosCodificadas = False
                _mostrarResultadosFinalizadasParcial = False
        End Select

    End Sub
    Private Sub CargarDatos()
        'Anio 
        Dim AniosLN As Anios = New Anios(_sesion.Operacion)
        Dim dt As DataSet = AniosLN.GetDsAnio()

        DropDownListAnio.DataSource = dt
        DropDownListAnio.DataTextField = AniosLN.ColumnaDescripcion()
        DropDownListAnio.DataValueField = AniosLN.ColumnaId
        DropDownListAnio.DataBind()
        'Trimestre
        Dim TrimLN As Trimestre = New Trimestre(_sesion.Operacion)
        Dim dtTrim As DataSet = TrimLN.GetDsTrim()
        If (Not IsNothing(dtTrim)) Then
            If (dtTrim.Tables(0).Rows.Count > 0) Then

                DropDownListTrim.DataSource = dtTrim
                DropDownListTrim.DataTextField = TrimLN.ColumnaDescripcion()
                DropDownListTrim.DataValueField = TrimLN.ColumnaId
                DropDownListTrim.DataBind()

                'Seleccionar el mayor trimestre para ese año que tenga datos en la tabla de muestra 
                Dim mayorTrimeste As Integer = TrimLN.ObtenerMayorTrimestre(DropDownListAnio.SelectedValue)
                DropDownListTrim.SelectedValue = mayorTrimeste
            Else
                lblTrim.Visible = False
                DropDownListTrim.Visible = False
            End If
        Else
            lblTrim.Visible = False
            DropDownListTrim.Visible = False
        End If
        'Semana
        Dim SemLN As Semana = New Semana(_sesion.Operacion)
        Dim dtSem As DataSet = SemLN.GetDsSem()
        If (Not IsNothing(dtSem)) Then
            If (dtSem.Tables(0).Rows.Count > 0) Then
                Dim dtRowSem As DataRow
                dtRowSem = dtSem.Tables(0).NewRow()
                dtRowSem(SemLN.ColumnaId) = DBNull.Value
                dtRowSem(SemLN.ColumnaDescripcion()) = Resources.ConsultaViviendas.LabelElija
                dtSem.Tables(0).Rows.InsertAt(dtRowSem, 0)
                DropDownListSem.DataSource = dtSem
                DropDownListSem.DataTextField = SemLN.ColumnaDescripcion()
                DropDownListSem.DataValueField = SemLN.ColumnaId
                DropDownListSem.DataBind()
            Else
                lblSem.Visible = False
                DropDownListSem.Visible = False
            End If
        Else
            lblSem.Visible = False
            DropDownListSem.Visible = False
        End If
        'Provincia y Municipio
        DropDownListTH.DataValueField = _sesion.ProvinciasInfo.ColumnaId
        DropDownListTH.DataTextField = _sesion.ProvinciasInfo.ColumnaNombre
        DropDownListTH.DataSource = _sesion.ProvinciasInfo.GetProvinciasCAV()
        DropDownListTH.DataBind()

        imgExcel.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
    End Sub


    Private Function ComprobarNumcs() As Boolean
        If txtNumcDesde.Text = "" And txtNumcHasta.Text <> "" Then
            Return False
        Else : Return True
        End If
    End Function

    Protected Sub ObjectDataSource1_ObjectCreating(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceEventArgs) Handles ObjectDataSourceVal.ObjectCreating
        If (IsNothing(_sesion.ValidacionGeneralInfo)) Then
            _sesion.ValidacionGeneralInfo = ObtenerValidacionGeneralInfo()
        End If
        e.ObjectInstance = _sesion.ValidacionGeneralInfo
    End Sub

    Protected Sub Validar()
        Try
            pnlResultados.Visible = False
            txtNumcDesde.Text = txtNumcDesde.Text.Trim
            txtNumcHasta.Text = txtNumcHasta.Text.Trim
            Page.Validate()
            If Page.IsValid And ComprobarNumcs() Then
                'Iniciar proceso de validacion

                Dim LG As ValidacionGeneral = ObtenerValidacionGeneralInfo()
                _sesion.ValidacionGeneralInfo = LG
                LG.ObjDtvivienda = Nothing
                LG.ObjResultadoPantalla = Nothing
                LG.ObjResultErrores = Nothing
                If LG.ProcesoValidaciones() Then
                    Dim espacios As String = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"

                    LG.MsjInfo = GetLocalResourceObject("lblProcFinalizado") & "<br/><br/>"

                    EstablecerOpcionesVisualizacionResultados()
                    'Numero viviendas sin errores
                    LG.MsjInfo &= GetLocalResourceObject("lblViviendasSinErrores").Replace("@", LG.numVivPendCodif + LG.numVivFinalizadas) & "<br/>"
                    'Viviendas pendiente codif, finalizadas
                    If _mostrarResultadosCodificadas Then
                        LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivPendCodif").Replace("@", LG.numVivPendCodif) & "<br/>"
                    End If
                    LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivFinalizada").Replace("@", LG.numVivFinalizadas) & "<br/>"
                    If _mostrarResultadosFinalizadasParcial Then
                        LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivFinalizadaParcial").Replace("@", LG.numVivFinalizadasParciales) & "<br/><br/>"
                    End If
                    ''Numero viviendas con errores
                    LG.MsjInfo &= GetLocalResourceObject("lblViviendasConErrores").Replace("@", LG.numVivNoValidas) & "<br/>"
                    'Viviendas con errores duros, blandos y duros/blandos
                    LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivErrDuros").Replace("@", LG.numVivDuros) & "<br/>"
                    LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivErrBlandos").Replace("@", LG.numVivBlandos) & "<br/>"
                    LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivErrDurosBlandos").Replace("@", LG.numVivBlandosDuros) & "<br/>"

                    If LG.MsjError <> String.Empty Then
                        mostrarErrores(String.Concat(LG.MsjInfo, "<br/><br/> <p style='color:red'>", GetLocalResourceObject("lblMensajeErrorCab"), LG.MsjError.Remove(LG.MsjError.Length - 1, 1), "</p>"), True)
                    Else
                        mostrarErrores(LG.MsjInfo, True)
                    End If

                    ''Mostrar tabla con las viviendas correctas
                    MostrarResultados()
                Else
                    mostrarErrores(GetLocalResourceObject("lblNoExistenDatos"), False)
                End If
            Else
                Dim resul As Integer
                If Not ComprobarNumcs() And System.Int32.TryParse(txtNumcHasta.Text, resul) Then
                    mostrarErrores(GetLocalResourceObject("lblErrorNumcDesde"), False)
                End If
            End If
        Catch ex As Exception
            '_sesion.ValidacionGeneralInfo.numVivNoValidas = 0
            mostrarErrores(ex.Message, True)
        End Try
    End Sub



    Protected Sub btnDescarga_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDescarga.Click
        Validar()
    End Sub

    Private Sub mostrarErrores(ByVal p1 As String, ByVal p2 As Boolean)
        lblTexto.Text = p1
        lblTextoBtn.Text = GetLocalResourceObject("lblMostrarErrores")
        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "Popup", "ShowPopup();", p2)
    End Sub

    Private Sub MostrarResultados()
        lkExcel.Visible = False
        imgExcel.Visible = False
        btnAceptarErroresBlandos.Visible = False
        'gvResultados.DataSource = _sesion.ValidacionGeneralInfo.ObjResultadoPantalla
        gvResultados.DataBind()
        pnlResultados.Visible = True

        'si hay algún numc que sólo tenga errores blandos, muestro el boton de aceptar errores blandos
        If (_sesion.ValidacionGeneralInfo.SoloErrorBlando) Then
            btnAceptarErroresBlandos.Visible = True
        End If
        If (Not IsNothing(_sesion.ValidacionGeneralInfo.ObjResultErrores)) Then
            If (_sesion.ValidacionGeneralInfo.ObjResultErrores.Rows.Count > 0) Then
                lkExcel.Visible = True
                imgExcel.Visible = True
            End If
        End If
    End Sub

    Protected Function MostrarImagenError(ByVal o As Object) As Boolean
        Dim result As Boolean = False
        If (o.ToString().Equals(Globales.ERROR_DURO) Or o.ToString().Equals(Globales.ERROR_BLANDO)) Then
            result = True
        End If
        Return result
    End Function

    Protected Function ImagenError(ByVal o As Object) As String
        Dim result As String = "c_blando.png"
        If (o.ToString().Equals(Globales.ERROR_DURO)) Then
            result = ConfigurationManager.AppSettings("Images") & "c_duro.png"
        ElseIf (o.ToString().Equals(Globales.ERROR_BLANDO)) Then
            result = ConfigurationManager.AppSettings("Images") & "c_blando.png"
        End If
        Return result
    End Function

    Public Sub GenerarExcel()
        ' Guardar el idioma actual
        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        Try
            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If

            Dim ExcelApplication As New Excel.Application
            Dim libroexcel As Excel.Workbook
            Dim hojaExcel As New Excel.Worksheet
            Dim hojaExcel2 As New Excel.Worksheet
            Dim hojaExcel3 As New Excel.Worksheet

            Dim fecha() As String = Now.Date.ToString.Split(" ")

            Dim filename As String = GetLocalResourceObject("lblValidacionEnc").ToLower & fecha(0).Replace("/", "-") & _
                                     "_" & extension

            Dim bytes() As Byte = Nothing

            ExcelApplication = New Excel.Application
            Dim plantilla As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATH") + System.Configuration.ConfigurationManager.AppSettings.Get("NOM_PLANTILLA_EXCEL_HORIZ")

            ' Cambiar el idioma a castellano, para que no casque la generación del Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")

            ExcelApplication.Workbooks.Add(plantilla)

            libroexcel = ExcelApplication.Workbooks(1)
            libroexcel.Activate()

            hojaExcel = libroexcel.ActiveSheet


            hojaExcel.Name = GetLocalResourceObject("lblErrores").ToString.ToUpper
            libroexcel.Sheets("Hoja2").visible = False
            libroexcel.Sheets("Hoja3").visible = False

            hojaExcel.Visible = True

            hojaExcel.Activate()

            '/////////////////////////////////////////////////////////////////////////////////////////////////////////
            'HOJA1
            '***CABECERA***'
            hojaExcel.Range("G2").Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
            hojaExcel.Range("G2").Borders(XlBordersIndex.xlEdgeRight).Weight = 4
            hojaExcel.Range("G2").Borders(XlBordersIndex.xlEdgeRight).ColorIndex = 49



            hojaExcel.Range("H2").Borders(XlBordersIndex.xlEdgeTop).LineStyle = Excel.XlLineStyle.xlLineStyleNone
            hojaExcel.Range("H2").Borders(XlBordersIndex.xlEdgeBottom).LineStyle = Excel.XlLineStyle.xlLineStyleNone
            hojaExcel.Range("H2").Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlLineStyleNone

            hojaExcel.Range("A1").ColumnWidth = 7.5
            hojaExcel.Range("B1").ColumnWidth = 6.15
            hojaExcel.Range("C1").ColumnWidth = 6.15
            hojaExcel.Range("D1").ColumnWidth = 50
            hojaExcel.Range("E1").ColumnWidth = 40
            hojaExcel.Range("F1").ColumnWidth = 21
            hojaExcel.Range("G1").ColumnWidth = 21

            hojaExcel.Range("C2:G2").Merge()
            hojaExcel.Range("C2").Value = GetLocalResourceObject("lblInfValidaciones")
            hojaExcel.Range("C2").IndentLevel = 10
            hojaExcel.Range("C2").VerticalAlignment = Excel.XlHAlign.xlHAlignCenter
            hojaExcel.Range("C2").HorizontalAlignment = Excel.XlHAlign.xlHAlignCenter
            hojaExcel.Range("C2").Font.Bold = True

            hojaExcel.Range("A3:G3").Merge()
            hojaExcel.Range("A3").HorizontalAlignment = Excel.XlHAlign.xlHAlignRight
            hojaExcel.Range("A3").Value = GetLocalResourceObject("lblFechaDoc") & " " & Now.Date & " " & Now.Hour & ":" & Now.Minute
            
            Const espacios As String = "        "
            Dim desTerr As String = DropDownListTH.SelectedItem.Text
            hojaExcel.Range("A5:G5").Merge()

            If DropDownListTrim.Visible Then

                hojaExcel.Range("A5").Value = GetLocalResourceObject("lblAnioResource1.Text") & " " & DropDownListAnio.SelectedItem.Text & espacios & _
                                            GetLocalResourceObject("lblTrimResource1.Text") & " " & DropDownListTrim.SelectedItem.Text & espacios
            Else
                hojaExcel.Range("A5").Value = GetLocalResourceObject("lblAnioResource1.Text") & " " & DropDownListAnio.SelectedItem.Text
            End If


            If DropDownListSem.SelectedIndex <> "-1" Then
                hojaExcel.Range("A5").Value &= GetLocalResourceObject("lblSemana") & ": " & DropDownListSem.SelectedItem.Text & espacios
            End If

            If desTerr <> String.Empty Then
                hojaExcel.Range("A5").Value &= GetLocalResourceObject("lblTerr") & ": " & desTerr & espacios
            End If

            If txtNumcDesde.Text <> String.Empty Then
                hojaExcel.Range("A5").Value &= Resources.ConsultaViviendas.lblNumcResource1 & " " & txtNumcDesde.Text & espacios & Resources.ConsultaViviendas.lblNumcHastaResource1 & " " & txtNumcHasta.Text & espacios
            End If

            hojaExcel.Range("A5:G5").HorizontalAlignment = Excel.XlHAlign.xlHAlignLeft
            hojaExcel.Range("A5:G5").Font.Bold = True
            hojaExcel.Range("A5:G5").Borders(XlBordersIndex.xlEdgeTop).LineStyle = Excel.XlLineStyle.xlContinuous
            hojaExcel.Range("A5:G5").Borders(XlBordersIndex.xlEdgeBottom).LineStyle = Excel.XlLineStyle.xlContinuous

            hojaExcel.Range("A7").Value = "Numc"
            hojaExcel.Range("A7").Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
            hojaExcel.Range("B7").Value = "Nind"
            hojaExcel.Range("B7").Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
            hojaExcel.Range("C7").Value = GetLocalResourceObject("lblTipo")
            hojaExcel.Range("C7").Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
            hojaExcel.Range("D7").Value = GetLocalResourceObject("lblDesError")
            hojaExcel.Range("D7").Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
            hojaExcel.Range("E7").Value = GetLocalResourceObject("lblCondError")
            hojaExcel.Range("E7").Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
            hojaExcel.Range("F7").Value = GetLocalResourceObject("lblValores")
            hojaExcel.Range("F7").Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
            hojaExcel.Range("G7").Value = GetLocalResourceObject("lblAgente")
            hojaExcel.Range("G7").Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous

            hojaExcel.Range("A7:G7").HorizontalAlignment = Excel.XlHAlign.xlHAlignCenter
            hojaExcel.Range("A7:G7").Font.Bold = True
            hojaExcel.Range("A7:G7").Borders(XlBordersIndex.xlEdgeLeft).LineStyle = Excel.XlLineStyle.xlContinuous
            hojaExcel.Range("A7:G7").Borders(XlBordersIndex.xlEdgeTop).LineStyle = Excel.XlLineStyle.xlContinuous
            hojaExcel.Range("A7:G7").Borders(XlBordersIndex.xlEdgeBottom).LineStyle = Excel.XlLineStyle.xlContinuous


            '***********Datos Errores****************

            Dim filaExcel As Integer = 8
            Dim dt As Data.DataTable = _sesion.ValidacionGeneralInfo.ObjResultErrores

            ' lo reordenamos 
            Dim dtView As DataView = New DataView(dt)
            dtView.Sort = "NUMC asc,NIND asc,TIPO asc"


            dt = dtView.ToTable()
            dt.AcceptChanges()


            Dim fila As DataRow
            If dt.Rows.Count <> 0 Then


                Dim esFila1 As Boolean = True
                Dim err As String = dt.Rows(0).Item("VALOR")

                Dim tipoError As String = dt.Rows(0).Item("TIPO")


                For Each fila In dt.Rows

                    hojaExcel.Range("A" & filaExcel.ToString).Value = fila.Item("NUMC")
                    hojaExcel.Range("A" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("A" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeBottom).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("A" & filaExcel.ToString).HorizontalAlignment = Excel.XlHAlign.xlHAlignCenter
                    hojaExcel.Range("A" & filaExcel.ToString).VerticalAlignment = Excel.XlHAlign.xlHAlignCenter

                    hojaExcel.Range("B" & filaExcel.ToString).Value = fila.Item("NIND")
                    hojaExcel.Range("B" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("B" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeBottom).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("B" & filaExcel.ToString).HorizontalAlignment = Excel.XlHAlign.xlHAlignCenter
                    hojaExcel.Range("B" & filaExcel.ToString).VerticalAlignment = Excel.XlHAlign.xlHAlignCenter

                    If fila.Item("TIPO").ToString = "1" Then
                        hojaExcel.Range("C" & filaExcel.ToString).Value = GetLocalResourceObject("lblDuro")
                    Else
                        hojaExcel.Range("C" & filaExcel.ToString).Value = GetLocalResourceObject("lblBlando")
                    End If
                    hojaExcel.Range("C" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("C" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeBottom).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("C" & filaExcel.ToString).HorizontalAlignment = Excel.XlHAlign.xlHAlignCenter
                    hojaExcel.Range("C" & filaExcel.ToString).VerticalAlignment = Excel.XlHAlign.xlHAlignCenter

                    If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                        hojaExcel.Range("D" & filaExcel.ToString).Value = fila.Item("CODIGO") & ". " & fila.Item("DESC_CAS")
                    Else : hojaExcel.Range("D" & filaExcel.ToString).Value = fila.Item("CODIGO") & ". " & fila.Item("DESC_EUS")
                    End If
                    hojaExcel.Range("D" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("D" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeBottom).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("D" & filaExcel.ToString).VerticalAlignment = Excel.XlHAlign.xlHAlignCenter
                    hojaExcel.Range("D" & filaExcel.ToString).HorizontalAlignment = Excel.XlHAlign.xlHAlignLeft
                    hojaExcel.Range("D" & filaExcel.ToString).WrapText = True

                    hojaExcel.Range("E" & filaExcel.ToString).Value = fila.Item("VALOR")
                    hojaExcel.Range("E" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("E" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeBottom).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("E" & filaExcel.ToString).VerticalAlignment = Excel.XlHAlign.xlHAlignCenter
                    hojaExcel.Range("E" & filaExcel.ToString).HorizontalAlignment = Excel.XlHAlign.xlHAlignLeft
                    hojaExcel.Range("E" & filaExcel.ToString).WrapText = True

                    hojaExcel.Range("F" & filaExcel.ToString).Value = fila.Item("VALORES")
                    hojaExcel.Range("F" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("F" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeBottom).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("F" & filaExcel.ToString).VerticalAlignment = Excel.XlHAlign.xlHAlignCenter
                    hojaExcel.Range("F" & filaExcel.ToString).HorizontalAlignment = Excel.XlHAlign.xlHAlignLeft
                    hojaExcel.Range("F" & filaExcel.ToString).WrapText = True

                    hojaExcel.Range("G" & filaExcel.ToString).Value = fila.Item("AGENTE")
                    hojaExcel.Range("G" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeRight).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("G" & filaExcel.ToString).Borders(XlBordersIndex.xlEdgeBottom).LineStyle = Excel.XlLineStyle.xlContinuous
                    hojaExcel.Range("G" & filaExcel.ToString).VerticalAlignment = Excel.XlHAlign.xlHAlignCenter
                    hojaExcel.Range("G" & filaExcel.ToString).HorizontalAlignment = Excel.XlHAlign.xlHAlignCenter
                    hojaExcel.Range("G" & filaExcel.ToString).WrapText = True
                    filaExcel += 1

                Next
                hojaExcel.Range("A8:" & "G" & filaExcel.ToString).Font.Size = 11
                hojaExcel.Range("A8:" & "A" & (filaExcel - 1).ToString).Borders(XlBordersIndex.xlEdgeLeft).LineStyle = Excel.XlLineStyle.xlContinuous
            Else
                hojaExcel.Range("A" & filaExcel.ToString & ":G" & filaExcel.ToString).Merge()
                hojaExcel.Range("A" & filaExcel.ToString).Value = GetLocalResourceObject("lblNoErrores")
                filaExcel += 1
            End If


            hojaExcel.Activate()

            Dim hojas(libroexcel.Sheets.Count - 1) As Excel.Worksheet
            Dim i As Integer = 0
            For i = 0 To libroexcel.Sheets.Count - 1
                hojas(i) = libroexcel.Sheets.Item(i + 1)
            Next

            'SesionPagValidacionEnc.nombreFicheroPlantillaExcel = filename
            'SesionPagValidacionEnc.bytesFicheroPlantillaExcel = bytes

            'Guardar el fichero
            Guardar(ExcelApplication, libroexcel, hojas)

        Catch ex As Exception
            Throw ex
        Finally
            ' Devolver el idioma que tenía antes de generar el Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI
        End Try

    End Sub

    Private Sub Guardar(ByVal ExcelApplication As Excel.Application, ByVal libroexcel As Excel.Workbook, ByVal hojas() As Excel.Worksheet)
        Try
            'Dim id_excel As Int32 = ExcelApplication.Hinstance
            'Dim id_excel As Int32 = ExcelApplication.Hwnd
            'Dim id_excel As Int64 = ExcelApplication.HinstancePtr
            Dim i As Integer = 0

            Dim ruta As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATHSALIDA") + "Validaciones" + System.DateTime.Today.ToString("ddMMyyyy") + _sesion.Agente.Trim + ".xls"
            Dim f As IO.FileInfo = New IO.FileInfo(ruta)
            If f.Exists Then
                f.Delete()
            End If

            libroexcel.SaveAs(ruta)

            If Not libroexcel Is Nothing Then
                For i = 0 To hojas.Length - 1
                    Finalizar(hojas(i))
                Next
                libroexcel.Close(False)
                Finalizar(libroexcel)
                ExcelApplication.Quit()
                Finalizar(ExcelApplication)
            End If

            System.GC.Collect()

            'matarProcesoExcel(id_excel)

            Dim fileStream As System.IO.FileStream = Nothing

            Try
                fileStream = New System.IO.FileStream(ruta, System.IO.FileMode.Open, System.IO.FileAccess.Read)
                ReDim bytesFicheroExcelVal(fileStream.Length - 1)
                fileStream.Read(bytesFicheroExcelVal, 0, fileStream.Length)
                _sesion.bytesFicheroExcelVal = bytesFicheroExcelVal
                _sesion.mostrarExcel = True
            Finally
                If Not fileStream Is Nothing Then
                    fileStream.Close()
                End If
            End Try

            'EliminarArchivos(ruta)
        Catch ex As Exception
            If ExcelApplication IsNot Nothing Then
                Dim id_excel As Int64 = ExcelApplication.HinstancePtr
                matarProcesoExcel(id_excel)
            End If
            Throw ex
        End Try
    End Sub

    Private Sub matarProcesoExcel(ByVal id_excel As Int64)
        'MATAMOS EL PROCESO EXCEL ASP.NET
        Try
            Dim Procesos() As System.Diagnostics.Process = Process.GetProcessesByName("EXCEL")
            For Each pProccess As System.Diagnostics.Process In Procesos
                Dim baseAdd As Int64 = pProccess.MainModule.BaseAddress.ToInt64
                If (baseAdd = id_excel) Then
                    pProccess.Kill()
                End If
            Next
        Catch ex As Exception
            Throw ex
        End Try
    End Sub

    Private Sub Finalizar(ByRef Referencias As Object)
        Try
            'Bucle de eliminacion
            Do Until _
                 System.Runtime.InteropServices.Marshal.ReleaseComObject(Referencias) <= 0
            Loop
        Catch ex As Exception
            Referencias = Nothing
            Throw ex
        End Try
        Referencias = Nothing
    End Sub
    Protected Function ObtenerValidacionGeneralInfo() As ValidacionGeneral
        'Si una oeracion debe modificar las tablas sobre las que se hace la validacion puede crear una clase que hereda de ValidacionGeneral y realizar el override en los metodos correspondientes
         Return New ValidacionGeneral(_sesion.Operacion, txtNumcDesde.Text, DropDownListAnio.SelectedValue, DropDownListTrim.SelectedValue, DropDownListSem.SelectedValue, _sesion.Idioma, txtNumcHasta.Text, DropDownListTH.SelectedValue)
    End Function
   

    Protected Sub lkExcel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lkExcel.Click
        lblErrorAviso.Visible = False
        Dim stError As String = String.Empty
        Try
            ''Generar Excel
            GenerarExcel()
        Catch ex As Exception
            stError = ex.Message
        Finally
            If (Not String.IsNullOrEmpty(stError)) Then
                lblErrorAviso.Text = "<b>" & "No se han podido exportar los datos ya que ha ocurrido un error: </b>" & stError
                lblErrorAviso.Visible = True
            Else
                lblErrorAviso.Visible = False
            End If
        End Try
    End Sub

    Protected Sub btnAceptarErroresBlandos_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAceptarErroresBlandos.Click
        _sesion.ValidacionGeneralInfo.AceptarErroresBlandos()
        Dim espacios As String = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
        Dim LG As ValidacionGeneral = _sesion.ValidacionGeneralInfo
        LG.MsjInfo = GetLocalResourceObject("lblProcFinalizado") & "<br/><br/>"

        ''Numero viviendas sin errores
        LG.MsjInfo &= GetLocalResourceObject("lblViviendasSinErrores").Replace("@", LG.numVivPendCodif + LG.numVivFinalizadas) & "<br/>"
        'Viviendas pendiente codif, finalizadas

        LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivPendCodif").Replace("@", LG.numVivPendCodif) & "<br/>"
        LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivFinalizada").Replace("@", LG.numVivFinalizadas) & "<br/>"
        LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivFinalizadaParcial").Replace("@", LG.numVivFinalizadasParciales) & "<br/><br/>"
        ''Numero viviendas con errores
        LG.MsjInfo &= GetLocalResourceObject("lblViviendasConErrores").Replace("@", LG.numVivNoValidas) & "<br/>"
        'Viviendas con errores duros, blandos y duros/blandos
        LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivErrDuros").Replace("@", LG.numVivDuros) & "<br/>"
        LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivErrBlandos").Replace("@", LG.numVivBlandos) & "<br/>"
        LG.MsjInfo &= espacios & espacios & GetLocalResourceObject("lblVivErrDurosBlandos").Replace("@", LG.numVivBlandosDuros) & "<br/>"

        If LG.MsjError <> String.Empty Then
            mostrarErrores(String.Concat(LG.MsjInfo, "<br/><br/> <p style='color:red'>", GetLocalResourceObject("lblMensajeErrorCab"), LG.MsjError.Remove(LG.MsjError.Length - 1, 1), "</p>"), True)
        Else
            mostrarErrores(LG.MsjInfo, True)
        End If

        ''Mostrar tabla con las viviendas correctas
        lkExcel.Visible = False
        imgExcel.Visible = False
        btnAceptarErroresBlandos.Visible = False
        'gvResultados.DataSource = _sesion.ValidacionGeneralInfo.ObjResultadoPantalla
        gvResultados.DataBind()
        pnlResultados.Visible = True

        'si hay algún numc que sólo tenga errores blandos, muestro el boton de aceptar errores blandos
        If (_sesion.ValidacionGeneralInfo.numVivBlandos > 0) Then
            btnAceptarErroresBlandos.Visible = True
        End If
        If (Not IsNothing(_sesion.ValidacionGeneralInfo.ObjResultErrores)) Then
            If (_sesion.ValidacionGeneralInfo.ObjResultErrores.Rows.Count > 0) Then
                lkExcel.Visible = True
                imgExcel.Visible = True
            End If
        End If
    End Sub

    'Evento para visualizar la encuesta concreta
    Protected Sub ClickLupa(ByVal sender As Object, ByVal e As EventArgs)

        Dim img As ImageButton = CType(sender, ImageButton)
        Dim tableC As DataControlFieldCell = CType(img.Parent, DataControlFieldCell)
        Dim gridR As GridViewRow = CType(tableC.Parent, GridViewRow)


        Dim numc As String = CType(gridR.Cells(0).Controls(0), DataBoundLiteralControl).Text.ToString().Trim()
        Dim nind As String = CType(gridR.Cells(1).Controls(0), DataBoundLiteralControl).Text.ToString().Trim()



        'no establecido valor de querystring por seguridad. Contactar con Eustat
        Dim querystring As String = ""
        

        Dim strRuta As String = "winenc = window.open('" + ObtenerURLAcceso(_sesion.Operacion, querystring, _sesion.Idioma) + "','Encuesta');"

        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "newWindow", "javascrip:" & strRuta & ";", True)

        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "modWindow", "javascript:ShowPopupRefrescar();", True)

    End Sub

    'Evento para visualizar la encuesta concreta
    Protected Sub ClickLupa2(ByVal sender As Object, ByVal e As EventArgs)

        Dim img As ImageButton = CType(sender, ImageButton)
        Dim tableC As DataControlFieldCell = CType(img.Parent, DataControlFieldCell)
        Dim gridR As GridViewRow = CType(tableC.Parent, GridViewRow)


        Dim numc As String = CType(gridR.Cells(0).Controls(0), DataBoundLiteralControl).Text.ToString().Trim()
        Dim nind As String = CType(gridR.Cells(1).Controls(0), DataBoundLiteralControl).Text.ToString().Trim()

        Dim informante As String = _sesion.ValidacionGeneralInfo.ObtenerInfIndividual(numc, _sesion.ValidacionGeneralInfo.Anio, _sesion.ValidacionGeneralInfo.Trim, nind)


        'no establecido valor de querystring por seguridad. Contactar con Eustat
        Dim querystring As String = ""
        

        Dim strRuta As String = "winenc = window.open('" + ObtenerURLAcceso(_sesion.Operacion, querystring, _sesion.Idioma) + "','Encuesta');"

        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "newWindow", "javascrip:" & strRuta & ";", True)

        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "modWindow", "javascript:ShowPopupRefrescar();", True)

    End Sub

    Public Sub btnDescarga2_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDescarga2.Click
        Validar()
    End Sub


    Protected Sub btnExcel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnExcel.Click
        If (_sesion.mostrarExcel) Then
            _sesion.mostrarExcel = False
            'Mostrar excel
            Response.Clear()
            Response.ClearHeaders()
            Response.ClearContent()
            'Response.ContentType = "binary/octet-stream"
            'Response.Charset = ""
            Response.ContentType = "application/octet-stream"
            Response.Cache.SetCacheability(HttpCacheability.Private)
            Response.ContentEncoding = System.Text.Encoding.UTF8
            Response.AddHeader("Content-Disposition", "attachment; filename=" + "Validaciones" + System.DateTime.Today.ToString("ddMMyyyy") + _sesion.Agente.Trim + ".xls")
            Response.BinaryWrite(_sesion.bytesFicheroExcelVal)
            _sesion.bytesFicheroExcelVal = Nothing
            Response.Flush()
            Response.End()
        End If
    End Sub

    Protected Sub gvResultados_RowCreated(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvResultados.RowCreated
        If (e.Row.RowType = DataControlRowType.DataRow) Then
            Dim img As System.Web.UI.WebControls.ImageButton = CType(e.Row.FindControl("imgCFam"), System.Web.UI.WebControls.ImageButton)
            Dim img2 As System.Web.UI.WebControls.ImageButton = CType(e.Row.FindControl("imgCInd"), System.Web.UI.WebControls.ImageButton)

            ScriptManager.GetCurrent(Page).RegisterPostBackControl(img)
            ScriptManager.GetCurrent(Page).RegisterPostBackControl(img2)
        End If
    End Sub
End Class
