﻿Imports Eustat.GEDW.V35.Ng
Imports System.Data

Partial Class _PreEncuesta
    Inherits System.Web.UI.Page

    Private _sesion As AppSession

    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If (_sesion Is Nothing) Then
            _sesion = New AppSession
        End If
    End Sub


    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        
        If Not IsPostBack() Then
            AutenticarUsuario()
        End If
    End Sub


    Private Sub AutenticarUsuario()

        Dim ControlUsuariosLN As ControlUsuarios = New ControlUsuarios()
        Dim dsCtrUsuarios As DataSet = ControlUsuariosLN.GetControlUsuarios(_sesion.Agente)
        If (String.IsNullOrEmpty(ControlUsuariosLN.CodigoUsu)) Then
           ModGeneral.CerrarSesion(Me)
        Else
            Dim OperacionesUsuariosLN As OperacionesUsuario = New OperacionesUsuario()
            OperacionesUsuariosLN.GetOperacionesUsuario(ControlUsuariosLN.CodigoUsu)
            _sesion.OperacionesUsuarioInfo = OperacionesUsuariosLN
            Dim dsOpeUsuarios As DataSet = OperacionesUsuariosLN.GetDsOperacionesUsuario
            If (OperacionesUsuariosLN.MultipleOperacion) Then
                cmbSeleccione.DataSource = dsOpeUsuarios
                cmbSeleccione.DataTextField = OperacionesUsuariosLN.ColumnaDescripcion(_sesion.Idioma)
                cmbSeleccione.DataValueField = OperacionesUsuariosLN.ColumnaId
                cmbSeleccione.DataBind()
                _sesion.MultiOperacion = True
            Else
                _sesion.MultiOperacion = False
                _sesion.ValidacionGeneralInfo = Nothing
                _sesion.Operacion = OperacionesUsuariosLN.Operacion
                _sesion.EncuestaSeleccionadaInfo = New Eustat.GEDW.V35.Ng.Encuesta.Encuesta(_sesion.Operacion)
                _sesion.IC = New IC(_sesion.Operacion)
                _sesion.TurnoInfo = New Turno(_sesion.Operacion)
                Response.Redirect("~/ConsultaViviendas.aspx")
            End If
        End If
    End Sub

    
    Protected Sub lkOperacion_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lkOperacion.Click
        If (Page.IsValid) Then
            _sesion.Operacion = cmbSeleccione.SelectedValue
            _sesion.EncuestaSeleccionadaInfo = New Eustat.GEDW.V35.Ng.Encuesta.Encuesta(_sesion.Operacion)
            _sesion.ValidacionGeneralInfo = Nothing
            _sesion.IC = New IC(_sesion.Operacion)
            _sesion.TurnoInfo = New Turno(_sesion.Operacion)
            Response.Redirect("~/ConsultaViviendas.aspx")
        End If
    End Sub
End Class
