﻿Imports System.Data
Imports System.Diagnostics
Imports Microsoft.Office.Interop
Imports Microsoft.Office.Interop.Excel
Imports Microsoft.Office.Interop.Excel.Constants

Partial Class Listados
    Inherits System.Web.UI.Page

    Private _sesion As AppSession
    Dim bytesFicheroExcel() As Byte
    Dim nombreFicheroPlantillaExcel As String
    Dim id_excel As Int64


    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If (_sesion Is Nothing) Then
            _sesion = New AppSession
        End If
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim sm As ScriptManager = ScriptManager.GetCurrent(Me.Page)
        If Not IsPostBack() Then
            CargarDatos()
        End If
        LiteralNombreEncuesta.Text = String.Format(LiteralNombreEncuesta.Text, _sesion.Operacion)
        'Imagenes
        img1.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
        img2.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
        img3.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
        img4.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
        img5.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
        img6.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
        img7.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
        img8.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
        img9.ImageUrl = ConfigurationManager.AppSettings("Images") & "excel.ico"
        Dim imgProgreso As Image = CType(UpdateProg1.FindControl("imgProcesando"), Image)
        imgProgreso.ImageUrl = ConfigurationManager.AppSettings("Images") & "ajax_updating.gif"

        'Buscar por operación que excels deben visualizarse
        Dim e_Listados As Eustat.GEDW.V35.Ng.Listados = New Eustat.GEDW.V35.Ng.Listados(_sesion.Operacion)
        _sesion.Listados = e_Listados
        Dim dtVisualizar As System.Data.DataTable = _sesion.Listados.CargarExcelVisualizar()

        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")
        System.Threading.Thread.CurrentThread.CurrentUICulture = New System.Globalization.CultureInfo("es-ES")

        If dtVisualizar IsNot Nothing AndAlso dtVisualizar.Rows.Count > 0 Then
            If dtVisualizar.Select(Globales.COL_CONSULTAEXCEL_NOMEXC & "= '" & GetLocalResourceObject("lblListado1").ToString() & "'").Length = 0 Then
                divListado1.Visible = False
            End If
            If dtVisualizar.Select(Globales.COL_CONSULTAEXCEL_NOMEXC & "= '" & GetLocalResourceObject("lblListado2").ToString() & "'").Length = 0 Then
                divListado2.Visible = False
            End If
            If dtVisualizar.Select(Globales.COL_CONSULTAEXCEL_NOMEXC & "= '" & GetLocalResourceObject("lblListado3").ToString() & "'").Length = 0 Then
                divListado3.Visible = False
            End If
            If dtVisualizar.Select(Globales.COL_CONSULTAEXCEL_NOMEXC & "= '" & GetLocalResourceObject("lblListado4").ToString() & "'").Length = 0 Then
                divListado4.Visible = False
            End If
            If dtVisualizar.Select(Globales.COL_CONSULTAEXCEL_NOMEXC & "= '" & GetLocalResourceObject("lblListado5").ToString() & "'").Length = 0 Then
                divListado5.Visible = False
            End If
            If dtVisualizar.Select(Globales.COL_CONSULTAEXCEL_NOMEXC & "= '" & GetLocalResourceObject("lblListado6").ToString() & "'").Length = 0 Then
                divListado6.Visible = False
            End If
            If dtVisualizar.Select(Globales.COL_CONSULTAEXCEL_NOMEXC & "= '" & GetLocalResourceObject("lblListado7").ToString() & "'").Length = 0 Then
                divListado7.Visible = False
            End If
            If dtVisualizar.Select(Globales.COL_CONSULTAEXCEL_NOMEXC & "= '" & GetLocalResourceObject("lblListado8").ToString() & "'").Length = 0 Then
                divListado8.Visible = False
            End If
            If dtVisualizar.Select(Globales.COL_CONSULTAEXCEL_NOMEXC & "= '" & GetLocalResourceObject("lblListado9").ToString() & "'").Length = 0 Then
                divListado9.Visible = False
            End If
        Else
            divListado1.Visible = False
            divListado2.Visible = False
            divListado3.Visible = False
            divListado4.Visible = False
            divListado5.Visible = False
            divListado6.Visible = False
            divListado7.Visible = False
            divListado8.Visible = False
            divListado9.Visible = False
        End If

        System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI
        System.Threading.Thread.CurrentThread.CurrentUICulture = CurrentCI
    End Sub

    Private Sub CargarDatos()
        'Anio 
        Dim AniosLN As Anios = New Anios(_sesion.Operacion)
        Dim dt As DataSet = AniosLN.GetDsAnio()

        DropDownListAnio.DataSource = dt
        DropDownListAnio.DataTextField = AniosLN.ColumnaDescripcion()
        DropDownListAnio.DataValueField = AniosLN.ColumnaId
        DropDownListAnio.DataBind()
        'Trimestre
        Dim TrimLN As Trimestre = New Trimestre(_sesion.Operacion)
        Dim dtTrim As DataSet = TrimLN.GetDsTrim()
        If (Not IsNothing(dtTrim)) Then
            If (dtTrim.Tables(0).Rows.Count > 0) Then

                DropDownListTrim.DataSource = dtTrim
                DropDownListTrim.DataTextField = TrimLN.ColumnaDescripcion()
                DropDownListTrim.DataValueField = TrimLN.ColumnaId
                DropDownListTrim.DataBind()

                'Seleccionar el mayor trimestre para ese año que tenga datos en la tabla de muestra 
                Dim mayorTrimeste As Integer = TrimLN.ObtenerMayorTrimestre(DropDownListAnio.SelectedValue)
                DropDownListTrim.SelectedValue = mayorTrimeste

            Else
                lblTrim.Visible = False
                DropDownListTrim.Visible = False
            End If
        Else
            lblTrim.Visible = False
            DropDownListTrim.Visible = False
        End If
    End Sub

#Region "Eventos de imagen excel"
    Protected Sub img1_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles img1.Click
        lblErrorAviso.Visible = False
        Dim stError As String = String.Empty


        Try
            If (DropDownListAnio.SelectedValue <> String.Empty And ((Not DropDownListTrim.Visible) Or DropDownListTrim.SelectedValue <> String.Empty)) Then
                'Generar Excel
                GenerarT1()
            End If
        Catch ex As Exception
            stError = ex.Message
        Finally
            If (Not String.IsNullOrEmpty(stError)) Then
                lblErrorAviso.Text = "<b>" & "No se ha podido generar el listado ya que ha ocurrido un error: </b>" & stError
                lblErrorAviso.Visible = True
            Else
                lblErrorAviso.Visible = False
            End If
        End Try
    End Sub

    Protected Sub img2_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles img2.Click
        lblErrorAviso.Visible = False
        Dim stError As String = String.Empty
        Try
            If (DropDownListAnio.SelectedValue <> String.Empty And ((Not DropDownListTrim.Visible) Or DropDownListTrim.SelectedValue <> String.Empty)) Then
                'Generar Excel
                GenerarT2()
            End If
        Catch ex As Exception
            stError = ex.Message
        Finally
            If (Not String.IsNullOrEmpty(stError)) Then
                lblErrorAviso.Text = "<b>" & "No se ha podido generar el listado ya que ha ocurrido un error: </b>" & stError
                lblErrorAviso.Visible = True
            Else
                lblErrorAviso.Visible = False
            End If
        End Try
    End Sub

    Protected Sub img3_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles img3.Click
        lblErrorAviso.Visible = False
        Dim stError As String = String.Empty
        Try
            If (DropDownListAnio.SelectedValue <> String.Empty And ((Not DropDownListTrim.Visible) Or DropDownListTrim.SelectedValue <> String.Empty)) Then
                'Generar Excel
                GenerarT3()
            End If
        Catch ex As Exception
            stError = ex.Message
        Finally
            If (Not String.IsNullOrEmpty(stError)) Then
                lblErrorAviso.Text = "<b>" & "No se ha podido generar el listado ya que ha ocurrido un error: </b>" & stError
                lblErrorAviso.Visible = True
            Else
                lblErrorAviso.Visible = False
            End If
        End Try
    End Sub

    Protected Sub img4_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles img4.Click
        lblErrorAviso.Visible = False
        Dim stError As String = String.Empty
        Try
            If (DropDownListAnio.SelectedValue <> String.Empty And ((Not DropDownListTrim.Visible) Or DropDownListTrim.SelectedValue <> String.Empty)) Then
                'Generar Excel
                GenerarT4()
            End If
        Catch ex As Exception
            stError = ex.Message
        Finally
            If (Not String.IsNullOrEmpty(stError)) Then
                lblErrorAviso.Text = "<b>" & "No se ha podido generar el listado ya que ha ocurrido un error: </b>" & stError
                lblErrorAviso.Visible = True
            Else
                lblErrorAviso.Visible = False
            End If
        End Try
    End Sub

    Protected Sub img5_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles img5.Click
        lblErrorAviso.Visible = False
        Dim stError As String = String.Empty
        Try
            If (DropDownListAnio.SelectedValue <> String.Empty) Then
                'Generar Excel
                GenerarT1Lote()
            End If
        Catch ex As Exception
            stError = ex.Message
        Finally
            If (Not String.IsNullOrEmpty(stError)) Then
                lblErrorAviso.Text = "<b>" & "No se ha podido generar el listado ya que ha ocurrido un error: </b>" & stError
                lblErrorAviso.Visible = True
            Else
                lblErrorAviso.Visible = False
            End If
        End Try
    End Sub

    Protected Sub img6_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles img6.Click
        lblErrorAviso.Visible = False
        Dim stError As String = String.Empty
        Try
            If cvMetodoIdioma.IsValid And cvEncuestadoAgente.IsValid And cvEncuestaVivienda.IsValid Then
                If (DropDownListAnio.SelectedValue <> String.Empty) Then
                    'Generar Excel
                    GenerarT6()
                End If
            End If
        Catch ex As Exception
            stError = ex.Message
        Finally
            If (Not String.IsNullOrEmpty(stError)) Then
                lblErrorAviso.Text = "<b>" & "No se ha podido generar el listado ya que ha ocurrido un error: </b>" & stError
                lblErrorAviso.Visible = True
            Else
                lblErrorAviso.Visible = False
            End If
        End Try
    End Sub


    Protected Sub img7_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles img7.Click
        lblErrorAviso.Visible = False
        Dim stError As String = String.Empty
        Try
            If (DropDownListAnio.SelectedValue <> String.Empty) Then
                'Generar Excel
                GenerarT7()
            End If
        Catch ex As Exception
            stError = ex.Message
        Finally
            If (Not String.IsNullOrEmpty(stError)) Then
                lblErrorAviso.Text = "<b>" & "No se ha podido generar el listado ya que ha ocurrido un error: </b>" & stError
                lblErrorAviso.Visible = True
            Else
                lblErrorAviso.Visible = False
            End If
        End Try
    End Sub


    Protected Sub img8_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles img8.Click
        lblErrorAviso.Visible = False
        Dim stError As String = String.Empty
        Try
            If (DropDownListAnio.SelectedValue <> String.Empty) Then
                'Generar Excel
                GenerarT8()
            End If
        Catch ex As Exception
            stError = ex.Message
        Finally
            If (Not String.IsNullOrEmpty(stError)) Then
                lblErrorAviso.Text = "<b>" & "No se ha podido generar el listado ya que ha ocurrido un error: </b>" & stError
                lblErrorAviso.Visible = True
            Else
                lblErrorAviso.Visible = False
            End If
        End Try
    End Sub

    Protected Sub img9_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles img9.Click
        lblErrorAviso.Visible = False
        Dim stError As String = String.Empty
        Try
            If (DropDownListAnio.SelectedValue <> String.Empty) Then
                'Generar Excel
                GenerarT9()
            End If
        Catch ex As Exception
            stError = ex.Message
        Finally
            If (Not String.IsNullOrEmpty(stError)) Then
                lblErrorAviso.Text = "<b>" & "No se ha podido generar el listado ya que ha ocurrido un error: </b>" & stError
                lblErrorAviso.Visible = True
            Else
                lblErrorAviso.Visible = False
            End If
        End Try
    End Sub
#End Region



#Region "Funciones generales que usan varios Excel"
    Private Sub DibujarSemanas(ByVal hojaExcel As Excel.Worksheet)
        hojaExcel.Range("B4").Value = GetLocalResourceObject("lblSenc") & " " & 1
        hojaExcel.Range("C4").Value = GetLocalResourceObject("lblSenc") & " " & 2
        hojaExcel.Range("D4").Value = GetLocalResourceObject("lblSenc") & " " & 3
        hojaExcel.Range("E4").Value = GetLocalResourceObject("lblSenc") & " " & 4
        hojaExcel.Range("F4").Value = GetLocalResourceObject("lblSenc") & " " & 5
        hojaExcel.Range("G4").Value = GetLocalResourceObject("lblSenc") & " " & 6
        hojaExcel.Range("H4").Value = GetLocalResourceObject("lblSenc") & " " & 7
        hojaExcel.Range("I4").Value = GetLocalResourceObject("lblSenc") & " " & 8
        hojaExcel.Range("J4").Value = GetLocalResourceObject("lblSenc") & " " & 9
        hojaExcel.Range("K4").Value = GetLocalResourceObject("lblSenc") & " " & 10
        hojaExcel.Range("L4").Value = GetLocalResourceObject("lblSenc") & " " & 11
        hojaExcel.Range("M4").Value = GetLocalResourceObject("lblSenc") & " " & 12
        hojaExcel.Range("N4").Value = GetLocalResourceObject("lblSenc") & " " & 13
        hojaExcel.Range("O4").Value = GetLocalResourceObject("lblTotal")
        hojaExcel.Range("B4:O4").ColumnWidth = 7
        hojaExcel.Range("B4").RowHeight = 16.5
        hojaExcel.Range("B4:O4").Font.Bold = True
        hojaExcel.Range("B4:O4").Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("B4:O4").Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("B4:O4").Borders(XlBordersIndex.xlInsideVertical).Weight = Excel.XlBorderWeight.xlMedium
    End Sub
#End Region


#Region "Funciones Excel"
    Public Sub GenerarT1()
        ' Guardar el idioma actual
        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        Try

            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If

            Dim ExcelApplication As New Excel.Application
            Dim libroexcel As Excel.Workbook
            Dim hojaExcel As New Excel.Worksheet
            Dim bytes() As Byte = Nothing
            'id_excel = ExcelApplication.Hinstance
            id_excel = ExcelApplication.HinstancePtr

            ExcelApplication = New Excel.Application
            Dim plantilla As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATH") + System.Configuration.ConfigurationManager.AppSettings.Get("NOM_PLANTILLA_EXCEL")

            ' Cambiar el idioma a castellano, para que no casque la generación del Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")

            ExcelApplication.Workbooks.Add(plantilla)

            Dim filename As String = GetLocalResourceObject("lblListado1").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension

            libroexcel = ExcelApplication.Workbooks(1)
            libroexcel.Activate()

            hojaExcel = libroexcel.ActiveSheet

            If (GetLocalResourceObject("lblListado1").ToString.Length > 30) Then
                hojaExcel.Name = GetLocalResourceObject("lblListado1").ToString.Substring(0, 30)
            Else
                hojaExcel.Name = GetLocalResourceObject("lblListado1").ToString
            End If


            libroexcel.Sheets("Hoja2").visible = False
            libroexcel.Sheets("Hoja3").visible = False

            hojaExcel.Cells.Font.Size = 11

            hojaExcel.Visible = True

            'EXCEL
            hojaExcel.Range("A2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("A2").Borders.Color = RGB(0, 0, 0)
            hojaExcel.Range("B2").Value = GetLocalResourceObject("lblTitulo1Resource1.Text").ToString().ToUpper() & Chr(10) & GetLocalResourceObject("lblAnioResource1.Text") & " " & _
                DropDownListAnio.SelectedValue & " " & GetLocalResourceObject("lblTrimResource1.Text") & " " & DropDownListTrim.SelectedValue
            hojaExcel.Range("B2").Font.Bold = True
            hojaExcel.Range("B2:O2").Merge()
            hojaExcel.Range("B2:O2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("B2:O2").Borders.Color = RGB(0, 0, 0)

            hojaExcel.Range("B3").Value = GetLocalResourceObject("lblSemanaEncuestacion")
            hojaExcel.Range("B3").Font.Bold = True
            hojaExcel.Range("B3").HorizontalAlignment = xlCenter
            hojaExcel.Range("B3").VerticalAlignment = xlCenter
            hojaExcel.Range("B3:O3").Merge()
            hojaExcel.Range("B3").RowHeight = 15.75
            hojaExcel.Range("B3:O3").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("A4").Value = GetLocalResourceObject("lblSituacion")
            hojaExcel.Range("A4").Font.Bold = True
            hojaExcel.Range("A4").Borders.Weight = Excel.XlBorderWeight.xlThick

            'Dibujar semanas
            DibujarSemanas(hojaExcel)

            Dim SituacionesLN As Situaciones = New Situaciones()
            Dim dtSituaciones As System.Data.DataTable = SituacionesLN.GetDsSituaciones.Tables(0)
            For f As Integer = 0 To dtSituaciones.Rows.Count - 1
                If (f < (dtSituaciones.Rows.Count)) Then
                    If dtSituaciones.Rows(f)(SituacionesLN.ColumnaId) Is DBNull.Value Then
                        dtSituaciones.Rows(f).Delete()
                        dtSituaciones.AcceptChanges()
                    End If
                End If
            Next

            Dim dtProvincias As System.Data.DataTable = _sesion.ProvinciasInfo.GetProvinciasCAV().ToTable()
            For f As Integer = 0 To dtProvincias.Rows.Count - 1
                If (f < (dtProvincias.Rows.Count)) Then
                    If dtProvincias.Rows(f)(Globales.ALIAS_PROV_NOMBRE) Is String.Empty Then
                        dtProvincias.Rows(f).Delete()
                        dtProvincias.AcceptChanges()
                    End If
                End If
            Next

            'Dibujar las Situaciones para cada territorio
            Dim celdaSeleccionada As Excel.Range = hojaExcel.Range("A5")
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlMedium
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.IndentLevel = 0
                celdaSeleccionada.Font.Color = RGB(0, 0, 0)
                celdaSeleccionada.Font.Color = RGB(0, 0, 0)
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Bold = True
                celdaSeleccionada.Value = dtProvincias.Rows(j)(Globales.ALIAS_PROV_NOMBRE).ToString().ToUpper()
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                For k As Integer = 0 To dtSituaciones.Rows.Count - 1
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.RowHeight = 15
                    celdaSeleccionada.IndentLevel = 2
                    celdaSeleccionada.Value = dtSituaciones.Rows(k)(SituacionesLN.ColumnaDescripcion(_sesion.Idioma)).ToString()
                    celdaSeleccionada.Font.Bold = False
                    celdaSeleccionada.Font.Italic = True
                    celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                    celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                Next
            Next
            'Total
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = GetLocalResourceObject("lblTotal").ToString().ToUpper()
            celdaSeleccionada.HorizontalAlignment = xlLeft
            celdaSeleccionada.VerticalAlignment = xlCenter
            celdaSeleccionada.IndentLevel = 0
            celdaSeleccionada.Font.Color = RGB(0, 0, 0)
            celdaSeleccionada.Font.Italic = True
            celdaSeleccionada.Font.Bold = True
            celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            For k As Integer = 0 To dtSituaciones.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.RowHeight = 15
                celdaSeleccionada.IndentLevel = 2
                celdaSeleccionada.Value = dtSituaciones.Rows(k)(SituacionesLN.ColumnaDescripcion(_sesion.Idioma)).ToString()
                celdaSeleccionada.Font.Bold = False
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            Next
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = GetLocalResourceObject("lblBase").ToString()
            celdaSeleccionada.HorizontalAlignment = xlLeft
            celdaSeleccionada.VerticalAlignment = xlCenter
            celdaSeleccionada.IndentLevel = 0
            celdaSeleccionada.Font.Color = RGB(0, 0, 0)
            celdaSeleccionada.Font.Italic = True
            celdaSeleccionada.Font.Bold = True

            Dim e_Listados As Eustat.GEDW.V35.Ng.Listados = New Eustat.GEDW.V35.Ng.Listados(_sesion.Operacion)
            _sesion.Listados = e_Listados

            _sesion.Listados.Anio = DropDownListAnio.SelectedValue
            _sesion.Listados.Trim = DropDownListTrim.SelectedValue

            Dim SemLN As Semana = New Semana(_sesion.Operacion)
            Dim dtSem As DataSet = SemLN.GetDsSem()
            Dim dt As System.Data.DataTable = _sesion.Listados.CargarDatosListado1(Not IsNothing(dtSem))

            'DATOS
            Dim semana As Integer
            Dim provincia As String
            Dim situacion As String

            'Por Territorio, sin situación
            celdaSeleccionada = hojaExcel.Range("B5")
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                provincia = dtProvincias.Rows(j)(Globales.ALIAS_PROV_ID).ToString()
                For semana = 1 To 13

                    celdaSeleccionada.HorizontalAlignment = xlRight
                    If dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                        celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                Next
                'total por territorio y situación sin semana
                If dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length > 0 Then
                    celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada = celdaSeleccionada.Offset(dtSituaciones.Rows.Count + 1, -13)
            Next

            'Por Territorio y situación y semana
            celdaSeleccionada = hojaExcel.Range("B6")
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                For k As Integer = 0 To dtSituaciones.Rows.Count - 1

                    provincia = dtProvincias.Rows(j)(Globales.ALIAS_PROV_ID).ToString()
                    situacion = dtSituaciones.Rows(k)(SituacionesLN.ColumnaId).ToString()

                    For semana = 1 To 13

                        celdaSeleccionada.HorizontalAlignment = xlRight
                        If dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                            celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                        celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                    Next
                    'total por territorio y situación sin semana
                    If dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length > 0 Then
                        celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada.HorizontalAlignment = xlRight
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada = celdaSeleccionada.Offset(1, -13)
                Next
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            Next


            'Total de situaciones sin territorio
            'Sin situación ni semana
            celdaSeleccionada = celdaSeleccionada.Offset(-1, 0)
            For semana = 1 To 13
                celdaSeleccionada.HorizontalAlignment = xlRight
                If dt.Select(Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                    celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
            Next
            'total
            celdaSeleccionada.Value = dt.Rows.Count
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada = celdaSeleccionada.Offset(1, -13)


            For k As Integer = 0 To dtSituaciones.Rows.Count - 1
                situacion = dtSituaciones.Rows(k)(SituacionesLN.ColumnaId).ToString()
                For semana = 1 To 13

                    celdaSeleccionada.HorizontalAlignment = xlRight
                    If dt.Select(Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                        celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    If k = dtSituaciones.Rows.Count - 1 Then
                        celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
                Next
                'Total sin semana, sin territorio
                If dt.Select(Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length > 0 Then
                    celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                If k = dtSituaciones.Rows.Count - 1 Then
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(1, -13)
            Next


            'Fecha
            hojaExcel.Range("A1").Value = GetLocalResourceObject("lblFechaDoc") & " " & FormatDateTime(Now, DateFormat.GeneralDate)
            hojaExcel.Range("A1").ColumnWidth = 41
            hojaExcel.Range("A1").VerticalAlignment = xlCenter
            hojaExcel.Range("A1").HorizontalAlignment = xlLeft
            hojaExcel.Range("A1").WrapText = False
            hojaExcel.Range("A1").ShrinkToFit = False

            hojaExcel.Activate()

            Dim hojas(libroexcel.Sheets.Count - 1) As Excel.Worksheet
            Dim i As Integer = 0
            For i = 0 To libroexcel.Sheets.Count - 1
                hojas(i) = libroexcel.Sheets.Item(i + 1)
            Next

            filename = GetLocalResourceObject("lblListado1").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension
            nombreFicheroPlantillaExcel = filename
            _sesion.NameListado = filename
            bytesFicheroExcel = bytes

            'Guardar el fichero
            Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado1") + "_" + DropDownListAnio.SelectedValue + "_" + DropDownListTrim.SelectedValue + "_" + extension + ".xls")

            'If nombreFicheroPlantillaExcel <> String.Empty Then
            '    'Sin espacios que sino no sale formato excel al abrir
            '    descargarFicheroPlantillaExcel(GetLocalResourceObject("lblListado1").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension & ".xls")
            'End If

        Catch ex As Exception
            Throw ex
        Finally
            ' Devolver el idioma que tenía antes de generar el Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI
        End Try

    End Sub



    Public Sub GenerarT2()
        ' Guardar el idioma actual
        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        Try

            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If

            Dim ExcelApplication As New Excel.Application
            Dim libroexcel As Excel.Workbook
            Dim hojaExcel As New Excel.Worksheet
            Dim bytes() As Byte = Nothing
            'id_excel = ExcelApplication.Hinstance
            id_excel = ExcelApplication.HinstancePtr

            ExcelApplication = New Excel.Application
            Dim plantilla As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATH") + System.Configuration.ConfigurationManager.AppSettings.Get("NOM_PLANTILLA_EXCEL")

            ' Cambiar el idioma a castellano, para que no casque la generación del Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")

            ExcelApplication.Workbooks.Add(plantilla)

            Dim filename As String = GetLocalResourceObject("lblListado2").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension

            libroexcel = ExcelApplication.Workbooks(1)
            libroexcel.Activate()

            hojaExcel = libroexcel.ActiveSheet

            If (GetLocalResourceObject("lblListado2").ToString.Length > 30) Then
                hojaExcel.Name = GetLocalResourceObject("lblListado2").ToString.Substring(0, 30)
            Else
                hojaExcel.Name = GetLocalResourceObject("lblListado2").ToString
            End If

            libroexcel.Sheets("Hoja2").visible = False
            libroexcel.Sheets("Hoja3").visible = False

            hojaExcel.Cells.Font.Size = 11

            hojaExcel.Visible = True

            'EXCEL
            hojaExcel.Range("A2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("A2").Borders.Color = RGB(0, 0, 0)
            hojaExcel.Range("B2").Value = GetLocalResourceObject("lblTitulo2Resource1.Text").ToString().ToUpper() & " " & GetLocalResourceObject("lblAnioResource1.Text") & " " & _
                DropDownListAnio.SelectedValue & " " & GetLocalResourceObject("lblTrimResource1.Text") & " " & DropDownListTrim.SelectedValue
            hojaExcel.Range("B2").Font.Bold = True
            hojaExcel.Range("B2:O2").Merge()
            hojaExcel.Range("B2:O2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("B2:O2").Borders.Color = RGB(0, 0, 0)

            hojaExcel.Range("B3").Value = GetLocalResourceObject("lblSemanaEncuestacion")
            hojaExcel.Range("B3").Font.Bold = True
            hojaExcel.Range("B3").HorizontalAlignment = xlCenter
            hojaExcel.Range("B3").VerticalAlignment = xlCenter
            hojaExcel.Range("B3:O3").Merge()
            hojaExcel.Range("B3").RowHeight = 15.75
            hojaExcel.Range("B3:O3").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("A4").Value = GetLocalResourceObject("lblResultadoPersonal")
            hojaExcel.Range("A4").Font.Bold = True
            hojaExcel.Range("A4").Borders.Weight = Excel.XlBorderWeight.xlThick

            'Dibujar semanas
            DibujarSemanas(hojaExcel)

            Dim e_Listados As Eustat.GEDW.V35.Ng.Listados = New Eustat.GEDW.V35.Ng.Listados(_sesion.Operacion)
            _sesion.Listados = e_Listados

            Dim dtIncidencias As System.Data.DataTable = _sesion.Listados.CargarIncidencias()

            _sesion.MetodoCump = New Eustat.GEDW.V35.Ng.MetodoCump()
            Dim dtFormaCumplimentacion As System.Data.DataTable = _sesion.MetodoCump.GetDsMetodo().Tables(0)
            For f As Integer = 0 To dtFormaCumplimentacion.Rows.Count - 1
                If (f < (dtFormaCumplimentacion.Rows.Count)) Then
                    If dtFormaCumplimentacion.Rows(f)(_sesion.MetodoCump.ColumnaId) Is DBNull.Value Then
                        dtFormaCumplimentacion.Rows(f).Delete()
                        dtFormaCumplimentacion.AcceptChanges()
                    End If
                End If
            Next

            'se solicita incluir una nueva fila para los casos en los que el método de cumplimentación es vacio
            Dim dtRow As DataRow
            dtRow = dtFormaCumplimentacion.NewRow
            dtRow(_sesion.MetodoCump.ColumnaId) = "-1"
            dtRow(_sesion.MetodoCump.ColumnaDescripcion(Globales.C_IDIOMA_CASTELLANO)) = GetLocalResourceObject("lblSinDeterminar").ToString()
            dtRow(_sesion.MetodoCump.ColumnaDescripcion(Globales.C_IDIOMA_EUSKERA)) = GetLocalResourceObject("lblSinDeterminar").ToString()
            dtFormaCumplimentacion.Rows.Add(dtRow)



            Dim dtProvincias As System.Data.DataTable = _sesion.ProvinciasInfo.GetProvinciasCAV().ToTable()
            For f As Integer = 0 To dtProvincias.Rows.Count - 1
                If (f < (dtProvincias.Rows.Count)) Then
                    If dtProvincias.Rows(f)(Globales.ALIAS_PROV_NOMBRE) Is String.Empty Then
                        dtProvincias.Rows(f).Delete()
                        dtProvincias.AcceptChanges()
                    End If
                End If
            Next

            'Dibujar para cada territorio, forma de cumplimentación e incidencias
            Dim celdaSeleccionada As Excel.Range = hojaExcel.Range("A5")
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.IndentLevel = 0
                celdaSeleccionada.Font.Color = RGB(0, 0, 0)
                celdaSeleccionada.Font.Color = RGB(0, 0, 0)
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Bold = True
                celdaSeleccionada.Value = dtProvincias.Rows(j)(Globales.ALIAS_PROV_NOMBRE).ToString().ToUpper()
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

                celdaSeleccionada.Value = GetLocalResourceObject("lblEncuestados")
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.RowHeight = 15
                celdaSeleccionada.IndentLevel = 2
                celdaSeleccionada.Font.Bold = True
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)


                For k = 0 To dtFormaCumplimentacion.Rows.Count - 1
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.HorizontalAlignment = xlLeft
                    celdaSeleccionada.VerticalAlignment = xlCenter
                    celdaSeleccionada.Value = dtFormaCumplimentacion.Rows(k)(_sesion.MetodoCump.ColumnaDescripcion(_sesion.Idioma)).ToString()
                    celdaSeleccionada.Font.Bold = False
                    celdaSeleccionada.Font.Italic = True
                    celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                    celdaSeleccionada.IndentLevel = 4
                    celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                Next


                celdaSeleccionada.Value = GetLocalResourceObject("lblIncidencias")
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.RowHeight = 15
                celdaSeleccionada.IndentLevel = 2
                celdaSeleccionada.Font.Bold = True
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

                For k As Integer = 0 To dtIncidencias.Rows.Count - 1
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.HorizontalAlignment = xlLeft
                    celdaSeleccionada.VerticalAlignment = xlCenter
                    celdaSeleccionada.Value = dtIncidencias.Rows(k)(_sesion.Listados.ColumnaDescripcionIncidencias(_sesion.Idioma)).ToString()
                    celdaSeleccionada.Font.Bold = False
                    celdaSeleccionada.Font.Italic = True
                    celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                    celdaSeleccionada.RowHeight = 15
                    celdaSeleccionada.IndentLevel = 4
                    celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                Next
            Next
            'Total
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = GetLocalResourceObject("lblTotalCAPV").ToString().ToUpper()
            celdaSeleccionada.HorizontalAlignment = xlLeft
            celdaSeleccionada.VerticalAlignment = xlCenter
            celdaSeleccionada.IndentLevel = 0
            celdaSeleccionada.Font.Color = RGB(0, 0, 0)
            celdaSeleccionada.Font.Italic = True
            celdaSeleccionada.Font.Bold = True
            celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

            celdaSeleccionada.Value = GetLocalResourceObject("lblEncuestados")
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.HorizontalAlignment = xlLeft
            celdaSeleccionada.VerticalAlignment = xlCenter
            celdaSeleccionada.RowHeight = 15
            celdaSeleccionada.IndentLevel = 2
            celdaSeleccionada.Font.Bold = True
            celdaSeleccionada.Font.Italic = True
            celdaSeleccionada.Font.Color = RGB(255, 0, 0)
            celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

            For k As Integer = 0 To dtFormaCumplimentacion.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.Value = dtFormaCumplimentacion.Rows(k)(_sesion.MetodoCump.ColumnaDescripcion(_sesion.Idioma)).ToString()
                celdaSeleccionada.Font.Bold = False
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                celdaSeleccionada.IndentLevel = 4
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            Next

            celdaSeleccionada.Value = GetLocalResourceObject("lblIncidencias")
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.HorizontalAlignment = xlLeft
            celdaSeleccionada.VerticalAlignment = xlCenter
            celdaSeleccionada.RowHeight = 15
            celdaSeleccionada.IndentLevel = 2
            celdaSeleccionada.Font.Bold = True
            celdaSeleccionada.Font.Italic = True
            celdaSeleccionada.Font.Color = RGB(255, 0, 0)
            celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

            For k As Integer = 0 To dtIncidencias.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.Value = dtIncidencias.Rows(k)(_sesion.Listados.ColumnaDescripcionIncidencias(_sesion.Idioma)).ToString()
                celdaSeleccionada.Font.Bold = False
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                celdaSeleccionada.RowHeight = 15
                celdaSeleccionada.IndentLevel = 4
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            Next
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick

            _sesion.Listados.Anio = DropDownListAnio.SelectedValue
            _sesion.Listados.Trim = DropDownListTrim.SelectedValue

            Dim SemLN As Semana = New Semana(_sesion.Operacion)
            Dim dtSem As DataSet = SemLN.GetDsSem()
            Dim dtDatosFormaCumplimentacion As System.Data.DataTable = _sesion.Listados.CargarDatosFormaListado2(Not IsNothing(dtSem))
            Dim dtDatosIncidencias As System.Data.DataTable = _sesion.Listados.CargarDatosIncidenciasListado2(Not IsNothing(dtSem))

            'DATOS
            Dim semana As Integer
            Dim provincia As String
            Dim incidencia As String
            Dim formaCumplimentacion As String
            Dim datoForma, datoIncidencia As Integer


            celdaSeleccionada = hojaExcel.Range("B5")
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                'Por territorio, total forma de cumplimentación

                provincia = dtProvincias.Rows(j)(Globales.ALIAS_PROV_ID).ToString()
                For semana = 1 To 13

                    celdaSeleccionada.HorizontalAlignment = xlRight
                    'TOTALES POR PROVINCIA
                    If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                        datoForma = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                    Else
                        datoForma = 0
                    End If
                    If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                        datoIncidencia = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                    Else
                        datoIncidencia = 0
                    End If
                    celdaSeleccionada.Value = datoForma + datoIncidencia

                    celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                    celdaSeleccionada.HorizontalAlignment = xlRight
                    If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(-1, 1)

                Next
                'Total incidencias + forma por territorio
                celdaSeleccionada.HorizontalAlignment = xlRight
                If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length > 0 Then
                    datoForma = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length
                Else
                    datoForma = 0
                End If
                If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length > 0 Then
                    datoIncidencia = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length
                Else
                    datoIncidencia = 0
                End If
                celdaSeleccionada.Value = datoForma + datoIncidencia

                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                'total por territorio y forma de cumplimentación sin semana
                If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada.Offset(-1, 0).Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Offset(-1, 0).Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada = celdaSeleccionada.Offset(dtFormaCumplimentacion.Rows.Count + 1, -13)

                'Por territorio, total incidencias
                For semana = 1 To 13

                    celdaSeleccionada.HorizontalAlignment = xlRight
                    If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                Next
                'total por territorio e incidencia sin semana
                If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada = celdaSeleccionada.Offset(dtIncidencias.Rows.Count + 1, -13)
            Next

            'Por Territorio y forma de cumplimentación y semana
            celdaSeleccionada = hojaExcel.Range("B7")
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                provincia = dtProvincias.Rows(j)(Globales.ALIAS_PROV_ID).ToString()
                'Forma de cumplimentación
                For k As Integer = 0 To dtFormaCumplimentacion.Rows.Count - 1

                    formaCumplimentacion = dtFormaCumplimentacion.Rows(k)(_sesion.MetodoCump.ColumnaId).ToString()

                    For semana = 1 To 13


                        celdaSeleccionada.HorizontalAlignment = xlRight
                        If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "' AND " & Globales.COL_CONSULTAVIV_SEM & "='" & semana & "'").Length > 0 Then
                            celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                        celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                    Next
                    'total por territorio y forma de cumplimentación sin semana
                    If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada.HorizontalAlignment = xlRight
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada = celdaSeleccionada.Offset(1, -13)
                Next
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

                'Incidencias
                For k As Integer = 0 To dtIncidencias.Rows.Count - 1
                    incidencia = dtIncidencias.Rows(k)(_sesion.Listados.ColumnaIdIncidencias()).ToString()

                    For semana = 1 To 13

                        celdaSeleccionada.HorizontalAlignment = xlRight
                        If incidencia = Globales.Constantes.PENDIENTE Then
                            'Añado los nulos con INDPER = 'S'
                            If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND (" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "')) AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                                celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND (" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "')) AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                            Else
                                celdaSeleccionada.Value = 0
                            End If
                        Else
                            If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                                celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                            Else
                                celdaSeleccionada.Value = 0
                            End If
                        End If

                        celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                    Next
                    'total por territorio e incidencia sin semana
                    If incidencia = Globales.Constantes.PENDIENTE Then
                        'Añado los nulos con INDPER = 'S'
                        If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND (" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "'))").Length > 0 Then
                            celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND (" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "'))").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                    Else
                        If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "'").Length > 0 Then
                            celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "'").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                    End If
                    celdaSeleccionada.HorizontalAlignment = xlRight
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada = celdaSeleccionada.Offset(1, -13)
                Next
                celdaSeleccionada = celdaSeleccionada.Offset(2, 0)
            Next

            'TOTAL CAPV
            celdaSeleccionada = celdaSeleccionada.Offset(-2, 0)
            For semana = 1 To 13
                celdaSeleccionada.HorizontalAlignment = xlRight
                If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                    datoForma = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                Else
                    datoForma = 0
                End If
                If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                    datoIncidencia = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                Else
                    datoIncidencia = 0
                End If
                celdaSeleccionada.Value = datoForma + datoIncidencia
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
            Next

            'Total de formas de cumplimentacion sin territorio
            'Sin formas de cumplimentacion ni semana
            'Total incidencias + forma por territorio
            celdaSeleccionada.HorizontalAlignment = xlRight
            If dtDatosFormaCumplimentacion.Rows.Count > 0 Then
                datoForma = dtDatosFormaCumplimentacion.Rows.Count
            Else
                datoForma = 0
            End If
            If dtDatosIncidencias.Rows.Count > 0 Then
                datoIncidencia = dtDatosIncidencias.Rows.Count
            Else
                datoIncidencia = 0
            End If
            celdaSeleccionada.Value = datoForma + datoIncidencia

            celdaSeleccionada = celdaSeleccionada.Offset(1, -13)
            For semana = 1 To 13
                celdaSeleccionada.HorizontalAlignment = xlRight
                If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
            Next
            'total
            celdaSeleccionada.Offset(-1, 0).Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Offset(-1, 0).Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Rows.Count
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada = celdaSeleccionada.Offset(1, -13)


            For k As Integer = 0 To dtFormaCumplimentacion.Rows.Count - 1
                formaCumplimentacion = dtFormaCumplimentacion.Rows(k)(_sesion.MetodoCump.ColumnaId).ToString()
                For semana = 1 To 13

                    celdaSeleccionada.HorizontalAlignment = xlRight
                    If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
                Next
                'Total sin semana, sin territorio
                If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada = celdaSeleccionada.Offset(1, -13)
            Next


            'Total de incidencias sin territorio
            'Sin incidencias ni semana
            For semana = 1 To 13
                celdaSeleccionada.HorizontalAlignment = xlRight
                If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_SEM & "='" & semana & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
            Next
            'total
            celdaSeleccionada.Value = dtDatosIncidencias.Rows.Count
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada = celdaSeleccionada.Offset(1, -13)

            For k As Integer = 0 To dtIncidencias.Rows.Count - 1
                incidencia = dtIncidencias.Rows(k)(_sesion.Listados.ColumnaIdIncidencias()).ToString()
                For semana = 1 To 13
                    celdaSeleccionada.HorizontalAlignment = xlRight
                    If incidencia = Globales.Constantes.PENDIENTE Then
                        'Añado los nulos con INDPER = 'S'
                        If dtDatosIncidencias.Select("(" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "'))" & " AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                            celdaSeleccionada.Value = dtDatosIncidencias.Select("(" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "'))" & " AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                    Else
                        If dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length > 0 Then
                            celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' AND " & Globales.COL_CONSULTAVIV_SEM & "= '" & semana & "'").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                    End If
                    If k = dtIncidencias.Rows.Count - 1 Then
                        celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
                Next
                'Total sin semana, sin territorio
                If incidencia = Globales.Constantes.PENDIENTE Then
                    'Añado los nulos con INDPER = 'S'
                    If dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "')").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "')").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    If dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                End If
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                If k = dtIncidencias.Rows.Count - 1 Then
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(1, -13)
            Next


            'Fecha
            hojaExcel.Range("A1").Value = GetLocalResourceObject("lblFechaDoc") & " " & FormatDateTime(Now, DateFormat.GeneralDate)
            hojaExcel.Range("A1").ColumnWidth = 26
            hojaExcel.Range("A1").VerticalAlignment = xlCenter
            hojaExcel.Range("A1").HorizontalAlignment = xlLeft
            hojaExcel.Range("A1").WrapText = False
            hojaExcel.Range("A1").ShrinkToFit = False

            hojaExcel.Activate()

            Dim hojas(libroexcel.Sheets.Count - 1) As Excel.Worksheet
            Dim i As Integer = 0
            For i = 0 To libroexcel.Sheets.Count - 1
                hojas(i) = libroexcel.Sheets.Item(i + 1)
            Next

            filename = GetLocalResourceObject("lblListado2").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension
            nombreFicheroPlantillaExcel = filename
            _sesion.NameListado = filename
            bytesFicheroExcel = bytes

            'Guardar el fichero
            Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado2") + "_" + DropDownListAnio.SelectedValue + "_" + DropDownListTrim.SelectedValue + "_" + extension + ".xls")

            'If nombreFicheroPlantillaExcel <> String.Empty Then
            '    'Sin espacios que sino no sale formato excel al abrir
            '    descargarFicheroPlantillaExcel(GetLocalResourceObject("lblListado2").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension & ".xls")
            'End If

        Catch ex As Exception
            Throw ex
        Finally
            ' Devolver el idioma que tenía antes de generar el Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI
        End Try

    End Sub



    Public Sub GenerarT3()
        ' Guardar el idioma actual
        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        Try
            'CONSTANTES PARA LAS CAPITALES
            Const Bizkaia As String = "48"
            Const Bilbao As String = "020"
            Const Gipuzkoa As String = "20"
            Const Donostia As String = "069"
            Const Araba As String = "01"
            Const Gasteiz As String = "059"
            Const llanadaAlavesa As String = "02"
            Const donostialdea As String = "04"
            Const granBilbao As String = "02"

            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If

            Dim ExcelApplication As New Excel.Application
            Dim libroexcel As Excel.Workbook
            Dim hojaExcel As New Excel.Worksheet
            Dim bytes() As Byte = Nothing
            'id_excel = ExcelApplication.Hinstance
            id_excel = ExcelApplication.HinstancePtr

            ExcelApplication = New Excel.Application
            Dim plantilla As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATH") + System.Configuration.ConfigurationManager.AppSettings.Get("NOM_PLANTILLA_EXCEL")

            ' Cambiar el idioma a castellano, para que no casque la generación del Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")

            ExcelApplication.Workbooks.Add(plantilla)

            Dim filename As String = GetLocalResourceObject("lblListado3").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension

            libroexcel = ExcelApplication.Workbooks(1)
            libroexcel.Activate()

            hojaExcel = libroexcel.ActiveSheet

            If (GetLocalResourceObject("lblListado3").ToString.Length > 30) Then
                hojaExcel.Name = GetLocalResourceObject("lblListado3").ToString.Substring(0, 30)
            Else
                hojaExcel.Name = GetLocalResourceObject("lblListado3").ToString
            End If

            libroexcel.Sheets("Hoja2").visible = False
            libroexcel.Sheets("Hoja3").visible = False

            hojaExcel.Cells.Font.Size = 11

            hojaExcel.Visible = True

            'EXCEL
            hojaExcel.Range("A2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("A2").Borders.Color = RGB(0, 0, 0)
            hojaExcel.Range("A2").ColumnWidth = 6.15
            hojaExcel.Range("C2").Value = GetLocalResourceObject("lblTitulo3Resource1.Text").ToString().ToUpper()
            hojaExcel.Range("C2").Font.Bold = True
            hojaExcel.Range("A2:N2").Borders.LineStyle = xlNone
            hojaExcel.Range("A2:B2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C3").Value = GetLocalResourceObject("lblSitu").ToString() & Chr(10) & GetLocalResourceObject("lblAnioResource1.Text") & " " & _
                DropDownListAnio.SelectedValue & " " & GetLocalResourceObject("lblTrimResource1.Text") & " " & DropDownListTrim.SelectedValue
            hojaExcel.Range("C3").Font.Bold = True
            hojaExcel.Range("A3:N3").Borders.LineStyle = xlNone
            hojaExcel.Range("A3:B3").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C3").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C3:M3").Merge()
            hojaExcel.Range("C3").RowHeight = 30
            hojaExcel.Range("C3").HorizontalAlignment = xlCenter

            hojaExcel.Range("B4").Value = GetLocalResourceObject("lblComarca")
            hojaExcel.Range("B4").Font.Bold = True
            hojaExcel.Range("B4").HorizontalAlignment = xlLeft
            hojaExcel.Range("B4").VerticalAlignment = xlBottom
            hojaExcel.Range("B4").RowHeight = 45.75
            hojaExcel.Range("A4:B4").Borders.Weight = Excel.XlBorderWeight.xlMedium
            hojaExcel.Range("A4").Borders(XlBordersIndex.xlEdgeRight).LineStyle = xlNone
            hojaExcel.Range("B4").ColumnWidth = 39

            'Dibujar situaciones
            Dim SituacionesLN As Situaciones = New Situaciones()
            Dim dtSituaciones As System.Data.DataTable = SituacionesLN.GetDsSituaciones.Tables(0)
            For f As Integer = 0 To dtSituaciones.Rows.Count - 1
                If (f < (dtSituaciones.Rows.Count)) Then
                    If dtSituaciones.Rows(f)(SituacionesLN.ColumnaId) Is DBNull.Value Then
                        dtSituaciones.Rows(f).Delete()
                        dtSituaciones.AcceptChanges()
                    End If
                End If
            Next

            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Merge()
            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Borders.Color = RGB(0, 0, 0)
            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick

            Dim celdaSeleccionada As Excel.Range = hojaExcel.Range("C4")
            For j As Integer = 0 To dtSituaciones.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.Value = dtSituaciones.Rows(j)(SituacionesLN.ColumnaDescripcion(_sesion.Idioma)).ToString()
                If celdaSeleccionada.Value.ToString().Length > 20 Then
                    celdaSeleccionada.ColumnWidth = 15
                Else
                    celdaSeleccionada.ColumnWidth = 11
                End If
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Bold = True
                celdaSeleccionada.HorizontalAlignment = xlCenter
                celdaSeleccionada.VerticalAlignment = xlBottom
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
            Next
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlMedium
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlMedium
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlMedium
            celdaSeleccionada.Value = GetLocalResourceObject("lblTotal")
            celdaSeleccionada.Font.Bold = True
            celdaSeleccionada.ColumnWidth = 8
            celdaSeleccionada.HorizontalAlignment = xlCenter
            celdaSeleccionada.VerticalAlignment = xlBottom

            Dim e_Listados As Eustat.GEDW.V35.Ng.Listados = New Eustat.GEDW.V35.Ng.Listados(_sesion.Operacion)
            _sesion.Listados = e_Listados

            'Dibujar las comarcas
            Dim dtComarcas As System.Data.DataTable = _sesion.Listados.CargarComarcas()
            celdaSeleccionada = hojaExcel.Range("B5")
            For j As Integer = 0 To dtComarcas.Rows.Count - 1
                celdaSeleccionada.Offset(0, -1).Value = j + 1
                celdaSeleccionada.Offset(0, -1).HorizontalAlignment = xlRight
                celdaSeleccionada.Offset(0, -1).VerticalAlignment = xlCenter
                celdaSeleccionada.Offset(0, -1).Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.Value = dtComarcas.Rows(j)(Globales.COL_COM_NOMBRE)
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                celdaSeleccionada.ShrinkToFit = False
            Next
            'Dibujar los municipios
            _sesion.ProvinciasInfo.GetProvinciasCAV().Sort = Globales.ALIAS_PROV_ID
            Dim dtProvincias As System.Data.DataTable = _sesion.ProvinciasInfo.GetProvinciasCAV().ToTable()
            For f As Integer = 0 To dtProvincias.Rows.Count - 1
                If (f < (dtProvincias.Rows.Count)) Then
                    If dtProvincias.Rows(f)(Globales.ALIAS_PROV_NOMBRE) Is String.Empty Then
                        dtProvincias.Rows(f).Delete()
                        dtProvincias.AcceptChanges()
                    End If
                End If
            Next
            Dim provincia As String = Nothing
            Dim municipio As String = Nothing
            For k As Integer = 0 To dtProvincias.Rows.Count - 1
                Dim dtMunicipios = _sesion.MunicipiosInfo.GetMunicipios(dtProvincias.Rows(k)(Globales.ALIAS_PROV_ID).ToString()).ToTable()
                provincia = dtProvincias.Rows(k)(Globales.ALIAS_PROV_ID).ToString()
                celdaSeleccionada.Offset(0, -1).Value = celdaSeleccionada.Offset(-1, -1).Value + 1
                celdaSeleccionada.Offset(0, -1).HorizontalAlignment = xlRight
                celdaSeleccionada.Offset(0, -1).VerticalAlignment = xlCenter
                celdaSeleccionada.Offset(0, -1).Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlMedium

                If provincia = Bizkaia Then
                    municipio = Bilbao
                ElseIf provincia = Gipuzkoa Then
                    municipio = Donostia
                ElseIf provincia = Araba Then
                    municipio = Gasteiz
                End If
                If dtMunicipios.Select(Globales.ALIAS_MUN_ID & "= '" & municipio & "' AND " & Globales.ALIAS_MUN_PROVID & " = '" & provincia & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtMunicipios.Select(Globales.ALIAS_MUN_ID & "= '" & municipio & "' AND " & Globales.ALIAS_MUN_PROVID & " = '" & provincia & "'")(0)(Globales.ALIAS_MUN_NOMBRE)
                End If

                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                celdaSeleccionada.ShrinkToFit = False
            Next

            celdaSeleccionada.Offset(0, -1).Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlMedium
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlMedium

            _sesion.Listados.Anio = DropDownListAnio.SelectedValue
            _sesion.Listados.Trim = DropDownListTrim.SelectedValue

            Dim dt As System.Data.DataTable = _sesion.Listados.CargarDatosListado3()

            'DATOS
            Dim comarca As String
            Dim situacion As String

            'Por Territorio y comarca y situación
            celdaSeleccionada = hojaExcel.Range("C5")
            For j As Integer = 0 To dtComarcas.Rows.Count - 1
                provincia = dtComarcas.Rows(j)(Globales.COL_COM_PROV).ToString()
                comarca = dtComarcas.Rows(j)(Globales.COL_COM_COMR).ToString()

                For k As Integer = 0 To dtSituaciones.Rows.Count - 1
                    situacion = dtSituaciones.Rows(k)(SituacionesLN.ColumnaId).ToString()

                    municipio = String.Empty
                    If provincia = Bizkaia And comarca = granBilbao Then
                        municipio = Bilbao
                    ElseIf provincia = Gipuzkoa And comarca = donostialdea Then
                        municipio = Donostia
                    ElseIf provincia = Araba And comarca = llanadaAlavesa Then
                        municipio = Gasteiz
                    End If
                    celdaSeleccionada.HorizontalAlignment = xlRight

                    If municipio = String.Empty Then
                        If dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_COM_COMR & "= '" & comarca & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length > 0 Then
                            celdaSeleccionada.Value = dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_COM_COMR & "= '" & comarca & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                    Else
                        If dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_COM_COMR & "= '" & comarca & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'" & " AND " & Globales.COL_CONSULTAVIV_MUN & " <> " & municipio).Length > 0 Then
                            celdaSeleccionada.Value = dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_COM_COMR & "= '" & comarca & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'" & " AND " & Globales.COL_CONSULTAVIV_MUN & " <> " & municipio).Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                    End If

                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
                    celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
                Next

                'total sin situación, por comarca
                If municipio = String.Empty Then
                    If dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_COM_COMR & "= '" & comarca & "'").Length > 0 Then
                        celdaSeleccionada.Value = dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_COM_COMR & "= '" & comarca & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    If dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_COM_COMR & "= '" & comarca & "'" & " AND " & Globales.COL_CONSULTAVIV_MUN & " <> '" & municipio & "'").Length > 0 Then
                        celdaSeleccionada.Value = dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_COM_COMR & "= '" & comarca & "'" & " AND " & Globales.COL_CONSULTAVIV_MUN & " <> '" & municipio & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                End If

                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada = celdaSeleccionada.Offset(1, -dtSituaciones.Rows.Count)
            Next

            'Por capitales y situación
            For k As Integer = 0 To dtProvincias.Rows.Count - 1
                provincia = dtProvincias.Rows(k)(Globales.ALIAS_PROV_ID).ToString()

                If provincia = Bizkaia Then
                    municipio = Bilbao
                ElseIf provincia = Gipuzkoa Then
                    municipio = Donostia
                ElseIf provincia = Araba Then
                    municipio = Gasteiz
                End If

                For l As Integer = 0 To dtSituaciones.Rows.Count - 1
                    situacion = dtSituaciones.Rows(l)(SituacionesLN.ColumnaId).ToString()

                    celdaSeleccionada.HorizontalAlignment = xlRight
                    If dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_MUN & "= '" & municipio & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length > 0 Then
                        celdaSeleccionada.Value = dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_MUN & "= '" & municipio & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium

                    If k = dtProvincias.Rows.Count - 1 Then
                        celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlMedium
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                Next

                'total sin situación, por comarca
                If dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_MUN & "= '" & municipio & "'").Length > 0 Then
                    celdaSeleccionada.Value = dt.Select(Globales.COL_COM_PROV & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_MUN & "= '" & municipio & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
                If k = dtProvincias.Rows.Count - 1 Then
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlMedium
                End If

                celdaSeleccionada = celdaSeleccionada.Offset(1, -dtSituaciones.Rows.Count)

            Next


            'Fecha
            hojaExcel.Range("A1").Value = GetLocalResourceObject("lblFechaDoc") & " " & FormatDateTime(Now, DateFormat.GeneralDate)
            hojaExcel.Range("A1").VerticalAlignment = xlCenter
            hojaExcel.Range("A1").HorizontalAlignment = xlLeft
            hojaExcel.Range("A1").WrapText = False
            hojaExcel.Range("A1").ShrinkToFit = False

            hojaExcel.Activate()

            Dim hojas(libroexcel.Sheets.Count - 1) As Excel.Worksheet
            Dim i As Integer = 0
            For i = 0 To libroexcel.Sheets.Count - 1
                hojas(i) = libroexcel.Sheets.Item(i + 1)
            Next

            filename = GetLocalResourceObject("lblListado3").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension
            nombreFicheroPlantillaExcel = filename
            _sesion.NameListado = filename
            bytesFicheroExcel = bytes

            'Guardar el fichero
            Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado3") + "_" + DropDownListAnio.SelectedValue + "_" + DropDownListTrim.SelectedValue + "_" + extension + ".xls")

            'If nombreFicheroPlantillaExcel <> String.Empty Then
            '    'Sin espacios que sino no sale formato excel al abrir
            '    descargarFicheroPlantillaExcel(GetLocalResourceObject("lblListado3").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension & ".xls")
            'End If

        Catch ex As Exception
            Throw ex
        Finally
            ' Devolver el idioma que tenía antes de generar el Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI
        End Try

    End Sub


    Public Sub GenerarT4()
        ' Guardar el idioma actual
        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        Try

            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If

            Dim ExcelApplication As New Excel.Application
            Dim libroexcel As Excel.Workbook
            Dim hojaExcel As New Excel.Worksheet
            Dim bytes() As Byte = Nothing
            'id_excel = ExcelApplication.Hinstance
            id_excel = ExcelApplication.HinstancePtr

            ExcelApplication = New Excel.Application
            Dim plantilla As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATH") + System.Configuration.ConfigurationManager.AppSettings.Get("NOM_PLANTILLA_EXCEL")

            ' Cambiar el idioma a castellano, para que no casque la generación del Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")

            ExcelApplication.Workbooks.Add(plantilla)

            Dim filename As String = GetLocalResourceObject("lblListado4").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension

            libroexcel = ExcelApplication.Workbooks(1)
            libroexcel.Activate()

            hojaExcel = libroexcel.ActiveSheet

            If GetLocalResourceObject("lblListado4").ToString.Length > 30 Then
                hojaExcel.Name = GetLocalResourceObject("lblListado4").ToString.Substring(0, 30)
            Else
                hojaExcel.Name = GetLocalResourceObject("lblListado4").ToString
            End If

            libroexcel.Sheets("Hoja2").visible = False
            libroexcel.Sheets("Hoja3").visible = False

            hojaExcel.Cells.Font.Size = 11

            hojaExcel.Visible = True

            'EXCEL
            hojaExcel.Range("A2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("A2").Borders.Color = RGB(0, 0, 0)
            hojaExcel.Range("B2").Value = GetLocalResourceObject("lblTitulo4Resource1.Text").ToString() & " " & GetLocalResourceObject("lblAnioResource1.Text") & " " & _
                DropDownListAnio.SelectedValue & " " & GetLocalResourceObject("lblTrimResource1.Text") & " " & DropDownListTrim.SelectedValue
            hojaExcel.Range("B2").Font.Bold = True
            hojaExcel.Range("B2:E2").Merge()
            hojaExcel.Range("B2:N2").Borders.LineStyle = xlNone
            hojaExcel.Range("B2:E2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("B2").Borders.Color = RGB(0, 0, 0)
            hojaExcel.Range("A2").ColumnWidth = 30
            hojaExcel.Range("B2:E2").ColumnWidth = 38

            hojaExcel.Range("A4").Value = GetLocalResourceObject("lblEncuestador")
            hojaExcel.Range("B4").Value = GetLocalResourceObject("lblTotalFamCompletas")
            hojaExcel.Range("C4").Value = GetLocalResourceObject("lblTotalFamIncidencias")
            hojaExcel.Range("D4").Value = GetLocalResourceObject("lblTotalIndCompletas")
            hojaExcel.Range("E4").Value = GetLocalResourceObject("lblTotalIndIncidencias")
            hojaExcel.Range("A4:E4").Font.Bold = True
            hojaExcel.Range("A4:E4").HorizontalAlignment = xlLeft
            hojaExcel.Range("A4:E4").VerticalAlignment = xlCenter
            hojaExcel.Range("A4:E4").Borders.Weight = Excel.XlBorderWeight.xlThick

            'Dibujar los encuestadores
            Dim e_Listados As Eustat.GEDW.V35.Ng.Listados = New Eustat.GEDW.V35.Ng.Listados(_sesion.Operacion)
            _sesion.Listados = e_Listados
            Dim dtEncuestadores As System.Data.DataTable = _sesion.Listados.ObtenerEncuestadores(_sesion.Operacion)
            Dim celdaSeleccionada As Excel.Range = hojaExcel.Range("A5")
            For j As Integer = 0 To dtEncuestadores.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.Value = dtEncuestadores.Rows(j)(Globales.ALIAS_USUARIOS_NOMBRE).ToString()
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            Next
            'Totales
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = GetLocalResourceObject("lblTotales").ToString().ToUpper()
            celdaSeleccionada.Font.Bold = True

            _sesion.Listados.Anio = DropDownListAnio.SelectedValue
            _sesion.Listados.Trim = DropDownListTrim.SelectedValue
            _sesion.Listados.Operacion = _sesion.Operacion


            'DATOS
            Dim dtFamCompletas As New System.Data.DataTable
            Dim dtFamIncidencias As New System.Data.DataTable

            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                dtFamCompletas = _sesion.Listados.CargarDatosFamiliaresCompletas()
                dtFamIncidencias = _sesion.Listados.CargarDatosFamiliaresIncidencias()
            End If

            Dim dtIndCompletas As System.Data.DataTable = _sesion.Listados.CargarDatosIndividualesCompletas()
            Dim dtIndIncidencias As System.Data.DataTable = _sesion.Listados.CargarDatosIndividualesIncidencias()

            Dim codEncuestador As String

            celdaSeleccionada = hojaExcel.Range("B5")
            For j As Integer = 0 To dtEncuestadores.Rows.Count - 1
                codEncuestador = dtEncuestadores.Rows(j)(Globales.COL_USUARIOS_NUMC).ToString()

                'Familiares completas por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                    If dtFamCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtFamCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Familiares con incidencias por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                    If dtFamIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtFamIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Personales completas por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                If dtIndCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtIndCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Personales con incidencias por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                If dtIndIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtIndIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(1, -3)

            Next
            'Total Familiares completas
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                celdaSeleccionada.Value = dtFamCompletas.Rows.Count
            Else
                celdaSeleccionada.Value = 0
            End If

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total Familiares con incidencias
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                celdaSeleccionada.Value = dtFamIncidencias.Rows.Count
            Else
                celdaSeleccionada.Value = 0
            End If
            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total individuales completas
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = dtIndCompletas.Rows.Count
            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total individuales con incidencias
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = dtIndIncidencias.Rows.Count
            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Fecha
            hojaExcel.Range("A1").Value = GetLocalResourceObject("lblFechaDoc") & " " & FormatDateTime(Now, DateFormat.GeneralDate)
            hojaExcel.Range("A1").VerticalAlignment = xlCenter
            hojaExcel.Range("A1").HorizontalAlignment = xlLeft
            hojaExcel.Range("A1").WrapText = False
            hojaExcel.Range("A1").ShrinkToFit = False

            hojaExcel.Activate()

            Dim hojas(libroexcel.Sheets.Count - 1) As Excel.Worksheet
            Dim i As Integer = 0
            For i = 0 To libroexcel.Sheets.Count - 1
                hojas(i) = libroexcel.Sheets.Item(i + 1)
            Next

            filename = GetLocalResourceObject("lblListado4").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension
            nombreFicheroPlantillaExcel = filename
            _sesion.NameListado = filename
            bytesFicheroExcel = bytes

            'Guardar el fichero
            Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado4") + "_" + DropDownListAnio.SelectedValue + "_" + DropDownListTrim.SelectedValue + "_" + extension + ".xls")

            'If nombreFicheroPlantillaExcel <> String.Empty Then
            '    'Sin espacios que sino no sale formato excel al abrir
            '    descargarFicheroPlantillaExcel(".xls")
            'End If

        Catch ex As Exception
            Throw ex
        Finally
            ' Devolver el idioma que tenía antes de generar el Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI
        End Try

    End Sub

    Public Sub GenerarT1Lote()
        ' Guardar el idioma actual
        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        Try

            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If

            Dim ExcelApplication As New Excel.Application
            Dim libroexcel As Excel.Workbook
            Dim hojaExcel As New Excel.Worksheet
            Dim bytes() As Byte = Nothing
            'id_excel = ExcelApplication.Hinstance
            id_excel = ExcelApplication.HinstancePtr

            ExcelApplication = New Excel.Application
            Dim plantilla As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATH") + System.Configuration.ConfigurationManager.AppSettings.Get("NOM_PLANTILLA_EXCEL")

            ' Cambiar el idioma a castellano, para que no casque la generación del Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")

            ExcelApplication.Workbooks.Add(plantilla)

            Dim filename As String = GetLocalResourceObject("lblListado5").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & extension

            libroexcel = ExcelApplication.Workbooks(1)
            libroexcel.Activate()

            hojaExcel = libroexcel.ActiveSheet

            If (GetLocalResourceObject("lblListado5").ToString.Length > 30) Then
                hojaExcel.Name = GetLocalResourceObject("lblListado5").ToString.Substring(0, 30)
            Else
                hojaExcel.Name = GetLocalResourceObject("lblListado5").ToString
            End If


            libroexcel.Sheets("Hoja2").visible = False
            libroexcel.Sheets("Hoja3").visible = False

            hojaExcel.Cells.Font.Size = 11

            hojaExcel.Visible = True

            'EXCEL
            hojaExcel.Range("A2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("A2").Borders.Color = RGB(0, 0, 0)
            hojaExcel.Range("B2").Value = GetLocalResourceObject("lblTitulo5Resource1.Text").ToString().ToUpper()
            hojaExcel.Range("B2").Font.Bold = True
            hojaExcel.Range("B2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C2:N2").Borders.Color = xlNone
            hojaExcel.Range("C2:N2").Borders.LineStyle = xlNone
            hojaExcel.Range("B2").Borders.Color = RGB(0, 0, 0)

            hojaExcel.Range("B3").Value = GetLocalResourceObject("lblAnioResource1.Text") & " " & DropDownListAnio.SelectedValue & " " & GetLocalResourceObject("lblTrimResource1.Text") & " 1"
            hojaExcel.Range("B3").Font.Bold = True
            hojaExcel.Range("B3").HorizontalAlignment = xlCenter
            hojaExcel.Range("B3").VerticalAlignment = xlCenter
            hojaExcel.Range("B3").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("B1").ColumnWidth = 50

            hojaExcel.Range("A4").Value = GetLocalResourceObject("lblSituacion")
            hojaExcel.Range("A4").Font.Bold = True
            hojaExcel.Range("A4").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("B4").Value = GetLocalResourceObject("lblTotal")
            hojaExcel.Range("B4").Font.Bold = True
            hojaExcel.Range("B4").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("B4").HorizontalAlignment = xlRight

            Dim SituacionesLN As Situaciones = New Situaciones()
            Dim dtSituaciones As System.Data.DataTable = SituacionesLN.GetDsSituaciones.Tables(0)
            For f As Integer = 0 To dtSituaciones.Rows.Count - 1
                If (f < (dtSituaciones.Rows.Count)) Then
                    If dtSituaciones.Rows(f)(SituacionesLN.ColumnaId) Is DBNull.Value Then
                        dtSituaciones.Rows(f).Delete()
                        dtSituaciones.AcceptChanges()
                    End If
                End If
            Next

            Dim dtProvincias As System.Data.DataTable = _sesion.ProvinciasInfo.GetProvinciasCAV().ToTable()
            For f As Integer = 0 To dtProvincias.Rows.Count - 1
                If (f < (dtProvincias.Rows.Count)) Then
                    If dtProvincias.Rows(f)(Globales.ALIAS_PROV_NOMBRE) Is String.Empty Then
                        dtProvincias.Rows(f).Delete()
                        dtProvincias.AcceptChanges()
                    End If
                End If
            Next

            'Dibujar las Situaciones para cada territorio
            Dim celdaSeleccionada As Excel.Range = hojaExcel.Range("A5")
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlMedium
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.IndentLevel = 0
                celdaSeleccionada.Font.Color = RGB(0, 0, 0)
                celdaSeleccionada.Font.Color = RGB(0, 0, 0)
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Bold = True
                celdaSeleccionada.Value = dtProvincias.Rows(j)(Globales.ALIAS_PROV_NOMBRE).ToString().ToUpper()
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                For k As Integer = 0 To dtSituaciones.Rows.Count - 1
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.RowHeight = 15
                    celdaSeleccionada.IndentLevel = 2
                    celdaSeleccionada.Value = dtSituaciones.Rows(k)(SituacionesLN.ColumnaDescripcion(_sesion.Idioma)).ToString()
                    celdaSeleccionada.Font.Bold = False
                    celdaSeleccionada.Font.Italic = True
                    celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                    celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                Next
            Next
            'Total
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = GetLocalResourceObject("lblTotal").ToString().ToUpper()
            celdaSeleccionada.HorizontalAlignment = xlLeft
            celdaSeleccionada.VerticalAlignment = xlCenter
            celdaSeleccionada.IndentLevel = 0
            celdaSeleccionada.Font.Color = RGB(0, 0, 0)
            celdaSeleccionada.Font.Italic = True
            celdaSeleccionada.Font.Bold = True
            celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            For k As Integer = 0 To dtSituaciones.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.RowHeight = 15
                celdaSeleccionada.IndentLevel = 2
                celdaSeleccionada.Value = dtSituaciones.Rows(k)(SituacionesLN.ColumnaDescripcion(_sesion.Idioma)).ToString()
                celdaSeleccionada.Font.Bold = False
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            Next
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = GetLocalResourceObject("lblBase").ToString()
            celdaSeleccionada.HorizontalAlignment = xlLeft
            celdaSeleccionada.VerticalAlignment = xlCenter
            celdaSeleccionada.IndentLevel = 0
            celdaSeleccionada.Font.Color = RGB(0, 0, 0)
            celdaSeleccionada.Font.Italic = True
            celdaSeleccionada.Font.Bold = True

            Dim e_Listados As Eustat.GEDW.V35.Ng.Listados = New Eustat.GEDW.V35.Ng.Listados(_sesion.Operacion)
            _sesion.Listados = e_Listados

            _sesion.Listados.Anio = DropDownListAnio.SelectedValue
            _sesion.Listados.Trim = DropDownListTrim.SelectedValue

            Dim dt As System.Data.DataTable = _sesion.Listados.CargarDatosListado1Lote(_sesion.UsuarioActual)

            'DATOS
            Dim provincia As String
            Dim situacion As String

            'Por Territorio, sin situación
            celdaSeleccionada = hojaExcel.Range("B5")
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                provincia = dtProvincias.Rows(j)(Globales.ALIAS_PROV_ID).ToString()

                'Total por territorio y situación
                celdaSeleccionada.HorizontalAlignment = xlRight
                If dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length > 0 Then
                    celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada = celdaSeleccionada.Offset(dtSituaciones.Rows.Count + 1, 0)
            Next

            'Por Territorio y situación
            celdaSeleccionada = hojaExcel.Range("B6")
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                For k As Integer = 0 To dtSituaciones.Rows.Count - 1

                    provincia = dtProvincias.Rows(j)(Globales.ALIAS_PROV_ID).ToString()
                    situacion = dtSituaciones.Rows(k)(SituacionesLN.ColumnaId).ToString()
                    celdaSeleccionada.HorizontalAlignment = xlRight
                    'total por territorio y situación sin semana
                    If dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length > 0 Then
                        celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada.HorizontalAlignment = xlRight
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                Next
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            Next

            'Total de situaciones sin territorio
            'Sin situación
            celdaSeleccionada = celdaSeleccionada.Offset(-1, 0)
            'total
            celdaSeleccionada.Value = dt.Rows.Count
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada = celdaSeleccionada.Offset(1, 0)


            For k As Integer = 0 To dtSituaciones.Rows.Count - 1
                situacion = dtSituaciones.Rows(k)(SituacionesLN.ColumnaId).ToString()
                'Total sin territorio
                If dt.Select(Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length > 0 Then
                    celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                If k = dtSituaciones.Rows.Count - 1 Then
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            Next


            'Fecha
            hojaExcel.Range("A1").Value = GetLocalResourceObject("lblFechaDoc") & " " & FormatDateTime(Now, DateFormat.GeneralDate)
            hojaExcel.Range("A1").ColumnWidth = 41
            hojaExcel.Range("A1").VerticalAlignment = xlCenter
            hojaExcel.Range("A1").HorizontalAlignment = xlLeft
            hojaExcel.Range("A1").WrapText = False
            hojaExcel.Range("A1").ShrinkToFit = False

            hojaExcel.Activate()

            Dim hojas(libroexcel.Sheets.Count - 1) As Excel.Worksheet
            Dim i As Integer = 0
            For i = 0 To libroexcel.Sheets.Count - 1
                hojas(i) = libroexcel.Sheets.Item(i + 1)
            Next

            filename = GetLocalResourceObject("lblListado5").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & extension
            nombreFicheroPlantillaExcel = filename
            _sesion.NameListado = filename
            bytesFicheroExcel = bytes

            'Guardar el fichero
            Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado5") + "_" + DropDownListAnio.SelectedValue + "_" + extension + ".xls")

            'If nombreFicheroPlantillaExcel <> String.Empty Then
            '    'Sin espacios que sino no sale formato excel al abrir
            '    descargarFicheroPlantillaExcel(GetLocalResourceObject("lblListado1").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension & ".xls")
            'End If

        Catch ex As Exception
            Throw ex
        Finally
            ' Devolver el idioma que tenía antes de generar el Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI
        End Try

    End Sub


    'LISTADO DURACIONES
    Public Sub GenerarT6()
        ' Guardar el idioma actual
        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        Try

            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If

            Dim ExcelApplication As New Excel.Application
            Dim libroexcel As Excel.Workbook
            Dim hojaExcel As New Excel.Worksheet
            Dim bytes() As Byte = Nothing
            'id_excel = ExcelApplication.Hinstance
            id_excel = ExcelApplication.HinstancePtr

            ExcelApplication = New Excel.Application
            Dim plantilla As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATH") + System.Configuration.ConfigurationManager.AppSettings.Get("NOM_PLANTILLA_EXCEL")

            ' Cambiar el idioma a castellano, para que no casque la generación del Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")

            ExcelApplication.Workbooks.Add(plantilla)

            Dim filename As String = GetLocalResourceObject("lblListado6").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue
            If DropDownListTrim.SelectedValue <> String.Empty Then
                filename = filename & "_" & DropDownListTrim.SelectedValue & "_" & extension
            End If

            libroexcel = ExcelApplication.Workbooks(1)
            libroexcel.Activate()

            hojaExcel = libroexcel.ActiveSheet

            If cbAgente.Checked Then
                hojaExcel.Name = GetLocalResourceObject("cbAgenteResource1.Text").ToString()
                If cbEncuestado.Checked Then
                    libroexcel.Sheets("Hoja2").Name = GetLocalResourceObject("cbEncuestadoResource1.Text").ToString()
                    libroexcel.Sheets("Hoja3").visible = False
                End If
            Else
                hojaExcel.Name = GetLocalResourceObject("cbEncuestadoResource1.Text").ToString()
                libroexcel.Sheets("Hoja2").visible = False
            End If

            hojaExcel.Cells.Font.Size = 11

            hojaExcel.Visible = True

            'EXCEL
            Dim e_Listados As Eustat.GEDW.V35.Ng.Listados = New Eustat.GEDW.V35.Ng.Listados(_sesion.Operacion)
            _sesion.Listados = e_Listados

            _sesion.Listados.Anio = DropDownListAnio.SelectedValue
            _sesion.Listados.Trim = DropDownListTrim.SelectedValue

            Dim celdaSeleccionada As Excel.Range = hojaExcel.Range("B5")

            'POR IDIOMA
            If rbIdioma.Checked Then
                'por agente
                If cbAgente.Checked Then

                    If cbEncuesta.Checked Then
                        dibujarAgenteEncuesta(hojaExcel, libroexcel, True)
                    End If

                    If cbVivienda.Checked Then
                        dibujarAgenteVivienda(hojaExcel, libroexcel, True)
                    End If

                    hojaExcel.Range("C3").EntireRow.Delete()

                    DibujarInformeDuracionElementosComunes(hojaExcel, libroexcel)

                End If

                'por encuestado (otra pestaña)
                If cbEncuestado.Checked Then

                    libroexcel.Sheets(GetLocalResourceObject("cbEncuestadoResource1.Text").ToString()).Activate()

                    hojaExcel = libroexcel.ActiveSheet

                    If cbEncuesta.Checked Then
                        dibujarEncuestadoEncuesta(hojaExcel, libroexcel, True)
                    End If

                    If cbVivienda.Checked Then
                        dibujarEncuestadoVivienda(hojaExcel, libroexcel, True)
                    End If

                    hojaExcel.Range("C3").EntireRow.Delete()

                    DibujarInformeDuracionElementosComunes(hojaExcel, libroexcel)

                End If

                'POR METODO
            ElseIf rbMetodo.Checked Then
                'por agente
                If cbAgente.Checked Then

                    If cbEncuesta.Checked Then
                        dibujarAgenteEncuesta(hojaExcel, libroexcel, False)
                    End If

                    If cbVivienda.Checked Then
                        dibujarAgenteVivienda(hojaExcel, libroexcel, False)
                    End If

                    hojaExcel.Range("C3").EntireRow.Delete()

                    DibujarInformeDuracionElementosComunes(hojaExcel, libroexcel)

                End If

                'por encuestado (otra pestaña)
                If cbEncuestado.Checked Then

                    libroexcel.Sheets(GetLocalResourceObject("cbEncuestadoResource1.Text").ToString()).Activate()

                    hojaExcel = libroexcel.ActiveSheet

                    If cbEncuesta.Checked Then
                        dibujarEncuestadoEncuesta(hojaExcel, libroexcel, False)
                    End If

                    If cbVivienda.Checked Then
                        dibujarEncuestadoVivienda(hojaExcel, libroexcel, False)
                    End If

                    hojaExcel.Range("C3").EntireRow.Delete()

                    DibujarInformeDuracionElementosComunes(hojaExcel, libroexcel)

                End If
            End If

            Dim hojas(libroexcel.Sheets.Count - 1) As Excel.Worksheet
            Dim i As Integer = 0
            For i = 0 To libroexcel.Sheets.Count - 1
                hojas(i) = libroexcel.Sheets.Item(i + 1)
            Next

            libroexcel.Sheets(1).Activate()

            hojaExcel = libroexcel.ActiveSheet
            hojaExcel.Range("A1").Select()

            If DropDownListTrim.SelectedValue <> String.Empty Then
                filename = GetLocalResourceObject("lblListado6").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension
            Else
                filename = GetLocalResourceObject("lblListado6").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & extension
            End If
            nombreFicheroPlantillaExcel = filename
            _sesion.NameListado = filename
            bytesFicheroExcel = bytes

            'Guardar el fichero
            If DropDownListTrim.SelectedValue <> String.Empty Then
                Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado6") + "_" + DropDownListAnio.SelectedValue + "_" + DropDownListTrim.SelectedValue + "_" + extension + ".xls")
            Else
                Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado6") + "_" + DropDownListAnio.SelectedValue + "_" + extension + ".xls")
            End If

        Catch ex As Exception
            Throw ex
        Finally
            ' Devolver el idioma que tenía antes de generar el Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI
        End Try

    End Sub

    Private Sub dibujarAgenteEncuesta(ByVal hojaExcel As Excel.Worksheet, ByVal libroexcel As Excel.Workbook, ByVal esIdioma As Boolean)
        Dim totalColectivoAgente As Integer
        Dim totalFamiliarAgente As Integer
        Dim totalPersonalAgente As Integer

        Dim dur1 As Integer = 300
        Dim dur2 As Integer = 600
        Dim dur3 As Integer = 900
        Dim dur4 As Integer = 1200
        Dim dur5 As Integer = 1500
        Dim dur6 As Integer = 1800
        Dim dur7 As Integer = 2100
        Dim dur8 As Integer = 2400
        Dim dur9 As Integer = 2700

        Dim dtDuracionColectivoAgente As System.Data.DataTable = Nothing
        Dim dtDuracionFamiliarAgente As System.Data.DataTable = Nothing
        Dim dtDuracionPersonalAgente As System.Data.DataTable = Nothing

        Dim dtSumaColectivoAgenteCastellano As System.Data.DataTable = Nothing
        Dim dtSumaFamiliarAgenteCastellano As System.Data.DataTable = Nothing
        Dim dtSumaPersonalAgenteCastellano As System.Data.DataTable = Nothing

        Dim dtSumaColectivoAgenteEuskera As System.Data.DataTable = Nothing
        Dim dtSumaFamiliarAgenteEuskera As System.Data.DataTable = Nothing
        Dim dtSumaPersonalAgenteEuskera As System.Data.DataTable = Nothing

        Dim dtSumaColectivoAgenteTelefonoVisita As System.Data.DataTable = Nothing
        Dim dtSumaFamiliarAgenteTelefonoVisita As System.Data.DataTable = Nothing
        Dim dtSumaPersonalAgenteTelefonoVisita As System.Data.DataTable = Nothing

        Dim dtSumaColectivoAgenteWeb As System.Data.DataTable = Nothing
        Dim dtSumaFamiliarAgenteWeb As System.Data.DataTable = Nothing
        Dim dtSumaPersonalAgenteWeb As System.Data.DataTable = Nothing

        Dim celdaSeleccionada As Excel.Range = hojaExcel.Range("B5")
        hojaExcel.Range("B4").Value = GetLocalResourceObject("lblDuracion").ToString().ToUpper()
        hojaExcel.Range("B4").Font.Bold = True
        hojaExcel.Range("B4").HorizontalAlignment = xlLeft
        hojaExcel.Range("B4").VerticalAlignment = xlCenter

        'Dibujar duraciones
        hojaExcel.Range("B1").ColumnWidth = 25
        hojaExcel.Range("B5").Value = GetLocalResourceObject("lblDur1").ToString()
        hojaExcel.Range("B6").Value = GetLocalResourceObject("lblDur2").ToString()
        hojaExcel.Range("B7").Value = GetLocalResourceObject("lblDur3").ToString()
        hojaExcel.Range("B8").Value = GetLocalResourceObject("lblDur4").ToString()
        hojaExcel.Range("B9").Value = GetLocalResourceObject("lblDur5").ToString()
        hojaExcel.Range("B10").Value = GetLocalResourceObject("lblDur6").ToString()
        hojaExcel.Range("B11").Value = GetLocalResourceObject("lblDur7").ToString()
        hojaExcel.Range("B12").Value = GetLocalResourceObject("lblDur8").ToString()
        hojaExcel.Range("B13").Value = GetLocalResourceObject("lblDur9").ToString()
        hojaExcel.Range("B14").Value = GetLocalResourceObject("lblDur10").ToString()
        hojaExcel.Range("B5:B14").HorizontalAlignment = xlLeft

        'Por encuesta
        hojaExcel.Range("C4").Value = GetLocalResourceObject("lblNumero").ToString()
        hojaExcel.Range("D4").Value = "%"
        hojaExcel.Range("E4").Value = GetLocalResourceObject("lblAcumulado").ToString()

        hojaExcel.Range("F4").Value = GetLocalResourceObject("lblNumero").ToString()
        hojaExcel.Range("G4").Value = "%"
        hojaExcel.Range("H4").Value = GetLocalResourceObject("lblAcumulado").ToString()

        hojaExcel.Range("I4").Value = GetLocalResourceObject("lblNumero").ToString()
        hojaExcel.Range("J4").Value = "%"
        hojaExcel.Range("K4").Value = GetLocalResourceObject("lblAcumulado").ToString()
        hojaExcel.Range("C4:K4").HorizontalAlignment = xlCenter
        hojaExcel.Range("C4:K4").VerticalAlignment = xlCenter
        hojaExcel.Range("C4:K4").Font.Bold = True

        'CASTELLANO
        If esIdioma Then
            hojaExcel.Range("A4").Value = GetLocalResourceObject("rbIdiomaResource1.Text").ToString().ToUpper()
        Else
            hojaExcel.Range("A4").Value = GetLocalResourceObject("lblForma").ToString()
        End If
        hojaExcel.Range("A4").Font.Bold = True
        hojaExcel.Range("A4").HorizontalAlignment = xlLeft
        hojaExcel.Range("A4").VerticalAlignment = xlBottom
        'hojaExcel.Range("A4").RowHeight = 45.75
        'hojaExcel.Range("A4:B4").Borders.Weight = Excel.XlBorderWeight.xlMedium
        'hojaExcel.Range("A4").Borders(XlBordersIndex.xlEdgeRight).LineStyle = xlNone
        'hojaExcel.Range("B4").ColumnWidth = 39

        If esIdioma Then
            hojaExcel.Range("A5").Value = GetLocalResourceObject("lblCastellano").ToString()
        Else
            hojaExcel.Range("A5").Value = GetLocalResourceObject("lblTelefonicaVisita").ToString()
        End If

        hojaExcel.Range("A5").Font.Bold = True
        hojaExcel.Range("A5").ColumnWidth = 12



        dtDuracionColectivoAgente = _sesion.Listados.CargarDatosDuracionColectivoAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

        If esIdioma Then

            'Datos colectivo en castellano
            dtSumaColectivoAgenteCastellano = _sesion.Listados.CargarSumaDuracionColectivoAgenteCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

            If Not dtDuracionColectivoAgente Is Nothing Then

                totalColectivoAgente = dtDuracionColectivoAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                If totalColectivoAgente = 0 Then
                    totalColectivoAgente = 1
                End If

                celdaSeleccionada.Offset(0, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value

                celdaSeleccionada.Offset(1, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value

                celdaSeleccionada.Offset(2, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value

                celdaSeleccionada.Offset(3, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value

                celdaSeleccionada.Offset(4, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value

                celdaSeleccionada.Offset(5, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value

                celdaSeleccionada.Offset(6, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value

                celdaSeleccionada.Offset(7, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value

                celdaSeleccionada.Offset(8, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value

                celdaSeleccionada.Offset(9, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value

            Else
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 1).Value = 0
                    celdaSeleccionada.Offset(j, 2).Value = 0
                    celdaSeleccionada.Offset(j, 3).Value = 0
                Next
            End If

        Else

            'Datos colectivo por telefónica/visita
            dtSumaColectivoAgenteTelefonoVisita = _sesion.Listados.CargarSumaDuracionColectivoAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

            If Not dtDuracionColectivoAgente Is Nothing Then

                Dim columnaConsulta As String = String.Empty
                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar() Then
                    columnaConsulta = Globales.COL_CONSULTAIND_FORMFAM
                Else
                    columnaConsulta = Globales.COL_CONSULTAIND_FORMPER
                End If

                totalColectivoAgente = dtDuracionColectivoAgente.Select(columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                If totalColectivoAgente = 0 Then
                    totalColectivoAgente = 1
                End If

                celdaSeleccionada.Offset(0, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value

                celdaSeleccionada.Offset(1, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value

                celdaSeleccionada.Offset(2, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value

                celdaSeleccionada.Offset(3, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value

                celdaSeleccionada.Offset(4, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value

                celdaSeleccionada.Offset(5, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value

                celdaSeleccionada.Offset(6, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value

                celdaSeleccionada.Offset(7, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value

                celdaSeleccionada.Offset(8, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value

                celdaSeleccionada.Offset(9, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value

            Else
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 1).Value = 0
                    celdaSeleccionada.Offset(j, 2).Value = 0
                    celdaSeleccionada.Offset(j, 3).Value = 0
                Next
            End If

        End If

        hojaExcel.Range("D5:E14").NumberFormat = "#.##0,00"


        dtDuracionFamiliarAgente = _sesion.Listados.CargarDatosDuracionFamiliarAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
        If esIdioma Then
            'Datos Familiar en castellano
            dtSumaFamiliarAgenteCastellano = _sesion.Listados.CargarSumaDuracionFamiliarAgenteCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())


            If Not dtDuracionFamiliarAgente Is Nothing Then

                totalFamiliarAgente = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                If totalFamiliarAgente = 0 Then
                    totalFamiliarAgente = 1
                End If

                celdaSeleccionada.Offset(0, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(0, 5).Value = ((celdaSeleccionada.Offset(0, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(0, 6).Value = celdaSeleccionada.Offset(0, 5).Value

                celdaSeleccionada.Offset(1, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(1, 5).Value = ((celdaSeleccionada.Offset(1, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(1, 6).Value = celdaSeleccionada.Offset(0, 6).Value + celdaSeleccionada.Offset(1, 5).Value

                celdaSeleccionada.Offset(2, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(2, 5).Value = ((celdaSeleccionada.Offset(2, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(2, 6).Value = celdaSeleccionada.Offset(1, 6).Value + celdaSeleccionada.Offset(2, 5).Value

                celdaSeleccionada.Offset(3, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(3, 5).Value = ((celdaSeleccionada.Offset(3, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(3, 6).Value = celdaSeleccionada.Offset(2, 6).Value + celdaSeleccionada.Offset(3, 5).Value

                celdaSeleccionada.Offset(4, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(4, 5).Value = ((celdaSeleccionada.Offset(4, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(4, 6).Value = celdaSeleccionada.Offset(3, 6).Value + celdaSeleccionada.Offset(4, 5).Value

                celdaSeleccionada.Offset(5, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(5, 5).Value = ((celdaSeleccionada.Offset(5, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(5, 6).Value = celdaSeleccionada.Offset(4, 6).Value + celdaSeleccionada.Offset(5, 5).Value

                celdaSeleccionada.Offset(6, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(6, 5).Value = ((celdaSeleccionada.Offset(6, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(6, 6).Value = celdaSeleccionada.Offset(5, 6).Value + celdaSeleccionada.Offset(6, 5).Value

                celdaSeleccionada.Offset(7, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(7, 5).Value = ((celdaSeleccionada.Offset(7, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(7, 6).Value = celdaSeleccionada.Offset(6, 6).Value + celdaSeleccionada.Offset(7, 5).Value

                celdaSeleccionada.Offset(8, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(8, 5).Value = ((celdaSeleccionada.Offset(8, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(8, 6).Value = celdaSeleccionada.Offset(7, 6).Value + celdaSeleccionada.Offset(8, 5).Value

                celdaSeleccionada.Offset(9, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(9, 5).Value = ((celdaSeleccionada.Offset(9, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(9, 6).Value = celdaSeleccionada.Offset(8, 6).Value + celdaSeleccionada.Offset(9, 5).Value

            Else
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 4).Value = 0
                    celdaSeleccionada.Offset(j, 5).Value = 0
                    celdaSeleccionada.Offset(j, 6).Value = 0
                Next
            End If

        Else
            'Datos Familiar por telefónica/visita
            dtSumaFamiliarAgenteTelefonoVisita = _sesion.Listados.CargarSumaDuracionFamiliarAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())


            If Not dtDuracionFamiliarAgente Is Nothing Then

                totalFamiliarAgente = dtDuracionFamiliarAgente.Select(Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                If totalFamiliarAgente = 0 Then
                    totalFamiliarAgente = 1
                End If

                celdaSeleccionada.Offset(0, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(0, 5).Value = ((celdaSeleccionada.Offset(0, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(0, 6).Value = celdaSeleccionada.Offset(0, 5).Value

                celdaSeleccionada.Offset(1, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(1, 5).Value = ((celdaSeleccionada.Offset(1, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(1, 6).Value = celdaSeleccionada.Offset(0, 6).Value + celdaSeleccionada.Offset(1, 5).Value

                celdaSeleccionada.Offset(2, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(2, 5).Value = ((celdaSeleccionada.Offset(2, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(2, 6).Value = celdaSeleccionada.Offset(1, 6).Value + celdaSeleccionada.Offset(2, 5).Value

                celdaSeleccionada.Offset(3, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(3, 5).Value = ((celdaSeleccionada.Offset(3, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(3, 6).Value = celdaSeleccionada.Offset(2, 6).Value + celdaSeleccionada.Offset(3, 5).Value

                celdaSeleccionada.Offset(4, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(4, 5).Value = ((celdaSeleccionada.Offset(4, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(4, 6).Value = celdaSeleccionada.Offset(3, 6).Value + celdaSeleccionada.Offset(4, 5).Value

                celdaSeleccionada.Offset(5, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(5, 5).Value = ((celdaSeleccionada.Offset(5, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(5, 6).Value = celdaSeleccionada.Offset(4, 6).Value + celdaSeleccionada.Offset(5, 5).Value

                celdaSeleccionada.Offset(6, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(6, 5).Value = ((celdaSeleccionada.Offset(6, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(6, 6).Value = celdaSeleccionada.Offset(5, 6).Value + celdaSeleccionada.Offset(6, 5).Value

                celdaSeleccionada.Offset(7, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(7, 5).Value = ((celdaSeleccionada.Offset(7, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(7, 6).Value = celdaSeleccionada.Offset(6, 6).Value + celdaSeleccionada.Offset(7, 5).Value

                celdaSeleccionada.Offset(8, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(8, 5).Value = ((celdaSeleccionada.Offset(8, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(8, 6).Value = celdaSeleccionada.Offset(7, 6).Value + celdaSeleccionada.Offset(8, 5).Value

                celdaSeleccionada.Offset(9, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(9, 5).Value = ((celdaSeleccionada.Offset(9, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(9, 6).Value = celdaSeleccionada.Offset(8, 6).Value + celdaSeleccionada.Offset(9, 5).Value

            Else
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 4).Value = 0
                    celdaSeleccionada.Offset(j, 5).Value = 0
                    celdaSeleccionada.Offset(j, 6).Value = 0
                Next
            End If

        End If



        hojaExcel.Range("G5:H14").NumberFormat = "#.##0,00"


        dtDuracionPersonalAgente = _sesion.Listados.CargarDatosDuracionPersonalAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())
        If esIdioma Then
            'Datos Personal en castellano
            dtSumaPersonalAgenteCastellano = _sesion.Listados.CargarSumaDuracionPersonalAgenteCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())


            If Not dtDuracionPersonalAgente Is Nothing Then

                totalPersonalAgente = dtDuracionPersonalAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                If totalPersonalAgente = 0 Then
                    totalPersonalAgente = 1
                End If

                celdaSeleccionada.Offset(0, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(0, 8).Value = ((celdaSeleccionada.Offset(0, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(0, 9).Value = celdaSeleccionada.Offset(0, 8).Value

                celdaSeleccionada.Offset(1, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(1, 8).Value = ((celdaSeleccionada.Offset(1, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(1, 9).Value = celdaSeleccionada.Offset(0, 9).Value + celdaSeleccionada.Offset(1, 8).Value

                celdaSeleccionada.Offset(2, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(2, 8).Value = ((celdaSeleccionada.Offset(2, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(2, 9).Value = celdaSeleccionada.Offset(1, 9).Value + celdaSeleccionada.Offset(2, 8).Value

                celdaSeleccionada.Offset(3, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(3, 8).Value = ((celdaSeleccionada.Offset(3, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(3, 9).Value = celdaSeleccionada.Offset(2, 9).Value + celdaSeleccionada.Offset(3, 8).Value

                celdaSeleccionada.Offset(4, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(4, 8).Value = ((celdaSeleccionada.Offset(4, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(4, 9).Value = celdaSeleccionada.Offset(3, 9).Value + celdaSeleccionada.Offset(4, 8).Value

                celdaSeleccionada.Offset(5, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(5, 8).Value = ((celdaSeleccionada.Offset(5, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(5, 9).Value = celdaSeleccionada.Offset(4, 9).Value + celdaSeleccionada.Offset(5, 8).Value

                celdaSeleccionada.Offset(6, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(6, 8).Value = ((celdaSeleccionada.Offset(6, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(6, 9).Value = celdaSeleccionada.Offset(5, 9).Value + celdaSeleccionada.Offset(6, 8).Value

                celdaSeleccionada.Offset(7, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(7, 8).Value = ((celdaSeleccionada.Offset(7, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(7, 9).Value = celdaSeleccionada.Offset(6, 9).Value + celdaSeleccionada.Offset(7, 8).Value

                celdaSeleccionada.Offset(8, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(8, 8).Value = ((celdaSeleccionada.Offset(8, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(8, 9).Value = celdaSeleccionada.Offset(7, 9).Value + celdaSeleccionada.Offset(8, 8).Value


                celdaSeleccionada.Offset(9, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(9, 8).Value = ((celdaSeleccionada.Offset(9, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(9, 9).Value = celdaSeleccionada.Offset(8, 9).Value + celdaSeleccionada.Offset(9, 8).Value

            Else
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 7).Value = 0
                    celdaSeleccionada.Offset(j, 8).Value = 0
                    celdaSeleccionada.Offset(j, 9).Value = 0
                Next
            End If
        Else
            'Datos Personal por telefónica/visita
            dtSumaPersonalAgenteTelefonoVisita = _sesion.Listados.CargarSumaDuracionPersonalAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

            If Not dtDuracionPersonalAgente Is Nothing Then

                totalPersonalAgente = dtDuracionPersonalAgente.Select(Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                If totalPersonalAgente = 0 Then
                    totalPersonalAgente = 1
                End If

                celdaSeleccionada.Offset(0, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(0, 8).Value = ((celdaSeleccionada.Offset(0, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(0, 9).Value = celdaSeleccionada.Offset(0, 8).Value

                celdaSeleccionada.Offset(1, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(1, 8).Value = ((celdaSeleccionada.Offset(1, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(1, 9).Value = celdaSeleccionada.Offset(0, 9).Value + celdaSeleccionada.Offset(1, 8).Value

                celdaSeleccionada.Offset(2, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(2, 8).Value = ((celdaSeleccionada.Offset(2, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(2, 9).Value = celdaSeleccionada.Offset(1, 9).Value + celdaSeleccionada.Offset(2, 8).Value

                celdaSeleccionada.Offset(3, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(3, 8).Value = ((celdaSeleccionada.Offset(3, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(3, 9).Value = celdaSeleccionada.Offset(2, 9).Value + celdaSeleccionada.Offset(3, 8).Value

                celdaSeleccionada.Offset(4, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(4, 8).Value = ((celdaSeleccionada.Offset(4, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(4, 9).Value = celdaSeleccionada.Offset(3, 9).Value + celdaSeleccionada.Offset(4, 8).Value

                celdaSeleccionada.Offset(5, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(5, 8).Value = ((celdaSeleccionada.Offset(5, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(5, 9).Value = celdaSeleccionada.Offset(4, 9).Value + celdaSeleccionada.Offset(5, 8).Value

                celdaSeleccionada.Offset(6, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(6, 8).Value = ((celdaSeleccionada.Offset(6, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(6, 9).Value = celdaSeleccionada.Offset(5, 9).Value + celdaSeleccionada.Offset(6, 8).Value

                celdaSeleccionada.Offset(7, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(7, 8).Value = ((celdaSeleccionada.Offset(7, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(7, 9).Value = celdaSeleccionada.Offset(6, 9).Value + celdaSeleccionada.Offset(7, 8).Value

                celdaSeleccionada.Offset(8, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(8, 8).Value = ((celdaSeleccionada.Offset(8, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(8, 9).Value = celdaSeleccionada.Offset(7, 9).Value + celdaSeleccionada.Offset(8, 8).Value


                celdaSeleccionada.Offset(9, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
                celdaSeleccionada.Offset(9, 8).Value = ((celdaSeleccionada.Offset(9, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(9, 9).Value = celdaSeleccionada.Offset(8, 9).Value + celdaSeleccionada.Offset(9, 8).Value

            Else
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 7).Value = 0
                    celdaSeleccionada.Offset(j, 8).Value = 0
                    celdaSeleccionada.Offset(j, 9).Value = 0
                Next
            End If

        End If



        hojaExcel.Range("J5:K14").NumberFormat = "#.##0,00"

        hojaExcel.Range("A4").EntireRow.Insert()
        hojaExcel.Range("C4").Value = GetLocalResourceObject("lblColectivo").ToString()
        hojaExcel.Range("C4:E4").Merge()
        hojaExcel.Range("C4").HorizontalAlignment = xlCenter
        hojaExcel.Range("C4").VerticalAlignment = xlCenter
        hojaExcel.Range("C4").Font.Bold = True
        hojaExcel.Range("F4").Value = GetLocalResourceObject("lblCuestionarioFamiliar").ToString()
        hojaExcel.Range("F4:H4").Merge()
        hojaExcel.Range("F4").HorizontalAlignment = xlCenter
        hojaExcel.Range("F4").VerticalAlignment = xlCenter
        hojaExcel.Range("F4").Font.Bold = True
        hojaExcel.Range("I4").Value = GetLocalResourceObject("lblCuestionarioIndividual").ToString()
        hojaExcel.Range("I4:K4").Merge()
        hojaExcel.Range("I4").HorizontalAlignment = xlCenter
        hojaExcel.Range("I4").VerticalAlignment = xlCenter
        hojaExcel.Range("I4").Font.Bold = True

        'Colectivo
        'hojaExcel.Range("B16").Value = GetLocalResourceObject("lblTotalEncuestas.Text").ToString()
        hojaExcel.Range("B16").Value = GetLocalResourceObject("lblMedia").ToString()
        hojaExcel.Range("B16").HorizontalAlignment = xlLeft

        'hojaExcel.Range("C16").NumberFormat = "#.##0,0"

        If esIdioma Then
            If Not dtSumaColectivoAgenteCastellano Is Nothing Then
                If dtSumaColectivoAgenteCastellano.Rows.Count > 0 Then
                    hojaExcel.Range("C16").Value = Decimal.Round(((dtSumaColectivoAgenteCastellano.Rows(0)(0) / totalColectivoAgente) / 60), 2)
                    hojaExcel.Range("C16").Value = hojaExcel.Range("C16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("C16").Value = 0
                End If
            Else
                hojaExcel.Range("C16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaFamiliarAgenteCastellano Is Nothing Then
                If dtSumaFamiliarAgenteCastellano.Rows.Count > 0 Then
                    hojaExcel.Range("F16").Value = Decimal.Round(((dtSumaFamiliarAgenteCastellano.Rows(0)(0) / totalFamiliarAgente) / 60), 2)
                    hojaExcel.Range("F16").Value = hojaExcel.Range("F16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("F16").Value = 0
                End If
            Else
                hojaExcel.Range("F16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaPersonalAgenteCastellano Is Nothing Then
                If dtSumaPersonalAgenteCastellano.Rows.Count > 0 Then
                    hojaExcel.Range("I16").Value = Decimal.Round(((dtSumaPersonalAgenteCastellano.Rows(0)(0) / totalPersonalAgente) / 60), 2)
                    hojaExcel.Range("I16").Value = hojaExcel.Range("I16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("I16").Value = 0
                End If
            Else
                hojaExcel.Range("I16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If
        Else

            If Not dtSumaColectivoAgenteTelefonoVisita Is Nothing Then
                If dtSumaColectivoAgenteTelefonoVisita.Rows.Count > 0 Then
                    hojaExcel.Range("C16").Value = Decimal.Round(((dtSumaColectivoAgenteTelefonoVisita.Rows(0)(0) / totalColectivoAgente) / 60), 2)
                    hojaExcel.Range("C16").Value = hojaExcel.Range("C16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("C16").Value = 0
                End If
            Else
                hojaExcel.Range("C16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaFamiliarAgenteTelefonoVisita Is Nothing Then
                If dtSumaFamiliarAgenteTelefonoVisita.Rows.Count > 0 Then
                    hojaExcel.Range("F16").Value = Decimal.Round(((dtSumaFamiliarAgenteTelefonoVisita.Rows(0)(0) / totalFamiliarAgente) / 60), 2)
                    hojaExcel.Range("F16").Value = hojaExcel.Range("F16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("F16").Value = 0
                End If
            Else
                hojaExcel.Range("F16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaPersonalAgenteTelefonoVisita Is Nothing Then
                If dtSumaPersonalAgenteTelefonoVisita.Rows.Count > 0 Then
                    hojaExcel.Range("I16").Value = Decimal.Round(((dtSumaPersonalAgenteTelefonoVisita.Rows(0)(0) / totalPersonalAgente) / 60), 2)
                    hojaExcel.Range("I16").Value = hojaExcel.Range("I16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("I16").Value = 0
                End If
            Else
                hojaExcel.Range("I16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

        End If

        hojaExcel.Range("C16").HorizontalAlignment = xlRight
        hojaExcel.Range("F16").HorizontalAlignment = xlRight
        hojaExcel.Range("I16").HorizontalAlignment = xlRight

        hojaExcel.Range("B16:C16").Font.Bold = True
        hojaExcel.Range("F16").Font.Bold = True
        hojaExcel.Range("I16").Font.Bold = True

        hojaExcel.Range("C16").RowHeight = 15
        hojaExcel.Range("C16").ColumnWidth = 13
        hojaExcel.Range("F16").ColumnWidth = 13
        hojaExcel.Range("I16").ColumnWidth = 13

        'hojaExcel.Range("A6:K16").Borders.Weight = Excel.XlBorderWeight.xlMedium
        'hojaExcel.Range("A6:K16").Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone
        'hojaExcel.Range("A6:K16").Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlNone

        hojaExcel.Range("A3:K17").Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlSolid
        hojaExcel.Range("A3:K17").Borders.Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("A6:K17").Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone

        'EUSKERA o WEB
        celdaSeleccionada = hojaExcel.Range("A18")
        If esIdioma Then
            celdaSeleccionada.Value = GetLocalResourceObject("lblEuskera").ToString()
        Else
            celdaSeleccionada.Value = GetLocalResourceObject("lblWeb").ToString()
        End If
        celdaSeleccionada.Font.Bold = True
        celdaSeleccionada.ColumnWidth = 12

        'Dibujar duraciones
        hojaExcel.Range("B18").Value = GetLocalResourceObject("lblDur1").ToString()
        hojaExcel.Range("B19").Value = GetLocalResourceObject("lblDur2").ToString()
        hojaExcel.Range("B20").Value = GetLocalResourceObject("lblDur3").ToString()
        hojaExcel.Range("B21").Value = GetLocalResourceObject("lblDur4").ToString()
        hojaExcel.Range("B22").Value = GetLocalResourceObject("lblDur5").ToString()
        hojaExcel.Range("B23").Value = GetLocalResourceObject("lblDur6").ToString()
        hojaExcel.Range("B24").Value = GetLocalResourceObject("lblDur7").ToString()
        hojaExcel.Range("B25").Value = GetLocalResourceObject("lblDur8").ToString()
        hojaExcel.Range("B26").Value = GetLocalResourceObject("lblDur9").ToString()
        hojaExcel.Range("B27").Value = GetLocalResourceObject("lblDur10").ToString()
        hojaExcel.Range("A18:B27").HorizontalAlignment = xlLeft

        celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

        If esIdioma Then
            'Datos colectivo en euskera
            dtSumaColectivoAgenteEuskera = _sesion.Listados.CargarSumaDuracionColectivoAgenteEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            If Not dtDuracionColectivoAgente Is Nothing Then

                totalColectivoAgente = dtDuracionColectivoAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                If totalColectivoAgente = 0 Then
                    totalColectivoAgente = 1
                End If

                celdaSeleccionada.Offset(0, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value

                celdaSeleccionada.Offset(1, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value

                celdaSeleccionada.Offset(2, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value

                celdaSeleccionada.Offset(3, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value

                celdaSeleccionada.Offset(4, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value

                celdaSeleccionada.Offset(5, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value

                celdaSeleccionada.Offset(6, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value

                celdaSeleccionada.Offset(7, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value

                celdaSeleccionada.Offset(8, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value

                celdaSeleccionada.Offset(9, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / totalColectivoAgente)
                celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value

            Else
                totalColectivoAgente = 1
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 1).Value = 0
                    celdaSeleccionada.Offset(j, 2).Value = 0
                    celdaSeleccionada.Offset(j, 3).Value = 0
                Next
            End If
        Else
            'Datos colectivo por web
            'dtSumaColectivoAgenteWeb = _sesion.Listados.CargarSumaDuracionColectivoAgente(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaColectivoAgenteWeb = Nothing
            dtDuracionColectivoAgente = Nothing

            'If Not dtDuracionColectivoAgente Is Nothing Then

            '    Dim columnaConsulta As String = String.Empty
            '    If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar() Then
            '        columnaConsulta = Globales.COL_CONSULTAIND_FORMFAM
            '    Else
            '        columnaConsulta = Globales.COL_CONSULTAIND_FORMPER
            '    End If

            '    totalColectivoAgente = dtDuracionColectivoAgente.Select(columnaConsulta & " = " & Globales.FORM_WEB).Length
            '    If totalColectivoAgente = 0 Then
            '        totalColectivoAgente = 1
            '    End If

            '    celdaSeleccionada.Offset(0, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / totalColectivoAgente)
            '    celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value

            '    celdaSeleccionada.Offset(1, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / totalColectivoAgente)
            '    celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value

            '    celdaSeleccionada.Offset(2, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / totalColectivoAgente)
            '    celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value

            '    celdaSeleccionada.Offset(3, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / totalColectivoAgente)
            '    celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value

            '    celdaSeleccionada.Offset(4, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / totalColectivoAgente)
            '    celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value

            '    celdaSeleccionada.Offset(5, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / totalColectivoAgente)
            '    celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value

            '    celdaSeleccionada.Offset(6, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / totalColectivoAgente)
            '    celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value

            '    celdaSeleccionada.Offset(7, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / totalColectivoAgente)
            '    celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value

            '    celdaSeleccionada.Offset(8, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / totalColectivoAgente)
            '    celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value

            '    celdaSeleccionada.Offset(9, 1).Value = dtDuracionColectivoAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / totalColectivoAgente)
            '    celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value

            'Else
            totalColectivoAgente = 1
            For j As Integer = 0 To 9
                celdaSeleccionada.Offset(j, 1).Value = 0
                celdaSeleccionada.Offset(j, 2).Value = 0
                celdaSeleccionada.Offset(j, 3).Value = 0
            Next
            'End If
        End If


        hojaExcel.Range("D18:E27").NumberFormat = "#.##0,00"
        'hojaExcel.Range("C6:C31").HorizontalAlignment = xlRight


        If esIdioma Then
            'Datos Familiar en euskera
            dtSumaFamiliarAgenteEuskera = _sesion.Listados.CargarSumaDuracionFamiliarAgenteEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            If Not dtDuracionFamiliarAgente Is Nothing Then

                totalFamiliarAgente = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                If totalFamiliarAgente = 0 Then
                    totalFamiliarAgente = 1
                End If

                celdaSeleccionada.Offset(0, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(0, 5).Value = ((celdaSeleccionada.Offset(0, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(0, 6).Value = celdaSeleccionada.Offset(0, 5).Value

                celdaSeleccionada.Offset(1, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(1, 5).Value = ((celdaSeleccionada.Offset(1, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(1, 6).Value = celdaSeleccionada.Offset(0, 6).Value + celdaSeleccionada.Offset(1, 5).Value

                celdaSeleccionada.Offset(2, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(2, 5).Value = ((celdaSeleccionada.Offset(2, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(2, 6).Value = celdaSeleccionada.Offset(1, 6).Value + celdaSeleccionada.Offset(2, 5).Value

                celdaSeleccionada.Offset(3, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(3, 5).Value = ((celdaSeleccionada.Offset(3, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(3, 6).Value = celdaSeleccionada.Offset(2, 6).Value + celdaSeleccionada.Offset(3, 5).Value

                celdaSeleccionada.Offset(4, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(4, 5).Value = ((celdaSeleccionada.Offset(4, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(4, 6).Value = celdaSeleccionada.Offset(3, 6).Value + celdaSeleccionada.Offset(4, 5).Value

                celdaSeleccionada.Offset(5, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(5, 5).Value = ((celdaSeleccionada.Offset(5, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(5, 6).Value = celdaSeleccionada.Offset(4, 6).Value + celdaSeleccionada.Offset(5, 5).Value

                celdaSeleccionada.Offset(6, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(6, 5).Value = ((celdaSeleccionada.Offset(6, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(6, 6).Value = celdaSeleccionada.Offset(5, 6).Value + celdaSeleccionada.Offset(6, 5).Value

                celdaSeleccionada.Offset(7, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(7, 5).Value = ((celdaSeleccionada.Offset(7, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(7, 6).Value = celdaSeleccionada.Offset(6, 6).Value + celdaSeleccionada.Offset(7, 5).Value

                celdaSeleccionada.Offset(8, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(8, 5).Value = ((celdaSeleccionada.Offset(8, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(8, 6).Value = celdaSeleccionada.Offset(7, 6).Value + celdaSeleccionada.Offset(8, 5).Value

                celdaSeleccionada.Offset(9, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(9, 5).Value = ((celdaSeleccionada.Offset(9, 4).Value * 100) / totalFamiliarAgente)
                celdaSeleccionada.Offset(9, 6).Value = celdaSeleccionada.Offset(8, 6).Value + celdaSeleccionada.Offset(9, 5).Value

            Else
                totalFamiliarAgente = 1
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 4).Value = 0
                    celdaSeleccionada.Offset(j, 5).Value = 0
                    celdaSeleccionada.Offset(j, 6).Value = 0
                Next
            End If
        Else
            'Datos Familiar por web
            ' dtSumaFamiliarAgenteWeb = _sesion.Listados.CargarSumaDuracionFamiliarAgente(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaFamiliarAgenteWeb = Nothing
            dtDuracionFamiliarAgente = Nothing
            'If Not dtDuracionFamiliarAgente Is Nothing Then

            '    totalFamiliarAgente = dtDuracionFamiliarAgente.Select(Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            '    If totalFamiliarAgente = 0 Then
            '        totalFamiliarAgente = 1
            '    End If

            '    celdaSeleccionada.Offset(0, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(0, 5).Value = ((celdaSeleccionada.Offset(0, 4).Value * 100) / totalFamiliarAgente)
            '    celdaSeleccionada.Offset(0, 6).Value = celdaSeleccionada.Offset(0, 5).Value

            '    celdaSeleccionada.Offset(1, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(1, 5).Value = ((celdaSeleccionada.Offset(1, 4).Value * 100) / totalFamiliarAgente)
            '    celdaSeleccionada.Offset(1, 6).Value = celdaSeleccionada.Offset(0, 6).Value + celdaSeleccionada.Offset(1, 5).Value

            '    celdaSeleccionada.Offset(2, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(2, 5).Value = ((celdaSeleccionada.Offset(2, 4).Value * 100) / totalFamiliarAgente)
            '    celdaSeleccionada.Offset(2, 6).Value = celdaSeleccionada.Offset(1, 6).Value + celdaSeleccionada.Offset(2, 5).Value

            '    celdaSeleccionada.Offset(3, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(3, 5).Value = ((celdaSeleccionada.Offset(3, 4).Value * 100) / totalFamiliarAgente)
            '    celdaSeleccionada.Offset(3, 6).Value = celdaSeleccionada.Offset(2, 6).Value + celdaSeleccionada.Offset(3, 5).Value

            '    celdaSeleccionada.Offset(4, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(4, 5).Value = ((celdaSeleccionada.Offset(4, 4).Value * 100) / totalFamiliarAgente)
            '    celdaSeleccionada.Offset(4, 6).Value = celdaSeleccionada.Offset(3, 6).Value + celdaSeleccionada.Offset(4, 5).Value

            '    celdaSeleccionada.Offset(5, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(5, 5).Value = ((celdaSeleccionada.Offset(5, 4).Value * 100) / totalFamiliarAgente)
            '    celdaSeleccionada.Offset(5, 6).Value = celdaSeleccionada.Offset(4, 6).Value + celdaSeleccionada.Offset(5, 5).Value

            '    celdaSeleccionada.Offset(6, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(6, 5).Value = ((celdaSeleccionada.Offset(6, 4).Value * 100) / totalFamiliarAgente)
            '    celdaSeleccionada.Offset(6, 6).Value = celdaSeleccionada.Offset(5, 6).Value + celdaSeleccionada.Offset(6, 5).Value

            '    celdaSeleccionada.Offset(7, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(7, 5).Value = ((celdaSeleccionada.Offset(7, 4).Value * 100) / totalFamiliarAgente)
            '    celdaSeleccionada.Offset(7, 6).Value = celdaSeleccionada.Offset(6, 6).Value + celdaSeleccionada.Offset(7, 5).Value

            '    celdaSeleccionada.Offset(8, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(8, 5).Value = ((celdaSeleccionada.Offset(8, 4).Value * 100) / totalFamiliarAgente)
            '    celdaSeleccionada.Offset(8, 6).Value = celdaSeleccionada.Offset(7, 6).Value + celdaSeleccionada.Offset(8, 5).Value

            '    celdaSeleccionada.Offset(9, 4).Value = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(9, 5).Value = ((celdaSeleccionada.Offset(9, 4).Value * 100) / totalFamiliarAgente)
            '    celdaSeleccionada.Offset(9, 6).Value = celdaSeleccionada.Offset(8, 6).Value + celdaSeleccionada.Offset(9, 5).Value

            'Else
            totalFamiliarAgente = 1
            For j As Integer = 0 To 9
                celdaSeleccionada.Offset(j, 4).Value = 0
                celdaSeleccionada.Offset(j, 5).Value = 0
                celdaSeleccionada.Offset(j, 6).Value = 0
            Next
            'End If
        End If



        hojaExcel.Range("G18:H27").NumberFormat = "#.##0,00"
        'hojaExcel.Range("F6:F31").HorizontalAlignment = xlRight

        If esIdioma Then
            'Datos Personal en euskera
            dtSumaPersonalAgenteEuskera = _sesion.Listados.CargarSumaDuracionPersonalAgenteEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())
            If Not dtDuracionPersonalAgente Is Nothing Then

                totalPersonalAgente = dtDuracionPersonalAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                If totalPersonalAgente = 0 Then
                    totalPersonalAgente = 1
                End If

                celdaSeleccionada.Offset(0, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(0, 8).Value = ((celdaSeleccionada.Offset(0, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(0, 9).Value = celdaSeleccionada.Offset(0, 8).Value

                celdaSeleccionada.Offset(1, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(1, 8).Value = ((celdaSeleccionada.Offset(1, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(1, 9).Value = celdaSeleccionada.Offset(0, 9).Value + celdaSeleccionada.Offset(1, 8).Value

                celdaSeleccionada.Offset(2, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(2, 8).Value = ((celdaSeleccionada.Offset(2, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(2, 9).Value = celdaSeleccionada.Offset(1, 9).Value + celdaSeleccionada.Offset(2, 8).Value

                celdaSeleccionada.Offset(3, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(3, 8).Value = ((celdaSeleccionada.Offset(3, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(3, 9).Value = celdaSeleccionada.Offset(2, 9).Value + celdaSeleccionada.Offset(3, 8).Value

                celdaSeleccionada.Offset(4, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(4, 8).Value = ((celdaSeleccionada.Offset(4, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(4, 9).Value = celdaSeleccionada.Offset(3, 9).Value + celdaSeleccionada.Offset(4, 8).Value

                celdaSeleccionada.Offset(5, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(5, 8).Value = ((celdaSeleccionada.Offset(5, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(5, 9).Value = celdaSeleccionada.Offset(4, 9).Value + celdaSeleccionada.Offset(5, 8).Value

                celdaSeleccionada.Offset(6, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(6, 8).Value = ((celdaSeleccionada.Offset(6, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(6, 9).Value = celdaSeleccionada.Offset(5, 9).Value + celdaSeleccionada.Offset(6, 8).Value

                celdaSeleccionada.Offset(7, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(7, 8).Value = ((celdaSeleccionada.Offset(7, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(7, 9).Value = celdaSeleccionada.Offset(6, 9).Value + celdaSeleccionada.Offset(7, 8).Value

                celdaSeleccionada.Offset(8, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(8, 8).Value = ((celdaSeleccionada.Offset(8, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(8, 9).Value = celdaSeleccionada.Offset(7, 9).Value + celdaSeleccionada.Offset(8, 8).Value


                celdaSeleccionada.Offset(9, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(9, 8).Value = ((celdaSeleccionada.Offset(9, 7).Value * 100) / totalPersonalAgente)
                celdaSeleccionada.Offset(9, 9).Value = celdaSeleccionada.Offset(8, 9).Value + celdaSeleccionada.Offset(9, 8).Value

            Else
                totalPersonalAgente = 1
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 7).Value = 0
                    celdaSeleccionada.Offset(j, 8).Value = 0
                    celdaSeleccionada.Offset(j, 9).Value = 0
                Next
            End If
        Else
            'Datos Personal por Web
            ' dtSumaPersonalAgenteEuskera = _sesion.Listados.CargarSumaDuracionPersonalAgente(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())
            dtSumaPersonalAgenteEuskera = Nothing
            dtDuracionPersonalAgente = Nothing
            'If Not dtDuracionPersonalAgente Is Nothing Then

            '    totalPersonalAgente = dtDuracionPersonalAgente.Select(Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            '    If totalPersonalAgente = 0 Then
            '        totalPersonalAgente = 1
            '    End If

            '    celdaSeleccionada.Offset(0, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur1 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(0, 8).Value = ((celdaSeleccionada.Offset(0, 7).Value * 100) / totalPersonalAgente)
            '    celdaSeleccionada.Offset(0, 9).Value = celdaSeleccionada.Offset(0, 8).Value

            '    celdaSeleccionada.Offset(1, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(1, 8).Value = ((celdaSeleccionada.Offset(1, 7).Value * 100) / totalPersonalAgente)
            '    celdaSeleccionada.Offset(1, 9).Value = celdaSeleccionada.Offset(0, 9).Value + celdaSeleccionada.Offset(1, 8).Value

            '    celdaSeleccionada.Offset(2, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(2, 8).Value = ((celdaSeleccionada.Offset(2, 7).Value * 100) / totalPersonalAgente)
            '    celdaSeleccionada.Offset(2, 9).Value = celdaSeleccionada.Offset(1, 9).Value + celdaSeleccionada.Offset(2, 8).Value

            '    celdaSeleccionada.Offset(3, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(3, 8).Value = ((celdaSeleccionada.Offset(3, 7).Value * 100) / totalPersonalAgente)
            '    celdaSeleccionada.Offset(3, 9).Value = celdaSeleccionada.Offset(2, 9).Value + celdaSeleccionada.Offset(3, 8).Value

            '    celdaSeleccionada.Offset(4, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(4, 8).Value = ((celdaSeleccionada.Offset(4, 7).Value * 100) / totalPersonalAgente)
            '    celdaSeleccionada.Offset(4, 9).Value = celdaSeleccionada.Offset(3, 9).Value + celdaSeleccionada.Offset(4, 8).Value

            '    celdaSeleccionada.Offset(5, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(5, 8).Value = ((celdaSeleccionada.Offset(5, 7).Value * 100) / totalPersonalAgente)
            '    celdaSeleccionada.Offset(5, 9).Value = celdaSeleccionada.Offset(4, 9).Value + celdaSeleccionada.Offset(5, 8).Value

            '    celdaSeleccionada.Offset(6, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(6, 8).Value = ((celdaSeleccionada.Offset(6, 7).Value * 100) / totalPersonalAgente)
            '    celdaSeleccionada.Offset(6, 9).Value = celdaSeleccionada.Offset(5, 9).Value + celdaSeleccionada.Offset(6, 8).Value

            '    celdaSeleccionada.Offset(7, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(7, 8).Value = ((celdaSeleccionada.Offset(7, 7).Value * 100) / totalPersonalAgente)
            '    celdaSeleccionada.Offset(7, 9).Value = celdaSeleccionada.Offset(6, 9).Value + celdaSeleccionada.Offset(7, 8).Value

            '    celdaSeleccionada.Offset(8, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(8, 8).Value = ((celdaSeleccionada.Offset(8, 7).Value * 100) / totalPersonalAgente)
            '    celdaSeleccionada.Offset(8, 9).Value = celdaSeleccionada.Offset(7, 9).Value + celdaSeleccionada.Offset(8, 8).Value


            '    celdaSeleccionada.Offset(9, 7).Value = dtDuracionPersonalAgente.Select(Globales.COL_CUESTIONARIO_DURACION_AG & " > " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            '    celdaSeleccionada.Offset(9, 8).Value = ((celdaSeleccionada.Offset(9, 7).Value * 100) / totalPersonalAgente)
            '    celdaSeleccionada.Offset(9, 9).Value = celdaSeleccionada.Offset(8, 9).Value + celdaSeleccionada.Offset(9, 8).Value

            'Else
            totalPersonalAgente = 1
            For j As Integer = 0 To 9
                celdaSeleccionada.Offset(j, 7).Value = 0
                celdaSeleccionada.Offset(j, 8).Value = 0
                celdaSeleccionada.Offset(j, 9).Value = 0
            Next
            'End If
        End If

        hojaExcel.Range("J18:K27").NumberFormat = "#.##0,00"
        hojaExcel.Range("C6:K31").HorizontalAlignment = xlRight

        'Colectivo
        'hojaExcel.Range("B30").Value = GetLocalResourceObject("lblTotalEncuestas.Text").ToString()
        hojaExcel.Range("B28").Value = GetLocalResourceObject("lblMedia").ToString()
        hojaExcel.Range("B28").HorizontalAlignment = xlLeft

        If esIdioma Then
            If Not dtSumaColectivoAgenteEuskera Is Nothing Then
                If dtSumaColectivoAgenteEuskera.Rows.Count > 0 Then
                    hojaExcel.Range("C28").Value = Decimal.Round(((dtSumaColectivoAgenteEuskera.Rows(0)(0) / totalColectivoAgente) / 60), 2)
                    hojaExcel.Range("C28").Value = hojaExcel.Range("C28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("C28").Value = 0
                End If
            Else
                hojaExcel.Range("C28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaFamiliarAgenteEuskera Is Nothing Then
                If dtSumaFamiliarAgenteEuskera.Rows.Count > 0 Then
                    hojaExcel.Range("F28").Value = Decimal.Round(((dtSumaFamiliarAgenteEuskera.Rows(0)(0) / totalFamiliarAgente) / 60), 2)
                    hojaExcel.Range("F28").Value = hojaExcel.Range("F28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("F28").Value = 0
                End If
            Else
                hojaExcel.Range("F28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaPersonalAgenteEuskera Is Nothing Then
                If dtSumaPersonalAgenteEuskera.Rows.Count > 0 Then
                    hojaExcel.Range("I28").Value = Decimal.Round(((dtSumaPersonalAgenteEuskera.Rows(0)(0) / totalPersonalAgente) / 60), 2)
                    hojaExcel.Range("I28").Value = hojaExcel.Range("I28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("I28").Value = 0
                End If
            Else
                hojaExcel.Range("I28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If
        Else

            If Not dtSumaColectivoAgenteWeb Is Nothing Then
                If dtSumaColectivoAgenteWeb.Rows.Count > 0 Then
                    hojaExcel.Range("C28").Value = Decimal.Round(((dtSumaColectivoAgenteWeb.Rows(0)(0) / totalColectivoAgente) / 60), 2)
                    hojaExcel.Range("C28").Value = hojaExcel.Range("C28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("C28").Value = 0
                End If
            Else
                hojaExcel.Range("C28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaFamiliarAgenteWeb Is Nothing Then
                If dtSumaFamiliarAgenteWeb.Rows.Count > 0 Then
                    hojaExcel.Range("F28").Value = Decimal.Round(((dtSumaFamiliarAgenteWeb.Rows(0)(0) / totalFamiliarAgente) / 60), 2)
                    hojaExcel.Range("F28").Value = hojaExcel.Range("F28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("F28").Value = 0
                End If
            Else
                hojaExcel.Range("F28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaPersonalAgenteWeb Is Nothing Then
                If dtSumaPersonalAgenteWeb.Rows.Count > 0 Then
                    hojaExcel.Range("I28").Value = Decimal.Round(((dtSumaPersonalAgenteWeb.Rows(0)(0) / totalPersonalAgente) / 60), 2)
                    hojaExcel.Range("I28").Value = hojaExcel.Range("I28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("I28").Value = 0
                End If
            Else
                hojaExcel.Range("I28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

        End If

        hojaExcel.Range("C28").HorizontalAlignment = xlRight
        hojaExcel.Range("F28").HorizontalAlignment = xlRight
        hojaExcel.Range("I28").HorizontalAlignment = xlRight

        hojaExcel.Range("B28:C28").Font.Bold = True
        hojaExcel.Range("F28").Font.Bold = True
        hojaExcel.Range("I28").Font.Bold = True

        'hojaExcel.Range("A18:K28").Borders.Weight = Excel.XlBorderWeight.xlMedium
        'hojaExcel.Range("A18:K28").Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone
        'hojaExcel.Range("A18:K28").Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlNone

        hojaExcel.Range("A18:K29").Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlSolid
        hojaExcel.Range("A18:K29").Borders.Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("A18:K29").Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone

        'hojaExcel.Activate()
    End Sub


    Private Sub dibujarAgenteVivienda(ByVal hojaExcel As Excel.Worksheet, ByVal libroexcel As Excel.Workbook, ByVal esIdioma As Boolean)
        Dim dur1 As Integer = 300
        Dim dur2 As Integer = 600
        Dim dur3 As Integer = 900
        Dim dur4 As Integer = 1200
        Dim dur5 As Integer = 1500
        Dim dur6 As Integer = 1800
        Dim dur7 As Integer = 2100
        Dim dur8 As Integer = 2400
        Dim dur9 As Integer = 2700

        Dim dtSumaColectivoAgenteCastellano As System.Data.DataTable
        Dim dtSumaFamiliarAgenteCastellano As System.Data.DataTable
        Dim dtSumaPersonalAgenteCastellano As System.Data.DataTable

        Dim dtSumaColectivoAgenteEuskera As System.Data.DataTable
        Dim dtSumaFamiliarAgenteEuskera As System.Data.DataTable
        Dim dtSumaPersonalAgenteEuskera As System.Data.DataTable

        Dim totalColectivoAgenteCastellano As Integer
        Dim totalFamiliarAgenteCastellano As Integer
        Dim totalPersonalAgenteCastellano As Integer

        Dim totalColectivoAgenteEuskera As Integer
        Dim totalFamiliarAgenteEuskera As Integer
        Dim totalPersonalAgenteEuskera As Integer

        Dim dtSumaColectivoAgenteTelefonoVisita As System.Data.DataTable
        Dim dtSumaFamiliarAgenteTelefonoVisita As System.Data.DataTable
        Dim dtSumaPersonalAgenteTelefonoVisita As System.Data.DataTable

        Dim dtSumaColectivoAgenteWeb As System.Data.DataTable
        Dim dtSumaFamiliarAgenteWeb As System.Data.DataTable
        Dim dtSumaPersonalAgenteWeb As System.Data.DataTable

        Dim totalColectivoAgenteTelefonoVisita As Integer
        Dim totalFamiliarAgenteTelefonoVisita As Integer
        Dim totalPersonalAgenteTelefonoVisita As Integer

        Dim denominador As Integer
        Dim suma As Integer

        Dim celdaSeleccionada As Excel.Range
        If cbEncuesta.Checked Then
            celdaSeleccionada = hojaExcel.Range("A32")
        Else
            celdaSeleccionada = hojaExcel.Range("A4")
        End If

        celdaSeleccionada.Offset(0, 2).Value = GetLocalResourceObject("lblDuracionVivienda").ToString().ToUpper()
        celdaSeleccionada.Offset(0, 2).Font.Bold = True

        Dim desde As Object = celdaSeleccionada.Offset(0, 2)
        Dim hasta As Object = celdaSeleccionada.Offset(0, 4)
        hojaExcel.Range(desde, hasta).Merge()
        celdaSeleccionada.Offset(0, 2).RowHeight = 30
        celdaSeleccionada.Offset(0, 2).HorizontalAlignment = xlCenter
        celdaSeleccionada.Offset(0, 2).VerticalAlignment = xlCenter

        desde = celdaSeleccionada.Offset(0, 0)

        'CASTELLANO o TELEFONO/VISITA
        If esIdioma Then
            celdaSeleccionada.Offset(1, 0).Value = GetLocalResourceObject("rbIdiomaResource1.Text").ToString().ToUpper()
        Else
            celdaSeleccionada.Offset(1, 0).Value = GetLocalResourceObject("lblForma").ToString()
        End If
        celdaSeleccionada.Offset(1, 0).Font.Bold = True
        celdaSeleccionada.Offset(1, 0).HorizontalAlignment = xlLeft
        celdaSeleccionada.Offset(1, 0).VerticalAlignment = xlBottom

        celdaSeleccionada.Offset(1, 1).Value = GetLocalResourceObject("lblDuracion").ToString().ToUpper()
        celdaSeleccionada.Offset(1, 1).Font.Bold = True
        celdaSeleccionada.Offset(1, 1).HorizontalAlignment = xlLeft
        celdaSeleccionada.Offset(1, 1).VerticalAlignment = xlCenter

        If esIdioma Then
            celdaSeleccionada.Offset(2, 0).Value = GetLocalResourceObject("lblCastellano").ToString()
        Else
            celdaSeleccionada.Offset(2, 0).Value = GetLocalResourceObject("lblTelefonicaVisita").ToString()
        End If
        celdaSeleccionada.Offset(2, 0).Font.Bold = True
        celdaSeleccionada.Offset(2, 0).ColumnWidth = 12
        celdaSeleccionada.Offset(2, 0).HorizontalAlignment = xlLeft
        celdaSeleccionada.Offset(2, 0).VerticalAlignment = xlBottom

        celdaSeleccionada.Offset(1, 2).Value = GetLocalResourceObject("lblNumero").ToString()
        celdaSeleccionada.Offset(1, 3).Value = "%"
        celdaSeleccionada.Offset(1, 4).Value = GetLocalResourceObject("lblAcumulado").ToString()

        hojaExcel.Range(celdaSeleccionada.Offset(1, 2), celdaSeleccionada.Offset(1, 4)).HorizontalAlignment = xlCenter
        hojaExcel.Range(celdaSeleccionada.Offset(1, 2), celdaSeleccionada.Offset(1, 4)).VerticalAlignment = xlCenter
        hojaExcel.Range(celdaSeleccionada.Offset(1, 2), celdaSeleccionada.Offset(1, 4)).Font.Bold = True

        'Dibujar duraciones
        celdaSeleccionada.Offset(2, 1).ColumnWidth = 25
        celdaSeleccionada.Offset(2, 1).Value = GetLocalResourceObject("lblDur1").ToString()
        celdaSeleccionada.Offset(3, 1).Value = GetLocalResourceObject("lblDur2").ToString()
        celdaSeleccionada.Offset(4, 1).Value = GetLocalResourceObject("lblDur3").ToString()
        celdaSeleccionada.Offset(5, 1).Value = GetLocalResourceObject("lblDur4").ToString()
        celdaSeleccionada.Offset(6, 1).Value = GetLocalResourceObject("lblDur5").ToString()
        celdaSeleccionada.Offset(7, 1).Value = GetLocalResourceObject("lblDur6").ToString()
        celdaSeleccionada.Offset(8, 1).Value = GetLocalResourceObject("lblDur7").ToString()
        celdaSeleccionada.Offset(9, 1).Value = GetLocalResourceObject("lblDur8").ToString()
        celdaSeleccionada.Offset(10, 1).Value = GetLocalResourceObject("lblDur9").ToString()
        celdaSeleccionada.Offset(11, 1).Value = GetLocalResourceObject("lblDur10").ToString()
        hojaExcel.Range(celdaSeleccionada.Offset(2, 1), celdaSeleccionada.Offset(11, 1)).HorizontalAlignment = xlLeft

        celdaSeleccionada = celdaSeleccionada.Offset(2, 1)

        Dim dtDuracionColectivoAgente As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionColectivoAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
        Dim dtDuracionFamiliarAgente As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionFamiliarAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
        Dim dtDuracionPersonalAgente As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionPersonalAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())




        If esIdioma Then

            Dim dtDuracionAgenteFinalizadas As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionAgenteIdiomaFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual(), Globales.C_IDIOMA_CASTELLANO)

            'Datos de la vivienda en castellano
            dtSumaColectivoAgenteCastellano = _sesion.Listados.CargarSumaDuracionColectivoAgenteCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

            dtSumaFamiliarAgenteCastellano = _sesion.Listados.CargarSumaDuracionFamiliarAgenteCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

            dtSumaPersonalAgenteCastellano = _sesion.Listados.CargarSumaDuracionPersonalAgenteCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

            Dim totalDuracionViviendaAgenteCastellano As Integer = 0
            If Not dtSumaColectivoAgenteCastellano Is Nothing Then
                totalDuracionViviendaAgenteCastellano = totalDuracionViviendaAgenteCastellano + dtSumaColectivoAgenteCastellano.Rows(0)(0)
            End If
            If Not dtSumaFamiliarAgenteCastellano Is Nothing Then
                totalDuracionViviendaAgenteCastellano = totalDuracionViviendaAgenteCastellano + dtSumaFamiliarAgenteCastellano.Rows(0)(0)
            End If
            If Not dtSumaPersonalAgenteCastellano Is Nothing Then
                totalDuracionViviendaAgenteCastellano = totalDuracionViviendaAgenteCastellano + dtSumaPersonalAgenteCastellano.Rows(0)(0)
            End If

            If Not dtDuracionColectivoAgente Is Nothing Then
                totalColectivoAgenteCastellano = dtDuracionColectivoAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
            Else
                totalColectivoAgenteCastellano = 0
            End If

            If Not dtDuracionFamiliarAgente Is Nothing Then
                totalFamiliarAgenteCastellano = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
            Else
                totalFamiliarAgenteCastellano = 0
            End If

            If Not dtDuracionPersonalAgente Is Nothing Then
                totalPersonalAgenteCastellano = dtDuracionPersonalAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
            Else
                totalPersonalAgenteCastellano = 0
            End If

            denominador = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                denominador = dtDuracionAgenteFinalizadas.Rows.Count
            End If
            If denominador = 0 Then
                denominador = 1
            End If


            Dim denominadorPorcentaje = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                denominadorPorcentaje = dtDuracionAgenteFinalizadas.Rows.Count
            End If
            If denominadorPorcentaje = 0 Then denominadorPorcentaje = 1

            celdaSeleccionada.Offset(0, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(0, 1).Value = celdaSeleccionada.Offset(0, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur1).Length
            End If
            celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value


            celdaSeleccionada.Offset(1, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(1, 1).Value = celdaSeleccionada.Offset(1, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur1 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur2).Length
            End If
            celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value


            celdaSeleccionada.Offset(2, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(2, 1).Value = celdaSeleccionada.Offset(2, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur2 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur3).Length
            End If
            celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value


            celdaSeleccionada.Offset(3, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(3, 1).Value = celdaSeleccionada.Offset(3, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur3 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur4).Length
            End If
            celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value


            celdaSeleccionada.Offset(4, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(4, 1).Value = celdaSeleccionada.Offset(4, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur4 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur5).Length
            End If
            celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value


            celdaSeleccionada.Offset(5, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(5, 1).Value = celdaSeleccionada.Offset(5, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur5 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur6).Length
            End If
            celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value


            celdaSeleccionada.Offset(6, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(6, 1).Value = celdaSeleccionada.Offset(6, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur6 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur7).Length
            End If
            celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value


            celdaSeleccionada.Offset(7, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(7, 1).Value = celdaSeleccionada.Offset(7, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur7 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur8).Length
            End If
            celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value


            celdaSeleccionada.Offset(8, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(8, 1).Value = celdaSeleccionada.Offset(8, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur8 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur9).Length
            End If
            celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value


            celdaSeleccionada.Offset(9, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(9, 1).Value = celdaSeleccionada.Offset(9, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur9).Length
            End If
            celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value

        Else

            'Datos de la vivienda por telefonica/visita
            dtSumaColectivoAgenteTelefonoVisita = _sesion.Listados.CargarSumaDuracionColectivoAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

            dtSumaFamiliarAgenteTelefonoVisita = _sesion.Listados.CargarSumaDuracionFamiliarAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

            dtSumaPersonalAgenteTelefonoVisita = _sesion.Listados.CargarSumaDuracionPersonalAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

            Dim columnaConsulta As String = String.Empty
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar() Then
                columnaConsulta = Globales.COL_CONSULTAIND_FORMFAM
            Else
                columnaConsulta = Globales.COL_CONSULTAIND_FORMPER
            End If

            If Not dtDuracionColectivoAgente Is Nothing Then
                totalColectivoAgenteTelefonoVisita = dtDuracionColectivoAgente.Select(columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            Else
                totalColectivoAgenteTelefonoVisita = 0
            End If

            If Not dtDuracionFamiliarAgente Is Nothing Then
                totalFamiliarAgenteTelefonoVisita = dtDuracionFamiliarAgente.Select(Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            Else
                totalFamiliarAgenteTelefonoVisita = 0
            End If

            If Not dtDuracionPersonalAgente Is Nothing Then
                totalPersonalAgenteTelefonoVisita = dtDuracionPersonalAgente.Select(Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            Else
                totalPersonalAgenteTelefonoVisita = 0
            End If

            denominador = 0
            Dim dtDuracionAgenteFinalizadas As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionAgenteIdiomaFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual(), String.Empty)
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                denominador = dtDuracionAgenteFinalizadas.Rows.Count
            End If
            If denominador = 0 Then
                denominador = 1
            End If



            Dim denominadorPorcentaje = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                denominadorPorcentaje = dtDuracionAgenteFinalizadas.Rows.Count
            End If
            If denominadorPorcentaje = 0 Then denominadorPorcentaje = 1


            celdaSeleccionada.Offset(0, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(0, 1).Value = celdaSeleccionada.Offset(0, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur1).Length
            End If
            celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value


            celdaSeleccionada.Offset(1, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(1, 1).Value = celdaSeleccionada.Offset(1, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur1 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur2).Length
            End If
            celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value


            celdaSeleccionada.Offset(2, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(2, 1).Value = celdaSeleccionada.Offset(2, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur2 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur3).Length
            End If
            celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value


            celdaSeleccionada.Offset(3, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(3, 1).Value = celdaSeleccionada.Offset(3, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur3 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur4).Length
            End If
            celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value


            celdaSeleccionada.Offset(4, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(4, 1).Value = celdaSeleccionada.Offset(4, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur4 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur5).Length
            End If
            celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value


            celdaSeleccionada.Offset(5, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(5, 1).Value = celdaSeleccionada.Offset(5, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur5 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur6).Length
            End If
            celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value


            celdaSeleccionada.Offset(6, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(6, 1).Value = celdaSeleccionada.Offset(6, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur6 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur7).Length
            End If
            celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value


            celdaSeleccionada.Offset(7, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(7, 1).Value = celdaSeleccionada.Offset(7, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur7 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur8).Length
            End If
            celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value


            celdaSeleccionada.Offset(8, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(8, 1).Value = celdaSeleccionada.Offset(8, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur8 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur9).Length
            End If
            celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value


            celdaSeleccionada.Offset(9, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(9, 1).Value = celdaSeleccionada.Offset(9, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur9).Length
            End If
            celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value


        End If



        hojaExcel.Range(celdaSeleccionada.Offset(0, 2), celdaSeleccionada.Offset(9, 3)).NumberFormat = "#.##0,00"
        hojaExcel.Range(celdaSeleccionada.Offset(0, 1), celdaSeleccionada.Offset(9, 3)).HorizontalAlignment = xlRight

        'Media
        celdaSeleccionada.Offset(10, 0).Value = GetLocalResourceObject("lblMedia").ToString()
        celdaSeleccionada.Offset(10, 0).HorizontalAlignment = xlLeft

        ' celdaSeleccionada.Offset(11, 0).EntireRow.Delete()

        If esIdioma Then
            dtSumaColectivoAgenteCastellano = _sesion.Listados.CargarSumaDuracionColectivoAgenteCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaFamiliarAgenteCastellano = _sesion.Listados.CargarSumaDuracionFamiliarAgenteCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaPersonalAgenteCastellano = _sesion.Listados.CargarSumaDuracionPersonalAgenteCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

            suma = 0
            If Not dtSumaColectivoAgenteCastellano Is Nothing Then
                suma = suma + dtSumaColectivoAgenteCastellano.Rows(0)(0)
            End If
            If Not dtSumaFamiliarAgenteCastellano Is Nothing Then
                suma = suma + dtSumaFamiliarAgenteCastellano.Rows(0)(0)
            End If
            If Not dtSumaPersonalAgenteCastellano Is Nothing Then
                suma = suma + dtSumaPersonalAgenteCastellano.Rows(0)(0)
            End If

            celdaSeleccionada.Offset(10, 1).Value = Decimal.Round(((Decimal.Round(suma, 2) / Decimal.Round(denominador, 2)) / 60), 2)
        Else
            dtSumaColectivoAgenteTelefonoVisita = _sesion.Listados.CargarSumaDuracionColectivoAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaFamiliarAgenteTelefonoVisita = _sesion.Listados.CargarSumaDuracionFamiliarAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaPersonalAgenteTelefonoVisita = _sesion.Listados.CargarSumaDuracionPersonalAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

            suma = 0
            If Not dtSumaColectivoAgenteTelefonoVisita Is Nothing Then
                suma = suma + dtSumaColectivoAgenteTelefonoVisita.Rows(0)(0)
            End If
            If Not dtSumaFamiliarAgenteTelefonoVisita Is Nothing Then
                suma = suma + dtSumaFamiliarAgenteTelefonoVisita.Rows(0)(0)
            End If
            If Not dtSumaPersonalAgenteTelefonoVisita Is Nothing Then
                suma = suma + dtSumaPersonalAgenteTelefonoVisita.Rows(0)(0)
            End If

            celdaSeleccionada.Offset(10, 1).Value = Decimal.Round(((Decimal.Round(suma, 2) / Decimal.Round(denominador, 2)) / 60), 2)

        End If


        celdaSeleccionada.Offset(10, 1).Value = celdaSeleccionada.Offset(10, 1).Value & " " & GetLocalResourceObject("lblMinutos").ToString()
        celdaSeleccionada.Offset(10, 1).ColumnWidth = 13
        celdaSeleccionada.Offset(10, 0).Font.Bold = True
        celdaSeleccionada.Offset(10, 1).Font.Bold = True
        celdaSeleccionada.Offset(10, 1).HorizontalAlignment = xlRight

        hasta = celdaSeleccionada.Offset(11, 3)

        hojaExcel.Range(desde, hasta).Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlSolid
        hojaExcel.Range(desde, hasta).Borders.Weight = Excel.XlBorderWeight.xlThick

        desde = celdaSeleccionada.Offset(0, -1)

        hojaExcel.Range(desde, hasta).Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone



        'EUSKERA o WEB
        celdaSeleccionada = celdaSeleccionada.Offset(13, -1)
        Dim celdaBorrar As Excel.Range
        celdaBorrar = celdaSeleccionada.Offset(-1, 0)
        celdaBorrar.EntireRow.Delete()
        If esIdioma Then
            celdaSeleccionada.Value = GetLocalResourceObject("lblEuskera").ToString()
        Else
            celdaSeleccionada.Value = GetLocalResourceObject("lblWeb").ToString()
        End If
        celdaSeleccionada.HorizontalAlignment = xlLeft
        celdaSeleccionada.Font.Bold = True
        'celdaSeleccionada.ColumnWidth = 12

        celdaSeleccionada = celdaSeleccionada.Offset(-2, 0)

        celdaSeleccionada.Offset(2, 1).Value = GetLocalResourceObject("lblDur1").ToString()
        celdaSeleccionada.Offset(3, 1).Value = GetLocalResourceObject("lblDur2").ToString()
        celdaSeleccionada.Offset(4, 1).Value = GetLocalResourceObject("lblDur3").ToString()
        celdaSeleccionada.Offset(5, 1).Value = GetLocalResourceObject("lblDur4").ToString()
        celdaSeleccionada.Offset(6, 1).Value = GetLocalResourceObject("lblDur5").ToString()
        celdaSeleccionada.Offset(7, 1).Value = GetLocalResourceObject("lblDur6").ToString()
        celdaSeleccionada.Offset(8, 1).Value = GetLocalResourceObject("lblDur7").ToString()
        celdaSeleccionada.Offset(9, 1).Value = GetLocalResourceObject("lblDur8").ToString()
        celdaSeleccionada.Offset(10, 1).Value = GetLocalResourceObject("lblDur9").ToString()
        celdaSeleccionada.Offset(11, 1).Value = GetLocalResourceObject("lblDur10").ToString()
        hojaExcel.Range(celdaSeleccionada.Offset(2, 1), celdaSeleccionada.Offset(11, 1)).HorizontalAlignment = xlLeft

        celdaSeleccionada = celdaSeleccionada.Offset(2, 1)

        dtDuracionColectivoAgente = _sesion.Listados.CargarDatosDuracionColectivoAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
        dtDuracionFamiliarAgente = _sesion.Listados.CargarDatosDuracionFamiliarAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
        dtDuracionPersonalAgente = _sesion.Listados.CargarDatosDuracionPersonalAgenteFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

        If esIdioma Then

            Dim dtDuracionAgenteFinalizadas As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionAgenteIdiomaFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual(), Globales.C_IDIOMA_EUSKERA)

            'Datos de la vivienda en euskera
            dtSumaColectivoAgenteEuskera = _sesion.Listados.CargarSumaDuracionColectivoAgenteEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

            dtSumaFamiliarAgenteEuskera = _sesion.Listados.CargarSumaDuracionFamiliarAgenteEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

            dtSumaPersonalAgenteEuskera = _sesion.Listados.CargarSumaDuracionPersonalAgenteEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())


            If Not dtDuracionColectivoAgente Is Nothing Then
                totalColectivoAgenteEuskera = dtDuracionColectivoAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
            Else
                totalColectivoAgenteEuskera = 0
            End If

            If Not dtDuracionFamiliarAgente Is Nothing Then
                totalFamiliarAgenteEuskera = dtDuracionFamiliarAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
            Else
                totalFamiliarAgenteEuskera = 0
            End If

            If Not dtDuracionPersonalAgente Is Nothing Then
                totalPersonalAgenteEuskera = dtDuracionPersonalAgente.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
            Else
                totalPersonalAgenteEuskera = 0
            End If

            denominador = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                denominador = dtDuracionAgenteFinalizadas.Rows.Count
            End If
            If denominador = 0 Then
                denominador = 1
            End If

            Dim denominadorPorcentaje = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                denominadorPorcentaje = dtDuracionAgenteFinalizadas.Rows.Count
            End If
            If denominadorPorcentaje = 0 Then denominadorPorcentaje = 1

            celdaSeleccionada.Offset(0, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(0, 1).Value = celdaSeleccionada.Offset(0, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur1).Length
            End If
            celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value


            celdaSeleccionada.Offset(1, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(1, 1).Value = celdaSeleccionada.Offset(1, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur2).Length
            End If
            celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value


            celdaSeleccionada.Offset(2, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(2, 1).Value = celdaSeleccionada.Offset(2, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur3).Length
            End If
            celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value


            celdaSeleccionada.Offset(3, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(3, 1).Value = celdaSeleccionada.Offset(3, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur4).Length
            End If
            celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value


            celdaSeleccionada.Offset(4, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(4, 1).Value = celdaSeleccionada.Offset(4, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur5).Length
            End If
            celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value


            celdaSeleccionada.Offset(5, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(5, 1).Value = celdaSeleccionada.Offset(5, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur6).Length
            End If
            celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value


            celdaSeleccionada.Offset(6, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(6, 1).Value = celdaSeleccionada.Offset(6, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur7).Length
            End If
            celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value


            celdaSeleccionada.Offset(7, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(7, 1).Value = celdaSeleccionada.Offset(7, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur8).Length
            End If
            celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value


            celdaSeleccionada.Offset(8, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(8, 1).Value = celdaSeleccionada.Offset(8, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION_AG & " <= " & dur9).Length
            End If
            celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value


            celdaSeleccionada.Offset(9, 1).Value = 0
            If Not dtDuracionAgenteFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(9, 1).Value = celdaSeleccionada.Offset(9, 1).Value + dtDuracionAgenteFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur9).Length
            End If
            celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value
        Else

            For j As Integer = 0 To 9
                celdaSeleccionada.Offset(j, 1).Value = 0
                celdaSeleccionada.Offset(j, 2).Value = 0
                celdaSeleccionada.Offset(j, 3).Value = 0
            Next

        End If


        hojaExcel.Range(celdaSeleccionada.Offset(0, 2), celdaSeleccionada.Offset(9, 3)).NumberFormat = "#.##0,00"
        hojaExcel.Range(celdaSeleccionada.Offset(0, 1), celdaSeleccionada.Offset(9, 3)).HorizontalAlignment = xlRight

        'Media
        celdaSeleccionada.Offset(10, 0).Value = GetLocalResourceObject("lblMedia").ToString()
        celdaSeleccionada.Offset(10, 0).HorizontalAlignment = xlLeft

        If esIdioma Then

            dtSumaColectivoAgenteEuskera = _sesion.Listados.CargarSumaDuracionColectivoAgenteEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaFamiliarAgenteEuskera = _sesion.Listados.CargarSumaDuracionFamiliarAgenteEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaPersonalAgenteEuskera = _sesion.Listados.CargarSumaDuracionPersonalAgenteEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

            suma = 0
            If Not dtSumaColectivoAgenteEuskera Is Nothing Then
                suma = suma + dtSumaColectivoAgenteEuskera.Rows(0)(0)
            End If
            If Not dtSumaFamiliarAgenteEuskera Is Nothing Then
                suma = suma + dtSumaFamiliarAgenteEuskera.Rows(0)(0)
            End If
            If Not dtSumaPersonalAgenteEuskera Is Nothing Then
                suma = suma + dtSumaPersonalAgenteEuskera.Rows(0)(0)
            End If

        Else

            dtSumaColectivoAgenteWeb = Nothing
            dtSumaFamiliarAgenteWeb = Nothing
            dtSumaPersonalAgenteWeb = Nothing

            suma = 0
            If Not dtSumaColectivoAgenteWeb Is Nothing Then
                suma = suma + dtSumaColectivoAgenteWeb.Rows(0)(0)
            End If
            If Not dtSumaFamiliarAgenteWeb Is Nothing Then
                suma = suma + dtSumaFamiliarAgenteWeb.Rows(0)(0)
            End If
            If Not dtSumaPersonalAgenteWeb Is Nothing Then
                suma = suma + dtSumaPersonalAgenteWeb.Rows(0)(0)
            End If

        End If


        celdaSeleccionada.Offset(10, 1).Value = Decimal.Round(((Decimal.Round(suma, 2) / Decimal.Round(denominador, 2)) / 60), 2)
        celdaSeleccionada.Offset(10, 1).Value = celdaSeleccionada.Offset(10, 1).Value & " " & GetLocalResourceObject("lblMinutos").ToString()
        celdaSeleccionada.Offset(10, 1).ColumnWidth = 13
        celdaSeleccionada.Offset(10, 1).HorizontalAlignment = xlRight

        celdaSeleccionada.Offset(10, 0).Font.Bold = True
        celdaSeleccionada.Offset(10, 1).Font.Bold = True

        hasta = celdaSeleccionada.Offset(11, 3)
        desde = celdaSeleccionada.Offset(0, -1)

        hojaExcel.Range(desde, hasta).Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlSolid
        hojaExcel.Range(desde, hasta).Borders.Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range(desde, hasta).Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone

    End Sub


    Private Sub dibujarEncuestadoEncuesta(ByVal hojaExcel As Excel.Worksheet, ByVal libroexcel As Excel.Workbook, ByVal esIdioma As Boolean)
        Dim dur1 As Integer = 300
        Dim dur2 As Integer = 600
        Dim dur3 As Integer = 900
        Dim dur4 As Integer = 1200
        Dim dur5 As Integer = 1500
        Dim dur6 As Integer = 1800
        Dim dur7 As Integer = 2100
        Dim dur8 As Integer = 2400
        Dim dur9 As Integer = 2700


        libroexcel.Sheets(GetLocalResourceObject("cbEncuestadoResource1.Text").ToString()).Activate()

        hojaExcel = libroexcel.ActiveSheet

        Dim celdaSeleccionada As Excel.Range = hojaExcel.Range("B5")
        hojaExcel.Cells.Font.Size = 11

        hojaExcel.Visible = True

        'EXCEL
        hojaExcel.Range("A2").Borders.Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("A2").Borders.Color = RGB(0, 0, 0)
        'hojaExcel.Range("A2").ColumnWidth = 6.15
        hojaExcel.Range("C2").Value = String.Format(GetLocalResourceObject("lblTitulo6Resource1Operacion.Text").ToString().ToUpper(), _sesion.Operacion) & _
            Chr(10) & GetLocalResourceObject("lblAnioResource1.Text") & " " & DropDownListAnio.SelectedValue
        If DropDownListTrim.SelectedValue <> String.Empty Then
            hojaExcel.Range("C2").Value = hojaExcel.Range("C2").Value & " " & GetLocalResourceObject("lblTrimResource1.Text") & " " & DropDownListTrim.SelectedValue
        End If
        hojaExcel.Range("C2").Font.Bold = True
        hojaExcel.Range("A2:N2").Borders.LineStyle = xlNone
        hojaExcel.Range("A2:B2").Borders.Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("C2").Borders.Weight = Excel.XlBorderWeight.xlThick

        hojaExcel.Range("C2:K2").Merge()
        hojaExcel.Range("C2").Borders.Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("C2").RowHeight = 30
        hojaExcel.Range("C2").HorizontalAlignment = xlCenter

        hojaExcel.Range("A3:N3").Borders.LineStyle = xlNone
        hojaExcel.Range("A3:B3").Borders.Weight = Excel.XlBorderWeight.xlThick


        'hojaExcel.Range("B4").RowHeight = 45.75
        hojaExcel.Range("A4:B4").Borders.Weight = Excel.XlBorderWeight.xlMedium
        hojaExcel.Range("A4").Borders(XlBordersIndex.xlEdgeRight).LineStyle = xlNone
        hojaExcel.Range("B4").ColumnWidth = 29


        'libroexcel.Sheets(GetLocalResourceObject("cbEncuestadoResource1.Text").ToString()).Select()

        hojaExcel.Range("B4").Value = GetLocalResourceObject("lblDuracion").ToString().ToUpper()
        hojaExcel.Range("B4").Font.Bold = True
        hojaExcel.Range("B4").HorizontalAlignment = xlLeft
        hojaExcel.Range("B4").VerticalAlignment = xlCenter

        'Dibujar duraciones
        hojaExcel.Range("B5").Value = GetLocalResourceObject("lblDur1").ToString()
        hojaExcel.Range("B6").Value = GetLocalResourceObject("lblDur2").ToString()
        hojaExcel.Range("B7").Value = GetLocalResourceObject("lblDur3").ToString()
        hojaExcel.Range("B8").Value = GetLocalResourceObject("lblDur4").ToString()
        hojaExcel.Range("B9").Value = GetLocalResourceObject("lblDur5").ToString()
        hojaExcel.Range("B10").Value = GetLocalResourceObject("lblDur6").ToString()
        hojaExcel.Range("B11").Value = GetLocalResourceObject("lblDur7").ToString()
        hojaExcel.Range("B12").Value = GetLocalResourceObject("lblDur8").ToString()
        hojaExcel.Range("B13").Value = GetLocalResourceObject("lblDur9").ToString()
        hojaExcel.Range("B14").Value = GetLocalResourceObject("lblDur10").ToString()
        hojaExcel.Range("B5:B14").HorizontalAlignment = xlLeft

        'Por encuesta
        hojaExcel.Range("C4").Value = GetLocalResourceObject("lblNumero").ToString()
        hojaExcel.Range("D4").Value = "%"
        hojaExcel.Range("E4").Value = GetLocalResourceObject("lblAcumulado").ToString()

        hojaExcel.Range("F4").Value = GetLocalResourceObject("lblNumero").ToString()
        hojaExcel.Range("G4").Value = "%"
        hojaExcel.Range("H4").Value = GetLocalResourceObject("lblAcumulado").ToString()

        hojaExcel.Range("I4").Value = GetLocalResourceObject("lblNumero").ToString()
        hojaExcel.Range("J4").Value = "%"
        hojaExcel.Range("K4").Value = GetLocalResourceObject("lblAcumulado").ToString()
        hojaExcel.Range("C4:K4").HorizontalAlignment = xlCenter
        hojaExcel.Range("C4:K4").VerticalAlignment = xlCenter
        hojaExcel.Range("C4:K4").Font.Bold = True

        'CASTELLANO
        If esIdioma Then
            hojaExcel.Range("A4").Value = GetLocalResourceObject("rbIdiomaResource1.Text").ToString().ToUpper()
        Else
            hojaExcel.Range("A4").Value = GetLocalResourceObject("lblForma").ToString()
        End If
        hojaExcel.Range("A4").WrapText = True
        hojaExcel.Range("A4").Font.Bold = True
        hojaExcel.Range("A4").HorizontalAlignment = xlLeft
        hojaExcel.Range("A4").VerticalAlignment = xlBottom
        'hojaExcel.Range("A4").RowHeight = 45.75
        'hojaExcel.Range("A4:B4").Borders.Weight = Excel.XlBorderWeight.xlMedium
        'hojaExcel.Range("A4").Borders(XlBordersIndex.xlEdgeRight).LineStyle = xlNone
        'hojaExcel.Range("B4").ColumnWidth = 39

        If esIdioma Then
            hojaExcel.Range("A5").Value = GetLocalResourceObject("lblCastellano").ToString()
        Else
            hojaExcel.Range("A5").Value = GetLocalResourceObject("lblTelefonicaVisita").ToString()
        End If
        hojaExcel.Range("A5").Font.Bold = True
        hojaExcel.Range("A5").ColumnWidth = 12

        Dim dtSumaColectivoEncuestadoCastellano As System.Data.DataTable = Nothing
        Dim dtSumaFamiliarEncuestadoCastellano As System.Data.DataTable = Nothing
        Dim dtSumaPersonalEncuestadoCastellano As System.Data.DataTable = Nothing

        Dim totalColectivoEncuestado As Integer
        Dim totalFamiliarEncuestado As Integer
        Dim totalPersonalEncuestado As Integer

        Dim dtSumaColectivoEncuestadoTelefonoVisita As System.Data.DataTable = Nothing
        Dim dtSumaFamiliarEncuestadoTelefonoVisita As System.Data.DataTable = Nothing
        Dim dtSumaPersonalEncuestadoTelefonoVisita As System.Data.DataTable = Nothing

        Dim dtSumaColectivoEncuestado As System.Data.DataTable = Nothing
        Dim dtSumaFamiliarEncuestado As System.Data.DataTable = Nothing
        Dim dtSumaPersonalEncuestado As System.Data.DataTable = Nothing


        Dim dtDuracionColectivoEncuestado As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionColectivoEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())


        If esIdioma Then
            'Datos colectivo en castellano
            dtSumaColectivoEncuestadoCastellano = _sesion.Listados.CargarSumaDuracionColectivoEncuestadoCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

            If Not dtDuracionColectivoEncuestado Is Nothing Then

                totalColectivoEncuestado = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                If totalColectivoEncuestado = 0 Then
                    totalColectivoEncuestado = 1
                End If

                celdaSeleccionada.Offset(0, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value

                celdaSeleccionada.Offset(1, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value

                celdaSeleccionada.Offset(2, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value

                celdaSeleccionada.Offset(3, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value

                celdaSeleccionada.Offset(4, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value

                celdaSeleccionada.Offset(5, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value

                celdaSeleccionada.Offset(6, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value

                celdaSeleccionada.Offset(7, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value

                celdaSeleccionada.Offset(8, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value

                celdaSeleccionada.Offset(9, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value

            Else
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 1).Value = 0
                    celdaSeleccionada.Offset(j, 2).Value = 0
                    celdaSeleccionada.Offset(j, 3).Value = 0
                Next
            End If
        Else
            'Datos colectivo en TelefonoVisita
            'dtSumaColectivoEncuestadoTelefonoVisita = _sesion.Listados.CargarSumaDuracionColectivoEncuestado(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

            dtSumaColectivoEncuestadoTelefonoVisita = Nothing
            dtDuracionColectivoEncuestado = Nothing

            'If Not dtDuracionColectivoEncuestado Is Nothing Then

            '    Dim columnaConsulta As String = String.Empty
            '    If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar() Then
            '        columnaConsulta = Globales.COL_CONSULTAIND_FORMFAM
            '    Else
            '        columnaConsulta = Globales.COL_CONSULTAIND_FORMPER
            '    End If

            '    totalColectivoEncuestado = dtDuracionColectivoEncuestado.Select(columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    If totalColectivoEncuestado = 0 Then
            '        totalColectivoEncuestado = 1
            '    End If

            '    celdaSeleccionada.Offset(0, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / totalColectivoEncuestado)
            '    celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value

            '    celdaSeleccionada.Offset(1, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / totalColectivoEncuestado)
            '    celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value

            '    celdaSeleccionada.Offset(2, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / totalColectivoEncuestado)
            '    celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value

            '    celdaSeleccionada.Offset(3, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / totalColectivoEncuestado)
            '    celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value

            '    celdaSeleccionada.Offset(4, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / totalColectivoEncuestado)
            '    celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value

            '    celdaSeleccionada.Offset(5, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / totalColectivoEncuestado)
            '    celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value

            '    celdaSeleccionada.Offset(6, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / totalColectivoEncuestado)
            '    celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value

            '    celdaSeleccionada.Offset(7, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / totalColectivoEncuestado)
            '    celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value

            '    celdaSeleccionada.Offset(8, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / totalColectivoEncuestado)
            '    celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value

            '    celdaSeleccionada.Offset(9, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & columnaConsulta & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / totalColectivoEncuestado)
            '    celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value

            'Else
            For j As Integer = 0 To 9
                celdaSeleccionada.Offset(j, 1).Value = 0
                celdaSeleccionada.Offset(j, 2).Value = 0
                celdaSeleccionada.Offset(j, 3).Value = 0
            Next
            'End If

        End If


        hojaExcel.Range("D5:E14").NumberFormat = "#.##0,00"

        Dim dtDuracionFamiliarEncuestado As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionFamiliarEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
        If esIdioma Then
            'Datos Familiar en castellano
            dtSumaFamiliarEncuestadoCastellano = _sesion.Listados.CargarSumaDuracionFamiliarEncuestadoCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

            If Not dtDuracionFamiliarEncuestado Is Nothing Then

                totalFamiliarEncuestado = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                If totalFamiliarEncuestado = 0 Then
                    totalFamiliarEncuestado = 1
                End If

                celdaSeleccionada.Offset(0, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(0, 5).Value = ((celdaSeleccionada.Offset(0, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(0, 6).Value = celdaSeleccionada.Offset(0, 5).Value

                celdaSeleccionada.Offset(1, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(1, 5).Value = ((celdaSeleccionada.Offset(1, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(1, 6).Value = celdaSeleccionada.Offset(0, 6).Value + celdaSeleccionada.Offset(1, 5).Value

                celdaSeleccionada.Offset(2, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(2, 5).Value = ((celdaSeleccionada.Offset(2, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(2, 6).Value = celdaSeleccionada.Offset(1, 6).Value + celdaSeleccionada.Offset(2, 5).Value

                celdaSeleccionada.Offset(3, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(3, 5).Value = ((celdaSeleccionada.Offset(3, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(3, 6).Value = celdaSeleccionada.Offset(2, 6).Value + celdaSeleccionada.Offset(3, 5).Value

                celdaSeleccionada.Offset(4, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(4, 5).Value = ((celdaSeleccionada.Offset(4, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(4, 6).Value = celdaSeleccionada.Offset(3, 6).Value + celdaSeleccionada.Offset(4, 5).Value

                celdaSeleccionada.Offset(5, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(5, 5).Value = ((celdaSeleccionada.Offset(5, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(5, 6).Value = celdaSeleccionada.Offset(4, 6).Value + celdaSeleccionada.Offset(5, 5).Value

                celdaSeleccionada.Offset(6, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(6, 5).Value = ((celdaSeleccionada.Offset(6, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(6, 6).Value = celdaSeleccionada.Offset(5, 6).Value + celdaSeleccionada.Offset(6, 5).Value

                celdaSeleccionada.Offset(7, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(7, 5).Value = ((celdaSeleccionada.Offset(7, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(7, 6).Value = celdaSeleccionada.Offset(6, 6).Value + celdaSeleccionada.Offset(7, 5).Value

                celdaSeleccionada.Offset(8, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(8, 5).Value = ((celdaSeleccionada.Offset(8, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(8, 6).Value = celdaSeleccionada.Offset(7, 6).Value + celdaSeleccionada.Offset(8, 5).Value

                celdaSeleccionada.Offset(9, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(9, 5).Value = ((celdaSeleccionada.Offset(9, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(9, 6).Value = celdaSeleccionada.Offset(8, 6).Value + celdaSeleccionada.Offset(9, 5).Value

            Else
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 4).Value = 0
                    celdaSeleccionada.Offset(j, 5).Value = 0
                    celdaSeleccionada.Offset(j, 6).Value = 0
                Next
            End If
        Else
            'Datos Familiar por telefono/visita
            ' dtSumaFamiliarEncuestadoTelefonoVisita = _sesion.Listados.CargarSumaDuracionFamiliarEncuestado(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaFamiliarEncuestadoTelefonoVisita = Nothing
            dtDuracionFamiliarEncuestado = Nothing

            'If Not dtDuracionFamiliarEncuestado Is Nothing Then

            '    totalFamiliarEncuestado = dtDuracionFamiliarEncuestado.Select(Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    If totalFamiliarEncuestado = 0 Then
            '        totalFamiliarEncuestado = 1
            '    End If

            '    celdaSeleccionada.Offset(0, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(0, 5).Value = ((celdaSeleccionada.Offset(0, 4).Value * 100) / totalFamiliarEncuestado)
            '    celdaSeleccionada.Offset(0, 6).Value = celdaSeleccionada.Offset(0, 5).Value

            '    celdaSeleccionada.Offset(1, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(1, 5).Value = ((celdaSeleccionada.Offset(1, 4).Value * 100) / totalFamiliarEncuestado)
            '    celdaSeleccionada.Offset(1, 6).Value = celdaSeleccionada.Offset(0, 6).Value + celdaSeleccionada.Offset(1, 5).Value

            '    celdaSeleccionada.Offset(2, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(2, 5).Value = ((celdaSeleccionada.Offset(2, 4).Value * 100) / totalFamiliarEncuestado)
            '    celdaSeleccionada.Offset(2, 6).Value = celdaSeleccionada.Offset(1, 6).Value + celdaSeleccionada.Offset(2, 5).Value

            '    celdaSeleccionada.Offset(3, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(3, 5).Value = ((celdaSeleccionada.Offset(3, 4).Value * 100) / totalFamiliarEncuestado)
            '    celdaSeleccionada.Offset(3, 6).Value = celdaSeleccionada.Offset(2, 6).Value + celdaSeleccionada.Offset(3, 5).Value

            '    celdaSeleccionada.Offset(4, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(4, 5).Value = ((celdaSeleccionada.Offset(4, 4).Value * 100) / totalFamiliarEncuestado)
            '    celdaSeleccionada.Offset(4, 6).Value = celdaSeleccionada.Offset(3, 6).Value + celdaSeleccionada.Offset(4, 5).Value

            '    celdaSeleccionada.Offset(5, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(5, 5).Value = ((celdaSeleccionada.Offset(5, 4).Value * 100) / totalFamiliarEncuestado)
            '    celdaSeleccionada.Offset(5, 6).Value = celdaSeleccionada.Offset(4, 6).Value + celdaSeleccionada.Offset(5, 5).Value

            '    celdaSeleccionada.Offset(6, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(6, 5).Value = ((celdaSeleccionada.Offset(6, 4).Value * 100) / totalFamiliarEncuestado)
            '    celdaSeleccionada.Offset(6, 6).Value = celdaSeleccionada.Offset(5, 6).Value + celdaSeleccionada.Offset(6, 5).Value

            '    celdaSeleccionada.Offset(7, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(7, 5).Value = ((celdaSeleccionada.Offset(7, 4).Value * 100) / totalFamiliarEncuestado)
            '    celdaSeleccionada.Offset(7, 6).Value = celdaSeleccionada.Offset(6, 6).Value + celdaSeleccionada.Offset(7, 5).Value

            '    celdaSeleccionada.Offset(8, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(8, 5).Value = ((celdaSeleccionada.Offset(8, 4).Value * 100) / totalFamiliarEncuestado)
            '    celdaSeleccionada.Offset(8, 6).Value = celdaSeleccionada.Offset(7, 6).Value + celdaSeleccionada.Offset(8, 5).Value

            '    celdaSeleccionada.Offset(9, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(9, 5).Value = ((celdaSeleccionada.Offset(9, 4).Value * 100) / totalFamiliarEncuestado)
            '    celdaSeleccionada.Offset(9, 6).Value = celdaSeleccionada.Offset(8, 6).Value + celdaSeleccionada.Offset(9, 5).Value

            'Else
            For j As Integer = 0 To 9
                celdaSeleccionada.Offset(j, 4).Value = 0
                celdaSeleccionada.Offset(j, 5).Value = 0
                celdaSeleccionada.Offset(j, 6).Value = 0
            Next
            'End If
        End If



        hojaExcel.Range("G5:H14").NumberFormat = "#.##0,00"

        'Datos Personal en castellano
        Dim dtDuracionPersonalEncuestado As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionPersonalEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

        If esIdioma Then
            dtSumaPersonalEncuestadoCastellano = _sesion.Listados.CargarSumaDuracionPersonalEncuestadoCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

            If Not dtDuracionPersonalEncuestado Is Nothing Then

                totalPersonalEncuestado = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                If totalPersonalEncuestado = 0 Then
                    totalPersonalEncuestado = 1
                End If

                celdaSeleccionada.Offset(0, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(0, 8).Value = ((celdaSeleccionada.Offset(0, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(0, 9).Value = celdaSeleccionada.Offset(0, 8).Value

                celdaSeleccionada.Offset(1, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(1, 8).Value = ((celdaSeleccionada.Offset(1, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(1, 9).Value = celdaSeleccionada.Offset(0, 9).Value + celdaSeleccionada.Offset(1, 8).Value

                celdaSeleccionada.Offset(2, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(2, 8).Value = ((celdaSeleccionada.Offset(2, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(2, 9).Value = celdaSeleccionada.Offset(1, 9).Value + celdaSeleccionada.Offset(2, 8).Value

                celdaSeleccionada.Offset(3, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(3, 8).Value = ((celdaSeleccionada.Offset(3, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(3, 9).Value = celdaSeleccionada.Offset(2, 9).Value + celdaSeleccionada.Offset(3, 8).Value

                celdaSeleccionada.Offset(4, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(4, 8).Value = ((celdaSeleccionada.Offset(4, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(4, 9).Value = celdaSeleccionada.Offset(3, 9).Value + celdaSeleccionada.Offset(4, 8).Value

                celdaSeleccionada.Offset(5, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(5, 8).Value = ((celdaSeleccionada.Offset(5, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(5, 9).Value = celdaSeleccionada.Offset(4, 9).Value + celdaSeleccionada.Offset(5, 8).Value

                celdaSeleccionada.Offset(6, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(6, 8).Value = ((celdaSeleccionada.Offset(6, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(6, 9).Value = celdaSeleccionada.Offset(5, 9).Value + celdaSeleccionada.Offset(6, 8).Value

                celdaSeleccionada.Offset(7, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(7, 8).Value = ((celdaSeleccionada.Offset(7, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(7, 9).Value = celdaSeleccionada.Offset(6, 9).Value + celdaSeleccionada.Offset(7, 8).Value

                celdaSeleccionada.Offset(8, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(8, 8).Value = ((celdaSeleccionada.Offset(8, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(8, 9).Value = celdaSeleccionada.Offset(7, 9).Value + celdaSeleccionada.Offset(8, 8).Value


                celdaSeleccionada.Offset(9, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
                celdaSeleccionada.Offset(9, 8).Value = ((celdaSeleccionada.Offset(9, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(9, 9).Value = celdaSeleccionada.Offset(8, 9).Value + celdaSeleccionada.Offset(9, 8).Value

            Else
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 7).Value = 0
                    celdaSeleccionada.Offset(j, 8).Value = 0
                    celdaSeleccionada.Offset(j, 9).Value = 0
                Next
            End If
        Else
            'dtSumaPersonalEncuestadoTelefonoVisita = _sesion.Listados.CargarSumaDuracionPersonalEncuestado(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

            dtSumaPersonalEncuestadoTelefonoVisita = Nothing
            dtDuracionPersonalEncuestado = Nothing

            'If Not dtDuracionPersonalEncuestado Is Nothing Then

            '    totalPersonalEncuestado = dtDuracionPersonalEncuestado.Select(Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    If totalPersonalEncuestado = 0 Then
            '        totalPersonalEncuestado = 1
            '    End If

            '    celdaSeleccionada.Offset(0, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(0, 8).Value = ((celdaSeleccionada.Offset(0, 7).Value * 100) / totalPersonalEncuestado)
            '    celdaSeleccionada.Offset(0, 9).Value = celdaSeleccionada.Offset(0, 8).Value

            '    celdaSeleccionada.Offset(1, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(1, 8).Value = ((celdaSeleccionada.Offset(1, 7).Value * 100) / totalPersonalEncuestado)
            '    celdaSeleccionada.Offset(1, 9).Value = celdaSeleccionada.Offset(0, 9).Value + celdaSeleccionada.Offset(1, 8).Value

            '    celdaSeleccionada.Offset(2, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(2, 8).Value = ((celdaSeleccionada.Offset(2, 7).Value * 100) / totalPersonalEncuestado)
            '    celdaSeleccionada.Offset(2, 9).Value = celdaSeleccionada.Offset(1, 9).Value + celdaSeleccionada.Offset(2, 8).Value

            '    celdaSeleccionada.Offset(3, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(3, 8).Value = ((celdaSeleccionada.Offset(3, 7).Value * 100) / totalPersonalEncuestado)
            '    celdaSeleccionada.Offset(3, 9).Value = celdaSeleccionada.Offset(2, 9).Value + celdaSeleccionada.Offset(3, 8).Value

            '    celdaSeleccionada.Offset(4, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(4, 8).Value = ((celdaSeleccionada.Offset(4, 7).Value * 100) / totalPersonalEncuestado)
            '    celdaSeleccionada.Offset(4, 9).Value = celdaSeleccionada.Offset(3, 9).Value + celdaSeleccionada.Offset(4, 8).Value

            '    celdaSeleccionada.Offset(5, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(5, 8).Value = ((celdaSeleccionada.Offset(5, 7).Value * 100) / totalPersonalEncuestado)
            '    celdaSeleccionada.Offset(5, 9).Value = celdaSeleccionada.Offset(4, 9).Value + celdaSeleccionada.Offset(5, 8).Value

            '    celdaSeleccionada.Offset(6, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(6, 8).Value = ((celdaSeleccionada.Offset(6, 7).Value * 100) / totalPersonalEncuestado)
            '    celdaSeleccionada.Offset(6, 9).Value = celdaSeleccionada.Offset(5, 9).Value + celdaSeleccionada.Offset(6, 8).Value

            '    celdaSeleccionada.Offset(7, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(7, 8).Value = ((celdaSeleccionada.Offset(7, 7).Value * 100) / totalPersonalEncuestado)
            '    celdaSeleccionada.Offset(7, 9).Value = celdaSeleccionada.Offset(6, 9).Value + celdaSeleccionada.Offset(7, 8).Value

            '    celdaSeleccionada.Offset(8, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(8, 8).Value = ((celdaSeleccionada.Offset(8, 7).Value * 100) / totalPersonalEncuestado)
            '    celdaSeleccionada.Offset(8, 9).Value = celdaSeleccionada.Offset(7, 9).Value + celdaSeleccionada.Offset(8, 8).Value


            '    celdaSeleccionada.Offset(9, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")").Length
            '    celdaSeleccionada.Offset(9, 8).Value = ((celdaSeleccionada.Offset(9, 7).Value * 100) / totalPersonalEncuestado)
            '    celdaSeleccionada.Offset(9, 9).Value = celdaSeleccionada.Offset(8, 9).Value + celdaSeleccionada.Offset(9, 8).Value

            'Else
            For j As Integer = 0 To 9
                celdaSeleccionada.Offset(j, 7).Value = 0
                celdaSeleccionada.Offset(j, 8).Value = 0
                celdaSeleccionada.Offset(j, 9).Value = 0
            Next
            'End If
        End If


        hojaExcel.Range("J5:K14").NumberFormat = "#.##0,00"

        hojaExcel.Range("A4").EntireRow.Insert()
        hojaExcel.Range("C4").Value = GetLocalResourceObject("lblColectivo").ToString()
        hojaExcel.Range("C4:E4").Merge()
        hojaExcel.Range("C4").HorizontalAlignment = xlCenter
        hojaExcel.Range("C4").VerticalAlignment = xlCenter
        hojaExcel.Range("C4").Font.Bold = True
        hojaExcel.Range("F4").Value = GetLocalResourceObject("lblCuestionarioFamiliar").ToString()
        hojaExcel.Range("F4:H4").Merge()
        hojaExcel.Range("F4").HorizontalAlignment = xlCenter
        hojaExcel.Range("F4").VerticalAlignment = xlCenter
        hojaExcel.Range("f4").Font.Bold = True
        hojaExcel.Range("I4").Value = GetLocalResourceObject("lblCuestionarioIndividual").ToString()
        hojaExcel.Range("I4:K4").Merge()
        hojaExcel.Range("I4").HorizontalAlignment = xlCenter
        hojaExcel.Range("I4").VerticalAlignment = xlCenter
        hojaExcel.Range("I4").Font.Bold = True
        hojaExcel.Range("A4").RowHeight = 30

        'Colectivo
        'hojaExcel.Range("B16").Value = GetLocalResourceObject("lblTotalEncuestas.Text").ToString()
        hojaExcel.Range("B16").Value = GetLocalResourceObject("lblMedia").ToString()
        hojaExcel.Range("B16").HorizontalAlignment = xlLeft

        'hojaExcel.Range("C16").NumberFormat = "#.##0,0"

        If esIdioma Then
            If Not dtSumaColectivoEncuestadoCastellano Is Nothing Then
                If dtSumaColectivoEncuestadoCastellano.Rows.Count > 0 Then
                    hojaExcel.Range("C16").Value = Decimal.Round(((dtSumaColectivoEncuestadoCastellano.Rows(0)(0) / totalColectivoEncuestado) / 60), 2)
                    hojaExcel.Range("C16").Value = hojaExcel.Range("C16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("C16").Value = 0
                End If
            Else
                hojaExcel.Range("C16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaFamiliarEncuestadoCastellano Is Nothing Then
                If dtSumaFamiliarEncuestadoCastellano.Rows.Count > 0 Then
                    hojaExcel.Range("F16").Value = Decimal.Round(((dtSumaFamiliarEncuestadoCastellano.Rows(0)(0) / totalFamiliarEncuestado) / 60), 2)
                    hojaExcel.Range("F16").Value = hojaExcel.Range("F16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("F16").Value = 0
                End If
            Else
                hojaExcel.Range("F16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaPersonalEncuestadoCastellano Is Nothing Then
                If dtSumaPersonalEncuestadoCastellano.Rows.Count > 0 Then
                    hojaExcel.Range("I16").Value = Decimal.Round(((dtSumaPersonalEncuestadoCastellano.Rows(0)(0) / totalPersonalEncuestado) / 60), 2)
                    hojaExcel.Range("I16").Value = hojaExcel.Range("I16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("I16").Value = 0
                End If
            Else
                hojaExcel.Range("I16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If
        Else
            If Not dtSumaColectivoEncuestadoTelefonoVisita Is Nothing Then
                If dtSumaColectivoEncuestadoTelefonoVisita.Rows.Count > 0 Then
                    hojaExcel.Range("C16").Value = Decimal.Round(((dtSumaColectivoEncuestadoTelefonoVisita.Rows(0)(0) / totalColectivoEncuestado) / 60), 2)
                    hojaExcel.Range("C16").Value = hojaExcel.Range("C16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("C16").Value = 0
                End If
            Else
                hojaExcel.Range("C16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaFamiliarEncuestadoTelefonoVisita Is Nothing Then
                If dtSumaFamiliarEncuestadoTelefonoVisita.Rows.Count > 0 Then
                    hojaExcel.Range("F16").Value = Decimal.Round(((dtSumaFamiliarEncuestadoTelefonoVisita.Rows(0)(0) / totalFamiliarEncuestado) / 60), 2)
                    hojaExcel.Range("F16").Value = hojaExcel.Range("F16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("F16").Value = 0
                End If
            Else
                hojaExcel.Range("F16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaPersonalEncuestadoTelefonoVisita Is Nothing Then
                If dtSumaPersonalEncuestadoTelefonoVisita.Rows.Count > 0 Then
                    hojaExcel.Range("I16").Value = Decimal.Round(((dtSumaPersonalEncuestadoTelefonoVisita.Rows(0)(0) / totalPersonalEncuestado) / 60), 2)
                    hojaExcel.Range("I16").Value = hojaExcel.Range("I16").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("I16").Value = 0
                End If
            Else
                hojaExcel.Range("I16").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If
        End If

        hojaExcel.Range("B16:C16").Font.Bold = True
        hojaExcel.Range("F16").Font.Bold = True
        hojaExcel.Range("I16").Font.Bold = True

        hojaExcel.Range("C16").RowHeight = 15
        hojaExcel.Range("C16").ColumnWidth = 13
        hojaExcel.Range("F16").ColumnWidth = 13
        hojaExcel.Range("I16").ColumnWidth = 13

        'hojaExcel.Range("A6:K16").Borders.Weight = Excel.XlBorderWeight.xlMedium
        'hojaExcel.Range("A6:K16").Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone
        'hojaExcel.Range("A6:K16").Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlNone

        hojaExcel.Range("A3:K17").Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlSolid
        hojaExcel.Range("A3:K17").Borders.Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("A6:K17").Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone

        'EUSKERA o WEB
        celdaSeleccionada = hojaExcel.Range("A18")
        If esIdioma Then
            celdaSeleccionada.Value = GetLocalResourceObject("lblEuskera").ToString()
        Else
            celdaSeleccionada.Value = GetLocalResourceObject("lblWeb").ToString()
        End If
        celdaSeleccionada.Font.Bold = True
        celdaSeleccionada.ColumnWidth = 12

        'Dibujar duraciones
        hojaExcel.Range("B18").Value = GetLocalResourceObject("lblDur1").ToString()
        hojaExcel.Range("B19").Value = GetLocalResourceObject("lblDur2").ToString()
        hojaExcel.Range("B20").Value = GetLocalResourceObject("lblDur3").ToString()
        hojaExcel.Range("B21").Value = GetLocalResourceObject("lblDur4").ToString()
        hojaExcel.Range("B22").Value = GetLocalResourceObject("lblDur5").ToString()
        hojaExcel.Range("B23").Value = GetLocalResourceObject("lblDur6").ToString()
        hojaExcel.Range("B24").Value = GetLocalResourceObject("lblDur7").ToString()
        hojaExcel.Range("B25").Value = GetLocalResourceObject("lblDur8").ToString()
        hojaExcel.Range("B26").Value = GetLocalResourceObject("lblDur9").ToString()
        hojaExcel.Range("B27").Value = GetLocalResourceObject("lblDur10").ToString()
        hojaExcel.Range("A18:B27").HorizontalAlignment = xlLeft

        celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

        Dim dtSumaColectivoEncuestadoEuskera As System.Data.DataTable = _sesion.Listados.CargarSumaDuracionColectivoEncuestadoEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

        If esIdioma Then
            'Datos colectivo en euskera
            If Not dtDuracionColectivoEncuestado Is Nothing Then

                totalColectivoEncuestado = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                If totalColectivoEncuestado = 0 Then
                    totalColectivoEncuestado = 1
                End If

                celdaSeleccionada.Offset(0, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value

                celdaSeleccionada.Offset(1, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value

                celdaSeleccionada.Offset(2, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value

                celdaSeleccionada.Offset(3, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value

                celdaSeleccionada.Offset(4, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value

                celdaSeleccionada.Offset(5, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value

                celdaSeleccionada.Offset(6, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value

                celdaSeleccionada.Offset(7, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value

                celdaSeleccionada.Offset(8, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value

                celdaSeleccionada.Offset(9, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value

            Else
                totalColectivoEncuestado = 1
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 1).Value = 0
                    celdaSeleccionada.Offset(j, 2).Value = 0
                    celdaSeleccionada.Offset(j, 3).Value = 0
                Next
            End If
        Else
            'Datos colectivo Web
            dtDuracionColectivoEncuestado = _sesion.Listados.CargarDatosDuracionColectivoEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaColectivoEncuestado = _sesion.Listados.CargarSumaDuracionColectivoEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            If Not dtDuracionColectivoEncuestado Is Nothing Then

                Dim columnaConsulta As String = String.Empty
                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar() Then
                    columnaConsulta = Globales.COL_CONSULTAIND_FORMFAM
                Else
                    columnaConsulta = Globales.COL_CONSULTAIND_FORMPER
                End If

                totalColectivoEncuestado = dtDuracionColectivoEncuestado.Select(columnaConsulta & " = " & Globales.FORM_WEB).Length
                If totalColectivoEncuestado = 0 Then
                    totalColectivoEncuestado = 1
                End If

                celdaSeleccionada.Offset(0, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value

                celdaSeleccionada.Offset(1, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value

                celdaSeleccionada.Offset(2, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value

                celdaSeleccionada.Offset(3, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value

                celdaSeleccionada.Offset(4, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value

                celdaSeleccionada.Offset(5, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value

                celdaSeleccionada.Offset(6, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value

                celdaSeleccionada.Offset(7, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value

                celdaSeleccionada.Offset(8, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value

                celdaSeleccionada.Offset(9, 1).Value = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & columnaConsulta & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / totalColectivoEncuestado)
                celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value

            Else
                totalColectivoEncuestado = 1
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 1).Value = 0
                    celdaSeleccionada.Offset(j, 2).Value = 0
                    celdaSeleccionada.Offset(j, 3).Value = 0
                Next
            End If
        End If



        hojaExcel.Range("D18:E27").NumberFormat = "#.##0,00"
        'hojaExcel.Range("C6:C31").HorizontalAlignment = xlRight

        Dim dtSumaFamiliarEncuestadoEuskera As System.Data.DataTable = _sesion.Listados.CargarSumaDuracionFamiliarEncuestadoEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())

        If esIdioma Then
            'Datos Familiar en euskera

            If Not dtDuracionFamiliarEncuestado Is Nothing Then

                totalFamiliarEncuestado = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                If totalFamiliarEncuestado = 0 Then
                    totalFamiliarEncuestado = 1
                End If

                celdaSeleccionada.Offset(0, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(0, 5).Value = ((celdaSeleccionada.Offset(0, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(0, 6).Value = celdaSeleccionada.Offset(0, 5).Value

                celdaSeleccionada.Offset(1, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(1, 5).Value = ((celdaSeleccionada.Offset(1, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(1, 6).Value = celdaSeleccionada.Offset(0, 6).Value + celdaSeleccionada.Offset(1, 5).Value

                celdaSeleccionada.Offset(2, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(2, 5).Value = ((celdaSeleccionada.Offset(2, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(2, 6).Value = celdaSeleccionada.Offset(1, 6).Value + celdaSeleccionada.Offset(2, 5).Value

                celdaSeleccionada.Offset(3, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(3, 5).Value = ((celdaSeleccionada.Offset(3, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(3, 6).Value = celdaSeleccionada.Offset(2, 6).Value + celdaSeleccionada.Offset(3, 5).Value

                celdaSeleccionada.Offset(4, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(4, 5).Value = ((celdaSeleccionada.Offset(4, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(4, 6).Value = celdaSeleccionada.Offset(3, 6).Value + celdaSeleccionada.Offset(4, 5).Value

                celdaSeleccionada.Offset(5, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(5, 5).Value = ((celdaSeleccionada.Offset(5, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(5, 6).Value = celdaSeleccionada.Offset(4, 6).Value + celdaSeleccionada.Offset(5, 5).Value

                celdaSeleccionada.Offset(6, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(6, 5).Value = ((celdaSeleccionada.Offset(6, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(6, 6).Value = celdaSeleccionada.Offset(5, 6).Value + celdaSeleccionada.Offset(6, 5).Value

                celdaSeleccionada.Offset(7, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(7, 5).Value = ((celdaSeleccionada.Offset(7, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(7, 6).Value = celdaSeleccionada.Offset(6, 6).Value + celdaSeleccionada.Offset(7, 5).Value

                celdaSeleccionada.Offset(8, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(8, 5).Value = ((celdaSeleccionada.Offset(8, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(8, 6).Value = celdaSeleccionada.Offset(7, 6).Value + celdaSeleccionada.Offset(8, 5).Value

                celdaSeleccionada.Offset(9, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(9, 5).Value = ((celdaSeleccionada.Offset(9, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(9, 6).Value = celdaSeleccionada.Offset(8, 6).Value + celdaSeleccionada.Offset(9, 5).Value

            Else
                totalFamiliarEncuestado = 1
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 4).Value = 0
                    celdaSeleccionada.Offset(j, 5).Value = 0
                    celdaSeleccionada.Offset(j, 6).Value = 0
                Next
            End If
        Else
            'Datos Familiar WEB
            dtDuracionFamiliarEncuestado = _sesion.Listados.CargarDatosDuracionFamiliarEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaFamiliarEncuestado = _sesion.Listados.CargarSumaDuracionFamiliarEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            If Not dtDuracionFamiliarEncuestado Is Nothing Then

                totalFamiliarEncuestado = dtDuracionFamiliarEncuestado.Select(Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
                If totalFamiliarEncuestado = 0 Then
                    totalFamiliarEncuestado = 1
                End If

                celdaSeleccionada.Offset(0, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(0, 5).Value = ((celdaSeleccionada.Offset(0, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(0, 6).Value = celdaSeleccionada.Offset(0, 5).Value

                celdaSeleccionada.Offset(1, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(1, 5).Value = ((celdaSeleccionada.Offset(1, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(1, 6).Value = celdaSeleccionada.Offset(0, 6).Value + celdaSeleccionada.Offset(1, 5).Value

                celdaSeleccionada.Offset(2, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(2, 5).Value = ((celdaSeleccionada.Offset(2, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(2, 6).Value = celdaSeleccionada.Offset(1, 6).Value + celdaSeleccionada.Offset(2, 5).Value

                celdaSeleccionada.Offset(3, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(3, 5).Value = ((celdaSeleccionada.Offset(3, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(3, 6).Value = celdaSeleccionada.Offset(2, 6).Value + celdaSeleccionada.Offset(3, 5).Value

                celdaSeleccionada.Offset(4, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(4, 5).Value = ((celdaSeleccionada.Offset(4, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(4, 6).Value = celdaSeleccionada.Offset(3, 6).Value + celdaSeleccionada.Offset(4, 5).Value

                celdaSeleccionada.Offset(5, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(5, 5).Value = ((celdaSeleccionada.Offset(5, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(5, 6).Value = celdaSeleccionada.Offset(4, 6).Value + celdaSeleccionada.Offset(5, 5).Value

                celdaSeleccionada.Offset(6, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(6, 5).Value = ((celdaSeleccionada.Offset(6, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(6, 6).Value = celdaSeleccionada.Offset(5, 6).Value + celdaSeleccionada.Offset(6, 5).Value

                celdaSeleccionada.Offset(7, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(7, 5).Value = ((celdaSeleccionada.Offset(7, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(7, 6).Value = celdaSeleccionada.Offset(6, 6).Value + celdaSeleccionada.Offset(7, 5).Value

                celdaSeleccionada.Offset(8, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(8, 5).Value = ((celdaSeleccionada.Offset(8, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(8, 6).Value = celdaSeleccionada.Offset(7, 6).Value + celdaSeleccionada.Offset(8, 5).Value

                celdaSeleccionada.Offset(9, 4).Value = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(9, 5).Value = ((celdaSeleccionada.Offset(9, 4).Value * 100) / totalFamiliarEncuestado)
                celdaSeleccionada.Offset(9, 6).Value = celdaSeleccionada.Offset(8, 6).Value + celdaSeleccionada.Offset(9, 5).Value

            Else
                totalFamiliarEncuestado = 1
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 4).Value = 0
                    celdaSeleccionada.Offset(j, 5).Value = 0
                    celdaSeleccionada.Offset(j, 6).Value = 0
                Next
            End If
        End If


        hojaExcel.Range("G18:H27").NumberFormat = "#.##0,00"
        hojaExcel.Range("F6:F31").HorizontalAlignment = xlRight

        Dim dtSumaPersonalEncuestadoEuskera As System.Data.DataTable = _sesion.Listados.CargarSumaDuracionPersonalEncuestadoEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

        If esIdioma Then
            'Datos Personal en euskera

            If Not dtDuracionPersonalEncuestado Is Nothing Then

                totalPersonalEncuestado = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                If totalPersonalEncuestado = 0 Then
                    totalPersonalEncuestado = 1
                End If

                celdaSeleccionada.Offset(0, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(0, 8).Value = ((celdaSeleccionada.Offset(0, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(0, 9).Value = celdaSeleccionada.Offset(0, 8).Value

                celdaSeleccionada.Offset(1, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(1, 8).Value = ((celdaSeleccionada.Offset(1, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(1, 9).Value = celdaSeleccionada.Offset(0, 9).Value + celdaSeleccionada.Offset(1, 8).Value

                celdaSeleccionada.Offset(2, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(2, 8).Value = ((celdaSeleccionada.Offset(2, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(2, 9).Value = celdaSeleccionada.Offset(1, 9).Value + celdaSeleccionada.Offset(2, 8).Value

                celdaSeleccionada.Offset(3, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(3, 8).Value = ((celdaSeleccionada.Offset(3, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(3, 9).Value = celdaSeleccionada.Offset(2, 9).Value + celdaSeleccionada.Offset(3, 8).Value

                celdaSeleccionada.Offset(4, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(4, 8).Value = ((celdaSeleccionada.Offset(4, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(4, 9).Value = celdaSeleccionada.Offset(3, 9).Value + celdaSeleccionada.Offset(4, 8).Value

                celdaSeleccionada.Offset(5, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(5, 8).Value = ((celdaSeleccionada.Offset(5, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(5, 9).Value = celdaSeleccionada.Offset(4, 9).Value + celdaSeleccionada.Offset(5, 8).Value

                celdaSeleccionada.Offset(6, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(6, 8).Value = ((celdaSeleccionada.Offset(6, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(6, 9).Value = celdaSeleccionada.Offset(5, 9).Value + celdaSeleccionada.Offset(6, 8).Value

                celdaSeleccionada.Offset(7, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(7, 8).Value = ((celdaSeleccionada.Offset(7, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(7, 9).Value = celdaSeleccionada.Offset(6, 9).Value + celdaSeleccionada.Offset(7, 8).Value

                celdaSeleccionada.Offset(8, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(8, 8).Value = ((celdaSeleccionada.Offset(8, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(8, 9).Value = celdaSeleccionada.Offset(7, 9).Value + celdaSeleccionada.Offset(8, 8).Value


                celdaSeleccionada.Offset(9, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
                celdaSeleccionada.Offset(9, 8).Value = ((celdaSeleccionada.Offset(9, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(9, 9).Value = celdaSeleccionada.Offset(8, 9).Value + celdaSeleccionada.Offset(9, 8).Value

            Else
                totalPersonalEncuestado = 1
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 7).Value = 0
                    celdaSeleccionada.Offset(j, 8).Value = 0
                    celdaSeleccionada.Offset(j, 9).Value = 0
                Next
            End If
        Else
            'Datos Personal WEB
            dtDuracionPersonalEncuestado = _sesion.Listados.CargarDatosDuracionPersonalEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())
            dtSumaPersonalEncuestado = _sesion.Listados.CargarSumaDuracionPersonalEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())
            If Not dtDuracionPersonalEncuestado Is Nothing Then

                totalPersonalEncuestado = dtDuracionPersonalEncuestado.Select(Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
                If totalPersonalEncuestado = 0 Then
                    totalPersonalEncuestado = 1
                End If

                celdaSeleccionada.Offset(0, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " <= " & dur1 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(0, 8).Value = ((celdaSeleccionada.Offset(0, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(0, 9).Value = celdaSeleccionada.Offset(0, 8).Value

                celdaSeleccionada.Offset(1, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur1 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur2 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(1, 8).Value = ((celdaSeleccionada.Offset(1, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(1, 9).Value = celdaSeleccionada.Offset(0, 9).Value + celdaSeleccionada.Offset(1, 8).Value

                celdaSeleccionada.Offset(2, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur2 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur3 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(2, 8).Value = ((celdaSeleccionada.Offset(2, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(2, 9).Value = celdaSeleccionada.Offset(1, 9).Value + celdaSeleccionada.Offset(2, 8).Value

                celdaSeleccionada.Offset(3, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur3 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur4 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(3, 8).Value = ((celdaSeleccionada.Offset(3, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(3, 9).Value = celdaSeleccionada.Offset(2, 9).Value + celdaSeleccionada.Offset(3, 8).Value

                celdaSeleccionada.Offset(4, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur4 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur5 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(4, 8).Value = ((celdaSeleccionada.Offset(4, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(4, 9).Value = celdaSeleccionada.Offset(3, 9).Value + celdaSeleccionada.Offset(4, 8).Value

                celdaSeleccionada.Offset(5, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur5 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur6 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(5, 8).Value = ((celdaSeleccionada.Offset(5, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(5, 9).Value = celdaSeleccionada.Offset(4, 9).Value + celdaSeleccionada.Offset(5, 8).Value

                celdaSeleccionada.Offset(6, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur6 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur7 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(6, 8).Value = ((celdaSeleccionada.Offset(6, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(6, 9).Value = celdaSeleccionada.Offset(5, 9).Value + celdaSeleccionada.Offset(6, 8).Value

                celdaSeleccionada.Offset(7, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur7 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur8 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(7, 8).Value = ((celdaSeleccionada.Offset(7, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(7, 9).Value = celdaSeleccionada.Offset(6, 9).Value + celdaSeleccionada.Offset(7, 8).Value

                celdaSeleccionada.Offset(8, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur8 & " AND " & Globales.COL_CUESTIONARIO_DURACION & " <= " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(8, 8).Value = ((celdaSeleccionada.Offset(8, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(8, 9).Value = celdaSeleccionada.Offset(7, 9).Value + celdaSeleccionada.Offset(8, 8).Value


                celdaSeleccionada.Offset(9, 7).Value = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTIONARIO_DURACION & " > " & dur9 & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
                celdaSeleccionada.Offset(9, 8).Value = ((celdaSeleccionada.Offset(9, 7).Value * 100) / totalPersonalEncuestado)
                celdaSeleccionada.Offset(9, 9).Value = celdaSeleccionada.Offset(8, 9).Value + celdaSeleccionada.Offset(9, 8).Value

            Else
                totalPersonalEncuestado = 1
                For j As Integer = 0 To 9
                    celdaSeleccionada.Offset(j, 7).Value = 0
                    celdaSeleccionada.Offset(j, 8).Value = 0
                    celdaSeleccionada.Offset(j, 9).Value = 0
                Next
            End If

        End If


        hojaExcel.Range("J18:K27").NumberFormat = "#.##0,00"
        hojaExcel.Range("C6:K31").HorizontalAlignment = xlRight

        'Colectivo
        'hojaExcel.Range("B30").Value = GetLocalResourceObject("lblTotalEncuestas.Text").ToString()
        hojaExcel.Range("B28").Value = GetLocalResourceObject("lblMedia").ToString()
        hojaExcel.Range("B28").HorizontalAlignment = xlLeft

        If esIdioma Then
            If Not dtSumaColectivoEncuestadoEuskera Is Nothing Then
                If dtSumaColectivoEncuestadoEuskera.Rows.Count > 0 Then
                    hojaExcel.Range("C28").Value = Decimal.Round(((dtSumaColectivoEncuestadoEuskera.Rows(0)(0) / totalColectivoEncuestado) / 60), 2)
                    hojaExcel.Range("C28").Value = hojaExcel.Range("C28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("C28").Value = 0
                End If
            Else
                hojaExcel.Range("C28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaFamiliarEncuestadoEuskera Is Nothing Then
                If dtSumaFamiliarEncuestadoEuskera.Rows.Count > 0 Then
                    hojaExcel.Range("F28").Value = Decimal.Round(((dtSumaFamiliarEncuestadoEuskera.Rows(0)(0) / totalFamiliarEncuestado) / 60), 2)
                    hojaExcel.Range("F28").Value = hojaExcel.Range("F28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("F28").Value = 0
                End If
            Else
                hojaExcel.Range("F28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaPersonalEncuestadoEuskera Is Nothing Then
                If dtSumaPersonalEncuestadoEuskera.Rows.Count > 0 Then
                    hojaExcel.Range("I28").Value = Decimal.Round(((dtSumaPersonalEncuestadoEuskera.Rows(0)(0) / totalPersonalEncuestado) / 60), 2)
                    hojaExcel.Range("I28").Value = hojaExcel.Range("I28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("I28").Value = 0
                End If
            Else
                hojaExcel.Range("I28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If
        Else
            If Not dtSumaColectivoEncuestado Is Nothing Then
                If dtSumaColectivoEncuestado.Rows.Count > 0 Then
                    hojaExcel.Range("C28").Value = Decimal.Round(((dtSumaColectivoEncuestado.Rows(0)(0) / totalColectivoEncuestado) / 60), 2)
                    hojaExcel.Range("C28").Value = hojaExcel.Range("C28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("C28").Value = 0
                End If
            Else
                hojaExcel.Range("C28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaFamiliarEncuestado Is Nothing Then
                If dtSumaFamiliarEncuestado.Rows.Count > 0 Then
                    hojaExcel.Range("F28").Value = Decimal.Round(((dtSumaFamiliarEncuestado.Rows(0)(0) / totalFamiliarEncuestado) / 60), 2)
                    hojaExcel.Range("F28").Value = hojaExcel.Range("F28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("F28").Value = 0
                End If
            Else
                hojaExcel.Range("F28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

            If Not dtSumaPersonalEncuestado Is Nothing Then
                If dtSumaPersonalEncuestado.Rows.Count > 0 Then
                    hojaExcel.Range("I28").Value = Decimal.Round(((dtSumaPersonalEncuestado.Rows(0)(0) / totalPersonalEncuestado) / 60), 2)
                    hojaExcel.Range("I28").Value = hojaExcel.Range("I28").Value & " " & GetLocalResourceObject("lblMinutos").ToString()
                Else
                    hojaExcel.Range("I28").Value = 0
                End If
            Else
                hojaExcel.Range("I28").Value = 0 & " " & GetLocalResourceObject("lblMinutos").ToString()
            End If

        End If

        hojaExcel.Range("B28:C28").Font.Bold = True
        hojaExcel.Range("F28").Font.Bold = True
        hojaExcel.Range("I28").Font.Bold = True

        'hojaExcel.Range("A18:K28").Borders.Weight = Excel.XlBorderWeight.xlMedium
        'hojaExcel.Range("A18:K28").Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone
        'hojaExcel.Range("A18:K28").Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlNone

        hojaExcel.Range("A18:K28").Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlSolid
        hojaExcel.Range("A18:K28").Borders.Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("A18:K28").Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone

    End Sub


    Private Sub dibujarEncuestadoVivienda(ByVal hojaExcel As Excel.Worksheet, ByVal libroexcel As Excel.Workbook, ByVal esIdioma As Boolean)
        libroexcel.Sheets(GetLocalResourceObject("cbEncuestadoResource1.Text").ToString()).Activate()

        hojaExcel = libroexcel.ActiveSheet

        Dim dur1 As Integer = 300
        Dim dur2 As Integer = 600
        Dim dur3 As Integer = 900
        Dim dur4 As Integer = 1200
        Dim dur5 As Integer = 1500
        Dim dur6 As Integer = 1800
        Dim dur7 As Integer = 2100
        Dim dur8 As Integer = 2400
        Dim dur9 As Integer = 2700

        Dim dtSumaColectivoEncuestadoCastellano As System.Data.DataTable
        Dim dtSumaFamiliarEncuestadoCastellano As System.Data.DataTable
        Dim dtSumaPersonalEncuestadoCastellano As System.Data.DataTable

        Dim dtSumaColectivoEncuestadoEuskera As System.Data.DataTable
        Dim dtSumaFamiliarEncuestadoEuskera As System.Data.DataTable
        Dim dtSumaPersonalEncuestadoEuskera As System.Data.DataTable

        Dim dtSumaColectivoEncuestado As System.Data.DataTable
        Dim dtSumaFamiliarEncuestado As System.Data.DataTable
        Dim dtSumaPersonalEncuestado As System.Data.DataTable

        Dim totalColectivoEncuestado As Integer
        Dim totalFamiliarEncuestado As Integer
        Dim totalPersonalEncuestado As Integer

        Dim celdaSeleccionada As Excel.Range
        If cbEncuesta.Checked Then
            celdaSeleccionada = hojaExcel.Range("A32")
        Else
            celdaSeleccionada = hojaExcel.Range("A4")
        End If

        celdaSeleccionada.Offset(0, 2).Value = GetLocalResourceObject("lblDuracionVivienda").ToString().ToUpper()
        celdaSeleccionada.Offset(0, 2).Font.Bold = True

        Dim desde As Object = celdaSeleccionada.Offset(0, 2)
        Dim hasta As Object = celdaSeleccionada.Offset(0, 4)
        hojaExcel.Range(desde, hasta).Merge()
        celdaSeleccionada.Offset(0, 2).RowHeight = 30
        celdaSeleccionada.Offset(0, 2).HorizontalAlignment = xlCenter
        celdaSeleccionada.Offset(0, 2).VerticalAlignment = xlCenter

        desde = celdaSeleccionada.Offset(0, 0)

        'CASTELLANO o TELEFONO/VISITA
        If esIdioma Then
            celdaSeleccionada.Offset(1, 0).Value = GetLocalResourceObject("rbIdiomaResource1.Text").ToString().ToUpper()
        Else
            celdaSeleccionada.Offset(1, 0).Value = GetLocalResourceObject("lblForma").ToString()
        End If
        celdaSeleccionada.Offset(1, 0).WrapText = True
        celdaSeleccionada.Offset(1, 0).Font.Bold = True
        celdaSeleccionada.Offset(1, 0).HorizontalAlignment = xlLeft
        celdaSeleccionada.Offset(1, 0).VerticalAlignment = xlBottom

        celdaSeleccionada.Offset(1, 1).Value = GetLocalResourceObject("lblDuracion").ToString().ToUpper()
        celdaSeleccionada.Offset(1, 1).Font.Bold = True
        celdaSeleccionada.Offset(1, 1).HorizontalAlignment = xlLeft
        celdaSeleccionada.Offset(1, 1).VerticalAlignment = xlCenter

        If esIdioma Then
            celdaSeleccionada.Offset(2, 0).Value = GetLocalResourceObject("lblCastellano").ToString()
        Else
            celdaSeleccionada.Offset(2, 0).Value = GetLocalResourceObject("lblTelefonicaVisita").ToString()
        End If
        celdaSeleccionada.Offset(2, 0).Font.Bold = True
        celdaSeleccionada.Offset(2, 0).ColumnWidth = 12
        celdaSeleccionada.Offset(2, 0).HorizontalAlignment = xlLeft
        celdaSeleccionada.Offset(2, 0).VerticalAlignment = xlCenter

        celdaSeleccionada.Offset(1, 2).Value = GetLocalResourceObject("lblNumero").ToString()
        celdaSeleccionada.Offset(1, 3).Value = "%"
        celdaSeleccionada.Offset(1, 4).Value = GetLocalResourceObject("lblAcumulado").ToString()

        hojaExcel.Range(celdaSeleccionada.Offset(1, 2), celdaSeleccionada.Offset(1, 4)).HorizontalAlignment = xlCenter
        hojaExcel.Range(celdaSeleccionada.Offset(1, 2), celdaSeleccionada.Offset(1, 4)).Font.Bold = True
        hojaExcel.Range(celdaSeleccionada.Offset(1, 2), celdaSeleccionada.Offset(1, 4)).VerticalAlignment = xlCenter

        'Dibujar duraciones
        celdaSeleccionada.Offset(2, 1).ColumnWidth = 25
        celdaSeleccionada.Offset(2, 1).Value = GetLocalResourceObject("lblDur1").ToString()
        celdaSeleccionada.Offset(3, 1).Value = GetLocalResourceObject("lblDur2").ToString()
        celdaSeleccionada.Offset(4, 1).Value = GetLocalResourceObject("lblDur3").ToString()
        celdaSeleccionada.Offset(5, 1).Value = GetLocalResourceObject("lblDur4").ToString()
        celdaSeleccionada.Offset(6, 1).Value = GetLocalResourceObject("lblDur5").ToString()
        celdaSeleccionada.Offset(7, 1).Value = GetLocalResourceObject("lblDur6").ToString()
        celdaSeleccionada.Offset(8, 1).Value = GetLocalResourceObject("lblDur7").ToString()
        celdaSeleccionada.Offset(9, 1).Value = GetLocalResourceObject("lblDur8").ToString()
        celdaSeleccionada.Offset(10, 1).Value = GetLocalResourceObject("lblDur9").ToString()
        celdaSeleccionada.Offset(11, 1).Value = GetLocalResourceObject("lblDur10").ToString()
        hojaExcel.Range(celdaSeleccionada.Offset(2, 1), celdaSeleccionada.Offset(11, 1)).HorizontalAlignment = xlLeft

        celdaSeleccionada = celdaSeleccionada.Offset(2, 1)

        Dim dtDuracionColectivoEncuestado As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionColectivoEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
        dtSumaColectivoEncuestadoCastellano = _sesion.Listados.CargarSumaDuracionColectivoEncuestadoCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())


        Dim dtDuracionFamiliarEncuestado As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionFamiliarEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
        dtSumaFamiliarEncuestadoCastellano = _sesion.Listados.CargarSumaDuracionFamiliarEncuestadoCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())


        Dim dtDuracionPersonalEncuestado As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionPersonalEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())
        dtSumaPersonalEncuestadoCastellano = _sesion.Listados.CargarSumaDuracionPersonalEncuestadoCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

        Dim denominador As Integer

        If esIdioma Then
            'Datos de la vivienda en castellano
            Dim dtDuracionEncuestadoFinalizadas As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionEncuestadoIdiomaFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual(), Globales.C_IDIOMA_CASTELLANO)


            If Not dtDuracionColectivoEncuestado Is Nothing Then
                totalColectivoEncuestado = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
            Else
                totalColectivoEncuestado = 0
            End If

            If Not dtDuracionFamiliarEncuestado Is Nothing Then
                totalFamiliarEncuestado = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
            Else
                totalFamiliarEncuestado = 0
            End If

            If Not dtDuracionPersonalEncuestado Is Nothing Then
                totalPersonalEncuestado = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'").Length
            Else
                totalPersonalEncuestado = 0
            End If

            denominador = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                denominador = dtDuracionEncuestadoFinalizadas.Rows.Count
            End If
            If denominador = 0 Then
                denominador = 1
            End If

            Dim denominadorPorcentaje = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                denominadorPorcentaje = dtDuracionEncuestadoFinalizadas.Rows.Count
            End If
            If denominadorPorcentaje = 0 Then denominadorPorcentaje = 1

            celdaSeleccionada.Offset(0, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(0, 1).Value = celdaSeleccionada.Offset(0, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur1).Length
            End If
            celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value


            celdaSeleccionada.Offset(1, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(1, 1).Value = celdaSeleccionada.Offset(1, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur1 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur2).Length
            End If
            celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value


            celdaSeleccionada.Offset(2, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(2, 1).Value = celdaSeleccionada.Offset(2, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur2 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur3).Length
            End If
            celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value


            celdaSeleccionada.Offset(3, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(3, 1).Value = celdaSeleccionada.Offset(3, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur3 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur4).Length
            End If
            celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value


            celdaSeleccionada.Offset(4, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(4, 1).Value = celdaSeleccionada.Offset(4, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur4 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur5).Length
            End If
            celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value


            celdaSeleccionada.Offset(5, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(5, 1).Value = celdaSeleccionada.Offset(5, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur5 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur6).Length
            End If
            celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value


            celdaSeleccionada.Offset(6, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(6, 1).Value = celdaSeleccionada.Offset(6, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur6 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur7).Length
            End If
            celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value


            celdaSeleccionada.Offset(7, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(7, 1).Value = celdaSeleccionada.Offset(7, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur7 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur8).Length
            End If
            celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value


            celdaSeleccionada.Offset(8, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(8, 1).Value = celdaSeleccionada.Offset(8, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur8 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur9).Length
            End If
            celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value


            celdaSeleccionada.Offset(9, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(9, 1).Value = celdaSeleccionada.Offset(9, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur9).Length
            End If
            celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value
        Else

            dtDuracionColectivoEncuestado = Nothing
            dtDuracionFamiliarEncuestado = Nothing
            dtDuracionPersonalEncuestado = Nothing

            For j As Integer = 0 To 9
                celdaSeleccionada.Offset(j, 1).Value = 0
                celdaSeleccionada.Offset(j, 2).Value = 0
                celdaSeleccionada.Offset(j, 3).Value = 0
            Next

        End If


        hojaExcel.Range(celdaSeleccionada.Offset(0, 2), celdaSeleccionada.Offset(9, 3)).NumberFormat = "#.##0,00"
        hojaExcel.Range(celdaSeleccionada.Offset(0, 1), celdaSeleccionada.Offset(9, 3)).HorizontalAlignment = xlRight

        'Media
        celdaSeleccionada.Offset(10, 0).Value = GetLocalResourceObject("lblMedia").ToString()
        celdaSeleccionada.Offset(10, 0).HorizontalAlignment = xlLeft

        Dim suma As Integer = 0

        If esIdioma Then
            dtSumaColectivoEncuestadoCastellano = _sesion.Listados.CargarSumaDuracionColectivoEncuestadoCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaFamiliarEncuestadoCastellano = _sesion.Listados.CargarSumaDuracionFamiliarEncuestadoCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaPersonalEncuestadoCastellano = _sesion.Listados.CargarSumaDuracionPersonalEncuestadoCastellanoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

            If Not dtSumaColectivoEncuestadoCastellano Is Nothing Then
                suma = suma + dtSumaColectivoEncuestadoCastellano.Rows(0)(0)
            End If
            If Not dtSumaFamiliarEncuestadoCastellano Is Nothing Then
                suma = suma + dtSumaFamiliarEncuestadoCastellano.Rows(0)(0)
            End If
            If Not dtSumaPersonalEncuestadoCastellano Is Nothing Then
                suma = suma + dtSumaPersonalEncuestadoCastellano.Rows(0)(0)
            End If

        Else
            suma = 0
            denominador = 1

        End If

        celdaSeleccionada.Offset(10, 1).Value = Decimal.Round(((Decimal.Round(suma, 2) / Decimal.Round(denominador, 2)) / 60), 2)
        celdaSeleccionada.Offset(10, 1).Value = celdaSeleccionada.Offset(10, 1).Value & " " & GetLocalResourceObject("lblMinutos").ToString()
        celdaSeleccionada.Offset(10, 1).ColumnWidth = 13
        celdaSeleccionada.Offset(10, 1).HorizontalAlignment = xlRight

        celdaSeleccionada.Offset(10, 0).Font.Bold = True
        celdaSeleccionada.Offset(10, 1).Font.Bold = True

        hasta = celdaSeleccionada.Offset(11, 3)

        hojaExcel.Range(desde, hasta).Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlSolid
        hojaExcel.Range(desde, hasta).Borders.Weight = Excel.XlBorderWeight.xlThick

        desde = celdaSeleccionada.Offset(0, -1)

        hojaExcel.Range(desde, hasta).Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone


        'EUSKERA o WEB
        celdaSeleccionada = celdaSeleccionada.Offset(13, -1)
        If esIdioma Then
            celdaSeleccionada.Value = GetLocalResourceObject("lblEuskera").ToString()
        Else
            celdaSeleccionada.Value = GetLocalResourceObject("lblWeb").ToString()
        End If
        Dim celdaBorrar As Excel.Range
        celdaBorrar = celdaSeleccionada.Offset(-1, 0)
        celdaBorrar.EntireRow.Delete()
        celdaSeleccionada.HorizontalAlignment = xlLeft
        celdaSeleccionada.Font.Bold = True
        celdaSeleccionada.ColumnWidth = 12

        celdaSeleccionada = celdaSeleccionada.Offset(-2, 0)

        celdaSeleccionada.Offset(2, 1).ColumnWidth = 25
        celdaSeleccionada.Offset(2, 1).Value = GetLocalResourceObject("lblDur1").ToString()
        celdaSeleccionada.Offset(3, 1).Value = GetLocalResourceObject("lblDur2").ToString()
        celdaSeleccionada.Offset(4, 1).Value = GetLocalResourceObject("lblDur3").ToString()
        celdaSeleccionada.Offset(5, 1).Value = GetLocalResourceObject("lblDur4").ToString()
        celdaSeleccionada.Offset(6, 1).Value = GetLocalResourceObject("lblDur5").ToString()
        celdaSeleccionada.Offset(7, 1).Value = GetLocalResourceObject("lblDur6").ToString()
        celdaSeleccionada.Offset(8, 1).Value = GetLocalResourceObject("lblDur7").ToString()
        celdaSeleccionada.Offset(9, 1).Value = GetLocalResourceObject("lblDur8").ToString()
        celdaSeleccionada.Offset(10, 1).Value = GetLocalResourceObject("lblDur9").ToString()
        celdaSeleccionada.Offset(11, 1).Value = GetLocalResourceObject("lblDur10").ToString()
        hojaExcel.Range(celdaSeleccionada.Offset(2, 1), celdaSeleccionada.Offset(11, 1)).HorizontalAlignment = xlLeft

        celdaSeleccionada = celdaSeleccionada.Offset(2, 1)

        'Datos de la vivienda en euskera
        dtDuracionColectivoEncuestado = _sesion.Listados.CargarDatosDuracionColectivoEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
        dtSumaColectivoEncuestadoEuskera = _sesion.Listados.CargarSumaDuracionColectivoEncuestadoEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())


        dtDuracionFamiliarEncuestado = _sesion.Listados.CargarDatosDuracionFamiliarEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
        dtSumaFamiliarEncuestadoEuskera = _sesion.Listados.CargarSumaDuracionFamiliarEncuestadoEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())


        dtDuracionPersonalEncuestado = _sesion.Listados.CargarDatosDuracionPersonalEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())
        dtSumaPersonalEncuestadoEuskera = _sesion.Listados.CargarSumaDuracionPersonalEncuestadoEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

        If esIdioma Then
            If Not dtDuracionColectivoEncuestado Is Nothing Then
                totalColectivoEncuestado = dtDuracionColectivoEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
            Else
                totalColectivoEncuestado = 0
            End If

            If Not dtDuracionFamiliarEncuestado Is Nothing Then
                totalFamiliarEncuestado = dtDuracionFamiliarEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
            Else
                totalFamiliarEncuestado = 0
            End If

            If Not dtDuracionPersonalEncuestado Is Nothing Then
                totalPersonalEncuestado = dtDuracionPersonalEncuestado.Select(Globales.COL_CUESTFAM_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'").Length
            Else
                totalPersonalEncuestado = 0
            End If

            Dim dtDuracionEncuestadoFinalizadas As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionEncuestadoIdiomaFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual(), Globales.C_IDIOMA_EUSKERA)

            denominador = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                denominador = dtDuracionEncuestadoFinalizadas.Rows.Count
            End If
            If denominador = 0 Then
                denominador = 1
            End If

            Dim denominadorPorcentaje = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                denominadorPorcentaje = dtDuracionEncuestadoFinalizadas.Rows.Count
            End If
            If denominadorPorcentaje = 0 Then denominadorPorcentaje = 1

            celdaSeleccionada.Offset(0, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(0, 1).Value = celdaSeleccionada.Offset(0, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur1).Length
            End If
            celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value


            celdaSeleccionada.Offset(1, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(1, 1).Value = celdaSeleccionada.Offset(1, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur1 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur2).Length
            End If
            celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value


            celdaSeleccionada.Offset(2, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(2, 1).Value = celdaSeleccionada.Offset(2, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur2 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur3).Length
            End If
            celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value


            celdaSeleccionada.Offset(3, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(3, 1).Value = celdaSeleccionada.Offset(3, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur3 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur4).Length
            End If
            celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value


            celdaSeleccionada.Offset(4, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(4, 1).Value = celdaSeleccionada.Offset(4, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur4 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur5).Length
            End If
            celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value


            celdaSeleccionada.Offset(5, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(5, 1).Value = celdaSeleccionada.Offset(5, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur5 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur6).Length
            End If
            celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value


            celdaSeleccionada.Offset(6, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(6, 1).Value = celdaSeleccionada.Offset(6, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur6 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur7).Length
            End If
            celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value


            celdaSeleccionada.Offset(7, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(7, 1).Value = celdaSeleccionada.Offset(7, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur7 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur8).Length
            End If
            celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value


            celdaSeleccionada.Offset(8, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(8, 1).Value = celdaSeleccionada.Offset(8, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur8 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur9).Length
            End If
            celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value


            celdaSeleccionada.Offset(9, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(9, 1).Value = celdaSeleccionada.Offset(9, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur9).Length
            End If
            celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value
        Else

            Dim columnaConsulta As String = String.Empty
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar() Then
                columnaConsulta = Globales.COL_CONSULTAIND_FORMFAM
            Else
                columnaConsulta = Globales.COL_CONSULTAIND_FORMPER
            End If

            If Not dtDuracionColectivoEncuestado Is Nothing Then
                totalColectivoEncuestado = dtDuracionColectivoEncuestado.Select(columnaConsulta & " = " & Globales.FORM_WEB).Length
            Else
                totalColectivoEncuestado = 0
            End If

            If Not dtDuracionFamiliarEncuestado Is Nothing Then
                totalFamiliarEncuestado = dtDuracionFamiliarEncuestado.Select(Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB).Length
            Else
                totalFamiliarEncuestado = 0
            End If

            If Not dtDuracionPersonalEncuestado Is Nothing Then
                totalPersonalEncuestado = dtDuracionPersonalEncuestado.Select(Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB).Length
            Else
                totalPersonalEncuestado = 0
            End If

            Dim dtDuracionEncuestadoFinalizadas As System.Data.DataTable = _sesion.Listados.CargarDatosDuracionEncuestadoIdiomaFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual(), String.Empty)

            denominador = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                denominador = dtDuracionEncuestadoFinalizadas.Rows.Count
            End If
            If denominador = 0 Then
                denominador = 1
            End If

            Dim denominadorPorcentaje = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                denominadorPorcentaje = dtDuracionEncuestadoFinalizadas.Rows.Count
            End If
            If denominadorPorcentaje = 0 Then denominadorPorcentaje = 1



            celdaSeleccionada.Offset(0, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(0, 1).Value = celdaSeleccionada.Offset(0, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur1).Length
            End If
            celdaSeleccionada.Offset(0, 2).Value = ((celdaSeleccionada.Offset(0, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(0, 3).Value = celdaSeleccionada.Offset(0, 2).Value


            celdaSeleccionada.Offset(1, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(1, 1).Value = celdaSeleccionada.Offset(1, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur1 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur2).Length
            End If
            celdaSeleccionada.Offset(1, 2).Value = ((celdaSeleccionada.Offset(1, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(1, 3).Value = celdaSeleccionada.Offset(0, 3).Value + celdaSeleccionada.Offset(1, 2).Value


            celdaSeleccionada.Offset(2, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(2, 1).Value = celdaSeleccionada.Offset(2, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur2 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur3).Length
            End If
            celdaSeleccionada.Offset(2, 2).Value = ((celdaSeleccionada.Offset(2, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(2, 3).Value = celdaSeleccionada.Offset(1, 3).Value + celdaSeleccionada.Offset(2, 2).Value


            celdaSeleccionada.Offset(3, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(3, 1).Value = celdaSeleccionada.Offset(3, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur3 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur4).Length
            End If
            celdaSeleccionada.Offset(3, 2).Value = ((celdaSeleccionada.Offset(3, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(3, 3).Value = celdaSeleccionada.Offset(2, 3).Value + celdaSeleccionada.Offset(3, 2).Value


            celdaSeleccionada.Offset(4, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(4, 1).Value = celdaSeleccionada.Offset(4, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur4 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur5).Length
            End If
            celdaSeleccionada.Offset(4, 2).Value = ((celdaSeleccionada.Offset(4, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(4, 3).Value = celdaSeleccionada.Offset(3, 3).Value + celdaSeleccionada.Offset(4, 2).Value


            celdaSeleccionada.Offset(5, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(5, 1).Value = celdaSeleccionada.Offset(5, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur5 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur6).Length
            End If
            celdaSeleccionada.Offset(5, 2).Value = ((celdaSeleccionada.Offset(5, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(5, 3).Value = celdaSeleccionada.Offset(4, 3).Value + celdaSeleccionada.Offset(5, 2).Value


            celdaSeleccionada.Offset(6, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(6, 1).Value = celdaSeleccionada.Offset(6, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur6 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur7).Length
            End If
            celdaSeleccionada.Offset(6, 2).Value = ((celdaSeleccionada.Offset(6, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(6, 3).Value = celdaSeleccionada.Offset(5, 3).Value + celdaSeleccionada.Offset(6, 2).Value


            celdaSeleccionada.Offset(7, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(7, 1).Value = celdaSeleccionada.Offset(7, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur7 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur8).Length
            End If
            celdaSeleccionada.Offset(7, 2).Value = ((celdaSeleccionada.Offset(7, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(7, 3).Value = celdaSeleccionada.Offset(6, 3).Value + celdaSeleccionada.Offset(7, 2).Value


            celdaSeleccionada.Offset(8, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(8, 1).Value = celdaSeleccionada.Offset(8, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur8 & " AND " & Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " <= " & dur9).Length
            End If
            celdaSeleccionada.Offset(8, 2).Value = ((celdaSeleccionada.Offset(8, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(8, 3).Value = celdaSeleccionada.Offset(7, 3).Value + celdaSeleccionada.Offset(8, 2).Value


            celdaSeleccionada.Offset(9, 1).Value = 0
            If Not dtDuracionEncuestadoFinalizadas Is Nothing Then
                celdaSeleccionada.Offset(9, 1).Value = celdaSeleccionada.Offset(9, 1).Value + dtDuracionEncuestadoFinalizadas.Select(Eustat.GEDW.V35.Ng.Listados._totalCuestionarios & " > " & dur9).Length
            End If
            celdaSeleccionada.Offset(9, 2).Value = ((celdaSeleccionada.Offset(9, 1).Value * 100) / denominadorPorcentaje)
            celdaSeleccionada.Offset(9, 3).Value = celdaSeleccionada.Offset(8, 3).Value + celdaSeleccionada.Offset(9, 2).Value

        End If



        hojaExcel.Range(celdaSeleccionada.Offset(0, 2), celdaSeleccionada.Offset(9, 3)).NumberFormat = "#.##0,00"
        hojaExcel.Range(celdaSeleccionada.Offset(0, 1), celdaSeleccionada.Offset(9, 3)).HorizontalAlignment = xlRight

        'Media
        celdaSeleccionada.Offset(10, 0).Value = GetLocalResourceObject("lblMedia").ToString()
        celdaSeleccionada.Offset(10, 0).HorizontalAlignment = xlLeft

        If esIdioma Then
            dtSumaColectivoEncuestadoEuskera = _sesion.Listados.CargarSumaDuracionColectivoEncuestadoEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaFamiliarEncuestadoEuskera = _sesion.Listados.CargarSumaDuracionFamiliarEncuestadoEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaPersonalEncuestadoEuskera = _sesion.Listados.CargarSumaDuracionPersonalEncuestadoEuskeraFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

            suma = 0
            If Not dtSumaColectivoEncuestadoEuskera Is Nothing Then
                suma = suma + dtSumaColectivoEncuestadoEuskera.Rows(0)(0)
            End If
            If Not dtSumaFamiliarEncuestadoEuskera Is Nothing Then
                suma = suma + dtSumaFamiliarEncuestadoEuskera.Rows(0)(0)
            End If
            If Not dtSumaPersonalEncuestadoEuskera Is Nothing Then
                suma = suma + dtSumaPersonalEncuestadoEuskera.Rows(0)(0)
            End If
        Else
            dtSumaColectivoEncuestado = _sesion.Listados.CargarSumaDuracionColectivoEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasColectivo(), _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaFamiliarEncuestado = _sesion.Listados.CargarSumaDuracionFamiliarEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar())
            dtSumaPersonalEncuestado = _sesion.Listados.CargarSumaDuracionPersonalEncuestadoFinalizadas(_sesion.EncuestaSeleccionadaInfo.HasCuestionarioIndividual())

            suma = 0
            If Not dtSumaColectivoEncuestado Is Nothing Then
                suma = suma + dtSumaColectivoEncuestado.Rows(0)(0)
            End If
            If Not dtSumaFamiliarEncuestado Is Nothing Then
                suma = suma + dtSumaFamiliarEncuestado.Rows(0)(0)
            End If
            If Not dtSumaPersonalEncuestado Is Nothing Then
                suma = suma + dtSumaPersonalEncuestado.Rows(0)(0)
            End If

        End If

        celdaSeleccionada.Offset(10, 1).Value = Decimal.Round(((Decimal.Round(suma, 2) / Decimal.Round(denominador, 2)) / 60), 2)
        celdaSeleccionada.Offset(10, 1).Value = celdaSeleccionada.Offset(10, 1).Value & " " & GetLocalResourceObject("lblMinutos").ToString()
        celdaSeleccionada.Offset(10, 1).ColumnWidth = 13
        celdaSeleccionada.Offset(10, 1).HorizontalAlignment = xlRight

        celdaSeleccionada.Offset(10, 0).Font.Bold = True
        celdaSeleccionada.Offset(10, 1).Font.Bold = True

        hasta = celdaSeleccionada.Offset(11, 3)
        desde = celdaSeleccionada.Offset(0, -1)

        hojaExcel.Range(desde, hasta).Borders(Excel.XlBordersIndex.xlInsideVertical).LineStyle = xlSolid
        hojaExcel.Range(desde, hasta).Borders.Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range(desde, hasta).Borders(Excel.XlBordersIndex.xlInsideHorizontal).LineStyle = xlNone

    End Sub


    Sub DibujarInformeDuracionElementosComunes(ByVal hojaExcel As Excel.Worksheet, ByVal libroexcel As Excel.Workbook)
        hojaExcel.Range("A1").ColumnWidth = 20
        hojaExcel.Range("A2").Borders.Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("A2").Borders.Color = RGB(0, 0, 0)
        'hojaExcel.Range("A2").ColumnWidth = 6.15
        hojaExcel.Range("C2").Value = String.Format(GetLocalResourceObject("lblTitulo6Resource1Operacion.Text").ToString().ToUpper(), _sesion.Operacion) & _
            Chr(10) & GetLocalResourceObject("lblAnioResource1.Text") & " " & DropDownListAnio.SelectedValue
        If DropDownListTrim.SelectedValue <> String.Empty Then
            hojaExcel.Range("C2").Value = hojaExcel.Range("C2").Value & " " & GetLocalResourceObject("lblTrimResource1.Text") & " " & DropDownListTrim.SelectedValue
        End If
        hojaExcel.Range("C2").Font.Bold = True
        hojaExcel.Range("A2:N2").Borders.LineStyle = xlNone
        hojaExcel.Range("A2:B2").Borders.Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("C2").Borders.Weight = Excel.XlBorderWeight.xlThick

        'hojaExcel.Range("C3").Font.Bold = True
        'hojaExcel.Range("A3:N3").Borders.LineStyle = xlNone
        'hojaExcel.Range("A3:B3").Borders.Weight = Excel.XlBorderWeight.xlThick
        'hojaExcel.Range("C3").Borders.Weight = Excel.XlBorderWeight.xlThick
        'hojaExcel.Range("C3:K3").Merge()
        'hojaExcel.Range("C3").RowHeight = 30
        'hojaExcel.Range("C3").HorizontalAlignment = xlCenter

        ''hojaExcel.Range("B4").RowHeight = 45.75
        'hojaExcel.Range("A4:B4").Borders.Weight = Excel.XlBorderWeight.xlMedium
        'hojaExcel.Range("A4").Borders(XlBordersIndex.xlEdgeRight).LineStyle = xlNone
        'hojaExcel.Range("B4").ColumnWidth = 29

        hojaExcel.Range("C1").ColumnWidth = 14
        hojaExcel.Range("C2:K2").Merge()
        hojaExcel.Range("C2:K2").Borders(XlBordersIndex.xlEdgeBottom).LineStyle = xlNone
        hojaExcel.Range("C2:K2").Borders.ColorIndex = 0
        hojaExcel.Range("C2:K2").Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("C2:K2").Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("C2:K2").Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("C2:K2").Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
        hojaExcel.Range("C2").RowHeight = 31

        'Fecha
        hojaExcel.Range("A1").Value = GetLocalResourceObject("lblFechaDoc") & " " & FormatDateTime(Now, DateFormat.GeneralDate)
        hojaExcel.Range("A1").VerticalAlignment = xlCenter
        hojaExcel.Range("A1").HorizontalAlignment = xlLeft
        hojaExcel.Range("A1").WrapText = False
        hojaExcel.Range("A1").ShrinkToFit = False

    End Sub




    Public Sub GenerarT7()
        ' Guardar el idioma actual
        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        Try

            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If

            Dim ExcelApplication As New Excel.Application
            Dim libroexcel As Excel.Workbook
            Dim hojaExcel As New Excel.Worksheet
            Dim bytes() As Byte = Nothing
            'id_excel = ExcelApplication.Hinstance
            id_excel = ExcelApplication.HinstancePtr

            ExcelApplication = New Excel.Application
            Dim plantilla As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATH") + System.Configuration.ConfigurationManager.AppSettings.Get("NOM_PLANTILLA_EXCEL")

            ' Cambiar el idioma a castellano, para que no casque la generación del Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")

            ExcelApplication.Workbooks.Add(plantilla)

            Dim filename As String
            If (DropDownListTrim.SelectedValue <> String.Empty) Then
                filename = GetLocalResourceObject("lblListado7").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension
            Else
                filename = GetLocalResourceObject("lblListado7").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & extension
            End If


            libroexcel = ExcelApplication.Workbooks(1)
            libroexcel.Activate()

            hojaExcel = libroexcel.ActiveSheet

            If (GetLocalResourceObject("lblListado7").ToString.Length > 30) Then
                hojaExcel.Name = GetLocalResourceObject("lblListado7").ToString.Substring(0, 30)
            Else
                hojaExcel.Name = GetLocalResourceObject("lblListado7").ToString
            End If

            libroexcel.Sheets("Hoja2").visible = False
            libroexcel.Sheets("Hoja3").visible = False

            hojaExcel.Cells.Font.Size = 11

            hojaExcel.Visible = True

            'EXCEL
            hojaExcel.Range("A2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("A2").Borders.Color = RGB(0, 0, 0)
            hojaExcel.Range("A2").ColumnWidth = 6.15
            hojaExcel.Range("C2").Value = String.Format(GetLocalResourceObject("lblTitulo7Resource1Operacion.Text").ToString().ToUpper(), _sesion.Operacion)
            hojaExcel.Range("C2").Font.Bold = True
            hojaExcel.Range("A2:N2").Borders.LineStyle = xlNone
            hojaExcel.Range("A2:B2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C2").Borders.Weight = Excel.XlBorderWeight.xlThick
            If (DropDownListTrim.SelectedValue <> String.Empty) Then
                hojaExcel.Range("C3").Value = GetLocalResourceObject("lblSitu").ToString() & Chr(10) & GetLocalResourceObject("lblAnioResource1.Text") & " " & _
               DropDownListAnio.SelectedValue & " " & GetLocalResourceObject("lblTrimResource1.Text") & " " & DropDownListTrim.SelectedValue
            Else
                hojaExcel.Range("C3").Value = GetLocalResourceObject("lblSitu").ToString() & Chr(10) & GetLocalResourceObject("lblAnioResource1.Text") & " " & _
               DropDownListAnio.SelectedValue
            End If
            hojaExcel.Range("C3").Font.Bold = True
            hojaExcel.Range("A3:N3").Borders.LineStyle = xlNone
            hojaExcel.Range("A3:B3").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C3").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C3:M3").Merge()
            hojaExcel.Range("C3").RowHeight = 30
            hojaExcel.Range("C3").HorizontalAlignment = xlCenter

            hojaExcel.Range("B4").Value = GetLocalResourceObject("lblEstato")
            hojaExcel.Range("B4").Font.Bold = True
            hojaExcel.Range("B4").HorizontalAlignment = xlLeft
            hojaExcel.Range("B4").VerticalAlignment = xlBottom
            hojaExcel.Range("B4").RowHeight = 45.75
            hojaExcel.Range("A4:B4").Borders.Weight = Excel.XlBorderWeight.xlMedium
            hojaExcel.Range("A4").Borders(XlBordersIndex.xlEdgeRight).LineStyle = xlNone
            hojaExcel.Range("B4").ColumnWidth = 39

            'Dibujar situaciones
            Dim SituacionesLN As Situaciones = New Situaciones()
            Dim dtSituaciones As System.Data.DataTable = SituacionesLN.GetDsSituaciones.Tables(0)
            For f As Integer = 0 To dtSituaciones.Rows.Count - 1
                If (f < (dtSituaciones.Rows.Count)) Then
                    If dtSituaciones.Rows(f)(SituacionesLN.ColumnaId) Is DBNull.Value Then
                        dtSituaciones.Rows(f).Delete()
                        dtSituaciones.AcceptChanges()
                    End If
                End If
            Next

            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Merge()
            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Borders.Color = RGB(0, 0, 0)
            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C2:" + hojaExcel.Cells(2, dtSituaciones.Rows.Count + 3).Address().ToString().Replace("$", "").ToString()).Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick

            Dim celdaSeleccionada As Excel.Range = hojaExcel.Range("C4")
            For j As Integer = 0 To dtSituaciones.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.Value = dtSituaciones.Rows(j)(SituacionesLN.ColumnaDescripcion(_sesion.Idioma)).ToString()
                If celdaSeleccionada.Value.ToString().Length > 20 Then
                    celdaSeleccionada.ColumnWidth = 15
                Else
                    celdaSeleccionada.ColumnWidth = 11
                End If
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Bold = True
                celdaSeleccionada.HorizontalAlignment = xlCenter
                celdaSeleccionada.VerticalAlignment = xlBottom
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
            Next
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlMedium
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlMedium
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlMedium
            celdaSeleccionada.Value = GetLocalResourceObject("lblTotal")
            celdaSeleccionada.Font.Bold = True
            celdaSeleccionada.ColumnWidth = 8
            celdaSeleccionada.HorizontalAlignment = xlCenter
            celdaSeleccionada.VerticalAlignment = xlBottom

            Dim e_Listados As Eustat.GEDW.V35.Ng.Listados = New Eustat.GEDW.V35.Ng.Listados(_sesion.Operacion)
            _sesion.Listados = e_Listados

            'Dibujar las comarcas
            celdaSeleccionada = hojaExcel.Range("B5")
            For j As Integer = 1 To 6
                celdaSeleccionada.Offset(0, -1).Value = j
                celdaSeleccionada.Offset(0, -1).HorizontalAlignment = xlRight
                celdaSeleccionada.Offset(0, -1).VerticalAlignment = xlCenter
                celdaSeleccionada.Offset(0, -1).Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.Value = GetLocalResourceObject("lblEstrato" + j.ToString())
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                celdaSeleccionada.ShrinkToFit = False
                celdaSeleccionada.ColumnWidth = 47
            Next

            celdaSeleccionada.Offset(0, -1).Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlMedium
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlMedium

            _sesion.Listados.Anio = DropDownListAnio.SelectedValue
            _sesion.Listados.Trim = DropDownListTrim.SelectedValue

            Dim dt As System.Data.DataTable = _sesion.Listados.CargarDatosListado7()

            'DATOS
            Dim estrato As String
            Dim situacion As String

            ''Por estrato y situación
            celdaSeleccionada = hojaExcel.Range("C5")
            For j As Integer = 0 To 5

                estrato = (j + 1).ToString()

                For k As Integer = 0 To dtSituaciones.Rows.Count - 1
                    situacion = dtSituaciones.Rows(k)(SituacionesLN.ColumnaId).ToString()

                    celdaSeleccionada.HorizontalAlignment = xlRight

                    If dt.Select(Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length > 0 Then
                        celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "' AND " & Globales.COL_CONSULTAVIV_SIT & " = '" & situacion & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If

                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
                    If j = 5 Then
                        celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlMedium
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
                Next

                'total sin situación, por estato
                If dt.Select(Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                    celdaSeleccionada.Value = dt.Select(Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If

                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlMedium
                If j = 5 Then
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlMedium
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(1, -dtSituaciones.Rows.Count)
            Next

            'Fecha
            hojaExcel.Range("A1").Value = GetLocalResourceObject("lblFechaDoc") & " " & FormatDateTime(Now, DateFormat.GeneralDate)
            hojaExcel.Range("A1").VerticalAlignment = xlCenter
            hojaExcel.Range("A1").HorizontalAlignment = xlLeft
            hojaExcel.Range("A1").WrapText = False
            hojaExcel.Range("A1").ShrinkToFit = False

            hojaExcel.Activate()

            Dim hojas(libroexcel.Sheets.Count - 1) As Excel.Worksheet
            Dim i As Integer = 0
            For i = 0 To libroexcel.Sheets.Count - 1
                hojas(i) = libroexcel.Sheets.Item(i + 1)
            Next

            'filename = GetLocalResourceObject("lblListado7").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension
            nombreFicheroPlantillaExcel = filename
            _sesion.NameListado = filename
            bytesFicheroExcel = bytes

            'Guardar el fichero
            If (DropDownListTrim.SelectedValue <> String.Empty) Then
                Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado7") + "_" + DropDownListAnio.SelectedValue + "_" + DropDownListTrim.SelectedValue + "_" + extension + ".xls")
            Else
                Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado7") + "_" + DropDownListAnio.SelectedValue + "_" + extension + ".xls")
            End If

        Catch ex As Exception
            Throw ex
        Finally
            ' Devolver el idioma que tenía antes de generar el Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI
        End Try
    End Sub



    Public Sub GenerarT8()
        ' Guardar el idioma actual
        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        Try

            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If

            Dim ExcelApplication As New Excel.Application
            Dim libroexcel As Excel.Workbook
            Dim hojaExcel As New Excel.Worksheet
            Dim bytes() As Byte = Nothing
            'id_excel = ExcelApplication.Hinstance
            id_excel = ExcelApplication.HinstancePtr

            ExcelApplication = New Excel.Application
            Dim plantilla As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATH") + System.Configuration.ConfigurationManager.AppSettings.Get("NOM_PLANTILLA_EXCEL")

            ' Cambiar el idioma a castellano, para que no casque la generación del Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")

            ExcelApplication.Workbooks.Add(plantilla)

            Dim filename As String
            If DropDownListTrim.SelectedValue <> String.Empty Then
                filename = GetLocalResourceObject("lblListado8").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension
            Else
                filename = GetLocalResourceObject("lblListado8").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & extension
            End If


            libroexcel = ExcelApplication.Workbooks(1)
            libroexcel.Activate()

            hojaExcel = libroexcel.ActiveSheet

            If (GetLocalResourceObject("lblListado8").ToString.Length > 30) Then
                hojaExcel.Name = GetLocalResourceObject("lblListado8").ToString.Substring(0, 30)
            Else
                hojaExcel.Name = GetLocalResourceObject("lblListado8").ToString
            End If

            libroexcel.Sheets("Hoja2").visible = False
            libroexcel.Sheets("Hoja3").visible = False

            hojaExcel.Cells.Font.Size = 11

            hojaExcel.Visible = True

            'EXCEL
            hojaExcel.Range("A2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("A2").Borders.Color = RGB(0, 0, 0)

            If DropDownListTrim.SelectedValue <> String.Empty Then
                hojaExcel.Range("B2").Value = String.Format(GetLocalResourceObject("lblTitulo8Resource1Operacion.Text").ToString().ToUpper(), _sesion.Operacion) & " " & GetLocalResourceObject("lblAnioResource1.Text") & " " & _
               DropDownListAnio.SelectedValue & " " & GetLocalResourceObject("lblTrimResource1.Text") & " " & DropDownListTrim.SelectedValue
            Else
                hojaExcel.Range("B2").Value = String.Format(GetLocalResourceObject("lblTitulo8Resource1Operacion.Text").ToString().ToUpper(), _sesion.Operacion) & " " & GetLocalResourceObject("lblAnioResource1.Text") & " " & _
                   DropDownListAnio.SelectedValue
            End If

            hojaExcel.Range("B2").Font.Bold = True
            hojaExcel.Range("B2:H2").Merge()
            hojaExcel.Range("B2:H2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("B2:H2").Borders.Color = RGB(0, 0, 0)
            hojaExcel.Range("I2:N2").Borders(XlBordersIndex.xlEdgeBottom).LineStyle = xlNone
            hojaExcel.Range("I2:N2").Borders(XlBordersIndex.xlEdgeTop).LineStyle = xlNone
            hojaExcel.Range("I2:N2").Borders(XlBordersIndex.xlEdgeRight).LineStyle = xlNone

            hojaExcel.Range("B3").Value = GetLocalResourceObject("lblEstrato").ToString().ToUpper()
            hojaExcel.Range("B3").Font.Bold = True
            hojaExcel.Range("B3").HorizontalAlignment = xlCenter
            hojaExcel.Range("B3").VerticalAlignment = xlCenter
            hojaExcel.Range("B3:H3").Merge()
            hojaExcel.Range("B3").RowHeight = 15.75
            hojaExcel.Range("B3:H3").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("A4").Value = GetLocalResourceObject("lblResultadoPersonal")
            hojaExcel.Range("A4").Font.Bold = True
            hojaExcel.Range("A4").Borders.Weight = Excel.XlBorderWeight.xlThick

            'Dibujar estratos
            hojaExcel.Range("B4").Value = GetLocalResourceObject("lblEstrato1")
            hojaExcel.Range("C4").Value = GetLocalResourceObject("lblEstrato2")
            hojaExcel.Range("D4").Value = GetLocalResourceObject("lblEstrato3")
            hojaExcel.Range("E4").Value = GetLocalResourceObject("lblEstrato4")
            hojaExcel.Range("F4").Value = GetLocalResourceObject("lblEstrato5")
            hojaExcel.Range("G4").Value = GetLocalResourceObject("lblEstrato6")
            hojaExcel.Range("H4").Value = GetLocalResourceObject("lblTotal")
            hojaExcel.Range("B4:G4").ColumnWidth = 25
            hojaExcel.Range("H4").ColumnWidth = 7
            hojaExcel.Range("B4").RowHeight = 34.5
            hojaExcel.Range("B4:H4").Font.Bold = True
            hojaExcel.Range("B4:H4").HorizontalAlignment = xlCenter
            hojaExcel.Range("B4:H4").Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("B4:H4").Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("B4:H4").Borders(XlBordersIndex.xlInsideVertical).Weight = Excel.XlBorderWeight.xlThick

            Dim e_Listados As Eustat.GEDW.V35.Ng.Listados = New Eustat.GEDW.V35.Ng.Listados(_sesion.Operacion)
            _sesion.Listados = e_Listados

            Dim dtIncidencias As System.Data.DataTable = _sesion.Listados.CargarIncidencias()

            _sesion.MetodoCump = New Eustat.GEDW.V35.Ng.MetodoCump()
            Dim dtFormaCumplimentacion As System.Data.DataTable = _sesion.MetodoCump.GetDsMetodo().Tables(0)
            For f As Integer = 0 To dtFormaCumplimentacion.Rows.Count - 1
                If (f < (dtFormaCumplimentacion.Rows.Count)) Then
                    If dtFormaCumplimentacion.Rows(f)(_sesion.MetodoCump.ColumnaId) Is DBNull.Value Then
                        dtFormaCumplimentacion.Rows(f).Delete()
                        dtFormaCumplimentacion.AcceptChanges()
                    End If
                End If
            Next

            'se solicita incluir una nueva fila para los casos en los que el método de cumplimentación es vacio
            Dim dtRow As DataRow
            dtRow = dtFormaCumplimentacion.NewRow
            dtRow(_sesion.MetodoCump.ColumnaId) = "-1"
            dtRow(_sesion.MetodoCump.ColumnaDescripcion(Globales.C_IDIOMA_CASTELLANO)) = GetLocalResourceObject("lblSinDeterminar").ToString()
            dtRow(_sesion.MetodoCump.ColumnaDescripcion(Globales.C_IDIOMA_EUSKERA)) = GetLocalResourceObject("lblSinDeterminar").ToString()
            dtFormaCumplimentacion.Rows.Add(dtRow)


            Dim dtProvincias As System.Data.DataTable = _sesion.ProvinciasInfo.GetProvinciasCAV().ToTable()
            For f As Integer = 0 To dtProvincias.Rows.Count - 1
                If (f < (dtProvincias.Rows.Count)) Then
                    If dtProvincias.Rows(f)(Globales.ALIAS_PROV_NOMBRE) Is String.Empty Then
                        dtProvincias.Rows(f).Delete()
                        dtProvincias.AcceptChanges()
                    End If
                End If
            Next

            'Dibujar para cada territorio, forma de cumplimentación e incidencias
            Dim celdaSeleccionada As Excel.Range = hojaExcel.Range("A5")
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.IndentLevel = 0
                celdaSeleccionada.Font.Color = RGB(0, 0, 0)
                celdaSeleccionada.Font.Color = RGB(0, 0, 0)
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Bold = True
                celdaSeleccionada.Value = dtProvincias.Rows(j)(Globales.ALIAS_PROV_NOMBRE).ToString().ToUpper()
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

                celdaSeleccionada.Value = GetLocalResourceObject("lblEncuestados")
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.RowHeight = 15
                'celdaSeleccionada.IndentLevel = 2
                celdaSeleccionada.Font.Bold = True
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)


                For k = 0 To dtFormaCumplimentacion.Rows.Count - 1
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.HorizontalAlignment = xlLeft
                    celdaSeleccionada.VerticalAlignment = xlCenter
                    celdaSeleccionada.Value = dtFormaCumplimentacion.Rows(k)(_sesion.MetodoCump.ColumnaDescripcion(_sesion.Idioma)).ToString()
                    celdaSeleccionada.Font.Bold = False
                    celdaSeleccionada.Font.Italic = True
                    celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                    celdaSeleccionada.IndentLevel = 4
                    celdaSeleccionada.RowHeight = 15
                    celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                Next


                celdaSeleccionada.Value = GetLocalResourceObject("lblIncidencias")
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.RowHeight = 15
                celdaSeleccionada.IndentLevel = 2
                celdaSeleccionada.Font.Bold = True
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

                For k As Integer = 0 To dtIncidencias.Rows.Count - 1
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.HorizontalAlignment = xlLeft
                    celdaSeleccionada.VerticalAlignment = xlCenter
                    celdaSeleccionada.Value = dtIncidencias.Rows(k)(_sesion.Listados.ColumnaDescripcionIncidencias(_sesion.Idioma)).ToString()
                    celdaSeleccionada.Font.Bold = False
                    celdaSeleccionada.Font.Italic = True
                    celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                    celdaSeleccionada.RowHeight = 15
                    celdaSeleccionada.IndentLevel = 4
                    celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                Next
            Next
            'Total
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = GetLocalResourceObject("lblTotalCAPV").ToString().ToUpper()
            celdaSeleccionada.HorizontalAlignment = xlLeft
            celdaSeleccionada.VerticalAlignment = xlCenter
            celdaSeleccionada.IndentLevel = 0
            celdaSeleccionada.Font.Color = RGB(0, 0, 0)
            celdaSeleccionada.Font.Italic = True
            celdaSeleccionada.Font.Bold = True
            celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

            celdaSeleccionada.Value = GetLocalResourceObject("lblEncuestados")
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.HorizontalAlignment = xlLeft
            celdaSeleccionada.VerticalAlignment = xlCenter
            celdaSeleccionada.RowHeight = 15
            celdaSeleccionada.IndentLevel = 2
            celdaSeleccionada.Font.Bold = True
            celdaSeleccionada.Font.Italic = True
            celdaSeleccionada.Font.Color = RGB(255, 0, 0)
            celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

            For k As Integer = 0 To dtFormaCumplimentacion.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.Value = dtFormaCumplimentacion.Rows(k)(_sesion.MetodoCump.ColumnaDescripcion(_sesion.Idioma)).ToString()
                celdaSeleccionada.Font.Bold = False
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                celdaSeleccionada.IndentLevel = 4
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            Next

            celdaSeleccionada.Value = GetLocalResourceObject("lblIncidencias")
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.HorizontalAlignment = xlLeft
            celdaSeleccionada.VerticalAlignment = xlCenter
            celdaSeleccionada.RowHeight = 15
            celdaSeleccionada.IndentLevel = 2
            celdaSeleccionada.Font.Bold = True
            celdaSeleccionada.Font.Italic = True
            celdaSeleccionada.Font.Color = RGB(255, 0, 0)
            celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

            For k As Integer = 0 To dtIncidencias.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.Value = dtIncidencias.Rows(k)(_sesion.Listados.ColumnaDescripcionIncidencias(_sesion.Idioma)).ToString()
                celdaSeleccionada.Font.Bold = False
                celdaSeleccionada.Font.Italic = True
                celdaSeleccionada.Font.Color = RGB(255, 0, 0)
                celdaSeleccionada.RowHeight = 15
                celdaSeleccionada.IndentLevel = 4
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            Next
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick

            _sesion.Listados.Anio = DropDownListAnio.SelectedValue
            _sesion.Listados.Trim = DropDownListTrim.SelectedValue

            Dim dtDatosFormaCumplimentacion As System.Data.DataTable = _sesion.Listados.CargarDatosFormaListado8()
            Dim dtDatosIncidencias As System.Data.DataTable = _sesion.Listados.CargarDatosIncidenciasListado8()

            ''DATOS
            Dim estrato As Integer
            Dim incidencia As String
            Dim formaCumplimentacion As String
            Dim provincia As String
            Dim datoForma, datoIncidencia As Integer


            celdaSeleccionada = hojaExcel.Range("B5")
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                'Por territorio, total forma de cumplimentación

                provincia = dtProvincias.Rows(j)(Globales.ALIAS_PROV_ID).ToString()
                For estrato = 1 To 6

                    celdaSeleccionada.HorizontalAlignment = xlRight
                    'TOTALES POR PROVINCIA
                    If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                        datoForma = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                    Else
                        datoForma = 0
                    End If
                    If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                        datoIncidencia = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                    Else
                        datoIncidencia = 0
                    End If
                    celdaSeleccionada.Value = datoForma + datoIncidencia

                    celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                    celdaSeleccionada.HorizontalAlignment = xlRight
                    If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(-1, 1)

                Next
                'Total incidencias + forma por territorio
                celdaSeleccionada.HorizontalAlignment = xlRight
                If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length > 0 Then
                    datoForma = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length
                Else
                    datoForma = 0
                End If
                If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length > 0 Then
                    datoIncidencia = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length
                Else
                    datoIncidencia = 0
                End If
                celdaSeleccionada.Value = datoForma + datoIncidencia

                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
                'total por territorio y forma de cumplimentación sin semana
                If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada.Offset(-1, 0).Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Offset(-1, 0).Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada = celdaSeleccionada.Offset(dtFormaCumplimentacion.Rows.Count + 1, -6)

                'Por territorio, total incidencias
                For estrato = 1 To 6

                    celdaSeleccionada.HorizontalAlignment = xlRight
                    If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                Next
                'total por territorio e incidencia sin estrato
                If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada = celdaSeleccionada.Offset(dtIncidencias.Rows.Count + 1, -6)
            Next

            'Por Territorio y forma de cumplimentación y semana
            celdaSeleccionada = hojaExcel.Range("B7")
            For j As Integer = 0 To dtProvincias.Rows.Count - 1
                provincia = dtProvincias.Rows(j)(Globales.ALIAS_PROV_ID).ToString()
                'Forma de cumplimentación
                For k As Integer = 0 To dtFormaCumplimentacion.Rows.Count - 1

                    formaCumplimentacion = dtFormaCumplimentacion.Rows(k)(_sesion.MetodoCump.ColumnaId).ToString()

                    For estrato = 1 To 6

                        celdaSeleccionada.HorizontalAlignment = xlRight
                        If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "='" & estrato & "'").Length > 0 Then
                            celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                        celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                    Next
                    'total por territorio y forma de cumplimentación sin estrato
                    If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada.HorizontalAlignment = xlRight
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada = celdaSeleccionada.Offset(1, -6)
                Next
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)

                'Incidencias
                For k As Integer = 0 To dtIncidencias.Rows.Count - 1
                    incidencia = dtIncidencias.Rows(k)(_sesion.Listados.ColumnaIdIncidencias()).ToString()

                    For estrato = 1 To 6

                        celdaSeleccionada.HorizontalAlignment = xlRight
                        If incidencia = Globales.Constantes.PENDIENTE Then
                            'Añado los nulos con INDPER = 'S'
                            If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND (" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "')) AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                                celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND (" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "')) AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                            Else
                                celdaSeleccionada.Value = 0
                            End If
                        Else
                            If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                                celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                            Else
                                celdaSeleccionada.Value = 0
                            End If
                        End If

                        celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                    Next
                    'total por territorio e incidencia sin estrato
                    If incidencia = Globales.Constantes.PENDIENTE Then
                        'Añado los nulos con INDPER = 'S'
                        If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND (" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "'))").Length > 0 Then
                            celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND (" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "'))").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                    Else
                        If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "'").Length > 0 Then
                            celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_TH & "= '" & provincia & "' AND " & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "'").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                    End If
                    celdaSeleccionada.HorizontalAlignment = xlRight
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                    celdaSeleccionada = celdaSeleccionada.Offset(1, -6)
                Next
                celdaSeleccionada = celdaSeleccionada.Offset(2, 0)
            Next

            'TOTAL CAPV
            celdaSeleccionada = celdaSeleccionada.Offset(-2, 0)
            For estrato = 1 To 6
                celdaSeleccionada.HorizontalAlignment = xlRight
                If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                    datoForma = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                Else
                    datoForma = 0
                End If
                If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                    datoIncidencia = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                Else
                    datoIncidencia = 0
                End If
                celdaSeleccionada.Value = datoForma + datoIncidencia
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
            Next

            'Total de formas de cumplimentacion sin territorio
            'Sin formas de cumplimentacion ni estrato
            'Total incidencias + forma por territorio
            celdaSeleccionada.HorizontalAlignment = xlRight
            If dtDatosFormaCumplimentacion.Rows.Count > 0 Then
                datoForma = dtDatosFormaCumplimentacion.Rows.Count
            Else
                datoForma = 0
            End If
            If dtDatosIncidencias.Rows.Count > 0 Then
                datoIncidencia = dtDatosIncidencias.Rows.Count
            Else
                datoIncidencia = 0
            End If
            celdaSeleccionada.Value = datoForma + datoIncidencia

            celdaSeleccionada = celdaSeleccionada.Offset(1, -6)
            For estrato = 1 To 6
                celdaSeleccionada.HorizontalAlignment = xlRight
                If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
            Next
            'total
            celdaSeleccionada.Offset(-1, 0).Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Offset(-1, 0).Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Rows.Count
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada = celdaSeleccionada.Offset(1, -6)


            For k As Integer = 0 To dtFormaCumplimentacion.Rows.Count - 1
                formaCumplimentacion = dtFormaCumplimentacion.Rows(k)(_sesion.MetodoCump.ColumnaId).ToString()
                For estrato = 1 To 6

                    celdaSeleccionada.HorizontalAlignment = xlRight
                    If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
                Next
                'Total sin semana, sin territorio
                If dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtDatosFormaCumplimentacion.Select(Globales.COL_CONSULTAIND_FORMPER & " = '" & formaCumplimentacion & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada = celdaSeleccionada.Offset(1, -6)
            Next


            'Total de incidencias sin territorio
            'Sin incidencias ni estrato
            For estrato = 1 To 6
                celdaSeleccionada.HorizontalAlignment = xlRight
                If dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAVIV_ESTRATO & "='" & estrato & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
            Next
            'total
            celdaSeleccionada.Value = dtDatosIncidencias.Rows.Count
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada = celdaSeleccionada.Offset(1, -6)

            For k As Integer = 0 To dtIncidencias.Rows.Count - 1
                incidencia = dtIncidencias.Rows(k)(_sesion.Listados.ColumnaIdIncidencias()).ToString()
                For estrato = 1 To 6
                    celdaSeleccionada.HorizontalAlignment = xlRight
                    If incidencia = Globales.Constantes.PENDIENTE Then
                        'Añado los nulos con INDPER = 'S'
                        If dtDatosIncidencias.Select("(" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "'))" & " AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                            celdaSeleccionada.Value = dtDatosIncidencias.Select("(" & Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "'))" & " AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                    Else
                        If dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length > 0 Then
                            celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' AND " & Globales.COL_CONSULTAVIV_ESTRATO & "= '" & estrato & "'").Length
                        Else
                            celdaSeleccionada.Value = 0
                        End If
                    End If
                    If k = dtIncidencias.Rows.Count - 1 Then
                        celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
                    End If
                    celdaSeleccionada = celdaSeleccionada.Offset(0, 1)
                Next
                'Total sin estrato, sin territorio
                If incidencia = Globales.Constantes.PENDIENTE Then
                    'Añado los nulos con INDPER = 'S'
                    If dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "')").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & "= '" & Globales.VALOR_SI_IND & "')").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    If dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtDatosIncidencias.Select(Globales.COL_CONSULTAIND_RPER & " = '" & incidencia & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                End If
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                If k = dtIncidencias.Rows.Count - 1 Then
                    celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(1, -6)
            Next

            'Fecha
            hojaExcel.Range("A1").Value = GetLocalResourceObject("lblFechaDoc") & " " & FormatDateTime(Now, DateFormat.GeneralDate)
            hojaExcel.Range("A1").ColumnWidth = 26
            hojaExcel.Range("A1").VerticalAlignment = xlCenter
            hojaExcel.Range("A1").HorizontalAlignment = xlLeft
            hojaExcel.Range("A1").WrapText = False
            hojaExcel.Range("A1").ShrinkToFit = False

            hojaExcel.Activate()

            Dim hojas(libroexcel.Sheets.Count - 1) As Excel.Worksheet
            Dim i As Integer = 0
            For i = 0 To libroexcel.Sheets.Count - 1
                hojas(i) = libroexcel.Sheets.Item(i + 1)
            Next

            ' filename = GetLocalResourceObject("lblListado8").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension
            nombreFicheroPlantillaExcel = filename
            _sesion.NameListado = filename
            bytesFicheroExcel = bytes

            'Guardar el fichero
            If DropDownListTrim.SelectedValue <> String.Empty Then
                Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado8") + "_" + DropDownListAnio.SelectedValue + "_" + DropDownListTrim.SelectedValue + "_" + extension + ".xls")
            Else
                Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado8") + "_" + DropDownListAnio.SelectedValue + "_" + extension + ".xls")
            End If

        Catch ex As Exception
            Throw ex
        Finally
            ' Devolver el idioma que tenía antes de generar el Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI
        End Try

    End Sub


    Public Sub GenerarT9()
        ' Guardar el idioma actual
        Dim CurrentCI As System.Globalization.CultureInfo = System.Threading.Thread.CurrentThread.CurrentCulture

        Try

            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If

            Dim ExcelApplication As New Excel.Application
            Dim libroexcel As Excel.Workbook
            Dim hojaExcel As New Excel.Worksheet
            Dim bytes() As Byte = Nothing
            'id_excel = ExcelApplication.Hinstance
            id_excel = ExcelApplication.HinstancePtr

            ExcelApplication = New Excel.Application
            Dim plantilla As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATH") + System.Configuration.ConfigurationManager.AppSettings.Get("NOM_PLANTILLA_EXCEL")

            ' Cambiar el idioma a castellano, para que no casque la generación del Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = New System.Globalization.CultureInfo("es-ES")

            ExcelApplication.Workbooks.Add(plantilla)

            Dim filename As String = GetLocalResourceObject("lblListado9").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension

            libroexcel = ExcelApplication.Workbooks(1)
            libroexcel.Activate()

            hojaExcel = libroexcel.ActiveSheet

            If GetLocalResourceObject("lblListado9").ToString.Length > 30 Then
                hojaExcel.Name = GetLocalResourceObject("lblListado9").ToString.Substring(0, 30)
            Else
                hojaExcel.Name = GetLocalResourceObject("lblListado9").ToString
            End If

            libroexcel.Sheets("Hoja2").visible = False
            libroexcel.Sheets("Hoja3").visible = False

            hojaExcel.Cells.Font.Size = 11

            hojaExcel.Visible = True

            'EXCEL
            hojaExcel.Range("A2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("A2").Borders.Color = RGB(0, 0, 0)

            If (DropDownListTrim.SelectedValue <> String.Empty) Then
                hojaExcel.Range("B2").Value = String.Format(GetLocalResourceObject("lblTitulo9Resource1Operacion.Text").ToString() & " " & GetLocalResourceObject("lblAnioResource1.Text") & " " & _
               DropDownListAnio.SelectedValue & " " & GetLocalResourceObject("lblTrimResource1.Text") & " " & DropDownListTrim.SelectedValue, _sesion.Operacion)
            Else
                hojaExcel.Range("B2").Value = String.Format(GetLocalResourceObject("lblTitulo9Resource1Operacion.Text").ToString() & " " & GetLocalResourceObject("lblAnioResource1.Text") & " " & _
               DropDownListAnio.SelectedValue, _sesion.Operacion)
            End If
            hojaExcel.Range("B2").Font.Bold = True
            hojaExcel.Range("B2:Q2").Merge()
            hojaExcel.Range("B2:Q2").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("B2").Borders.Color = RGB(0, 0, 0)
            hojaExcel.Range("A2").ColumnWidth = 20

            hojaExcel.Range("E1").ColumnWidth = 16
            hojaExcel.Range("I1").ColumnWidth = 16
            hojaExcel.Range("M1").ColumnWidth = 16
            hojaExcel.Range("Q1").ColumnWidth = 16

            'CABECERA NIVEL 1 
            hojaExcel.Range("A4").Value = GetLocalResourceObject("lblEncuestador")
            hojaExcel.Range("A4:A6").Merge()
            hojaExcel.Range("A4").Font.Bold = True
            hojaExcel.Range("A4:A6").VerticalAlignment = xlCenter
            hojaExcel.Range("A4:A6").HorizontalAlignment = xlCenter
            hojaExcel.Range("A4:A6").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("B4").Value = GetLocalResourceObject("lblTotalFamCompletas")
            hojaExcel.Range("B4:E4").Merge()
            hojaExcel.Range("B4:E4").Font.Bold = True
            hojaExcel.Range("B4").RowHeight = 20
            hojaExcel.Range("B4:E4").VerticalAlignment = xlCenter
            hojaExcel.Range("B4:E4").HorizontalAlignment = xlCenter
            hojaExcel.Range("B4:E4").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("F4").Value = GetLocalResourceObject("lblTotalFamIncidencias")
            hojaExcel.Range("F4:I4").Merge()
            hojaExcel.Range("F4:I4").Font.Bold = True
            hojaExcel.Range("F4:I4").VerticalAlignment = xlCenter
            hojaExcel.Range("F4:I4").HorizontalAlignment = xlCenter
            hojaExcel.Range("F4:I4").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("J4").Value = GetLocalResourceObject("lblTotalIndCompletas")
            hojaExcel.Range("J4:M4").Merge()
            hojaExcel.Range("J4:M4").Font.Bold = True
            hojaExcel.Range("J4:M4").VerticalAlignment = xlCenter
            hojaExcel.Range("J4:M4").HorizontalAlignment = xlCenter
            hojaExcel.Range("J4:M4").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("N4").Value = GetLocalResourceObject("lblTotalIndIncidencias")
            hojaExcel.Range("N4:Q4").Merge()
            hojaExcel.Range("N4:Q4").Font.Bold = True
            hojaExcel.Range("N4:Q4").VerticalAlignment = xlCenter
            hojaExcel.Range("N4:Q4").HorizontalAlignment = xlCenter
            hojaExcel.Range("N4:Q4").Borders.Weight = Excel.XlBorderWeight.xlThick

            'CABECERA NIVEL 2 

            hojaExcel.Range("B5").Value = GetLocalResourceObject("lblTotal")
            hojaExcel.Range("B5:B6").Merge()
            hojaExcel.Range("B5").Font.Bold = True
            hojaExcel.Range("B5").VerticalAlignment = xlCenter
            hojaExcel.Range("B5").HorizontalAlignment = xlCenter
            hojaExcel.Range("B5:B6").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("C5").Value = GetLocalResourceObject("lblIC")
            hojaExcel.Range("C5:E5").Merge()
            hojaExcel.Range("C5:E5").Font.Bold = True
            hojaExcel.Range("C5:E5").VerticalAlignment = xlCenter
            hojaExcel.Range("C5:E5").HorizontalAlignment = xlCenter
            hojaExcel.Range("C5:E5").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("C6").Value = GetLocalResourceObject("lblMuestra")
            hojaExcel.Range("C6").Font.Bold = True
            hojaExcel.Range("C6").VerticalAlignment = xlCenter
            hojaExcel.Range("C6").HorizontalAlignment = xlCenter
            hojaExcel.Range("C6").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("D6").Value = GetLocalResourceObject("lblTotalIC")
            hojaExcel.Range("D6").Font.Bold = True
            hojaExcel.Range("D6").VerticalAlignment = xlCenter
            hojaExcel.Range("D6").HorizontalAlignment = xlCenter
            hojaExcel.Range("D6").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("E6").Value = GetLocalResourceObject("lblInformante")
            hojaExcel.Range("E6").Font.Bold = True
            hojaExcel.Range("E6").VerticalAlignment = xlCenter
            hojaExcel.Range("E6").HorizontalAlignment = xlCenter
            hojaExcel.Range("E6").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("F5").Value = GetLocalResourceObject("lblTotal")
            hojaExcel.Range("F5:F6").Merge()
            hojaExcel.Range("F5").Font.Bold = True
            hojaExcel.Range("F5").VerticalAlignment = xlCenter
            hojaExcel.Range("F5").HorizontalAlignment = xlCenter
            hojaExcel.Range("F5:F6").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("G5").Value = GetLocalResourceObject("lblIC")
            hojaExcel.Range("G5:I5").Merge()
            hojaExcel.Range("G5:I5").Font.Bold = True
            hojaExcel.Range("G5:I5").VerticalAlignment = xlCenter
            hojaExcel.Range("G5:I5").HorizontalAlignment = xlCenter
            hojaExcel.Range("G5:I5").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("G6").Value = GetLocalResourceObject("lblMuestra")
            hojaExcel.Range("G6").Font.Bold = True
            hojaExcel.Range("G6").VerticalAlignment = xlCenter
            hojaExcel.Range("G6").HorizontalAlignment = xlCenter
            hojaExcel.Range("G6").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("H6").Value = GetLocalResourceObject("lblTotalIC")
            hojaExcel.Range("H6").Font.Bold = True
            hojaExcel.Range("H6").VerticalAlignment = xlCenter
            hojaExcel.Range("H6").HorizontalAlignment = xlCenter
            hojaExcel.Range("H6").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("I6").Value = GetLocalResourceObject("lblInformante")
            hojaExcel.Range("I6").Font.Bold = True
            hojaExcel.Range("I6").VerticalAlignment = xlCenter
            hojaExcel.Range("I6").HorizontalAlignment = xlCenter
            hojaExcel.Range("I6").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("J5").Value = GetLocalResourceObject("lblTotal")
            hojaExcel.Range("J5:J6").Merge()
            hojaExcel.Range("J5").Font.Bold = True
            hojaExcel.Range("J5").VerticalAlignment = xlCenter
            hojaExcel.Range("J5").HorizontalAlignment = xlCenter
            hojaExcel.Range("J5:J6").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("K5").Value = GetLocalResourceObject("lblIC")
            hojaExcel.Range("K5:M5").Merge()
            hojaExcel.Range("K5:M5").Font.Bold = True
            hojaExcel.Range("K5:M5").VerticalAlignment = xlCenter
            hojaExcel.Range("K5:M5").HorizontalAlignment = xlCenter
            hojaExcel.Range("K5:M5").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("K6").Value = GetLocalResourceObject("lblMuestra")
            hojaExcel.Range("K6").Font.Bold = True
            hojaExcel.Range("K6").VerticalAlignment = xlCenter
            hojaExcel.Range("K6").HorizontalAlignment = xlCenter
            hojaExcel.Range("K6").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("L6").Value = GetLocalResourceObject("lblTotalIC")
            hojaExcel.Range("L6").Font.Bold = True
            hojaExcel.Range("L6").VerticalAlignment = xlCenter
            hojaExcel.Range("L6").HorizontalAlignment = xlCenter
            hojaExcel.Range("L6").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("M6").Value = GetLocalResourceObject("lblInformante")
            hojaExcel.Range("M6").Font.Bold = True
            hojaExcel.Range("M6").VerticalAlignment = xlCenter
            hojaExcel.Range("M6").HorizontalAlignment = xlCenter
            hojaExcel.Range("M6").Borders.Weight = Excel.XlBorderWeight.xlThick


            hojaExcel.Range("N5").Value = GetLocalResourceObject("lblTotal")
            hojaExcel.Range("N5:N6").Merge()
            hojaExcel.Range("N5").Font.Bold = True
            hojaExcel.Range("N5").VerticalAlignment = xlCenter
            hojaExcel.Range("N5").HorizontalAlignment = xlCenter
            hojaExcel.Range("N5:N6").Borders.Weight = Excel.XlBorderWeight.xlThick
            hojaExcel.Range("O5").Value = GetLocalResourceObject("lblIC")
            hojaExcel.Range("O5:Q5").Merge()
            hojaExcel.Range("O5:Q5").Font.Bold = True
            hojaExcel.Range("O5:Q5").VerticalAlignment = xlCenter
            hojaExcel.Range("O5:Q5").HorizontalAlignment = xlCenter
            hojaExcel.Range("O5:Q5").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("O6").Value = GetLocalResourceObject("lblMuestra")
            hojaExcel.Range("O6").Font.Bold = True
            hojaExcel.Range("O6").VerticalAlignment = xlCenter
            hojaExcel.Range("O6").HorizontalAlignment = xlCenter
            hojaExcel.Range("O6").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("P6").Value = GetLocalResourceObject("lblTotalIC")
            hojaExcel.Range("P6").Font.Bold = True
            hojaExcel.Range("P6").VerticalAlignment = xlCenter
            hojaExcel.Range("P6").HorizontalAlignment = xlCenter
            hojaExcel.Range("P6").Borders.Weight = Excel.XlBorderWeight.xlThick

            hojaExcel.Range("Q6").Value = GetLocalResourceObject("lblInformante")
            hojaExcel.Range("Q6").Font.Bold = True
            hojaExcel.Range("Q6").VerticalAlignment = xlCenter
            hojaExcel.Range("Q6").HorizontalAlignment = xlCenter
            hojaExcel.Range("Q6").Borders.Weight = Excel.XlBorderWeight.xlThick


            'Dibujar los encuestadores
            Dim e_Listados As Eustat.GEDW.V35.Ng.Listados = New Eustat.GEDW.V35.Ng.Listados(_sesion.Operacion)
            _sesion.Listados = e_Listados
            Dim dtEncuestadores As System.Data.DataTable = _sesion.Listados.ObtenerEncuestadores(_sesion.Operacion)
            Dim celdaSeleccionada As Excel.Range = hojaExcel.Range("A7")
            For j As Integer = 0 To dtEncuestadores.Rows.Count - 1
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
                celdaSeleccionada.HorizontalAlignment = xlLeft
                celdaSeleccionada.VerticalAlignment = xlCenter
                celdaSeleccionada.Value = dtEncuestadores.Rows(j)(Globales.ALIAS_USUARIOS_NOMBRE).ToString()
                celdaSeleccionada = celdaSeleccionada.Offset(1, 0)
            Next
            'Totales
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = GetLocalResourceObject("lblTotales").ToString().ToUpper()
            celdaSeleccionada.Font.Bold = True

            _sesion.Listados.Anio = DropDownListAnio.SelectedValue
            _sesion.Listados.Trim = DropDownListTrim.SelectedValue
            _sesion.Listados.Operacion = _sesion.Operacion


            ''DATOS
            Dim dtICFamCompletas As New System.Data.DataTable
            Dim dtICFamIncidencias As New System.Data.DataTable

            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                dtICFamCompletas = _sesion.Listados.CargarDatosICFamiliaresCompletas()
                dtICFamIncidencias = _sesion.Listados.CargarDatosICFamiliaresIncidencias()
            End If

            Dim dtICIndCompletas As System.Data.DataTable = _sesion.Listados.CargarDatosICIndividualesCompletas()
            Dim dtICIndIncidencias As System.Data.DataTable = _sesion.Listados.CargarDatosICIndividualesIncidencias()

            Dim codEncuestador As String

            celdaSeleccionada = hojaExcel.Range("B7")
            For j As Integer = 0 To dtEncuestadores.Rows.Count - 1
                codEncuestador = dtEncuestadores.Rows(j)(Globales.COL_USUARIOS_NUMC).ToString()

                'Familiares completas por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                    If dtICFamCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtICFamCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Familiares completas IC desde muestra por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                    If dtICFamCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtICFamCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & "= '" & Globales.VALOR_COD_IC_SI & Globales.VALOR_COD_IC_ORIGEN_MUESTRA & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Familiares completas IC por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                    If dtICFamCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtICFamCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)


                'Familiares completas IC INFORMANTE CONFIANZA por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                    If dtICFamCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtICFamCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%' and " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Familiares con incidencias por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                    If dtICFamIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtICFamIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Familiares con incidencias IC desde muestra por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                    If dtICFamIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtICFamIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & "= '" & Globales.VALOR_COD_IC_SI & Globales.VALOR_COD_IC_ORIGEN_MUESTRA & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Familiares con incidencias IC por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                    If dtICFamIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtICFamIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)


                'Familiares con incidencias IC INFORMANTE CONFIANZA por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                    If dtICFamIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                        celdaSeleccionada.Value = dtICFamIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%' and " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "'").Length
                    Else
                        celdaSeleccionada.Value = 0
                    End If
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'INDIVIDUALES
                'Individuales completas por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick


                If dtICIndCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtICIndCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If

                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Individuales completas IC desde muestra por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick


                If dtICIndCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtICIndCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & "= '" & Globales.VALOR_COD_IC_SI & Globales.VALOR_COD_IC_ORIGEN_MUESTRA & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If

                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Individuales completas IC por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick


                If dtICIndCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtICIndCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If

                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)


                'Individuales completas IC INFORMANTE CONFIANZA por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If dtICIndCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtICIndCompletas.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%' and " & Globales.COL_CONSULTAIND_INFPER & " = '" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If

                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Individuales con incidencias por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick


                If dtICIndIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtICIndIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If
                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Individuales con incidencias IC desde muestra por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If dtICIndIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtICIndIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & "= '" & Globales.VALOR_COD_IC_SI & Globales.VALOR_COD_IC_ORIGEN_MUESTRA & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If

                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

                'Individuales con incidencias IC por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick

                If dtICIndIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtICIndIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If

                celdaSeleccionada = celdaSeleccionada.Offset(0, 1)


                'Individuales con incidencias IC INFORMANTE CONFIANZA por encuestador
                celdaSeleccionada.HorizontalAlignment = xlRight
                celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick


                If dtICIndIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "'").Length > 0 Then
                    celdaSeleccionada.Value = dtICIndIncidencias.Select(Globales.COL_CUESTIONARIO_AGENTE & "= '" & codEncuestador & "' and " & Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%' and " & Globales.COL_CONSULTAIND_INFPER & " = '" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "'").Length
                Else
                    celdaSeleccionada.Value = 0
                End If

                celdaSeleccionada = celdaSeleccionada.Offset(1, -15)

            Next

            'Total Familiares completas
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                celdaSeleccionada.Value = dtICFamCompletas.Rows.Count
            Else
                celdaSeleccionada.Value = 0
            End If

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)


            'Total Familiares  completas IC desde muestra
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                celdaSeleccionada.Value = dtICFamCompletas.Select(Globales.COL_CONSULTAVIV_IC & "= '" & Globales.VALOR_COD_IC_SI & Globales.VALOR_COD_IC_ORIGEN_MUESTRA & "'").Length
            Else
                celdaSeleccionada.Value = 0
            End If

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total Familiares  completas IC 
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                celdaSeleccionada.Value = dtICFamCompletas.Select(Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%'").Length
            Else
                celdaSeleccionada.Value = 0
            End If

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total Familiares completas IC INFORMANTE CONFIANZA
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                celdaSeleccionada.Value = dtICFamCompletas.Select(Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%' and " & Globales.COL_CONSULTAIND_INDFAM & " ='" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "'").Length
            Else
                celdaSeleccionada.Value = 0
            End If

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total Familiares incidencias
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                celdaSeleccionada.Value = dtICFamIncidencias.Rows.Count
            Else
                celdaSeleccionada.Value = 0
            End If

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)


            'Total Familiares  incidencias IC desde muestra
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                celdaSeleccionada.Value = dtICFamIncidencias.Select(Globales.COL_CONSULTAVIV_IC & "= '" & Globales.VALOR_COD_IC_SI & Globales.VALOR_COD_IC_ORIGEN_MUESTRA & "'").Length
            Else
                celdaSeleccionada.Value = 0
            End If

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total Familiares  incidencias IC 
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                celdaSeleccionada.Value = dtICFamIncidencias.Select(Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%'").Length
            Else
                celdaSeleccionada.Value = 0
            End If

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total Familiares incidencias IC INFORMANTE CONFIANZA
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
                celdaSeleccionada.Value = dtICFamIncidencias.Select(Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%' and " & Globales.COL_CONSULTAIND_INDFAM & " ='" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "'").Length
            Else
                celdaSeleccionada.Value = 0
            End If

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total individuales completas
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = dtICIndCompletas.Rows.Count

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)


            'Total individuales  completas IC desde muestra
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = dtICIndCompletas.Select(Globales.COL_CONSULTAVIV_IC & "= '" & Globales.VALOR_COD_IC_SI & Globales.VALOR_COD_IC_ORIGEN_MUESTRA & "'").Length

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total individuales completas IC 
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick

            celdaSeleccionada.Value = dtICIndCompletas.Select(Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%'").Length

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total individuales completas IC INFORMANTE CONFIANZA
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = dtICIndCompletas.Select(Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%' and " & Globales.COL_CONSULTAIND_INFPER & " ='" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "'").Length

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total individuales incidencias
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick

            celdaSeleccionada.Value = dtICIndIncidencias.Rows.Count

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)


            'Total individuales incidencias IC desde muestra
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = dtICIndIncidencias.Select(Globales.COL_CONSULTAVIV_IC & "= '" & Globales.VALOR_COD_IC_SI & Globales.VALOR_COD_IC_ORIGEN_MUESTRA & "'").Length

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total individuales incidencias IC 
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = dtICIndIncidencias.Select(Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%'").Length

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Total individuales incidencias IC INFORMANTE CONFIANZA
            celdaSeleccionada.HorizontalAlignment = xlRight
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeRight).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeLeft).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeTop).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Borders(XlBordersIndex.xlEdgeBottom).Weight = Excel.XlBorderWeight.xlThick
            celdaSeleccionada.Value = dtICIndIncidencias.Select(Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%' and " & Globales.COL_CONSULTAIND_INFPER & " ='" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "'").Length

            celdaSeleccionada = celdaSeleccionada.Offset(0, 1)

            'Fecha
            hojaExcel.Range("A1").Value = GetLocalResourceObject("lblFechaDoc") & " " & FormatDateTime(Now, DateFormat.GeneralDate)
            hojaExcel.Range("A1").VerticalAlignment = xlCenter
            hojaExcel.Range("A1").HorizontalAlignment = xlLeft
            hojaExcel.Range("A1").WrapText = False
            hojaExcel.Range("A1").ShrinkToFit = False

            hojaExcel.Activate()

            Dim hojas(libroexcel.Sheets.Count - 1) As Excel.Worksheet
            Dim i As Integer = 0
            For i = 0 To libroexcel.Sheets.Count - 1
                hojas(i) = libroexcel.Sheets.Item(i + 1)
            Next



            If DropDownListTrim.SelectedValue <> String.Empty Then
                filename = GetLocalResourceObject("lblListado9").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & DropDownListTrim.SelectedValue & "_" & extension
            Else
                filename = GetLocalResourceObject("lblListado9").ToString().Replace(" ", "") & "_" & DropDownListAnio.SelectedValue & "_" & extension
            End If

            nombreFicheroPlantillaExcel = filename
            _sesion.NameListado = filename
            bytesFicheroExcel = bytes


            'Guardar el fichero
            If DropDownListTrim.SelectedValue <> String.Empty Then
                Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado9") + "_" + DropDownListAnio.SelectedValue + "_" + DropDownListTrim.SelectedValue + "_" + extension + ".xls")
            Else
                Guardar(ExcelApplication, libroexcel, hojas, GetLocalResourceObject("lblListado9") + "_" + DropDownListAnio.SelectedValue + "_" + extension + ".xls")
            End If

        Catch ex As Exception
            Throw ex
        Finally
            ' Devolver el idioma que tenía antes de generar el Excel
            System.Threading.Thread.CurrentThread.CurrentCulture = CurrentCI
        End Try
    End Sub

#End Region

    Private Sub descargarFicheroPlantillaExcel(ByVal name As String)
        Try
            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If

            Response.Clear()
            Response.ClearHeaders()
            Response.ClearContent()
            'Response.ContentType = "binary/octet-stream"
            'Response.Charset = ""
            Response.ContentType = "application/octet-stream"
            Response.Cache.SetCacheability(HttpCacheability.Private)
            Response.ContentEncoding = System.Text.Encoding.UTF8
            Response.AddHeader("Content-Disposition", "attachment; filename=" + name)
            Response.BinaryWrite(_sesion.bytesFicheroExcel)
            _sesion.bytesFicheroExcel = Nothing
            Response.Flush()
            Response.End()

        Catch ex As Exception
            Throw ex
        End Try
    End Sub

    Private Sub Guardar(ByVal ExcelApplication As Excel.Application, ByVal libroexcel As Excel.Workbook, ByVal hojas() As Excel.Worksheet, ByVal filename As String)
        Try
            Dim id_excel As Int64 = ExcelApplication.HinstancePtr
            Dim i As Integer = 0

            Dim extension As String = ""

            If _sesion.Idioma = ConfigurationManager.AppSettings("Castellano") Then
                extension = "c"
            Else
                extension = "e"
            End If
            Dim ruta As String = System.Configuration.ConfigurationManager.AppSettings.Get("EXCELPATHSALIDA") + filename
            Dim f As IO.FileInfo = New IO.FileInfo(ruta)
            If f.Exists Then
                f.Delete()
            End If

            libroexcel.SaveAs(ruta)

            If Not libroexcel Is Nothing Then
                For i = 0 To hojas.Length - 1
                    Finalizar(hojas(i))
                Next
                libroexcel.Close(False)
                Finalizar(libroexcel)
                ExcelApplication.Quit()
                Finalizar(ExcelApplication)
            End If

            System.GC.Collect()

            matarProcesoExcel(id_excel)

            Dim fileStream As System.IO.FileStream = Nothing

            Try
                fileStream = New System.IO.FileStream(ruta, System.IO.FileMode.Open, System.IO.FileAccess.Read)
                ReDim bytesFicheroExcel(fileStream.Length - 1)
                fileStream.Read(bytesFicheroExcel, 0, fileStream.Length)
                _sesion.bytesFicheroListados = bytesFicheroExcel
                _sesion.mostrarExcelListado = True
            Finally
                If Not fileStream Is Nothing Then
                    fileStream.Close()
                End If
            End Try

            'EliminarArchivos(ruta)
        Catch ex As Exception
            If ExcelApplication IsNot Nothing Then
                Dim id_excel As Int64 = ExcelApplication.HinstancePtr
                matarProcesoExcel(id_excel)
            End If
            Throw ex
        End Try
    End Sub

    Private Sub matarProcesoExcel(ByVal id_excel As Int64)
        'MATAMOS EL PROCESO EXCEL ASP.NET
        Try
            Dim Procesos() As System.Diagnostics.Process = Process.GetProcessesByName("EXCEL")
            For Each pProccess As System.Diagnostics.Process In Procesos
                Dim baseAdd As Int64 = pProccess.MainModule.BaseAddress.ToInt64
                If (baseAdd = id_excel) Then
                    pProccess.Kill()
                End If
            Next
        Catch ex As Exception
            Throw ex
        End Try
    End Sub

    Private Sub Finalizar(ByRef Referencias As Object)
        Try
            'Bucle de eliminacion
            Do Until _
                 System.Runtime.InteropServices.Marshal.ReleaseComObject(Referencias) <= 0
            Loop
        Catch ex As Exception
            Referencias = Nothing
            Throw ex
        End Try
        Referencias = Nothing
    End Sub


    Protected Sub btnExcel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnExcel.Click
        If (_sesion.mostrarExcelListado) Then
            _sesion.mostrarExcelListado = False
            'Mostrar excel
            Response.Clear()
            Response.ClearHeaders()
            Response.ClearContent()
            'Response.ContentType = "binary/octet-stream"
            'Response.Charset = ""
            Response.ContentType = "application/octet-stream"
            Response.Cache.SetCacheability(HttpCacheability.Private)
            Response.ContentEncoding = System.Text.Encoding.UTF8
            Response.AddHeader("Content-Disposition", "attachment; filename=" + _sesion.NameListado + ".xls")
            Response.BinaryWrite(_sesion.bytesFicheroListados)
            bytesFicheroExcel = Nothing
            Response.Flush()
            Response.End()
        End If
    End Sub



#Region "Validaciones"

    Protected Sub cvMetodoIdioma_ServerValidate(ByVal source As Object, ByVal args As System.Web.UI.WebControls.ServerValidateEventArgs) Handles cvMetodoIdioma.ServerValidate
        args.IsValid = False
        If (rbMetodo.Checked Or rbIdioma.Checked) Then
            args.IsValid = True
        End If
    End Sub

    Protected Sub cvEncuestadoAgente_ServerValidate(ByVal source As Object, ByVal args As System.Web.UI.WebControls.ServerValidateEventArgs) Handles cvEncuestadoAgente.ServerValidate
        args.IsValid = False
        If (cbAgente.Checked Or cbEncuestado.Checked) Then
            args.IsValid = True
        End If
    End Sub

    Protected Sub cvEncuestaVivienda_ServerValidate(ByVal source As Object, ByVal args As System.Web.UI.WebControls.ServerValidateEventArgs) Handles cvEncuestaVivienda.ServerValidate
        args.IsValid = False
        If (cbEncuesta.Checked Or cbVivienda.Checked) Then
            args.IsValid = True
        End If
    End Sub

#End Region





End Class
