﻿<%@ Application Language="VB" %>
<%@ Import Namespace="Eustat.Comun.V35.Ng" %>
<%@ Import Namespace="Eustat.Comun.V35.Ng.Errores" %>
<%@ Import Namespace="Eustat.Comun.V35.DAL.Trazing" %>
<%@ Import Namespace="System.Xml" %>

<script runat="server">
    
     Const IDENTIF_LIMITER As String = "_"
    
    Protected Sub Application_AuthenticateRequest(ByVal sender As Object, ByVal e As System.EventArgs)
        If Not String.IsNullOrEmpty(Request("Ag")) AndAlso Me.Request.Cookies(FormsAuthentication.FormsCookieName) Is Nothing Then
            AutenticarUsuario()
            Response.Redirect("~/DesdeHJR.aspx")
        End If
    End Sub

    Protected Sub Application_AuthorizeRequest(ByVal sender As Object, ByVal e As System.EventArgs)
        'Si el usuario no está autenticado, no se hace nada.
        If Not Me.User.Identity.IsAuthenticated Then
            Exit Sub
        End If
    End Sub
    
    
    Protected Sub Session_Start(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim objCookie As HttpCookie = Me.Request.Cookies(FormsAuthentication.FormsCookieName)
        Dim info() As String
        Dim infoAg() As String
        Dim entradaUrl As Boolean = false
        Dim _sesion As New AppSession
        
        Dim tipoTrazaActual As ControlError.TipoTraza
        tipoTrazaActual = ControlError.TipoTraza.TipoAccesoUsuNoRegistrado
        
        If Not objCookie Is Nothing AndAlso String.IsNullOrEmpty(_sesion.Numc) Then
            Dim objTicket As FormsAuthenticationTicket = FormsAuthentication.Decrypt(objCookie.Value)
            _sesion.ParamsTicket = objTicket.UserData
            info = objTicket.UserData.Split(";")
            _sesion.Idioma = info(0)
            _sesion.Operacion = info(1)
            _sesion.Numc = info(2)
            If (info.Length > 3) Then
                infoAg = info(3).Split("_")
                If (infoAg.Length > 1) Then
                    _sesion.Agente = infoAg(0)
                    _sesion.Operacion = infoAg(1)
                    entradaUrl = True
                Else
                    _sesion.Agente = info(2)
                End If
            Else
                _sesion.Numc = String.Empty
                _sesion.Agente = info(2)
             End If
                _sesion.Start = True
           
                If info.Length > 4 Then
                    _sesion.UsuarioActual = info(4)
                    tipoTrazaActual = ControlError.TipoTraza.TipoAccesoUsuRegistrado
                Else
                    _sesion.UsuarioActual = String.Empty
                End If
                If info.Length > 5 Then
                    _sesion.DNI = info(5)
                    tipoTrazaActual = ControlError.TipoTraza.TipoAccesoTarjeta
                Else
                    _sesion.DNI = String.Empty
                End If
                ' Cargar el idioma ... para lo que necesite la clase de negocio encuesta. La primera vez
                EstablecerIdioma(_sesion.Idioma)
                ' Recuperar información del cuestionario
                _sesion.EncuestaInfo = New Eustat.Comun.V35.Ng.Encuesta()
                With _sesion.EncuestaInfo
                    ' Cargar la disponibilidad de las trazas
                    _sesion.Trazas = .Trazas
                    ' Establecer el timeout de sesión
                    _sesion.Timeout = .SesTimeout
                End With
                InicializarValoresSesion()
            End If
            objCookie = Nothing
            'Cargar variables generales de aplicacion
            InicializarVariablesAplication()
            Session_Start_Trace(tipoTrazaActual)
        If (Not (entradaUrl)) Then
            If (Not String.IsNullOrEmpty(_sesion.Operacion)) Then
                Response.Redirect("~/PreEncuesta.aspx")
            End If
        End If
    End Sub
    
    Protected Sub Application_PreRequestHandlerExecute(ByVal sender As Object, ByVal e As System.EventArgs)
        Try
            Dim _sesion As New AppSession
            
            ' Cargar el idioma ... el resto de veces
            EstablecerIdioma(_sesion.Idioma)
        Catch ex As Exception
            
        Finally
            'Registrar traza BeginRequest
            Application_BeginRequest_Trace()
        End Try
    End Sub
    
    Protected Sub Application_PostRequestHandlerExecute(ByVal sender As Object, ByVal e As System.EventArgs)
        'Registrar traza EndRequest
        Application_EndRequest_Trace()
    End Sub
    
#Region "CONTROL DE ACCESOS Y TRAZAS"
#Region "APPLICATION"
    Sub Application_Start(ByVal sender As Object, ByVal e As EventArgs)
        ' Code that runs on application startup
        Dim _sesion As New AppSession
        Dim errores As ControlError = New ControlError()
        errores.Encuesta = ConfigurationManager.AppSettings("DefaultBD").ToString()
        errores.registrarTraza(ControlError.TipoTraza.Aplication_Start)
    End Sub
    
    Sub Application_End(ByVal sender As Object, ByVal e As EventArgs)
        Dim _sesion As New AppSession
        Dim errores As ControlError = New ControlError()
        errores.Encuesta = ConfigurationManager.AppSettings("DefaultBD").ToString()
        errores.registrarTraza(ControlError.TipoTraza.Aplication_End)
    End Sub
#End Region
    
#Region "SESSION"
    ''' <summary>
    ''' Registrar traza SessionStart
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub Session_Start_Trace(ByVal tipoTraza As ControlError.TipoTraza)
        Try
            ' Se desencadena cuando se inicia la sesión
            Dim _sesion As New AppSession
            Dim errores As ControlError = New ControlError()
            
            _sesion.SesionId = HttpContext.Current.Session.SessionID
            Dim navegador As String() = Eustat.Comun.V35.Ng.Errores.ControlErrorUtils.getNavegador(My.Request.UserAgent)
            If (Not IsNothing(navegador)) Then
                ControlTraza.Navegador = navegador(2)
            End If
            Dim SO As String() = Eustat.Comun.V35.Ng.Errores.ControlErrorUtils.getSO(My.Request.UserAgent)
            If (Not IsNothing(SO)) Then
                ControlTraza.Plataforma = SO(2)
            End If
            Dim IP As String = My.Request.UserHostAddress
            If (Not IsNothing(IP)) Then
                ControlTraza.Ip = IP
            End If
            
            errores.Encuesta = ConfigurationManager.AppSettings("DefaultBD").ToString()
            errores.registrarTraza(tipoTraza, My.Request, Nothing, _sesion)
        Catch ex As Exception
            Throw ex
        End Try
    End Sub
    
    ''' <summary>
    ''' Registrar traza SessionEnd
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub Session_End(ByVal sender As Object, ByVal e As EventArgs)
        Dim _sesion As New AppSession
        Dim errores As ControlError = New ControlError()
        Dim lista As List(Of String) = New List(Of String)

        lista.Add("Session_End")
        errores.Encuesta = ConfigurationManager.AppSettings("DefaultBD").ToString()
        errores.registrarTraza(Eustat.GEDW.V35.Ng.Globales.TIPOTRAZA_SESION, Nothing, lista, Nothing)
    End Sub
#End Region

#Region "REQUEST"
    ''' <summary>
    ''' Registrar traza BeginRequest
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub Application_BeginRequest_Trace()
        Dim _sesion As New AppSession

        If _sesion.Exists Then
            Dim errores As ControlError = New ControlError()
            Dim _list As New List(Of String)()

            _list.Add(My.Request.Url.AbsolutePath)
            errores.Encuesta = ConfigurationManager.AppSettings("DefaultBD").ToString()
            errores.registrarTraza(ControlError.TipoTraza.Request_Begin, My.Request, _list, _sesion)
        End If
    End Sub

    ''' <summary>
    ''' Registrar traza EndRequest
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub Application_EndRequest_Trace()
        Dim _sesion As New AppSession

        If _sesion.Exists Then
            Dim errores As ControlError = New ControlError()
            Dim _list As New List(Of String)()

            _list.Add(My.Request.Url.AbsolutePath)
            errores.Encuesta = ConfigurationManager.AppSettings("DefaultBD").ToString()
            errores.registrarTraza(ControlError.TipoTraza.Request_End, My.Request, _list, _sesion)
        End If
    End Sub
#End Region
#End Region
    
#Region "GESTION DE ERRORES"
    ''' <summary>
    ''' Control y registro de errores
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub Application_OnError(ByVal sender As Object, ByVal e As EventArgs)
        Try
            Dim ctx As HttpContext = HttpContext.Current
            Dim excp As Exception = ctx.Server.GetLastError()
            Dim _sesion As New AppSession

            If TypeOf excp Is HttpUnhandledException AndAlso excp.InnerException IsNot Nothing Then
                excp = excp.InnerException
            End If
            _sesion.ErrorMessage = excp.Message
            If (TypeOf excp Is Eustat.Comun.V35.Web.BaseException OrElse _
                TypeOf excp Is Eustat.Comun.V35.Web.GridViewException OrElse _
                TypeOf excp Is Eustat.GEDW.V35.Ng.BaseException OrElse _
                TypeOf excp Is Eustat.Comun.V35.Fmk.Ng.BaseException) _
                AndAlso excp.InnerException IsNot Nothing Then
                _sesion.ErrorSource = excp.Source
                _sesion.ErrorTecMessage = excp.InnerException.Message
            Else
                Dim websitePath As String = ctx.Request.PhysicalApplicationPath
                Dim serverDir As System.IO.DirectoryInfo = New System.IO.DirectoryInfo(websitePath)

                _sesion.ErrorSource = serverDir.Name
                _sesion.ErrorTecMessage = excp.Message
            End If
            _sesion.StackTrace = excp.StackTrace

            Dim errores As ControlError = New ControlError()
            errores.Encuesta = ConfigurationManager.AppSettings("DefaultBD").ToString()
            errores.registrarError(excp, ctx.Request, Nothing, _sesion)
            ctx.Server.ClearError()

            ctx.Response.Redirect("~/ErrorPages/CommonError.aspx", False)
            ctx.Server.ClearError()
        Catch ex As Exception

        End Try
    End Sub
#End Region
       
#Region "METODOS PRIVADOS"
    Private Sub AutenticarUsuario()
        'Se obtiene los datos del usuario que se está conectando a la aplicación.
        Dim strOperacion As String = ConfigurationManager.AppSettings("DefaultBD").ToString()
        If Right(strOperacion, 1) = "W" Then
            strOperacion = strOperacion.Remove(ConfigurationManager.AppSettings("DefaultBD").ToString().LastIndexOf("W"), 1)
        End If
        Dim strUsuario As String = Request("numc").Split(IDENTIF_LIMITER)(0)
        Dim strUsuarioInfo As String = IIf(String.IsNullOrEmpty(Request("idioma")) OrElse Request("idioma") = "1" OrElse Request("idioma").ToLower = "c" OrElse Request("idioma").ToLower = "es-es", ConfigurationManager.AppSettings("Castellano"), ConfigurationManager.AppSettings("Euskera")) & ";" & strOperacion & ";" & Request("numc") & ";" & Request("Ag") & "_" & Request("Op")
        Dim dFecha As DateTime = DateTime.Now

        ' Generación del ticket
        Dim objTicket As New FormsAuthenticationTicket(1, strUsuario, dFecha, dFecha.AddMinutes(20), False, strUsuarioInfo)
        Dim strTicket As String = FormsAuthentication.Encrypt(objTicket)

        ' Cuando entra como agente ...
        ' Si tenemos una cookie generada previamente, nos la cepillamos
        If Me.Response.Cookies(FormsAuthentication.FormsCookieName) IsNot Nothing Then
            Me.Response.Cookies.Remove(FormsAuthentication.FormsCookieName)
        End If
        
        ' Generar cookie con los valores correctos
        Me.Response.Cookies.Add(New HttpCookie(FormsAuthentication.FormsCookieName, strTicket))
    End Sub
    
    Private Function GetSessionState(ByVal application As HttpApplication) As SessionStateModule
        Dim modules As HttpModuleCollection = application.Modules
        Dim misessionState As SessionStateModule = CType(modules("Session"), SessionStateModule)
        If (IsNothing(misessionState)) Then
            Return GetSessionStateByTypeCast(modules)
        Else
            Return misessionState
        End If
    End Function

    Private Function GetSessionStateByTypeCast(ByVal modules As HttpModuleCollection) As SessionStateModule
        For Each modul As Object In modules
            Dim sessionState As SessionStateModule = CType(modul, SessionStateModule)
            If sessionState IsNot Nothing Then
                Return sessionState
            End If
        Next
        Return Nothing
    End Function
#End Region
</script>