﻿Imports Eustat.GEDW.V35.Ng
Imports System.Data

Imports System.Diagnostics
Imports Eustat.Comun.V35.Web

Partial Class GestionEncuesta
    Inherits System.Web.UI.Page

    Dim ErroresValLN As ErroresVal = New ErroresVal

    Dim bytesFicheroExcel() As Byte

    Private _sesion As AppSession

#Region "CONSTANTES"
    Private Const FORM_IC_TITULO As String = "FormularioIcTitulo"
#End Region

#Region "Eventos genericos"

    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If (_sesion Is Nothing) Then
            _sesion = New AppSession
        End If
    End Sub
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If (Not IsPostBack) Then
            lblNumcDato.Text = _sesion.Numc
            lblAnioDato.Text = _sesion.Aenc
            If (Not String.IsNullOrEmpty(_sesion.Trim)) Then
                lblTrimDato.Text = _sesion.Trim
                lblTrimestre.Visible = True
                lblTrimDato.Visible = True
            End If
            If (Not String.IsNullOrEmpty(_sesion.Semana)) Then
                lblSemDato.Text = _sesion.Semana
                lblSemana.Visible = True
                lblSemDato.Visible = True
            End If
            CargarCabecera()
        End If
        CargarControlColectivo()
        CargarControlResultados()
        CargarControlInfo()
        VisualizarPestActiva()

        _sesion.RefrescandoGestionEncuesta = False
        LiteralNombreEncuesta.Text = String.Format(LiteralNombreEncuesta.Text, _sesion.Operacion)
    End Sub


    Public Sub CargarControlColectivo()
        phColectivo.Controls.Clear()
        Dim ctrl As UserControl
        Try
            ctrl = CType(LoadControl("~/WebUserControls/GestionEncuestaContents/" & _sesion.Operacion & "/ctlColectivo.ascx"), UserControl)
        Catch ex As Exception
            ctrl = CType(LoadControl("~/WebUserControls/GestionEncuestaContents/ctlColectivo.ascx"), UserControl)
        End Try
        ctrl.ID = "myColectivo"
        phColectivo.Controls.Add(ctrl)
    End Sub

    Public Sub CargarControlResultados()
        phResultados.Controls.Clear()
        Dim ctrl As UserControl
        Try
            ctrl = CType(LoadControl("~/WebUserControls/GestionEncuestaContents/" & _sesion.Operacion & "/ctlResultados.ascx"), UserControl)
        Catch ex As Exception
            ctrl = CType(LoadControl("~/WebUserControls/GestionEncuestaContents/ctlResultados.ascx"), UserControl)
        End Try
        ctrl.ID = "myResultados"
        phResultados.Controls.Add(ctrl)
    End Sub

    Public Sub CargarControlInfo()
        pnlinfoContacto.Controls.Clear()
        Dim ctrl As UserControl
        Try
            ctrl = CType(LoadControl("~/WebUserControls/GestionEncuestaContents/" & _sesion.Operacion & "/ctlInfo.ascx"), UserControl)
        Catch ex As Exception
            ctrl = CType(LoadControl("~/WebUserControls/GestionEncuestaContents/ctlInfo.ascx"), UserControl)
        End Try
        ctrl.ID = "myInfo"
        pnlinfoContacto.Controls.Add(ctrl)
    End Sub

#End Region

#Region "Métodos especificos"





    'Evento para validación de numc concreto
    Protected Sub ClickValidar(ByVal sender As Object, ByVal e As EventArgs)


    End Sub

#End Region

    Protected Sub btnContactos_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnContactos.Click
        _sesion.RefrescandoGestionEncuesta = True
        _sesion.PestañaActiva = Globales.PESTANIA_CON
        Response.Redirect(Request.RawUrl)
    End Sub

    Protected Sub btnIndividuo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnIndividuo.Click
        _sesion.RefrescandoGestionEncuesta = True
        _sesion.PestañaActiva = Globales.PESTANIA_VIV
        Response.Redirect(Request.RawUrl)
    End Sub

    Protected Sub btnInfo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnInfo.Click
        _sesion.RefrescandoGestionEncuesta = True
        _sesion.PestañaActiva = "4"
        Response.Redirect(Request.RawUrl)
    End Sub

    Protected Sub btnEspecifica_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnEspecifica.Click
        _sesion.RefrescandoGestionEncuesta = True
        _sesion.PestañaActiva = Globales.PESTANIA_RES
        Dim srt As String = Request.RawUrl.ToString().Replace("es-ES", "eu-ES")
        Response.Redirect(srt)
    End Sub



    Protected Sub lnkVolver_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkVolver.Click
        _sesion.VolverVivienda = True
        _sesion.CambiosEnPagina = False
        Server.Transfer("~/ConsultaViviendas.aspx")
    End Sub

    Private Sub CargarCabecera()
        Dim infoCabecera As ConMuestra = New ConMuestra(_sesion.Operacion, _sesion.Idioma, _sesion.UsuarioActual)
        Dim dtCabecera As DataSet = infoCabecera.ObtenerDatosCabecera(_sesion.Numc, _sesion.Aenc, _sesion.Trim)
        lblIDEV.Text = dtCabecera.Tables(0).Rows(0)(ConMuestra.IdentColumnIDEV).ToString()
        lblTerritorio.Text = dtCabecera.Tables(0).Rows(0)(ConMuestra.IdentColumnTh).ToString()
        lblMunicipio.Text = dtCabecera.Tables(0).Rows(0)(ConMuestra.IdentColumnMun).ToString()
        lblDireccion.Text = dtCabecera.Tables(0).Rows(0)(ConMuestra.IdentColumnDir).ToString()
        lblCP.Text = dtCabecera.Tables(0).Rows(0)(ConMuestra.IdentColumnCp).ToString()
        If _sesion.IC.TieneIC Then

            If _sesion.GestionEncuestaMuestra Is Nothing OrElse Not _sesion.RefrescandoGestionEncuesta OrElse ((_sesion.Numc <> _sesion.GestionEncuestaMuestra.Numc Or _sesion.Aenc <> _sesion.GestionEncuestaMuestra.Aenc Or _sesion.Trim <> _sesion.GestionEncuestaMuestra.Tenc Or _sesion.Semana <> _sesion.GestionEncuestaMuestra.Sem)) Then
                _sesion.GestionEncuestaMuestra = New Muestra(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Trim, _sesion.Semana)
            End If
            If Not _sesion.GestionEncuestaMuestra Is Nothing Then
                chkIC.Checked = _sesion.IC.EsIC(_sesion.GestionEncuestaMuestra.IC)
                chkIC.Enabled = Not _sesion.GestionEncuestaMuestra.TieneInformanteIC()
                Me.lnkICForm.Visible = _sesion.IC.EsIC(_sesion.GestionEncuestaMuestra.IC)
                If Not String.IsNullOrEmpty(_sesion.GestionEncuestaMuestra.ICNombre) Then
                    Me.lnkICForm.Text = Me.lnkICForm.Text & "&nbsp;(" & _sesion.GestionEncuestaMuestra.ICNombre & ")"
                End If
            End If
        Else
            Me.phIC.Visible = False
        End If

    End Sub

    Protected Sub lnkGuardarCambios_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkGuardarCambios.Click
        If Guardar() Then
            _sesion.RefrescandoGestionEncuesta = True
            Response.Redirect(Request.RawUrl)
        End If
    End Sub

    Public Function Guardar() As Boolean

        If _sesion.IC.TieneIC Then
            _sesion.GestionEncuestaMuestra.EstablecerCodigoIC(chkIC.Checked)
            _sesion.GestionEncuestaMuestra.Actualizar()
        End If

        Dim ctColectivo As IGestion = CType(phColectivo.FindControl("myColectivo"), IGestion)
        Dim ctResultados As IGestion = CType(phColectivo.FindControl("myResultados"), IGestion)
        Dim ctInfo As IGestion = CType(phColectivo.FindControl("myInfo"), IGestion)

        Dim result As Boolean = False
        If (pnlIntegrantes.Visible) Then
            result = ctColectivo.GuardarCambios()
        ElseIf (pnlParteEsp.Visible) Then
            result = ctResultados.GuardarCambios()
        ElseIf (pnlinfoContacto.Visible) Then
            result = ctInfo.GuardarCambios()
        End If
        Return result
    End Function


    Private Sub VisualizarPestActiva()
        If (_sesion.PestañaActiva.Equals(Globales.PESTANIA_VIV)) Then
            btnIndividuo.CssClass = "activo"
            btnContactos.CssClass = "inactivo"
            btnEspecifica.CssClass = "inactivo"
            btnInfo.CssClass = "inactivo"
            pnlIntegrantes.Visible = True
            pnlContactos.Visible = False
            pnlParteEsp.Visible = False
            pnlinfoContacto.Visible = False
        ElseIf (_sesion.PestañaActiva.Equals(Globales.PESTANIA_CON)) Then
            btnIndividuo.CssClass = "inactivo"
            btnContactos.CssClass = "activo"
            btnEspecifica.CssClass = "inactivo"
            btnInfo.CssClass = "inactivo"
            pnlIntegrantes.Visible = False
            pnlContactos.Visible = True
            pnlParteEsp.Visible = False
            pnlinfoContacto.Visible = False
        ElseIf (_sesion.PestañaActiva.Equals(Globales.PESTANIA_RES)) Then
            btnIndividuo.CssClass = "inactivo"
            btnContactos.CssClass = "inactivo"
            btnEspecifica.CssClass = "activo"
            btnInfo.CssClass = "inactivo"
            pnlIntegrantes.Visible = False
            pnlContactos.Visible = False
            pnlParteEsp.Visible = True
            pnlinfoContacto.Visible = False
        Else
            btnIndividuo.CssClass = "inactivo"
            btnContactos.CssClass = "inactivo"
            btnEspecifica.CssClass = "inactivo"
            btnInfo.CssClass = "activo"
            pnlIntegrantes.Visible = False
            pnlContactos.Visible = False
            pnlParteEsp.Visible = False
            pnlinfoContacto.Visible = True
        End If
    End Sub


    Protected Sub lnkICForm_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkICForm.Click
        txtICNombre.Text = _sesion.GestionEncuestaMuestra.ICNombre
        txtICTlfno.Text = _sesion.GestionEncuestaMuestra.ICTlfno
        txtICEmail.Text = _sesion.GestionEncuestaMuestra.ICEmail
        txtICRelacion.Text = _sesion.GestionEncuestaMuestra.ICRelacion
        txtICObservaciones.Text = _sesion.GestionEncuestaMuestra.ICObservaciones

        MostrarICformulario()
    End Sub

    Protected Sub btnICAceptar_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnICAceptar.Click
        If DatosICValidos Then
            _sesion.GestionEncuestaMuestra.ICNombre = txtICNombre.Text.Trim
            _sesion.GestionEncuestaMuestra.ICTlfno = txtICTlfno.Text.Trim
            _sesion.GestionEncuestaMuestra.ICEmail = txtICEmail.Text.Trim
            _sesion.GestionEncuestaMuestra.ICRelacion = txtICRelacion.Text.Trim
            _sesion.GestionEncuestaMuestra.ICObservaciones = txtICObservaciones.Text.Trim

            _sesion.RefrescandoGestionEncuesta = True
            Dim srt As String = Request.RawUrl.ToString().Replace("es-ES", "eu-ES")
            Response.Redirect(srt)
            Me.txtICNombre.Enabled = False
        Else
            MostrarICformulario()
        End If

    End Sub


    Private Function DatosICValidos() As Boolean
        Me.txtICNombre.Validate()
        Me.txtICTlfno.Validate()
        Me.txtICEmail.Validate()
        Me.txtICRelacion.Validate()
        Me.txtICObservaciones.Validate()
        Return Me.txtICNombre.IsValid And _
            Me.txtICTlfno.IsValid And _
            Me.txtICEmail.IsValid And _
            Me.txtICRelacion.IsValid And _
            Me.txtICObservaciones.IsValid

    End Function

    Private Sub MostrarICformulario()
        Me.txtICNombre.Enabled = True
        ScriptManager.RegisterStartupScript(Me.Page, Me.Page.GetType, "ShowModal" & Me.FormIC.ID, "$('#" & Me.FormIC.ClientID & "').dialog({title:'" & GetLocalResourceObject(FORM_IC_TITULO) & "',modal:true,open: function (type, data) {$(this).parent().appendTo($('form:first'));},minWidth:650});", True)
    End Sub

    Protected Sub chkIC_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles chkIC.CheckedChanged
        Me.lnkICForm.Text = Me.lnkICForm.Text & "&nbsp;(" & _sesion.GestionEncuestaMuestra.ICNombre & ")"
        _sesion.GestionEncuestaMuestra.EstablecerCodigoIC(Me.chkIC.Checked)
        If Not Me.chkIC.Checked Then
            _sesion.GestionEncuestaMuestra.ICNombre = String.Empty
            _sesion.GestionEncuestaMuestra.ICTlfno = String.Empty
            _sesion.GestionEncuestaMuestra.ICEmail = String.Empty
            _sesion.GestionEncuestaMuestra.ICRelacion = String.Empty
            _sesion.GestionEncuestaMuestra.ICObservaciones = String.Empty
        End If
        'Refrescamos para borrar los informantes IC del grid
        _sesion.RefrescandoGestionEncuesta = True
        Dim srt As String = Request.RawUrl.ToString().Replace("es-ES", "eu-ES")
        Response.Redirect(srt)
    End Sub

   
    Protected Sub btnICCancelar_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnICCancelar.Click
        Me.txtICNombre.Enabled = False
    End Sub
End Class
