﻿
Partial Class Expirado
    Inherits System.Web.UI.Page

#Region "VARIABLES"
    Private _sesion As AppSession
#End Region

    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        ' Recoger información de la sesión ...
        _sesion = New AppSession()
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        '***ESTILO PAGINA EXPIRADO***'
        Dim css As HtmlLink = New HtmlLink()
        css = New HtmlLink()
        css.Href = ConfigurationManager.AppSettings("Style") & "expirado/eustat_expirado.css"
        css.Attributes.Add("rel", "stylesheet")
        css.Attributes.Add("type", "text/css")
        Page.Header.Controls.Add(css)
        css.Dispose()

        'Nifty corners
        Page.ClientScript.RegisterClientScriptBlock(Page.GetType(), "niftycube", "<script id=""niftycube"" type=""text/javascript"" src=""" + ConfigurationManager.AppSettings("JS") + "niftycube/niftycube.js""></script>")
        Page.ClientScript.RegisterStartupScript(Page.GetType(), "niftycube-convert", "window.onload=function(){Nifty(""div.box,div.boxtitle"");}" & Chr(13), True)

        Select Case Request.QueryString("tipo")
            Case "A"
                LabelRes1.Text = GetLocalResourceObject("Resumen1Agente")
                LabelRes2.Text = String.Format(GetLocalResourceObject("Resumen2Agente"), _sesion.EncuestaInfo.Telefono(0))
            Case "T"
                If _sesion.EncuestaInfo.DiasRevision > 1 Then
                    LabelRes1.Text = String.Format(GetLocalResourceObject("Resumen1UsuarioMasDeUno"), _sesion.EncuestaInfo.DiasRevision)
                Else
                    LabelRes1.Text = String.Format(GetLocalResourceObject("Resumen1Usuario"), _sesion.EncuestaInfo.DiasRevision)
                End If
                LabelRes2.Text = String.Format(GetLocalResourceObject("Resumen2Usuario"), _sesion.EncuestaInfo.Telefono(0))
            Case "D"
                LabelRes1.Text = GetLocalResourceObject("Resumen1Inactivo")
                LabelRes2.Text = String.Format(GetLocalResourceObject("Resumen2Inactivo"), _sesion.EncuestaInfo.Telefono(0))
            Case Else
                Response.Redirect("~/PreEncuesta.aspx")
        End Select
    End Sub
End Class