﻿
Partial Class ErrorPages_Error
    Inherits System.Web.UI.MasterPage

#Region "SESION"
    Private _sesion As New AppSession()
#End Region

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load
        Try
            '*** ESTILOS ***'
            Dim css As HtmlLink = New HtmlLink()
            'Icono de la web
            css.Href = ConfigurationManager.AppSettings("Images") + "eustat.ico"
            css.Attributes.Add("rel", "shortcut icon")
            css.Attributes.Add("type", "image/x-icon")
            Page.Header.Controls.AddAt(2, css)
            'Estilo general
            css = New HtmlLink()
            css.Href = ConfigurationManager.AppSettings("Style") + "eustat.css"
            css.Attributes.Add("rel", "stylesheet")
            css.Attributes.Add("type", "text/css")
            Page.Header.Controls.AddAt(3, css)
            'Estilo error
            css = New HtmlLink()
            css.Href = ConfigurationManager.AppSettings("Style") + "error/eustat_error.css"
            css.Attributes.Add("rel", "stylesheet")
            css.Attributes.Add("type", "text/css")
            Page.Header.Controls.AddAt(4, css)
            'Cabecera
            css = New HtmlLink()
            css.Href = ConfigurationManager.AppSettings("Style") + "cabecera/eustat_cabecera.css"
            css.Attributes.Add("rel", "stylesheet")
            css.Attributes.Add("type", "text/css")
            Page.Header.Controls.AddAt(5, css)
            css.Dispose()

            '*** SCRIPTS ***'
            'jQuery
            Page.ClientScript.RegisterClientScriptInclude("jquery", ConfigurationManager.AppSettings("Js") + ConfigurationManager.AppSettings("jQuery"))
            'jQuery UI
            Page.ClientScript.RegisterClientScriptInclude("jquery-ui", ConfigurationManager.AppSettings("Js") + ConfigurationManager.AppSettings("jQuery-ui"))

            '*** INICIALIZAR VALORES ESTATICOS ***'
            ImageLogoEustat.ImageUrl = ConfigurationManager.AppSettings("Images") + "logo_eustat.gif"
            ImageLogoEuskadi.ImageUrl = ConfigurationManager.AppSettings("Images") + "logo_euskadinet.gif"
        Catch ex As Exception
            LiteralError.Text = ex.Message
        End Try
    End Sub

    Protected Sub Page_PreRender(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.PreRender
        Try
            Dim stack() As String
            Dim trace As String = String.Empty

            LiteralError.Text = _sesion.ErrorMessage
            LiteralSource.Text = _sesion.ErrorSource
            LiteralTecError.Text = _sesion.ErrorTecMessage
            stack = Split(_sesion.StackTrace, " at ")
            If stack.Length <= 1 Then
                stack = Split(_sesion.StackTrace, " en ")
            End If
            For Each s As String In stack
                If Not String.IsNullOrEmpty(s.Trim) Then
                    trace = trace & "<p>" & s & "</p>"
                End If
            Next
            LiteralDetails.Text = trace
        Catch ex As Exception
            LiteralError.Text = ex.Message
        End Try
    End Sub
End Class

