﻿Imports Eustat.GEDW.V35.Ng
Imports System.Data

Imports System.Diagnostics

Partial Class ConsultaViviendas
    Inherits System.Web.UI.Page

    Dim ErroresValLN As ErroresVal = New ErroresVal

    Dim bytesFicheroExcel() As Byte

    Private _sesion As AppSession


#Region "Eventos genericos"

    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If (_sesion Is Nothing) Then
            _sesion = New AppSession
        End If
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim sm As ScriptManager = ScriptManager.GetCurrent(Me.Page)
        CargarControlResultados()
        If Not Page.IsPostBack Then
            lnkFiltrar.Focus()
            If (IsNothing(_sesion.FiltrosConsultaInfo)) Then
                Dim filtrosMuestra As FiltrosMuestra = New FiltrosMuestra()
                _sesion.FiltrosConsultaInfo = filtrosMuestra
            End If
            If (IsNothing(_sesion.OperacionesUsuarioInfo)) Then
                Response.Redirect("PreEncuesta.aspx")
            End If
            'Obtengo el perfil del usuario para esta operación
            Dim ControlUsuariosLN As ControlUsuarios = New ControlUsuarios()
            Dim dsCtrUsuarios As DataSet = ControlUsuariosLN.GetControlUsuarios(_sesion.Agente, _sesion.Operacion)
            _sesion.Perfil = ControlUsuariosLN.Perfil
            _sesion.UsuarioActual = ControlUsuariosLN.CodigoUsu
            txtCodUsu.Text = _sesion.UsuarioActual
            CargarDatos()
            If _sesion.VolverVivienda Then
                CargarDatosSesion()
                _sesion.VolverVivienda = False
                'ElseIf (Not IsNothing(_sesion.Agente)) Then
                'If (Not IsNothing(_sesion.Numc)) Then
                '    txtNumcDesde.Text = _sesion.Numc
                '    txtNumcHasta.Text = _sesion.Numc
                'End If
            End If
        ElseIf _sesion.FiltrosConsultaInfo.LimpiarMunicipio Then
            DropDownListMunicipio.DataSource = _sesion.MunicipiosInfo.GetMunicipios(DropDownListTerritorioHistorico.SelectedValue)
            DropDownListMunicipio.DataBind()
            DropDownListMunicipio.SelectedIndex = -1
            _sesion.FiltrosConsultaInfo.LimpiarMunicipio = False
        End If
        LiteralNombreEncuesta.Text = String.Format(Resources.ConsultaViviendas.LiteralNombreEncuestaResource1.ToString(), _sesion.Operacion)
        Dim imgProgreso As Image = CType(UpdateProg1.FindControl("imgProcesando"), Image)
        imgProgreso.ImageUrl = ConfigurationManager.AppSettings("Images") & "ajax_updating.gif"
    End Sub



#End Region

#Region "Métodos especificos"


    Public Sub CargarControlResultados()
        phResultado.Controls.Clear()
        Dim ctrl As UserControl
        Try
            ctrl = CType(LoadControl("~/WebUserControls/DetalleBusquedaContents/" & _sesion.Operacion & "/ctlMuestra.ascx"), UserControl)
        Catch ex As Exception
            ctrl = CType(LoadControl("~/WebUserControls/DetalleBusquedaContents/ctlMuestra.ascx"), UserControl)
        End Try
        ctrl.ID = "myResultados"
        phResultado.Controls.Add(ctrl)

    End Sub

    Public Sub CargarDatos()

        'Operaciones
        panelOpe.Visible = _sesion.OperacionesUsuarioInfo.MultipleOperacion
        'Provincia y Municipio y comarca
        DropDownListTerritorioHistorico.DataValueField = _sesion.ProvinciasInfo.ColumnaId
        DropDownListTerritorioHistorico.DataTextField = _sesion.ProvinciasInfo.ColumnaNombre
        DropDownListTerritorioHistorico.DataSource = _sesion.ProvinciasInfo.GetProvinciasCAV()
        DropDownListTerritorioHistorico.DataBind()

        Dim ComarcasLN As Comarcas = New Comarcas()
        ComarcasLN.GetComarcas()
        DropDownListComarca.DataValueField = ComarcasLN.ColumnaId
        DropDownListComarca.DataTextField = _sesion.ComarcasInfo.ColumnaNombre
        If String.IsNullOrEmpty(DropDownListTerritorioHistorico.SelectedValue) Then
            DropDownListComarca.DataSource = _sesion.ComarcasInfo.GetComarcas()
        Else
            DropDownListComarca.DataSource = _sesion.ComarcasInfo.GetComarcas(DropDownListTerritorioHistorico.SelectedValue)
        End If
        DropDownListComarca.DataBind()

        DropDownListMunicipio.DataValueField = _sesion.MunicipiosInfo.ColumnaId
        DropDownListMunicipio.DataTextField = _sesion.MunicipiosInfo.ColumnaNombre
        If String.IsNullOrEmpty(DropDownListTerritorioHistorico.SelectedValue) Then
            DropDownListMunicipio.DataSource = _sesion.MunicipiosInfo.GetMunicipios()
        Else
            DropDownListMunicipio.DataSource = _sesion.MunicipiosInfo.GetMunicipios(DropDownListTerritorioHistorico.SelectedValue)
        End If
        DropDownListMunicipio.DataBind()

        'Situacion
        Dim SituacionesLN As Situaciones = New Situaciones()
        SituacionesLN.GetSituaciones()
        DropDownListSituacion.DataSource = SituacionesLN.GetDsSituaciones
        DropDownListSituacion.DataTextField = SituacionesLN.ColumnaDescripcion(_sesion.Idioma)
        DropDownListSituacion.DataValueField = SituacionesLN.ColumnaId
        DropDownListSituacion.DataBind()
        'Resultado Encuesta
        Dim ResultadoVivLN As ResultadoViv = New ResultadoViv(_sesion.Operacion)
        DropDownListREncuesta.DataSource = ResultadoVivLN.GetDsResultadoViv
        DropDownListREncuesta.DataTextField = ResultadoVivLN.ColumnaDescripcion(_sesion.Idioma)
        DropDownListREncuesta.DataValueField = ResultadoVivLN.ColumnaId
        DropDownListREncuesta.DataBind()
        'Resultado Contacto
        Dim ResultadoConLN As ResultadoCon = New ResultadoCon()
        DropDownListRContacto.DataSource = ResultadoConLN.GetDsResultadoCon
        DropDownListRContacto.DataTextField = ResultadoConLN.ColumnaDescripcion(_sesion.Idioma)
        DropDownListRContacto.DataValueField = ResultadoConLN.ColumnaId
        DropDownListRContacto.DataBind()
        'Resultado Cuestionario Familiar/Personal
        Dim ResultadoCuestLN As ResultadoCuest = New ResultadoCuest(_sesion.Operacion)
        DropDownListRCuestFam.DataSource = ResultadoCuestLN.GetDsResultadoCuest
        DropDownListRCuestFam.DataTextField = ResultadoCuestLN.ColumnaDescripcion(_sesion.Idioma)
        DropDownListRCuestFam.DataValueField = ResultadoCuestLN.ColumnaId
        DropDownListRCuestFam.DataBind()
        DropDownListRCuestPer.DataSource = ResultadoCuestLN.GetDsResultadoCuest
        DropDownListRCuestPer.DataTextField = ResultadoCuestLN.ColumnaDescripcion(_sesion.Idioma)
        DropDownListRCuestPer.DataValueField = ResultadoCuestLN.ColumnaId
        DropDownListRCuestPer.DataBind()
        'Anio 
        Dim AniosLN As Anios = New Anios(_sesion.Operacion)
        Dim dt As DataSet = AniosLN.GetDsAnio()
        Dim dtRow1 As DataRow
        dtRow1 = dt.Tables(0).NewRow()
        dtRow1(AniosLN.ColumnaId) = DBNull.Value
        dtRow1(AniosLN.ColumnaDescripcion()) = Resources.ConsultaViviendas.LabelElija
        dt.Tables(0).Rows.InsertAt(dtRow1, 0)
        DropDownListAnio.DataSource = dt
        DropDownListAnio.DataTextField = AniosLN.ColumnaDescripcion()
        DropDownListAnio.DataValueField = AniosLN.ColumnaId
        DropDownListAnio.DataBind()
        'Trimestre
        Dim TrimLN As Trimestre = New Trimestre(_sesion.Operacion)
        Dim dtTrim As DataSet = TrimLN.GetDsTrim()
        If (Not IsNothing(dtTrim)) Then
            If (dtTrim.Tables(0).Rows.Count > 0) Then
                Dim dtRowTrim As DataRow
                dtRowTrim = dtTrim.Tables(0).NewRow()
                dtRowTrim(TrimLN.ColumnaId) = DBNull.Value
                dtRowTrim(TrimLN.ColumnaDescripcion()) = Resources.ConsultaViviendas.LabelElija
                dtTrim.Tables(0).Rows.InsertAt(dtRowTrim, 0)
                DropDownListTrim.DataSource = dtTrim
                DropDownListTrim.DataTextField = TrimLN.ColumnaDescripcion()
                DropDownListTrim.DataValueField = TrimLN.ColumnaId
                DropDownListTrim.DataBind()
            Else
                lblTrim.Visible = False
                DropDownListTrim.Visible = False 
            End If
        Else
            lblTrim.Visible = False
            DropDownListTrim.Visible = False 
        End If
        'Semana
        Dim SemLN As Semana = New Semana(_sesion.Operacion)
        Dim dtSem As DataSet = SemLN.GetDsSem()
        If (Not IsNothing(dtSem)) Then
            If (dtSem.Tables(0).Rows.Count > 0) Then
                Dim dtRowSem As DataRow
                dtRowSem = dtSem.Tables(0).NewRow()
                dtRowSem(SemLN.ColumnaId) = DBNull.Value
                dtRowSem(SemLN.ColumnaDescripcion()) = Resources.ConsultaViviendas.LabelElija
                dtSem.Tables(0).Rows.InsertAt(dtRowSem, 0)
                DropDownListSem.DataSource = dtSem
                DropDownListSem.DataTextField = SemLN.ColumnaDescripcion()
                DropDownListSem.DataValueField = SemLN.ColumnaId
                DropDownListSem.DataBind()
                If (Not DropDownListTrim.Visible) Then
                    lblSem.Attributes("style") = ""
                    lblSem.CssClass = "labelsemimedio"
                End If
            Else
                lblSem.Visible = False
                DropDownListSem.Visible = False
            End If
        Else
            lblSem.Visible = False
            DropDownListSem.Visible = False
            _sesion.Semana = String.Empty
        End If
        'Mes
        Dim MesLN As Mes = New Mes(_sesion.Operacion)
        Dim dtMes As DataSet = MesLN.GetDsMes()
        If (Not IsNothing(dtMes)) Then
            If (dtMes.Tables(0).Rows.Count > 0) Then
                Dim dtRowMes As DataRow
                dtRowMes = dtMes.Tables(0).NewRow()
                dtRowMes(SemLN.ColumnaId) = DBNull.Value
                dtRowMes(SemLN.ColumnaDescripcion()) = Resources.ConsultaViviendas.LabelElija
                dtMes.Tables(0).Rows.InsertAt(dtRowMes, 0)
                DropDownListMes.DataSource = dtMes
                DropDownListMes.DataTextField = MesLN.ColumnaDescripcion()
                DropDownListMes.DataValueField = MesLN.ColumnaId
                DropDownListMes.DataBind()
            Else
                lblMes.Visible = False
                DropDownListMes.Visible = False
            End If
        Else
            lblMes.Visible = False
            DropDownListMes.Visible = False
        End If
        'Lote
        Dim LoteLN As Lote = New Lote(_sesion.Operacion, _sesion.UsuarioActual)
        Dim dtLote As DataSet = LoteLN.GetDsLote()
        If (Not IsNothing(dtLote)) Then
            If (dtLote.Tables(0).Rows.Count > 0) Then
                Dim dtRowLote As DataRow
                dtRowLote = dtLote.Tables(0).NewRow()
                dtRowLote(SemLN.ColumnaId) = DBNull.Value
                dtRowLote(SemLN.ColumnaDescripcion()) = Resources.ConsultaViviendas.LabelElija
                dtLote.Tables(0).Rows.InsertAt(dtRowLote, 0)
                DropDownListLote.DataSource = dtLote
                DropDownListLote.DataTextField = LoteLN.ColumnaDescripcion()
                DropDownListLote.DataValueField = LoteLN.ColumnaId
                DropDownListLote.DataBind()
            Else
                lblLote.Visible = False
                DropDownListLote.Visible = False
            End If
        Else
            lblLote.Visible = False
            DropDownListLote.Visible = False
        End If

        'IC
        LabeViviendaIC.Visible = _sesion.IC.TieneIC
        DropDownListViviendaIC.Visible = _sesion.IC.TieneIC

        'Turno
        LabelTurno.Visible = _sesion.TurnoInfo.TieneTurno
        DropDownListTurno.Visible = _sesion.TurnoInfo.TieneTurno

        'Metodo Fam
        Dim MetodoLN As MetodoCump = New MetodoCump()
        DropDownListMetodoFam.DataSource = MetodoLN.GetDsMetodo
        DropDownListMetodoFam.DataTextField = MetodoLN.ColumnaDescripcion(_sesion.Idioma)
        DropDownListMetodoFam.DataValueField = MetodoLN.ColumnaId
        DropDownListMetodoFam.DataBind()
        'Metodo Ind
        DropDownListMetodoInd.DataSource = MetodoLN.GetDsMetodo
        DropDownListMetodoInd.DataTextField = MetodoLN.ColumnaDescripcion(_sesion.Idioma)
        DropDownListMetodoInd.DataValueField = MetodoLN.ColumnaId
        DropDownListMetodoInd.DataBind()
        'encuestador familiar
        Dim ControlUsuariosLN As ControlUsuarios = New ControlUsuarios()
        Dim dtEncuestadores As DataSet = ControlUsuariosLN.ObtenerEncuestadores(_sesion.Operacion)
        Dim dtRow As DataRow
        dtRow = dtEncuestadores.Tables(0).NewRow()
        dtRow(ControlUsuariosLN.ALIAS_CODIGO) = DBNull.Value
        Dim column As String = Globales.C_ELIJA_CAS
        If (_sesion.Idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
            column = Globales.C_ELIJA_EUS
        End If
        dtRow(ControlUsuariosLN.ALIAS_NOMBRE) = column
        dtEncuestadores.Tables(0).Rows.InsertAt(dtRow, 0)
        DropDownListEncFam.DataSource = dtEncuestadores
        DropDownListEncFam.DataTextField = ControlUsuariosLN.ALIAS_NOMBRE
        DropDownListEncFam.DataValueField = ControlUsuariosLN.ALIAS_CODIGO
        DropDownListEncFam.DataBind()
        DropDownListEncInd.DataSource = dtEncuestadores
        DropDownListEncInd.DataTextField = ControlUsuariosLN.ALIAS_NOMBRE
        DropDownListEncInd.DataValueField = ControlUsuariosLN.ALIAS_CODIGO
        DropDownListEncInd.DataBind()


        'filtros especificos de operaciones por defecto no visibles 
        
            lblFechaRef.Visible = False
            txtFechaRef.Visible = False
        
            lblFechaEncuesta.Visible = False
            txtFechaEncuesta.Visible = False

    End Sub




    ''' <summary>
    ''' Evento de cambio de valor en el combobox de territorio historico del establecimiento.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Protected Sub DropDownListTerrotorioHistoricoEst_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles DropDownListTerritorioHistorico.SelectedIndexChanged
        If Not String.IsNullOrEmpty(DropDownListTerritorioHistorico.SelectedValue) AndAlso DropDownListTerritorioHistorico.SelectedValue > 0 Then
            DropDownListMunicipio.DataSource = _sesion.MunicipiosInfo.GetMunicipios(DropDownListTerritorioHistorico.SelectedValue)
            DropDownListMunicipio.DataBind()

            DropDownListComarca.DataSource = _sesion.ComarcasInfo.GetComarcas(DropDownListTerritorioHistorico.SelectedValue)
            DropDownListComarca.DataBind()


        Else
            DropDownListMunicipio.DataSource = _sesion.MunicipiosInfo.GetMunicipios("-1")
            DropDownListMunicipio.DataBind()

            DropDownListComarca.DataSource = _sesion.ComarcasInfo.GetComarcas("-1")
            DropDownListComarca.DataBind()

        End If
        _sesion.FiltrosConsultaInfo.LimpiarMunicipio = True
    End Sub



    ''' <summary>
    ''' Evento de cambio de valor en el combobox de comarca.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Protected Sub DropDownListComarca_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles DropDownListComarca.SelectedIndexChanged
        If Not String.IsNullOrEmpty(DropDownListComarca.SelectedValue) AndAlso DropDownListComarca.SelectedValue > 0 Then

            DropDownListMunicipio.DataSource = _sesion.MunicipiosInfo.GetMunicipiosComarcas(DropDownListComarca.SelectedValue, DropDownListTerritorioHistorico.SelectedValue)
            DropDownListMunicipio.DataBind()

        ElseIf Not String.IsNullOrEmpty(DropDownListTerritorioHistorico.SelectedValue) AndAlso DropDownListTerritorioHistorico.SelectedValue > 0 Then

            DropDownListMunicipio.DataSource = _sesion.MunicipiosInfo.GetMunicipios(DropDownListTerritorioHistorico.SelectedValue)
            DropDownListMunicipio.DataBind()
            DropDownListMunicipio.SelectedIndex = -1
            _sesion.FiltrosConsultaInfo.LimpiarMunicipio = True

        Else

            DropDownListMunicipio.DataSource = _sesion.MunicipiosInfo.GetMunicipios("-1")
            DropDownListMunicipio.DataBind()

        End If
    End Sub

#End Region

    Private Sub CargarDatosOpe()

    End Sub


    Protected Sub lnkFiltrar_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkFiltrar.Click
        Dim ctResultados As IMuestra = CType(phResultado.FindControl("myResultados"), IMuestra)
        ctResultados.VisualizarErrorExcel(False)
        cmpNumc.Enabled = True
        If (Not (String.IsNullOrEmpty(txtNumcDesde.Text)) And String.IsNullOrEmpty(txtNumcHasta.Text)) Then
            cmpNumc.IsValid = True
            cmpNumc.Enabled = False
        End If
        Page.Validate()
        If Page.IsValid Then
            ctResultados.Refrescar()
        Else
            ctResultados.VisualizarExcel(False)
        End If
        CargarDatosEnSesion()
    End Sub

    Protected Sub lnkLimpiar_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkLimpiar.Click
        Dim ctResultados As IMuestra = CType(phResultado.FindControl("myResultados"), IMuestra)
        ctResultados.VisualizarErrorExcel(False)
        Limpiar()
    End Sub

    Protected Sub Limpiar()
        txtNumcDesde.Text = String.Empty
        txtNumcHasta.Text = String.Empty
        DropDownListTerritorioHistorico.SelectedIndex = -1

        DropDownListMunicipio.DataSource = _sesion.MunicipiosInfo.GetMunicipios(DropDownListTerritorioHistorico.SelectedIndex)
        DropDownListMunicipio.DataBind()

        DropDownListComarca.DataSource = _sesion.ComarcasInfo.GetComarcas(DropDownListTerritorioHistorico.SelectedIndex)
        DropDownListComarca.DataBind()

        DropDownListAnio.SelectedIndex = -1
        DropDownListSituacion.SelectedIndex = -1
        DropDownListViviendaIC.SelectedIndex = -1
        DropDownListTurno.SelectedIndex = -1
        DropDownListREncuesta.SelectedIndex = -1
        DropDownListRContacto.SelectedIndex = -1
        DropDownListRCuestFam.SelectedIndex = -1
        DropDownListRCuestPer.SelectedIndex = -1
        txtFechaFamDesde.Text = String.Empty
        txtFechaFamHasta.Text = String.Empty
        txtFechaIndDesde.Text = String.Empty
        txtFechaIndHasta.Text = String.Empty
        txtFechaEncuesta.Text = String.Empty
        DropDownListMetodoFam.SelectedIndex = -1
        DropDownListMetodoInd.SelectedIndex = -1
        DropDownListEncFam.SelectedIndex = -1
        DropDownListEncInd.SelectedIndex = -1
        DropDownListSem.SelectedIndex = -1
        DropDownListTrim.SelectedIndex = -1
        DropDownListLote.SelectedIndex = -1
        txtFechaRef.Text = String.Empty
        CargarDatosEnSesion()
    End Sub

    Private Sub CargarDatosSesion()
        Dim ctResultados As IMuestra = CType(phResultado.FindControl("myResultados"), IMuestra)
        If (Not IsNothing(DropDownListAnio.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectAnio))) Then
            DropDownListAnio.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectAnio).Selected = True
        End If
        If (DropDownListTrim.Visible) Then
            'If (DropDownListTrim.Attributes("style").Equals("visibility:hidden")) Then
            If (Not IsNothing(DropDownListTrim.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectTrim))) Then
                DropDownListTrim.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectTrim).Selected = True
            End If
        End If
        If (DropDownListSem.Visible) Then
            If (Not IsNothing(DropDownListSem.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectSem))) Then
                DropDownListSem.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectSem).Selected = True
            End If
        End If
        If (DropDownListMes.Visible) Then
            If (Not IsNothing(DropDownListMes.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectMes))) Then
                DropDownListMes.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectMes).Selected = True
            End If
        End If
        If (DropDownListLote.Visible) Then
            If (Not IsNothing(DropDownListLote.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectLote))) Then
                DropDownListLote.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectLote).Selected = True
            End If
        End If
        If (DropDownListViviendaIC.Visible) Then
            If (Not IsNothing(DropDownListViviendaIC.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectIC))) Then
                DropDownListViviendaIC.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectIC).Selected = True
            End If
        End If
        If (DropDownListTurno.Visible) Then
            If (Not IsNothing(DropDownListTurno.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectTurno))) Then
                DropDownListTurno.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectTurno).Selected = True
            End If
        End If
        If (txtFechaEncuesta.Visible) Then
            txtFechaEncuesta.Text = _sesion.FiltrosConsultaInfo.SelecFecEncuesta
        End If
        txtNumcDesde.Text = _sesion.FiltrosConsultaInfo.SelectNumcDesde
        txtNumcHasta.Text = _sesion.FiltrosConsultaInfo.SelectNumcHasta

        If (Not IsNothing(DropDownListTerritorioHistorico.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectTh))) Then
            DropDownListTerritorioHistorico.ClearSelection()
            DropDownListTerritorioHistorico.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectTh).Selected = True
            DropDownListComarca.DataSource = _sesion.ComarcasInfo.GetComarcas(DropDownListTerritorioHistorico.SelectedValue)
            DropDownListComarca.DataBind()
            DropDownListMunicipio.DataSource = _sesion.MunicipiosInfo.GetMunicipios(DropDownListTerritorioHistorico.SelectedValue)
            DropDownListMunicipio.DataBind()
        End If

        If (Not IsNothing(DropDownListComarca.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectCom))) Then
            DropDownListComarca.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectCom).Selected = True
        End If

        If (Not IsNothing(DropDownListMunicipio.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectMun))) Then
            DropDownListMunicipio.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectMun).Selected = True
        End If

        If (Not IsNothing(DropDownListSituacion.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectSituac))) Then
            DropDownListSituacion.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectSituac).Selected = True
        End If
        If (Not IsNothing(DropDownListRContacto.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectRCont))) Then
            DropDownListRContacto.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectRCont).Selected = True
        End If
        If (Not IsNothing(DropDownListREncuesta.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectRViv))) Then
            DropDownListREncuesta.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectRViv).Selected = True
        End If
        If (Not IsNothing(DropDownListRCuestPer.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectRPer))) Then
            DropDownListRCuestPer.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectRPer).Selected = True
        End If
        If (Not IsNothing(DropDownListRCuestFam.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectRFam))) Then
            DropDownListRCuestFam.Items.FindByText(_sesion.FiltrosConsultaInfo.SelectRFam).Selected = True
        End If
        txtFechaFamDesde.Text = _sesion.FiltrosConsultaInfo.SelecFecFamDesde
        txtFechaFamHasta.Text = _sesion.FiltrosConsultaInfo.SelecFecFamHasta
        txtFechaIndDesde.Text = _sesion.FiltrosConsultaInfo.SelecFecIndDesde
        txtFechaIndHasta.Text = _sesion.FiltrosConsultaInfo.SelecFecIndHasta
        If (Not IsNothing(DropDownListMetodoFam.Items.FindByText(_sesion.FiltrosConsultaInfo.SelecMetodoFam))) Then
            DropDownListMetodoFam.Items.FindByText(_sesion.FiltrosConsultaInfo.SelecMetodoFam).Selected = True
        End If
        If (Not IsNothing(DropDownListMetodoInd.Items.FindByText(_sesion.FiltrosConsultaInfo.SelecMetodoInd))) Then
            DropDownListMetodoInd.Items.FindByText(_sesion.FiltrosConsultaInfo.SelecMetodoInd).Selected = True
        End If
        If (Not IsNothing(DropDownListEncFam.Items.FindByText(_sesion.FiltrosConsultaInfo.SelecEncFam))) Then
            DropDownListEncFam.Items.FindByText(_sesion.FiltrosConsultaInfo.SelecEncFam).Selected = True
        End If
        If (Not IsNothing(DropDownListEncInd.Items.FindByText(_sesion.FiltrosConsultaInfo.SelecEncInd))) Then
            DropDownListEncInd.Items.FindByText(_sesion.FiltrosConsultaInfo.SelecEncInd).Selected = True
        End If
        ctResultados.NumPag = _sesion.FiltrosConsultaInfo.SelectPageIndex
        txtFechaRef.Text = _sesion.FiltrosConsultaInfo.SelecFecReferencia
    End Sub

    Private Sub CargarDatosEnSesion()
        Dim ctResultados As IMuestra = CType(phResultado.FindControl("myResultados"), IMuestra)
        _sesion.FiltrosConsultaInfo.SelectAnio = DropDownListAnio.SelectedItem.Text
        If (DropDownListTrim.Visible) Then
            'If (DropDownListTrim.Attributes("style").Equals("visibility:hidden")) Then
            _sesion.FiltrosConsultaInfo.SelectTrim = DropDownListTrim.SelectedItem.Text
        End If
        If (DropDownListSem.Visible) Then
            _sesion.FiltrosConsultaInfo.SelectSem = DropDownListSem.SelectedItem.Text
        End If
        If (DropDownListMes.Visible) Then
            _sesion.FiltrosConsultaInfo.SelectMes = DropDownListMes.SelectedItem.Text
        End If
        If (DropDownListLote.Visible) Then
            _sesion.FiltrosConsultaInfo.SelectLote = DropDownListLote.SelectedItem.Text
        End If
        If (DropDownListViviendaIC.Visible) Then
            _sesion.FiltrosConsultaInfo.SelectIC = DropDownListViviendaIC.SelectedItem.Text
        End If
        If (DropDownListTurno.Visible) Then
            _sesion.FiltrosConsultaInfo.SelectTurno = DropDownListTurno.SelectedItem.Text
        End If
        If (txtFechaEncuesta.Visible) Then
            _sesion.FiltrosConsultaInfo.SelecFecEncuesta = txtFechaEncuesta.Text
        End If

        _sesion.FiltrosConsultaInfo.SelectNumcDesde = txtNumcDesde.Text
        _sesion.FiltrosConsultaInfo.SelectNumcHasta = txtNumcHasta.Text
        _sesion.FiltrosConsultaInfo.SelectTh = DropDownListTerritorioHistorico.SelectedItem.Text
        _sesion.FiltrosConsultaInfo.SelectCom = DropDownListComarca.SelectedItem.Text()
        _sesion.FiltrosConsultaInfo.SelectMun = DropDownListMunicipio.SelectedItem.Text
        _sesion.FiltrosConsultaInfo.SelectSituac = DropDownListSituacion.SelectedItem.Text
        _sesion.FiltrosConsultaInfo.SelectRCont = DropDownListRContacto.SelectedItem.Text
        _sesion.FiltrosConsultaInfo.SelectRViv = DropDownListREncuesta.SelectedItem.Text
        _sesion.FiltrosConsultaInfo.SelectRPer = DropDownListRCuestPer.SelectedItem.Text
        _sesion.FiltrosConsultaInfo.SelectRFam = DropDownListRCuestFam.SelectedItem.Text
        _sesion.FiltrosConsultaInfo.SelectPageIndex = ctResultados.NumPag
        _sesion.FiltrosConsultaInfo.SelecFecFamDesde = txtFechaFamDesde.Text
        _sesion.FiltrosConsultaInfo.SelecFecFamHasta = txtFechaFamHasta.Text
        _sesion.FiltrosConsultaInfo.SelecFecIndDesde = txtFechaIndDesde.Text
        _sesion.FiltrosConsultaInfo.SelecFecIndHasta = txtFechaIndHasta.Text
        _sesion.FiltrosConsultaInfo.SelecMetodoFam = DropDownListMetodoFam.SelectedItem.Text
        _sesion.FiltrosConsultaInfo.SelecMetodoInd = DropDownListMetodoInd.SelectedItem.Text
        _sesion.FiltrosConsultaInfo.SelecEncFam = DropDownListEncFam.SelectedValue
        _sesion.FiltrosConsultaInfo.SelecEncInd = DropDownListEncInd.SelectedValue
        _sesion.FiltrosConsultaInfo.SelecFecReferencia = txtFechaRef.Text
    End Sub

    Protected Sub btnExcel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnExcel.Click
        If (_sesion.mostrarExcel) Then
            _sesion.mostrarExcel = False
            'Mostrar excel
            Response.Clear()
            Response.ClearHeaders()
            Response.ClearContent()
            Response.ContentType = "application/octet-stream"
            Response.Cache.SetCacheability(HttpCacheability.Private)
            Response.ContentEncoding = System.Text.Encoding.UTF8
            Response.AddHeader("Content-Disposition", "attachment; filename=" + "Muestra" + _sesion.Agente.Trim + ".xls")
            Response.BinaryWrite(_sesion.bytesFicheroExcel)
            bytesFicheroExcel = Nothing
            Response.Flush()
            Response.End()
        End If
    End Sub


    Protected Sub btnCambioOperación_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCambioOperación.Click
        Limpiar()
        _sesion.Numc = Nothing
        _sesion.Trim = Nothing
        Response.Redirect("PreEncuesta.aspx")
    End Sub
End Class
