﻿Imports System.IO
Imports System.Data
Imports System.Xml
Imports System.Xml.Schema

Partial Class CargarHojaRuta
    Inherits System.Web.UI.Page

    Private _MaxLimitUpload As Integer = 4096
    Private strMsgXmlValidation As String
    Private _sesion As AppSession

    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If (_sesion Is Nothing) Then
            _sesion = New AppSession
        End If
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        LiteralNombreEncuesta.Text = String.Format(LiteralNombreEncuesta.Text, _sesion.Operacion)
    End Sub


    Private Function comprobarExtension() As Boolean
        Dim extension As String = fupFichero.PostedFile.FileName.ToString().Substring(fupFichero.PostedFile.FileName.ToString().Length - 3, 3)

        If extension.ToUpper = "XML" Then
            ctFichero.IsValid = True
            Return True
        Else
            ctFichero.ErrorMessage = GetLocalResourceObject("LitNoPermitido").ToString()
            ctFichero.IsValid = False
            Return False
        End If
    End Function

    Protected Sub LinkButton4_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles LinkButton4.Click
        Try

            Dim ms As New MemoryStream()
            Dim docXML As XmlDocument = New XmlDocument()
            Dim stNumc, stAnio, stTrim, stSem, stFecha, stContacto, stObserv, stTlfn1, stTlfn2 As String
            Page.Validate()
            If (IsNothing(fupFichero.PostedFile) Or fupFichero.PostedFile.ContentLength = 0) Then
                ctFichero.IsValid = False
                ctFichero.ErrorMessage = GetLocalResourceObject("LitObligatorio")
            End If
            If (Page.IsValid And ctFichero.IsValid) Then
                If (ValidarTamaño(Request.Files) And comprobarExtension()) Then
                    ms = New MemoryStream(fupFichero.FileBytes)
                    docXML.Load(ms)

                    Dim fs As System.IO.Stream = fupFichero.PostedFile.InputStream

                    Dim validado As String = ValidateXML(fs)

                    If (validado.Equals(String.Empty)) Then
                        Dim m_nodelist As XmlNodeList
                        'Obtenemos la lista de los nodos "salto"
                        m_nodelist = docXML.SelectNodes("main/DATA_RECORD")
                        Dim contactosLN As ConContactos = New ConContactos(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Trim)
                        Dim dtAux As DataSet = contactosLN.CrearDsBaseContactos()
                        For Each m_node As XmlNode In m_nodelist
                            Dim dtRow As DataRow = dtAux.Tables(0).NewRow
                            stNumc = CType(m_node, XmlElement).GetElementsByTagName("NUMC")(0).InnerText
                            stAnio = CType(m_node, XmlElement).GetElementsByTagName("ANIO")(0).InnerText
                            If (CType(m_node, XmlElement).GetElementsByTagName("TRIM").Count > 0) Then
                                stTrim = CType(m_node, XmlElement).GetElementsByTagName("TRIM")(0).InnerText
                            Else
                                stTrim = String.Empty
                            End If
                            If (CType(m_node, XmlElement).GetElementsByTagName("SEM").Count > 0) Then
                                stSem = CType(m_node, XmlElement).GetElementsByTagName("SEM")(0).InnerText
                            Else
                                stSem = String.Empty
                            End If
                            stFecha = CType(m_node, XmlElement).GetElementsByTagName("FECHA")(0).InnerText
                            stContacto = CType(m_node, XmlElement).GetElementsByTagName("CONTACTO")(0).InnerText
                            If (CType(m_node, XmlElement).GetElementsByTagName("OBSERV").Count > 0) Then
                                stObserv = CType(m_node, XmlElement).GetElementsByTagName("OBSERV")(0).InnerText
                            Else
                                stObserv = String.Empty
                            End If
                            If (CType(m_node, XmlElement).GetElementsByTagName("TLFNO1").Count > 0) Then
                                stTlfn1 = CType(m_node, XmlElement).GetElementsByTagName("TLFNO1")(0).InnerText
                            Else
                                stTlfn1 = String.Empty
                            End If
                            If (CType(m_node, XmlElement).GetElementsByTagName("TLFNO2").Count > 0) Then
                                stTlfn2 = CType(m_node, XmlElement).GetElementsByTagName("TLFNO2")(0).InnerText
                            Else
                                stTlfn2 = String.Empty
                            End If
                            Dim dtSelectedRow As DataRow() = dtAux.Tables(0).Select(ConContactos.ColumnNumc & " = '" & stNumc & "' AND " & ConContactos.ColumnAenc & " = '" & stAnio & "' AND " & ConContactos.Columnfechahora & " = '" & stFecha & "'")
                            'si ya existe un registro con esos datos de clave
                            If (dtSelectedRow.Length = 0) Then
                                dtRow(ConContactos.ColumnNumc) = stNumc
                                dtRow(ConContactos.ColumnAenc) = stAnio
                                dtRow(ConContactos.ColumnTenc) = stTrim
                                dtRow(ConContactos.Columnfechahora) = stFecha
                                dtRow(ConContactos.ColumnPers) = stContacto
                                dtRow(ConContactos.Columnrcont) = Globales.RCONT_CONTACTO
                                dtRow(ConContactos.Columnobserv) = stObserv
                                dtRow(ConContactos.Columntlf1) = stTlfn1
                                dtRow(ConContactos.Columntlf2) = stTlfn2
                                dtAux.Tables(0).Rows.Add(dtRow)
                            End If
                        Next
                        Dim filasConDuplicados As String = contactosLN.ExistenDuplicados(dtAux)
                        If (Not (String.IsNullOrEmpty(filasConDuplicados))) Then
                            lblTexto.Text = "<b>" & GetLocalResourceObject("LitNoSatisfactorio").ToString() & "</b> <br/> Registros ya existentes en base de datos: <br/>" & filasConDuplicados
                            ScriptManager.RegisterStartupScript(Page, Page.GetType(), "Popup", "ShowPopup();", True)
                        Else
                            contactosLN.GuardarDatos(dtAux)
                            lblTexto.Text = "<b>" & GetLocalResourceObject("LitSatisfactorio").ToString() & "</b> <br/> <br/>"
                            lblTexto.Text = lblTexto.Text & String.Format(GetLocalResourceObject("LitNumRegistros"), "<b>" & dtAux.Tables(0).Rows.Count & "</b>")
                            ScriptManager.RegisterStartupScript(Page, Page.GetType(), "Popup", "ShowPopup();", True)
                        End If
                    Else
                        lblTexto.Text = "<b>" & GetLocalResourceObject("LitNoSatisfactorio").ToString() & "</b> <br/> <br/>" & validado
                        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "Popup", "ShowPopup();", True)
                    End If
                End If
            End If
        Catch ex As Exception
            lblTexto.Text = "<b>" & GetLocalResourceObject("LitNoSatisfactorio").ToString() & "</b> <br/> <br/>" & ex.Message
            ScriptManager.RegisterStartupScript(Page, Page.GetType(), "Popup", "ShowPopup();", True)
        End Try

    End Sub


    

    Public Function ValidateXML(ByVal xmlStream As Stream) As String

        Dim status As String = String.Empty

        Try
            Dim xmlValidatingReader As XmlReader
            Dim rs As New XmlReaderSettings()

            rs.ValidationType = ValidationType.Schema
            rs.ValidationFlags = Schema.XmlSchemaValidationFlags.ProcessSchemaLocation Or Schema.XmlSchemaValidationFlags.ReportValidationWarnings
            AddHandler rs.ValidationEventHandler, AddressOf ValidationEventHandler

            Dim xsdFilePath As String
            Try
                xsdFilePath = Server.MapPath("~/App_Data/XSD/" & _sesion.Operacion & "/HojaRuta.xsd")
                rs.Schemas.Add(Nothing, XmlReader.Create(xsdFilePath))
            Catch ex As Exception
                xsdFilePath = Server.MapPath("~/App_Data/XSD/HojaRuta.xsd")
                rs.Schemas.Add(Nothing, XmlReader.Create(xsdFilePath))
            End Try


            xmlValidatingReader = XmlReader.Create(xmlStream, rs)
            While xmlValidatingReader.Read

            End While

            xmlStream.Position = 0
            xmlValidatingReader.Close()

            If Not String.IsNullOrEmpty(strMsgXmlValidation) Then
                status = strMsgXmlValidation
            End If

            Return status
        Catch ex As Exception
            Throw
        End Try
    End Function


    Public Function ValidateXML(ByVal xmlStream As Stream, ByVal xsdFilePath As String) As String

        Dim status As String = String.Empty

        Try
            Dim xmlValidatingReader As XmlReader
            Dim rs As New XmlReaderSettings()

            rs.ValidationType = ValidationType.Schema
            rs.ValidationFlags = Schema.XmlSchemaValidationFlags.ProcessSchemaLocation Or Schema.XmlSchemaValidationFlags.ReportValidationWarnings
            AddHandler rs.ValidationEventHandler, AddressOf ValidationEventHandler
            rs.Schemas.Add(Nothing, XmlReader.Create(xsdFilePath))

            xmlValidatingReader = XmlReader.Create(xmlStream, rs)
            While xmlValidatingReader.Read

            End While

            xmlStream.Position = 0
            xmlValidatingReader.Close()

            If Not String.IsNullOrEmpty(strMsgXmlValidation) Then
                status = strMsgXmlValidation
            End If

            Return status
        Catch ex As Exception
            Throw
        End Try
    End Function

    Private Sub ValidationEventHandler(ByVal sender As Object, ByVal e As Schema.ValidationEventArgs)
        Me.strMsgXmlValidation &= e.Exception.Message & "<br/>"
    End Sub

    Public Function ValidarTamaño(ByVal p_Fcol As HttpFileCollection) As Boolean
        Dim _totSize As Integer = 0
        For i As Integer = 0 To p_Fcol.Count - 1
            _totSize += p_Fcol(i).ContentLength
        Next
        Dim resultado As Boolean = _totSize < Convert.ToInt32(_MaxLimitUpload) * 1024
        If (Not (resultado)) Then
            ctFichero.ErrorMessage = GetLocalResourceObject("LitTamañoMax").ToString()
            ctFichero.IsValid = False
        Else
            ctFichero.IsValid = True
        End If
        Return resultado

    End Function

End Class
