﻿Imports System.Reflection
Imports System.Xml
Imports System.Web.HttpContext
Imports System.Xml.Schema

Imports Eustat.Comun.V35.Ng
Imports Eustat.GEDW.V35.Ng
Imports System.IO

''' <summary>
''' PARTE ESPECIFICA DE CADA ENCUESTA
''' Clase AppSession que alberga valores de la encuesta en sesion.
''' </summary>
''' <remarks>Clase que alberga valores de la encuesta en sesion. Parte Especifica para implementar funcionalidades propias de la encuesta propietaria de la clase</remarks>

Public Module ModGeneralSpecific
    ''' <summary>
    ''' Reemplazar el codigo de fecha fin (@FFIN@) de los diferenetes contenidos (base de datos,...) 
    ''' por la fecha fin especificada en la informacion de control de la encuesta
    ''' </summary>
    ''' <param name="strXML">Contenido sobre el que se realizará el reemplazo.</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function AsignarXML(ByVal strXML As String) As String
        Dim sesion As New AppSession()
        Return strXML.Replace("@FFIN@", sesion.EncuestaInfo.FechaFin)
    End Function

    ''' <summary>
    ''' Inicializar valores especificos de encuesta al iniciar sesion.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub InicializarValoresSesion()

    End Sub

    ''' <summary>
    ''' Inicializar variables especificas de encuesta al iniciar la aplicación
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub InicializarVariablesAplication()
        Dim sesion As New AppSession

        sesion.ProvinciasInfo = New Provincias()
        sesion.MunicipiosInfo = New MunicipiosGedw()
        sesion.ComarcasInfo = New Comarcas()

    End Sub

    ''' <summary>
    ''' Inicialización y carga de clases propias del cuestionario
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub CargasIniciales()
        Dim sesion As New AppSession()
    End Sub

    Public Function PreCuestionarioInit() As Boolean
        Return False
    End Function

#Region "AUTOCOMPLETADO"
#Region "CONSTANTES"
    Private Const AUTOCOMPLETADO_URL As String = "autocomplete.aspx"
    Private Const AUTOCOMPLETADO_PARAM_TERM As String = "term"
    Private Const AUTOCOMPLETADO_PARAM_ID As String = "id"

    Private Const AUTOCOMPLETADO_PATH As String = "~/App_Data/Autocompletado.xml"
    Private Const AUTOCOMPLETADO_SCHEMA_RESOURCE As String = "~/App_Data/XSD/Autocompletado.xsd"
#End Region

    Private Sub InitAutocompletado()
        Dim sesion As New AppSession()
        Dim filepath As String = HttpContext.Current.Server.MapPath(AUTOCOMPLETADO_PATH)
        If sesion.Autocompletado Is Nothing AndAlso File.Exists(filepath) Then
            Try
                Dim xmlDoc As XmlDocument = GetXmlDocument(filepath, AUTOCOMPLETADO_SCHEMA_RESOURCE)
                sesion.Autocompletado = xmlDoc
            Catch ex As XmlSchemaValidationException
                Throw ex
            Catch ex As Exception
                Throw New XmlException("ERROR AL CARGAR Y GENERAR LA INFORMACIÓN DE AUTOCOMPLETADO")
            End Try
        End If
    End Sub

    ''' <summary>
    ''' Función que recupera la configuración de un objeto autocompleta del xml.
    ''' </summary>
    ''' <param name="id">identificador de autocompletado a evaluar en el fichero XML.</param>
    ''' <returns>Devuelve un objeto de tipo <c>AutocmpletadoConfig</c>.</returns>
    ''' <remarks></remarks>
    Public Function GetAutocompletadoConfig(ByVal id As String) As Eustat.GEDW.V35.Ng.AutocompletadoConfig

        Dim sesion As New AppSession()
        Dim campocas As String = String.Empty
        Dim campoeus As String = String.Empty
        Dim campoid As String = String.Empty
        Dim tabla As String = String.Empty
        If sesion.Autocompletado Is Nothing Then
            InitAutocompletado()
        End If
        If sesion.Autocompletado IsNot Nothing Then
            Dim autocompletadoNode As XmlNode
            autocompletadoNode = sesion.Autocompletado.DocumentElement.SelectSingleNode(String.Format(Eustat.GEDW.V35.Ng.Globales.Constantes.XML_NODE_AUTOCOMPLETADO_ROOT, id))
            If autocompletadoNode Is Nothing Then Throw New Exception(String.Format("Autocomplete identifier {0} not found", id))

            If Not autocompletadoNode.Attributes.GetNamedItem(Eustat.GEDW.V35.Ng.Globales.Constantes.XML_NODE_AUTOCOMPLETADO_ATTRIB_CAMPO_CAS) Is Nothing Then
                campocas = autocompletadoNode.Attributes.GetNamedItem(Eustat.GEDW.V35.Ng.Globales.Constantes.XML_NODE_AUTOCOMPLETADO_ATTRIB_CAMPO_CAS).Value
            End If
            If Not autocompletadoNode.Attributes.GetNamedItem(Eustat.GEDW.V35.Ng.Globales.Constantes.XML_NODE_AUTOCOMPLETADO_ATTRIB_CAMPO_EUS) Is Nothing Then
                campoeus = autocompletadoNode.Attributes.GetNamedItem(Eustat.GEDW.V35.Ng.Globales.Constantes.XML_NODE_AUTOCOMPLETADO_ATTRIB_CAMPO_EUS).Value
            End If
            If Not autocompletadoNode.Attributes.GetNamedItem(Eustat.GEDW.V35.Ng.Globales.Constantes.XML_NODE_AUTOCOMPLETADO_ATTRIB_TABLA) Is Nothing Then
                tabla = autocompletadoNode.Attributes.GetNamedItem(Eustat.GEDW.V35.Ng.Globales.Constantes.XML_NODE_AUTOCOMPLETADO_ATTRIB_TABLA).Value
            End If
            If Not autocompletadoNode.Attributes.GetNamedItem(Eustat.GEDW.V35.Ng.Globales.Constantes.XML_NODE_AUTOCOMPLETADO_ATTRIB_CAMPO_ID) Is Nothing Then
                campoid = autocompletadoNode.Attributes.GetNamedItem(Eustat.GEDW.V35.Ng.Globales.Constantes.XML_NODE_AUTOCOMPLETADO_ATTRIB_CAMPO_ID).Value
            End If
        End If

        Return New Eustat.GEDW.V35.Ng.AutocompletadoConfig(id, tabla, campocas, campoeus, campoid)
    End Function
    ''' <summary>
    ''' registra el script necesario  al control especificado para el autocompletado
    ''' </summary>
    ''' <param name="pagina">pagina que contiene los controles que se quieren registrar</param>
    ''' <param name="textBoxControl">Control web <c>TextBox</c> al que se quiere registrar el autocompletado</param>
    ''' <param name="AutocompleteID"><c>String</c> con el identificador de autocompletado</param>
    ''' <param name="AutocompleteMinLength"><c>Integer</c> con el identificador de autocompletado</param>
    Public Sub RegistrarAutocompletado(ByRef pagina As Page, ByVal textBoxControl As Eustat.Comun.V35.Web.TextBox, ByVal AutocompleteID As String, ByVal AutocompleteMinLength As Integer)

        Dim extraParams As String = ""

        If textBoxControl.MaxLength > 0 Then
            extraParams += ",  maxlength:" & textBoxControl.MaxLength & ""
        End If
         Dim funcChange As String = ""
        ScriptManager.RegisterStartupScript(textBoxControl, textBoxControl.GetType(), textBoxControl.UniqueID & "$Autocomplete", "Sys.Application.add_load(function() {$('#" & textBoxControl.ClientID & "').autocomplete({source: function( request, response ) {$.ajax({url: '" & AUTOCOMPLETADO_URL & "',dataType: 'json',data: {" & AUTOCOMPLETADO_PARAM_TERM & ": request.term , " & AUTOCOMPLETADO_PARAM_ID & ":" & AutocompleteID & " " & extraParams & " },success: function( data ) {response( data );}});}, select: function (event, ui) {$('#" & textBoxControl.ClientID & "').val(ui.item.value).change();}, minLength: " & AutocompleteMinLength & " " & funcChange & "});});" & Chr(13), True)

    End Sub

    Private Function GetXmlDocument(ByVal xmlfilePath As String, ByVal xmlSchemaPath As String) As XmlDocument
        Dim xmldoc As New XmlDocument()
        Dim xmlrdset As New XmlReaderSettings()
        Dim xmlrd As XmlReader

        xmlrdset.IgnoreComments = True
        xmlrdset.Schemas.Add(Nothing, XmlReader.Create(HttpContext.Current.Server.MapPath(xmlSchemaPath)))
        xmlrdset.ValidationType = ValidationType.Schema
        xmlrd = XmlReader.Create(xmlfilePath, xmlrdset)

        xmldoc.Load(xmlrd)
        Return xmldoc
    End Function

#End Region

#Region "URL ACCESO"

    Private Const DEFAULT_IDIOMA_QS_ID As String = "idioma"
    Private Const ENCRYPTED_QS_ID As String = "u"
    Private Const paginaAcesso As String = "DesdeHJR.aspx"



    Public Function EncodeAgenteURLAcceso(ByVal str As String) As String
        Return str.Replace("_", "..")
    End Function


    Public Function ObtenerURLAcceso(ByVal operacion As String, ByVal querystring As String, Optional ByVal idioma As String = Eustat.GEDW.V35.Ng.Globales.C_IDIOMA_CASTELLANO) As String
        'Nota: no implementado por seguridad. Contactar con Eustat
        Return ""
    End Function

#End Region

#Region "ENCRIPTACION"
    Public Function EncriptarStringExt(ByVal str As String) As String
        Dim Ext As New Eustat.Comun.V35.Crypting.CryptingEXT(ObtenerSalt)
        Return Ext.Encrypting(str)
    End Function

    Private Const SALT_PADDING_CHAR As Char = "X"c

    Private Function ObtenerSalt() As String
        Dim _sesion As New AppSession
        Dim str As String = _sesion.EncuestaSeleccionadaInfo.IdEncuesta

        If Not String.IsNullOrEmpty(_sesion.EncuestaSeleccionadaInfo.AnoReferencia) Then
            Select Case _sesion.EncuestaSeleccionadaInfo.PeriodoEncuestacion
                Case Eustat.GEDW.V35.Ng.Encuesta.TipoPeriodoEncuestacion.Anual
                    str &= _sesion.EncuestaSeleccionadaInfo.AnoReferencia
                Case Eustat.GEDW.V35.Ng.Encuesta.TipoPeriodoEncuestacion.Trimestral
                    Dim anio As Integer
                    Dim trim As Integer
                    Dim strCas As String = ""
                    Dim strEus As String = ""
                    Eustat.Comun.V35.Ng.Globales.obtenerAnyoTrimestre(strCas, strEus, anio, trim)
                    str &= anio & trim.ToString.PadLeft(2, "0")
                Case Eustat.GEDW.V35.Ng.Encuesta.TipoPeriodoEncuestacion.Mensual
                    Dim anio As Integer
                    Dim mes As Integer
                    Dim strCas As String = ""
                    Dim strEus As String = ""
                    Eustat.Comun.V35.Ng.Globales.obtenerMesAnyo(strCas, strEus, anio, mes)
                    str &= anio & mes.ToString.PadLeft(2, "0")
            End Select
        Else
            str &= Today.Year.ToString & Today.Month.ToString.PadLeft(2, "0") & Today.Day.ToString.PadLeft(2, "0")
        End If

        Return str.PadRight(8, SALT_PADDING_CHAR)
    End Function
#End Region
End Module
