﻿Imports Microsoft.VisualBasic

Public Class EstadoGridView

#Region "CONSTANTS"
    Private Const C_GV_ASCENDING_SORTDIRECTION As String = "ASC"
    Private Const C_GV_DESCENDING_SORTDIRECTION As String = "DESC"
#End Region

#Region "PROPERTIES"
    Private _pageIndex As Integer
    Public ReadOnly Property PageIndex As Integer
        Get
            Return _pageIndex
        End Get
        
    End Property

    Private _pageSize As String
    Public ReadOnly Property PageSize As String
        Get
            Return _pageSize
        End Get

    End Property

    Private _sortExpression As String
    Public Property SortExpression As String
        Get
            Return _sortExpression
        End Get
        Set(ByVal value As String)
            _sortExpression = value
        End Set
    End Property
#End Region

#Region "CONSTRUCTOR"
    Public Sub New()
        _pageIndex = 0
    End Sub
#End Region

#Region "METHODS"
    ''' <summary>
    ''' Método a ejecutar al inicializar la página que contiene el gridview para el que se ha guardado el estado
    ''' </summary>
    ''' <param name="gv"><c>Eustat.Comun.v35.Web.GridView</c> para el que se ha guardado el estado</param>
    ''' <remarks></remarks>
    Public Sub InicializarEstado(ByRef gv As Eustat.Comun.V35.Web.GridView)
        If Not String.IsNullOrEmpty(Me.PageSize) Then
            gv.PageSize = Me.PageSize
        End If
    End Sub

    ''' <summary>
    ''' Método a ejecutar al cargar la página que contiene el gridview para el que se ha guardado el estado
    ''' </summary>
    ''' <param name="gv"><c>Eustat.Comun.v35.Web.GridView</c> para el que se ha guardado el estado</param>
    ''' <remarks></remarks>
    Public Sub CargarEstado(ByRef gv As Eustat.Comun.V35.Web.GridView)
        gv.PageIndex = Me.PageIndex

        If Not String.IsNullOrEmpty(SortExpression) Then
            gv.DataBind()
            Dim sortDirection As SortDirection = WebControls.SortDirection.Ascending
            If SortExpression.EndsWith(C_GV_ASCENDING_SORTDIRECTION) Then
                sortDirection = WebControls.SortDirection.Ascending
                SortExpression = SortExpression.Remove(SortExpression.LastIndexOf(C_GV_ASCENDING_SORTDIRECTION) - 1)
            ElseIf SortExpression.EndsWith(C_GV_DESCENDING_SORTDIRECTION) Then
                sortDirection = WebControls.SortDirection.Ascending
                SortExpression = SortExpression.Remove(SortExpression.LastIndexOf(C_GV_DESCENDING_SORTDIRECTION) - 1)
            End If
            gv.Sort(SortExpression, sortDirection)

            gv.PageIndex = Me.PageIndex

         End If
    End Sub


    ''' <summary>
    ''' Metodo a ejecutar al descargar (Unload) la página que contiene el gridview para guardar su estado
    ''' </summary>
    ''' <param name="gv"><c>Eustat.Comun.v35.Web.GridView</c> para el que se quiere guardar el estado</param>
    ''' <remarks></remarks>
    Public Sub GuardarEstado(ByRef gv As Eustat.Comun.V35.Web.GridView)
        _sortExpression = gv.SortExpression
        _pageIndex = gv.PageIndex
        _pageSize = gv.PageSize
    End Sub

#End Region

End Class

