﻿Imports Microsoft.VisualBasic
Imports System.Configuration
Imports System.Globalization
Imports System.Web
Imports System.Web.SessionState

Imports Eustat.Comun.V35.Fmk.Ng
Imports Eustat.Comun.V35.Ng.Encuesta
Imports Eustat.GEDW.V35.Ng.IC
Imports System.Xml


''' <summary>
''' PARTE ESPECIFICA, INTRODUCIR LÍNEAS ESPECIFICAS A ESTA ENCUESTA
''' Clase AppSession que alberga valores de la encuesta en sesion.
''' </summary>
''' <remarks>Clase que alberga valores de la encuesta en sesion. Parte Especifica para implementar funcionalidades propias de la encuesta propietaria de la clase</remarks>
Partial Public Class AppSession

#Region "Constantes"
    ' Constantes utilizadas dentro de la clase

    Private Const C_TRIM_PROP As String = "Trim"
    Private Const C_SEMANA_PROP As String = "Sem"
    Private Const C_AENC_PROP As String = "Aenc"

    Private Const C_IC_PROP As String = "IC"

    Private Const C_TURNO_PROP As String = "Turno"

    Private Const C_ENCUESTA_SELECCIONADA_INFO_PROP As String = "EncuestaSeleccionada"

    Private Const C_CODIGO_IDENT_PROP As String = "COD_IND"

    Private Const C_VALMASIVA As String = "ValMasiva"
    Private Const C_NUMCVAL_PROP As String = "NumcVal"
    Private Const C_TIPOVAL_PROP As String = "TipoVal"
    Private Const C_DESCVAL_PROP As String = "DescVal"

    Private Const C_PERFIL_PROP As String = "PERFIL"

    Private Const C_OPEUSU_PROP As String = "OPEUSU"

    Private Const C_MULTIOPE_PROP As String = "MULTIOPE"

    Private Const C_FILVIV_PROP As String = "FILVIV"

    Private Const C_CONVIV_PROP As String = "CONVIV"

    Private Const C_CONVIVTS_PROP As String = "CONVIVTS"

    Private Const C_VOLVERVIV_PROP As String = "VOLVER"

    Private Const C_RVIV_PROP As String = "rviv"

    Private Const C_CAMBIOS_PROP As String = "CAMBIOS"

    Private Const C_PACTIVA_PROP As String = "C_PACTIVA_PROP"

    Private Const C_COLECTIVO_PROP As String = "COLECT"

    Private Const C_COLECTIVOTRIM_PROP As String = "COLECTTRIM"


    Private Const C_COLECTIVOVIVVACIA_PROP As String = "COLECTIVOVIVVACIA"

    Private Const C_RESULTTRIM_PROP As String = "RESULTTRIM"

    Private Const C_TICKET_PROP As String = "TICKET"

    Private Const C_VALIDACION_PROP As String = "VALIDACION"
    Private Const C_SITIOS_PROP As String = "SITIOS"

    Private Const C_VALIDACIONGEN_PROP As String = "VALIDACIONGEN"
    Private Const C_CODLITERALESOTROS_PROP As String = "CODLITERALESOTROS"

    Private Const C_AUTOCOMPLETADO_P As String = "AUTOCOMPLETADO"

    Private Const C_LISTADOS_PROP As String = "LISTADOS"
    Private Const C_METODOCUMP_PROP As String = "METODO_CUMPLIMENTACION"


    Private Const C_ESTADO_GV_MUESTRA_PROP As String = "ESTADOGVMUESTRA"

    Private Const C_ESTADO_GV_MUESTRA_ESIF_PROP As String = "ESTADOGVMUESTRAESIF"
    Private Const C_ESTADO_GV_MUESTRA_PRA_PROP As String = "ESTADOGVMUESTRAPRA"

    Private Const C_COMARCAS_PROP As String = "ComarcasProp"

    Private Const C_REFRESCANDO_GESTION_ENCUESTA As String = "REFRESCANDO_GESTION_ENCUESTA"

    Private Const C_GESTION_ENCUESTA_MUESTRA_PROP As String = "GESTION_ENCUESTA_MUESTRA"

#End Region

#Region "Propiedades publicas"
#Region "Globales"


    ''' <summary>
    ''' Obtener o establecer el Aenc.
    ''' </summary>
    ''' <value>Codigo Aenc que identifica un cuestionario.</value>
    ''' <returns>Objeto de tipo string con el valor del Aenc.</returns>
    ''' <remarks></remarks>
    Public Property Aenc() As String
        Get
            Return CType(_objSesion(C_AENC_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_AENC_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer el Trim.
    ''' </summary>
    ''' <value>Trim que identifica un cuestionario.</value>
    ''' <returns>Objeto de tipo string con el valor del Trim.</returns>
    ''' <remarks></remarks>
    Public Property Trim() As String
        Get
            Return CType(_objSesion(C_TRIM_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_TRIM_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer el Semana.
    ''' </summary>
    ''' <value>Semana que identifica un cuestionario.</value>
    ''' <returns>Objeto de tipo string con el valor del Semana.</returns>
    ''' <remarks></remarks>
    Public Property Semana() As String
        Get
            Return CType(_objSesion(C_SEMANA_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_SEMANA_PROP) = value
        End Set
    End Property


    ''' <summary>
    ''' Obtener o establecer el identificador de agente cuando se accede al cuestionario desde la hoja de ruta.
    ''' </summary>
    ''' <value>Código del agente.</value>
    ''' <returns>Objeto de tipo string con el valor del identificador de agente.</returns>
    ''' <remarks></remarks>
    Public Property Perfil() As String
        Get
            Return CType(_objSesion(C_PERFIL_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_PERFIL_PROP) = value
        End Set
    End Property


    Public Property ResultVivienda() As String
        Get
            Return CType(_objSesion(C_RVIV_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_RVIV_PROP) = value
        End Set
    End Property


#End Region


#Region "Generales"

    ''' <summary>
    ''' Obtener o establecer la informacion relativa a la encuesta que ha sido seleccionada.
    ''' </summary>
    ''' <value>Valor que indica la informacion relativa a la encuesta.</value>
    ''' <returns>Objeto de tipo Encuesta.</returns>
    ''' <remarks></remarks>
    Public Property EncuestaSeleccionadaInfo() As Encuesta.Encuesta
        Get
            Return CType(_objSesion(C_ENCUESTA_SELECCIONADA_INFO_PROP), Encuesta.Encuesta)
        End Get
        Set(ByVal value As Encuesta.Encuesta)
            _objSesion(C_ENCUESTA_SELECCIONADA_INFO_PROP) = value
        End Set
    End Property


    ''' <summary>
    ''' Obtener o establecer la informacion relativa a IC de la operación que ha sido seleccionada.
    ''' </summary>
    ''' <value>Valor que indica a informacion relativa a IC.</value>
    ''' <returns>Objeto de tipo IC.</returns>
    ''' <remarks></remarks>
    Public Property IC() As IC
        Get
            If _objSesion(C_IC_PROP) Is Nothing Then
                _objSesion(C_IC_PROP) = New IC(Me.Operacion)
            End If
            Return CType(_objSesion(C_IC_PROP), IC)
        End Get
        Set(ByVal value As IC)
            _objSesion(C_IC_PROP) = value
        End Set
    End Property

    Public Property GestionEncuestaMuestra As Muestra
        Get
            Return CType(_objSesion(C_GESTION_ENCUESTA_MUESTRA_PROP), Muestra)
        End Get
        Set(ByVal value As Muestra)
            _objSesion(C_GESTION_ENCUESTA_MUESTRA_PROP) = value
        End Set
    End Property

    Public Property RefrescandoGestionEncuesta As Boolean
        Get
            Return _objSesion(C_REFRESCANDO_GESTION_ENCUESTA)
        End Get
        Set(ByVal value As Boolean)
            _objSesion(C_REFRESCANDO_GESTION_ENCUESTA) = value
        End Set
    End Property


    ''' <summary>
    ''' Obtener o establecer la informacion relativa al turno de la operación que ha sido seleccionada.
    ''' </summary>
    ''' <value>Valor que indica a informacion relativa al turno.</value>
    ''' <returns>Objeto de tipo Turno.</returns>
    ''' <remarks></remarks>
    Public Property TurnoInfo() As Turno
        Get
            If _objSesion(C_TURNO_PROP) Is Nothing Then
                _objSesion(C_TURNO_PROP) = New Turno(Me.Operacion)
            End If
            Return CType(_objSesion(C_Turno_PROP), Turno)
        End Get
        Set(ByVal value As Turno)
            _objSesion(C_Turno_PROP) = value
        End Set
    End Property

    Public Property OperacionesUsuarioInfo() As OperacionesUsuario
        Get
            Return CType(_objSesion(C_OPEUSU_PROP), OperacionesUsuario)
        End Get
        Set(ByVal value As OperacionesUsuario)
            _objSesion(C_OPEUSU_PROP) = value
        End Set
    End Property


    Public Property FiltrosConsultaInfo() As FiltrosMuestra
        Get
            Return CType(_objSesion(C_FILVIV_PROP), FiltrosMuestra)
        End Get
        Set(ByVal value As FiltrosMuestra)
            _objSesion(C_FILVIV_PROP) = value
        End Set
    End Property


    Public Property ConsultaVivInfo() As ConMuestra
        Get
            Return CType(_objSesion(C_CONVIV_PROP), ConMuestra)
        End Get
        Set(ByVal value As ConMuestra)
            _objSesion(C_CONVIV_PROP) = value
        End Set
    End Property


    Public Property ColectivoInfo() As ConColectivo
        Get
            Return CType(_objSesion(C_COLECTIVO_PROP), ConColectivo)
        End Get
        Set(ByVal value As ConColectivo)
            _objSesion(C_COLECTIVO_PROP) = value
        End Set
    End Property


    Private _volver As Boolean
    Public Property VolverVivienda() As Boolean
        Get
            Return CType(_objSesion(C_VOLVERVIV_PROP), Boolean)
        End Get
        Set(ByVal value As Boolean)
            _objSesion(C_VOLVERVIV_PROP) = value
        End Set
    End Property

    Public Property MultiOperacion() As Boolean
        Get
            Return CType(_objSesion(C_MULTIOPE_PROP), Boolean)
        End Get
        Set(ByVal value As Boolean)
            _objSesion(C_MULTIOPE_PROP) = value
        End Set
    End Property

    Public Property CambiosEnPagina() As Boolean
        Get
            Return CType(_objSesion(C_CAMBIOS_PROP), Boolean)
        End Get
        Set(ByVal value As Boolean)
            _objSesion(C_CAMBIOS_PROP) = value
        End Set
    End Property

    Public Property PestañaActiva() As String
        Get
            Return CType(_objSesion(C_PACTIVA_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_PACTIVA_PROP) = value
        End Set
    End Property

    Public Property ParamsTicket() As String
        Get
            Return CType(_objSesion(C_TICKET_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_TICKET_PROP) = value
        End Set
    End Property


    Public Property Autocompletado As XmlDocument
        Get
            Return CType(_objAplicacion(C_AUTOCOMPLETADO_P), XmlDocument)
        End Get
        Set(ByVal value As XmlDocument)
            _objAplicacion(C_AUTOCOMPLETADO_P) = value
        End Set
    End Property

    Public Property Listados() As Listados
        Get
            Return CType(_objSesion(C_LISTADOS_PROP), Listados)
        End Get
        Set(ByVal value As Listados)
            _objSesion(C_LISTADOS_PROP) = value
        End Set
    End Property

    Public Property MetodoCump() As MetodoCump
        Get
            Return CType(_objSesion(C_METODOCUMP_PROP), MetodoCump)
        End Get
        Set(ByVal value As MetodoCump)
            _objSesion(C_METODOCUMP_PROP) = value
        End Set
    End Property

    ''' <summary>
    '''  Obtener o establecer la clase <c>EstadoGridView</c>.
    ''' </summary>
    ''' <value>Objeto de tipo <c>EstadoGridView</c></value>
    ''' <returns>Objeto de tipo <c>EstadoGridView</c></returns>
    ''' <remarks></remarks>
    Public Property EstadoGVMuestra As EstadoGridView
        Get
            Return CType(_objSesion(C_ESTADO_GV_MUESTRA_PROP), EstadoGridView)
        End Get
        Set(ByVal value As EstadoGridView)
            _objSesion(C_ESTADO_GV_MUESTRA_PROP) = value
        End Set
    End Property


    ''' <summary>
    ''' Obtener o establecer las diferentes comarcas disponibles.
    ''' </summary>
    ''' <value>Valor que indica el listado de comarcas.</value>
    ''' <returns>Objeto de tipo <c>Comarcas</c> con el listado de comarcas.</returns>
    ''' <remarks></remarks>
    Public Property ComarcasInfo() As Comarcas
        Get
            Return CType(_objAplicacion(C_COMARCAS_PROP), Comarcas)
        End Get
        Set(ByVal value As Comarcas)
            _objAplicacion(C_COMARCAS_PROP) = value
        End Set
    End Property


#End Region


#Region "ValidacionMasiva"

    ''' <summary>
    ''' Obtener o establecer la clase ValidacionGeneral.
    ''' </summary>
    ''' <value>Valor que indica la instancia de la clase de ValidacionGeneral.</value>
    ''' <returns>Objeto de tipo <c>ValidacionGeneral</c> con la clase de ValidacionGeneral.</returns>
    ''' <remarks></remarks>
    Public Property ValidacionGeneralInfo() As ValidacionGeneral
        Get
            Return CType(_objSesion(C_VALIDACIONGEN_PROP), ValidacionGeneral)
        End Get
        Set(ByVal value As ValidacionGeneral)
            _objSesion(C_VALIDACIONGEN_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer el Numc seleccionado en el filtro de la validacion masiva.
    ''' </summary>
    ''' <value>Codigo Numcseleccionado en el filtro de la validacion masiva.</value>
    ''' <returns>Objeto de tipo string con el valor del Numc seleccionado en el filtro de la validacion masiva.</returns>
    ''' <remarks></remarks>
    Public Property ValidacionNumc() As String
        Get
            Return CType(_objSesion(C_NUMCVAL_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_NUMCVAL_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer el Tipo seleccionado en el filtro de la validacion masiva.
    ''' </summary>
    ''' <value>Codigo Tipo seleccionado en el filtro de la validacion masiva.</value>
    ''' <returns>Objeto de tipo string con el valor del Tipo seleccionado en el filtro de la validacion masiva.</returns>
    ''' <remarks></remarks>
    Public Property ValidacionTipo() As String
        Get
            Return CType(_objSesion(C_TIPOVAL_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_TIPOVAL_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer la descripción del error seleccionado en el filtro de la validacion masiva.
    ''' </summary>
    ''' <value>Codigo Numcseleccionado en el filtro de la validacion masiva.</value>
    ''' <returns>Objeto de tipo string con el valor del Numc seleccionado en el filtro de la validacion masiva.</returns>
    ''' <remarks></remarks>
    Public Property ValidacionDesc() As String
        Get
            Return CType(_objSesion(C_DESCVAL_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_DESCVAL_PROP) = value
        End Set
    End Property

    Public Property bytesFicheroExcel() As Byte()
        Get
            Return CType(_objSesion("bytesFicheroExcel"), Byte())
        End Get
        Set(ByVal value As Byte())
            _objSesion("bytesFicheroExcel") = value
        End Set
    End Property

    Public Property bytesFicheroExcelVal() As Byte()
        Get
            Return CType(_objSesion("bytesFicheroExcelVal"), Byte())
        End Get
        Set(ByVal value As Byte())
            _objSesion("bytesFicheroExcelVal") = value
        End Set
    End Property

    Public Property bytesFicheroExcelValsit() As Byte()
        Get
            Return CType(_objSesion("bytesFicheroExcelValsit"), Byte())
        End Get
        Set(ByVal value As Byte())
            _objSesion("bytesFicheroExcelValsit") = value
        End Set
    End Property

    Public Property bytesFicheroListados() As Byte()
        Get
            Return CType(_objSesion("bytesFicheroListados"), Byte())
        End Get
        Set(ByVal value As Byte())
            _objSesion("bytesFicheroListados") = value
        End Set
    End Property

    Public Property mostrarExcel() As Boolean
        Get
            Return CType(_objSesion("mostrarExcel"), Boolean)
        End Get
        Set(ByVal value As Boolean)
            _objSesion("mostrarExcel") = value
        End Set
    End Property

    Public Property mostrarExcelListado() As Boolean
        Get
            Return CType(_objSesion("mostrarExcelListado"), Boolean)
        End Get
        Set(ByVal value As Boolean)
            _objSesion("mostrarExcelListado") = value
        End Set
    End Property

    Public Property NameListado() As String
        Get
            Return CType(_objSesion("nameListado"), String)
        End Get
        Set(ByVal value As String)
            _objSesion("nameListado") = value
        End Set
    End Property

    Public Property XmlDoc() As XmlDocument
        Get
            Return CType(_objSesion("XmlDoc"), XmlDocument)
        End Get
        Set(ByVal value As XmlDocument)
            _objSesion("XmlDoc") = value
        End Set
    End Property


#End Region


#Region "PRA"
    ''' <summary>
    '''  Obtener o establecer la clase <c>EstadoGridView</c>.
    ''' </summary>
    ''' <value>Objeto de tipo <c>EstadoGridView</c></value>
    ''' <returns>Objeto de tipo <c>EstadoGridView</c></returns>
    ''' <remarks></remarks>
    Public Property EstadoGVMuestraPRA As EstadoGridView
        Get
            Return CType(_objSesion(C_ESTADO_GV_MUESTRA_PRA_PROP), EstadoGridView)
        End Get
        Set(ByVal value As EstadoGridView)
            _objSesion(C_ESTADO_GV_MUESTRA_PRA_PROP) = value
        End Set
    End Property
#End Region

#End Region


End Class

