﻿Imports System.Reflection
Imports System.Xml
Imports System.Web.HttpContext

Imports Eustat.Comun.V35.Ng


''' <summary>
''' PARTE GENERAL. SOLO SE MODIFICARÁ POR TÉCNICOS EUSTAT
''' Clase AppSession que alberga valores de la encuesta en sesion.
''' </summary>
''' <remarks>Clase que alberga valores de la encuesta en sesion. Parte General, definida por Eustat</remarks>

Public Module ModGeneral

    Private Const valor_vacio As String = "VACIO"

#Region "Inicializacion de informacion de base de datos"
    ''' <summary>
    ''' Inicializa la informacion de base de datos referente a las sentencias SQL de cuestionario, 
    ''' y el sistema dinamico de asociacines entre controles de interfaz y campos de base de datos.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub CargarInfoHashCamposBBDD()
        Const HashSentenciasBBDD As String = "HashSenteciasBBDD"
        Const HashCamposBBDD As String = "HashCamposBBDD"

        Dim controlSentencias As New ControlSentenciasBBDD()
        Dim controlInfo As New ControlInternoBBDD()

        HttpContext.Current.Application(HashSentenciasBBDD) = controlSentencias.ControlSenteciasBBDD
        HttpContext.Current.Application(HashCamposBBDD) = controlInfo.ControlInfoBBDD
    End Sub
#End Region

#Region "Idioma"
    ''' <summary>
    ''' Establecer idioma en la aplicación web
    ''' </summary>
    ''' <param name="strCulture"></param>
    ''' <remarks></remarks>
    Public Sub EstablecerIdioma(ByVal strCulture As String)
        System.Threading.Thread.CurrentThread.CurrentCulture = System.Globalization.CultureInfo.CreateSpecificCulture(strCulture)
        System.Threading.Thread.CurrentThread.CurrentUICulture = New System.Globalization.CultureInfo(strCulture)
    End Sub
#End Region

#Region "Cerrar Sesion"
    ''' <summary>
    ''' Procedimiento para cerrar la sesion
    ''' </summary>
    ''' <param name="Ctrl"></param>
    ''' <remarks></remarks>
    Public Sub CerrarSesion(ByVal Ctrl As Control)
        Dim sesion As New AppSession
        Dim strIdioma As String = sesion.Idioma
        Dim strAgente As String = sesion.Agente

        FormsAuthentication.SignOut()
        Current.Session.Abandon()
       
        Current.Response.Redirect("~/PreEncuesta.aspx?idioma=" & strIdioma)
       
    End Sub

    ''' <summary>
    ''' Generar script de cierre de ventana
    ''' </summary>
    ''' <param name="Ctrl"></param>
    ''' <remarks></remarks>
    Private Sub CerrarVentana(ByVal Ctrl As Control)
        Dim script As New StringBuilder()
        script.AppendLine("window.open('', '_self', ''); window.close();")
        ScriptManager.RegisterStartupScript(Ctrl.Page, Ctrl.GetType(), "wclose", script.ToString(), True)
    End Sub
#End Region




End Module
