﻿Imports Microsoft.VisualBasic
Imports System.Configuration
Imports System.Globalization
Imports System.Web
Imports System.Web.SessionState

Imports Eustat.Comun.V35.Fmk.Ng
Imports Eustat.Comun.V35.Ng


''' <summary>
''' PARTE GENERAL. SOLO SE MODIFICARÁ POR TÉCNICOS EUSTAT
''' Clase AppSession que alberga valores de la encuesta en sesion.
''' </summary>
''' <remarks>Clase que alberga valores de la encuesta en sesion. Parte General, definida por Eustat</remarks>
Partial Public Class AppSession

#Region "Constantes"
    ' Constantes utilizadas dentro de la clase
    Private Const C_NUMC_PROP As String = "Numc"
    Private Const C_OPERACION_PROP As String = "Operacion"
    Private Const C_AGENTE_PROP As String = "Agente"
    Private Const C_START_PROP As String = "Start"
    Private Const C_IDIOMA_PROP As String = "Language"
    Private Const C_IDIOMA_CHANGE_PROP As String = "LanguageChange"
    Private Const C_ERROR_COHESION_PROP As String = "ErrorCohesion"

    Private Const C_ERROR_MESSAGE_PROP As String = "ErrorMessage"
    Private Const C_ERROR_TEC_MESSAGE_PROP As String = "ErrorTecMessage"
    Private Const C_ERROR_SOURCE_PROP As String = "ErrorSource"
    Private Const C_STACKTRACE_PROP As String = "StackTrace"

    Private Const C_ENCUESTA_PROP As String = "Encuesta"
    Private Const C_CONTROLCUESTIONARIO_PROP As String = "ControlCuestionario"
    Private Const C_MAPA_ESQUEMA_PROP As String = "MapaEsquema"
    Private Const C_MAPA_PROP As String = "Mapa"
    Private Const C_TIEMPOENCUESTACION_PROP As String = "TiempoEncuestacion"
    Private Const C_TRAZAS_PROP As String = "Trazas"

    Private Const C_MUESTRA_PROP As String = "Muestra"
    Private Const C_CUESTIONARIO_PROP As String = "CuestionarioProp"
    Private Const C_PROVINVIAS_PROP As String = "ProvinciasProp"
    Private Const C_MUNICIPIOS_PROP As String = "MunicipiosProp"

    Private Const C_TIPOTRAZA_PROP As String = "TipoTrazaProp"
    Private Const C_TIPOERROR_PROP As String = "TipoErrorProp"

    Private Const C_ACCESOS_PROP As String = "AccesosProp"

    Private Const C_SESSIONID_PROP As String = "SesionId"
    Private Const C_DNI As String = "DNI"
    Private Const C_USER_PROP As String = "USUARIO"

    Private Const C_HT_TABLASADIC_PROP As String = "TABLASADICIONALES"
#End Region

#Region "Variables"
    'Contenedor del objeto aplicacion
    Private _objAplicacion As HttpApplicationState
    ' Contenedor del objeto de sesión
    Private _objSesion As HttpSessionState
#End Region

#Region "Constructores"
    ''' <summary>
    ''' Constructor por defecto de la clase.
    ''' </summary>
    ''' <remarks>Se encarga de inicalizar la clase y de obtener las sesión que va a manejar.</remarks>
    Public Sub New()
        ' Obtenemos el objeto aplicacion ...
        _objAplicacion = HttpContext.Current.Application
        ' Obtenemos la sesión ...
        _objSesion = HttpContext.Current.Session
    End Sub
#End Region

#Region "Propiedades publicas"
#Region "Globales"
    ''' <summary>
    ''' Obtener o establecer el Timeout de la sesión.
    ''' </summary>
    ''' <value>Timeout de la sesión.</value>
    ''' <returns>Objeto de tipo integer con el valor de timeout de la sesión.</returns>
    ''' <remarks></remarks>
    Public Property Timeout() As Integer
        Get
            Return _objSesion.Timeout
        End Get
        Set(ByVal value As Integer)
            _objSesion.Timeout = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer el Numc.
    ''' </summary>
    ''' <value>Codigo Numc que identifica un cuestionario.</value>
    ''' <returns>Objeto de tipo string con el valor del Numc.</returns>
    ''' <remarks></remarks>
    Public Property Numc() As String
        Get
            Return CType(_objSesion(C_NUMC_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_NUMC_PROP) = value
        End Set
    End Property

    Public Property DescTrimCas() As String
        Get
            Return _objSesion(Eustat.Comun.V35.Ng.Globales.C_DESCTRIMCAS_PROP)
        End Get
        Set(ByVal value As String)
            _objSesion(Eustat.Comun.V35.Ng.Globales.C_DESCTRIMCAS_PROP) = value
        End Set
    End Property

    Public Property DescTrimEus() As String
        Get
            Return _objSesion(Eustat.Comun.V35.Ng.Globales.C_DESCTRIMEUS_PROP)
        End Get
        Set(ByVal value As String)
            _objSesion(Eustat.Comun.V35.Ng.Globales.C_DESCTRIMEUS_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer el hashtable.
    ''' </summary>
    ''' <value>Hashtable con la información de tablas adicionales a inicializar.</value>
    ''' <returns>Objeto de tipo hashtable con los valores de tabla-columna-valor y tipo.</returns>
    ''' <remarks></remarks>
    Public Property TablasAdicionales() As Hashtable
        Get
            Return CType(_objSesion(C_HT_TABLASADIC_PROP), Hashtable)
        End Get
        Set(ByVal value As Hashtable)
            _objSesion(C_HT_TABLASADIC_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer el Id de la Sesion Actual.
    ''' </summary>
    ''' <value>Id de la Sesion Actual.</value>
    ''' <returns>Objeto de tipo string con el valor de la Id de la Sesion Actual.</returns>
    ''' <remarks></remarks>
    Public Property SesionId() As String
        Get
            Return CType(_objSesion(C_SESSIONID_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_SESSIONID_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtiene o establece el usuario actual de la aplicación.
    ''' </summary>
    ''' <value>Nombre del usuario actual.</value>
    ''' <returns>String que contiene el nombre del usuario conectado a la aplicación.</returns>
    ''' <remarks>Para que está propiedad devuelva un valor, el usuario tiene que estar autenticado.</remarks>
    Public Property UsuarioActual() As String
        Get
            Return CType(_objSesion(C_USER_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_USER_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtiene o establece el dni del usuario actual de la aplicación.
    ''' </summary>
    ''' <value>DNI del usuario actual.</value>
    ''' <returns>String que contiene el DNI del usuario conectado a la aplicación.</returns>
    ''' <remarks>Para que está propiedad devuelva un valor, el usuario tiene que estar autenticado.</remarks>
    Public Property DNI() As String
        Get
            Return CType(_objSesion(C_DNI), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_DNI) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer la operacion del cuestionario.
    ''' </summary>
    ''' <value>Operacion de la web del cuestionario.</value>
    ''' <returns>Objeto de tipo string con el valor de la operacion.</returns>
    ''' <remarks></remarks>
    Public Property Operacion() As String
        Get
            Return CType(_objSesion(C_OPERACION_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_OPERACION_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer el identificador de agente cuando se accede al cuestionario desde la hoja de ruta.
    ''' </summary>
    ''' <value>Código del agente.</value>
    ''' <returns>Objeto de tipo string con el valor del identificador de agente.</returns>
    ''' <remarks></remarks>
    Public Property Agente() As String
        Get
            Return CType(_objSesion(C_AGENTE_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_AGENTE_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer si una vez iniciada la sesion no se ha realizado ninguna accion.
    ''' </summary>
    ''' <value>Valor que indica si una vez iniciada la sesion no se ha realizado ninguna accion.</value>
    ''' <returns>
    ''' <c>True</c>: No se ha realizado ninguna accion.
    ''' <c>False</c>: Se ha realizado al menos una accion.
    ''' </returns>
    ''' <remarks>Controlar si una vez iniciada la sesion no se ha realizado ninguna accion.
    ''' De este modo se puede controlar que en la primera carga se muestre el ultimo nodo visitado del mapa, por ejemplo.
    ''' </remarks>
    Public Property Start() As Boolean
        Get
            If _objSesion(C_START_PROP) IsNot Nothing Then
                Return CType(_objSesion(C_START_PROP), Boolean)
            Else
                Return True
            End If
        End Get
        Set(ByVal value As Boolean)
            _objSesion(C_START_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer el idioma en el que se muestra la aplicación
    ''' </summary>
    ''' <value>Identificador de idioma.</value>
    ''' <returns>String que contiene el identificador del idioma.
    ''' <example><c>es-ES</c>: Castellano. <c>eu-ES</c>: Euskera.</example>
    ''' </returns>
    ''' <remarks>El idioma se actualiza cada vez que el usuario elige el idioma en el 
    ''' que quiere que se muestra la aplicación.</remarks>
    Public Property Idioma() As String
        Get
            'Si no hay un idioma, se obtiene del archivo de configuración
            If _objSesion(C_IDIOMA_PROP) Is Nothing Then
                _objSesion(C_IDIOMA_PROP) = ConfigurationManager.AppSettings("Castellano")
            End If
            'Se devuelve el idioma de la aplicación
            Return CType(_objSesion(C_IDIOMA_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_IDIOMA_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtiene la cultura local que se aplicará a la aplicación.
    ''' </summary>
    ''' <value>Cultura local actual.</value>
    ''' <returns>Devuelve un objeto de tipo CultureInfo que contiene la cultura local actual.</returns>
    ''' <remarks>El objeto devuelto se utilizará para establecer el idioma de la aplicación.</remarks>
    Public ReadOnly Property CulturaActual() As CultureInfo
        Get
            Return New CultureInfo(Me.Idioma)
        End Get
    End Property

    ''' <summary>
    ''' Obtinene o establece si se ha producido la accion de cambio de idioma.
    ''' </summary>
    ''' <value>Valor que indica si se ha producido la accion de cambio de idioma.</value>
    ''' <returns>
    ''' <c>True</c>: Se ha produccido la accion de cambio de idioma.
    ''' <c>False</c>: No se ha produccido la accion de cambio de idioma.
    ''' </returns>
    ''' <remarks></remarks>
    Public Property IdiomaChange() As Boolean
        Get
            If _objSesion(C_IDIOMA_CHANGE_PROP) IsNot Nothing Then
                Return CType(_objSesion(C_IDIOMA_CHANGE_PROP), Boolean)
            Else
                Return False
            End If
        End Get
        Set(ByVal value As Boolean)
            _objSesion(C_IDIOMA_CHANGE_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtinene o establece si se ha producido errores tipo duro en las validaciones de cohexión
    ''' </summary>
    ''' <value>Valor que indica si se ha producido la accion de cambio de idioma.</value>
    ''' <returns>
    ''' <c>True</c>: Se ha produccido la accion de cambio de idioma.
    ''' <c>False</c>: No se ha produccido la accion de cambio de idioma.
    ''' </returns>
    ''' <remarks></remarks>
    Public Property ErroresCohesionGraves() As Boolean
        Get
            If _objSesion(C_ERROR_COHESION_PROP) IsNot Nothing Then
                Return CType(_objSesion(C_ERROR_COHESION_PROP), Boolean)
            Else
                Return False
            End If
        End Get
        Set(ByVal value As Boolean)
            _objSesion(C_ERROR_COHESION_PROP) = value
        End Set
    End Property
#End Region

#Region "Error"
    ''' <summary>
    ''' Obtener o establecer el mensaje de error de la web.
    ''' </summary>
    ''' <value>Valor que indica el mensaje de error a mostrar.</value>
    ''' <returns>String que representa el mensaje de error.</returns>
    ''' <remarks></remarks>
    Public Property ErrorMessage() As String
        Get
            Return CType(_objSesion(C_ERROR_MESSAGE_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_ERROR_MESSAGE_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer el mensaje de error tecnico de la web.
    ''' </summary>
    ''' <value>Valor que indica el mensaje de error tecnico a mostrar.</value>
    ''' <returns>String que representa el mensaje de error tecnico.</returns>
    ''' <remarks></remarks>
    Public Property ErrorTecMessage() As String
        Get
            Return CType(_objSesion(C_ERROR_TEC_MESSAGE_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_ERROR_TEC_MESSAGE_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer el origen del error.
    ''' </summary>
    ''' <value>Valor que indica el origen del error.</value>
    ''' <returns>String que representa el origen del error.</returns>
    ''' <remarks></remarks>
    Public Property ErrorSource() As String
        Get
            Return CType(_objSesion(C_ERROR_SOURCE_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_ERROR_SOURCE_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer la traza del error.
    ''' </summary>
    ''' <value>Valor que indica la traza del error.</value>
    ''' <returns>String que representa la traza del error.</returns>
    ''' <remarks></remarks>
    Public Property StackTrace() As String
        Get
            Return CType(_objSesion(C_STACKTRACE_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_STACKTRACE_PROP) = value
        End Set
    End Property
#End Region

#Region "Encuesta"
    ''' <summary>
    ''' Obtener o establecer la informacion relativa a la encuesta.
    ''' </summary>
    ''' <value>Valor que indica la informacion relativa a la encuesta.</value>
    ''' <returns>Objeto de tipo Encuesta.</returns>
    ''' <remarks></remarks>
    Public Property EncuestaInfo() As Encuesta
        Get
            Return CType(_objSesion(C_ENCUESTA_PROP), Encuesta)
        End Get
        Set(ByVal value As Encuesta)
            _objSesion(C_ENCUESTA_PROP) = value
        End Set
    End Property





    ''' <summary>
    ''' Obtener o establecer el valor de nodo del mapa activo.
    ''' </summary>
    ''' <value>Valor de nodo del mapa activo.</value>
    ''' <returns>Objeto de tipo string con el valor del nodo activo.</returns>
    ''' <remarks></remarks>
    Public Property Mapa() As String
        Get
            Return CType(_objSesion(C_MAPA_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_MAPA_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtiene o establece la disponibilidad o no de trazas
    ''' </summary>
    ''' <value>String Trazas</value>
    ''' <returns>Objeto de tipo string con el valor del Trazas</returns>
    ''' <remarks>Trazas</remarks>
    Public Property Trazas() As String
        Get
            Return CType(_objSesion(C_TRAZAS_PROP), String)
        End Get
        Set(ByVal value As String)
            _objSesion(C_TRAZAS_PROP) = value
        End Set
    End Property
#End Region

#Region "Generales"


    Public Property TiempoEncuestacion() As Date
        Get
            Return CType(_objSesion(C_TIEMPOENCUESTACION_PROP), Date)
        End Get
        Set(ByVal value As Date)
            _objSesion(C_TIEMPOENCUESTACION_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer las diferentes provincias disponibles.
    ''' </summary>
    ''' <value>Valor que indica el listado de provincias.</value>
    ''' <returns>Objeto de tipo <c>Provincias</c> con el listado de provincias.</returns>
    ''' <remarks></remarks>
    Public Property ProvinciasInfo() As Provincias
        Get
            Return CType(_objAplicacion(C_PROVINVIAS_PROP), Provincias)
        End Get
        Set(ByVal value As Provincias)
            _objAplicacion(C_PROVINVIAS_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer los diferentes municipios disponibles. 
    ''' Ahora es tipo MunicipiosGedw ya que la carga además de por provincias depende de las comarcas. (Cambio 03/03/2017)
    ''' </summary>
    ''' <value>Valor que indica el listado de municipios.</value>
    ''' <returns>Objeto de tipo <c>Municipios</c> con el listado de municipios.</returns>
    ''' <remarks></remarks>
    Public Property MunicipiosInfo() As MunicipiosGedw
        Get
            Return CType(_objAplicacion(C_MUNICIPIOS_PROP), MunicipiosGedw)
        End Get
        Set(ByVal value As MunicipiosGedw)
            _objAplicacion(C_MUNICIPIOS_PROP) = value
        End Set
    End Property
#End Region

#Region "Busqueda Incidencias"
    ''' <summary>
    ''' Obtener o establecer las diferentes TipoAcceso disponibles.
    ''' </summary>
    ''' <value>Valor que indica el listado de TipoAcceso.</value>
    ''' <returns>Objeto de tipo <c>TipoAcceso</c> con el listado de TipoAcceso.</returns>
    ''' <remarks></remarks>
    Public Property TipoTrazaInfo() As TipoTraza
        Get
            Return CType(_objSesion(C_TIPOTRAZA_PROP), TipoTraza)
        End Get
        Set(ByVal value As TipoTraza)
            _objSesion(C_TIPOTRAZA_PROP) = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener o establecer las diferentes TipoError disponibles.
    ''' </summary>
    ''' <value>Valor que indica el listado de TipoError.</value>
    ''' <returns>Objeto de tipo <c>TipoError</c> con el listado de TipoError.</returns>
    ''' <remarks></remarks>
    Public Property TipoErrorInfo() As TipoError
        Get
            Return CType(_objSesion(C_TIPOERROR_PROP), TipoError)
        End Get
        Set(ByVal value As TipoError)
            _objSesion(C_TIPOERROR_PROP) = value
        End Set
    End Property



#End Region
#End Region

#Region "Funciones publicas"
    Public Function Exists() As Boolean
        Return (_objSesion IsNot Nothing)
    End Function
#End Region
End Class

