﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa las diferentes TipoError del estado.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class TipoError
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsTipoError As DataSet
#End Region

#Region "CONSTRUCTOR"
    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()
        Me.Cargar()
    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return Globales.C_TABLA_TipoError
        End Get
    End Property
#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return Globales.ALIAS_ERROR_ID
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaDescripcion() As String
        Get
            Return Globales.ALIAS_ERROR_DESC
        End Get
    End Property
#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_ORDER
            strQuery = String.Format(strQuery, Globales.COL_ERROR_ID & " AS " & Globales.ALIAS_ERROR_ID & ", " & Globales.COL_ERROR_DESC & " AS " & Globales.ALIAS_ERROR_DESC, Me.NombreTabla, Globales.ALIAS_ERROR_DESC)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Dim dtRow As DataRow
                dtRow = data.Tables(0).NewRow()
                dtRow(Globales.ALIAS_ERROR_ID) = "-1"
                dtRow(Globales.ALIAS_ERROR_DESC) = "Elija"
                data.Tables(0).Rows.InsertAt(dtRow, 0)
                _dsTipoError = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New TipoErrorException(Globales.EX_TIPOERROR, ex)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener TipoError.
    ''' </summary>
    ''' <returns>DataSet con el listado de las TipoError.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetTipoError() As DataSet
        Return _dsTipoError
    End Function
#End Region
#End Region
End Class
