﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa los resultados.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class Resultados
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsDatos As DataSet
    Private _filtro As String = String.Empty
    Private _nombretablaope As String = String.Empty
    Private _idioma As String = Globales.C_IDIOMA_CASTELLANO

    Private Const _aliasTablaIndividuos As String = "IND"
    Private Const _aliasTablaCuestFam As String = "FAM"
    Private Const _aliasTablaCuestInd As String = "PER"


    Public Const IdentColumnNind As String = Globales.Constantes.COL_CONSULTAIND_NIND
    Public Const IdentColumnResfam As String = Globales.Constantes.COL_CONSULTAIND_RFAM
    Public Const IdentColumnResper As String = Globales.Constantes.COL_CONSULTAIND_RPER
    Public Const IdentColumnformfam As String = Globales.Constantes.COL_CONSULTAIND_FORMFAM
    Public Const IdentColumnformper As String = Globales.Constantes.COL_CONSULTAIND_FORMPER
    Public Const IdentColumnIndfam As String = Globales.Constantes.COL_CONSULTAIND_INDFAM
    Public Const IdentColumnInfper As String = Globales.Constantes.COL_CONSULTAIND_INFPER
#End Region

#Region "CONSTRUCTOR"
    Private _p1 As String

    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()

    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"

    Sub New(ByVal p1 As String, ByVal p2 As String, ByVal p3 As String, ByVal p4 As String) 
        _nombretablaope = p1
        _numc = p2
        _anio = p3
        _idioma = p4
    End Sub

    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos
        End Get
    End Property


    ''' <summary>
    ''' Obtener el nombre de la tabla de la operación
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public ReadOnly Property NombreTablasAux() As String
        Get
            Return Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST & " A," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST & " B," & _
            Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_LUGARNAC & "," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_NACIONALIDAD & "," & _
             _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " Z "
        End Get
    End Property
#End Region

#Region "PROPIAS"


    Private _operacion As String
    Public Property Operacion() As String
        Get
            Return _nombretablaope
        End Get
        Set(ByVal value As String)
            _nombretablaope = value
        End Set
    End Property

    Private _numc As String
    Public Property Numc() As String
        Get
            Return _numc
        End Get
        Set(ByVal value As String)
            _numc = value
        End Set
    End Property

    Private _anio As String
    Public Property Anio() As String
        Get
            Return _anio
        End Get
        Set(ByVal value As String)
            _anio = value
        End Set
    End Property

    Public ReadOnly Property ColumnaDescripcionNaci(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_NACIONALIDAD_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_NACIONALIDAD_LITEUS
            End If
            Return column
        End Get
    End Property

    Public ReadOnly Property ColumnaDescripcionLnac(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_LUGARNAC_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_LUGARNAC_LITEUS
            End If
            Return column
        End Get
    End Property

    Public ReadOnly Property ColumnaDescripcionRCuest(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_RESULTCUEST_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_RESULTCUEST_LITEUS
            End If
            Return column
        End Get
    End Property


    Public Property Idioma() As String
        Get
            Return _idioma
        End Get
        Set(ByVal value As String)
            _idioma = value
        End Set
    End Property

#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Function GetDatosIndividual() As DataSet
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INFPER & " AS " & Globales.ALIAS_CONSULTAIND_INFPER
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_SITA & " AS " & Globales.ALIAS_CONSULTAIND_SITA & "," & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NOM & " || ' ' || " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_APE2 & " || ' ' || '('||" & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_EDAD & "||')' AS " & Globales.ALIAS_CONSULTAIND_NOM
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_FORMPER & " AS " & Globales.ALIAS_CONSULTAIND_FORMPER
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NIND & " AS " & Globales.ALIAS_CONSULTAIND_NIND
            strSelect = strSelect & ", " & Globales.COL_CUESTFAM_IDIOMA & " AS " & Globales.ALIAS_CUESTFAM_IDIOMA
            strSelect = strSelect & ", " & Globales.COL_CONSULTAIND_RPER & " AS " & Globales.ALIAS_CONSULTAIND_RPER
            strSelect = strSelect & ", " & _aliasTablaCuestInd & "." & Globales.COL_CUESTIND_NUMC & " AS " & Globales.ALIAS_CUESTIND_NUMC
            strSelect = strSelect & ", " & _aliasTablaCuestInd & "." & Globales.COL_CUESTIONARIO_AGENTE

            strSelect = strSelect & ", CASE WHEN " & _aliasTablaCuestInd & "." & Globales.COL_CUESTIONARIO_COPIA & " IS NULL THEN 'N' ELSE 'S' END AS " & Globales.ALIAS_CUESTIONARIO_TIENE_COPIA

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC & " =  '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDPER & " = '" & Globales.VALOR_SI_IND & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaCuestInd & "." & Globales.COL_CUESTIND_NUMC & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC
            _filtroAux = _filtroAux & " AND " & _aliasTablaCuestInd & "." & Globales.COL_CUESTIND_AENC & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO
            _filtroAux = _filtroAux & " AND " & _aliasTablaCuestInd & "." & Globales.COL_CUESTIND_NIND & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NIND
            _filtroAux = _filtroAux & " AND " & Globales.COL_RESULTCUEST_ID & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_RPER

            Dim _tablas As String = _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos
            _tablas = _tablas & "," & _nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & " " & _aliasTablaCuestInd
            _tablas = _tablas & "," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)

            Return data
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function GetDatosRviv() As String
        Try
            Dim resul As String = ""
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = Globales.COL_CONSULTAVIV_RVIV
            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & Globales.COL_CONSULTAIND_NUMC & " =  '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio

            Dim _tablas As String = _nombretablaope & Globales.C_TABLA_VIVIENDA

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                If (data.Tables(0).Rows.Count > 0) Then
                    resul = data.Tables(0).Rows(0)(Globales.COL_CONSULTAVIV_RVIV).ToString()
                End If
            End If
            Return resul
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function GetInfoFamiliar() As DataSet
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = Globales.COL_CONSULTAIND_RFAM & " AS " & Globales.ALIAS_CONSULTAIND_RFAM & " , " & _
                Globales.COL_CONSULTAIND_FORMFAM & " AS " & Globales.ALIAS_CONSULTAIND_FORMFAM

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC & " =  '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio

            Dim _tablas As String = _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            Return data
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function GetDatosFamiliar() As DataSet
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDFAM & " AS " & Globales.ALIAS_CONSULTAIND_INDFAM
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_FORMFAM & " AS " & Globales.ALIAS_CONSULTAIND_FORMFAM
            strSelect = strSelect & ", CASE " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDFAM & " WHEN '" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "' THEN '" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "' ELSE " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NIND & " END AS " & Globales.ALIAS_CONSULTAIND_NIND
            strSelect = strSelect & ", " & Globales.COL_CUESTFAM_IDIOMA & " AS " & Globales.ALIAS_CUESTFAM_IDIOMA
            strSelect = strSelect & ", " & Globales.COL_CONSULTAIND_RFAM & " AS " & Globales.ALIAS_CONSULTAIND_RFAM
            strSelect = strSelect & ", " & _aliasTablaCuestFam & "." & Globales.COL_CUESTFAM_NUMC & " AS " & Globales.ALIAS_CUESTFAM_NUMC
            strSelect = strSelect & ", " & _aliasTablaCuestFam & "." & Globales.COL_CUESTIONARIO_AGENTE

            strSelect = strSelect & ", CASE WHEN " & _aliasTablaCuestFam & "." & Globales.COL_CUESTIONARIO_COPIA & " IS NULL THEN 'N' ELSE 'S' END AS " & Globales.ALIAS_CUESTIONARIO_TIENE_COPIA

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC & " =  '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaCuestFam & "." & Globales.COL_CUESTFAM_NUMC & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC
            _filtroAux = _filtroAux & " AND " & _aliasTablaCuestFam & "." & Globales.COL_CUESTFAM_AENC & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO
            _filtroAux = _filtroAux & " AND " & Globales.COL_RESULTCUEST_ID & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_RFAM

            Dim _tablas As String = _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos
            _tablas = _tablas & "," & _nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM & " " & _aliasTablaCuestFam
            _tablas = _tablas & "," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                If (Not (data.Tables(0).Rows.Count > 0)) Then
                    Dim stEstado As String = Globales.PENDIENTE
                    Dim stForma As String = String.Empty
                    Dim dtInfo As DataSet = GetInfoFamiliar()
                    If dtInfo IsNot Nothing AndAlso dtInfo.Tables.Count > 0 Then
                        If (dtInfo.Tables(0).Rows.Count > 0) Then
                            stEstado = dtInfo.Tables(0).Rows(0)(Globales.ALIAS_CONSULTAIND_RFAM).ToString()
                            stForma = dtInfo.Tables(0).Rows(0)(Globales.ALIAS_CONSULTAIND_FORMFAM).ToString()
                        End If
                    End If
                    Dim dtrow As DataRow = data.Tables(0).NewRow
                    dtrow(Globales.ALIAS_CONSULTAIND_NIND) = DBNull.Value
                    dtrow(Globales.ALIAS_CONSULTAIND_INDFAM) = Globales.VALOR_SI_IND
                    dtrow(Globales.ALIAS_CONSULTAIND_RFAM) = stEstado

                    dtrow(Globales.ALIAS_CONSULTAIND_FORMFAM) = IIf(Not String.IsNullOrEmpty(stForma), stForma, DBNull.Value)
                    data.Tables(0).Rows.Add(dtrow)
                End If
            End If
            Return data
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function InformanteFam() As String
        Try
            Dim result As Boolean = False
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = Globales.COL_CONSULTAIND_NIND

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC & " =  '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"


            Dim _tablas As String = _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                If (data.Tables(0).Rows.Count > 0) Then
                    result = data.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_NIND)
                End If
            End If
            Return result
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function InformanteFamMenor() As Boolean
        Try
            Dim result As Boolean = False
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = Globales.COL_CONSULTAIND_NIND

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC & " =  '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_EDAD & " <= 15"

            Dim _tablas As String = _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                If (data.Tables(0).Rows.Count > 0) Then
                    result = True
                End If
            End If
            Return result
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function InformanteFamBaja() As Boolean
        Try
            Dim result As Boolean = False
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = Globales.COL_CONSULTAIND_NIND

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC & " =  '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_SITA & " = " & Globales.INDIVIDUO_BAJA

            Dim _tablas As String = _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                If (data.Tables(0).Rows.Count > 0) Then
                    result = True
                End If
            End If
            Return result
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function InformanteFamIC() As Boolean
        Try
            Dim result As Boolean = False
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = Globales.COL_CONSULTAIND_NIND

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC & " =  '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDFAM & " = '" & IC.VALOR_PERSONA_CONFIANZA & "'"
            _filtroAux = _filtroAux & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_SITA & " = " & Globales.INDIVIDUO_BAJA

            Dim _tablas As String = _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                If (data.Tables(0).Rows.Count > 0) Then
                    result = True
                End If
            End If
            Return result
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_CARGA, ex.InnerException)
        End Try
    End Function

#End Region


#End Region

    Sub guardarDatosPer(ByVal dt As DataSet)
        Try
            Me.GuardarDataSet(dt)
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_ACTUALIZAR, ex.InnerException)
        End Try
    End Sub

    Function obtenerEstructuraBaseInd() As DataSet
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim strSelect As String = " * "

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & " " & Globales.COL_CONSULTAIND_NUMC & " =  '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _nombretablaope & Globales.C_TABLA_INDIVIDUOS, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                If (data.Tables(0).Rows.Count > 0) Then
                    Return data
                End If
            End If

            Return Nothing

        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_ACTUALIZAR, ex.InnerException)
        End Try
    End Function

    Sub ActualizarDatosFam(ByVal infor As String, ByVal resul As String, ByVal metodo As String)


        Try
            'guardamos los nuevos valores
            Dim sql1 As String = String.Format(Globales.UPDATE_GENERICO, Me.NombreTabla,
                                                          Globales.COL_CONSULTAIND_INDFAM & "=:" & Globales.COL_CONSULTAIND_INDFAM & "," & _
                                                          Globales.COL_CONSULTAIND_RFAM & "=:" & Globales.COL_CONSULTAIND_RFAM & "," & _
            Globales.COL_CONSULTAIND_FORMFAM & "=:" & Globales.COL_CONSULTAIND_FORMFAM, Globales.COL_CONSULTAIND_NUMC & "=:" & Globales.COL_CONSULTAIND_NUMC & " AND " &
                                                          Globales.COL_CONSULTAIND_ANIO & "=:" & Globales.COL_CONSULTAIND_ANIO)
            Dim cmd1(4) As OracleParameter

            cmd1(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, Me.Numc)
            cmd1(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.VarChar, Me.Anio)
            If infor.Equals(IC.VALOR_PERSONA_CONFIANZA) Then
                cmd1(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_INDFAM, OracleType.VarChar, IC.VALOR_PERSONA_CONFIANZA)
            Else
                cmd1(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_INDFAM, OracleType.VarChar, Globales.VALOR_NO_IND)
            End If
            cmd1(3) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_RFAM, OracleType.VarChar, resul)
            cmd1(4) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_FORMFAM, OracleType.VarChar, metodo)
            Me.EjecutarNoSQL(sql1, CommandType.Text, cmd1)

            'borramos el antiguo informante si lo hubiera

            If Not infor.Equals(IC.VALOR_PERSONA_CONFIANZA) Then
                Dim sql2 As String = String.Format(Globales.UPDATE_GENERICO, Me.NombreTabla,
                                                              Globales.COL_CONSULTAIND_INDFAM & "=:" & Globales.COL_CONSULTAIND_INDFAM & "",
                                                              Globales.COL_CONSULTAIND_NIND & "=:" & Globales.COL_CONSULTAIND_NIND & " AND " &
                                                              Globales.COL_CONSULTAIND_NUMC & "=:" & Globales.COL_CONSULTAIND_NUMC & " AND " &
                                                              Globales.COL_CONSULTAIND_ANIO & "=:" & Globales.COL_CONSULTAIND_ANIO)
                Dim cmd2(4) As OracleParameter

                cmd2(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.Number, Me.Numc)
                cmd2(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.Number, Me.Anio)
                cmd2(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_INDFAM, OracleType.VarChar, Globales.VALOR_SI_IND)
                cmd2(3) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NIND, OracleType.VarChar, infor)
                Me.EjecutarNoSQL(sql2, CommandType.Text, cmd2)
            End If
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_ACTUALIZAR, ex.InnerException)
        End Try

    End Sub

    

    Sub ActualizarDatosRviv(ByVal result As String, ByVal situac As String)
        Try
            'guardamos los nuevos valores
            Dim sql1 As String = String.Format(Globales.UPDATE_GENERICO, _nombretablaope & Globales.C_TABLA_VIVIENDA,
                                                          Globales.COL_CONSULTAVIV_RVIV & "=:" & Globales.COL_CONSULTAVIV_RVIV & "," &
                                                          Globales.COL_CONSULTAVIV_SIT & "=:" & Globales.COL_CONSULTAVIV_SIT,
                                                          Globales.COL_CONSULTAIND_NUMC & "=:" & Globales.COL_CONSULTAIND_NUMC & " AND " &
                                                          Globales.COL_CONSULTAIND_ANIO & "=:" & Globales.COL_CONSULTAIND_ANIO)
            Dim cmd1(4) As OracleParameter

            cmd1(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, Me.Numc)
            cmd1(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.VarChar, Me.Anio)
            cmd1(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_RVIV, OracleType.VarChar, result)
            cmd1(3) = Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_SIT, OracleType.VarChar, situac)
            Me.EjecutarNoSQL(sql1, CommandType.Text, cmd1)

        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_ACTUALIZAR, ex.InnerException)
        End Try
    End Sub

    Sub ActualizarDatosResultViv(ByVal result As String)
        Try
            'guardamos los nuevos valores
            Dim sql1 As String = String.Format(Globales.UPDATE_GENERICO, _nombretablaope & Globales.C_TABLA_VIVIENDA,
                                                          Globales.COL_CONSULTAVIV_RVIV & "=:" & Globales.COL_CONSULTAVIV_RVIV,
                                                          Globales.COL_CONSULTAIND_NUMC & "=:" & Globales.COL_CONSULTAIND_NUMC & " AND " &
                                                          Globales.COL_CONSULTAIND_ANIO & "=:" & Globales.COL_CONSULTAIND_ANIO)
            Dim cmd1(3) As OracleParameter

            cmd1(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, Me.Numc)
            cmd1(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.VarChar, Me.Anio)
            cmd1(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_RVIV, OracleType.VarChar, result)
            Me.EjecutarNoSQL(sql1, CommandType.Text, cmd1)

        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_ACTUALIZAR, ex.InnerException)
        End Try
    End Sub

    Public Sub ActualizarIdiomaFam(ByVal idioma As String)
        Dim bTransCreada As Boolean = False
        Try
            Dim sql As String
            Dim cmd(2) As OracleParameter

            If Me.Transaccion Is Nothing Then
                Me.CrearTransaccion()
                bTransCreada = True
            End If

            Me.AsignarTransaccion(Me)
            'Asignar método cumplimentación Web
            sql = String.Format(Globales.UPDATE_GENERICO, _nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM,
                                Globales.COL_CUESTIONARIO_IDIOMA & "=:" & Globales.COL_CUESTIONARIO_IDIOMA,
                                Globales.COL_CUESTFAM_NUMC & "=:" & Globales.COL_CUESTFAM_NUMC & " AND " &
                                Globales.COL_CUESTFAM_AENC & "=:" & Globales.COL_CUESTFAM_AENC)
            cmd(0) = Me.CrearParametroOracle(Globales.COL_CUESTFAM_NUMC, OracleType.VarChar, Me.Numc)
            cmd(1) = Me.CrearParametroOracle(Globales.COL_CUESTFAM_AENC, OracleType.VarChar, Me.Anio)
            cmd(2) = Me.CrearParametroOracle(Globales.COL_CUESTIONARIO_IDIOMA, OracleType.VarChar, idioma)
            Me.EjecutarNoSQL(sql, CommandType.Text, cmd)

            Me.CerrarTransaccion()
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_ACTUALIZAR, ex.InnerException)
        Finally
            If bTransCreada Then
                Me.CancelarTransaccion()
            End If
        End Try
    End Sub

    Public Sub ActualizarIdiomaInd(ByVal nind As String, ByVal idioma As String)
        Dim bTransCreada As Boolean = False
        Try
            Dim sql As String
            Dim cmd(3) As OracleParameter

            If Me.Transaccion Is Nothing Then
                Me.CrearTransaccion()
                bTransCreada = True
            End If

            Me.AsignarTransaccion(Me)
            'Asignar método cumplimentación Web
            sql = String.Format(Globales.UPDATE_GENERICO, _nombretablaope & Globales.C_TABLA_CUESTIONARIOIND,
                                Globales.COL_CUESTIONARIO_IDIOMA & "=:" & Globales.COL_CUESTIONARIO_IDIOMA,
                                Globales.COL_CUESTIND_NUMC & "=:" & Globales.COL_CUESTIND_NUMC & " AND " &
                                Globales.COL_CUESTIND_AENC & "=:" & Globales.COL_CUESTIND_AENC & " AND " &
                                Globales.COL_CUESTIND_NIND & "=:" & Globales.COL_CUESTIND_NIND)
            cmd(0) = Me.CrearParametroOracle(Globales.COL_CUESTIND_NUMC, OracleType.VarChar, Me.Numc)
            cmd(1) = Me.CrearParametroOracle(Globales.COL_CUESTIND_AENC, OracleType.VarChar, Me.Anio)
            cmd(2) = Me.CrearParametroOracle(Globales.COL_CUESTIND_NIND, OracleType.VarChar, nind)
            cmd(3) = Me.CrearParametroOracle(Globales.COL_CUESTIONARIO_IDIOMA, OracleType.VarChar, idioma)
            Me.EjecutarNoSQL(sql, CommandType.Text, cmd)

            Me.CerrarTransaccion()
        Catch ex As Exception
            Throw New ResultException(Globales.EX_RESULT_ACTUALIZAR, ex.InnerException)
        Finally
            If bTransCreada Then
                Me.CancelarTransaccion()
            End If
        End Try
    End Sub

End Class
