﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase para acceder a los datos de los listados Excel.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class Listados
    Inherits EntidadBase

#Region "VARIABLES"
    'Private _dsDatos As DataSet
    Private _nombretablaope As String = String.Empty

    Private Const _aliasTablaVivienda As String = "VIV"
    Private Const _aliasTablaIndividuos As String = "IND"

    Public Const _totalCuestionarios As String = "TOTALCUESTIONARIOS"

#End Region


#Region "CONSTRUCTOR"
    Private _p1 As String
#End Region


#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    Sub New(ByVal p1 As String)
        _nombretablaope = p1
    End Sub
#End Region

#Region "PROPIAS"

    Private _anio As String
    Public Property Anio() As String
        Get
            Return _anio
        End Get
        Set(ByVal value As String)
            _anio = value
        End Set
    End Property

    Private _trim As String
    Public Property Trim() As String
        Get
            Return _trim
        End Get
        Set(ByVal value As String)
            _trim = value
        End Set
    End Property
     
    Public Property Operacion() As String
        Get
            Return _nombretablaope
        End Get
        Set(ByVal value As String)
            _nombretablaope = value
        End Set
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre de Incidencias.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaDescripcionIncidencias(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_RESULTCUEST_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_RESULTCUEST_LITEUS
            End If
            Return column
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo Id de Incidencias.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaIdIncidencias() As String
        Get
            Return Globales.COL_RESULTCUEST_ID
        End Get
    End Property

#End Region
#End Region

#Region "METODOS"
#Region "PROPIOS"

    Public Function CargarDatosListado1(ByVal tieneSemanas As Boolean) As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = Globales.COL_CONSULTAVIV_NUMC & ", " & Globales.COL_CONSULTAVIV_TH & ", " & Globales.COL_CONSULTAVIV_SIT

            If tieneSemanas Then
                strSelect &= ", " & Globales.COL_CONSULTAVIV_SEM
            Else
                strSelect &= ", 1 AS " & Globales.COL_CONSULTAVIV_SEM
            End If

            _filtro = _filtro & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IS NOT NULL"
            If tieneSemanas Then
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SEM & " BETWEEN 1 AND 13"
            End If
            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function CargarIncidencias() As DataTable
        Try


            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_FILTRO

            Dim strSelect As String = Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST & "." & Globales.COL_RESULTCUEST_ID & ", " & Globales.COL_RESULTCUEST_LITCAS & ", " & Globales.COL_RESULTCUEST_LITEUS
            Dim strFrom As String = Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST & ", " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST_OPE
            Dim cmd(0) As OracleParameter
            Dim strWhere As String = Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST & "." & Globales.COL_RESULTCUEST_ID & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST_OPE & "." & Globales.COL_RESULTCUESTOPE_CODRCUEST & "(+) AND NVL(" & Globales.COL_RESULTCUESTOPE_CODOPE & ",:" & Globales.COL_RESULTCUESTOPE_CODOPE & ") = :" & Globales.COL_RESULTCUESTOPE_CODOPE _
             & " AND " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST & "." & Globales.COL_RESULTCUEST_ID & " <> '" & Globales.COMPLETO & "'"
            cmd(0) = Me.CrearParametroOracle(Globales.COL_RESULTCUESTOPE_CODOPE, OracleType.VarChar, Operacion)

            strQuery = String.Format(strQuery, strSelect, strFrom, strWhere)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, cmd)
           
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_INCIDENCIAS_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function CargarDatosFormaListado2(ByVal tieneSemanas As Boolean) As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NIND & ", " & Globales.COL_CONSULTAVIV_TH & ", nvl(" & Globales.COL_CONSULTAIND_FORMPER & ",-1) as " & Globales.COL_CONSULTAIND_FORMPER

            If tieneSemanas Then
                strSelect &= ", " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_SEM
            Else
                strSelect &= ", 1 AS " & Globales.COL_CONSULTAVIV_SEM
            End If

            _filtro = _filtro & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If
            _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_TRIM
            End If
            _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RPER & " = '" & Globales.COMPLETO & "'"
            If tieneSemanas Then
                _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_SEM & " BETWEEN 1 AND 13"
            End If


            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " " & _aliasTablaVivienda & ", " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function CargarDatosIncidenciasListado2(ByVal tieneSemanas As Boolean) As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NIND & ", " & _
                Globales.COL_CONSULTAVIV_TH & ", " & Globales.COL_CONSULTAIND_RPER & ", " & Globales.COL_CONSULTAIND_INDPER

            If tieneSemanas Then
                strSelect &= ", " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_SEM
            Else
                strSelect &= ", 1 AS " & Globales.COL_CONSULTAVIV_SEM
            End If

            _filtro = _filtro & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If
            _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_TRIM
            End If
            _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC
            If tieneSemanas Then
                _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_SEM & " BETWEEN 1 AND 13"
            End If
            _filtro = _filtro & " AND (" & Globales.COL_CONSULTAIND_RPER & " <> '" & Globales.COMPLETO & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & " = '" & Globales.VALOR_SI_IND & "'))"

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " " & _aliasTablaVivienda & ", " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function CargarComarcas() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _order As String = String.Empty

            Dim strSelect As String = Globales.COL_COM_PROV & ", " & Globales.COL_COM_COMR & ", " & Globales.COL_COM_NOMBRE

            _order = Globales.COL_COM_PROV & ", " & Globales.COL_COM_COMR

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_ORDER
            strQuery = String.Format(strQuery, strSelect, Globales.C_TABLA_COMARCAS, _order)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_COMARCAS_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function CargarDatosListado3() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty
            Dim _order As String = String.Empty

            Dim strSelect As String = Globales.COL_CONSULTAVIV_NUMC & ", " & Globales.COL_CONSULTAVIV_SIT & ", " & Globales.COL_COM_PROV & ", " & Globales.COL_COM_COMR & _
            ", " & Globales.COL_CONSULTAVIV_MUN

            _filtro = _filtro & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IS NOT NULL" 
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_MUN & " = " & Globales.COL_MUN_ID
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_TH & " = " & Globales.COL_MUN_PROVID
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_TH & " = " & Globales.COL_com_prov
            _filtro = _filtro & " AND " & Globales.COL_MUN_COMR & " = " & Globales.COL_COM_COMR

            _order = Globales.COL_COM_PROV & ", " & Globales.COL_COM_COMR

            ''hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO_ORDER
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & ", " & Globales.C_TABLA_MUNICIPIOS & ", " & Globales.C_TABLA_COMARCAS, _filtro, _order)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function ObtenerEncuestadores(ByVal op As String) As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = " " & "USU." & Globales.COL_USUARIOS_NUMC
            strSelect = strSelect & "," & Globales.COL_USUARIOS_NOM & " || ' ' || " & Globales.COL_USUARIOS_APE1 & " || ' ' || " & Globales.COL_USUARIOS_APE2 & " AS " & Globales.ALIAS_USUARIOS_NOMBRE

            Dim _filtroAux As String = String.Empty

            If Not String.IsNullOrEmpty(op) Then
                _filtroAux = _filtroAux & Globales.COL_USUARIOS_OPE & " = '" & op & "'"
            End If
            'Encuestadores activos
            _filtroAux = _filtroAux & " AND " & Globales.COL_USUARIOS_ACTIVO & " = '" & Globales.USUARIO_ACTIVO & "'"
            _filtroAux = _filtroAux & " AND " & Globales.COL_USUARIOS_PERFIL & " = " & Globales.PERFIL_ENCUESTADOR & ""

            _filtroAux = _filtroAux & " AND " & "USU." & Globales.COL_USUARIOS_CODUSU & " = " & "REL." & Globales.COL_USUARIOS_CODUSU

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & " USU," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE & " REL", _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ControlUsuariosException(Globales.EX_CONTROLUSU_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function CargarDatosFamiliaresCompletas() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAIND_NUMC & ", " & Globales.COL_CUESTIONARIO_AGENTE & ", " & _
                  Globales.COL_CONSULTAIND_NIND
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                strSelect &= " , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAIND_TRIM
            End If

            _filtro = _filtro & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_ANIO
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_TRIM
            End If
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RFAM & " = '" & Globales.COMPLETO & "'"
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
            _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_AGENTE & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_NUMC
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_OPE & " = '" & Me.Operacion & "'"
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_PERFIL & " = " & Globales.PERFIL_ENCUESTADOR & ""
            _filtro = _filtro & " AND " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_CODUSU & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE & "." & Globales.COL_USUARIOS_CODUSU

            ''hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & ", " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & ", " & _
                                     Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & ", " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function



    Public Function CargarDatosFamiliaresIncidencias() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAIND_NUMC & ", " & Globales.COL_CUESTIONARIO_AGENTE & ", " & _
                 Globales.COL_CONSULTAIND_NIND

            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                strSelect &= " , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAIND_TRIM
            End If

            _filtro = _filtro & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_ANIO
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_TRIM
            End If
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RFAM & " <> '" & Globales.COMPLETO & "'"
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RFAM & " IS NOT NULL"
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
            _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_AGENTE & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_NUMC
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_OPE & " = '" & Me.Operacion & "'"
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_PERFIL & " = " & Globales.PERFIL_ENCUESTADOR & ""
            _filtro = _filtro & " AND " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_CODUSU & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE & "." & Globales.COL_USUARIOS_CODUSU

            ''hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & ", " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & ", " & _
                                     Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & ", " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function CargarDatosIndividualesCompletas() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_NUMC & ", " & Globales.COL_CUESTIONARIO_AGENTE & ", " & _
                 Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_NIND

            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                strSelect &= " , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_TRIM
            End If

            _filtro = _filtro & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_ANIO
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_TRIM
            End If
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_NIND & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_NIND
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RPER & " = '" & Globales.COMPLETO & "'"
            _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_AGENTE & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_NUMC
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_OPE & " = '" & Me.Operacion & "'"
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_PERFIL & " = " & Globales.PERFIL_ENCUESTADOR & ""
            _filtro = _filtro & " AND " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_CODUSU & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE & "." & Globales.COL_USUARIOS_CODUSU

            ''hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & ", " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & ", " & _
                                     Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & ", " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function CargarDatosIndividualesIncidencias() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_NUMC & ", " & Globales.COL_CUESTIONARIO_AGENTE & ", " & _
                 Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_NIND

            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                strSelect &= " , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_TRIM
            End If

            _filtro = _filtro & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim

            End If
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_ANIO
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_TRIM
            End If
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_NIND & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_NIND
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RPER & " <> '" & Globales.COMPLETO & "'"
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RPER & " IS NOT NULL"
            _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_AGENTE & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_NUMC
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_OPE & " = '" & Me.Operacion & "'"
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_PERFIL & " = " & Globales.PERFIL_ENCUESTADOR & ""
            _filtro = _filtro & " AND " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_CODUSU & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE & "." & Globales.COL_USUARIOS_CODUSU

            ''hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & ", " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & ", " & _
                                     Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & ", " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function CargarDatosListado1Lote(ByVal codusu As String) As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            _filtro = _filtro & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If (Not (String.IsNullOrEmpty(Me.Trim))) Then
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IS NOT NULL"

            'Si existe lote y el usuario sólo tiene acceso a determinados lotes debo solo mostrar la información de dichos lotes
            Dim LoteLN As Lote = New Lote(Me.Operacion, codusu)
            Dim dtLotes As DataSet = LoteLN.GetDsLote()
            If dtLotes IsNot Nothing AndAlso dtLotes.Tables.Count > 0 Then
                Dim strAuxLotes As String = String.Empty
                For Each row In dtLotes.Tables(0).Rows
                    If (Not (String.IsNullOrEmpty(strAuxLotes))) Then
                        strAuxLotes &= ",'" & row(LoteLN.ColumnaDescripcion).ToString() & "'"
                    Else
                        strAuxLotes &= "'" & row(LoteLN.ColumnaDescripcion).ToString() & "'"
                    End If
                Next
                If Not (String.IsNullOrEmpty(_filtro)) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & Globales.COL_CONSULTAVIV_LOTE & " IN (" & strAuxLotes & ")"
            End If


            Dim strSelect As String = Globales.COL_CONSULTAVIV_NUMC & ", " & Globales.COL_CONSULTAVIV_TH & ", " & Globales.COL_CONSULTAVIV_SIT
            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA, _filtro)


            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function




    Public Function CargarExcelVisualizar() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = Globales.COL_CONSULTAEXCEL_CODOPE & ", " & Globales.COL_CONSULTAEXCEL_NOMEXC

            _filtro = _filtro & Globales.COL_CONSULTAEXCEL_CODOPE & " = '" & Me._nombretablaope & "'"

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_EXCELOPE, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If
        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function



#Region "LISTADOS DURACIÓN"

    '*****************************************************************************************************************
    'Listados Duración

#Region "AGENTE"

    Public Function CargarSumaDuracionColectivoAgenteCastellanoFinalizadas(hasColectivo As Boolean, hasCuestionarioFamiliar As Boolean) As DataTable
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            If hasColectivo Then

                'hay que buscar el idioma
                If hasCuestionarioFamiliar Then

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION_AG & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                             & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                Else

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION_AG & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "i." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "i." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "i." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAINICIO & " = ("

                    'Si no tiene cuestionario familiar, del individual que tenga la fecha más baja
                    Dim _filtro2 As String = String.Empty
                    Dim strQuery2 As String = Globales.C_SELECT_FILTRO

                    Dim strSelect2 As String = "MIN(" & Globales.COL_CUESTIONARIO_FECHAINICIO & ")"

                    _filtro2 = _filtro2 & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_NUMC & " = i." & Globales.COL_CUESTIONARIO_NUMC & ")"

                    strQuery2 = String.Format(strQuery2, strSelect2, Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND, _filtro2)

                    'hay que aplicar filtro
                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro & strQuery2
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                End If

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If

        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarSumaDuracionFamiliarAgenteCastellanoFinalizadas(hasCuestionarioFamiliar As Boolean) As DataTable
        Try
            If hasCuestionarioFamiliar Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(f." & Globales.COL_CONSULTAVIV_DURACION_AG & "),0)"

                _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND f." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & " IS NOT NULL "
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                strQuery = Globales.C_SELECT_FILTRO
                _filtro = _filtro
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                         & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarSumaDuracionPersonalAgenteCastellanoFinalizadas(hasCuestionarioIndividual As Boolean) As DataTable
        Try
            If hasCuestionarioIndividual Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(i." & Globales.COL_CUESTIONARIO_DURACION_AG & "),0)"

                _filtro = _filtro & " i." & Globales.COL_CUESTIND_AENC & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_DURACION_AG & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_FECHAFIN_AG & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'"
                _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If

                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c, " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarDatosDuracionColectivoAgenteFinalizadas(hasColectivo As Boolean, hasCuestionarioFamiliar As Boolean) As DataTable
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            If hasColectivo Then

                'hay que buscar el idioma
                If hasCuestionarioFamiliar Then

                    Dim strSelect As String = "c." & Globales.COL_CONSULTAVIV_DURACION_AG & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                             & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                Else

                    Dim strSelect As String = "c." & Globales.COL_CONSULTAVIV_DURACION_AG & ", i." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "i." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "i." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "i." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAINICIO & " = ("

                    'Si no tiene cuestionario familiar, del individual que tenga la fecha más baja
                    Dim _filtro2 As String = String.Empty
                    Dim strQuery2 As String = Globales.C_SELECT_FILTRO

                    Dim strSelect2 As String = "MIN(" & Globales.COL_CUESTIONARIO_FECHAINICIO & ")"

                    _filtro2 = _filtro2 & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_NUMC & " = i." & Globales.COL_CUESTIONARIO_NUMC & ")"

                    strQuery2 = String.Format(strQuery2, strSelect2, Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND, _filtro2)

                    'hay que aplicar filtro
                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro & strQuery2
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                End If

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If


            Else
                Return Nothing
            End If

        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarDatosDuracionFamiliarAgenteFinalizadas(hasCuestionarioFamiliar As Boolean) As DataTable
        Try
            If hasCuestionarioFamiliar Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "f." & Globales.COL_CONSULTAVIV_DURACION_AG & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM

                _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND f." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & " IS NOT NULL "
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                strQuery = Globales.C_SELECT_FILTRO
                _filtro = _filtro
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                         & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarDatosDuracionPersonalAgenteFinalizadas(hasCuestionarioIndividual As Boolean) As DataTable
        Try
            If hasCuestionarioIndividual Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "i." & Globales.COL_CUESTIONARIO_DURACION_AG & ", " & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER

                _filtro = _filtro & " i." & Globales.COL_CUESTIND_AENC & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_DURACION_AG & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_FECHAFIN_AG & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If

                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If
                'MyBase.Cargar()
            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function




    Public Function CargarSumaDuracionColectivoAgenteFinalizadas(hasColectivo As Boolean, hasCuestionarioFamiliar As Boolean) As DataTable
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            If hasColectivo Then

                'hay que buscar el idioma
                If hasCuestionarioFamiliar Then

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION_AG & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                             & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                Else

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION_AG & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "i." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "i." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "i." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAINICIO & " = ("

                    'Si no tiene cuestionario familiar, del individual que tenga la fecha más baja
                    Dim _filtro2 As String = String.Empty
                    Dim strQuery2 As String = Globales.C_SELECT_FILTRO

                    Dim strSelect2 As String = "MIN(" & Globales.COL_CUESTIONARIO_FECHAINICIO & ")"

                    _filtro2 = _filtro2 & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_NUMC & " = i." & Globales.COL_CUESTIONARIO_NUMC & ")"

                    strQuery2 = String.Format(strQuery2, strSelect2, Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND, _filtro2)

                    'hay que aplicar filtro
                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro & strQuery2
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                End If

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If


            Else
                Return Nothing
            End If

        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarSumaDuracionFamiliarAgenteFinalizadas(hasCuestionarioFamiliar As Boolean) As DataTable
        Try
            If hasCuestionarioFamiliar Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(f." & Globales.COL_CONSULTAVIV_DURACION_AG & "),0)"

                _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND f." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & " IS NOT NULL "
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                strQuery = Globales.C_SELECT_FILTRO
                _filtro = _filtro
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                         & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarSumaDuracionPersonalAgenteFinalizadas(hasCuestionarioIndividual As Boolean) As DataTable
        Try
            If hasCuestionarioIndividual Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(i." & Globales.COL_CUESTIONARIO_DURACION_AG & "),0)"

                _filtro = _filtro & " i." & Globales.COL_CUESTIND_AENC & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_DURACION_AG & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_FECHAFIN_AG & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If

                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function



    Public Function CargarSumaDuracionColectivoAgenteEuskeraFinalizadas(hasColectivo As Boolean, hasCuestionarioFamiliar As Boolean) As DataTable
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            If hasColectivo Then

                'hay que buscar el idioma
                If hasCuestionarioFamiliar Then

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION_AG & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                             & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                Else

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION_AG & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "i." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "i." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "i." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAINICIO & " = ("

                    'Si no tiene cuestionario familiar, del individual que tenga la fecha más baja
                    Dim _filtro2 As String = String.Empty
                    Dim strQuery2 As String = Globales.C_SELECT_FILTRO

                    Dim strSelect2 As String = "MIN(" & Globales.COL_CUESTIONARIO_FECHAINICIO & ")"

                    _filtro2 = _filtro2 & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_NUMC & " = i." & Globales.COL_CUESTIONARIO_NUMC & ")"

                    strQuery2 = String.Format(strQuery2, strSelect2, Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND, _filtro2)

                    'hay que aplicar filtro
                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro & strQuery2
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                End If

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If


            Else
                Return Nothing
            End If

        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarSumaDuracionFamiliarAgenteEuskeraFinalizadas(hasCuestionarioFamiliar As Boolean) As DataTable
        Try
            If hasCuestionarioFamiliar Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(f." & Globales.COL_CONSULTAVIV_DURACION_AG & "),0)"

                _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND f." & Globales.COL_CONSULTAVIV_DURACION_AG & " IS NOT NULL "
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & " IS NOT NULL "
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                strQuery = Globales.C_SELECT_FILTRO
                _filtro = _filtro
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                         & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarSumaDuracionPersonalAgenteEuskeraFinalizadas(hasCuestionarioIndividual As Boolean) As DataTable
        Try
            If hasCuestionarioIndividual Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(i." & Globales.COL_CUESTIONARIO_DURACION_AG & "),0)"

                _filtro = _filtro & " i." & Globales.COL_CUESTIND_AENC & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_DURACION_AG & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_FECHAFIN_AG & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If

                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function




    Public Function CargarDatosDuracionAgenteIdiomaFinalizadas(hasColectivo As Boolean, hasCuestionarioFamiliar As Boolean, hasCuestionarioIndividual As Boolean, idioma As String) As DataTable
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty
            Dim strSelect As String = String.Empty



            'hay que buscar el idioma
            If hasCuestionarioFamiliar Then

                    strSelect = "c." & Globales.COL_CONSULTAVIV_DURACION_AG & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If

                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                    If idioma <> String.Empty Then
                        _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & idioma & "'"
                    End If


                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                             & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                Else

                    strSelect = "c." & Globales.COL_CONSULTAVIV_DURACION_AG & ", i." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If

                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "i." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "i." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "i." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                    If idioma <> String.Empty Then
                        _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & idioma & "'"
                    End If



                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAINICIO & " = ("

                    'Si no tiene cuestionario familiar, del individual que tenga la fecha más baja
                    Dim _filtro2 As String = String.Empty
                    Dim strQuery2 As String = Globales.C_SELECT_FILTRO

                    Dim strSelect2 As String = "MIN(" & Globales.COL_CUESTIONARIO_FECHAINICIO & ")"

                    _filtro2 = _filtro2 & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_NUMC & " = i." & Globales.COL_CUESTIONARIO_NUMC & ")"

                    strQuery2 = String.Format(strQuery2, strSelect2, Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND, _filtro2)

                    _filtro = _filtro & strQuery2

                End If


                If hasCuestionarioFamiliar Then

                    If strSelect = String.Empty Then
                        strSelect = "f." & Globales.COL_CONSULTAVIV_DURACION_AG & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM
                    Else
                        strSelect = strSelect & ", f." & Globales.COL_CONSULTAVIV_DURACION_AG & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM
                    End If

                    If _filtro <> String.Empty Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If

                    _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                    If idioma <> String.Empty Then
                        _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & idioma & "'"
                    End If

                End If

                If hasCuestionarioIndividual Then

                    If strSelect = String.Empty Then
                        strSelect = "i." & Globales.COL_CUESTIONARIO_DURACION_AG & ", " & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER
                    Else
                        strSelect = strSelect & ",i." & Globales.COL_CUESTIONARIO_DURACION_AG & ", i." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER
                    End If

                    If _filtro <> String.Empty Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & " i." & Globales.COL_CUESTIND_AENC & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & " IS NOT NULL "
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " IN (" & Globales.FORM_VISITA & ", " & Globales.FORM_TELEFONICA & ")"
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    If idioma <> String.Empty Then
                        _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & idioma & "'"
                    End If

                End If

                If hasColectivo Then
                    If hasCuestionarioFamiliar And hasCuestionarioIndividual Then
                        strSelect = strSelect & ", (nvl(c." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & "+" & "nvl(f." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & "+" & "nvl(i." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & ") as " & _totalCuestionarios
                    ElseIf hasCuestionarioFamiliar Then
                        strSelect = strSelect & " (nvl)c." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & "+" & "nvl(f." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & ")  as " & _totalCuestionarios
                    ElseIf hasCuestionarioIndividual Then
                        strSelect = strSelect & ", (nvl(c." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & "+" & "nvl(i." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & ")  as " & _totalCuestionarios
                    Else
                        strSelect = strSelect & ", (nvl(c." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & ") as totalCuestionarios"
                    End If
                Else
                    If hasCuestionarioFamiliar And hasCuestionarioIndividual Then
                        strSelect = strSelect & ", (nvl(f." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & "+" & "nvl(i." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & ")  as " & _totalCuestionarios
                    ElseIf hasCuestionarioFamiliar Then
                        strSelect = strSelect & ", (nvl(f." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & ")  as " & _totalCuestionarios
                    ElseIf hasCuestionarioIndividual Then
                        strSelect = strSelect & ", (nvl(i." & Globales.COL_CONSULTAVIV_DURACION_AG & ",0)" & ")  as " & _totalCuestionarios
                    End If
                End If

                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO
                Dim strWhere As String = Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o"
                If hasCuestionarioFamiliar Then
                    strWhere = strWhere & ", " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM & " f"
                End If
                strQuery = String.Format(strQuery, strSelect, strWhere, _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If
            
        Catch ex As Exception
            Return Nothing
        End Try
    End Function



#End Region


#Region "ENCUESTADO"


    Public Function CargarSumaDuracionFamiliarEncuestadoEuskeraFinalizadas(hasCuestionarioFamiliar As Boolean) As DataTable
        Try
            If hasCuestionarioFamiliar Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(f." & Globales.COL_CONSULTAVIV_DURACION & "),0)"

                _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND f." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                strQuery = Globales.C_SELECT_FILTRO
                _filtro = _filtro
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                         & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function

    Public Function CargarDatosDuracionColectivoEncuestadoFinalizadas(hasColectivo As Boolean, hasCuestionarioFamiliar As Boolean) As DataTable
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            If hasColectivo Then

                'hay que buscar el idioma
                If hasCuestionarioFamiliar Then

                    Dim strSelect As String = "c." & Globales.COL_CONSULTAVIV_DURACION & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                             & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                Else

                    Dim strSelect As String = "c." & Globales.COL_CONSULTAVIV_DURACION & ", i." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "i." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "i." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "i." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAINICIO & " = ("

                    'Si no tiene cuestionario familiar, del individual que tenga la fecha más baja
                    Dim _filtro2 As String = String.Empty
                    Dim strQuery2 As String = Globales.C_SELECT_FILTRO

                    Dim strSelect2 As String = "MIN(" & Globales.COL_CUESTIONARIO_FECHAINICIO & ")"

                    _filtro2 = _filtro2 & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_NUMC & " = i." & Globales.COL_CUESTIONARIO_NUMC & ")"

                    strQuery2 = String.Format(strQuery2, strSelect2, Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND, _filtro2)

                    'hay que aplicar filtro
                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro & strQuery2
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                End If

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If

        Catch ex As Exception
            Return Nothing
        End Try
    End Function



    Public Function CargarDatosDuracionFamiliarEncuestadoFinalizadas(hasCuestionarioFamiliar As Boolean) As DataTable
        Try
            If hasCuestionarioFamiliar Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "f." & Globales.COL_CONSULTAVIV_DURACION & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM

                _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND f." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                strQuery = Globales.C_SELECT_FILTRO
                _filtro = _filtro
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                         & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function



    Public Function CargarDatosDuracionPersonalEncuestadoFinalizadas(hasCuestionarioIndividual As Boolean) As DataTable
        Try
            If hasCuestionarioIndividual Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = " i." & Globales.COL_CUESTIONARIO_DURACION & ", " & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER

                _filtro = _filtro & " i." & Globales.COL_CUESTIND_AENC & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_DURACION & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If

                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function



    Public Function CargarSumaDuracionColectivoEncuestadoCastellanoFinalizadas(hasColectivo As Boolean, hasCuestionarioFamiliar As Boolean) As DataTable
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            If hasColectivo Then

                'hay que buscar el idioma
                If hasCuestionarioFamiliar Then

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                             & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                Else

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "i." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "i." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "i." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAINICIO & " = ("

                    'Si no tiene cuestionario familiar, del individual que tenga la fecha más baja
                    Dim _filtro2 As String = String.Empty
                    Dim strQuery2 As String = Globales.C_SELECT_FILTRO

                    Dim strSelect2 As String = "MIN(" & Globales.COL_CUESTIONARIO_FECHAINICIO & ")"

                    _filtro2 = _filtro2 & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_NUMC & " = i." & Globales.COL_CUESTIONARIO_NUMC & ")"

                    strQuery2 = String.Format(strQuery2, strSelect2, Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND, _filtro2)

                    'hay que aplicar filtro
                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro & strQuery2
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                End If

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If

        Catch ex As Exception
            Return Nothing
        End Try
    End Function



    Public Function CargarSumaDuracionFamiliarEncuestadoCastellanoFinalizadas(hasCuestionarioFamiliar As Boolean) As DataTable
        Try
            If hasCuestionarioFamiliar Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(f." & Globales.COL_CONSULTAVIV_DURACION & "),0)"

                _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND f." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                strQuery = Globales.C_SELECT_FILTRO
                _filtro = _filtro
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                         & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarSumaDuracionPersonalEncuestadoCastellanoFinalizadas(hasCuestionarioIndividual As Boolean) As DataTable
        Try
            If hasCuestionarioIndividual Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(i." & Globales.COL_CUESTIONARIO_DURACION & "),0)"

                _filtro = _filtro & " i." & Globales.COL_CUESTIND_AENC & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_DURACION & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_CASTELLANO & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If

                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarSumaDuracionColectivoEncuestadoEuskeraFinalizadas(hasColectivo As Boolean, hasCuestionarioFamiliar As Boolean) As DataTable
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            If hasColectivo Then

                'hay que buscar el idioma
                If hasCuestionarioFamiliar Then

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                             & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                Else

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "i." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "i." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "i." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAINICIO & " = ("

                    'Si no tiene cuestionario familiar, del individual que tenga la fecha más baja
                    Dim _filtro2 As String = String.Empty
                    Dim strQuery2 As String = Globales.C_SELECT_FILTRO

                    Dim strSelect2 As String = "MIN(" & Globales.COL_CUESTIONARIO_FECHAINICIO & ")"

                    _filtro2 = _filtro2 & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_NUMC & " = i." & Globales.COL_CUESTIONARIO_NUMC & ")"

                    strQuery2 = String.Format(strQuery2, strSelect2, Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND, _filtro2)

                    'hay que aplicar filtro
                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro & strQuery2
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                End If

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If


            Else
                Return Nothing
            End If

        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarSumaDuracionPersonalEncuestadoEuskeraFinalizadas(hasCuestionarioIndividual As Boolean) As DataTable
        Try
            If hasCuestionarioIndividual Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(i." & Globales.COL_CUESTIONARIO_DURACION & "),0)"

                _filtro = _filtro & " i." & Globales.COL_CUESTIND_AENC & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_DURACION & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & Globales.C_IDIOMA_EUSKERA & "'"
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarSumaDuracionColectivoEncuestadoFinalizadas(hasColectivo As Boolean, hasCuestionarioFamiliar As Boolean) As DataTable
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            If hasColectivo Then

                'hay que buscar el idioma
                If hasCuestionarioFamiliar Then

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                             & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                Else

                    Dim strSelect As String = "nvl(SUM(c." & Globales.COL_CONSULTAVIV_DURACION & "),0)"

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "i." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "i." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "i." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAINICIO & " = ("

                    'Si no tiene cuestionario familiar, del individual que tenga la fecha más baja
                    Dim _filtro2 As String = String.Empty
                    Dim strQuery2 As String = Globales.C_SELECT_FILTRO

                    Dim strSelect2 As String = "MIN(" & Globales.COL_CUESTIONARIO_FECHAINICIO & ")"

                    _filtro2 = _filtro2 & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_NUMC & " = i." & Globales.COL_CUESTIONARIO_NUMC & ")"

                    strQuery2 = String.Format(strQuery2, strSelect2, Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND, _filtro2)

                    'hay que aplicar filtro
                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro & strQuery2
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                End If

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If
               
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Return Nothing
        End Try
    End Function


    Public Function CargarSumaDuracionFamiliarEncuestadoFinalizadas(hasCuestionarioFamiliar As Boolean) As DataTable
        Try
            If hasCuestionarioFamiliar Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(f." & Globales.COL_CONSULTAVIV_DURACION & "),0)"

                _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND f." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                strQuery = Globales.C_SELECT_FILTRO
                _filtro = _filtro
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                         & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function



    Public Function CargarSumaDuracionPersonalEncuestadoFinalizadas(hasCuestionarioIndividual As Boolean) As DataTable
        Try
            If hasCuestionarioIndividual Then
                'Se establece la query a ejecutar.
                Dim strQuery As String
                Dim _filtro As String = String.Empty

                Dim strSelect As String = "nvl(SUM(i." & Globales.COL_CUESTIONARIO_DURACION & "),0)"

                _filtro = _filtro & " i." & Globales.COL_CUESTIND_AENC & " = " & Me.Anio
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_DURACION & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                If Me.Trim <> String.Empty Then
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                End If
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function




    Public Function CargarDatosDuracionEncuestadoFinalizadas(hasColectivo As Boolean, hasCuestionarioFamiliar As Boolean, hasCuestionarioIndividual As Boolean) As DataTable
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty
            Dim strSelect As String = String.Empty

            If hasColectivo Then

                'hay que buscar el idioma
                If hasCuestionarioFamiliar Then

                    strSelect = "c." & Globales.COL_CONSULTAVIV_DURACION & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                             & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                Else

                    strSelect = "c." & Globales.COL_CONSULTAVIV_DURACION & ", i." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "i." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "i." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "i." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAINICIO & " = ("

                    'Si no tiene cuestionario familiar, del individual que tenga la fecha más baja
                    Dim _filtro2 As String = String.Empty
                    Dim strQuery2 As String = Globales.C_SELECT_FILTRO

                    Dim strSelect2 As String = "MIN(" & Globales.COL_CUESTIONARIO_FECHAINICIO & ")"

                    _filtro2 = _filtro2 & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_NUMC & " = i." & Globales.COL_CUESTIONARIO_NUMC & ")"

                    strQuery2 = String.Format(strQuery2, strSelect2, Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND, _filtro2)

                    _filtro = _filtro & strQuery2

                End If


                If hasCuestionarioFamiliar Then

                    If strSelect = String.Empty Then
                        strSelect = "f." & Globales.COL_CONSULTAVIV_DURACION & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM
                    Else
                        strSelect = strSelect & ", f." & Globales.COL_CONSULTAVIV_DURACION & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM
                    End If

                    If _filtro <> String.Empty Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND f." & Globales.COL_CONSULTAVIV_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"

                End If

                If hasCuestionarioIndividual Then

                    If strSelect = String.Empty Then
                        strSelect = "i." & Globales.COL_CUESTIONARIO_DURACION & ", " & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER
                    Else
                        strSelect = strSelect & ",i." & Globales.COL_CUESTIONARIO_DURACION & ", " & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER
                    End If

                    If _filtro <> String.Empty Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & " i." & Globales.COL_CUESTIND_AENC & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_DURACION & " IS NOT NULL "
                    _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If

                End If

                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO
                strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If

        Catch ex As Exception
            Return Nothing
        End Try
    End Function






    Public Function CargarDatosDuracionEncuestadoIdiomaFinalizadas(hasColectivo As Boolean, hasCuestionarioFamiliar As Boolean, hasCuestionarioIndividual As Boolean, idioma As String) As DataTable
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty
            Dim strSelect As String = String.Empty

            If hasColectivo Then

                'hay que buscar el idioma
                If hasCuestionarioFamiliar Then

                    strSelect = "c." & Globales.COL_CONSULTAVIV_DURACION & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If

                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                    If idioma <> String.Empty Then
                        _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & idioma & "'"
                    End If

                    strQuery = Globales.C_SELECT_FILTRO
                    _filtro = _filtro
                    strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM _
                                             & " f, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o", _filtro)

                Else

                    strSelect = "c." & Globales.COL_CONSULTAVIV_DURACION & ", i." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER

                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If

                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "i." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "i." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "i." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND c." & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                    If idioma <> String.Empty Then
                        _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & idioma & "'"
                    End If

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAINICIO & " = ("

                    'Si no tiene cuestionario familiar, del individual que tenga la fecha más baja
                    Dim _filtro2 As String = String.Empty
                    Dim strQuery2 As String = Globales.C_SELECT_FILTRO

                    Dim strSelect2 As String = "MIN(" & Globales.COL_CUESTIONARIO_FECHAINICIO & ")"

                    _filtro2 = _filtro2 & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If
                    _filtro2 = _filtro2 & " AND " & Globales.COL_CUESTIONARIO_NUMC & " = i." & Globales.COL_CUESTIONARIO_NUMC & ")"

                    strQuery2 = String.Format(strQuery2, strSelect2, Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND, _filtro2)

                    _filtro = _filtro & strQuery2

                End If


                If hasCuestionarioFamiliar Then

                    If strSelect = String.Empty Then
                        strSelect = "f." & Globales.COL_CONSULTAVIV_DURACION & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM
                    Else
                        strSelect = strSelect & ", f." & Globales.COL_CONSULTAVIV_DURACION & ", f." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMFAM
                    End If

                    If _filtro <> String.Empty Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & "c." & Globales.COL_CUESTIONARIO_ANIO & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If

                    _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "f." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "f." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "f." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMFAM & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                    If idioma <> String.Empty Then
                        _filtro = _filtro & " AND f." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & idioma & "'"
                    End If

                End If

                If hasCuestionarioIndividual Then

                    If strSelect = String.Empty Then
                        strSelect = "i." & Globales.COL_CUESTIONARIO_DURACION & ", i." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER
                    Else
                        strSelect = strSelect & ",i." & Globales.COL_CUESTIONARIO_DURACION & ", i." & Globales.COL_CUESTIONARIO_IDIOMA & ", " & Globales.COL_CONSULTAIND_FORMPER
                    End If

                    If _filtro <> String.Empty Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & " i." & Globales.COL_CUESTIND_AENC & " = " & Me.Anio
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & Me.Trim
                    End If

                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_FECHAFIN & " IS NOT NULL "
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_FORMPER & " = " & Globales.FORM_WEB
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_NIND & " = " & "o." & Globales.COL_CUESTIONARIO_NIND
                    _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IN (" & Globales.SITUAC_FINAL_PARCIAL & ", " & Globales.SITUAC_FINALIZADA & ")"
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_NUMC & " = " & "o." & Globales.COL_CUESTIONARIO_NUMC
                    _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_ANIO & " = " & "o." & Globales.COL_CUESTIONARIO_ANIO
                    If Me.Trim <> String.Empty Then
                        _filtro = _filtro & " AND c." & Globales.COL_CUESTIONARIO_TRIM & " = " & "o." & Globales.COL_CUESTIONARIO_TRIM
                    End If
                    If idioma <> String.Empty Then
                        _filtro = _filtro & " AND i." & Globales.COL_CUESTIONARIO_IDIOMA & " = '" & idioma & "'"
                    End If

                End If

                If hasColectivo Then
                    If hasCuestionarioFamiliar And hasCuestionarioIndividual Then
                        strSelect = strSelect & ", (nvl(c." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & "+" & "nvl(f." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & "+" & "nvl(i." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & ") as " & _totalCuestionarios
                    ElseIf hasCuestionarioFamiliar Then
                        strSelect = strSelect & " (nvl)c." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & "+" & "nvl(f." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & ")  as " & _totalCuestionarios
                    ElseIf hasCuestionarioIndividual Then
                        strSelect = strSelect & ", (nvl(c." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & "+" & "nvl(i." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & ")  as " & _totalCuestionarios
                    Else
                        strSelect = strSelect & ", (nvl(c." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & ") as totalCuestionarios"
                    End If
                Else
                    If hasCuestionarioFamiliar And hasCuestionarioIndividual Then
                        strSelect = strSelect & ", (nvl(f." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & "+" & "nvl(i." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & ")  as " & _totalCuestionarios
                    ElseIf hasCuestionarioFamiliar Then
                        strSelect = strSelect & ", (nvl(f." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & ")  as " & _totalCuestionarios
                    ElseIf hasCuestionarioIndividual Then
                        strSelect = strSelect & ", (nvl(i." & Globales.COL_CONSULTAVIV_DURACION & ",0)" & ")  as " & _totalCuestionarios
                    End If
                End If

                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO
                Dim strWhere As String = Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " c , " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND _
                                             & " i, " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " o"
                If hasCuestionarioFamiliar Then
                    strWhere = strWhere & ", " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM & " f"
                End If
                strQuery = String.Format(strQuery, strSelect, strWhere, _filtro)

                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
                'Se recorre los data
                If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                    Return data.Tables(0)
                Else
                    Return Nothing
                End If

            Else
                Return Nothing
            End If

        Catch ex As Exception
            Return Nothing
        End Try
    End Function


#End Region

    'Listados Duración
    '*****************************************************************************************************************
#End Region



    Public Function CargarDatosListado7() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = Globales.COL_CONSULTAVIV_NUMC & ", " & Globales.COL_CONSULTAVIV_SIT & ", " & Globales.COL_CONSULTAVIV_ESTRATO

            _filtro = _filtro & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If Not String.IsNullOrEmpty(Me.Trim) Then
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAVIV_SIT & " IS NOT NULL"

            ''hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function


    Public Function CargarDatosFormaListado8() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NIND & ", " & Globales.COL_CONSULTAVIV_TH & ", nvl(" & Globales.COL_CONSULTAIND_FORMPER & ",-1) as " & Globales.COL_CONSULTAIND_FORMPER & ", " & Globales.COL_CONSULTAVIV_ESTRATO

            _filtro = _filtro & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If (Me.Trim <> String.Empty) Then
                _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If
            _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO
            If (Me.Trim <> String.Empty) Then
                _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_TRIM
            End If
            _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RPER & " = '" & Globales.COMPLETO & "'"

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " " & _aliasTablaVivienda & ", " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function



    Public Function CargarDatosIncidenciasListado8() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NIND & ", " & _
                Globales.COL_CONSULTAVIV_TH & ", " & Globales.COL_CONSULTAIND_RPER & ", " & Globales.COL_CONSULTAVIV_ESTRATO & ", " & Globales.COL_CONSULTAIND_INDPER

            _filtro = _filtro & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            If (Me.Trim <> String.Empty) Then
                _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If
            _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO
            If (Me.Trim <> String.Empty) Then
                _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_TRIM
            End If
            _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC
            _filtro = _filtro & " AND (" & Globales.COL_CONSULTAIND_RPER & " <> '" & Globales.COMPLETO & "' OR (" & Globales.COL_CONSULTAIND_RPER & " IS NULL AND " & Globales.COL_CONSULTAIND_INDPER & " = '" & Globales.VALOR_SI_IND & "'))"

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & " " & _aliasTablaVivienda & ", " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function

#Region "Seguimiento IC"
    Public Function CargarDatosICFamiliaresCompletas() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAIND_NUMC & ", " & Globales.COL_CONSULTAVIV_IC & ", " & Globales.COL_CONSULTAIND_INDFAM & ", " & Globales.COL_CUESTIONARIO_AGENTE

            _filtro = _filtro & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio

            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAIND_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAIND_ANIO
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_ANIO

            If Not String.IsNullOrEmpty(Me.Trim) Then

                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_TRIM
            End If

            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RFAM & " = '" & Globales.COMPLETO & "'"
            _filtro = _filtro & " AND ( " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "' OR " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "' ) "

            _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_AGENTE & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_NUMC
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_OPE & " = '" & Me.Operacion & "'"
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_PERFIL & " = " & Globales.PERFIL_ENCUESTADOR & ""
            _filtro = _filtro & " AND " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_CODUSU & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE & "." & Globales.COL_USUARIOS_CODUSU

            ''hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & ", " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & ", " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & ", " & _
                                     Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & ", " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function




    Public Function CargarDatosICFamiliaresIncidencias() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAIND_NUMC & ", " & Globales.COL_CONSULTAVIV_IC & ", " & Globales.COL_CONSULTAIND_INDFAM & ", " & Globales.COL_CUESTIONARIO_AGENTE

            _filtro = _filtro & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio

            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAIND_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAIND_ANIO
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_ANIO

            If Not String.IsNullOrEmpty(Me.Trim) Then

                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & "." & Globales.COL_CONSULTAVIV_TRIM
            End If

            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RFAM & " <> '" & Globales.COMPLETO & "'"
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RFAM & " IS NOT NULL"
            _filtro = _filtro & " AND ( " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "' OR " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_COD_IC_PERSONA_CONFIANZA & "' ) "

            _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_AGENTE & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_NUMC
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_OPE & " = '" & Me.Operacion & "'"
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_PERFIL & " = " & Globales.PERFIL_ENCUESTADOR & ""
            _filtro = _filtro & " AND " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_CODUSU & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE & "." & Globales.COL_USUARIOS_CODUSU

            ''hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & ", " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & ", " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIO & ", " & _
                                     Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & ", " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function




    Public Function CargarDatosICIndividualesCompletas() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_NUMC & ", " & Globales.COL_CONSULTAVIV_IC & ", " & Globales.COL_CONSULTAIND_INFPER & ", " & Globales.COL_CUESTIONARIO_AGENTE

            _filtro = _filtro & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio

            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_ANIO
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_ANIO

            If Not String.IsNullOrEmpty(Me.Trim) Then

                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_TRIM
            End If

            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RPER & " = '" & Globales.COMPLETO & "'"

            _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_AGENTE & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_NUMC
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_OPE & " = '" & Me.Operacion & "'"
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_PERFIL & " = " & Globales.PERFIL_ENCUESTADOR & ""
            _filtro = _filtro & " AND " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_CODUSU & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE & "." & Globales.COL_USUARIOS_CODUSU

            ''hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & ", " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & ", " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & ", " & _
                                     Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & ", " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function CargarDatosICIndividualesIncidencias() As DataTable
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim _filtro As String = String.Empty

            Dim strSelect As String = Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_NUMC & ", " & Globales.COL_CONSULTAVIV_IC & ", " & Globales.COL_CONSULTAIND_INFPER & ", " & Globales.COL_CUESTIONARIO_AGENTE

            _filtro = _filtro & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio

            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAIND_ANIO
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_NUMC & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_NUMC
            _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_ANIO

            If Not String.IsNullOrEmpty(Me.Trim) Then

                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_VIVIENDA & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM
                _filtro = _filtro & " AND " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & "." & Globales.COL_CONSULTAIND_TRIM & " = " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & "." & Globales.COL_CONSULTAVIV_TRIM
            End If

            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RPER & " <> '" & Globales.COMPLETO & "'"
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_RPER & " IS NOT NULL"

            _filtro = _filtro & " AND " & Globales.COL_CUESTIONARIO_AGENTE & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_NUMC
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_OPE & " = '" & Me.Operacion & "'"
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_PERFIL & " = " & Globales.PERFIL_ENCUESTADOR & ""
            _filtro = _filtro & " AND " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & "." & Globales.COL_USUARIOS_CODUSU & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE & "." & Globales.COL_USUARIOS_CODUSU

            ''hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me._nombretablaope & Globales.C_TABLA_VIVIENDA & ", " & Me._nombretablaope & Globales.C_TABLA_INDIVIDUOS & ", " & Me._nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & ", " & _
                                      Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & ", " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE, _filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0)
            Else
                Return Nothing
            End If

        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_LISTADO_CARGA, ex.InnerException)
        End Try
    End Function


#End Region
#End Region
#End Region


End Class
