﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

Imports Eustat.GEDW.V35.Ng.IC

''' <summary>
''' Clase que representa la muestra.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class ConMuestra
    Inherits EntidadBase

#Region "VARIABLES"
    Protected _dsConsulta As DataSet
    Protected _filtro As String = String.Empty
    Protected _nombretablaope As String = String.Empty
    Protected _idioma As String = String.Empty
    Protected _codusu As String = String.Empty
    Protected _encuestaInfo As Eustat.Comun.V35.Ng.Encuesta = Nothing
    Protected _cambioVivLit As String = String.Empty
    Protected _tipoViviLit As String = String.Empty

    Protected _litS As String = String.Empty
    Protected _litN As String = String.Empty
    Protected _litF As String = String.Empty
    Protected _litC As String = String.Empty


    Protected Const _aliasTablaVivienda As String = "VIV"
    Protected Const _aliasTablaIndividuos As String = "IND"

    Protected Const _aliasTablaCuestIndividual As String = "CIND"
    Protected Const _aliasTablaCuestFamiliar As String = "CFAM"


    Public Const IdentColumnIDEV As String = Globales.Constantes.ALIAS_CONSULTAVIV_IDEV
    Public Const IdentColumnMun As String = Globales.Constantes.ALIAS_CONSULTAVIV_MUN
    Public Const IdentColumnTh As String = Globales.Constantes.ALIAS_CONSULTAVIV_TH
    Public Const IdentColumnDir As String = Globales.Constantes.ALIAS_CONSULTAVIV_DIR
    Public Const IdentColumnCp As String = Globales.Constantes.ALIAS_CONSULTAVIV_CP
    Public Const IdentColumnIC As String = Globales.Constantes.ALIAS_CONSULTAVIV_IC
    Public Const IdentColumnICNombre As String = Globales.Constantes.ALIAS_CONSULTAVIV_IC_NOMBRE
    Public Const IdentColumnICTlfno As String = Globales.Constantes.ALIAS_CONSULTAVIV_IC_TLFNO
    Public Const IdentColumnICEmail As String = Globales.Constantes.ALIAS_CONSULTAVIV_IC_EMAIL
    Public Const IdentColumnICParentesco As String = Globales.Constantes.ALIAS_CONSULTAVIV_IC_RELACION
    Public Const IdentColumnICObservaciones As String = Globales.Constantes.ALIAS_CONSULTAVIV_IC_OBSERVACIONES

    Public Const IdentColumnNumc As String = Globales.ALIAS_CONSULTAVIV_NUMC
    Public Const IdentColumnAenc As String = Globales.ALIAS_CONSULTAVIV_ANIO
    Public Const IdentColumnRFam As String = Globales.ALIAS_CONSULTAIND_NOMRFAM
    Public Const IdentColumnRPer As String = Globales.ALIAS_CONSULTAIND_NOMRPER
    Public Const IdentColumnInfPer As String = Globales.ALIAS_CONSULTAIND_NOMINFPER
    Public Const IdentColumnTenc As String = Globales.ALIAS_CONSULTAVIV_TRIM

    Public Const IdentColumnFormFam As String = Globales.ALIAS_CONSULTAIND_FORMFAM
    Public Const IdentColumnFormPer As String = Globales.ALIAS_CONSULTAIND_FORMPER
    Public Const IdentColumnAgenteFam As String = Globales.ALIAS_CONSULTAIND_AGENTEFAM
    Public Const IdentColumnAgentePer As String = Globales.ALIAS_CONSULTAIND_AGENTEPER
#End Region

#Region "CONSTRUCTOR"
    Private _p1 As String

    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()

    End Sub
    Sub New(ByVal p1 As String, ByVal p2 As String, ByVal p3 As String, Optional ByVal encuestaInfo As Eustat.Comun.V35.Ng.Encuesta = Nothing)
        _nombretablaope = p1
        _idioma = p2
        _codusu = p3
        _encuestaInfo = encuestaInfo
    End Sub 
    
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"


    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Dim tablas As String
            tablas = Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_SITUACION & "," & _
            Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTVIV & "," & _
             Globales.C_TABLA_PROVINCIAS & "," & Globales.C_TABLA_MUNICIPIOS
            Return tablas
        End Get
    End Property


    ''' <summary>
    ''' Obtener el nombre de la tabla de la operación
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public ReadOnly Property NombreTablasOpe() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_VIVIENDA & " " & _aliasTablaVivienda & " ," & _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos
        End Get
    End Property
#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return Globales.ALIAS_ACCESO_IDACCESO
        End Get
    End Property


    Public ReadOnly Property ColumnaEncuesta() As String
        Get
            Return Globales.ALIAS_ACCESO_ENCUESTA
        End Get
    End Property

    Public ReadOnly Property ColumnaNumc() As String
        Get
            Return Globales.ALIAS_ACCESO_NUMC
        End Get
    End Property

    Public Property Operacion() As String
        Get
            Return _nombretablaope
        End Get
        Set(ByVal value As String)
            _nombretablaope = value
        End Set
    End Property


    Public Property Idioma() As String
        Get
            Return _idioma
        End Get
        Set(ByVal value As String)
            _idioma = value
        End Set
    End Property

    Public Property CodUsu() As String
        Get
            Return _codusu
        End Get
        Set(ByVal value As String)
            _codusu = value
        End Set
    End Property

    Public Property LitS() As String
        Get
            Return _litS
        End Get
        Set(ByVal value As String)
            _litS = value
        End Set
    End Property

    Public Property LitN() As String
        Get
            Return _litN
        End Get
        Set(ByVal value As String)
            _litN = value
        End Set
    End Property

    Public Property LitC() As String
        Get
            Return _litC
        End Get
        Set(ByVal value As String)
            _litC = value
        End Set
    End Property

    Public Property LitF() As String
        Get
            Return _litF
        End Get
        Set(ByVal value As String)
            _litF = value
        End Set
    End Property


    Public Property EncuestaInfo() As Eustat.Comun.V35.Ng.Encuesta
        Get
            Return _encuestaInfo
        End Get
        Set(ByVal value As Eustat.Comun.V35.Ng.Encuesta)
            _encuestaInfo = value
        End Set
    End Property

    Public ReadOnly Property ColumnaDescripcionResult(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_RESULTVIV_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_RESULTVIV_LITEUS
            End If
            Return column
        End Get
    End Property

    Public ReadOnly Property ColumnaDescripcionSituac(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_SITUACION_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_SITUACION_LITEUS
            End If
            Return column
        End Get
    End Property


    Public ReadOnly Property ColumnaDescripcionRCuest(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_RESULTCUEST_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_RESULTCUEST_LITEUS
            End If
            Return column
        End Get
    End Property

    Public ReadOnly Property ColumnaDescripcionForm(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_FORM_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_FORM_LITEUS
            End If
            Return column
        End Get
    End Property

    Public ReadOnly Property ColumnaDescripcionRCont(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_RESULTCONT_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_RESULTCONT_LITEUS
            End If
            Return column
        End Get
    End Property

    Public Property GetDatos() As DataSet
        Get
            Return _dsConsulta
        End Get
        Set(ByVal value As DataSet)
            _dsConsulta = value
        End Set
    End Property

#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"

    Public Overridable Function ObtenerDatosCabecera(ByVal numc As String, ByVal aenc As String, ByVal tenc As String) As DataSet
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim strSelect As String = Globales.COL_MUN_NOMBRE & " AS " & Globales.ALIAS_CONSULTAVIV_MUN & " ," & Globales.COL_PROV_NOMBRE & " AS " & Globales.ALIAS_CONSULTAVIV_TH
            strSelect = strSelect & "," & Globales.COL_CONSULTAVIV_IDEV & " AS " & Globales.ALIAS_CONSULTAVIV_IDEV
            strSelect = strSelect & "," & Globales.COL_CONSULTAVIV_DIR & " AS " & Globales.ALIAS_CONSULTAVIV_DIR
            strSelect = strSelect & "," & Globales.COL_CONSULTAVIV_CP & " AS " & Globales.ALIAS_CONSULTAVIV_CP
            Dim ICLN As IC = New IC(Me.Operacion)
            If ICLN.TieneIC Then
                strSelect = strSelect & "," & Globales.COL_CONSULTAVIV_IC & " AS " & Globales.ALIAS_CONSULTAVIV_IC
                strSelect = strSelect & "," & Globales.COL_CONSULTAVIV_IC_NOMBRE & " AS " & Globales.ALIAS_CONSULTAVIV_IC_NOMBRE
                strSelect = strSelect & "," & Globales.COL_CONSULTAVIV_IC_TLFNO & " AS " & Globales.ALIAS_CONSULTAVIV_IC_TLFNO
                strSelect = strSelect & "," & Globales.COL_CONSULTAVIV_IC_EMAIL & " AS " & Globales.ALIAS_CONSULTAVIV_IC_EMAIL
                strSelect = strSelect & "," & Globales.COL_CONSULTAVIV_IC_RELACION & " AS " & Globales.ALIAS_CONSULTAVIV_IC_RELACION
                strSelect = strSelect & "," & Globales.COL_CONSULTAVIV_IC_OBSERVACIONES & " AS " & Globales.ALIAS_CONSULTAVIV_IC_OBSERVACIONES
            End If

            Dim _filtroAux As String = ""

            Dim strTablas As String = _nombretablaope & Globales.C_TABLA_VIVIENDA & "," &
             Globales.C_TABLA_PROVINCIAS & "," & Globales.C_TABLA_MUNICIPIOS


            _filtroAux = _filtroAux & Globales.COL_PROV_ID & " = " & Globales.COL_CONSULTAVIV_TH
            _filtroAux = _filtroAux & " AND " & Globales.COL_MUN_ID & " = " & Globales.COL_CONSULTAVIV_MUN
            _filtroAux = _filtroAux & " AND " & Globales.COL_PROV_ID & " = " & Globales.COL_MUN_PROVID
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAVIV_ANIO & " = " & aenc
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAVIV_NUMC & " = '" & numc & "'"

            If (Not (String.IsNullOrEmpty(tenc))) Then
                _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAVIV_TRIM & " = " & tenc
            End If


            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, strTablas, _filtroAux)


            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data
            End If
            MyBase.Cargar()

            Return Nothing
        Catch ex As Exception
            Throw New MuestraException(Globales.EX_MUESTRA_CARGA, ex.InnerException)
        End Try
    End Function


    Public Overridable Function CargarExcel() As DataSet
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim strSelect As String
            strSelect = _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " AS " & Globales.ALIAS_CONSULTAVIV_ANIO
            strSelect = strSelect & "," & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & " AS " & Globales.ALIAS_CONSULTAVIV_NUMC
            strSelect = strSelect & "," & Globales.COL_PROV_NOMBRE & " AS TERR ," & Globales.COL_MUN_NOMBRE & " AS MUN "
            strSelect = strSelect & "," & ColumnaDescripcionSituac(Me.Idioma) & " AS SITUACION," & ColumnaDescripcionResult(Me.Idioma) & " AS RESULTVIVIENDA"
            strSelect = strSelect & "," & ColumnaDescripcionRCont(Me.Idioma) & " AS RCONT"
            strSelect = strSelect & "," & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NIND & " AS " & Globales.ALIAS_CONSULTAIND_NIND
            strSelect = strSelect & "," & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_SITA & " AS " & Globales.ALIAS_CONSULTAIND_SITA & "," & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NOM & " || ' ' || " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_APE2 & " AS " & Globales.ALIAS_CONSULTAIND_NOM
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_EDAD & " AS " & Globales.ALIAS_CONSULTAIND_EDAD & ","
            strSelect = strSelect & "A." & ColumnaDescripcionRCuest(Me.Idioma) & " AS " & Globales.ALIAS_CONSULTAIND_NOMRFAM & ",B." & ColumnaDescripcionRCuest(Me.Idioma) & " AS " & Globales.ALIAS_CONSULTAIND_NOMRPER
            strSelect = strSelect & ",Z" & "." & Globales.COL_CONSULTAIND_NOM & " || ' ' || " & "Z." & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & "Z." & Globales.COL_CONSULTAIND_APE2 & " AS " & Globales.ALIAS_CONSULTAIND_NOMINFPER
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INFPER & " AS " & Globales.ALIAS_CONSULTAIND_INFPER
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDFAM & " AS " & Globales.ALIAS_CONSULTAIND_INDFAM
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDPER & " AS " & Globales.ALIAS_CONSULTAIND_INDPER
            strSelect = strSelect & ", C." & ColumnaDescripcionForm(Me.Idioma) & " AS " & Globales.ALIAS_CONSULTAIND_FORMFAM
            strSelect = strSelect & ", D." & ColumnaDescripcionForm(Me.Idioma) & " AS " & Globales.ALIAS_CONSULTAIND_FORMPER
            If _encuestaInfo Is Nothing OrElse _encuestaInfo.HasCuestionarioFamiliar Then
                strSelect = strSelect & "," & _aliasTablaCuestFamiliar & "." & Globales.COL_CUESTIONARIO_AGENTE & " AS " & Globales.ALIAS_CONSULTAIND_AGENTEFAM
            Else
                strSelect = strSelect & ",''" & " AS " & Globales.ALIAS_CONSULTAIND_AGENTEFAM
            End If

            strSelect = strSelect & "," & _aliasTablaCuestIndividual & "." & Globales.COL_CUESTIONARIO_AGENTE & " AS " & Globales.ALIAS_CONSULTAIND_AGENTEPER
            strSelect = strSelect & ",TO_NUMBER(" & _aliasTablaVivienda & "." & Globales.COL_CONSULTAIND_NUMC & ") AS " & Globales.ALIAS_CONSULTAIND_NUMC & "_ORDER"
            strSelect = strSelect & "," & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_LENTP & " AS " & Globales.COL_CONSULTAVIV_LENTP


            Dim icLn As IC = New IC(_encuestaInfo.IdEncuesta)

            If icLn.TieneIC Then
                strSelect = strSelect & ", " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_IC & " AS " & Globales.ALIAS_CONSULTAVIV_IC
            End If 
            If (_encuestaInfo.CambioDireccion) Then 
                strSelect = strSelect & "," & "DECODE(" & Globales.COL_CONSULTAVIV_CAMBIODIR & ",'" & Globales.VALOR_SI_IND & "','" & LitS & "','" & Globales.VALOR_NO_IND & "','" & LitN & "'," & "'')" & " AS " & Globales.COL_CONSULTAVIV_CAMBIODIR
                strSelect = strSelect & "," & "DECODE(" & Globales.COL_CONSULTAVIV_TVIV & ",'" & Globales.VALOR_F_IND & "','" & LitF & "','" & Globales.VALOR_C_IND & "','" & LitC & "'," & "'')" & " AS " & Globales.COL_CONSULTAVIV_TVIV
            End If
             

            'Trimestre
            Dim TrimLN As Trimestre = New Trimestre(Me.Operacion)
            Dim dtTrim As DataSet = TrimLN.GetDsTrim()
            If (Not IsNothing(dtTrim)) Then
                strSelect = strSelect & ", " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TRIM & " AS " & Globales.ALIAS_CONSULTAVIV_TRIM
            End If
            'Semana
            Dim SemLN As Semana = New Semana(Me.Operacion)
            Dim dtSem As DataSet = SemLN.GetDsSem()
            If (Not IsNothing(dtSem)) Then
                strSelect = strSelect & ", " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_SEM & " AS " & Globales.ALIAS_CONSULTAVIV_SEM
            End If



            Dim _filtroAux As String = _filtro
            If Not (String.IsNullOrEmpty(_filtroAux)) Then
                _filtroAux = _filtroAux & " AND "
            End If


            _filtroAux = _filtroAux & Globales.COL_PROV_ID & " = " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TH
            _filtroAux = _filtroAux & " AND " & Globales.COL_MUN_ID & " = " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_MUN
            _filtroAux = _filtroAux & " AND " & Globales.COL_PROV_ID & " = " & Globales.COL_MUN_PROVID
            _filtroAux = _filtroAux & " AND " & Globales.COL_SITUACION_ID & " (+)= " & Globales.COL_CONSULTAVIV_SIT
            _filtroAux = _filtroAux & " AND " & Globales.COL_RESULTVIV_ID & " (+)= " & Globales.COL_CONSULTAVIV_RVIV
            _filtroAux = _filtroAux & " AND " & Globales.COL_RESULTCONT_ID & " (+)= " & Globales.COL_CONSULTAVIV_RCONT
            _filtroAux = _filtroAux & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO
            _filtroAux = _filtroAux & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC
            _filtroAux = _filtroAux & " AND " & "A." & Globales.COL_RESULTCUEST_ID & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_RFAM
            _filtroAux = _filtroAux & " AND B." & Globales.COL_RESULTCUEST_ID & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_RPER
            _filtroAux = _filtroAux & " AND Z." & Globales.COL_CONSULTAIND_NUMC & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC
            _filtroAux = _filtroAux & " AND Z." & Globales.COL_CONSULTAIND_ANIO & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO
            _filtroAux = _filtroAux & " AND Z." & Globales.COL_CONSULTAIND_NIND & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INFPER
            _filtroAux = _filtroAux & " AND " & "C." & Globales.COL_FORM_ID & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_FORMFAM
            _filtroAux = _filtroAux & " AND D." & Globales.COL_FORM_ID & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_FORMPER

            Dim tablasAux As String = Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST & " A," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST & " B," &
            Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCONT & "," & _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " Z, " &
            Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_FORMACUMPLIMENTACION & " C, " &
            Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_FORMACUMPLIMENTACION & " D "

            Dim stFrom As String = Me.NombreTabla & "," & Me.NombreTablasOpe & "," & tablasAux

            If _encuestaInfo Is Nothing OrElse _encuestaInfo.HasCuestionarioFamiliar Then
                stFrom += "," & _nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM & " " & _aliasTablaCuestFamiliar
            End If
            stFrom += "," & _nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & " " & _aliasTablaCuestIndividual

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO_ORDER
            strQuery = String.Format(strQuery, strSelect, stFrom, _filtroAux, Globales.ALIAS_CONSULTAVIV_ANIO & "," & Globales.ALIAS_CONSULTAIND_NUMC & "_ORDER")


            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data
            End If

            Return Nothing
        Catch ex As Exception
            Throw New MuestraException(Globales.EX_MUESTRA_CARGA, ex.InnerException)
        End Try
    End Function



    Public Overrides Sub Cargar()
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim strSelect As String = _aliasTablaVivienda & ".* ," & ColumnaDescripcionSituac(Me.Idioma) & " AS SITUACION," & ColumnaDescripcionResult(Me.Idioma) & " AS RESULTVIVIENDA"
            strSelect = strSelect & "," & Globales.COL_MUN_NOMBRE & " AS MUN ," & Globales.COL_PROV_NOMBRE & " AS TERR "
            strSelect = strSelect & "," & _aliasTablaVivienda & "." & Globales.COL_CONSULTAIND_NUMC & " AS " & Globales.ALIAS_CONSULTAIND_NUMC
            strSelect = strSelect & "," & _aliasTablaVivienda & "." & Globales.COL_CONSULTAIND_ANIO & " AS " & Globales.ALIAS_CONSULTAIND_ANIO
            strSelect = strSelect & ",TO_NUMBER(" & _aliasTablaVivienda & "." & Globales.COL_CONSULTAIND_NUMC & ") AS " & Globales.ALIAS_CONSULTAIND_NUMC & "_ORDER"

            If (Not (_encuestaInfo.CambioDireccion)) Then
                strSelect = strSelect & "," & "''" & " as CAMBIODIREC" & "," & "''" & " as TVIVI"
            Else
                strSelect = strSelect & "," & "DECODE(" & Globales.COL_CONSULTAVIV_CAMBIODIR & ",'" & Globales.VALOR_SI_IND & "','" & LitS & "','" & Globales.VALOR_NO_IND & "','" & LitN & "'," & "'')" & " as CAMBIODIREC"
                strSelect = strSelect & "," & "DECODE(" & Globales.COL_CONSULTAVIV_TVIV & ",'" & Globales.VALOR_F_IND & "','" & LitF & "','" & Globales.VALOR_C_IND & "','" & LitC & "'," & "'')" & " as TVIVI"
            End If

            Dim ICLN As IC = New IC(Me.Operacion)
            If ICLN.TieneIC Then
                strSelect = strSelect & "," & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_IC & " AS " & Globales.ALIAS_CONSULTAVIV_IC
            End If

            If Not (String.IsNullOrEmpty(_filtro)) Then
                _filtro = _filtro & " AND "
            End If


            _filtro = _filtro & Globales.COL_PROV_ID & " = " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TH
            _filtro = _filtro & " AND " & Globales.COL_MUN_ID & " = " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_MUN
            _filtro = _filtro & " AND " & Globales.COL_PROV_ID & " = " & Globales.COL_MUN_PROVID
            _filtro = _filtro & " AND " & Globales.COL_SITUACION_ID & " (+)= " & Globales.COL_CONSULTAVIV_SIT
            _filtro = _filtro & " AND " & Globales.COL_RESULTVIV_ID & " (+)= " & Globales.COL_CONSULTAVIV_RVIV
            _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO
            _filtro = _filtro & " AND " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & " = " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC
            If _encuestaInfo Is Nothing OrElse _encuestaInfo.HasCuestionarioFamiliar Then
                _filtro = _filtro & " AND " & _aliasTablaCuestFamiliar & "." & Globales.COL_CUESTIND_AENC & " (+)= " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAIND_ANIO
                _filtro = _filtro & " AND " & _aliasTablaCuestFamiliar & "." & Globales.COL_CUESTIND_NUMC & " (+)= " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAIND_NUMC
            End If
            _filtro = _filtro & " AND " & _aliasTablaCuestIndividual & "." & Globales.COL_CUESTIND_AENC & " (+)= " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAIND_ANIO
            _filtro = _filtro & " AND " & _aliasTablaCuestIndividual & "." & Globales.COL_CUESTIND_NUMC & " (+)= " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAIND_NUMC

            Dim stFrom As String = Me.NombreTabla & "," & Me.NombreTablasOpe
            If _encuestaInfo Is Nothing OrElse _encuestaInfo.HasCuestionarioFamiliar Then
                stFrom += "," & _nombretablaope & Globales.C_TABLA_CUESTIONARIOFAM & " " & _aliasTablaCuestFamiliar
            End If
            stFrom += "," & _nombretablaope & Globales.C_TABLA_CUESTIONARIOIND & " " & _aliasTablaCuestIndividual


            'Si existe lote y el usuario sólo tiene acceso a determinados lotes debo solo mostrar la información de dichos lotes
            Dim LoteLN As Lote = New Lote(Me.Operacion, Me.CodUsu)
            Dim dtLotes As DataSet = LoteLN.GetDsLote()
            If dtLotes IsNot Nothing AndAlso dtLotes.Tables.Count > 0 Then
                Dim strAuxLotes As String = String.Empty
                For Each row In dtLotes.Tables(0).Rows
                    If (Not (String.IsNullOrEmpty(strAuxLotes))) Then
                        strAuxLotes &= ",'" & row(LoteLN.ColumnaDescripcion).ToString() & "'"
                    Else
                        strAuxLotes &= "'" & row(LoteLN.ColumnaDescripcion).ToString() & "'"
                    End If
                Next
                If Not (String.IsNullOrEmpty(_filtro)) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & Globales.COL_CONSULTAVIV_LOTE & " IN (" & strAuxLotes & ")"
            End If

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_DIST_FILTRO_ORDER
            strQuery = String.Format(strQuery, strSelect, stFrom, _filtro, Globales.ALIAS_CONSULTAIND_ANIO & "," & Globales.ALIAS_CONSULTAIND_NUMC & "_ORDER")


            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dsConsulta = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New MuestraException(Globales.EX_MUESTRA_CARGA, ex.InnerException)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener Accesos.
    ''' </summary>
    ''' <returns>DataSet con el listado de las Accesos.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetMuestra(ByVal aenc As String, ByVal numcdesde As String, ByVal numchasta As String, ByVal th As String, ByVal com As String, ByVal mun As String, ByVal situac As String, ByVal rcont As String, ByVal renc As String _
                               , ByVal rfam As String, ByVal rper As String, ByVal fechafamdesde As String, ByVal fechafamhasta As String, ByVal fechainddesde As String, ByVal fechaindhasta As String _
                               , ByVal metodofam As String, ByVal metodoind As String _
                               , ByVal encuestadorfam As String, ByVal encuestadorind As String, ByVal tenc As String, ByVal senc As String, ByVal lote As String, ByVal codusuario As String, ByVal ic As String, ByVal turno As String) As DataSet

        Try
            If Not String.IsNullOrEmpty(numcdesde) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & " >= " & numcdesde & ""
            End If
            If Not String.IsNullOrEmpty(numchasta) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_NUMC & " <= " & numchasta & ""
            End If
            If Not String.IsNullOrEmpty(th) AndAlso th <> "-1" Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & Globales.COL_CONSULTAVIV_TH & " = '" & th & "'"
            End If
            If Not String.IsNullOrEmpty(com) AndAlso com <> "-1" Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & Globales.COL_MUN_COMR & " = '" & com & "'"
            End If
            If Not String.IsNullOrEmpty(mun) AndAlso mun <> "-1" Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & Globales.COL_CONSULTAVIV_MUN & " = '" & mun & "'"
            End If
            If Not String.IsNullOrEmpty(aenc) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_ANIO & " = " & aenc
            End If
            If Not String.IsNullOrEmpty(situac) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & Globales.COL_CONSULTAVIV_SIT & " = '" & situac & "'"
            End If
            If Not String.IsNullOrEmpty(ic) AndAlso ic <> "-1" Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                If ic.Equals(Globales.VALOR_COD_IC_SI) Then
                    _filtro = _filtro & Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_SI & "%'"
                Else
                    _filtro = _filtro & " ( " & Globales.COL_CONSULTAVIV_IC & " LIKE '" & Globales.VALOR_COD_IC_NO & "%' OR " & Globales.COL_CONSULTAVIV_IC & " IS NULL ) "
                End If
            End If
            If Not String.IsNullOrEmpty(turno) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TURN & " = " & turno
            End If
            If Not String.IsNullOrEmpty(rcont) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_RCONT & " = '" & rcont & "'"
            End If
            If Not String.IsNullOrEmpty(renc) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & Globales.COL_CONSULTAVIV_RVIV & " = '" & renc & "'"
            End If
            If Not String.IsNullOrEmpty(rper) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_RPER & " = '" & rper & "'"
            End If
            If Not String.IsNullOrEmpty(rfam) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_RFAM & " = '" & rfam & "'"
            End If
            If Not String.IsNullOrEmpty(fechafamdesde) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                If Not String.IsNullOrEmpty(fechafamhasta) Then
                    _filtro = _filtro & " (to_date(to_char(" & _aliasTablaCuestFamiliar & "." & Globales.COL_CUESTIONARIO_FECHAFIN & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') between "
                    _filtro = _filtro & " to_date('" & fechafamdesde & "', 'dd/mm/yyyy)') and "
                    _filtro = _filtro & " to_date('" & fechafamhasta & "', 'dd/mm/yyyy)') "
                    _filtro = _filtro & " OR (to_date(to_char(" & _aliasTablaCuestFamiliar & "." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') between "
                    _filtro = _filtro & " to_date('" & fechafamdesde & "', 'dd/mm/yyyy)') and "
                    _filtro = _filtro & " to_date('" & fechafamhasta & "', 'dd/mm/yyyy)'))) "
                Else
                    _filtro = _filtro & " (to_date(to_char(" & _aliasTablaCuestFamiliar & "." & Globales.COL_CUESTIONARIO_FECHAFIN & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') >= "
                    _filtro = _filtro & " to_date('" & fechafamdesde & "', 'dd/mm/yyyy)') "
                    _filtro = _filtro & " OR (to_date(to_char(" & _aliasTablaCuestFamiliar & "." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') >= "
                    _filtro = _filtro & " to_date('" & fechafamdesde & "', 'dd/mm/yyyy)'))) "
                End If
            End If
            If Not String.IsNullOrEmpty(fechainddesde) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                If Not String.IsNullOrEmpty(fechaindhasta) Then
                    _filtro = _filtro & " (to_date(to_char(" & _aliasTablaCuestIndividual & "." & Globales.COL_CUESTIONARIO_FECHAFIN & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') between "
                    _filtro = _filtro & " to_date('" & fechainddesde & "', 'dd/mm/yyyy)') and "
                    _filtro = _filtro & " to_date('" & fechaindhasta & "', 'dd/mm/yyyy)')"
                    _filtro = _filtro & " OR (to_date(to_char(" & _aliasTablaCuestIndividual & "." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') between "
                    _filtro = _filtro & " to_date('" & fechainddesde & "', 'dd/mm/yyyy)') and "
                    _filtro = _filtro & " to_date('" & fechaindhasta & "', 'dd/mm/yyyy)'))) "
                Else
                    _filtro = _filtro & " (to_date(to_char(" & _aliasTablaCuestIndividual & "." & Globales.COL_CUESTIONARIO_FECHAFIN & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') >= "
                    _filtro = _filtro & " to_date('" & fechainddesde & "', 'dd/mm/yyyy)') "
                    _filtro = _filtro & " OR (to_date(to_char(" & _aliasTablaCuestIndividual & "." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') >= "
                    _filtro = _filtro & " to_date('" & fechainddesde & "', 'dd/mm/yyyy)'))) "
                End If
            End If
            If _encuestaInfo Is Nothing OrElse _encuestaInfo.HasCuestionarioFamiliar AndAlso Not String.IsNullOrEmpty(fechafamhasta) And String.IsNullOrEmpty(fechafamdesde) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " (to_date(to_char(" & _aliasTablaCuestFamiliar & "." & Globales.COL_CUESTIONARIO_FECHAFIN & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') <= "
                _filtro = _filtro & " to_date('" & fechafamhasta & "', 'dd/mm/yyyy)') "
                _filtro = _filtro & " OR (to_date(to_char(" & _aliasTablaCuestFamiliar & "." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') <= "
                _filtro = _filtro & " to_date('" & fechafamhasta & "', 'dd/mm/yyyy)'))) "
            End If
            If Not String.IsNullOrEmpty(fechaindhasta) And String.IsNullOrEmpty(fechainddesde) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " (to_date(to_char(" & _aliasTablaCuestIndividual & "." & Globales.COL_CUESTIONARIO_FECHAFIN & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') <= "
                _filtro = _filtro & " to_date('" & fechaindhasta & "', 'dd/mm/yyyy)') "
                _filtro = _filtro & " OR (to_date(to_char(" & _aliasTablaCuestIndividual & "." & Globales.COL_CUESTIONARIO_FECHAFIN_AG & ", 'dd/mm/yyyy'), 'dd/mm/yyyy') <= "
                _filtro = _filtro & " to_date('" & fechaindhasta & "', 'dd/mm/yyyy)'))) "
            End If
            If Not String.IsNullOrEmpty(metodofam) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_FORMFAM & " = " & metodofam & ""
            End If
            If Not String.IsNullOrEmpty(metodoind) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_FORMPER & " = " & metodoind & ""
            End If
            If _encuestaInfo Is Nothing OrElse _encuestaInfo.HasCuestionarioFamiliar AndAlso Not String.IsNullOrEmpty(encuestadorfam) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaCuestFamiliar & "." & Globales.COL_CUESTIONARIO_AGENTE & " = '" & encuestadorfam & "'"
            End If
            If Not String.IsNullOrEmpty(encuestadorind) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaCuestIndividual & "." & Globales.COL_CUESTIONARIO_AGENTE & " = '" & encuestadorind & "'"
            End If
            If Not String.IsNullOrEmpty(tenc) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_TRIM & " = " & tenc
            End If
            If Not String.IsNullOrEmpty(senc) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_SEM & " = " & senc
            End If
            If Not String.IsNullOrEmpty(lote) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & _aliasTablaVivienda & "." & Globales.COL_CONSULTAVIV_LOTE & " = " & lote
            End If
            Me.Cargar()
            Return _dsConsulta
        Catch ex As Exception
            Throw New MuestraException(Globales.EX_MUESTRA_CARGA, ex.InnerException)
        End Try
    End Function
#End Region
#End Region



End Class
