﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa los contactos.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class ConInfo
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsConsulta As DataSet
    Private _filtro As String = String.Empty
    Private _nombretablaope As String = String.Empty
    Private _idioma As String = String.Empty

    Public Const IdentColumnTelef1 As String = Globales.COL_CONSULTAIND_TLFNO1
    Public Const IdentColumnTelef2 As String = Globales.COL_CONSULTAIND_TLFNO2
    Public Const IdentColumnEmail As String = Globales.COL_CONSULTAIND_EMAIL
    Public Const IdentColumnNind As String = Globales.COL_CONSULTAIND_NIND
    Public Const IdentColumnNumc As String = Globales.COL_CONSULTAIND_NUMC
    Public Const IdentColumnAenc As String = Globales.COL_CONSULTAIND_ANIO
    Public Const IdentColumnTenc As String = Globales.COL_CONSULTAIND_TRIM
#End Region

#Region "CONSTRUCTOR"

    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()

    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"

    Sub New(ByVal p1 As String, ByVal p2 As String)
        _nombretablaope = p1
        _idioma = p2
    End Sub

    Sub New(ByVal p1 As String, ByVal p2 As String, ByVal p3 As String, ByVal p4 As String, ByVal p5 As String)
        _nombretablaope = p1
        _numc = p2
        _aenc = p3
        _tenc = p4
        _idioma = p5
    End Sub

    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Dim tablas As String
            tablas = _nombretablaope & Globales.C_TABLA_INDIVIDUOS
            Return tablas
        End Get
    End Property


    ''' <summary>
    ''' Obtener el nombre de la tabla de la operación
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public ReadOnly Property NombreTablasOpe() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_INDIVIDUOS
        End Get
    End Property
#End Region

#Region "PROPIAS"

    Private _operacion As String
    Public Property Operacion() As String
        Get
            Return _operacion
        End Get
        Set(ByVal value As String)
            _operacion = value
        End Set
    End Property


    Public Property Idioma() As String
        Get
            Return _idioma
        End Get
        Set(ByVal value As String)
            _idioma = value
        End Set
    End Property

    Private _numc As String
    Public Property Numc() As String
        Get
            Return _numc
        End Get
        Set(ByVal value As String)
            _numc = value
        End Set
    End Property

    Private _aenc As String
    Public Property Aenc() As String
        Get
            Return _aenc
        End Get
        Set(ByVal value As String)
            _aenc = value
        End Set
    End Property

    Private _tenc As String
    Public Property Tenc() As String
        Get
            Return _tenc
        End Get
        Set(ByVal value As String)
            _tenc = value
        End Set
    End Property

    Private _senc As String
    Public Property Senc() As String
        Get
            Return _senc
        End Get
        Set(ByVal value As String)
            _senc = value
        End Set
    End Property

    Public Property GetDatos() As DataSet
        Get
            Return _dsConsulta
        End Get
        Set(ByVal value As DataSet)
            _dsConsulta = value
        End Set
    End Property

#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"

    Public Overrides Sub Cargar()
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim strSelect As String = Globales.COL_CONSULTAIND_NUMC
            strSelect = strSelect & ", " & Globales.COL_CONSULTAIND_ANIO
            If (Not String.IsNullOrEmpty(Me.Tenc)) Then
                strSelect = strSelect & ", " & Globales.COL_CONSULTAIND_TRIM
            End If
            strSelect = strSelect & ", " & Globales.COL_CONSULTAIND_NIND
            strSelect = strSelect & ", " & Globales.COL_CONSULTAIND_EDAD
            strSelect = strSelect & ", " & Globales.COL_CONSULTAIND_TLFNO1
            strSelect = strSelect & ", " & Globales.COL_CONSULTAIND_TLFNO2
            strSelect = strSelect & ", " & Globales.COL_CONSULTAIND_EMAIL
            strSelect = strSelect & ", " & Globales.COL_CONSULTAIND_NOM & " || ' ' || " & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & Globales.COL_CONSULTAIND_APE2 & " AS " & Globales.COL_USUARIOS_NOM

            If Not (String.IsNullOrEmpty(_filtro)) Then
                _filtro = _filtro & " AND "
            End If

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & Globales.COL_CONSULTAIND_SITA & " <> " & Globales.INDIVIDUO_BAJA

            _filtro = _filtro & _filtroAux

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO_ORDER
            strQuery = String.Format(strQuery, strSelect, _nombretablaope & Globales.C_TABLA_INDIVIDUOS, _filtro, Globales.COL_CONSULTAIND_EDAD & " DESC")

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dsConsulta = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New MuestraException(Globales.EX_CONTACTO_CARGA, ex.InnerException)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener Accesos.
    ''' </summary>
    ''' <returns>DataSet con el listado de las Accesos.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetInfo() As DataSet
        Try
            If Not String.IsNullOrEmpty(Me.Numc) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & Globales.COL_CONSULTAIND_NUMC & " = '" & Me.Numc & "'"
            End If
            If Not String.IsNullOrEmpty(Me.Aenc) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Aenc
            End If
            If Not String.IsNullOrEmpty(Me.Tenc) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & Globales.COL_CONSULTAIND_TRIM & " = " & Me.Tenc
            End If
            If Not String.IsNullOrEmpty(Me.Senc) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & " " & Globales.COL_CONSULTAIND_SENC & " = " & Me.Senc
            End If
            Me.Cargar()
            Return _dsConsulta
        Catch ex As Exception
            Throw New MuestraException(Globales.EX_CONTACTO_CARGA, ex.InnerException)
        End Try
    End Function


    Sub actualizarDatos(ByVal ds As DataSet)
        Dim bTransCreada As Boolean = False
        Try
            Dim sql As String
            Dim cmd(5) As OracleParameter
            If (Not String.IsNullOrEmpty(Me.Tenc)) Then
                ReDim cmd(6)
            End If

            If Me.Transaccion Is Nothing Then
                Me.CrearTransaccion()
                bTransCreada = True
            End If

            Me.AsignarTransaccion(Me)

            Dim i As Integer = 0
            For i = 0 To ds.Tables(0).Rows.Count - 1

                sql = String.Format(Globales.UPDATE_GENERICO, _nombretablaope & Globales.C_TABLA_INDIVIDUOS,
                Globales.COL_CONSULTAIND_TLFNO1 & "=:" & Globales.COL_CONSULTAIND_TLFNO1 & ", " &
                Globales.COL_CONSULTAIND_TLFNO2 & "=:" & Globales.COL_CONSULTAIND_TLFNO2 & ", " &
                Globales.COL_CONSULTAIND_EMAIL & "=:" & Globales.COL_CONSULTAIND_EMAIL,
                 Globales.COL_CONSULTAIND_NUMC & "=:" & Globales.COL_CONSULTAIND_NUMC & " AND " &
                                Globales.COL_CONSULTAIND_ANIO & "=:" & Globales.COL_CONSULTAIND_ANIO & " AND " &
                                Globales.COL_CONSULTAIND_NIND & "=:" & Globales.COL_CONSULTAIND_NIND & IIf(Not (String.IsNullOrEmpty(Me.Tenc)), " AND " &
                                Globales.COL_CONSULTAIND_TRIM & "=:" & Globales.COL_CONSULTAIND_TRIM, String.Empty))


                cmd(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_TLFNO1, OracleType.VarChar, ds.Tables(0).Rows(i)(Globales.COL_CONSULTAIND_TLFNO1))
                cmd(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_TLFNO2, OracleType.VarChar, ds.Tables(0).Rows(i)(Globales.COL_CONSULTAIND_TLFNO2))
                cmd(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_EMAIL, OracleType.VarChar, ds.Tables(0).Rows(i)(Globales.COL_CONSULTAIND_EMAIL))
                cmd(3) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, ds.Tables(0).Rows(i)(Globales.COL_CONSULTAIND_NUMC))
                cmd(4) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.Number, ds.Tables(0).Rows(i)(Globales.COL_CONSULTAIND_ANIO))
                cmd(5) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NIND, OracleType.Number, ds.Tables(0).Rows(i)(Globales.COL_CONSULTAIND_NIND))
                If (Not String.IsNullOrEmpty(Me.Tenc)) Then
                    cmd(6) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_TRIM, OracleType.Number, ds.Tables(0).Rows(i)(Globales.COL_CONSULTAIND_TRIM))
                End If

                Me.EjecutarNoSQL(sql, CommandType.Text, cmd)
            Next

            Me.CerrarTransaccion()
        Catch ex As Exception
            Throw New ContactosException(Globales.EX_CONTACTO_ACTUALIZAR, ex.InnerException)
        Finally
            If bTransCreada Then
                Me.CancelarTransaccion()
            End If
        End Try
    End Sub


    Sub guardarDatos(ByVal ds As DataSet)
        Try
            Me.guardarDataSet(ds)
        Catch ex As Exception
            Throw New ResultException(Globales.EX_CONTACTO_ACTUALIZAR, ex.InnerException)
        End Try
    End Sub

#End Region
#End Region



End Class
