﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa los datos de contacto.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class ConContactos
    Inherits EntidadBase

#Region "VARIABLES"

    Public Enum TipoDatoVisualizar
        TrimActual
        TrimAnterior
    End Enum

    Private _dsDatos As DataSet
    Private _filtro As String = String.Empty
    Private _nombretablaope As String = String.Empty

    Private Const _aliasTablaIndividuos As String = "IND"
    Private Const _aliasTablaContactos As String = "CONT"

    Public Const ChangesColumnNumc As String = "numc"
    Public Const ChangesColumnAenc As String = "aenc"
    Public Const ChangesColumnTenc As String = "tenc"
    Public Const ChangesColumnfechahora As String = "fechahora"
    Public Const ChangesColumnPers As String = "pers"
    Public Const ChangesColumnrcont As String = "rcont"
    Public Const ChangesColumntlf1 As String = "tlf1"
    Public Const ChangesColumntlf2 As String = "tlf2"
    Public Const ChangesColumnobserv As String = "observ"

    Public Const ColumnNumc As String = Globales.COL_CONTACTOS_NUMC
    Public Const ColumnAenc As String = Globales.COL_CONTACTOS_ANIO
    Public Const ColumnTenc As String = Globales.COL_CONTACTOS_TRIM
    Public Const Columnfechahora As String = Globales.COL_CONTACTOS_FECHA
    Public Const ColumnPers As String = Globales.COL_CONTACTOS_CONT
    Public Const Columnrcont As String = Globales.COL_CONTACTOS_RCONT
    Public Const Columntlf1 As String = Globales.COL_CONTACTOS_TLFNO1
    Public Const Columntlf2 As String = Globales.COL_CONTACTOS_TLFNO2
    Public Const Columnobserv As String = Globales.COL_CONTACTOS_OBSER

#End Region

#Region "CONSTRUCTOR"
    Private _p1 As String

    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()

    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"

    Sub New(ByVal ope As String, ByVal numc As String, ByVal anio As String, ByVal trim As String)
        _nombretablaope = ope
        _numc = numc
        _aenc = anio
        _tenc = trim
    End Sub

    Sub New(ByVal ope As String, ByVal numc As String, ByVal anio As String, ByVal trim As String, ByVal controlTrim As Boolean, ByVal datVisualizar As TipoDatoVisualizar) 
        _nombretablaope = ope
        _numc = numc
        _aenc = anio
        _tenc = trim
        _controlTrim = controlTrim
        _tipoTrimVisualizar = datVisualizar
    End Sub

    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_CONTACTOS
        End Get
    End Property


    ''' <summary>
    ''' Obtener el nombre de la tabla de la operación
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public ReadOnly Property NombreTablasAux() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos & "," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCONT
        End Get
    End Property
#End Region

#Region "PROPIAS"


    Private _operacion As String
    Public Property Operacion() As String
        Get
            Return _nombretablaope
        End Get
        Set(ByVal value As String)
            _nombretablaope = value
        End Set
    End Property

    Private _numc As String
    Public Property Numc() As String
        Get
            Return _numc
        End Get
        Set(ByVal value As String)
            _numc = value
        End Set
    End Property

    Private _aenc As String
    Public Property Aenc() As String
        Get
            Return _aenc
        End Get
        Set(ByVal value As String)
            _aenc = value
        End Set
    End Property
    
    Private _tenc As String
    Public Property Tenc() As String
        Get
            Return _tenc
        End Get
        Set(ByVal value As String)
            _tenc = value
        End Set
    End Property

    Private _tipoTrimVisualizar As TipoDatoVisualizar
    Public Property TencVisualizar() As TipoDatoVisualizar
        Get
            Return _tipoTrimVisualizar
        End Get
        Set(ByVal value As TipoDatoVisualizar)
            _tipoTrimVisualizar = value
        End Set
    End Property

    Private _controlTrim As Boolean
    Public Property controlTrim() As Boolean
        Get
            Return _controlTrim
        End Get
        Set(ByVal value As Boolean)
            _controlTrim = value
        End Set
    End Property

#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = " TO_CHAR(" & Globales.COL_CONTACTOS_FECHA & ", 'dd/MM/YYYY HH24:mi') AS " & Globales.ALIAS_CONTACTOS_FECHA & "," & Globales.COL_CONTACTOS_FECHA & " ,DECODE(" & Globales.COL_CONSULTAIND_NOM & " || ' ' || " & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & Globales.COL_CONSULTAIND_APE2 & ",'  '," & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_CONT & "," & Globales.COL_CONSULTAIND_NOM & " || ' ' || " & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & Globales.COL_CONSULTAIND_APE2 & ") AS " & Globales.ALIAS_CONTACTOS_CONT
            strSelect = strSelect & ", " & Globales.COL_RESULTCONT_LITCAS & " AS " & Globales.ALIAS_CONTACTOS_RCONT & "," & Globales.COL_CONTACTOS_OBSER & " AS " & Globales.ALIAS_CONTACTOS_OBSER
            strSelect = strSelect & "," & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_TLFNO1 & " AS " & Globales.ALIAS_CONTACTOS_TLFNO1
            strSelect = strSelect & "," & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_TLFNO2 & " AS " & Globales.ALIAS_CONTACTOS_TLFNO2

            If Not (String.IsNullOrEmpty(_filtro)) Then
                _filtro = _filtro & " AND "
            End If


            _filtro = _filtro & " " & Globales.COL_RESULTCONT_ID & " (+)= " & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_RCONT
            _filtro = _filtro & " and " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC & " (+)= " & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_NUMC
            _filtro = _filtro & " and " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO & " (+)= " & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_ANIO
            If (Not IsNothing(Me.Tenc)) Then
                _filtro = _filtro & " and " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_TRIM & " (+)= " & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_TRIM
            End If

            _filtro = _filtro & " and " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NIND & " (+)= " & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_CONT



            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO_ORDER
            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla & " " & _aliasTablaContactos & "," & Me.NombreTablasAux, _filtro, Globales.COL_CONTACTOS_FECHA & " DESC")


            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dsDatos = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New ContactosException(Globales.EX_CONTACTO_CARGA, ex.InnerException)
        End Try
    End Sub

    Public Function CrearDsBaseContactos() As DataSet
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = " * "

            Dim strFiltro As String = Globales.COL_CONTACTOS_NUMC & " is null"

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _nombretablaope & Globales.C_TABLA_CONTACTOS, strFiltro)


            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            
                Return data
            
        Catch ex As Exception
            Throw New ContactosException(Globales.EX_CONTACTO_CARGA, ex.InnerException)
        End Try
    End Function




    Public Function GetDatos() As DataSet
        Try
            If Not String.IsNullOrEmpty(Me.Numc) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_NUMC & " = '" & Me.Numc & "'"
            End If
            If (Me.controlTrim) Then
                If (Me.TencVisualizar.Equals(TipoDatoVisualizar.TrimActual)) Then
                    If Not String.IsNullOrEmpty(Me.Aenc) Then
                        If Not String.IsNullOrEmpty(_filtro) Then
                            _filtro = _filtro & " AND "
                        End If
                        _filtro = _filtro & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_ANIO & " = " & Me.Aenc
                    End If
                    If Not String.IsNullOrEmpty(Me.Tenc) Then
                        If Not String.IsNullOrEmpty(_filtro) Then
                            _filtro = _filtro & " AND "
                        End If
                        _filtro = _filtro & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_TRIM & " = " & Me.Tenc
                    End If
                ElseIf (Me.TencVisualizar.Equals(TipoDatoVisualizar.TrimAnterior)) Then
                    Dim anioaux As String
                    Dim trimaux As String
                    If (Me.Tenc = "1") Then
                        anioaux = Me.Aenc - 1
                        trimaux = "4"
                    Else
                        anioaux = Me.Aenc
                        trimaux = Me.Tenc - 1
                    End If

                    If Not String.IsNullOrEmpty(anioaux) Then
                        If Not String.IsNullOrEmpty(_filtro) Then
                            _filtro = _filtro & " AND "
                        End If
                        _filtro = _filtro & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_ANIO & " = " & anioaux
                    End If
                    If Not String.IsNullOrEmpty(trimaux) Then
                        If Not String.IsNullOrEmpty(_filtro) Then
                            _filtro = _filtro & " AND "
                        End If
                        _filtro = _filtro & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_TRIM & " = " & trimaux
                    End If
                End If
            Else
                If Not String.IsNullOrEmpty(Me.Aenc) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_ANIO & " = " & Me.Aenc
                End If
                If Not String.IsNullOrEmpty(Me.Tenc) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & _aliasTablaContactos & "." & Globales.COL_CONTACTOS_TRIM & " = " & Me.Tenc
                End If
            End If
            Cargar()
            Return _dsDatos
        Catch ex As Exception
            Throw New ContactosException(Globales.EX_CONTACTO_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function ObtenerDatosContacto() As DataSet
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim strSelect As String = " * "

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT
            strQuery = String.Format(strQuery, strSelect, _nombretablaope & Globales.C_TABLA_CONTACTOS)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                If (data.Tables(0).Rows.Count > 0) Then
                    Return data
                End If
            End If
            Return data
        Catch ex As Exception
            Throw New ContactosException(Globales.EX_CONTACTO_CARGA, ex.InnerException)
        End Try
    End Function
    

    Public Sub InsertDatos(ByVal numc As String, ByVal aenc As String, ByVal tenc As String, ByVal fechahora As String, ByVal rcont As String, ByVal pers As String, _
                           ByVal tlf1 As String, ByVal tlf2 As String, ByVal observ As String)
        Try
            Dim strQuery As String = String.Format(Globales.Constantes.C_INSERT_CONTACTOS, _nombretablaope & Globales.C_TABLA_CONTACTOS)
            Dim colParams(8) As OracleParameter

            colParams(0) = Me.CrearParametroOracle(Globales.Constantes.COL_CONTACTOS_NUMC, OracleType.VarChar, numc)
            colParams(1) = Me.CrearParametroOracle(Globales.Constantes.COL_CONTACTOS_ANIO, OracleType.VarChar, aenc)
            colParams(2) = Me.CrearParametroOracle(Globales.Constantes.COL_CONTACTOS_TRIM, OracleType.VarChar, IIf(String.IsNullOrEmpty(tenc), DBNull.Value, tenc))
            colParams(3) = Me.CrearParametroOracle(Globales.Constantes.COL_CONTACTOS_FECHA, OracleType.DateTime, fechahora)
            colParams(4) = Me.CrearParametroOracle(Globales.Constantes.COL_CONTACTOS_RCONT, OracleType.VarChar, rcont)
            colParams(5) = Me.CrearParametroOracle(Globales.Constantes.COL_CONTACTOS_CONT, OracleType.VarChar, pers)
            colParams(6) = Me.CrearParametroOracle(Globales.Constantes.COL_CONTACTOS_TLFNO1, OracleType.VarChar, IIf(String.IsNullOrEmpty(tlf1), DBNull.Value, tlf1))
            colParams(7) = Me.CrearParametroOracle(Globales.Constantes.COL_CONTACTOS_TLFNO2, OracleType.VarChar, IIf(String.IsNullOrEmpty(tlf2), DBNull.Value, tlf2))
            colParams(8) = Me.CrearParametroOracle(Globales.Constantes.COL_CONTACTOS_OBSER, OracleType.VarChar, IIf(String.IsNullOrEmpty(observ), DBNull.Value, observ))

            Me.EjecutarNoSQL(strQuery, CommandType.Text, colParams)
            MyBase.Guardar()
            If (Not IsNothing(tenc)) Then
                Me.Tenc = tenc
                ActualizarRContactoViviendaAnioTrim()
            Else
                ActualizarRContactoVivienda()
            End If
        Catch ex As Exception
            Throw New ContactosException(Globales.EX_CONTACTO_INSERTAR, ex.InnerException)
        End Try
    End Sub


    Public Sub ActualizarRContactoVivienda()
        Dim bTransCreada As Boolean = False
        Try
            Dim sql As String
            Dim cmd(2) As OracleParameter

            If Me.Transaccion Is Nothing Then
                Me.CrearTransaccion()
                bTransCreada = True
            End If

            Dim rcont As String = Globales.RCONT_CONTACTO

            Me.AsignarTransaccion(Me)
            'Asignar método cumplimentación Web
            sql = String.Format(Globales.UPDATE_GENERICO, _nombretablaope & Globales.C_TABLA_VIVIENDA,
                                Globales.COL_CONSULTAVIV_RCONT & "=:" & Globales.COL_CONSULTAVIV_RCONT,
                                Globales.COL_CONSULTAVIV_NUMC & "=:" & Globales.COL_CONSULTAVIV_NUMC & " AND " &
                                Globales.COL_CONSULTAVIV_ANIO & "=:" & Globales.COL_CONSULTAVIV_ANIO)
            cmd(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, Me.Numc)
            cmd(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.Number, Me.Aenc)
            cmd(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_RCONT, OracleType.VarChar, Globales.RCONT_CONTACTO)
            Me.EjecutarNoSQL(sql, CommandType.Text, cmd)

            Me.CerrarTransaccion()
        Catch ex As Exception
            Throw New ContactosException(Globales.EX_CONTACTO_ACTUALIZAR, ex.InnerException)
        Finally
            If bTransCreada Then
                Me.CancelarTransaccion()
            End If
        End Try
    End Sub

    Public Sub ActualizarRContactoViviendaAnioTrim()
        Dim bTransCreada As Boolean = False
        Try
            Dim sql As String
            Dim cmd(3) As OracleParameter

            If Me.Transaccion Is Nothing Then
                Me.CrearTransaccion()
                bTransCreada = True
            End If

            Dim rcont As String = Globales.RCONT_CONTACTO

            Me.AsignarTransaccion(Me)
            'Asignar método cumplimentación Web
            sql = String.Format(Globales.UPDATE_GENERICO, _nombretablaope & Globales.C_TABLA_VIVIENDA,
                                Globales.COL_CONSULTAVIV_RCONT & "=:" & Globales.COL_CONSULTAVIV_RCONT,
                                Globales.COL_CONSULTAVIV_NUMC & "=:" & Globales.COL_CONSULTAVIV_NUMC & " AND " &
                                Globales.COL_CONSULTAVIV_ANIO & "=:" & Globales.COL_CONSULTAVIV_ANIO & " AND " &
                                Globales.COL_CONSULTAVIV_TRIM & "=:" & Globales.COL_CONSULTAVIV_TRIM)
            cmd(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, Me.Numc)
            cmd(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.Number, Me.Aenc)
            cmd(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_TRIM, OracleType.Number, IIf(String.IsNullOrEmpty(Me.Tenc), DBNull.Value, Me.Tenc))
            cmd(3) = Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_RCONT, OracleType.VarChar, Globales.RCONT_CONTACTO)
            Me.EjecutarNoSQL(sql, CommandType.Text, cmd)

            Me.CerrarTransaccion()
        Catch ex As Exception
            Throw New ContactosException(Globales.EX_CONTACTO_ACTUALIZAR, ex.InnerException)
        Finally
            If bTransCreada Then
                Me.CancelarTransaccion()
            End If
        End Try
    End Sub
     
#End Region


#End Region

    Sub GuardarDatos(ByVal dtAux As DataSet)
        Dim bTransCreada As Boolean = False
        Try
            If Me.Transaccion Is Nothing Then
                Me.CrearTransaccion()
                bTransCreada = True
            End If
            Me.AsignarTransaccion(Me)
            Me.GuardarDataSet(dtAux)
            Me.CerrarTransaccion()
        Catch ex As Exception
            Throw ex
        Finally
            If bTransCreada Then
                Me.CancelarTransaccion()
            End If
        End Try
    End Sub

    

    Function ExistenDuplicados(ByVal dtAux As DataSet) As String
        Try
            Dim stRowsErroneos As String = String.Empty
            Dim dtR As DataSet = ObtenerDatosContacto()
            'Se recorre los data
            If dtR IsNot Nothing AndAlso dtR.Tables.Count > 0 Then
                If (dtR.Tables(0).Rows.Count > 0) Then
                    Dim i As Integer = 1
                    For Each dtRow As DataRow In dtAux.Tables(0).Rows
                        Dim numcR As String = dtRow(Globales.COL_CONTACTOS_NUMC).ToString()
                        Dim aencR As String = dtRow(Globales.COL_CONTACTOS_ANIO).ToString()
                        Dim tencR As String = dtRow(Globales.COL_CONTACTOS_TRIM).ToString()
                        Dim fechaR As String = dtRow(Globales.COL_CONTACTOS_FECHA).ToString()
                        Dim dtSelectedRow As DataRow()
                        If (Not String.IsNullOrEmpty(tencR)) Then
                            dtSelectedRow = dtR.Tables(0).Select(Globales.COL_CONTACTOS_NUMC & " = '" & numcR & "' AND " & Globales.COL_CONTACTOS_ANIO & " = '" & aencR & "' AND " & Globales.COL_CONTACTOS_TRIM & " = '" & tencR & "' AND " & Globales.COL_CONTACTOS_FECHA & " = '" & fechaR & "'")
                        Else
                            dtSelectedRow = dtR.Tables(0).Select(Globales.COL_CONTACTOS_NUMC & " = '" & numcR & "' AND " & Globales.COL_CONTACTOS_ANIO & " = '" & aencR & "' AND " & Globales.COL_CONTACTOS_FECHA & " = '" & fechaR & "'")
                        End If

                        If (dtSelectedRow.Length > 0) Then
                            If (String.IsNullOrEmpty(stRowsErroneos)) Then
                                stRowsErroneos = stRowsErroneos & i
                            Else
                                stRowsErroneos = stRowsErroneos & " , " & i
                            End If
                        End If
                        i = i + 1
                    Next
                End If
            End If
            Return stRowsErroneos
        Catch ex As Exception
            Throw New ContactosException(Globales.EX_CONTACTO_CARGA, ex.InnerException)
        End Try
    End Function

End Class
