﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa los datos del colectivo.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class ConColectivo
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsDatos As DataSet
    Private _filtro As String = String.Empty
    Private _nombretablaope As String = String.Empty
    Private _idioma As String = Globales.C_IDIOMA_CASTELLANO

    Private Const _aliasTablaIndividuos As String = "IND"

    Public Const ColumnIndFam As String = Globales.ALIAS_CONSULTAIND_INDFAM
    Public Const ColumnIndEdad As String = Globales.ALIAS_CONSULTAIND_EDAD

#End Region

#Region "CONSTRUCTOR"
    Private _p1 As String

    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()

    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"

    Sub New(ByVal p1 As String, ByVal p2 As String, ByVal p3 As String, ByVal p4 As String)
        _nombretablaope = p1
        _numc = p2
        _anio = p3
        _idioma = p4
    End Sub

    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " " & _aliasTablaIndividuos
        End Get
    End Property


    ''' <summary>
    ''' Obtener el nombre de la tabla de la operación
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public ReadOnly Property NombreTablasAux() As String
        Get
            Return Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST & " A," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST & " B," & _
            Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_LUGARNAC & "," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_NACIONALIDAD & "," & _
             _nombretablaope & Globales.C_TABLA_INDIVIDUOS & " Z "
        End Get
    End Property
#End Region

#Region "PROPIAS"
   

    Private _operacion As String
    Public Property Operacion() As String
        Get
            Return _nombretablaope
        End Get
        Set(ByVal value As String)
            _nombretablaope = value
        End Set
    End Property

    Private _numc As String
    Public Property Numc() As String
        Get
            Return _numc
        End Get
        Set(ByVal value As String)
            _numc = value
        End Set
    End Property

    Private _anio As String
    Public Property Anio() As String
        Get
            Return _anio
        End Get
        Set(ByVal value As String)
            _anio = value
        End Set
    End Property

    Public ReadOnly Property ColumnaDescripcionNaci(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_NACIONALIDAD_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_NACIONALIDAD_LITEUS
            End If
            Return column
        End Get
    End Property

    Public ReadOnly Property ColumnaDescripcionLnac(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_LUGARNAC_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_LUGARNAC_LITEUS
            End If
            Return column
        End Get
    End Property

    Public ReadOnly Property ColumnaDescripcionRCuest(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_RESULTCUEST_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_RESULTCUEST_LITEUS
            End If
            Return column
        End Get
    End Property


    Public Property Idioma() As String
        Get
            Return _idioma
        End Get
        Set(ByVal value As String)
            _idioma = value
        End Set
    End Property

#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_SITA & " AS " & Globales.ALIAS_CONSULTAIND_SITA & "," & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NOM & " || ' ' || " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_APE2 & " AS " & Globales.ALIAS_CONSULTAIND_NOM
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_SEXO & " AS " & Globales.ALIAS_CONSULTAIND_SEXO & "," & "to_char(" & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_FNAC & ",'dd/MM/YYYY')" & " AS " & Globales.ALIAS_CONSULTAIND_FNAC & "," & ColumnaDescripcionLnac(Me.Idioma) & " AS " & Globales.ALIAS_CONSULTAIND_LNAC & "," & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_EDAD & " AS " & Globales.ALIAS_CONSULTAIND_EDAD & ","
            strSelect = strSelect & ColumnaDescripcionNaci(Me.Idioma) & " AS " & Globales.ALIAS_CONSULTAIND_NACI & "," & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDFAM & " AS " & Globales.ALIAS_CONSULTAIND_INDFAM & "," & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INDPER & " AS " & Globales.ALIAS_CONSULTAIND_INDPER & "," & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NIND & " AS " & Globales.ALIAS_CONSULTAIND_NIND & ",A." & ColumnaDescripcionRCuest(Me.Idioma) & " AS " & Globales.ALIAS_CONSULTAIND_NOMRFAM & ",B." & ColumnaDescripcionRCuest(Me.Idioma) & " AS " & Globales.ALIAS_CONSULTAIND_NOMRPER
            strSelect = strSelect & ",Z" & "." & Globales.COL_CONSULTAIND_NOM & " || ' ' || " & "Z." & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & "Z." & Globales.COL_CONSULTAIND_APE2 & " AS " & Globales.ALIAS_CONSULTAIND_NOMINFPER
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INFPER & " AS " & Globales.ALIAS_CONSULTAIND_INFPER
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_RPER & " AS " & Globales.ALIAS_CONSULTAIND_RPER
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_RFAM & " AS " & Globales.ALIAS_CONSULTAIND_RFAM
            strSelect = strSelect & ", " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_FORMFAM & " AS " & Globales.ALIAS_CONSULTAIND_FORMFAM

            If Not (String.IsNullOrEmpty(_filtro)) Then
                _filtro = _filtro & " AND "
            End If


            _filtro = _filtro & "A." & Globales.COL_RESULTCUEST_ID & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_RFAM
            _filtro = _filtro & " AND B." & Globales.COL_RESULTCUEST_ID & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_RPER
            _filtro = _filtro & " AND " & Globales.COL_LUGARNAC_ID & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_LNAC
            _filtro = _filtro & " AND " & Globales.COL_NACIONALIDAD_ID & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NACI
             _filtro = _filtro & " AND Z." & Globales.COL_CONSULTAIND_NUMC & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC
            _filtro = _filtro & " AND Z." & Globales.COL_CONSULTAIND_ANIO & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO
            _filtro = _filtro & " AND Z." & Globales.COL_CONSULTAIND_NIND & " (+)= " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_INFPER

            _filtro = _filtro & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NUMC & " =  '" & Me.Numc & "'"
            _filtro = _filtro & " AND " & _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio


            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO_ORDER
            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla & "," & Me.NombreTablasAux, _filtro, _aliasTablaIndividuos & "." & Globales.COL_CONSULTAIND_NIND)



            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dsDatos = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_COLECT_CARGA, ex.InnerException)
        End Try
    End Sub


    Public Function GetDatos() As DataSet
        Try
            Cargar()
            Return _dsDatos
        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_COLECT_CARGA, ex.InnerException)
        End Try
    End Function

#End Region


#End Region

    Sub guardarDatosInformantePer(ByVal htCambios As Hashtable)
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim strSelect As String = " * "

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & " " & Globales.COL_CONSULTAIND_NUMC & " =  '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _nombretablaope & Globales.C_TABLA_INDIVIDUOS, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data

            Dim drSelectedRow() As DataRow
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                If (data.Tables(0).Rows.Count > 0) Then
                    For Each e As DictionaryEntry In htCambios
                        drSelectedRow = data.Tables(0).Select(Globales.COL_CONSULTAIND_NIND & " = '" & e.Key & "'")
                        'inicializamos el indicador de persona seleccionado para el personal
                        drSelectedRow(0)(Globales.COL_CONSULTAIND_INFPER) = e.Value
                    Next
                    Me.GuardarDataSet(data)
                End If
            End If

        Catch ex As Exception
            Throw ex
        End Try
    End Sub


    Public Function ObtenerIdiomaCFam() As String
        Try
            Dim Result As String = ""
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim strSelect As String = Globales.COL_CUESTIONARIO_IDIOMA

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & " " & Globales.COL_CONSULTAIND_NUMC & " = '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio 

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me.Operacion & Globales.C_TABLA_CUESTIONARIOFAM, _filtroAux) 'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                If (data.Tables(0).Rows.Count > 0) Then
                    Result = IIf(IsDBNull(data.Tables(0).Rows(0)(Globales.COL_CUESTIONARIO_IDIOMA)), String.Empty, data.Tables(0).Rows(0)(Globales.COL_CUESTIONARIO_IDIOMA))
                End If
            End If
            Return Result
        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_COLECT_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function ObtenerIdiomaCInd() As String
        Try
            Dim Result As String = ""
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim strSelect As String = Globales.COL_CUESTIONARIO_IDIOMA

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & " " & Globales.COL_CONSULTAIND_NUMC & " = '" & Me.Numc & "'"
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_ANIO & " = " & Me.Anio 

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me.Operacion & Globales.C_TABLA_CUESTIONARIOIND, _filtroAux) 'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                If (data.Tables(0).Rows.Count > 0) Then
                    Result = IIf(IsDBNull(data.Tables(0).Rows(0)(Globales.COL_CUESTIONARIO_IDIOMA)), String.Empty, data.Tables(0).Rows(0)(Globales.COL_CUESTIONARIO_IDIOMA))
                End If
            End If
            Return Result
        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_COLECT_CARGA, ex.InnerException)
        End Try
    End Function



End Class
