﻿Namespace Globales
    ''' <summary>
    ''' Metodos globales.
    ''' </summary>
    ''' <remarks></remarks>
    Module Metodos
        ''' <summary>
        ''' Obtener Valor de un DataRow.
        ''' </summary>
        ''' <param name="data">DataRow desde el que se quiere obtener el valor.</param>
        ''' <param name="column">Nombre de la columna en el DataRow que representa el valor del dato a obtener.</param>
        ''' <param name="defaultValue">Valor por defecto en caso de que no se recupere nada.</param>
        ''' <returns>Devuelve el valor del dato recuperado del DataRow o su valor por defecto si no existe tal valor.</returns>
        ''' <remarks></remarks>
        Public Function ObtenerValor(ByVal data As DataRow, ByVal column As String, ByVal defaultValue As Object) As Object
            Dim objValue As Object = defaultValue
            If data.Table.Columns.Contains(column) AndAlso Not data.IsNull(column) Then
                objValue = data(column)
            End If
            Return objValue
        End Function

        ''' <summary>
        ''' Formatear fecha a un formato especifico para BBDD.
        ''' </summary>
        ''' <param name="fecha">String que representa una fecha.</param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function FormatearFecha(ByVal fecha As String) As String
            If String.IsNullOrEmpty(fecha) Then
                Return String.Empty
            Else
                Dim dt As Date
                If Date.TryParse(fecha, dt) Then
                    Return dt.ToString("dd/MM/yyyy")
                Else
                    Return String.Empty
                End If
            End If
        End Function
    End Module
End Namespace
