﻿Namespace Globales
    ''' <summary>
    ''' Constantes de Base de Datos utilizadas para formar las sentencias.
    ''' </summary>
    ''' <remarks></remarks>
    Public Module Constantes

#Region "Tipos de Traza"
        Public Const TIPOTRAZA_APLICATION As Integer = 1
        Public Const TIPOTRAZA_SESION As Integer = 2
        Public Const TIPOTRAZA_REQUEST As Integer = 3
        Public Const TIPOTRAZA_CLASE As Integer = 4
#End Region

#Region "LANGUAGE"
        Friend Const C_LCID_EUSKERA As Integer = 1069
        Friend Const C_LCID_CASTELLANO As Integer = 1034
        Public Const C_IDIOMA_EUSKERA As String = "eu-ES"
        Public Const C_IDIOMA_CASTELLANO As String = "es-ES"

        Public Const C_ELIJA_CAS As String = "Elija"
        Public Const C_ELIJA_EUS As String = "Aukera"
#End Region

#Region "TABLES"


        Friend Const C_TABLA_MUESTRA = "01T00"

        Friend Const C_TABLA_VIVIENDA = "01T00"
        Friend Const C_TABLA_INDIVIDUOS = "02T00"
        'GEDW
        Friend Const C_TABLA_USUARIOS = "01T00"
        Friend Const C_TABLA_USUARIOS_OPE As String = "02T00"
        Friend Const C_TABLA_CONTACTOS As String = "03T00"

        Friend Const C_TABLA_GSITIOSWEB = "05T00"
        Friend Const C_TABLA_SITWEB = "05T01"
        Friend Const C_TABLA_TIPOWEB = "05T02"

        Friend Const C_TABLA_GBUSCADOR = "06T00"
        Friend Const C_TABLA_BUSQ = "06T01"



        Friend Const C_TABLA_SITUACION As String = "60T00"
        Friend Const C_TABLA_RESULTVIV As String = "61T00"
        Friend Const C_TABLA_RESULTVIV_OPE As String = "61T01"
        Friend Const C_TABLA_RESULTCONT As String = "62T00"
        Friend Const C_TABLA_RESULTCUEST As String = "63T00"
        Friend Const C_TABLA_RESULTCUEST_OPE As String = "63T01"
        Friend Const C_TABLA_LUGARNAC As String = "64T00"
        Friend Const C_TABLA_NACIONALIDAD As String = "65T00"
        Friend Const C_TABLA_FORMACUMPLIMENTACION As String = "66T00"
        Friend Const C_TABLA_EXCELOPE As String = "69T00"
        Friend Const C_TABLA_LOTES As String = "70T00"
        Friend Const C_TABLA_DESCARGAS_MUESTRA As String = "71T00"

        Friend Const C_TABLA_CUESTIONARIO = "11T00"
        Friend Const C_TABLA_CUESTIONARIOFAM = "11T00"
        Friend Const C_TABLA_CUESTIONARIOFAMNODOS = "12T00"
        Friend Const C_TABLA_CUESTIONARIOIND = "11T01"
        Friend Const C_TABLA_CUESTIONARIOHIJOS = "12T01"
        Friend Const C_TABLA_ENCUESTA = "88T00"
        Friend Const C_TABLA_CABECERA As String = "91T00"




        Friend Const C_TABLA_SSOC = "15T00"
        Friend Const C_TABLA_LANBIDE = "16T00"

        Friend Const C_TABLA_CODIFICACION = "19T00"

        Friend Const C_TABLA_CONTROLMES = "20T00"

        Friend Const C_TABLA_CONTROLTRIMESTRE = "21T00"

        Friend Const C_TABLA_TIPOERROR As String = "TIPOERROR"
        Friend Const C_TABLA_TIPOTRAZA As String = "TIPOTRAZA"

        Friend Const C_TABLA_PROVINCIAS As String = "PROVINCIAS"
        Friend Const C_TABLA_MUNICIPIOS As String = "MUNICIPIOS"
        Friend Const C_TABLA_COMARCAS As String = "COMARCAS"

        Friend Const C_TABLA_ERRORESVAL As String = "44T00"

        Friend Const C_TABLA_ACCESOS As String = "ACCESOS"

        Friend Const C_SEQ_ACCESOS As String = "SEQ_ACCESOS"

        Friend Const C_SEQ_DESCARGAS_MUESTRA As String = "SEQ_GEDW71T00"

        Friend Const C_TABLA_ERRCIERRE = "ERRORES_CIERRE"

        Friend Const C_TABLA_EBP = "EBPW.EBP_EBP"


        Friend Const C_TABLA_VALIDACION = "07T00"
        Friend Const C_TABLA_LITERALESNOCOD = "LITERALES_NOCODIFICADOS"

#End Region

#Region "COLUMNS"
        Friend Const COL_NUMC As String = "NUMC"
        Friend Const COL_MOD As String = "_M"

#Region "TABLE MUESTRA"
#Region "ESTABLECIMIENTO"
        Friend Const COL_MUESTRA_EST_NOMBRE As String = "EST_NOMBRE"
        Friend Const COL_MUESTRA_EST_DIRECCION As String = "EST_DIRECCION"
        Friend Const COL_MUESTRA_EST_PROVINCIA As String = "EST_PROVINCIA"
        Friend Const COL_MUESTRA_EST_MUNICIPIO As String = "EST_MUNICIPIO"
        Friend Const COL_MUESTRA_EST_CP As String = "EST_CP"
        Friend Const COL_MUESTRA_EST_TELEFONO As String = "EST_TELEFONO"
        Friend Const COL_MUESTRA_EST_FAX As String = "EST_FAX"
        Friend Const COL_MUESTRA_EST_EMAIL As String = "EST_EMAIL"
#End Region

#Region "EMPRESA"
        Friend Const COL_MUESTRA_EMP_CIF As String = "EMP_CIF"
        Friend Const COL_MUESTRA_EMP_PROPIETARIO As String = "EMP_PROPIETARIO"
        Friend Const COL_MUESTRA_EMP_DIRECCION As String = "EMP_DIRECCION"
        Friend Const COL_MUESTRA_EMP_PROVINCIA As String = "EMP_PROVINCIA"
        Friend Const COL_MUESTRA_EMP_MUNICIPIO As String = "EMP_MUNICIPIO"
        Friend Const COL_MUESTRA_EMP_CP As String = "EMP_CP"
        Friend Const COL_MUESTRA_EMP_TELEFONO As String = "EMP_TELEFONO"
        Friend Const COL_MUESTRA_EMP_FAX As String = "EMP_FAX"
        Friend Const COL_MUESTRA_EMP_URL As String = "EMP_URL"
        Friend Const COL_MUESTRA_EMP_EMAIL As String = "EMP_EMAIL"
#End Region

#Region "PERSONA"
        Friend Const COL_MUESTRA_PER_NOMBREAPELLIDOS As String = "PER_NOMBREAPELLIDOS"
        Friend Const COL_MUESTRA_PER_CARGO As String = "PER_CARGO"
        Friend Const COL_MUESTRA_PER_TELEFONO As String = "PER_TELEFONO"
        Friend Const COL_MUESTRA_PER_EMAIL As String = "PER_EMAIL"
#End Region
#End Region



#Region "TABLE ENCUESTA"
        Friend Const COL_ENCUESTA_ID As String = "CTRL_ID_ENC"
        Friend Const COL_ENCUESTA_ABRVCAS As String = "CTRL_ABREVCAS"
        Friend Const COL_ENCUESTA_ABRVEUS As String = "CTRL_ABREVEUS"
        Friend Const COL_ENCUESTA_NOMCAS As String = "CTRL_NOMBRECAS"
        Friend Const COL_ENCUESTA_NOMEUS As String = "CTRL_NOMBREEUS"
        Friend Const COL_ENCUESTA_ERRCTRL As String = "CTRL_ERRORCONTROL"
        Friend Const COL_ENCUESTA_PIECAS As String = "CTRL_PIEPAGCAS"
        Friend Const COL_ENCUESTA_PIEEUS As String = "CTRL_PIEPAGEUS"
        Friend Const COL_ENCUESTA_EMAIL As String = "CTRL_CON_EMAIL"
        Friend Const COL_ENCUESTA_TFNO As String = "CTRL_CON_TFNO"
        Friend Const COL_ENCUESTA_FAX As String = "CTRL_CON_FAX"
        Friend Const COL_ENCUESTA_INFMETO As String = "CTRL_URL_INFMETO"
        Friend Const COL_ENCUESTA_INICIO As String = "CTRL_FEC_INICIO"
        Friend Const COL_ENCUESTA_FIN As String = "CTRL_FEC_FIN"
        Friend Const COL_ENCUESTA_DIASREV As String = "CTRL_DIAS_REV"
        Friend Const COL_ENCUESTA_ANOREF As String = "CTRL_ANOREF"
        Friend Const COL_ENCUESTA_DATOSCTRL As String = "CTRL_DATOS_CTRL"
        Friend Const COL_ENCUESTA_CTRLACCESO As String = "CTRL_ACCESO"
        Friend Const COL_ENCUESTA_CTRLTRAZAS As String = "CTRL_TRAZAS"

        Friend Const ALIAS_ENCUESTA_NOMCAS_COMP As String = "NOMBRECAS"
        Friend Const ALIAS_ENCUESTA_NOMEUS_COMP As String = "NOMBREEUS"
#End Region

#Region "TABLE CONTROL CUESTIONARIO"
        Friend Const COL_CUESTIONARIO_FECHAFIN As String = "FECHAFIN"
        Public Const COL_CUESTIONARIO_AGENTE As String = "AGENTE"
        Friend Const COL_CUESTIONARIO_FECHAFIN_AG As String = "FECHAFIN_AG"
        Public Const COL_CUESTIONARIO_DURACION As String = "DURACION"
        Public Const COL_CUESTIONARIO_DURACION_AG As String = "DURACION_AG"
        Public Const COL_CUESTIONARIO_COPIA As String = "COPIA"
        Public Const ALIAS_CUESTIONARIO_TIENE_COPIA As String = "TIENE_COPIA"
#End Region

#Region "TABLE CABECERA"
        Friend Const COL_CABECERA_CAB_ID As String = "CAB_ID"
        Friend Const COL_CABECERA_CAB_LITCAS As String = "CAB_LITCAS"
        Friend Const COL_CABECERA_CAB_LITEUS As String = "CAB_LITEUS"
        Friend Const COL_CABECERA_CAB_URL As String = "CAB_URL"

        Friend Const ALIAS_CAB_LITCAS As String = "NOMBRECAS"
        Friend Const ALIAS_CAB_LITEUS As String = "NOMBREEUS"
        Friend Const ALIAS_CAB_URL As String = "URL"
#End Region

#Region "TABLE USUARIOS"
        Friend Const COL_USU_USUARIO As String = "USUARIO"
        Friend Const COL_USU_CODUSU As String = "CODUSU"
#End Region

#Region "TABLE PROVINCIAS"
        Friend Const COL_PROV_ID As String = "PRO_PROV"
        Friend Const COL_PROV_NOMBRE As String = "PRO_DS_O"

        Public Const ALIAS_PROV_ID As String = "ID"
        Public Const ALIAS_PROV_NOMBRE As String = "NOMBRE"
#End Region

#Region "TABLE MUNICIPIOS"
        Public Const COL_MUN_ID As String = "MUN_MUNI"
        Public Const COL_MUN_PROVID As String = "MUN_PROV"
        Friend Const COL_MUN_NOMBRE As String = "MUN_DS_O"
        Public Const COL_MUN_COMR As String = "MUN_COMR"

        Public Const ALIAS_MUN_ID As String = "ID"
        Public Const ALIAS_MUN_PROVID As String = "ID_PROV"
        Public Const ALIAS_MUN_NOMBRE As String = "NOMBRE"
        Public Const ALIAS_MUN_COMR As String = "ID_COM"
#End Region

#Region "TABLE COMARCAS"
        Public Const COL_COM_PROV As String = "COM_PROV"
        Public Const COL_COM_COMR As String = "COM_COMR"
        Public Const COL_COM_NOMBRE As String = "COM_DS_O"
        Friend Const COL_COM_NOMBREEUS As String = "COM_DS_E"
        Friend Const COL_COM_NOMBRECAS As String = "COM_DS_C"


        Friend Const ALIAS_COM_PROV As String = "COM_PROV"
        Friend Const ALIAS_COM_NOMBRE As String = "COM_DS_O"
        Friend Const ALIAS_COM_COMR As String = "COM_COMR"
#End Region

#Region "TABLE TIPO ERROR"
        Friend Const COL_ERROR_ID As String = "TipoError"
        Friend Const COL_ERROR_DESC As String = "Descripcion"

        Friend Const ALIAS_ERROR_ID As String = "TipoErr"
        Friend Const ALIAS_ERROR_DESC As String = "DescErr"
#End Region

#Region "TABLE TIPO TRAZA"
        Friend Const COL_TIPOTRAZA_ID As String = "TipoTraza"
        Friend Const COL_TIPOTRAZA_DESC As String = "Descripcion"

        Friend Const ALIAS_TIPOTRAZA_ID As String = "TipoAcc"
        Friend Const ALIAS_TIPOTRAZA_DESC As String = "DescAcc"
#End Region

#Region "TABLE ACCESOS"
        Friend Const COL_ACCESO_IDACCESO As String = "IDACCESO"
        Friend Const COL_ACCESO_FECHA As String = "FECHA"
        Friend Const COL_ACCESO_ENCUESTA As String = "ENCUESTA"
        Friend Const COL_ACCESO_NUMC As String = "NUMC"
        Friend Const COL_ACCESO_TIPOERROR As String = "TIPOERROR"
        Friend Const COL_ACCESO_TIPOACCESO As String = "TIPOACCESO"
        Friend Const COL_ACCESO_ORIGEN As String = "ORIGEN"
        Friend Const COL_ACCESO_TIPOENTRADA As String = "TIPOENTRADA"
        Friend Const COL_ACCESO_USUARIO As String = "USUARIO"
        Friend Const COL_ACCESO_DETALLETECNICO As String = "DETALLETECNICO"
        Friend Const COL_ACCESO_AGENTE As String = "AGENTE"
        Friend Const COL_ACCESO_TIPOTRAZA As String = "TIPOTRAZA"
        Friend Const COL_ACCESO_DATOS As String = "DATOS"
        Friend Const COL_ACCESO_NAVEGADOR As String = "NAVEGADOR"
        Friend Const COL_ACCESO_IP As String = "IP"
        Friend Const COL_ACCESO_SESION As String = "SESION"
        Friend Const COL_ACCESO_PLATAFORMA As String = "PLATAFORMA"
        Friend Const COL_ACCESO_IDIOMA As String = "IDIOMA"
        Friend Const COL_ACCESO_FUNCION As String = "FUNCION"
        Friend Const COL_ACCESO_NIF As String = "NIF"
        Friend Const COL_MAX As String = "MAX_ID"

        Friend Const ALIAS_ACCESO_IDACCESO As String = "IDACCESO"
        Friend Const ALIAS_ACCESO_FECHA As String = "FECHA"
        Friend Const ALIAS_ACCESO_ENCUESTA As String = "ENCUESTA"
        Friend Const ALIAS_ACCESO_NUMC As String = "NUMC"
        Friend Const ALIAS_ACCESO_TIPOERROR As String = "TIPOERROR"
        Friend Const ALIAS_ACCESO_ORIGEN As String = "ORIGEN"
        Friend Const ALIAS_ACCESO_DETALLETECNICO As String = "DETALLETECNICO"
        Friend Const ALIAS_ACCESO_AGENTE As String = "AGENTE"
        Friend Const ALIAS_ACCESO_TIPOTRAZA As String = "TIPOTRAZA"
        Friend Const ALIAS_ACCESO_DATOS As String = "DATOS"
        Friend Const ALIAS_ACCESO_NAVEGADOR As String = "NAVEGADOR"
        Friend Const ALIAS_ACCESO_IP As String = "IP"
        Friend Const ALIAS_ACCESO_SESION As String = "SESION"
        Friend Const ALIAS_ACCESO_PLATAFORMA As String = "PLATAFORMA"
        Friend Const ALIAS_ACCESO_IDIOMA As String = "IDIOMA"
        Friend Const ALIAS_ACCESO_FUNCION As String = "FUNCION"
#End Region

#Region "TABLE ERRORESVAL"
        Friend Const COL_ERRORESVAL_ID As String = "NUMC"
        Friend Const COL_ERRORESVAL_TIPO As String = "TIPO"
        Friend Const COL_ERRORESVAL_DESC As String = "T_ERROR"

        Friend Const ALIAS_ERRORESVAL_ID As String = "NUMC"
        Friend Const ALIAS_ERRORESVAL_TIPO As String = "TIPO"
        Friend Const ALIAS_ERRORESVAL_DESC As String = "T_ERROR"
#End Region


#Region "Table Codificacion"
        Friend Const COL_CODIFICACION_COD As String = "COD"
        Friend Const COL_CODIFICACION_LITERAL As String = "LITERAL"
        Friend Const COL_CODIFICACION_LITERALACT As String = "LITACT"
        Friend Const COL_CODIFICACION_TIPO As String = "TIPO"
        Friend Const COL_CODIFICACION_RAZON As String = "RAZON"
        Friend Const COL_CODIFICACION_ERROR As String = "ERROR"
#End Region

#Region "Table Control Apertura y Cierre Mes"
        Friend Const COL_CONTROLMES_AENC As String = "AENC"
        Friend Const COL_CONTROLMES_MES As String = "MES"
        Friend Const COL_CONTROLMES_FCIERRE As String = "FCIERRE"
        Friend Const COL_CONTROLMES_FAPERT As String = "FAPERT"
        Friend Const COL_CONTROLMES_AGENTE As String = "AGENTE"
        'params pl
        Friend Const COL_CONTROLMES_PAENC As String = "ANIO"
        Friend Const COL_CONTROLMES_PMES As String = "MES"

        'ERRORES_CIERRE
        Friend Const COL_ERRORCIERRE_TIPO As String = "TIPO"
        Friend Const COL_ERRORCIERRE_FECHA As String = "FECHA"
        Friend Const COL_ERRORCIERRE_ERROR As String = "ERROR"
        Friend Const COL_ERRORCIERRE_NUMC As String = "NUMC"
        Friend Const COL_ERRORCIERRE_AENC As String = "AENC"
        Friend Const COL_ERRORCIERRE_TRIM As String = "TRIM"


        Friend Const COL_CONTROLTRIM_AENC As String = "AENC"
        Friend Const COL_CONTROLTRIM_TENC As String = "TENC"
        Friend Const COL_CONTROLTRIM_FCIERRE As String = "FCIERRE"
        Friend Const COL_CONTROLTRIM_FAPERT As String = "FAPERT"
        Friend Const COL_CONTROLTRIM_AGENTE As String = "AGENTE"
        'GEDW

#Region "Table Usuarios"
        Public Const COL_USUARIOS_CODUSU As String = "CODUSU"
        Public Const COL_USUARIOS_NUMC As String = "NUMC"
        Friend Const COL_USUARIOS_PASS As String = "PASSWORD"
        Friend Const COL_USUARIOS_PERFIL As String = "PERFIL"
        Friend Const COL_USUARIOS_ACTIVO As String = "ACTIVO"
        Friend Const COL_USUARIOS_OPE As String = "CODOPE"
        Friend Const COL_USUARIOS_NOM As String = "NOMB"
        Friend Const COL_USUARIOS_APE1 As String = "APE1"
        Friend Const COL_USUARIOS_APE2 As String = "APE2"

        Friend Const ALIAS_USUARIOS_CODUSU As String = "USU_CODIGO"
        Friend Const ALIAS_USUARIOS_NUMC As String = "USU_NUMC"
        Friend Const ALIAS_USUARIOS_PASS As String = "USU_PASSWORD"
        Friend Const ALIAS_USUARIOS_PERFIL As String = "PERFIL"
        Friend Const ALIAS_USUARIOS_ACTIVO As String = "ACTIVO"
        Friend Const ALIAS_USUARIOS_OPE As String = "CODOPE"
        Public Const ALIAS_USUARIOS_NOMBRE As String = "NOMBRECOMP"
#End Region

#Region "TABLE SITUACION"
        Friend Const COL_SITUACION_ID As String = "CODSIT"
        Friend Const COL_SITUACION_LITCAS As String = "SIT_LITCAS"
        Friend Const COL_SITUACION_LITEUS As String = "SIT_LITEUS"

        Friend Const ALIAS_SITUACION_LITCAS As String = "NOMBRECAS"
        Friend Const ALIAS_SITUACION_LITEUS As String = "NOMBREEUS"
        Friend Const ALIAS_SITUACION_ID As String = "COD_SIT"
#End Region

#Region "TABLE MÉTODO CUMPLIMENTACIÓN"
        Friend Const COL_FORM_ID As String = "CODFORM"
        Friend Const COL_FORM_LITCAS As String = "FORM_LITCAS"
        Friend Const COL_FORM_LITEUS As String = "FORM_LITEUS"

        Friend Const ALIAS_FORM_LITCAS As String = "NOMBRECAS"
        Friend Const ALIAS_FORM_LITEUS As String = "NOMBREEUS"
        Friend Const ALIAS_FORM_ID As String = "COD_FORM"
#End Region

#Region "TABLE RESULTADO VIVIENDA"
        Friend Const COL_RESULTVIV_ID As String = "CODRVIV"
        Friend Const COL_RESULTVIV_LITCAS As String = "RVIV_LITCAS"
        Friend Const COL_RESULTVIV_LITEUS As String = "RVIV_LITEUS"

        Friend Const ALIAS_RESULTVIV_LITCAS As String = "NOMBRECAS"
        Friend Const ALIAS_RESULTVIV_LITEUS As String = "NOMBREEUS"
        Friend Const ALIAS_RESULTVIV_ID As String = "COD_RVIV"
#End Region

#Region "TABLE RESULTADO VIVIENDA OPERACIÓN"
        Friend Const COL_RESULTVIVOPE_CODRVIV As String = "RVIVOPE_CODRVIV"
        Friend Const COL_RESULTVIVOPE_CODOPE As String = "RVIVOPE_CODOPE"
#End Region

#Region "TABLE RESULTADO CONTACTO"
        Friend Const COL_RESULTCONT_ID As String = "CODRCON"
        Friend Const COL_RESULTCONT_LITCAS As String = "RCON_LITCAS"
        Friend Const COL_RESULTCONT_LITEUS As String = "RCON_LITEUS"

        Friend Const ALIAS_RESULTCONT_LITCAS As String = "NOMBRECAS"
        Friend Const ALIAS_RESULTCONT_LITEUS As String = "NOMBREEUS"
        Friend Const ALIAS_RESULTCONT_ID As String = "COD_RCON"
#End Region

#Region "TABLE RESULTADO CUESTIONARIO"
        Public Const COL_RESULTCUEST_ID As String = "CODRCUE"
        Public Const COL_RESULTCUEST_LITCAS As String = "RCUE_LITCAS"
        Public Const COL_RESULTCUEST_LITEUS As String = "RCUE_LITEUS"

        Friend Const ALIAS_RESULTCUEST_LITCAS As String = "NOMBRECAS"
        Friend Const ALIAS_RESULTCUEST_LITEUS As String = "NOMBREEUS"
        Friend Const ALIAS_RESULTCUEST_ID As String = "COD_RCUE"
#End Region


#Region "TABLE RESULTADO CUESTIONARIO OPERACIÓN"
        Friend Const COL_RESULTCUESTOPE_CODRCUEST As String = "RCUESTOPE_CODRCUEST"
        Friend Const COL_RESULTCUESTOPE_CODOPE As String = "RCUESTOPE_CODOPE"
#End Region

#Region "TABLE LUGARES DE NACIMIENTO"
        Friend Const COL_LUGARNAC_ID As String = "CODLNAC"
        Friend Const COL_LUGARNAC_LITCAS As String = "LNAC_LITCAS"
        Friend Const COL_LUGARNAC_LITEUS As String = "LNAC_LITEUS"

        Friend Const ALIAS_LUGARNAC_LITCAS As String = "LNAC_NOMBRECAS"
        Friend Const ALIAS_LUGARNAC_LITEUS As String = "LNAC_NOMBREEUS"
        Friend Const ALIAS_LUGARNAC_ID As String = "LNAC_COD"
#End Region


#Region "TABLE NACIONALIDAD"
        Friend Const COL_NACIONALIDAD_ID As String = "CODNACI"
        Friend Const COL_NACIONALIDAD_LITCAS As String = "NACI_LITCAS"
        Friend Const COL_NACIONALIDAD_LITEUS As String = "NACI_LITEUS"

        Friend Const ALIAS_NACIONALIDAD_LITCAS As String = "NACI_NOMBRECAS"
        Friend Const ALIAS_NACIONALIDAD_LITEUS As String = "NACI_NOMBREEUS"
        Friend Const ALIAS_NACIONALIDAD_ID As String = "NACI_COD"
#End Region

#Region "TABLE CONSULTAVIVIENDA"
        Public Const COL_CONSULTAVIV_ANIO As String = "AENC"
        Public Const COL_CONSULTAVIV_TRIM As String = "TENC"
        Public Const COL_CONSULTAVIV_SEM As String = "SENC"
        Friend Const COL_CONSULTAVIV_MES As String = "MES"
        Public Const COL_CONSULTAVIV_NUMC As String = "NUMC"
        Public Const COL_CONSULTAVIV_TH As String = "TERH"
        Public Const COL_CONSULTAVIV_COM As String = "COM"
        Public Const COL_CONSULTAVIV_MUN As String = "MUNR"
        Friend Const COL_CONSULTAVIV_RVIV As String = "RESULT"
        Public Const COL_CONSULTAVIV_SIT As String = "SITUAC"
        Friend Const COL_CONSULTAVIV_IDEV As String = "IDEV"
        Friend Const COL_CONSULTAVIV_DIR As String = "DIREC"
        Friend Const COL_CONSULTAVIV_CP As String = "CODP"
        Public Const COL_CONSULTAVIV_NOMA As String = "NOMA"
        Friend Const COL_CONSULTAVIV_RCONT As String = "RCONT"
        Friend Const COL_CONSULTAVIV_LENTP As String = "LENTP"
        Friend Const COL_CONSULTAVIV_FECENC As String = "FECENC"
        Friend Const COL_CONSULTAVIV_TIPE As String = "TIPE"
        Friend Const COL_CONSULTAVIV_TFAM As String = "TFAM"
        Friend Const COL_CONSULTAVIV_TINDI As String = "TOTALINDI"
        Friend Const COL_CONSULTAVIV_PERN1 As String = "PERN1"
        Friend Const COL_CONSULTAVIV_PERN2 As String = "PERN2"
        Friend Const COL_CONSULTAVIV_MENOR As String = "MENOR"
        Friend Const COL_CONSULTAVIV_LOTE As String = "LOTE"
        Public Const COL_CONSULTAVIV_IC As String = "IC"
        Friend Const COL_CONSULTAVIV_IC_NOMBRE As String = "ICNOMBRE"
        Friend Const COL_CONSULTAVIV_IC_TLFNO As String = "ICTLFNO"
        Friend Const COL_CONSULTAVIV_IC_EMAIL As String = "ICEMAIL"
        Friend Const COL_CONSULTAVIV_IC_RELACION As String = "ICRELACION"
        Friend Const COL_CONSULTAVIV_IC_OBSERVACIONES As String = "ICOBSERVACIONES"
        Public Const COL_CONSULTAVIV_DURACION As String = "DURACION"
        Public Const COL_CONSULTAVIV_DURACION_AG As String = "DURACION_AG"
        Public Const COL_CONSULTAVIV_ESTRATO As String = "ESTRATO"
        Public Const COL_CONSULTAVIV_CAMBIODIR As String = "CAMBIODIR"
        Public Const COL_CONSULTAVIV_TVIV As String = "TVIV"

        Friend Const ALIAS_CONSULTAVIV_ANIO As String = "VIV_AENC"
        Public Const ALIAS_CONSULTAVIV_TRIM As String = "VIV_TENC"
        Public Const ALIAS_CONSULTAVIV_SEM As String = "VIV_SENC"
        Friend Const ALIAS_CONSULTAVIV_MES As String = "VIV_MES"
        Friend Const ALIAS_CONSULTAVIV_NUMC As String = "VIV_NUMC"
        Friend Const ALIAS_CONSULTAVIV_MUN As String = "VIV_MUN"
        Friend Const ALIAS_CONSULTAVIV_TH As String = "VIV_TH"
        Friend Const ALIAS_CONSULTAVIV_RVIV As String = "VIV_RES"
        Friend Const ALIAS_CONSULTAVIV_SIT As String = "VIV_SIT"
        Friend Const ALIAS_CONSULTAVIV_IDEV As String = "VIV_IDEV"
        Friend Const ALIAS_CONSULTAVIV_DIR As String = "VIV_DIREC"
        Friend Const ALIAS_CONSULTAVIV_CP As String = "VIV_CODP"
        Friend Const ALIAS_CONSULTAVIV_NOMA As String = "VIV_NOMA"
        Friend Const ALIAS_CONSULTAVIV_RCONT As String = "VIV_RCONT"
        Friend Const ALIAS_CONSULTAVIV_FECENC As String = "VIV_FECENC"
        Friend Const ALIAS_CONSULTAVIV_TFAM As String = "VIV_NFAM"
        Friend Const ALIAS_CONSULTAVIV_MENOR As String = "VIV_MEN"
        Friend Const ALIAS_CONSULTAVIV_NENC As String = "VIV_NUMIND"
        Public Const ALIAS_CONSULTAVIV_IC As String = "VIV_IC"
        Friend Const ALIAS_CONSULTAVIV_IC_NOMBRE As String = "VIV_ICNOMBRE"
        Friend Const ALIAS_CONSULTAVIV_IC_TLFNO As String = "VIV_ICTLFNO"
        Friend Const ALIAS_CONSULTAVIV_IC_EMAIL As String = "VIV_ICEMAIL"
        Friend Const ALIAS_CONSULTAVIV_IC_RELACION As String = "VIV_ICRELACION"
        Friend Const ALIAS_CONSULTAVIV_IC_OBSERVACIONES As String = "VIV_ICOBSERVACIONES"
        Friend Const COL_CONSULTAVIV_TURN As String = "TURN"
        Friend Const COL_CONSULTAVIV_NORE As String = "NORE"

        Friend Const COL_CONSULTAVIV_DEFCOLEC As String = "DEFCOLEC"
        Friend Const COL_CONSULTAVIV_MATR As String = "MATR"
        Friend Const COL_CONSULTAVIV_PHIJ As String = "PHIJ"
        Friend Const COL_CONSULTAVIV_MHIJ As String = "MHIJ"
        Friend Const COL_CONSULTAVIV_OTRO As String = "OTRO"

        Friend Const COL_CONSULTAVIV_FREF As String = "FREF"
        Friend Const COL_CONSULTAVIV_SREF_DIAINI As String = "DINI"
        Friend Const COL_CONSULTAVIV_SREF_DIAFIN As String = "DFIN"


#End Region

#Region "TABLE CONSULTAINDIVIDUOS"

        Friend Const COL_CONSULTAIND_ANIO As String = "AENC"
        Friend Const COL_CONSULTAIND_NUMC As String = "NUMC"
        Friend Const COL_CONSULTAIND_NIND As String = "NIND"
        Friend Const COL_CONSULTAIND_SITA As String = "SITA"
        Friend Const COL_CONSULTAIND_FNAC As String = "FNAC"
        Friend Const COL_CONSULTAIND_EDAD As String = "EDAD"
        Friend Const COL_CONSULTAIND_SEXO As String = "SEXO"
        Friend Const COL_CONSULTAIND_SENC As String = "SENC"
        Friend Const COL_CONSULTAIND_LNAC As String = "LNAC"
        Friend Const COL_CONSULTAIND_NACI As String = "NACI"
        Friend Const COL_CONSULTAIND_NOM As String = "NOMB"
        Friend Const COL_CONSULTAIND_APE1 As String = "APE1"
        Friend Const COL_CONSULTAIND_APE2 As String = "APE2"
        Public Const COL_CONSULTAIND_FORMFAM As String = "FORMFAM"
        Public Const COL_CONSULTAIND_FORMPER As String = "FORMPER"
        Public Const COL_CONSULTAIND_INDFAM As String = "INDFAM"
        Public Const COL_CONSULTAIND_INDPER As String = "INDPER"
        Public Const COL_CONSULTAIND_INFPER As String = "INFPER"
        Public Const COL_CONSULTAIND_RPER As String = "RESPER"
        Friend Const COL_CONSULTAIND_RFAM As String = "RESFAM"
        Friend Const COL_CONSULTAIND_FREF As String = "FREF"
        Friend Const COL_CONSULTAIND_TRIM As String = "TENC"
        Friend Const COL_CONSULTAIND_TIPE As String = "TIPE"
        Friend Const COL_CONSULTAIND_TLFNO1 As String = "TLFNO1"
        Friend Const COL_CONSULTAIND_TLFNO2 As String = "TLFNO2"
        Friend Const COL_CONSULTAIND_EMAIL As String = "EMAIL"

        Friend Const COL_CONSULTAIND_LPROF1 As String = "LPROF1"
        Friend Const COL_CONSULTAIND_LPROF2 As String = "LPROF2"
        Friend Const COL_CONSULTAIND_LPROF3 As String = "LPROF3"
        Friend Const COL_CONSULTAIND_LPROF4 As String = "LPROF4"
        Friend Const COL_CONSULTAIND_PROF1 As String = "PROF1"
        Friend Const COL_CONSULTAIND_PROF2 As String = "PROF2"
        Friend Const COL_CONSULTAIND_PROF3 As String = "PROF3"
        Friend Const COL_CONSULTAIND_PROF4 As String = "PROF4"

        Friend Const COL_CONSULTAIND_LRACT1 As String = "LRACT1"
        Friend Const COL_CONSULTAIND_LRACT2 As String = "LRACT2"
        Friend Const COL_CONSULTAIND_LRACT3 As String = "LRACT3"
        Friend Const COL_CONSULTAIND_LRACT4 As String = "LRACT4"
        Friend Const COL_CONSULTAIND_RACT1 As String = "RACT1"
        Friend Const COL_CONSULTAIND_RACT2 As String = "RACT2"
        Friend Const COL_CONSULTAIND_RACT3 As String = "RACT3"
        Friend Const COL_CONSULTAIND_RACT4 As String = "RACT4"
        Friend Const COL_CONSULTAIND_RAZS1 As String = "RAZS1"
        Friend Const COL_CONSULTAIND_RAZS2 As String = "RAZS2"
        Friend Const COL_CONSULTAIND_RAZS3 As String = "RAZS3"
        Friend Const COL_CONSULTAIND_RAZS4 As String = "RAZS4"

        Friend Const COL_CONSULTAIND_SSOC As String = "SSOC"
        Friend Const COL_CONSULTAIND_LANBIDE As String = "LANBIDE"

        Friend Const COL_CONSULTAIND_OCUPA As String = "OCUPA"
        Friend Const COL_CONSULTAIND_ESTUD As String = "ESTUD"

        Friend Const ALIAS_CONSULTAIND_TENC As String = "IND_TENC"
        Friend Const ALIAS_CONSULTAIND_ANIO As String = "IND_AENC"
        Friend Const ALIAS_CONSULTAIND_NUMC As String = "IND_NUMC"
        Friend Const ALIAS_CONSULTAIND_NIND As String = "IND_NIND"
        Friend Const ALIAS_CONSULTAIND_SITA As String = "IND_SITA"
        Friend Const ALIAS_CONSULTAIND_FNAC As String = "IND_FNAC"
        Friend Const ALIAS_CONSULTAIND_EDAD As String = "IND_EDAD"
        Friend Const ALIAS_CONSULTAIND_SEXO As String = "IND_SEXO"
        Friend Const ALIAS_CONSULTAIND_LNAC As String = "IND_LNAC"
        Friend Const ALIAS_CONSULTAIND_FORMFAM As String = "IND_FORMFAM"
        Friend Const ALIAS_CONSULTAIND_FORMPER As String = "IND_FORMPER"
        Friend Const ALIAS_CONSULTAIND_NACI As String = "IND_NACI"
        Friend Const ALIAS_CONSULTAIND_NOM As String = "IND_NOMB"
        Friend Const ALIAS_CONSULTAIND_NOM_EDAD As String = "IND_NOMB_EDAD"
        Friend Const ALIAS_CONSULTAIND_APE1 As String = "IND_APE1"
        Friend Const ALIAS_CONSULTAIND_APE2 As String = "IND_APE2"
        Friend Const ALIAS_CONSULTAIND_INDFAM As String = "IND_INDFAM"
        Friend Const ALIAS_CONSULTAIND_INDPER As String = "IND_INDPER"
        Friend Const ALIAS_CONSULTAIND_INFPER As String = "IND_INFPER"
        Friend Const ALIAS_CONSULTAIND_NOMINFPER As String = "IND_NOMINFPER"
        Friend Const ALIAS_CONSULTAIND_RPER As String = "IND_RESPER"
        Friend Const ALIAS_CONSULTAIND_RFAM As String = "IND_RESFAM"
        Friend Const ALIAS_CONSULTAIND_NOMRPER As String = "IND_NOMRESPER"
        Friend Const ALIAS_CONSULTAIND_NOMRFAM As String = "IND_NOMRESFAM"

        Friend Const ALIAS_CONSULTAIND_AGENTEFAM As String = "IND_AGENTEFAM"
        Friend Const ALIAS_CONSULTAIND_AGENTEPER As String = "IND_AGENTEPER"
        Friend Const ALIAS_CONSULTAIND_FREF As String = "IND_FECREF"

        Friend Const ALIAS_CONSULTAIND_OCUPA As String = "IND_OCUPA"
        Friend Const ALIAS_CONSULTAIND_ESTUD As String = "IND_ESTUD"

        Friend Const ALIAS_CONSULTAIND_TLFNO1 As String = "IND_TLFNO1"
        Friend Const ALIAS_CONSULTAIND_TLFNO2 As String = "IND_TLFNO2"
        Friend Const ALIAS_CONSULTAIND_EMAIL As String = "IND_EMAIL"
#End Region

#Region "TABLE  SSOC"
        Friend Const COL_SSOC_NUMC = "NUMC"
        Friend Const COL_SSOC_NIND = "NIND"
        Friend Const COL_SSOC_ANIO = "ANIO"
        Friend Const COL_SSOC_TRIM = "TRIM"
        Friend Const COL_SSOC_ESTA = "ESTA_SSOC"
        Friend Const COL_SSOC_PPTR = "PPTR"
        Friend Const COL_SSOC_TIPRG = "TIPRG"
        Friend Const COL_SSOC_TCON = "TCON"
#End Region

#Region "TABLE  LANBIDE"
        Friend Const COL_LANBIDE_NUMC = "NUMC"
        Friend Const COL_LANBIDE_NIND = "NIND"
        Friend Const COL_LANBIDE_ANIO = "ANIO"
        Friend Const COL_LANBIDE_TRIM = "TRIM"
        Friend Const COL_LANBIDE_ESTA = "ESTA_LANB"
#End Region

#Region "TABLE CONTACTOS"
        Friend Const COL_CONTACTOS_NUMC As String = "NUMC"
        Friend Const COL_CONTACTOS_ANIO As String = "ANIO"
        Friend Const COL_CONTACTOS_TRIM As String = "TRIM"
        Friend Const COL_CONTACTOS_SEM As String = "SEM"
        Friend Const COL_CONTACTOS_FECHA As String = "FECHA"
        Friend Const COL_CONTACTOS_CONT As String = "CONTACTO"
        Friend Const COL_CONTACTOS_RCONT As String = "RCONT"
        Friend Const COL_CONTACTOS_PCONT As String = "PCONT"
        Friend Const COL_CONTACTOS_OBSER As String = "OBSERV"
        Friend Const COL_CONTACTOS_TLFNO1 As String = "TLFNO1"
        Friend Const COL_CONTACTOS_TLFNO2 As String = "TLFNO2"


        Friend Const ALIAS_CONTACTOS_NUMC As String = "CONT_NUMC"
        Friend Const ALIAS_CONTACTOS_ANIO As String = "CONT_ANIO"
        Friend Const ALIAS_CONTACTOS_TRIM As String = "CONT_TRIM"
        Friend Const ALIAS_CONTACTOS_SEM As String = "CONT_SEM"
        Friend Const ALIAS_CONTACTOS_FECHA As String = "CONT_FECHA"
        Friend Const ALIAS_CONTACTOS_CONT As String = "CONT_CONTACTO"
        Friend Const ALIAS_CONTACTOS_RCONT As String = "CONT_RCONT"
        Friend Const ALIAS_CONTACTOS_PCONT As String = "CONT_PCONT"
        Friend Const ALIAS_CONTACTOS_OBSER As String = "CONT_OBSERV"
        Friend Const ALIAS_CONTACTOS_TLFNO1 As String = "CONT_TLFNO1"
        Friend Const ALIAS_CONTACTOS_TLFNO2 As String = "CONT_TLFNO2"
#End Region

#Region "TABLE CUESTIONARIO"
        Public Const COL_CUESTFAM_IDIOMA As String = "IDIOMA"
        Friend Const COL_CUESTFAM_NUMC As String = "NUMC"
        Friend Const COL_CUESTIND_NUMC As String = "NUMC"
        Friend Const COL_CUESTFAM_AENC As String = "AENC"
        Friend Const COL_CUESTIND_AENC As String = "AENC"
        Friend Const COL_CUESTFAM_TENC As String = "TENC"
        Friend Const COL_CUESTIND_TENC As String = "TENC"
        Friend Const COL_CUESTIND_NIND As String = "NIND"
        Public Const COL_CUESTIONARIO_IDIOMA As String = "IDIOMA"
        Public Const COL_CUESTIONARIO_FECHAINICIO As String = "FECHAINICIO"

        Friend Const COL_CUESTIONARIO_ANIO As String = "AENC"
        Friend Const COL_CUESTIONARIO_TRIM As String = "TENC"
        Friend Const COL_CUESTIONARIO_NIND As String = "NIND"
        Friend Const COL_CUESTIONARIO_NUMC As String = "NUMC"
        Friend Const COL_CUESTIONARIO_EMPL As String = "EMPL"
        Friend Const COL_CUESTIONARIO_EMPOC As String = "EMPOC"
        Friend Const COL_CUESTIONARIO_AFAM As String = "AFAM"
        Friend Const COL_CUESTIONARIO_BUSQ As String = "BUSQ"
        Friend Const COL_CUESTIONARIO_GBUSQ As String = "GBUSQ"
        Friend Const COL_CUESTIONARIO_DISP As String = "DISP"
        Friend Const COL_CUESTIONARIO_LPROF1 As String = "LPROF1"
        Friend Const COL_CUESTIONARIO_LPROF2 As String = "LPROF2"
        Friend Const COL_CUESTIONARIO_LPROF3 As String = "LPROF3"
        Friend Const COL_CUESTIONARIO_LPROF4 As String = "LPROF4"
        Friend Const COL_CUESTIONARIO_PROF1 As String = "PROF1"
        Friend Const COL_CUESTIONARIO_PROF2 As String = "PROF2"
        Friend Const COL_CUESTIONARIO_PROF3 As String = "PROF3"
        Friend Const COL_CUESTIONARIO_PROF4 As String = "PROF4"
        Friend Const COL_CUESTIONARIO_LRACT1 As String = "LRACT1"
        Friend Const COL_CUESTIONARIO_LRACT2 As String = "LRACT2"
        Friend Const COL_CUESTIONARIO_LRACT3 As String = "LRACT3"
        Friend Const COL_CUESTIONARIO_LRACT4 As String = "LRACT4"
        Friend Const COL_CUESTIONARIO_RACT1 As String = "RACT1"
        Friend Const COL_CUESTIONARIO_RACT2 As String = "RACT2"
        Friend Const COL_CUESTIONARIO_RACT3 As String = "RACT3"
        Friend Const COL_CUESTIONARIO_RACT4 As String = "RACT4"

        Friend Const COL_CUESTIND_SIT1 = "SIT1"
        Friend Const COL_CUESTIND_SIT2 = "SIT2"
        Friend Const COL_CUESTIND_SIT3 = "SIT3"
        Friend Const COL_CUESTIND_SIT4 = "SIT4"
        Friend Const COL_CUESTIND_SIT5 = "SIT5"
        Friend Const COL_CUESTIND_VSIT1 = "VSIT1"
        Friend Const COL_CUESTIND_VSIT2 = "VSIT2"
        Friend Const COL_CUESTIND_VSIT3 = "VSIT3"
        Friend Const COL_CUESTIND_VSIT4 = "VSIT4"
        Friend Const COL_CUESTIND_VSIT5 = "VSIT5"
        Friend Const COL_CUESTIND_BUS1 = "BUS1"
        Friend Const COL_CUESTIND_BUS2 = "BUS2"
        Friend Const COL_CUESTIND_BUS3 = "BUS3"
        Friend Const COL_CUESTIND_BUS4 = "BUS4"
        Friend Const COL_CUESTIND_BUS5 = "BUS5"
        Friend Const COL_CUESTIND_VBUS1 = "VBUS1"
        Friend Const COL_CUESTIND_VBUS2 = "VBUS2"
        Friend Const COL_CUESTIND_VBUS3 = "VBUS3"
        Friend Const COL_CUESTIND_VBUS4 = "VBUS4"
        Friend Const COL_CUESTIND_VBUS5 = "VBUS5"
        Friend Const COL_CUESTIND_SIT = "SIT"
        Friend Const COL_CUESTIND_VSIT = "VSIT"
        Friend Const COL_CUESTIND_TIPWEB = "TIPWEB"
        Friend Const COL_CUESTIND_BUS = "BUS"
        Friend Const COL_CUESTIND_VBUS = "VBUS"

        Friend Const ALIAS_CUESTFAM_IDIOMA As String = "CUEST_IDIOMA"
        Friend Const ALIAS_CUESTFAM_NUMC As String = "CUESTF_NUMC"
        Friend Const ALIAS_CUESTIND_NUMC As String = "CUESTI_NUMC"
        Friend Const ALIAS_CUESTFAM_AENC As String = "CUESTF_AENC"
        Friend Const ALIAS_CUESTIND_AENC As String = "CUESTI_AENC"
#End Region

#End Region

#Region "TABLE VERIFICARSITIOS"
        Friend Const COL_CONSULTA_VERSIT_VALOR As String = "VALOR"
        Friend Const COL_CONSULTA_VERSIT_ANIO As String = "AENC"
        Friend Const COL_CONSULTA_VERSIT_TRIM As String = "TENC"
        Friend Const COL_CONSULTA_VERSIT_NUMC As String = "NUMC"
        Friend Const COL_CONSULTA_VERSIT_NIND As String = "NIND"
        Friend Const COL_CONSULTA_VERSIT_CAMPO As String = "CAMPO"
        Friend Const COL_CONSULTA_VERSIT_TIPO As String = "TIPO"
#End Region

#Region "TABLE VERIFICARBUSCADORES"
        Friend Const COL_CONSULTA_VERBUS_VALOR As String = "VALOR"
        Friend Const COL_CONSULTA_VERBUS_ANIO As String = "AENC"
        Friend Const COL_CONSULTA_VERBUS_TRIM As String = "TENC"
        Friend Const COL_CONSULTA_VERBUS_NUMC As String = "NUMC"
        Friend Const COL_CONSULTA_VERBUS_NIND As String = "NIND"
        Friend Const COL_CONSULTA_VERBUS_CAMPO As String = "CAMPO"
#End Region

#Region "TABLE VALIDACIONES"

        Public Const COL_VALIDACIONES_CODIGO As String = "VAL_CODIGO"
        Public Const COL_VALIDACIONES_TIPO As String = "VAL_TIPO"
        Public Const COL_VALIDACIONES_NIVEL As String = "VAL_NIVEL"
        Public Const COL_VALIDACIONES_DESC_CAS As String = "VAL_DESC_CAS"
        Public Const COL_VALIDACIONES_DESC_EUS As String = "VAL_DESC_EUS"
        Public Const COL_VALIDACIONES_DESC As String = "VAL_DESC"
        Public Const COL_VALIDACIONES_VALOR As String = "VAL_VALOR"
        Public Const COL_VALIDACIONES_VALORDES As String = "VAL_VALORDES"
        Public Const COL_VALIDACIONES_TABLA As String = "VAL_TABLA"
        Public Const COL_VALIDACIONES_LUGAR As String = "VAL_LUGAR"
        Public Const COL_VALIDACIONES_TABDES As String = "VAL_TABDES"
        Public Const COL_VALIDACIONES_PERFIL As String = "VAL_PERFIL"
        Public Const COL_VALIDACIONES_CUEST As String = "VAL_CUEST"
#End Region

#Region "TABLE GSITIOWEB"
        Friend Const COL_GSIT_CODIGO As String = "GSIT_COD"
        Friend Const COL_GSIT_DESC_CAS As String = "GSIT_DESC"
        Friend Const COL_GSIT_TWEB As String = "GSIT_TWEB"
#End Region

#Region "TABLE GBUSQ"
        Friend Const COL_GBUS_CODIGO As String = "GBUS_COD"
        Friend Const COL_GBUS_DESC_CAS As String = "GBUS_DESC"
#End Region

#Region "TABLE SITIOWEB"
        Friend Const COL_SIT_DESC_CAS As String = "AC1_SIT"
#End Region

#Region "TABLE SITIOWEB -ESIF"
        Friend Const COL_ESIF_TIPO_WEB_TIP_CODIGO As String = "TIP_CODIGO"
        Friend Const COL_ESIF_TIPO_WEB_TIP_DESC_CAS As String = "TIP_DESC_CAS"
        Friend Const COL_ESIF_TIPO_WEB_TIP_DESC_EUS As String = "TIP_DESC_EUS"
#End Region

#Region "TABLE BUSCADOR"
        Friend Const COL_BUS_DESC_CAS As String = "AC2_BUS"
#End Region

#Region "TABLA LITERALESNOCOD - ESIF"
        Public Const COL_LITERALESNOCOD_NUMC As String = "NUMC"
        Public Const COL_LITERALESNOCOD_NIND As String = "NIND"
        Public Const COL_LITERALESNOCOD_NOMBRE As String = "NOMBRE"
        Public Const COL_LITERALESNOCOD_EDAD As String = "EDAD"
        Public Const COL_LITERALESNOCOD_ESTUD As String = "ESTUD"
        Public Const COL_LITERALESNOCOD_OCUPA As String = "OCUPA"
        Public Const COL_LITERALESNOCOD_OPCION As String = "OPCION"
        Public Const COL_LITERALESNOCOD_CASILLA As String = "CASILLA"
        Public Const COL_LITERALESNOCOD_VALOR As String = "VALOR"
        Public Const COL_LITERALESNOCOD_ANIO As String = "ANIO"
        Public Const COL_LITERALESNOCOD_TRIMESTRE As String = "TRIMESTRE"
        Public Const COL_LITERALESNOCOD_SEMANA As String = "SEMANA"
        Public Const COL_LITERALESNOCOD_TERRI As String = "TERRI"
        Public Const COL_LITERALESNOCOD_TABLA As String = "TABLA"
        Public Const COL_LITERALESNOCOD_CAMPOIND As String = "CAMPOIND"
        Public Const COL_LITERALESNOCOD_CAMPOCOD As String = "CAMPOCOD"
        Public Const COL_LITERALESNOCOD_CAMPOLITERAL As String = "CAMPOLITERAL"
#End Region

#Region "TABLA LITERALES OTROS CODIFICADOS - ESIF"
        Public Const COL_LITERALESCODIFICADOS_ID As String = "ID"
        Public Const COL_LITERALESCODIFICADOS_DESCCAS As String = "DESC_CAS"
        Public Const COL_LITERALESCODIFICADOS_DESCEUS As String = "DESC_EUS"
        Public Const COL_LITERALESCODIFICADOS_CASILLA As String = "CASILLA"
        Public Const COL_LITERALESCODIFICADOS_CAMPO As String = "CAMPO"
        Public Const COL_LITERALESCODIFICADOS_VALOR As String = "VALOR"
        Public Const COL_LITERALESCODIFICADOS_MENOR As String = "MENOR"
        Public Const COL_LITERALESCODIFICADOS_OCUPA As String = "OCUPA"
        Public Const COL_LITERALESCODIFICADOS_ESTUD As String = "ESTUD"
#End Region

#Region "EMAFW"
        Public Const COL_CUESTIONARIO_FAM_ENERGIA_NUMC As String = "NUMC"
        Public Const COL_CUESTIONARIO_FAM_ENERGIA_AENC As String = "AENC"
        Public Const COL_CUESTIONARIO_FAM_ENERGIA_TENC As String = "TENC"

        Public Const COL_CUESTIONARIO_FAM_RESIDUOS_NUMC As String = "NUMC"
        Public Const COL_CUESTIONARIO_FAM_RESIDUOS_AENC As String = "AENC"
        Public Const COL_CUESTIONARIO_FAM_RESIDUOS_TENC As String = "TENC"

        Public Const COL_CUESTIONARIO_FAM_EQUIPAMIENTO_NUMC As String = "NUMC"
        Public Const COL_CUESTIONARIO_FAM_EQUIPAMIENTO_AENC As String = "AENC"
        Public Const COL_CUESTIONARIO_FAM_EQUIPAMIENTO_TENC As String = "TENC"

        Public Const COL_CUESTIONARIO_FAM_RUIDOS_OLORES_NUMC As String = "NUMC"
        Public Const COL_CUESTIONARIO_FAM_RUIDOS_OLORES_AENC As String = "AENC"
        Public Const COL_CUESTIONARIO_FAM_RUIDOS_OLORES_TENC As String = "TENC"

        Public Const COL_CUESTIONARIO_FAM_MOVILIDAD_NUMC As String = "NUMC"
        Public Const COL_CUESTIONARIO_FAM_MOVILIDAD_AENC As String = "AENC"
        Public Const COL_CUESTIONARIO_FAM_MOVILIDAD_TENC As String = "TENC"

        Public Const COL_CUESTIONARIO_FAM_VEHICULOS_NUMC As String = "NUMC"
        Public Const COL_CUESTIONARIO_FAM_VEHICULOS_AENC As String = "AENC"
        Public Const COL_CUESTIONARIO_FAM_VEHICULOS_TENC As String = "TENC"

#End Region
#End Region

#Region "TABLE OTROS"
        Friend Const COL_OTR_CODIGO As String = "OTR_CODIGO"
        Friend Const COL_OTR_DESC_C As String = "OTR_DESC_C"
        Friend Const COL_OTR_DESC_E As String = "OTR_DESC_E"
        Friend Const COL_OTR_CASILLA As String = "OTR_CASILLA"
#End Region

#Region "TABLE LOTES"
        Friend Const COL_CONSULTALOTE_LOTE As String = "LOTE"
        Friend Const COL_CONSULTALOTE_CODUSU As String = "CODUSU"
        Friend Const COL_CONSULTALOTE_CODOPE As String = "CODOPE"
#End Region

#Region "TABLE DESCARGAS MUESTRA"
        Friend Const COL_DESCARGAS_MUESTRA_IDDESCARGA As String = "IDDESCARGA"
        Friend Const COL_DESCARGAS_MUESTRA_OPERACION As String = "OPERACION"
        Friend Const COL_DESCARGAS_MUESTRA_ANIO As String = "AENC"
        Friend Const COL_DESCARGAS_MUESTRA_TRIMESTRE As String = "TENC"
        Friend Const COL_DESCARGAS_MUESTRA_SEMANA As String = "SENC"
        Friend Const COL_DESCARGAS_MUESTRA_FECHA As String = "FECHA"
        Friend Const COL_DESCARGAS_MUESTRA_NUMVIV As String = "NUMVIV"
        Friend Const COL_DESCARGAS_MUESTRA_NUMIND As String = "NUMIND"
        Friend Const COL_DESCARGAS_MUESTRA_CODUSUARIO As String = "CODUSU"
#End Region

#Region "TABLE EXCELOPE"
        Friend Const COL_CONSULTAEXCEL_CODOPE As String = "CODOPE"
        Public Const COL_CONSULTAEXCEL_NOMEXC As String = "NOMEXC"
#End Region

#Region "TABLE EBP"
        Friend Const COL_EBP_ORIGEN As String = "ORIG"
        Friend Const COL_EBP_NUMC As String = "NUMC"
        Friend Const COL_EBP_NIND As String = "NIND"
        Friend Const COL_EBP_AENC As String = "AENC"
        Friend Const COL_EBP_TENC As String = "TENC"
#End Region



#Region "SQL"
#Region "SELECT"
        Friend Const C_SELECT As String = "SELECT {0} FROM {1}"
        Friend Const C_SELECT_ORDER As String = "SELECT {0} FROM {1} ORDER BY {2}"
        Friend Const C_SELECT_ENCUESTA As String = "SELECT {0} FROM {1} WHERE " & COL_ENCUESTA_ID & " = :" & COL_ENCUESTA_ID
        Friend Const C_SELECT_MUNICIPIO As String = "SELECT {0} FROM {1} WHERE " & COL_MUN_PROVID & " = :" & COL_MUN_PROVID & " ORDER BY {2}"
        Friend Const C_SELECT_FILTRO_ORDER As String = "SELECT {0} FROM {1} WHERE {2} ORDER BY {3}"
        Friend Const C_SELECT_MAX As String = "SELECT NVL(MAX({0}),0) + 1 AS " & COL_MAX & " FROM {1}"
        Friend Const C_SELECT_NEXVAL As String = "SELECT {0}.NEXTVAL FROM DUAL"
        Friend Const C_SELECT_FILTRO As String = "SELECT {0} FROM {1} WHERE {2}"

        Friend Const C_SELECT_DIST_FILTRO As String = "SELECT DISTINCT {0} FROM {1} WHERE {2}"
        Friend Const C_SELECT_DIST_FILTRO_ORDER As String = "SELECT DISTINCT {0} FROM {1} WHERE {2} ORDER BY {3}"
        Friend Const C_SELECT_DIST_ORDER As String = "SELECT DISTINCT {0} FROM {1} ORDER BY {2}"
#End Region

#Region "INSERT"
        Friend Const C_INSERT_ERROR As String = "INSERT INTO {0}(" & COL_ACCESO_IDACCESO & ", " & COL_ACCESO_FECHA & _
        ", " & COL_ACCESO_ORIGEN & ", " & COL_ACCESO_DETALLETECNICO & ", " & COL_ACCESO_TIPOERROR & _
        ", " & COL_ACCESO_PLATAFORMA & ", " & COL_ACCESO_NAVEGADOR & ", " & COL_ACCESO_IP & _
        ", " & COL_ACCESO_ENCUESTA & ", " & COL_ACCESO_AGENTE & ", " & COL_ACCESO_USUARIO & _
        ", " & COL_ACCESO_NUMC & ", " & COL_ACCESO_DATOS & ", " & COL_ACCESO_IDIOMA & _
        ", " & COL_ACCESO_SESION & ", " & COL_ACCESO_TIPOTRAZA & ", " & COL_ACCESO_TIPOACCESO & _
        ", " & COL_ACCESO_TIPOENTRADA & ", " & COL_ACCESO_FUNCION & ", " & COL_ACCESO_NIF & _
        ") VALUES (:" & COL_ACCESO_IDACCESO & ", :" & COL_ACCESO_FECHA & _
        ", :" & COL_ACCESO_ORIGEN & ", :" & COL_ACCESO_DETALLETECNICO & ", :" & COL_ACCESO_TIPOERROR & _
        ", :" & COL_ACCESO_PLATAFORMA & ", :" & COL_ACCESO_NAVEGADOR & ", :" & COL_ACCESO_IP & _
        ", :" & COL_ACCESO_ENCUESTA & ", :" & COL_ACCESO_AGENTE & ", :" & COL_ACCESO_USUARIO & _
        ", :" & COL_ACCESO_NUMC & ", :" & COL_ACCESO_DATOS & ", :" & COL_ACCESO_IDIOMA & _
         ", :" & COL_ACCESO_SESION & ", :" & COL_ACCESO_TIPOTRAZA & ", :" & COL_ACCESO_TIPOACCESO & _
        ", :" & COL_ACCESO_TIPOENTRADA & ", :" & COL_ACCESO_FUNCION & ", :" & COL_ACCESO_NIF & ")"

        Friend Const C_INSERT_CONTACTOS As String = "INSERT INTO {0} ( " & _
           COL_CONTACTOS_NUMC & ", " & _
           COL_CONTACTOS_ANIO & ", " & _
           COL_CONTACTOS_TRIM & ", " & _
           COL_CONTACTOS_CONT & ", " & _
            COL_CONTACTOS_RCONT & ", " & _
            COL_CONTACTOS_FECHA & ", " & _
            COL_CONTACTOS_TLFNO1 & ", " & _
            COL_CONTACTOS_TLFNO2 & ", " & _
       COL_CONTACTOS_OBSER & ") " & _
       " VALUES (" & " :" & COL_CONTACTOS_NUMC & ", " & _
       " :" & COL_CONTACTOS_ANIO & ", " & _
        " :" & COL_CONTACTOS_TRIM & ", " & _
       " :" & COL_CONTACTOS_CONT & ", " & _
        " :" & COL_CONTACTOS_RCONT & ", " & _
         " :" & COL_CONTACTOS_FECHA & ", " & _
         " :" & COL_CONTACTOS_TLFNO1 & ", " & _
          " :" & COL_CONTACTOS_TLFNO2 & ", " & _
           " :" & COL_CONTACTOS_OBSER & ") "

        Friend Const C_INSERT As String = "INSERT INTO {0} ({1}) VALUES ({2})"

#End Region

#Region "DELETE"

        Friend Const DELETE_CODIFICACION As String = "DELETE FROM {0} WHERE TIPO = :TIPO"
#End Region

#Region "UPDATE"
#Region "General"
        Friend Const UPDATE_GENERICO As String = "UPDATE {0} SET {1} WHERE {2}"
#End Region

#End Region
#End Region

#Region "EXCEPTION"
        Friend Const EX_CABECERA_NOMBRE = "No se ha podido resolver el nombre de cabecera para el idioma actual."
        Friend Const EX_CABECERA_CARGA = "No se ha podido cargar la cabecera o alguno de sus elementos."
        Friend Const EX_CABECERA_BBDD = "No se ha podido instanciar la información de base de datos para cabecera."

        Friend Const EX_ENCUESTA_CARGA = "No se ha podido cargar la encuesta o alguno de sus elementos."
        Friend Const EX_ENCUESTA_BBDD = "No se ha podido instanciar la información de base de datos para encuesta."
        Friend Const EX_ENCUESTA_DATOSCTRL = "No se han podido cargar los datos de control de la encuesta."

        Friend Const EX_MUESTRA_CARGA = "No se ha podido cargar la muestra o alguno de sus elementos."
        Friend Const EX_MUESTRA_ACTUALIZAR = "No se han podido guardar los cambios especificados de la muestra en base de datos."

        Friend Const EX_CUESTIONARIO_CARGA = "No se ha podido cargar el cuestionario o alguno de sus elementos."
        Friend Const EX_CUESTIONARIO_ACTUALIZAR = "No se han podido guardar los cambios especificados en base de datos."
        Friend Const EX_CUESTIONARIO_BBDD = "No se ha podido instanciar la información de base de datos para cuestionario."

        Friend Const EX_PROVINCIA = "No se ha podido instanciar la información de base de datos para provincias."
        Friend Const EX_MUNICIPIO = "No se ha podido instanciar la información de base de datos para municipios."

        Friend Const EX_TIPOERROR = "No se ha podido instanciar la información de base de datos para tipo de error."
        Friend Const EX_TIPOTRAZA = "No se ha podido instanciar la información de base de datos para tipo de acceso."

        Friend Const EX_ACCESOS = "No se ha podido instanciar la información de base de datos para accesos."

        Friend Const EX_ANIOS_CARGA = "No se ha podido cargar la información de años."

        Friend Const EX_TRIM_CARGA = "No se ha podido cargar la información de trimestres."

        Friend Const EX_SEM_CARGA = "No se ha podido cargar la información de semanas."

        Friend Const EX_CAMPGEN_CARGA = "No se ha podido cargar la información de campos generales."

        Friend Const EX_CONTROLUSU_CARGA = "No se ha podido cargar la información de control de usuarios."

        Friend Const EX_INTEGRANTES_CARGA = "No se ha podido cargar la información de integrantes de la vivienda."
        Friend Const EX_METODO_CARGA = "No se ha podido cargar la información de métodos de cumplimentación."
        Friend Const EX_OPE_CARGA = "No se ha podido cargar la información de operaciones."
        Friend Const EX_RCONT_CARGA = "No se ha podido cargar la información de resultado de contacto."
        Friend Const EX_RCUEST_CARGA = "No se ha podido cargar la información de resultado del cuestionario."
        Friend Const EX_RVIV_CARGA = "No se ha podido cargar la información de resultado de la vivienda."
        Friend Const EX_SITUAC_CARGA = "No se ha podido cargar la información de situaciones."

        Friend Const EX_COLECT_CARGA = "No se ha podido cargar la información del colectivo de la vivienda."
        Friend Const EX_COLECT_ACTUALIZAR = "No se ha podido actualizar la información del colectivo de la vivienda."

        Friend Const EX_CONTACTO_CARGA = "No se ha podido cargar la información de contactos."
        Friend Const EX_CONTACTO_ACTUALIZAR = "No se ha podido actualizar la información de contactos."
        Friend Const EX_CONTACTO_INSERTAR = "No se ha podido insertar la información de contactos."

        Friend Const EX_RESULT_CARGA = "No se ha podido cargar la información de resultados."
        Friend Const EX_RESULT_ACTUALIZAR = "No se ha podido actualizar la información de resultados."

        Friend Const EX_CODIFICACION_CARGA = "Ha ocurrido un error en el proceso de codificación"

        Friend Const EX_CONTROLMES = "Ha ocurrido un error en el proceso de control de periodo mensual"

        Friend Const EX_CONTROLTRIM = "Ha ocurrido un error en el proceso de control de periodo trimestral"

        Friend Const EX_SITIOS_CARGA = "No se han podido cargar los sitios web."
        Friend Const EX_SITIOS_ACTUALIZAR = "No se han podido guardar los cambios especificados de los sitios web."
        Friend Const EX_BUSCADORES_CARGA = "No se han podido cargar los buscadores."
        Friend Const EX_BUSCADORES_ACTUALIZAR = "No se han podido guardar los cambios especificados de los buscadores."
        Friend Const EX_TIPOWEB = "No se ha podido instanciar la información de base de datos para tipos web."

        Friend Const EX_AUTOCOMPLETADO = "No se ha podido instanciar la información de base de datos para autocompletado."

        Friend Const EX_CODLITERALES = "No se ha podido obtener la información de la codificacion de literales."

        Friend Const EX_VALIDACION = "No se ha podido obtener la información de la validacion de encuestas."

        Friend Const EX_LISTADO_CARGA = "No se ha podido cargar la información del listado."
        Friend Const EX_INCIDENCIAS_CARGA = "No se ha podido cargar la información de las incidencias."
        Friend Const EX_COMARCAS_CARGA = "No se ha podido cargar la información de las comarcas."

        Friend Const EX_DESCARGAS_MUESTRA_GUARDAR = "No se ha podido guardar la información de la desacarga de la muestra."
#End Region

#Region "OTHERS"

        Public Const VISTA_ENCUESTADO As String = "1" 'valor para acceder a la vista de encuestado en los accesos a los cuestionarios

        Friend Const DATA_LIMITER As String = ";"
        Friend Const DATA_INTERNAL_LIMITER As String = "@"

        Friend Const USUARIO_ACTIVO = "S"

        Public Const INDIVIDUO_PERMANECE As Integer = 1
        Public Const INDIVIDUO_ALTA As Integer = 2
        Public Const INDIVIDUO_BAJA As Integer = 3

        Public Const INDIVIDUO_OCUPADO As String = "O"
        Public Const INDIVIDUO_PARADO As String = "P"

        Public Const VALOR_SI As String = "1"
        Public Const VALOR_NO As String = "6"

        Public Const VALOR_SI_IND As String = "S"
        Public Const VALOR_NO_IND As String = "N"

        Public Const VALOR_F_IND As String = "F"
        Public Const VALOR_C_IND As String = "C"

        Public Const COMPLETO As String = "00"
        Public Const INCOMPLETO As String = "99"
        Public Const PENDIENTE As String = "0"

        Public Const RCONT_CONTACTO As String = "00"
        Public Const RCONT_NOCONTACTO As String = "01"

        Public Const RVIV_LOCALIZADA As String = "00"
        Public Const RVIV_VIVTEMPORAL As String = "08"
        Public Const RVIV_DESHABITADA As String = "10"

        Public Const SITUAC_ENCAMPO As String = "1"
        Public Const SITUAC_FINALIZADA As String = "2"
        Public Const SITUAC_INCIDENCIAS As String = "4"
        Public Const SITUAC_FINAL_SINVALIDAR = "8"
        Public Const SITUAC_FINAL_CODIFICADA = "9"
        Public Const SITUAC_FINAL_SOLOFAMILIAR = "10"
        Public Const SITUAC_FINAL_SINCODIFICAR = "5"
        Public Const SITUAC_FINAL_PARCIAL = "3"

        Friend Const VALOR_COD_NEGATIVA = "11"
        Friend Const VALOR_COD_VACACIONES = "12"
        Friend Const VALOR_COD_AUSENCIA = "13"
        Friend Const VALOR_COD_OTRAS_INCIDENCIAS = "19"


        Public Const PESTANIA_VIV As String = "1"
        Public Const PESTANIA_CON As String = "2"
        Public Const PESTANIA_RES As String = "3"

        Public Const INDIVIDUO_FICTICIO = "999"

        Public Const SIN_CONTACTO = "98"
        Public Const OTRA_PERSONA = "99"
        Public Const OTRO_RESIDENTE = "999"


        Friend Const VALOR_COD_INCOMPLETO = "99"
        Friend Const VALOR_COD_COMPLETO = "00"
        Friend Const VALOR_COD_PENDIENTE = "0"

        Friend Const VALOR_SITUAC_FINALIZADA = "2"
        Friend Const VALOR_SITUAC_FINAL_SINCODIFICAR = "5"
        Friend Const VALOR_SITUAC_FINAL_FUERAPLAZO = "7"
        Friend Const VALOR_SITUAC_FINAL_SINCODIFICAR_FUERAPLAZO = "6"

        Public Const PERFIL_ENCUESTADOR = "0"

        Friend Const PrimerTrimestre = "1"
        Friend Const UltimoTrimestre = "4"

        Public Const TIPO_PROFESION = "P"
        Public Const TIPO_ACTIVIDAD = "A"

        Public Const TIPO_MES = "M"
        Public Const TIPO_TRIMESTRE = "T"

        Public Const PESTANIA_SIT As String = "1"
        Public Const PESTANIA_BUS As String = "2"

        Public Const MAX_MUESTRA = 488

        'Formas de cumplimentación
        Public Const FORM_VISITA = "1"
        Public Const FORM_TELEFONICA = "2"
        Public Const FORM_WEB = "3"
        Public Const FORM_MOVIL = "4"


#Region "CODIFICACION IC"
        Public Const VALOR_COD_IC_SI = "1"
        Public Const VALOR_COD_IC_NO = "6"
        Public Const VALOR_COD_IC_ORIGEN_MUESTRA = "0"
        Public Const VALOR_COD_IC_ORIGEN_GESTOR = "1"
        Public Const VALOR_EDAD_IC = "75"

        Public Const VALOR_COD_IC_PERSONA_CONFIANZA = "IC"

#End Region

#Region "AUTOCOMPLETADO"
        Public Const XML_NODE_AUTOCOMPLETADOS_ROOT As String = "autocompletados"
        Public Const XML_NODE_AUTOCOMPLETADO_ROOT As String = "autocompletado[@id={0}]"
        Public Const XML_NODE_AUTOCOMPLETADO_PARAM_ATTRIB_ID As String = "id"
        Public Const XML_NODE_AUTOCOMPLETADO_ATTRIB_CAMPO_CAS As String = "campoCas"
        Public Const XML_NODE_AUTOCOMPLETADO_ATTRIB_CAMPO_EUS As String = "campoEus"
        Public Const XML_NODE_AUTOCOMPLETADO_ATTRIB_CAMPO_ID As String = "campoID"
        Public Const XML_NODE_AUTOCOMPLETADO_ATTRIB_TABLA As String = "tabla"

        Public Const AUTOCOMPLETADO_PARAM_TERM As String = "term"
        Public Const AUTOCOMPLETADO_PARAM_ID As String = "id"
        Public Const AUTOCOMPLETADO_PARAM_MAX_LENGTH As String = "maxLength"
#End Region

#Region "Tipos errores validaciones"
        Public Const ERROR_DURO As String = "1"
        Public Const ERROR_BLANDO As String = "0"
#End Region
#End Region

#Region "Constantes de Identificadores de encuestas"
        Friend Const GEDW As String = "GEDW"
#End Region
    End Module
End Namespace


