﻿Imports Eustat.Comun.V35.DAL.BaseDatos
Imports System.Data.OracleClient

''' <summary>
''' Clase de lógica de la funcionalidades necesaria para la validación de las encuestas.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class ValidacionGeneral
    Inherits EntidadBase

#Region "CONSTANTES"
    Public Const IdentColumnNumc As String = Globales.ALIAS_CONSULTAVIV_NUMC
    Public Const IdentColumnAenc As String = Globales.ALIAS_CONSULTAVIV_ANIO
    Public Const IdentColumnTenc As String = Globales.ALIAS_CONSULTAVIV_TRIM
    Public Const IdentColumnSituac As String = Globales.ALIAS_CONSULTAVIV_SIT
    Public Const IdentColumnNombre As String = Globales.ALIAS_CONSULTAIND_NOM
    Public Const IdentColumnEdad As String = Globales.ALIAS_CONSULTAIND_EDAD
    Public Const IdentColumnTlfno1 As String = Globales.ALIAS_CONSULTAIND_TLFNO1
    Public Const IdentColumnTlfno2 As String = Globales.ALIAS_CONSULTAIND_TLFNO2
    Public Const IdentColumnCFam As String = "IND_CFAM"
    Public Const IdentColumnCInd As String = "IND_CIND"
    Public Const IdentColumnTipo As String = Globales.COL_VALIDACIONES_TIPO
    Public Const IdentColumnNind As String = Globales.ALIAS_CONSULTAIND_NIND

    Public Enum TipoCuestionario
        Familiar
        Individual
    End Enum
#End Region

#Region "CONSTRUCTOR"
    Sub New(ByVal operacion As String, ByVal numc As String, ByVal anio As String, ByVal trim As String, ByVal semana As String, ByVal idioma As String, ByVal numcHasta As String, ByVal th As String)
        _operacion = operacion
        _numc = numc
        _anio = anio
        _trim = trim
        _sem = semana
        _numcHasta = numcHasta
        _th = th
        _idioma = idioma
    End Sub
#End Region
    
#Region "PROPIEDADES"
    Private _operacion As String
    Public Property Operacion() As String
        Get
            Return _operacion
        End Get
        Set(ByVal value As String)
            _operacion = value
        End Set
    End Property

    Private dtResultadoErrores As DataTable
    Public Property ObjResultErrores As DataTable
        Get
            Return dtResultadoErrores
        End Get
        Set(ByVal value As DataTable)
            dtResultadoErrores = value
        End Set
    End Property

    Private dtResultadoPantalla As DataTable
    Public Property ObjResultadoPantalla As DataTable
        Get
            Return dtResultadoPantalla
        End Get
        Set(ByVal value As DataTable)
            dtResultadoPantalla = value
        End Set
    End Property

    Private _dtVivienda As DataSet
    Public Property ObjDtvivienda As DataSet
        Get
            Return _dtVivienda
        End Get
        Set(ByVal value As DataSet)
            _dtVivienda = value
        End Set
    End Property

    Private _msjError As String
    Public Property MsjError() As String
        Get
            Return _msjError
        End Get
        Set(ByVal value As String)
            _msjError = value
        End Set
    End Property

    Private _msjInfo As String
    Public Property MsjInfo() As String
        Get
            Return _msjInfo
        End Get
        Set(ByVal value As String)
            _msjInfo = value
        End Set
    End Property

    Private _idioma As String
    Public Property idioma() As String
        Get
            Return _idioma
        End Get
        Set(ByVal value As String)
            _idioma = value
        End Set
    End Property

    Private _numc As String
    Public Property Numc() As String
        Get
            Return _numc
        End Get
        Set(ByVal value As String)
            _numc = value
        End Set
    End Property

    Private _sem As String
    Public Property Semana() As String
        Get
            Return _sem
        End Get
        Set(ByVal value As String)
            _sem = value
        End Set
    End Property

    Private _numcHasta As String
    Public Property numcHasta() As String
        Get
            Return _numcHasta
        End Get
        Set(ByVal value As String)
            _numcHasta = value
        End Set
    End Property

    Private _th As String
    Public Property th() As String
        Get
            Return _th
        End Get
        Set(ByVal value As String)
            _th = value
        End Set
    End Property

    Private _anio As String
    Public Property Anio() As String
        Get
            Return _anio
        End Get
        Set(ByVal value As String)
            _anio = value
        End Set
    End Property

    Private _trim As String
    Public Property Trim() As String
        Get
            Return _trim
        End Get
        Set(ByVal value As String)
            _trim = value
        End Set
    End Property

    Private _numVivDuros As Integer
    Public Property numVivDuros() As Integer
        Get
            Return _numVivDuros
        End Get
        Set(ByVal value As Integer)
            _numVivDuros = value
        End Set
    End Property

    Private _numVivBlandos As Integer
    Public Property numVivBlandos() As Integer
        Get
            Return _numVivBlandos
        End Get
        Set(ByVal value As Integer)
            _numVivBlandos = value
        End Set
    End Property

    Private _numVivBlandosDuros As Integer
    Public Property numVivBlandosDuros() As Integer
        Get
            Return _numVivBlandosDuros
        End Get
        Set(ByVal value As Integer)
            _numVivBlandosDuros = value
        End Set
    End Property

    Public _numVivPendCodif As Integer
    Public Property numVivPendCodif() As Integer
        Get
            Return _numVivPendCodif
        End Get
        Set(ByVal value As Integer)
            _numVivPendCodif = value
        End Set
    End Property

    Public _numVivFinalizadas As Integer
    Public Property numVivFinalizadas() As Integer
        Get
            Return _numVivFinalizadas
        End Get
        Set(ByVal value As Integer)
            _numVivFinalizadas = value
        End Set
    End Property

    Public _numVivFinalizadasParciales As Integer
    Public Property numVivFinalizadasParciales() As Integer
        Get
            Return _numVivFinalizadasParciales
        End Get
        Set(ByVal value As Integer)
            _numVivFinalizadasParciales = value
        End Set
    End Property

    Public _numVivNoValidas As Integer
    Public Property numVivNoValidas() As Integer
        Get
            Return _numVivNoValidas
        End Get
        Set(ByVal value As Integer)
            _numVivNoValidas = value
        End Set
    End Property

    Public _numIndividuos As Integer
    Public Property numIndividuos() As Integer
        Get
            Return _numIndividuos
        End Get
        Set(ByVal value As Integer)
            _numIndividuos = value
        End Set
    End Property

    Public _numIndividuosNoValidos As Integer
    Public Property numIndividuosNoValidos() As Integer
        Get
            Return _numIndividuosNoValidos
        End Get
        Set(ByVal value As Integer)
            _numIndividuosNoValidos = value
        End Set
    End Property

    Private _htViviendas As Hashtable
    Public Property htViviendas() As Hashtable
        Get
            Return _htViviendas
        End Get
        Set(ByVal value As Hashtable)
            _htViviendas = value
        End Set
    End Property

    Private _vivSoloErrorBlando As Boolean
    Public Property SoloErrorBlando() As Boolean
        Get
            Return _vivSoloErrorBlando
        End Get
        Set(ByVal value As Boolean)
            _vivSoloErrorBlando = value
        End Set
    End Property

#End Region

#Region "METODOS"
    Public Function ObtenerDtValidaciones() As DataTable
        Return Me.ObjResultadoPantalla
    End Function

    Public Function ProcesoValidaciones() As Boolean
        Try
            Dim dtErrores As New DataTable
            dtErrores.Columns.Add("CODIGO", Type.GetType("System.String"))
            dtErrores.Columns.Add("NUMC", Type.GetType("System.Int32"))
            dtErrores.Columns.Add("NIND", Type.GetType("System.String"))
            dtErrores.Columns.Add("TIPO", Type.GetType("System.String"))
            dtErrores.Columns.Add("DESC_EUS", Type.GetType("System.String"))
            dtErrores.Columns.Add("DESC_CAS", Type.GetType("System.String"))
            dtErrores.Columns.Add("VALOR", Type.GetType("System.String"))
            dtErrores.Columns.Add("VALORES", Type.GetType("System.String"))
            dtErrores.Columns.Add("AGENTE", Type.GetType("System.String"))
            Me.ObjResultErrores = dtErrores.Copy

            Dim dtresultados As New DataTable
            dtresultados.Columns.Add(IdentColumnNumc, Type.GetType("System.String"))
            dtresultados.Columns.Add(IdentColumnNind, Type.GetType("System.String"))
            dtresultados.Columns.Add(IdentColumnNombre, Type.GetType("System.String"))
            dtresultados.Columns.Add(IdentColumnEdad, Type.GetType("System.String"))
            dtresultados.Columns.Add(IdentColumnTlfno1, Type.GetType("System.String"))
            dtresultados.Columns.Add(IdentColumnTlfno2, Type.GetType("System.String"))
            dtresultados.Columns.Add(IdentColumnCFam, Type.GetType("System.String"))
            dtresultados.Columns.Add(IdentColumnCInd, Type.GetType("System.String"))
            Me.ObjResultadoPantalla = dtresultados


            'Obtener viviendas pendientes de validacion y codificadas
            Me.ObjDtvivienda = ObtenerInfvivienda()

            Me.numVivDuros = 0
            Me.numVivBlandos = 0
            Me.numVivBlandosDuros = 0

            Me.htViviendas = New Hashtable

            If Not Me.ObjDtvivienda Is Nothing Then
                If Me.ObjDtvivienda.Tables(0).Rows.Count <> 0 Then

                    'Obtener validaciones familiares y personales
                    Dim dtVal As DataSet = ObtenerValidaciones()

                    Dim fila As DataRow
                    Dim fila2 As DataRow
                    Dim codigo As String = ""
                    Dim situacion As String = ""
                    Dim numc As String = ""

                    'Comprobar validaciones
                    For Each fila In Me.ObjDtvivienda.Tables(0).Rows
                        numc = fila.Item(Globales.COL_CONSULTAVIV_NUMC)
                        situacion = fila.Item(Globales.COL_CONSULTAVIV_SIT)
                        For Each fila2 In dtVal.Tables(0).Rows
                            If RealizarValidacion(Me.ObjResultErrores, numc, fila2) Then 'Si la vivienda no es válida
                                If Not (Me.htViviendas.ContainsKey(numc & "_" & fila2.Item(Globales.COL_VALIDACIONES_NIVEL))) Then
                                    'Guardar vivienda no válida en el hashtable
                                    Me.htViviendas.Add(numc & "_" & fila2.Item(Globales.COL_VALIDACIONES_NIVEL), False)
                                End If
                            End If
                        Next
                    Next
                End If


                'Actualizar valores de sesion
                Dim nivel As String = ""
                Dim cod As String = ""
                Dim keys(Me.htViviendas.Keys.Count - 1) As Object
                Dim i As Integer = 0
                For Each key As Object In Me.htViviendas.Keys
                    cod = key.split("_")(0)
                    nivel = key.split("_")(1)
                    If nivel = Globales.ERROR_DURO Then
                        If Me.htViviendas.ContainsKey(cod & "_" & Globales.ERROR_BLANDO) Then
                            Me.numVivBlandosDuros += 1
                        Else
                            Me.numVivDuros += 1
                        End If
                    Else
                        If Me.htViviendas.ContainsKey(cod & "_" & Globales.ERROR_DURO) Then
                            Me.numVivBlandosDuros += 1
                        Else
                            Me.numVivBlandos += 1
                        End If
                    End If
                Next

                If Me.numVivBlandosDuros <> 1 Then
                    Me.numVivBlandosDuros = Me.numVivBlandosDuros / 2
                End If

                ModificarSituacionResultadoViviendas()

                Return True
            Else
                Return False
            End If

        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try

    End Function

    Public Sub ModificarSituacionResultadoViviendas()
        Try
            Me.SoloErrorBlando = False
            Dim fila As DataRow
            Me.numVivPendCodif = 0
            Me.numVivFinalizadas = 0
            Me.numVivFinalizadasParciales = 0
            Dim dtAuxiliar As DataSet = Me.ObjDtvivienda

            'Modificar la situacion de las viviendas correctas
            For Each fila In Me.ObjDtvivienda.Tables(0).Rows

                If Not (Me.htViviendas.ContainsKey(fila.Item(Globales.COL_CONSULTAVIV_NUMC).ToString & "_" & Globales.ERROR_DURO)) And _
                   Not (Me.htViviendas.ContainsKey(fila.Item(Globales.COL_CONSULTAVIV_NUMC).ToString & "_" & Globales.ERROR_BLANDO)) Then
                    ModificarSituacionResultadoVivienda(fila)
                Else
                    Me.numVivNoValidas += 1
                End If

                If Not (Me.htViviendas.ContainsKey(fila.Item(Globales.COL_CONSULTAVIV_NUMC).ToString & "_" & Globales.ERROR_DURO)) And _
                   (Me.htViviendas.ContainsKey(fila.Item(Globales.COL_CONSULTAVIV_NUMC).ToString & "_" & Globales.ERROR_BLANDO)) Then
                    Me.SoloErrorBlando = True
                End If

            Next
            Me.ObjDtvivienda.Tables(0).TableName = Me.Operacion & Globales.C_TABLA_MUESTRA
            'Guardar Viviendas
            MyBase.guardarDataSet(Me.ObjDtvivienda)
        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try
    End Sub

    Public Overridable Sub ModificarSituacionResultadoVivienda(ByRef fila As DataRow)
        Try
            Dim vnumc As String = fila.Item(Globales.COL_CONSULTAVIV_NUMC).ToString
            Dim vaenc As String = fila.Item(Globales.COL_CONSULTAVIV_ANIO).ToString
            Dim vtrim As String = ""
            If Not String.IsNullOrEmpty(Trim) Then
                vtrim = fila.Item(Globales.COL_CONSULTAVIV_TRIM).ToString
            End If
            If fila.Item(Globales.COL_CONSULTAVIV_SIT) = Globales.SITUAC_FINAL_SINVALIDAR Then
                'compruebo si la vivienda tiene literales sin codificar, si no los tiene pasará a finalizada

                If (Not (ComprobarLitACodificar(vnumc, vaenc, vtrim))) Then
                    Dim numNocompletos As Integer = ObtenerExistenCuestionariosNoCompletos(vnumc, vaenc, vtrim)
                    If (numNocompletos > 0) Then
                        fila.Item(Globales.COL_CONSULTAVIV_SIT) = Globales.SITUAC_FINAL_PARCIAL
                        Me.numVivFinalizadasParciales += 1
                    Else
                        fila.Item(Globales.COL_CONSULTAVIV_SIT) = Globales.SITUAC_FINALIZADA
                        Me.numVivFinalizadas += 1
                    End If
                Else
                    fila.Item(Globales.COL_CONSULTAVIV_SIT) = Globales.SITUAC_FINAL_SINCODIFICAR
                    Me.numVivPendCodif += 1
                End If
            ElseIf fila.Item(Globales.COL_CONSULTAVIV_SIT) = Globales.SITUAC_FINAL_CODIFICADA Then
                'tengo que ver si debo pasar a finalizada parcial, si no están todos los cuestionarios individuales completos, pasara a finalizada parcial

                Dim numNocompletos As Integer = ObtenerExistenCuestionariosNoCompletos(vnumc, vaenc, vtrim)
                If (numNocompletos > 0) Then
                    fila.Item(Globales.COL_CONSULTAVIV_SIT) = Globales.SITUAC_FINAL_PARCIAL
                    Me.numVivFinalizadasParciales += 1
                Else
                    fila.Item(Globales.COL_CONSULTAVIV_SIT) = Globales.SITUAC_FINALIZADA
                    Me.numVivFinalizadas += 1
                End If
            End If

        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try
    End Sub

    ''' <summary>
    ''' Funcion que devuelve si para una vivienda quedan literales por codificar
    ''' </summary>
    ''' <param name="numc"></param>
    ''' <param name="anio"></param>
    ''' <param name="trim"></param>
    ''' <returns><c>True</c> si SÍ quedan literales por codificar. <c>False</c> si  NO quedan literales por codificar</returns>
    ''' <remarks></remarks>
    ''' 
    Public Overridable Function ComprobarLitACodificar(ByVal numc As String, ByVal anio As String, ByVal trim As String) As Boolean
        Return False
    End Function

    Public Function RealizarValidacion(ByVal dtErrores As DataTable, ByVal numc As String, ByVal filaVal As DataRow) As Boolean

        Dim codVal As String
        Try

            Dim val As String = filaVal.Item(Globales.COL_VALIDACIONES_VALORDES)

            Dim nivel As String = filaVal.Item(Globales.COL_VALIDACIONES_NIVEL)
            Dim tabDes As String = filaVal.Item(Globales.COL_VALIDACIONES_TABDES)
            Dim tipo As String = filaVal.Item(Globales.COL_VALIDACIONES_NIVEL)
            codVal = filaVal.Item(Globales.COL_VALIDACIONES_CODIGO)

            Dim dt As DataSet = Nothing
            Dim fila As DataRow

            Dim columnas As String = ObtenerColumnasCondicion(val.ToUpper, tabDes)

            Dim aParametros() As String = {codVal, val, columnas.ToUpper.Replace("(", " "), tabDes, numc}

            dt = ComprobarValidacionBD(aParametros)

            If Not dt Is Nothing Then
                If dt.Tables(0).Rows.Count <> 0 Then

                    For Each fila In dt.Tables(0).Rows
                        Dim valores As String = ObtenerValores(val, fila, tabDes)

                        Dim nindError As String = String.Empty

                        If ValidacionCuestionarioIndividual(tabDes) And ValidacionCuestionarioFamiliar(tabDes) Then
                            'si la validación es de ambos cuestionarios, obtener nind del cuestionario familiar (nind de la persona cuyo INDFAM = 'S') y nind del cuestionario con el error, si son distintos, se añadirán dos líneas, una con el error en el cuestionario familiar, y otra el cuestionario individual
                            Dim datosIndFam As DataSet = ObtenerDatosInfFamiliar(fila)
                            Dim datosIndIndividual As DataSet = ObtenerDatosInfIndividual(fila)
                            Dim stNindInd As String = datosIndIndividual.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_NIND)
                            Dim stNombreInd As String = datosIndIndividual.Tables(0).Rows(0)(Globales.ALIAS_CONSULTAIND_NOM)
                            Dim stEdadInd As String = IIf(IsDBNull(datosIndIndividual.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_EDAD)), String.Empty, datosIndIndividual.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_EDAD))
                            Dim tlfno1Ind As String = datosIndIndividual.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_TLFNO1).ToString()
                            Dim tlfno2Ind As String = datosIndIndividual.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_TLFNO2).ToString()
                            Dim stNind As String = ""
                            Dim stNombre As String = ""
                            Dim stEdad As String = ""
                            Dim tlfno1 As String = ""
                            Dim tlfno2 As String = ""

                            If datosIndFam.Tables(0).Rows.Count = 0 Then
                                'si el familiar lo ha informado el IC
                                stNind = IC.VALOR_PERSONA_CONFIANZA
                                If _idioma = Globales.C_IDIOMA_EUSKERA Then
                                    stNombre = My.Resources.Globales.ResourceManager.GetString("InformanteIC", New System.Globalization.CultureInfo(Globales.C_IDIOMA_EUSKERA))
                                Else
                                    stNombre = My.Resources.Globales.InformanteIC
                                End If
                            Else
                                stNind = datosIndFam.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_NIND)
                                stNombre = datosIndFam.Tables(0).Rows(0)(Globales.ALIAS_CONSULTAIND_NOM)
                                stEdad = datosIndFam.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_EDAD)
                                tlfno1 = datosIndFam.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_TLFNO1).ToString()
                                tlfno2 = datosIndFam.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_TLFNO2).ToString()
                            End If
                            'si el informante familiar, es el mismo que el propietario individual. Añado una sóla línea
                            If (stNind = stNindInd) Then
                                AñadirResultado(numc, stNind, stNombre, stEdad, tlfno1, tlfno2, tipo, tipo)
                            Else
                                'si es distinto añado una línea para el cuestionario familiar
                                AñadirResultado(numc, stNind, stNombre, stEdad, tlfno1, tlfno2, tipo, String.Empty)
                                'y otra para el cuestionario individual
                                AñadirResultado(numc, stNindInd, stNombreInd, stEdadInd, tlfno1Ind, tlfno2Ind, String.Empty, tipo)
                            End If
                            nindError = stNind
                        ElseIf ValidacionCuestionarioFamiliar(tabDes) Then
                            'si la validación es del cuestionario familiar, nind de la persona cuyo INDFAM = 'S'
                            Dim datosIndFam As DataSet = ObtenerDatosInfFamiliar(fila)
                            Dim stNind As String = ""
                            Dim stNombre As String = ""
                            Dim stEdad As String = ""
                            Dim tlfno1 As String = ""
                            Dim tlfno2 As String = ""
                            If datosIndFam.Tables(0).Rows.Count = 0 Then 'ES informante IC
                                stNind = IC.VALOR_PERSONA_CONFIANZA
                                If _idioma = Globales.C_IDIOMA_EUSKERA Then
                                    stNombre = My.Resources.Globales.ResourceManager.GetString("InformanteIC", New System.Globalization.CultureInfo(Globales.C_IDIOMA_EUSKERA))
                                Else
                                    stNombre = My.Resources.Globales.InformanteIC
                                End If
                            Else
                                stNind = datosIndFam.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_NIND)
                                stNombre = datosIndFam.Tables(0).Rows(0)(Globales.ALIAS_CONSULTAIND_NOM)
                                stEdad = datosIndFam.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_EDAD)
                                tlfno1 = datosIndFam.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_TLFNO1).ToString()
                                tlfno2 = datosIndFam.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_TLFNO2).ToString()
                            End If

                            AñadirResultado(numc, stNind, stNombre, stEdad, tlfno1, tlfno2, tipo, String.Empty)
                            nindError = stNind
                        ElseIf ValidacionCuestionarioIndividual(tabDes) Then
                            Dim datosIndIndividual As DataSet = ObtenerDatosInfIndividual(fila)
                            Dim stNindInd As String = datosIndIndividual.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_NIND)
                            Dim stNombreInd As String = datosIndIndividual.Tables(0).Rows(0)(Globales.ALIAS_CONSULTAIND_NOM)
                            Dim stEdadInd As String = datosIndIndividual.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_EDAD)
                            Dim tlfno1Ind As String = datosIndIndividual.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_TLFNO1).ToString()
                            Dim tlfno2Ind As String = datosIndIndividual.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_TLFNO2).ToString()
                            AñadirResultado(numc, stNindInd, stNombreInd, stEdadInd, tlfno1Ind, tlfno2Ind, String.Empty, tipo)
                            nindError = stNindInd
                        End If

                        Dim agente As String = ObtenerAgente(IIf(ValidacionCuestionarioIndividual(tabDes), TipoCuestionario.Individual, TipoCuestionario.Familiar), numc, Anio, Trim, nindError)

                        dtErrores.Rows.Add(codVal, numc, nindError, tipo, filaVal.Item(Globales.COL_VALIDACIONES_DESC_EUS), filaVal.Item(Globales.COL_VALIDACIONES_DESC_CAS), val.ToUpper, valores, agente)

                    Next
                    Return True
                Else : Return False
                End If
            Else : Return False
            End If

        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try
    End Function

    Public Function ObtenerValores(ByVal condicion As String, ByVal fila As DataRow, ByVal tablas As String) As String
        Dim arrayCond As String()

        Dim result As String = ""
        arrayCond = condicion.Split(" ")
        Dim campo As String = ""
        Dim posicion As Integer
        Dim posicion_fin As Integer

        For ind As Integer = 0 To arrayCond.GetUpperBound(0)
            posicion = arrayCond(ind).LastIndexOf(".")
            If (posicion > 0) Then
                posicion_fin = arrayCond(ind).Length - posicion
                campo = arrayCond(ind).Substring(posicion, posicion_fin).Replace(".", "")
                campo = campo.ToString.Replace("(", " ")
                campo = campo.Replace(")", " ")
                If Not result.Contains(campo.ToUpper) Then
                    result &= campo.ToUpper & " = " & fila.Item(campo.Replace(")", " ").Trim).ToString.Replace("(", " ") & ", "
                End If
            End If
        Next
        If result.Length > 0 Then
            result = result.Substring(0, result.Length - 2)
        End If

        Return result.Trim
    End Function

    Protected Function ObtenerColumnasCondicion(ByVal condicion As String, ByVal tablas As String) As String
        Try
            Dim result As String = ""
            Dim condicionAux As String = condicion
            Dim campo As String = ""
            Dim posicion As Integer
            Dim posicion_fin As Integer

            Dim arrayTablasAux As String() = tablas.Split(",")

            For Each e As String In arrayTablasAux
                While (condicionAux.Contains(e))
                    posicion = condicionAux.IndexOf(e & ".")
                    posicion_fin = condicionAux.IndexOf(" ", posicion)
                    campo = condicionAux.Substring(posicion, posicion_fin - posicion)
                    If Not result.Contains(campo) Then
                        result = result & campo & ", "
                        result.Replace("(", " ")
                    End If
                    condicionAux = condicionAux.Replace(campo & " ", "")
                End While
            Next

            If result.Length > 0 Then
                result = result.Substring(0, result.Length - 2)
            End If
            Return result
        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try
    End Function

    Public Function ComprobarValidacionBD(ByVal aParam() As String) As DataSet
        Dim sSql As String = ""
        Dim sSelect As String = " SELECT "
        Dim stWhere As String = " WHERE "
        Dim sWhere As String = ""
        Dim sFrom As String = " FROM "

        'Parametros 
        Dim codVal As String = aParam(0)
        Dim val As String = aParam(1)
        Dim columnas As String = aParam(2)
        Dim tabDes As String = aParam(3)
        Dim numc As String = aParam(4)

        Try

            Dim Tablas() As String = tabDes.Split(",")
            Dim columnasSelect As String = ""
            Dim clavesTablas As New List(Of KeyValuePair(Of String, String()))

            Dim cmdaux(3) As OracleParameter

            cmdaux(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_NUMC, OracleType.VarChar, numc)
            cmdaux(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_ANIO, OracleType.Number, Me.Anio)
            If Not String.IsNullOrEmpty(Me.Trim) Then
                cmdaux(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_TRIM, OracleType.Number, Me.Trim)
            End If
            'Si es una validacion que incluye a EBP añadir la operacion
            If ValidacionEBP(tabDes) Then
                cmdaux(3) = Me.CrearParametroOracle(Globales.COL_EBP_ORIGEN, OracleType.VarChar, Me.Operacion)
            End If

            For Each tabla In Tablas
                Dim keyval As New KeyValuePair(Of String, String())(tabla, ObtenerClavesPrimarias(tabla).Split(","))
                clavesTablas.Add(keyval)
                For Each clmna In keyval.Value
                    sSelect &= " " & tabla & "." & clmna & " , "
                Next
            Next
            sSelect &= columnas

            '*****Formar la where*******

            For i As Integer = 0 To clavesTablas.Count - 1 Step 1
                If i < clavesTablas.Count - 1 Then
                    For Each columna In clavesTablas(i).Value
                        For j = i + 1 To clavesTablas.Count - 1 Step 1
                            For Each clmaux In clavesTablas(j).Value
                                If columna = clmaux Then
                                    If sWhere <> "" Then
                                        sWhere &= " AND "
                                    End If
                                    sWhere &= clavesTablas(i).Key & "." & columna & " = " & clavesTablas(j).Key & "." & clmaux
                                End If
                            Next
                        Next
                    Next
                End If
            Next

            '***************************
            Dim tablasAux As String = ObtenerClavesPrimarias(Tablas(0))
            For Each columna In cmdaux
                If Not columna Is Nothing Then
                    If (tablasAux.Contains(columna.ParameterName)) Then
                        If (Not String.IsNullOrEmpty(sWhere)) Then
                            sWhere &= " and " & Tablas(0) & "." & columna.ParameterName & " = :" & columna.ParameterName
                        Else
                            sWhere &= Tablas(0) & "." & columna.ParameterName & " = :" & columna.ParameterName
                        End If
                    End If
                End If
            Next

            sFrom += tabDes

            'Añadir la validación a la Where
            sWhere &= " AND (" & val & " )"

            'Si es una validacion que incluye a EBP añadir la operacion
            If ValidacionEBP(tabDes) Then
                sWhere &= " AND " & Globales.C_TABLA_EBP & "." & Globales.COL_EBP_ORIGEN & " =:" & Globales.COL_EBP_ORIGEN
            End If

            sSql = sSelect + " " + sFrom + " " + stWhere + " " + sWhere
            'Se ejecuta la query
            Dim dtresul As DataSet = Me.EjecutarSQL(sSql, CommandType.Text, cmdaux)
            If dtresul.Tables(0).Rows.Count <> 0 Then
                If (ValidacionCuestionarioIndividual(tabDes)) Then
                    sSelect = " SELECT DISTINCT(" & Globales.COL_CONSULTAIND_RPER
                    sFrom = ") FROM " & Me.Operacion & Globales.C_TABLA_INDIVIDUOS
                    sWhere = " WHERE " & Globales.COL_CONSULTAIND_NUMC & " =:" & Globales.COL_CONSULTAIND_NUMC
                    sWhere = sWhere & " AND " & Globales.COL_CONSULTAIND_ANIO & " =:" & Globales.COL_CONSULTAIND_ANIO
                    If Not String.IsNullOrEmpty(Me.Trim) Then
                        sWhere = sWhere & " AND " & Globales.COL_CONSULTAIND_TRIM & " =:" & Globales.COL_CONSULTAIND_TRIM
                    End If
                    sWhere = sWhere & " AND " & Globales.COL_CONSULTAIND_NIND & " =:" & Globales.COL_CONSULTAIND_NIND

                    
                    Dim cmd(4) As OracleParameter

                    cmd(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_NUMC, OracleType.VarChar, numc)
                    cmd(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_ANIO, OracleType.Number, Me.Anio)
                    If Not String.IsNullOrEmpty(Me.Trim) Then
                        cmd(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_TRIM, OracleType.Number, Me.Trim)
                    End If
                    cmd(3) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NIND, OracleType.VarChar, dtresul.Tables(0).Rows(0)(Globales.COL_CONSULTAIND_NIND))
                    

                    sSql = sSelect + " " + sFrom + " " + sWhere
                    Dim dtAux As DataSet = Me.EjecutarSQL(sSql, CommandType.Text, cmd)
                    If dtAux IsNot Nothing AndAlso dtAux.Tables(0).Rows.Count > 0 Then
                        If dtAux.Tables(0).Rows(0).Item(Globales.COL_CONSULTAIND_RPER) = Globales.COMPLETO Then
                            Return dtresul
                        Else
                            Return Nothing
                        End If
                    Else
                        Return Nothing
                    End If
                ElseIf (ValidacionCuestionarioFamiliar(tabDes)) Then
                    sSelect = " SELECT DISTINCT(" & Globales.COL_CONSULTAIND_RFAM
                    sFrom = ") FROM " & Me.Operacion & Globales.C_TABLA_INDIVIDUOS
                    sWhere = " WHERE " & Globales.COL_CONSULTAIND_NUMC & " =:" & Globales.COL_CONSULTAIND_NUMC
                    sWhere = sWhere & " AND " & Globales.COL_CONSULTAIND_ANIO & " =:" & Globales.COL_CONSULTAIND_ANIO
                    If Not String.IsNullOrEmpty(Me.Trim) Then
                        sWhere = sWhere & " AND " & Globales.COL_CONSULTAIND_TRIM & " =:" & Globales.COL_CONSULTAIND_TRIM
                    End If

                    Dim cmd(3) As OracleParameter

                    cmd(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, numc)
                    cmd(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.Number, Me.Anio)
                    If Not String.IsNullOrEmpty(Me.Trim) Then
                        cmd(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_TRIM, OracleType.Number, Me.Trim)
                    End If

                    sSql = sSelect + " " + sFrom + " " + sWhere
                    Dim dtAux As DataSet = Me.EjecutarSQL(sSql, CommandType.Text, cmd)
                    If dtAux IsNot Nothing AndAlso dtAux.Tables(0).Rows.Count > 0 Then
                        If dtAux.Tables(0).Rows(0).Item(Globales.COL_CONSULTAIND_RFAM) = Globales.COMPLETO Then
                            Return dtresul
                        Else
                            Return Nothing
                        End If
                    Else
                        Return Nothing
                    End If
                ElseIf tabDes = (Me.Operacion & Globales.C_TABLA_VIVIENDA) Then
                    Return dtresul
                End If
            Else
                Return dtresul
            End If

        Catch ex As Exception
            If Me.MsjError = "" Then
                Me.MsjError = codVal & ", "
            Else
                If Not (Me.MsjError.Contains(codVal & ", ")) Then
                    Me.MsjError &= codVal & ", "
                End If
            End If

            Return Nothing
        End Try

        Return Nothing
    End Function

    Public Overridable Function ObtenerClavesPrimarias(ByVal tabla As String) As String
        Try

            Select Case tabla
                Case Me.Operacion & Globales.C_TABLA_CUESTIONARIOFAM
                    If Not String.IsNullOrEmpty(Me.Trim) Then
                        Return Globales.COL_CUESTFAM_NUMC & "," & Globales.COL_CUESTFAM_AENC & "," & Globales.COL_CUESTFAM_TENC
                    Else
                        Return Globales.COL_CUESTFAM_NUMC & "," & Globales.COL_CUESTFAM_AENC
                    End If
                Case Me.Operacion & Globales.C_TABLA_CUESTIONARIOIND
                    If Not String.IsNullOrEmpty(Me.Trim) Then
                        Return Globales.COL_CUESTIND_NUMC & "," & Globales.COL_CUESTIND_AENC & "," & Globales.COL_CUESTIND_TENC & "," & Globales.COL_CUESTIND_NIND
                    Else
                        Return Globales.COL_CUESTIND_NUMC & "," & Globales.COL_CUESTIND_AENC & "," & Globales.COL_CUESTIND_NIND
                    End If

                Case Me.Operacion & Globales.C_TABLA_VIVIENDA
                    If Not String.IsNullOrEmpty(Me.Trim) Then
                        Return Globales.COL_CONSULTAVIV_NUMC & "," & Globales.COL_CONSULTAVIV_ANIO & "," & Globales.COL_CONSULTAVIV_TRIM
                    Else
                        Return Globales.COL_CONSULTAVIV_NUMC & "," & Globales.COL_CONSULTAVIV_ANIO
                    End If

                Case Me.Operacion & Globales.C_TABLA_INDIVIDUOS
                    If Not String.IsNullOrEmpty(Me.Trim) Then
                        Return Globales.COL_CONSULTAIND_NUMC & "," & Globales.COL_CONSULTAIND_ANIO & "," & Globales.COL_CONSULTAIND_TRIM & "," & Globales.COL_CONSULTAIND_NIND
                    Else
                        Return Globales.COL_CONSULTAIND_NUMC & "," & Globales.COL_CONSULTAIND_ANIO & "," & Globales.COL_CONSULTAIND_NIND
                    End If

                Case Globales.C_TABLA_EBP
                    If Not String.IsNullOrEmpty(Me.Trim) Then
                        Return Globales.COL_EBP_ORIGEN & "," & Globales.COL_EBP_NUMC & "," & Globales.COL_EBP_NIND & "," & Globales.COL_EBP_AENC & "," & Globales.COL_EBP_TENC
                    Else
                        Return Globales.COL_EBP_ORIGEN & "," & Globales.COL_EBP_NUMC & "," & Globales.COL_EBP_NIND & "," & Globales.COL_EBP_AENC
                    End If

                Case Else
                    Return String.Empty
            End Select

        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try

        Return Nothing
    End Function

    Public Function ObtenerInfvivienda() As DataSet
        Try
            Dim data As DataSet
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = "*"
            Dim _filtroAux As String = ""

            If Not String.IsNullOrEmpty(Me.Numc) Then
                If Not String.IsNullOrEmpty(_filtroAux) Then
                    _filtroAux = _filtroAux & " AND "
                End If
                _filtroAux = _filtroAux & " " & Globales.COL_CONSULTAVIV_NUMC & " >= " & Me.Numc
            End If
            If Not String.IsNullOrEmpty(Me.numcHasta) Then
                If Not String.IsNullOrEmpty(_filtroAux) Then
                    _filtroAux = _filtroAux & " AND "
                End If
                _filtroAux = _filtroAux & " " & Globales.COL_CONSULTAVIV_NUMC & " <= " & Me.numcHasta
            End If


            If Not String.IsNullOrEmpty(Me.th) AndAlso Me.th <> "-1" Then
                If Not String.IsNullOrEmpty(_filtroAux) Then
                    _filtroAux = _filtroAux & " AND "
                End If
                _filtroAux = _filtroAux & " " & Globales.COL_CONSULTAVIV_TH & " = " & Me.th
            End If

            If Not String.IsNullOrEmpty(Me.Anio) Then
                If Not String.IsNullOrEmpty(_filtroAux) Then
                    _filtroAux = _filtroAux & " AND "
                End If
                _filtroAux = _filtroAux & " " & Globales.COL_CONSULTAVIV_ANIO & " = " & Me.Anio
            End If

            If Not String.IsNullOrEmpty(Me.Trim) Then
                If Not String.IsNullOrEmpty(_filtroAux) Then
                    _filtroAux = _filtroAux & " AND "
                End If
                _filtroAux = _filtroAux & " " & Globales.COL_CONSULTAVIV_TRIM & " = " & Me.Trim
            End If

            If Not String.IsNullOrEmpty(Me.Semana) Then
                If Not String.IsNullOrEmpty(_filtroAux) Then
                    _filtroAux = _filtroAux & " AND "
                End If
                _filtroAux = _filtroAux & " " & Globales.COL_CONSULTAVIV_SEM & " = " & Me.Semana
            End If

            If Not String.IsNullOrEmpty(_filtroAux) Then
                _filtroAux = _filtroAux & " AND "
            End If
            _filtroAux = _filtroAux & " (" & Globales.COL_CONSULTAVIV_SIT & " = " & Globales.SITUAC_FINAL_SINVALIDAR & _
                     " OR " & Globales.COL_CONSULTAVIV_SIT & " = " & Globales.SITUAC_FINAL_CODIFICADA & ")"

            Dim _tablas As String = Me.Operacion & Globales.C_TABLA_VIVIENDA

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO_ORDER
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux, "TO_NUMBER(" & Globales.COL_CONSULTAVIV_NUMC & ") ASC")

            'Se ejecuta la query
            data = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            Return data
        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try
    End Function

    Public Function ObtenerValidaciones() As DataSet
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = Globales.COL_VALIDACIONES_CODIGO & ", " & Globales.COL_VALIDACIONES_NIVEL & ", " & _
                      Globales.COL_VALIDACIONES_DESC_CAS & ", " & Globales.COL_VALIDACIONES_DESC_EUS & ", " & Globales.COL_VALIDACIONES_VALORDES & ", " & _
                        Globales.COL_VALIDACIONES_TABDES & ", " & _
                      Globales.COL_VALIDACIONES_PERFIL

            Dim _filtroAux As String = ""

            _filtroAux += " " & Globales.COL_VALIDACIONES_TABDES & " IS NOT NULL"

            Dim _tablas As String = Me.Operacion & Globales.C_TABLA_VALIDACION

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO_ORDER
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux, Globales.COL_VALIDACIONES_CODIGO)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)

            Return data
        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try
    End Function

    Private Function ObtenerDatosInfFamiliar(ByVal fila As DataRow) As DataSet
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = Globales.COL_CONSULTAIND_NOM & " || ' ' || " & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & Globales.COL_CONSULTAIND_APE2 & " AS " & Globales.ALIAS_CONSULTAIND_NOM
            strSelect = strSelect & "," & Globales.COL_CONSULTAIND_EDAD & "," & Globales.COL_CONSULTAIND_TLFNO1 & "," & Globales.COL_CONSULTAIND_TLFNO2 & "," & Globales.COL_CONSULTAIND_NIND

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & Globales.COL_CONSULTAIND_NUMC & " =:  " & Globales.COL_CONSULTAIND_NUMC
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_ANIO & " =: " & Globales.COL_CONSULTAIND_ANIO
            If Not String.IsNullOrEmpty(Me.Trim) Then
                _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_TRIM & " =: " & Globales.COL_CONSULTAIND_TRIM
            End If
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_INDFAM & " = '" & Globales.VALOR_SI_IND & "'"

            Dim cmd(3) As OracleParameter

            cmd(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, fila(Globales.COL_CONSULTAIND_NUMC))
            cmd(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.Number, Me.Anio)
            If Not String.IsNullOrEmpty(Me.Trim) Then
                cmd(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_TRIM, OracleType.Number, Me.Trim)
            End If

            Dim _tablas As String = Me.Operacion & Globales.C_TABLA_INDIVIDUOS

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, cmd)
            Return data
        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try
    End Function

    Private Function ObtenerDatosInfIndividual(ByVal fila As DataRow) As DataSet
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = Globales.COL_CONSULTAIND_NOM & " || ' ' || " & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & Globales.COL_CONSULTAIND_APE2 & " AS " & Globales.ALIAS_CONSULTAIND_NOM
            strSelect = strSelect & "," & Globales.COL_CONSULTAIND_EDAD & "," & Globales.COL_CONSULTAIND_TLFNO1 & "," & Globales.COL_CONSULTAIND_TLFNO2 & "," & Globales.COL_CONSULTAIND_NIND

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & Globales.COL_CONSULTAIND_NUMC & " =:  " & Globales.COL_CONSULTAIND_NUMC
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_ANIO & " =: " & Globales.COL_CONSULTAIND_ANIO
            If Not String.IsNullOrEmpty(Me.Trim) Then
                _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_TRIM & " =: " & Globales.COL_CONSULTAIND_TRIM
            End If
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_NIND & " =: " & Globales.COL_CONSULTAIND_NIND

            Dim cmd(4) As OracleParameter

            cmd(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, fila(Globales.COL_CONSULTAIND_NUMC))
            cmd(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.Number, Me.Anio)
            If Not String.IsNullOrEmpty(Me.Trim) Then
                cmd(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_TRIM, OracleType.Number, Me.Trim)
            End If
            cmd(3) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NIND, OracleType.VarChar, fila(Globales.COL_CONSULTAIND_NIND))

            Dim _tablas As String = Me.Operacion & Globales.C_TABLA_INDIVIDUOS

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, cmd)
            Return data
        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try
    End Function

    Public Function ObtenerInfIndividual(ByVal vnumc As String, ByVal vanio As String, ByVal vtrim As String, ByVal vnind As String) As String
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = Globales.COL_CONSULTAIND_INFPER

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & Globales.COL_CONSULTAIND_NUMC & " =:  " & Globales.COL_CONSULTAIND_NUMC
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_ANIO & " =: " & Globales.COL_CONSULTAIND_ANIO
            If Not String.IsNullOrEmpty(Me.Trim) Then
                _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_TRIM & " =: " & Globales.COL_CONSULTAIND_TRIM
            End If
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_NIND & " =: " & Globales.COL_CONSULTAIND_NIND

            Dim cmd(4) As OracleParameter

            cmd(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, vnumc)
            cmd(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.VarChar, vanio)
            If Not String.IsNullOrEmpty(Me.Trim) Then
                cmd(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_TRIM, OracleType.VarChar, vtrim)
            End If
            cmd(3) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NIND, OracleType.VarChar, vnind)

            Dim _tablas As String = Me.Operacion & Globales.C_TABLA_INDIVIDUOS

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, cmd)
            If data IsNot Nothing AndAlso data.Tables(0).Rows.Count > 0 Then
                Return data.Tables(0).Rows(0).Item(Globales.COL_CONSULTAIND_INFPER).ToString()
            End If
            Return String.Empty
        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try
    End Function


    Public Function ObtenerAgente(ByVal tipoCuestionario As TipoCuestionario, ByVal vnumc As String, ByVal vanio As String, ByVal vtrim As String, ByVal vnind As String) As String
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = Globales.COL_CUESTIONARIO_AGENTE

            Dim _filtroAux As String = ""

            _filtroAux = _filtroAux & Globales.COL_CONSULTAIND_NUMC & " =:  " & Globales.COL_CONSULTAIND_NUMC
            _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_ANIO & " =: " & Globales.COL_CONSULTAIND_ANIO

            If Not String.IsNullOrEmpty(Me.Trim) Then
                _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_TRIM & " =: " & Globales.COL_CONSULTAIND_TRIM
            End If

            Dim cmd(4) As OracleParameter
            cmd(0) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, vnumc)
            cmd(1) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.VarChar, vanio)
            If Not String.IsNullOrEmpty(Me.Trim) Then
                cmd(2) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_TRIM, OracleType.VarChar, vtrim)
            End If

            Dim _tablas As String = Me.Operacion & Globales.C_TABLA_CUESTIONARIO

            If tipoCuestionario = ValidacionGeneralESIF.TipoCuestionario.Individual Then
                _filtroAux = _filtroAux & " AND " & Globales.COL_CONSULTAIND_NIND & " =: " & Globales.COL_CONSULTAIND_NIND
                cmd(3) = Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NIND, OracleType.VarChar, vnind)
                _tablas = Me.Operacion & Globales.C_TABLA_CUESTIONARIOIND
            End If

            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, _tablas, _filtroAux)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, cmd)
            If data IsNot Nothing AndAlso data.Tables(0).Rows.Count > 0 Then
                Return data.Tables(0).Rows(0).Item(Globales.COL_CUESTIONARIO_AGENTE).ToString()
            End If
            Return String.Empty
        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION, ex.InnerException)
        End Try
    End Function

    Protected Sub AñadirResultado(ByVal numc As String, ByVal stNind As String, ByVal stNombre As String, ByVal stEdad As String, ByVal tlfno1 As String, ByVal tlfno2 As String, ByVal tipoFam As String, ByVal tipoInd As String)
        'Compruebo si debo insertar un nuevo registro, combinarlo o no hacer nada
        'Compruebo si ya existe ese registro para el numc
        Dim dtSelect As DataRow() = Me.ObjResultadoPantalla.Select(IdentColumnNumc & " = '" & numc & "' and " & IdentColumnNind & " = '" & stNind & "'")
        If (dtSelect.Length = 0) Then
            'si no existe lo añado
            Me.ObjResultadoPantalla.Rows.Add(numc, stNind, stNombre, stEdad, tlfno1, tlfno2, tipoFam, tipoInd)
        Else
            'si existe
            'miro si es el mismo tipo de error
            Dim tipoFamExistente As String = dtSelect(0)(IdentColumnCFam).ToString()
            Dim tipoIndExistente As String = dtSelect(0)(IdentColumnCInd).ToString()

            If (Not String.IsNullOrEmpty(tipoFam) And Not (tipoFamExistente.Equals(Globales.ERROR_DURO))) Then
                If (Not String.IsNullOrEmpty(tipoFam) And Not (tipoFamExistente.Equals(tipoFam))) Then
                    'si ahora es un error duro y antes un error blando, lo modifico
                    If ((tipoFamExistente.Equals(Globales.ERROR_BLANDO) And tipoFam.Equals(Globales.ERROR_DURO)) Or String.IsNullOrEmpty(tipoFamExistente)) Then
                        dtSelect(0)(IdentColumnCFam) = tipoFam
                    End If

                End If
            End If

            If (Not String.IsNullOrEmpty(tipoInd) And Not (tipoIndExistente.Equals(Globales.ERROR_DURO))) Then
                If (Not String.IsNullOrEmpty(tipoInd) And Not (tipoIndExistente.Equals(tipoInd))) Then
                    'si ahora es un error duro y antes un error blando, lo modifico
                    If ((tipoIndExistente.Equals(Globales.ERROR_BLANDO) And tipoInd.Equals(Globales.ERROR_DURO)) Or String.IsNullOrEmpty(tipoIndExistente)) Then
                        dtSelect(0)(IdentColumnCInd) = tipoInd
                    End If

                End If
            End If

        End If

    End Sub

    Public Sub AceptarErroresBlandos()
        Dim fila As DataRow
        Me.numVivPendCodif = 0
        Me.numVivFinalizadas = 0
        Me.numVivFinalizadasParciales = 0
        Dim dtAuxiliar As DataSet = ObtenerInfvivienda()
        dtAuxiliar.Tables(0).TableName = Me.Operacion & Globales.C_TABLA_VIVIENDA

        'Modificar la situacion de las viviendas correctas
        For Each fila In Me.ObjDtvivienda.Tables(0).Rows

            If Not (Me.htViviendas.ContainsKey(fila.Item(Globales.COL_CONSULTAVIV_NUMC).ToString & "_" & Globales.ERROR_DURO)) And _
               (Me.htViviendas.ContainsKey(fila.Item(Globales.COL_CONSULTAVIV_NUMC).ToString & "_" & Globales.ERROR_BLANDO)) Then

                Dim filtro As String = Globales.COL_CONSULTAVIV_NUMC & " = '" & fila.Item(Globales.COL_CONSULTAVIV_NUMC).ToString & "'" & _
                                                                   " and " & Globales.COL_CONSULTAVIV_ANIO & " = " & fila.Item(Globales.COL_CONSULTAVIV_ANIO).ToString
                If Not String.IsNullOrEmpty(Me.Trim) Then
                    filtro &= " and " & Globales.COL_CONSULTAVIV_TRIM & " = " & fila.Item(Globales.COL_CONSULTAVIV_TRIM).ToString
                End If

                Dim dtRow As DataRow = dtAuxiliar.Tables(0).Select(filtro)(0)
                ModificarSituacionResultadoVivienda(dtRow)

                EliminarNumcResultado(dtRow)
                Me.numVivBlandos -= 1
                Me.numVivNoValidas -= 1
            End If

        Next
        Me.ObjResultadoPantalla.AcceptChanges()
        'Guardar Viviendas
        MyBase.guardarDataSet(dtAuxiliar)
    End Sub

    Sub EliminarNumcResultado(ByVal dtAEliminar As DataRow)
        Try
            Dim dtRow As DataRow = Me.ObjResultadoPantalla.Select(IdentColumnNumc & " = '" & dtAEliminar.Item(Globales.COL_CONSULTAVIV_NUMC).ToString & "'")(0)

            dtRow.Delete()
        Catch ex As Exception
            Throw New ValidacionException(Globales.EX_VALIDACION & "(" & Me.MsjError & ")", ex.InnerException)
        End Try
    End Sub

    Function ObtenerExistenCuestionariosNoCompletos(ByVal numc As String, ByVal anio As String, ByVal trim As String) As Integer
        Try
            Dim Result As Integer = 0
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = " count(" & Globales.COL_CONSULTAIND_NIND & ")"

            Dim filtro As String = String.Empty

            filtro = filtro & Globales.COL_CONSULTAIND_NUMC & " = '" & numc & "'"
            filtro = filtro & " AND " & Globales.COL_CONSULTAIND_ANIO & " = '" & anio & "'"
            If Not String.IsNullOrEmpty(trim) Then
                filtro = filtro & " AND " & Globales.COL_CONSULTAIND_TRIM & " = '" & trim & "'"
            End If

            filtro = filtro & " AND " & Globales.COL_CONSULTAIND_RPER & " <> '" & Globales.VALOR_COD_COMPLETO & "'"
            filtro = filtro & " AND " & Globales.COL_CONSULTAIND_INDPER & " = '" & Globales.VALOR_SI_IND & "'"

            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me.Operacion & Globales.C_TABLA_INDIVIDUOS, filtro)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables(0).Rows.Count > 0 Then
                Result = data.Tables(0).Rows(0)(0)
            End If
            Return Result
        Catch ex As Exception
            Throw New ColectivoException(Globales.EX_COLECT_CARGA, ex.InnerException)
        End Try
    End Function

    Public Overridable Function ValidacionCuestionarioFamiliar(ByVal tablas As String) As Boolean
        Return tablas.Contains(Me.Operacion & Globales.C_TABLA_CUESTIONARIOFAM)
    End Function

    Public Overridable Function ValidacionCuestionarioIndividual(ByVal tablas As String) As Boolean
        Return tablas.Contains(Me.Operacion & Globales.C_TABLA_CUESTIONARIOIND)
    End Function

    Public Function ValidacionEBP(ByVal tablas As String) As Boolean
        Return tablas.Contains(Globales.C_TABLA_EBP)
    End Function

#End Region

End Class
