﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos


<Serializable()> _
Public Class Turno
    Inherits EntidadBase

#Region "VARIABLES"

    Private _select As String = String.Empty
    Private _nombretablaope As String = String.Empty

    Private _tieneTurno As Boolean

#End Region

#Region "CONSTRUCTOR"
    Sub New(ByVal p1 As String)
        _nombretablaope = p1
        _tieneTurno = False
        Cargar()
    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_VIVIENDA
        End Get
    End Property

#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener si la encuesta tiene campo Turno.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property TieneTurno() As Boolean
        Get
            Return _tieneTurno
        End Get
    End Property


#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT

            Dim strSelect As String = Globales.COL_CONSULTAVIV_TURN

            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _tieneTurno = True
            End If
            MyBase.Cargar()
        Catch ex As Exception
            _tieneTurno = False
        End Try
    End Sub
#End Region

#End Region
End Class
