﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa los diferentes trimestres.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class Trimestre
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsCamposGeneralesVivTrim As DataSet
    Private _filtro As String = String.Empty
    Private _select As String = String.Empty
    Private _nombretablaope As String = String.Empty

    Private Const id As String = "ID"
    Private Const desc As String = "DESCRIP"
#End Region

#Region "CONSTRUCTOR"
    Sub New(ByVal p1 As String)
        _nombretablaope = p1
        Cargar()
    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_VIVIENDA
        End Get
    End Property

#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return id
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaDescripcion() As String
        Get
            Return desc
        End Get
    End Property

#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_DIST_ORDER

            Dim strSelect As String = Globales.COL_CONSULTAVIV_TRIM & " as " & ColumnaId & ", to_char(" & Globales.COL_CONSULTAVIV_TRIM & ") as " & ColumnaDescripcion

            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, ColumnaId)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dsCamposGeneralesVivTrim = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            _dsCamposGeneralesVivTrim = Nothing
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener trimestres.
    ''' </summary>
    ''' <returns>DataSet con el listado de trimestres.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetDsTrim() As DataSet
        Return _dsCamposGeneralesVivTrim
    End Function

    ''' <summary>
    ''' Obtener el mayor trimestre para el año seleccionado que tenga datos en la muestra.
    ''' </summary>
    ''' <returns>Mayor trimestre que debe ser seleccionado en el combo por defecto.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function ObtenerMayorTrimestre(ByVal anio As Integer) As Integer
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_DIST_FILTRO_ORDER

            Dim strSelect As String = Globales.COL_CONSULTAVIV_TRIM

            Dim strWhere As String = Globales.COL_CONSULTAVIV_ANIO & " = " & anio

            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, strWhere, Globales.COL_CONSULTAVIV_TRIM & " desc")

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data.Tables(0).Rows(0)(0)
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New AniosException(Globales.EX_ANIOS_CARGA, ex)
        End Try
    End Function


#End Region
#End Region
End Class
