﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa las diferentes situaciones.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class Situaciones
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsSituaciones As DataSet
    Private _filtro As String = String.Empty
#End Region

#Region "CONSTRUCTOR"
    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()
        Me.Cargar()
    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_SITUACION
        End Get
    End Property
#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return Globales.COL_SITUACION_ID
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaDescripcion(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_SITUACION_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_SITUACION_LITEUS
            End If
            Return column
        End Get
    End Property

    
#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_ORDER

            Dim strSelect As String = Globales.COL_SITUACION_ID & ", " & Globales.COL_SITUACION_LITCAS & ", " & Globales.COL_SITUACION_LITEUS

            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, Globales.COL_SITUACION_ID)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Dim dtRow As DataRow
                dtRow = data.Tables(0).NewRow()
                dtRow(Globales.COL_SITUACION_ID) = DBNull.Value
                dtRow(Globales.COL_SITUACION_LITCAS) = Globales.C_ELIJA_CAS
                dtRow(Globales.COL_SITUACION_LITEUS) = Globales.C_ELIJA_EUS
                data.Tables(0).Rows.InsertAt(dtRow, 0)
                _dsSituaciones = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New SituacionesException(Globales.EX_SITUAC_CARGA, ex)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener situaciones.
    ''' </summary>
    ''' <returns>DataSet con el listado de las situaciones.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetDsSituaciones() As DataSet
        Return _dsSituaciones
    End Function



    ''' <summary>
    ''' Obtener Situacioness.
    ''' </summary>
    ''' <returns>DataSet con el listado de las Situacioness.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetSituaciones()
        _filtro = String.Empty
        Try
            Me.Cargar()
            Return _dsSituaciones
        Catch ex As Exception
            Throw New SituacionesException(Globales.EX_SITUAC_CARGA, ex.InnerException)
        End Try
    End Function
#End Region
#End Region
End Class
