﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa los diferentes Resultados de vivienda.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class ResultadoViv
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsResultadoViv As DataSet
    Private _operacion As String = String.Empty
#End Region

#Region "CONSTRUCTOR"
    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New(ByVal ope As String)
        _operacion = ope
        Me.Cargar()
    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTVIV
        End Get
    End Property
#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return Globales.COL_RESULTVIV_ID
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaDescripcion(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_RESULTVIV_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_RESULTVIV_LITEUS
            End If
            Return column
        End Get
    End Property


#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_FILTRO_ORDER

            Dim strSelect As String = NombreTabla & "." & Globales.COL_RESULTVIV_ID & ", " & Globales.COL_RESULTVIV_LITCAS & ", " & Globales.COL_RESULTVIV_LITEUS
            Dim strFrom As String = NombreTabla & ", " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTVIV_OPE
            Dim cmd(0) As OracleParameter
            Dim strWhere As String = NombreTabla & "." & Globales.COL_RESULTVIV_ID & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTVIV_OPE & "." & Globales.COL_RESULTVIVOPE_CODRVIV & "(+) AND NVL(" & Globales.COL_RESULTVIVOPE_CODOPE & ",:" & Globales.COL_RESULTVIVOPE_CODOPE & ") = :" & Globales.COL_RESULTVIVOPE_CODOPE
            cmd(0) = Me.CrearParametroOracle(Globales.COL_RESULTVIVOPE_CODOPE, OracleType.VarChar, _operacion)

            strQuery = String.Format(strQuery, strSelect, strFrom, strWhere, Globales.COL_RESULTVIV_ID)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, cmd)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Dim dtRow As DataRow
                dtRow = data.Tables(0).NewRow()
                dtRow(Globales.COL_RESULTVIV_ID) = DBNull.Value
                dtRow(Globales.COL_RESULTVIV_LITCAS) = Globales.C_ELIJA_CAS
                dtRow(Globales.COL_RESULTVIV_LITEUS) = Globales.C_ELIJA_EUS
                data.Tables(0).Rows.InsertAt(dtRow, 0)
                _dsResultadoViv = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New ResultVivException(Globales.EX_RVIV_CARGA, ex)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener Resultados de vivienda.
    ''' </summary>
    ''' <returns>DataSet con el listado de Resultados de vivienda.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetDsResultadoViv() As DataSet
        Return _dsResultadoViv
    End Function



    ''' <summary>
    ''' Obtener Resultados de vivienda.
    ''' </summary>
    ''' <returns>DataSet con el listado de las Resultados de vivienda.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetResultadoViv()
        Try
            Me.Cargar()
            Return _dsResultadoViv
        Catch ex As Exception
            Throw New ResultVivException(Globales.EX_RVIV_CARGA, ex.InnerException)
        End Try
    End Function
#End Region
#End Region
End Class
