﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa los diferentes resultados de cuestionario.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class ResultadoCuest
    Inherits EntidadBase

#Region "VARIABLES"
    Private _operacion As String
    Private _dsResultadoCuest As DataSet
    Private _filtro As String = String.Empty
#End Region

#Region "CONSTRUCTOR"
    ''' <summary>
    ''' Cueststructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New(ByVal operacion As String)
        _operacion = operacion
        Me.Cargar()

    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST
        End Get
    End Property
#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return Globales.COL_RESULTCUEST_ID
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaDescripcion(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.COL_RESULTCUEST_LITCAS
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.COL_RESULTCUEST_LITEUS
            End If
            Return column
        End Get
    End Property


#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_FILTRO_ORDER

            Dim strSelect As String = NombreTabla & "." & Globales.COL_RESULTCUEST_ID & ", " & Globales.COL_RESULTCUEST_LITCAS & ", " & Globales.COL_RESULTCUEST_LITEUS
            Dim strFrom As String = NombreTabla & ", " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST_OPE
            Dim cmd(0) As OracleParameter
            Dim strWhere As String = NombreTabla & "." & Globales.COL_RESULTCUEST_ID & " = " & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_RESULTCUEST_OPE & "." & Globales.COL_RESULTCUESTOPE_CODRCUEST & "(+) AND NVL(" & Globales.COL_RESULTCUESTOPE_CODOPE & ",:" & Globales.COL_RESULTCUESTOPE_CODOPE & ") = :" & Globales.COL_RESULTCUESTOPE_CODOPE
            cmd(0) = Me.CrearParametroOracle(Globales.COL_RESULTCUESTOPE_CODOPE, OracleType.VarChar, _operacion)

            strQuery = String.Format(strQuery, strSelect, strFrom, strWhere, Globales.COL_RESULTCUEST_ID)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, cmd)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Dim dtRow As DataRow
                dtRow = data.Tables(0).NewRow()
                dtRow(Globales.COL_RESULTCUEST_ID) = DBNull.Value
                dtRow(Globales.COL_RESULTCUEST_LITCAS) = Globales.C_ELIJA_CAS
                dtRow(Globales.COL_RESULTCUEST_LITEUS) = Globales.C_ELIJA_EUS
                data.Tables(0).Rows.InsertAt(dtRow, 0)
                _dsResultadoCuest = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New ResultCuestException(Globales.EX_RCUEST_CARGA, ex)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener resultados de cuestionario.
    ''' </summary>
    ''' <returns>DataSet con el listado de resultados de cuestionario.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetDsResultadoCuest() As DataSet
        Return _dsResultadoCuest
    End Function



    ''' <summary>
    ''' Obtener ResultadoCuest.
    ''' </summary>
    ''' <returns>DataSet con el listado de los resultados de cuestionario.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetResultadoCuest()
        _filtro = String.Empty
        Try
            Me.Cargar()
            Return _dsResultadoCuest
        Catch ex As Exception
            Throw New ResultCuestException(Globales.EX_RCUEST_CARGA, ex.InnerException)
        End Try
    End Function
#End Region
#End Region
End Class
