﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa las diferentes Operaciones de usuario.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class OperacionesUsuario
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsOperacionesUsuario As DataSet
    Private _filtro As String = String.Empty
    Private _multipleOp As Boolean = False
    Private _operacion As String = String.Empty
#End Region

#Region "CONSTRUCTOR"
    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()
        Me.Cargar()
    End Sub

#End Region

#Region "PROPIEDADES"

#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE & "," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_ENCUESTA
        End Get
    End Property
#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return Globales.COL_USUARIOS_OPE
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaDescripcion(ByVal idioma As String) As String
        Get
            Dim column As String = Globales.ALIAS_ENCUESTA_NOMCAS_COMP
            If (idioma.Equals(Globales.C_IDIOMA_EUSKERA)) Then
                column = Globales.ALIAS_ENCUESTA_NOMEUS_COMP
            End If
            Return column
        End Get
    End Property

    ''' <summary>
    ''' Obtener multiple columna
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property MultipleOperacion() As Boolean
        Get
            Return _multipleOp
        End Get
    End Property

    ''' <summary>
    ''' Obtener operacion
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Operacion() As String
        Get
            Return _operacion
        End Get
        Set(ByVal value As String)
            _operacion = value
        End Set
    End Property
#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try
            _multipleOp = False
            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_FILTRO_ORDER

            Dim strSelect As String = Globales.COL_USUARIOS_OPE & ", " & _
            Globales.COL_ENCUESTA_ABRVCAS & " || ' - ' || " & Globales.COL_ENCUESTA_NOMCAS & " AS " & Globales.ALIAS_ENCUESTA_NOMCAS_COMP & ", " & _
            Globales.COL_ENCUESTA_ABRVEUS & " || ' - ' || " & Globales.COL_ENCUESTA_NOMEUS & " AS " & Globales.ALIAS_ENCUESTA_NOMEUS_COMP

            If Not String.IsNullOrEmpty(_filtro) Then
                _filtro = _filtro & " AND "
            End If
            _filtro = _filtro & Globales.COL_USUARIOS_OPE & " = " & Globales.COL_ENCUESTA_ID
            _filtro = _filtro & " AND " & Globales.COL_USUARIOS_ACTIVO & " = '" & Globales.USUARIO_ACTIVO & "' "

            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, _filtro, Globales.COL_ENCUESTA_ABRVCAS)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _multipleOp = (data.Tables(0).Rows.Count > 1)
                If (Not _multipleOp) Then
                    _operacion = data.Tables(0).Rows(0)(Globales.COL_USUARIOS_OPE).ToString()
                End If
                Dim dtRow As DataRow
                dtRow = data.Tables(0).NewRow()
                dtRow(Globales.COL_USUARIOS_OPE) = DBNull.Value
                dtRow(Globales.ALIAS_ENCUESTA_NOMCAS_COMP) = Globales.C_ELIJA_CAS
                dtRow(Globales.ALIAS_ENCUESTA_NOMEUS_COMP) = Globales.C_ELIJA_EUS
                data.Tables(0).Rows.InsertAt(dtRow, 0)
                _dsOperacionesUsuario = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New OperacionesException(Globales.EX_OPE_CARGA, ex)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener Operaciones usuario.
    ''' </summary>
    ''' <returns>DataSet con el listado de las operaciones del usuario.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetDsOperacionesUsuario() As DataSet
        Return _dsOperacionesUsuario
    End Function

  

    ''' <summary>
    ''' Obtener OperacionesUsuarios.
    ''' </summary>
    ''' <returns>DataSet con el listado de las OperacionesUsuarios.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetOperacionesUsuario(ByVal codusu As String)
        _filtro = String.Empty
        Try
            If Not String.IsNullOrEmpty(codusu) Then

                If Not String.IsNullOrEmpty(codusu) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & Globales.COL_USUARIOS_CODUSU & " = " & codusu
                End If
                Me.Cargar()
            End If

            Return _dsOperacionesUsuario
        Catch ex As Exception
            Throw New OperacionesException(Globales.EX_OPE_CARGA, ex.InnerException)
        End Try
    End Function
#End Region
#End Region
End Class
