﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa las comarcas.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class MunicipiosGedw
    Inherits Eustat.Comun.V35.Ng.Municipios

#Region "VARIABLES"
    Private _dsMunicipios As DataSet
    Private _dvMunicipios As DataView
    Private _filtro As String = String.Empty
#End Region

#Region "CONSTRUCTOR"

    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <param name="firstEmpty">Valor opcional que especifica si se completa la carga con un valor nulo.
    ''' True: incluir primer registro nulo.
    ''' False: NO incluir primer registro nulo.</param>
    ''' <remarks></remarks>
    Public Sub New(Optional ByVal firstEmpty As Boolean = True)
        Me.Cargar()
        If _dvMunicipios IsNot Nothing AndAlso firstEmpty Then
            Dim drEmpty As DataRow = _dvMunicipios.Table.NewRow()
            drEmpty(Globales.ALIAS_MUN_ID) = "-1"
            drEmpty(Globales.ALIAS_MUN_PROVID) = "-1"
            drEmpty(Globales.ALIAS_MUN_NOMBRE) = String.Empty
            _dvMunicipios.Table.Rows.InsertAt(drEmpty, 0)
        End If
    End Sub

#End Region

#Region "METODOS"

#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_ORDER
            strQuery = String.Format(strQuery, String.Concat(Globales.COL_MUN_ID, " AS ", Globales.ALIAS_MUN_ID, ", ",
                                                             Globales.COL_MUN_PROVID, " AS ", Globales.ALIAS_MUN_PROVID, ", ",
                                                             Globales.COL_MUN_NOMBRE, " AS ", Globales.ALIAS_MUN_NOMBRE, ", ",
                                                             Globales.COL_MUN_COMR, " AS ", Globales.ALIAS_MUN_COMR), Me.NombreTabla, Globales.ALIAS_MUN_NOMBRE)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dsMunicipios = data
                _dvMunicipios = New DataView(_dsMunicipios.Tables(0))
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New ProvinciaException(Globales.EX_MUNICIPIO, ex)
        End Try
    End Sub

    ''' <summary>
    ''' Obtener municipios.
    ''' </summary>
    ''' <returns>DataSet con el listado de los municipios.
    ''' </returns>
    ''' <remarks></remarks>
    Public Overloads Function GetMunicipios() As DataView
        _dvMunicipios.RowFilter = String.Empty
        Return _dvMunicipios
    End Function

    ''' <summary>
    ''' Obtener municipios de una provincia concreta.
    ''' </summary>
    ''' <param name="id">Identificador de la provincia.</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overloads Function GetMunicipios(ByVal id As String) As DataView
        If _dvMunicipios IsNot Nothing Then
            _dvMunicipios.RowFilter = String.Concat(Globales.ALIAS_MUN_ID, " = '-1' OR ", Globales.ALIAS_MUN_PROVID, " = ", id)
        End If
        Return _dvMunicipios
    End Function

#End Region

#Region "PROPIOS"

    ''' <summary>
    ''' Obtener municipios de una comarca concreta.
    ''' </summary>
    ''' <param name="idComarca">Identificador de la comarca.</param>
    ''' <param name="idProvincia">Identificador de la provincia.</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetMunicipiosComarcas(ByVal idComarca As String, idProvincia As String) As DataView
        If _dvMunicipios IsNot Nothing Then
            _dvMunicipios.RowFilter = String.Concat(Globales.ALIAS_MUN_ID, " = '-1' OR (", Globales.ALIAS_MUN_COMR, " = ", idComarca, " AND ", Globales.ALIAS_MUN_PROVID, " = ", idProvincia, ")")
        End If
        Return _dvMunicipios
    End Function

#End Region
#End Region

End Class
