﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos


<Serializable()> _
Public Class Muestra
    Inherits EntidadBase

#Region "VARIABLES"
    Private _nombretablaope As String = ""
    Private _numc As String = ""
    Private _aenc As Integer
    Private _tenc As String = ""
    Private _sem As String = ""
    Private _ICNombre As String = ""
    Private _ICtlfno As String = ""
    Private _ICemail As String = ""
    Private _ICrelacion As String = ""
    Private _ICobservaciones As String = ""
    Private _IC As String = ""

#End Region

#Region "CONSTRUCTOR"
    Sub New(ByVal operacionParam As String, ByVal numcParam As String, ByVal aencParam As String, ByVal tencParam As String, ByVal semParam As String)
        _nombretablaope = operacionParam
        _numc = numcParam
        _aenc = aencParam
        _tenc = tencParam
        _sem = semParam
        Me.Cargar()
    End Sub
#End Region

#Region "PROPIEDADES"

#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_VIVIENDA
        End Get
    End Property

#End Region

#Region "PROPIAS"

    Public ReadOnly Property Numc() As String
        Get
            Return _numc
        End Get
    End Property

    Public ReadOnly Property Aenc() As Integer
        Get
            Return _aenc
        End Get
    End Property

    Public ReadOnly Property Tenc() As String
        Get
            Return _tenc
        End Get
    End Property

    Public ReadOnly Property Sem() As String
        Get
            Return _sem
        End Get
    End Property

    Public Property ICNombre() As String
        Get
            Return _ICNombre
        End Get
        Set(ByVal value As String)
            _ICNombre = value
        End Set
    End Property

    Public Property ICTlfno() As String
        Get
            Return _ICtlfno
        End Get
        Set(ByVal value As String)
            _ICtlfno = value
        End Set
    End Property

    Public Property ICEmail() As String
        Get
            Return _ICemail
        End Get
        Set(ByVal value As String)
            _ICemail = value
        End Set
    End Property

    Public Property ICRelacion() As String
        Get
            Return _ICrelacion
        End Get
        Set(ByVal value As String)
            _ICrelacion = value
        End Set
    End Property

    Public Property ICObservaciones() As String
        Get
            Return _ICobservaciones
        End Get
        Set(ByVal value As String)
            _ICobservaciones = value
        End Set
    End Property

    Public Property IC() As String
        Get
            Return _IC
        End Get
        Set(ByVal value As String)
            _IC = value
        End Set
    End Property

#End Region

#End Region

#Region "METODOS"

#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()

        Try
            'guardamos los nuevos valores
            Dim seleccionar As String = Globales.COL_CONSULTAVIV_IC & " , " & _
               Globales.COL_CONSULTAVIV_IC_NOMBRE & " , " & _
               Globales.COL_CONSULTAVIV_IC_TLFNO & " , " & _
               Globales.COL_CONSULTAVIV_IC_EMAIL & " , " & _
               Globales.COL_CONSULTAVIV_IC_OBSERVACIONES & " , " & _
               Globales.COL_CONSULTAVIV_IC_RELACION

            Dim where As String = Globales.COL_CONSULTAVIV_NUMC & "=:" & Globales.COL_CONSULTAVIV_NUMC
            If Not String.IsNullOrEmpty(Aenc) Then
                where = where & " AND " & Globales.COL_CONSULTAVIV_ANIO & "=:" & Globales.COL_CONSULTAVIV_ANIO
            End If
            If Not String.IsNullOrEmpty(Tenc) Then
                where = where & " AND " & Globales.COL_CONSULTAVIV_TRIM & "=:" & Globales.COL_CONSULTAVIV_TRIM
            End If
            If Not String.IsNullOrEmpty(Sem) Then
                where = where & " AND " & Globales.COL_CONSULTAVIV_SEM & "=:" & Globales.COL_CONSULTAVIV_SEM
            End If

            Dim strQuery As String = String.Format(Globales.C_SELECT_FILTRO, seleccionar, Me.NombreTabla, where)

            Dim cmd As New List(Of OracleParameter)

            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_NUMC, OracleType.VarChar, Numc))
            If Not String.IsNullOrEmpty(Aenc) Then
                cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_ANIO, OracleType.Int32, Aenc))
            End If
            If Not String.IsNullOrEmpty(Tenc) Then
                cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_TRIM, OracleType.Int32, Tenc))
            End If
            If Not String.IsNullOrEmpty(Sem) Then
                cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_SEM, OracleType.Int32, Sem))
            End If

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, cmd.ToArray)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 AndAlso data.Tables(0).Rows.Count = 1 Then
                Dim dr As DataRow = data.Tables(0).Rows(0)

                Me.ICNombre = dr(Globales.COL_CONSULTAVIV_IC_NOMBRE).ToString
                Me.ICTlfno = dr(Globales.COL_CONSULTAVIV_IC_TLFNO).ToString
                Me.ICEmail = dr(Globales.COL_CONSULTAVIV_IC_EMAIL).ToString
                Me.ICRelacion = dr(Globales.COL_CONSULTAVIV_IC_RELACION).ToString
                Me.ICObservaciones = dr(Globales.COL_CONSULTAVIV_IC_OBSERVACIONES).ToString
                Me.IC = dr(Globales.COL_CONSULTAVIV_IC).ToString
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New ResultException(Globales.EX_MUESTRA_CARGA, ex.InnerException)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Establecer valor de código IC
    ''' </summary>
    ''' <param name="EsIC">La vivienda es IC</param>
    ''' <remarks></remarks>
    Public Sub EstablecerCodigoIC(ByVal EsIC As Boolean)

        If String.IsNullOrEmpty(Me.IC) Then
            If EsIC Then
                Me.IC = Globales.VALOR_COD_IC_SI & Globales.VALOR_COD_IC_ORIGEN_GESTOR
            End If
        Else
            If EsIC Then
                Me.IC = Globales.VALOR_COD_IC_SI & Me.IC.Substring(1, 1)
            Else
                Me.IC = Globales.VALOR_COD_IC_NO & Me.IC.Substring(1, 1)
            End If
        End If
    End Sub




    Public Overrides Sub Actualizar()
        Try
            'guardamos los nuevos valores
            Dim values As String = Globales.COL_CONSULTAVIV_IC & "=:" & Globales.COL_CONSULTAVIV_IC & " , " & _
               Globales.COL_CONSULTAVIV_IC_NOMBRE & "=:" & Globales.COL_CONSULTAVIV_IC_NOMBRE & " , " & _
               Globales.COL_CONSULTAVIV_IC_TLFNO & "=:" & Globales.COL_CONSULTAVIV_IC_TLFNO & " , " & _
               Globales.COL_CONSULTAVIV_IC_EMAIL & "=:" & Globales.COL_CONSULTAVIV_IC_EMAIL & " , " & _
               Globales.COL_CONSULTAVIV_IC_OBSERVACIONES & "=:" & Globales.COL_CONSULTAVIV_IC_OBSERVACIONES & " , " & _
               Globales.COL_CONSULTAVIV_IC_RELACION & "=:" & Globales.COL_CONSULTAVIV_IC_RELACION

            Dim where As String = Globales.COL_CONSULTAVIV_NUMC & "=:" & Globales.COL_CONSULTAVIV_NUMC
            If Not String.IsNullOrEmpty(Me.Aenc) Then
                where = where & " AND " & Globales.COL_CONSULTAVIV_ANIO & "=:" & Globales.COL_CONSULTAVIV_ANIO
            End If
            If Not String.IsNullOrEmpty(Me.Tenc) Then
                where = where & " AND " & Globales.COL_CONSULTAVIV_TRIM & "=:" & Globales.COL_CONSULTAVIV_TRIM
            End If
            If Not String.IsNullOrEmpty(Me.Sem) Then
                where = where & " AND " & Globales.COL_CONSULTAVIV_SEM & "=:" & Globales.COL_CONSULTAVIV_SEM
            End If

            Dim sql As String = String.Format(Globales.UPDATE_GENERICO, Me.NombreTabla, values, where)

            Dim cmd As New List(Of OracleParameter)

            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_NUMC, OracleType.VarChar, Me.Numc))
            If Not String.IsNullOrEmpty(Me.Aenc) Then
                cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_ANIO, OracleType.Int32, Me.Aenc))
            End If
            If Not String.IsNullOrEmpty(Me.Tenc) Then
                cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_TRIM, OracleType.Int32, Me.Tenc))
            End If
            If Not String.IsNullOrEmpty(Me.Sem) Then
                cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_SEM, OracleType.Int32, Me.Sem))
            End If

            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_IC, OracleType.VarChar, IIf(String.IsNullOrEmpty(Me.IC), DBNull.Value, Me.IC)))
            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_IC_NOMBRE, OracleType.VarChar, IIf(String.IsNullOrEmpty(Me.ICNombre), DBNull.Value, Me.ICNombre)))
            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_IC_TLFNO, OracleType.VarChar, IIf(String.IsNullOrEmpty(Me.ICTlfno), DBNull.Value, Me.ICTlfno)))
            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_IC_EMAIL, OracleType.VarChar, IIf(String.IsNullOrEmpty(Me.ICEmail), DBNull.Value, Me.ICEmail)))
            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_IC_RELACION, OracleType.VarChar, IIf(String.IsNullOrEmpty(Me.ICRelacion), DBNull.Value, Me.ICRelacion)))
            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAVIV_IC_OBSERVACIONES, OracleType.VarChar, IIf(String.IsNullOrEmpty(Me.ICObservaciones), DBNull.Value, Me.ICObservaciones)))
            Me.EjecutarNoSQL(sql, CommandType.Text, cmd.ToArray)


        Catch ex As Exception
            Throw New ResultException(Globales.EX_MUESTRA_ACTUALIZAR, ex.InnerException)
        End Try
    End Sub

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener si la vivienda tiene al menos un cuestionario con informante IC
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function TieneInformanteIC() As Boolean
        MyBase.Cargar()
        Try
            'guardamos los nuevos valores
            Dim seleccionar As String = Globales.COL_CONSULTAIND_INFPER

            Dim where As String = Globales.COL_CONSULTAVIV_NUMC & "=:" & Globales.COL_CONSULTAIND_NUMC
            If Not String.IsNullOrEmpty(Aenc) Then
                where = where & " AND " & Globales.COL_CONSULTAIND_ANIO & "=:" & Globales.COL_CONSULTAIND_ANIO
            End If
            If Not String.IsNullOrEmpty(Tenc) Then
                where = where & " AND " & Globales.COL_CONSULTAVIV_TRIM & "=:" & Globales.COL_CONSULTAIND_TRIM
            End If

            where = where & " AND ( " & Globales.COL_CONSULTAIND_INFPER & "=:" & Globales.COL_CONSULTAIND_INFPER & " OR " & Globales.COL_CONSULTAIND_INDFAM & "=:" & Globales.COL_CONSULTAIND_INDFAM & " ) "

            Dim strQuery As String = String.Format(Globales.C_SELECT_FILTRO, seleccionar, _nombretablaope & Globales.C_TABLA_INDIVIDUOS, where)


            Dim cmd As New List(Of OracleParameter)

            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, Numc))
            If Not String.IsNullOrEmpty(Aenc) Then
                cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.Int32, Aenc))
            End If
            If Not String.IsNullOrEmpty(Tenc) Then
                cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAIND_TRIM, OracleType.Int32, Tenc))
            End If

            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAIND_INFPER, OracleType.VarChar, Globales.VALOR_COD_IC_PERSONA_CONFIANZA))
            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAIND_INDFAM, OracleType.VarChar, Globales.VALOR_COD_IC_PERSONA_CONFIANZA))

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, cmd.ToArray)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 AndAlso data.Tables(0).Rows.Count > 0 Then
                Return True
            Else
                Return False
            End If

        Catch ex As Exception
            Throw New ResultException(Globales.EX_MUESTRA_CARGA, ex.InnerException)
        End Try
    End Function

    ''' <summary>
    ''' Obtener si la vivienda tiene al menos un cuestionario con informante IC
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function TieneInformanteFamIC() As Boolean
        MyBase.Cargar()
        Try
            'guardamos los nuevos valores
            Dim seleccionar As String = Globales.COL_CONSULTAIND_INDFAM

            Dim where As String = Globales.COL_CONSULTAVIV_NUMC & "=:" & Globales.COL_CONSULTAIND_NUMC
            If Not String.IsNullOrEmpty(Aenc) Then
                where = where & " AND " & Globales.COL_CONSULTAIND_ANIO & "=:" & Globales.COL_CONSULTAIND_ANIO
            End If
            If Not String.IsNullOrEmpty(Tenc) Then
                where = where & " AND " & Globales.COL_CONSULTAVIV_TRIM & "=:" & Globales.COL_CONSULTAIND_TRIM
            End If
            If Not String.IsNullOrEmpty(Sem) Then
                where = where & " AND " & Globales.COL_CONSULTAIND_SENC & "=:" & Globales.COL_CONSULTAIND_SENC
            End If

            where = where & " AND " & Globales.COL_CONSULTAIND_INDFAM & "=:" & Globales.COL_CONSULTAIND_INDFAM

            Dim strQuery As String = String.Format(Globales.C_SELECT_FILTRO, seleccionar, _nombretablaope & Globales.C_TABLA_INDIVIDUOS, where)


            Dim cmd As New List(Of OracleParameter)

            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAIND_NUMC, OracleType.VarChar, Numc))
            If Not String.IsNullOrEmpty(Aenc) Then
                cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAIND_ANIO, OracleType.Int32, Aenc))
            End If
            If Not String.IsNullOrEmpty(Tenc) Then
                cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAIND_TRIM, OracleType.Int32, Tenc))
            End If
            If Not String.IsNullOrEmpty(Sem) Then
                cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAIND_SENC, OracleType.Int32, Sem))
            End If

            cmd.Add(Me.CrearParametroOracle(Globales.COL_CONSULTAIND_INDFAM, OracleType.VarChar, Globales.VALOR_COD_IC_PERSONA_CONFIANZA))

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, cmd.ToArray)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 AndAlso data.Tables(0).Rows.Count > 0 Then
                Return True
            Else
                Return False
            End If

        Catch ex As Exception
            Throw New ResultException(Globales.EX_MUESTRA_CARGA, ex.InnerException)
        End Try
    End Function
#End Region
#End Region
#End Region
End Class
