﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa las diferentes meses.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class Mes
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsCamposGeneralesVivMes As DataSet
    Private _filtro As String = String.Empty
    Private _select As String = String.Empty
    Private _nombretablaope As String = String.Empty

    Private Const id As String = "ID"
    Private Const desc As String = "DESCRIP"
#End Region

#Region "CONSTRUCTOR"
    Sub New(ByVal p1 As String)
        _nombretablaope = p1
        Cargar()
    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_VIVIENDA
        End Get
    End Property

#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return id
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaDescripcion() As String
        Get
            Return desc
        End Get
    End Property

#End Region
#End Region

#Region "METODOS"

#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_DIST_ORDER


            Dim strSelect As String = "TO_CHAR(" & Globales.COL_CONSULTAVIV_FREF & ",'MM')" & " as " & ColumnaId & ", to_char(" & Globales.COL_CONSULTAVIV_FREF & ", 'Month','NLS_DATE_LANGUAGE = SPANISH') as " & ColumnaDescripcion

            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, ColumnaId)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dsCamposGeneralesVivMes = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            _dsCamposGeneralesVivMes = Nothing
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener meses
    ''' </summary>
    ''' <returns>DataSet con el listado de Años.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetDsMes() As DataSet
        Return _dsCamposGeneralesVivMes
    End Function

#End Region
#End Region
End Class
