﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa lote.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class Lote
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsCamposGeneralesVivLote As DataSet 
    Private _select As String = String.Empty

    Private Const id As String = "ID"
    Private Const desc As String = "DESCRIP"
#End Region

#Region "CONSTRUCTOR"
    Sub New(ByVal ope As String, ByVal usu As String)
        Me.Operacion = ope
        Me.Usuario = usu
        Cargar()
    End Sub
#End Region

#Region "PROPIEDADES"

#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_VIVIENDA
        End Get
    End Property

#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return id
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaDescripcion() As String
        Get
            Return desc
        End Get
    End Property

    Private _nombretablaope As String = String.Empty
    Public Property Operacion() As String
        Get
            Return _nombretablaope
        End Get
        Set(ByVal value As String)
            _nombretablaope = value
        End Set
    End Property


    Private _idusuario As String
    Public Property Usuario() As String
        Get
            Return _idusuario
        End Get
        Set(ByVal value As String)
            _idusuario = value
        End Set
    End Property

#End Region

#End Region

#Region "METODOS"

#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try
            'Primero compruebo si la operación contiene el campo lote
            Dim dtLotesVivienda As DataSet = ObtenerdtLotesVivienda()

            If dtLotesVivienda IsNot Nothing AndAlso dtLotesVivienda.Tables.Count > 0 Then
                'Si existe el campo lote, obtengo los lotes a los cuales tiene permiso ese usuario
                'Se establece la query a ejecutar.
                Dim strQuery As String = Globales.C_SELECT_DIST_FILTRO_ORDER
                Dim cmd(1) As OracleParameter
                Dim strSelect As String = "a." & Globales.COL_CONSULTAVIV_LOTE & " as " & ColumnaId & ", to_char(a." & Globales.COL_CONSULTAVIV_LOTE & ") as " & ColumnaDescripcion

                Dim _filtro As String = String.Empty
                _filtro = "A." & Globales.COL_CONSULTAVIV_LOTE & " IS NOT NULL"
                'Sólo debo visualizar los lotes asociados al usuario conectado
                'si no tiene lotes asociados verá todos
                _filtro &= " AND B." & Globales.COL_CONSULTALOTE_CODUSU & " = :" & Globales.COL_CONSULTALOTE_CODUSU
                cmd(0) = Me.CrearParametroOracle(Globales.COL_CONSULTALOTE_CODUSU, OracleType.VarChar, Me.Usuario)
                _filtro &= " AND B." & Globales.COL_CONSULTALOTE_CODOPE & " = :" & Globales.COL_CONSULTALOTE_CODOPE
                cmd(1) = Me.CrearParametroOracle(Globales.COL_CONSULTALOTE_CODOPE, OracleType.VarChar, Me.Operacion)
                _filtro &= " AND B." & Globales.COL_CONSULTALOTE_LOTE & " = a." & Globales.COL_CONSULTAVIV_LOTE

                strQuery = String.Format(strQuery, strSelect, Me.NombreTabla & " a," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_LOTES & " b", _filtro, ColumnaId)
                'Se ejecuta la query
                Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, cmd)
                'Se recorre los data
                'Si el usuario no tiene asignados lotes especificos, puede acceder a todos
                If (data IsNot Nothing AndAlso data.Tables.Count > 0) Then
                    If (data.Tables(0).Rows.Count > 0) Then
                        _dsCamposGeneralesVivLote = data
                    Else
                        _dsCamposGeneralesVivLote = dtLotesVivienda
                    End If
                Else
                    _dsCamposGeneralesVivLote = dtLotesVivienda
                End If
                MyBase.Cargar()
            Else
                _dsCamposGeneralesVivLote = Nothing
            End If
        Catch ex As Exception
            _dsCamposGeneralesVivLote = Nothing
        End Try
    End Sub

    Public Function ObtenerdtLotesVivienda() As DataSet
        Try
            Dim result As DataSet = Nothing
            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_DIST_FILTRO_ORDER

            Dim _filtro As String = String.Empty
            _filtro = Globales.COL_CONSULTAVIV_LOTE & " IS NOT NULL"

            Dim strSelect As String = Globales.COL_CONSULTAVIV_LOTE & " as " & ColumnaId & ", to_char(" & Globales.COL_CONSULTAVIV_LOTE & ") as " & ColumnaDescripcion

            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, _filtro, ColumnaId)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                result = data
            End If
            Return result
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener Operaciones usuario.
    ''' </summary>
    ''' <returns>DataSet con el listado de Años.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetDsLote() As DataSet
        Return _dsCamposGeneralesVivLote
    End Function
#End Region
#End Region
End Class
