﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa las diferentes integrantes de la vivienda.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class Integrantes
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsIntegrantes As DataSet
    Private _filtro As String = String.Empty
    Private _numc As String
    Private _anio As String
    Private _trim As String
    Private _nombretablaope As String = String.Empty

    Public columnNom As String = Globales.ALIAS_CONSULTAIND_NOM
    Public columnNind As String = Globales.ALIAS_CONSULTAIND_NIND
#End Region

#Region "CONSTRUCTOR"
    Private _p1 As String
    Private _p2 As String
    Private _p3 As String
    Private _p4 As String

    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New(ByVal anio As String, ByVal numc As String, ByVal ope As String)
        _numc = numc
        _anio = anio
        _nombretablaope = ope
    End Sub

    Public Sub New(ByVal anio As String, ByVal numc As String, ByVal ope As String, ByVal trim As String)
        _numc = numc
        _anio = anio
        _trim = trim
        _nombretablaope = ope
    End Sub
    
#End Region

#Region "PROPIEDADES"

#Region "SOBREESCRITAS"

    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_INDIVIDUOS
        End Get
    End Property
#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return Globales.ALIAS_CONSULTAIND_NIND
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaDescripcion() As String
        Get
            Return Globales.ALIAS_CONSULTAIND_NOM
        End Get
    End Property
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaDescripcionNomEdad() As String
        Get
            Return Globales.ALIAS_CONSULTAIND_NOM_EDAD
        End Get
    End Property

#End Region
#End Region

#Region "METODOS"

#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_FILTRO

            Dim strSelect As String = Globales.COL_CONSULTAIND_NOM & " || ' ' || " & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & Globales.COL_CONSULTAIND_APE2 & " AS " & Globales.ALIAS_CONSULTAIND_NOM
            strSelect = strSelect & "," & Globales.COL_CONSULTAIND_NIND & " AS " & Globales.ALIAS_CONSULTAIND_NIND
            strSelect = strSelect & ", " & Globales.COL_CONSULTAIND_NOM & " || ' ' || " & Globales.COL_CONSULTAIND_APE1 & " || ' ' || " & Globales.COL_CONSULTAIND_APE2 & " || ' (' ||" & Globales.COL_CONSULTAIND_EDAD & " || ')' AS " & Globales.ALIAS_CONSULTAIND_NOM_EDAD

            If Not (String.IsNullOrEmpty(_filtro)) Then
                _filtro = _filtro & " AND "
            End If

            _filtro = _filtro & " " & Globales.COL_CONSULTAIND_NUMC & " = '" & Me._numc & "'"
            _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_ANIO & " = " & Me._anio
            If (Not (String.IsNullOrEmpty(Me._trim))) Then
                _filtro = _filtro & " AND " & Globales.COL_CONSULTAIND_TRIM & " = " & Me._trim
            End If
            _filtro = _filtro & " AND (" & Globales.COL_CONSULTAIND_SITA & " <> " & Globales.INDIVIDUO_BAJA & " or " & Globales.COL_CONSULTAIND_SITA & " is null)"
            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, _filtro)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Dim dtRow As DataRow
                dtRow = data.Tables(0).NewRow()
                dtRow(Globales.ALIAS_CONSULTAIND_NOM) = Globales.C_ELIJA_CAS
                dtRow(Globales.ALIAS_CONSULTAIND_NIND) = DBNull.Value
                data.Tables(0).Rows.InsertAt(dtRow, 0)
                _dsIntegrantes = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New IntegrantesVivException(Globales.EX_INTEGRANTES_CARGA, ex)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener Operaciones usuario.
    ''' </summary>
    ''' <returns>DataSet con el listado de las TipoError.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetDsIntegrantes() As DataSet
        Return _dsIntegrantes
    End Function


    Public Function GetIntegrantes()
        _filtro = String.Empty
        Try
            Me.Cargar()
            Return _dsIntegrantes
        Catch ex As Exception
            Throw New IntegrantesVivException(Globales.EX_INTEGRANTES_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function GetIntegrantes(ByVal menores As Boolean)
        _filtro = String.Empty
        Try
            If (Not (menores)) Then

                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & Globales.COL_CONSULTAIND_EDAD & " > 15"
            End If
            Me.Cargar()
            Return _dsIntegrantes
        Catch ex As Exception
            Throw New IntegrantesVivException(Globales.EX_INTEGRANTES_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function GetIntegrantes(ByVal edadMinima As Integer)
        _filtro = String.Empty
        Try

            If Not String.IsNullOrEmpty(_filtro) Then
                _filtro = _filtro & " AND "
            End If
            _filtro = _filtro & Globales.COL_CONSULTAIND_EDAD & " >= " & edadMinima
            Me.Cargar()
            Return _dsIntegrantes

        Catch ex As Exception
            Throw New IntegrantesVivException(Globales.EX_INTEGRANTES_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function GetIntegrantes(ByVal edadMinima As Integer, ByVal nind As String, ByVal edadMinimaNind As Integer)
        _filtro = String.Empty
        Try

            If Not String.IsNullOrEmpty(_filtro) Then
                _filtro = _filtro & " AND"
            End If
            _filtro = _filtro & " ( " & Globales.COL_CONSULTAIND_EDAD & " >= " & edadMinima

            If Not String.IsNullOrEmpty(nind) Then
                _filtro = _filtro & " OR ( " & Globales.COL_CONSULTAIND_NIND & " = " & nind & " AND " & Globales.COL_CONSULTAIND_EDAD & " >= " & edadMinimaNind & " )) "
            End If
            Me.Cargar()
            Return _dsIntegrantes

        Catch ex As Exception
            Throw New IntegrantesVivException(Globales.EX_INTEGRANTES_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function GetIntegrantesEspecifico(ByVal nind As String, ByVal menores As Boolean)
        _filtro = String.Empty
        Try
            If (Not (menores)) Then
                If Not String.IsNullOrEmpty(_filtro) Then
                    _filtro = _filtro & " AND "
                End If
                _filtro = _filtro & "(" & Globales.COL_CONSULTAIND_EDAD & " >= 18 Or "
                _filtro = _filtro & "(" & Globales.COL_CONSULTAIND_EDAD & " >= 15 and "
                _filtro = _filtro & Globales.COL_CONSULTAIND_NIND & " = '" & nind & "'))"
            End If
            Me.Cargar()
            Return _dsIntegrantes
        Catch ex As Exception
            Throw New IntegrantesVivException(Globales.EX_INTEGRANTES_CARGA, ex.InnerException)
        End Try
    End Function
#End Region
#End Region
End Class
