﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos


<Serializable()> _
Public Class IC
    Inherits EntidadBase

    Public Const VALOR_PERSONA_CONFIANZA = Globales.VALOR_COD_IC_PERSONA_CONFIANZA

#Region "VARIABLES"

    Private _select As String = String.Empty
    Private _nombretablaope As String = String.Empty

    Private _tieneIC As Boolean

#End Region

#Region "CONSTRUCTOR"
    Sub New(ByVal p1 As String)
        _nombretablaope = p1
        _tieneIC = False
        Cargar()
    End Sub
#End Region

#Region "PROPIEDADES"

#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return _nombretablaope & Globales.C_TABLA_VIVIENDA
        End Get
    End Property

#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener si la encuesta tiene campo IC.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property TieneIC() As Boolean
        Get
            Return _tieneIC
        End Get
    End Property

#End Region

#End Region

#Region "METODOS"

#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT

            Dim strSelect As String = Globales.COL_CONSULTAVIV_IC

            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla)
            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _tieneIC = True
            End If
            MyBase.Cargar()
        Catch ex As Exception
            _tieneIC = False
        End Try
    End Sub
#End Region

#Region "PROPIOS"

    ''' <summary>
    ''' Obtener si es IC el código proporcionado.
    ''' </summary>
    ''' <param name="codigo"><c>string</c> Codigo IC</param>
    ''' <returns><c>string</c> Código IC</returns>
    ''' <remarks></remarks>
    Public Function EsIC(ByVal codigo As String) As Boolean
        If String.IsNullOrEmpty(codigo) Then
            Return False
        Else
            Return codigo.Substring(0, 1).Equals(Globales.VALOR_COD_IC_SI)
        End If
    End Function

#End Region
#End Region
End Class