﻿
Namespace Encuesta

    Public Enum TipoEncuesta
        Economica = 0
        Demografica = 10
    End Enum

    Public Enum TipoPeriodoEncuestacion
        Anual
        Trimestral
        Mensual
    End Enum

    Public Class Encuesta
        Inherits Eustat.Comun.V35.Ng.Encuesta

#Region "CONSTANTES"
        Private Const PERIODO_ENCUESTACION_TRIMESTRAL As Char = "T"c
        Private Const PERIODO_ENCUESTACION_MENSUAL As Char = "M"c
#End Region

#Region "VARIABLES"
        Private _alias As String = String.Empty
#End Region

#Region "PROPIEDADES"

#Region "PROPIAS"
        Public ReadOnly Property PeriodoEncuestacion As TipoPeriodoEncuestacion
            Get
                Select Case Me.AnoReferencia
                    Case PERIODO_ENCUESTACION_TRIMESTRAL
                        Return TipoPeriodoEncuestacion.Trimestral
                    Case PERIODO_ENCUESTACION_MENSUAL
                        Return TipoPeriodoEncuestacion.Mensual
                    Case Else
                        Return TipoPeriodoEncuestacion.Anual
                End Select
            End Get
        End Property
#End Region

#Region "SOBRESCRITAS"
        Public Overrides ReadOnly Property NombreTabla() As String
            Get
                Return Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_ENCUESTA
            End Get
        End Property
#End Region

#End Region

#Region "CONSTRUCTOR"
        Public Sub New(ByVal aliasTabla As String)
            MyBase.New(aliasTabla, False)
        End Sub
#End Region

    End Class

End Namespace
