﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa las diferentes ControlUsuarios del estado.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class ControlUsuarios
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsControlUsuarios As DataSet
    Private _filtro As String = String.Empty

    
    Private _numc As String = String.Empty
    Private _perfil As String = String.Empty
    Private _operacion As String = String.Empty
    Private _codusu As String = String.Empty

    Public ALIAS_CODIGO As String = Globales.ALIAS_USUARIOS_NUMC
    Public ALIAS_NOMBRE As String = Globales.ALIAS_USUARIOS_NOMBRE
#End Region

#Region "CONSTRUCTOR"
    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()

    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS & " USU," & Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS_OPE & " REL"
        End Get
    End Property
#End Region

#Region "PROPIAS"
    

    Public ReadOnly Property Perfil() As String
        Get
            Return _perfil
        End Get
    End Property

    Public ReadOnly Property Operacion() As String
        Get
            Return _operacion
        End Get
    End Property

    Public ReadOnly Property CodigoUsu() As String
        Get
            Return _codusu
        End Get
    End Property

    
#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = " " & Globales.COL_USUARIOS_NUMC & " AS " & Globales.ALIAS_USUARIOS_NUMC
            strSelect = strSelect & " ," & Globales.COL_USUARIOS_PERFIL & " AS " & Globales.ALIAS_USUARIOS_PERFIL
            strSelect = strSelect & " ," & Globales.COL_USUARIOS_OPE & " AS " & Globales.ALIAS_USUARIOS_OPE
            strSelect = strSelect & " ,USU." & Globales.COL_USUARIOS_CODUSU & " AS " & Globales.ALIAS_USUARIOS_CODUSU


            If Not String.IsNullOrEmpty(_filtro) Then
                _filtro = _filtro & " AND "
            End If

            _filtro = _filtro & "USU." & Globales.COL_USUARIOS_CODUSU & " = " & "REL." & Globales.COL_USUARIOS_CODUSU


            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, _filtro)


            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dsControlUsuarios = data
                If (_dsControlUsuarios.Tables(0).Rows.Count > 0) Then
                    _perfil = _dsControlUsuarios.Tables(0).Rows(0)(Globales.ALIAS_USUARIOS_PERFIL)
                    _operacion = _dsControlUsuarios.Tables(0).Rows(0)(Globales.ALIAS_USUARIOS_OPE)
                    _numc = _dsControlUsuarios.Tables(0).Rows(0)(Globales.ALIAS_USUARIOS_NUMC)
                    _codusu = _dsControlUsuarios.Tables(0).Rows(0)(Globales.ALIAS_USUARIOS_CODUSU)
                End If
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New ControlUsuariosException(Globales.EX_CONTROLUSU_CARGA, ex.InnerException)
        End Try
    End Sub

    Public Function ObtenerEncuestadores(ByVal op As String) As DataSet
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = " " & Globales.COL_USUARIOS_NUMC & " AS " & Globales.ALIAS_USUARIOS_NUMC
            strSelect = strSelect & "," & Globales.COL_USUARIOS_NOM & " || ' ' || " & Globales.COL_USUARIOS_APE1 & " || ' ' || " & Globales.COL_USUARIOS_APE2 & " AS " & Globales.ALIAS_USUARIOS_NOMBRE

            Dim _filtroAux As String = String.Empty

            If Not String.IsNullOrEmpty(op) Then
                _filtroAux = _filtroAux & Globales.COL_USUARIOS_OPE & " = '" & op & "'"
            End If
            _filtroAux = _filtroAux & " AND " & Globales.COL_USUARIOS_ACTIVO & " = '" & Globales.USUARIO_ACTIVO & "'"
            _filtroAux = _filtroAux & " AND " & Globales.COL_USUARIOS_PERFIL & " = " & Globales.PERFIL_ENCUESTADOR & ""

            _filtroAux = _filtroAux & " AND " & "USU." & Globales.COL_USUARIOS_CODUSU & " = " & "REL." & Globales.COL_USUARIOS_CODUSU



            'hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, _filtroAux)


            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                Return data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New ControlUsuariosException(Globales.EX_CONTROLUSU_CARGA, ex.InnerException)
        End Try

        Return Nothing
    End Function

#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener ControlUsuarios.
    ''' </summary>
    ''' <returns>DataSet con el listado de las ControlUsuarios.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetControlUsuarios(ByVal numc As String)

        Try
            If Not String.IsNullOrEmpty(numc) Then

                If Not String.IsNullOrEmpty(numc) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & Globales.COL_USUARIOS_NUMC & " = '" & numc & "'"
                End If
                _filtro = _filtro & " AND " & Globales.COL_USUARIOS_ACTIVO & " = '" & Globales.USUARIO_ACTIVO & "'"
                Me.Cargar()
            End If

            Return _dsControlUsuarios
        Catch ex As Exception
            Throw New ControlUsuariosException(Globales.EX_CONTROLUSU_CARGA, ex.InnerException)
        End Try
    End Function

    Public Function GetControlUsuarios(ByVal numc As String, ByVal op As String)

        Try
            If Not String.IsNullOrEmpty(numc) Then

                If Not String.IsNullOrEmpty(numc) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & Globales.COL_USUARIOS_NUMC & " = '" & numc & "'"
                End If
                If Not String.IsNullOrEmpty(op) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & Globales.COL_USUARIOS_OPE & " = '" & op & "'"
                End If
                _filtro = _filtro & " AND " & Globales.COL_USUARIOS_ACTIVO & " = '" & Globales.USUARIO_ACTIVO & "'"
                Me.Cargar()
            End If

            Return _dsControlUsuarios
        Catch ex As Exception
            Throw New ControlUsuariosException(Globales.EX_CONTROLUSU_CARGA, ex.InnerException)
        End Try
    End Function
#End Region
#End Region
End Class
