﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa las comarcas.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class Comarcas
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsComarcas As DataSet
    Private _dvComarcas As DataView
    Private _filtro As String = String.Empty
#End Region

#Region "CONSTRUCTOR"
    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <param name="firstEmpty">Valor opcional que especifica si se completa la carga con un valor nulo.
    ''' True: incluir primer registro nulo.
    ''' False: NO incluir primer registro nulo.</param>
    ''' <remarks></remarks>
    Public Sub New(Optional ByVal firstEmpty As Boolean = True)
        Me.Cargar()
        If _dvComarcas IsNot Nothing AndAlso firstEmpty Then
            Dim drEmpty As DataRow = _dvComarcas.Table.NewRow()
            drEmpty(Globales.ALIAS_COM_COMR) = "-1"
            drEmpty(Globales.ALIAS_COM_PROV) = "-1"
            drEmpty(Globales.ALIAS_COM_NOMBRE) = String.Empty
            _dvComarcas.Table.Rows.InsertAt(drEmpty, 0)
        End If
    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return Globales.C_TABLA_COMARCAS
        End Get
    End Property
#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return Globales.COL_COM_COMR
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo nombre.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaNombre() As String
        Get
            Return Globales.COL_COM_NOMBRE
        End Get
    End Property


#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try

            'Se establece la query a ejecutar.
            Dim strQuery As String = Globales.C_SELECT_ORDER

            strQuery = String.Format(strQuery, String.Concat(Globales.COL_COM_COMR, " AS ", Globales.ALIAS_COM_COMR, ", ",
                                                             Globales.COL_COM_PROV, " AS ", Globales.ALIAS_COM_PROV, ", ",
                                                             Globales.COL_COM_NOMBRE, " AS ", Globales.ALIAS_COM_NOMBRE), Me.NombreTabla, Globales.ALIAS_COM_NOMBRE)

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dsComarcas = data
                _dvComarcas = New DataView(_dsComarcas.Tables(0))
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New SituacionesException(Globales.EX_COMARCAS_CARGA, ex)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener comarcas.
    ''' </summary>
    ''' <returns>DataSet con el listado de las comarcas.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetComarcas() As DataView
        _dvComarcas.RowFilter = String.Empty
        Return _dvComarcas
    End Function

    ''' <summary>
    ''' Obtener comarcas de una provincia concreta.
    ''' </summary>
    ''' <param name="id">Identificador de la provincia.</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetComarcas(ByVal id As String) As DataView
        If _dvComarcas IsNot Nothing Then
            _dvComarcas.RowFilter = String.Concat(Globales.ALIAS_COM_COMR, " = '-1' OR ", Globales.ALIAS_COM_PROV, " = ", id)
        End If
        Return _dvComarcas
    End Function

#End Region
#End Region
End Class
