﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa los clase con literales de autocompletado.
''' </summary>
''' <remarks></remarks>
Public Class Autocompletado
    Inherits EntidadBase

#Region "VARIABLES"
    Private _tabla As String
    Private _campo As String
    Private _campoID As String
    Private _term As String
    Private _maxLength As Integer
    Private _dataview As DataView = Nothing
#End Region

#Region "CONSTRUCTOR"
    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New(ByVal tabla As String, ByVal campo As String, ByVal campoID As String, ByVal term As String, Optional ByVal maxLength As Integer = Nothing)
        _tabla = tabla
        _campo = campo
        _campoID = campoID
        _term = term
        _maxLength = maxLength
        Me.Cargar()
    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return _tabla
        End Get
    End Property
#End Region

#Region "PROPIAS"


    ''' <summary>
    ''' Obtener nombre de la columna que contiene el texto a buscar.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property Campo() As String
        Get
            Return _campo
        End Get
    End Property

    ''' <summary>
    ''' Obtener nombre de la columna que contiene el codigo de los textos a buscar.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property CampoID() As String
        Get
            Return _campoID
        End Get
    End Property

    ''' <summary>
    ''' Obtener el texto a buscar.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property Term() As String
        Get
            Return _term
        End Get
    End Property

    ''' <summary>
    ''' Obtener la longitud máxima a devolver.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property MaxLength() As Integer
        Get
            Return _maxLength
        End Get
    End Property
#End Region
#End Region

#Region "METODOS"

#Region "SOBRESCRITOS"

    Public Overrides Sub Cargar()
        Try

            Dim strQuery As String = Globales.C_SELECT_FILTRO_ORDER
            'Se establece la query a ejecutar.

            Dim condition As String = "UPPER(" & Campo & ") LIKE :" & Campo & "||'%' "
            Dim colParams(0) As OracleParameter

            colParams(0) = New OracleParameter(Campo, Term.ToUpper())
            colParams(0).OracleType = OracleType.VarChar

            Dim columnas As String = ""
            If MaxLength > 0 Then
                columnas = "SUBSTR(" & Campo & ",0," & MaxLength & ") AS " & Campo
            Else
                columnas = Campo
            End If
            If Not String.IsNullOrEmpty(CampoID) Then
                columnas += " ," & CampoID
            End If

            strQuery = String.Format(strQuery, columnas, Me.NombreTabla, condition, Campo & " ASC")

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, colParams)
            MyBase.Cargar()
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dataview = (New DataView(data.Tables(0)))
            End If
        Catch ex As Exception
            Throw New AutocompletadoException(Globales.EX_AUTOCOMPLETADO, ex)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    Public Function GetResults() As List(Of AutocompletadoItem)
        Dim resultList As New List(Of AutocompletadoItem)
        For Each dvr As DataRowView In _dataview
            If Not dvr.Item(Campo) Is DBNull.Value Then
                If Not String.IsNullOrEmpty(CampoID) Then
                    resultList.Add(New AutocompletadoItem(dvr.Item(CampoID), dvr.Item(Campo)))
                Else
                    resultList.Add(New AutocompletadoItem(dvr.Item(Campo)))
                End If
            End If
        Next
        Return resultList
    End Function
#End Region

#End Region

End Class

<Serializable()>
Public Class AutocompletadoItem
#Region "VARIABLES"
    Private _id As String
    Private _value As String
#End Region

#Region "CONSTRUCTOR"

    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New(ByVal value As String)
        _id = String.Empty
        _value = value
    End Sub

    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New(ByVal id As String, ByVal value As String)
        _id = id
        _value = value
    End Sub
#End Region

#Region "PROPIEDADES"
#Region "PROPIAS"
    Public ReadOnly Property Id As String
        Get
            Return _id
        End Get
    End Property
    Public ReadOnly Property Value As String
        Get
            Return _value
        End Get
    End Property

#End Region
#End Region

End Class

Public Class AutocompletadoConfig
    Public Sub New(ByVal id As String, ByVal tabla As String, ByVal campoCas As String, ByVal campoEus As String, ByVal campoId As String)
        Me._strId = id
        Me._strTabla = tabla
        Me._strCampoCas = campoCas
        Me._strCampoEus = campoEus
        Me._strCampoId = campoId
    End Sub

#Region "PROPERTIES"
    Private _strId As String
    Public ReadOnly Property ID As String
        Get
            Return Me._strId
        End Get
    End Property

    Private _strTabla As String
    Public ReadOnly Property Tabla As String
        Get
            Return Me._strTabla
        End Get
    End Property

    Private _strCampoCas As String
    Public ReadOnly Property CampoCas As String
        Get
            Return Me._strCampoCas
        End Get
    End Property

    Private _strCampoEus As String
    Public ReadOnly Property CampoEus As String
        Get
            Return Me._strCampoEus
        End Get
    End Property

    Private _strCampoId As String
    Public ReadOnly Property CampoId As String
        Get
            Return Me._strCampoId
        End Get
    End Property

#End Region
End Class

