﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa los errores de validacion.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class ErroresVal
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsErroresVal As DataSet
    Private _filtro As String = String.Empty
    Private _litaviso As String = "A"
    Private _literror As String = "E"
    Private Const _const_aviso As String = "A"
    Private Const _const_error As String = "E"
#End Region

#Region "CONSTRUCTOR"
    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()

    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_ERRORESVAL
        End Get
    End Property
#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return Globales.ALIAS_ACCESO_IDACCESO
        End Get
    End Property


    Public ReadOnly Property ColumnaEncuesta() As String
        Get
            Return Globales.ALIAS_ACCESO_ENCUESTA
        End Get
    End Property

    Public ReadOnly Property ColumnaNumc() As String
        Get
            Return Globales.ALIAS_ACCESO_NUMC
        End Get
    End Property


    Public ReadOnly Property cnstAviso() As String
        Get
            Return _const_aviso
        End Get
    End Property

    Public ReadOnly Property cnstError() As String
        Get
            Return _const_error
        End Get
    End Property
#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = " " & Globales.COL_ERRORESVAL_ID & " AS " & Globales.ALIAS_ERRORESVAL_ID & ",UPPER(" & Globales.COL_ERRORESVAL_TIPO & ") AS " & Globales.ALIAS_ERRORESVAL_TIPO
            strSelect += "," & Globales.COL_ERRORESVAL_DESC & " AS " & Globales.ALIAS_ERRORESVAL_DESC

            If String.IsNullOrEmpty(_filtro) Then
                'no hay que aplicar filtro
                strQuery = Globales.C_SELECT
                strQuery = String.Format(strQuery, strSelect, Me.NombreTabla)
            Else
                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO_ORDER
                strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, _filtro, Globales.ALIAS_ERRORESVAL_ID)
            End If

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dsErroresVal = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New ProvinciaException(Globales.EX_ACCESOS, ex.InnerException)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener errores de validacion.
    ''' </summary>
    ''' <returns>DataSet con el listado errores de validacion.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetErroresVal(ByVal numc As String, ByVal tipoError As String, ByVal desc As String) As DataSet

        Try
            If Not String.IsNullOrEmpty(numc) Or (Not String.IsNullOrEmpty(tipoError) AndAlso tipoError <> "-1") Or Not String.IsNullOrEmpty(desc) Then

                If Not String.IsNullOrEmpty(numc) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & Globales.COL_ERRORESVAL_ID & " like '" & numc & "%'"
                End If
                If Not String.IsNullOrEmpty(tipoError) AndAlso tipoError <> "-1" Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & Globales.COL_ERRORESVAL_TIPO & " = '" & tipoError & "'"
                End If
                If Not String.IsNullOrEmpty(desc) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & Globales.COL_ERRORESVAL_DESC & " like '%" & desc & "%'"
                End If
            End If
            Me.Cargar()
            Return _dsErroresVal
        Catch ex As Exception
            Throw New ProvinciaException(Globales.EX_ACCESOS, ex.InnerException)
        End Try
    End Function
#End Region
#End Region
End Class
