﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa los controles de acceso.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class ControlAcceso
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsAccesos As DataSet
    Private _filtro As String = String.Empty

#End Region

#Region "CONSTRUCTOR"
    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()

    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return Eustat.Comun.V35.DAL.BaseDatos.BBDDAppSettings.DefaultBD & Globales.C_TABLA_USUARIOS
        End Get
    End Property
#End Region

#End Region

#Region "METODOS"


#Region "PROPIOS"
    Public Function ComprobarUsuario(ByVal usuario As String, ByRef codagente As String) As Boolean
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String
            Dim resultado As Boolean = False

            _filtro = Globales.COL_USU_USUARIO & " = '" & usuario & "'"
            'no hay que aplicar filtro
            strQuery = Globales.C_SELECT_FILTRO
            strQuery = String.Format(strQuery, Globales.COL_USU_USUARIO & "," & Globales.COL_USU_CODUSU, Me.NombreTabla, _filtro)


            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If (data IsNot Nothing AndAlso data.Tables.Count > 0) AndAlso data.Tables(0).Rows.Count > 0 Then
                codagente = data.Tables(0).Rows(0)(Globales.COL_USU_CODUSU).ToString()
                resultado = True
            End If
            Return resultado
        Catch ex As Exception
            Throw New CtrlAccesoException(Globales.EX_ACCESOS, ex.InnerException)
        End Try
    End Function
#End Region
#End Region
End Class
