﻿Imports System.Data.OracleClient
Imports System.Threading
Imports Eustat.Comun.V35.DAL.BaseDatos

''' <summary>
''' Clase que representa las diferentes Accesos del estado.
''' </summary>
''' <remarks></remarks>
<Serializable()> _
Public Class Accesos
    Inherits EntidadBase

#Region "VARIABLES"
    Private _dsAccesos As DataSet
    Private _filtro As String = String.Empty

#End Region

#Region "CONSTRUCTOR"
    ''' <summary>
    ''' Constructor base que instancia el objeto.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub New()

    End Sub
#End Region

#Region "PROPIEDADES"
#Region "SOBREESCRITAS"
    ''' <summary>
    ''' Obtener el nombre de la tabla.
    ''' </summary>
    ''' <value>Nombre de la tabla en BBDD.</value>
    ''' <returns>String que representa el nombre de la tabla en BBDD.</returns>
    ''' <remarks>Obtener el nombre de la tabla sobre la que se realiza la consulta.</remarks>
    Public Overrides ReadOnly Property NombreTabla() As String
        Get
            Return Globales.C_TABLA_ACCESOS
        End Get
    End Property
#End Region

#Region "PROPIAS"
    ''' <summary>
    ''' Obtener nombre de la columna que contiene el campo identificador.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ColumnaId() As String
        Get
            Return Globales.ALIAS_ACCESO_IDACCESO
        End Get
    End Property

    Public ReadOnly Property ColumnaFecha() As String
        Get
            Return Globales.ALIAS_ACCESO_FECHA
        End Get
    End Property

    Public ReadOnly Property ColumnaEncuesta() As String
        Get
            Return Globales.ALIAS_ACCESO_ENCUESTA
        End Get
    End Property

    Public ReadOnly Property ColumnaNumc() As String
        Get
            Return Globales.ALIAS_ACCESO_NUMC
        End Get
    End Property

    Public ReadOnly Property ColumnaTipoError() As String
        Get
            Return Globales.ALIAS_ACCESO_TIPOERROR
        End Get
    End Property

    Public ReadOnly Property ColumnaOrigen() As String
        Get
            Return Globales.ALIAS_ACCESO_ORIGEN
        End Get
    End Property

    Public ReadOnly Property ColumnaDetalle() As String
        Get
            Return Globales.ALIAS_ACCESO_DETALLETECNICO
        End Get
    End Property

    Public ReadOnly Property ColumnaPerfil() As String
        Get
            Return Globales.ALIAS_ACCESO_AGENTE
        End Get
    End Property

    Public ReadOnly Property ColumnaTipoAcceso() As String
        Get
            Return Globales.ALIAS_ACCESO_TIPOTRAZA
        End Get
    End Property

    Public ReadOnly Property ColumnaDatos() As String
        Get
            Return Globales.ALIAS_ACCESO_DATOS
        End Get
    End Property

    Public ReadOnly Property ColumnaNavegador() As String
        Get
            Return Globales.ALIAS_ACCESO_NAVEGADOR
        End Get
    End Property

    Public ReadOnly Property ColumnaIp() As String
        Get
            Return Globales.ALIAS_ACCESO_IP
        End Get
    End Property

    Public ReadOnly Property ColumnaSesion() As String
        Get
            Return Globales.ALIAS_ACCESO_SESION
        End Get
    End Property

    Public ReadOnly Property ColumnaPlataforma() As String
        Get
            Return Globales.ALIAS_ACCESO_PLATAFORMA
        End Get
    End Property

    Public ReadOnly Property ColumnaIdioma() As String
        Get
            Return Globales.ALIAS_ACCESO_IDIOMA
        End Get
    End Property

    Public ReadOnly Property ColumnaFuncion() As String
        Get
            Return Globales.ALIAS_ACCESO_FUNCION
        End Get
    End Property
#End Region
#End Region

#Region "METODOS"
#Region "SOBREESCRITOS"
    Public Overrides Sub Cargar()
        Try
            'Se establece la query a ejecutar.
            Dim strQuery As String

            Dim strSelect As String = " " & Globales.COL_ACCESO_IDACCESO & " AS " & Globales.ALIAS_ACCESO_IDACCESO & ", TO_CHAR (" & Globales.COL_ACCESO_FECHA & ",'dd/MM/yyyy hh24:mi:ss') AS " & Globales.ALIAS_ACCESO_FECHA & "," & Globales.COL_ACCESO_ENCUESTA & " AS " & Globales.ALIAS_ACCESO_ENCUESTA & "," & _
                Globales.COL_ACCESO_NUMC & " AS " & Globales.ALIAS_ACCESO_NUMC & "," & Globales.COL_ACCESO_TIPOERROR & " AS " & Globales.ALIAS_ACCESO_TIPOERROR & "," & Globales.COL_ACCESO_ORIGEN & " AS " & Globales.ALIAS_ACCESO_ORIGEN & "," & _
                Globales.COL_ACCESO_DETALLETECNICO & " AS " & Globales.ALIAS_ACCESO_DETALLETECNICO & "," & Globales.COL_ACCESO_AGENTE & " AS " & Globales.ALIAS_ACCESO_AGENTE & "," & Globales.COL_ACCESO_TIPOTRAZA & " AS " & Globales.ALIAS_ACCESO_TIPOTRAZA & "," & _
                Globales.COL_ACCESO_DATOS & " AS " & Globales.ALIAS_ACCESO_DATOS & "," & Globales.COL_ACCESO_NAVEGADOR & " AS " & Globales.ALIAS_ACCESO_NAVEGADOR & "," & Globales.COL_ACCESO_IP & " AS " & Globales.ALIAS_ACCESO_IP & "," & _
                Globales.COL_ACCESO_SESION & " AS " & Globales.ALIAS_ACCESO_SESION & "," & Globales.COL_ACCESO_PLATAFORMA & " AS " & Globales.ALIAS_ACCESO_PLATAFORMA & "," & Globales.COL_ACCESO_IDIOMA & " AS " & Globales.ALIAS_ACCESO_IDIOMA & "," & _
                "decode(" & Globales.COL_ACCESO_TIPOTRAZA & "," & Globales.TIPOTRAZA_CLASE.ToString() & "," & Globales.COL_ACCESO_FUNCION & "," & Globales.COL_ACCESO_ORIGEN & ") AS " & Globales.ALIAS_ACCESO_FUNCION

            If String.IsNullOrEmpty(_filtro) Then
                'no hay que aplicar filtro
                strQuery = Globales.C_SELECT
                strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, Globales.ALIAS_ACCESO_FECHA)
            Else
                'hay que aplicar filtro
                strQuery = Globales.C_SELECT_FILTRO_ORDER
                strQuery = String.Format(strQuery, strSelect, Me.NombreTabla, _filtro, Globales.ALIAS_ACCESO_FECHA)
            End If

            'Se ejecuta la query
            Dim data As DataSet = Me.EjecutarSQL(strQuery, CommandType.Text, Nothing)
            'Se recorre los data
            If data IsNot Nothing AndAlso data.Tables.Count > 0 Then
                _dsAccesos = data
            End If
            MyBase.Cargar()
        Catch ex As Exception
            Throw New ProvinciaException(Globales.EX_ACCESOS, ex.InnerException)
        End Try
    End Sub
#End Region

#Region "PROPIOS"
    ''' <summary>
    ''' Obtener Accesos.
    ''' </summary>
    ''' <returns>DataSet con el listado de las Accesos.
    ''' </returns>
    ''' <remarks></remarks>
    Public Function GetAccesos(ByVal fecha As String, ByVal detalle As String, ByVal encuesta As String, ByVal funcion As String, ByVal numc As String, _
                               ByVal perfil As String, ByVal hDesde As String, ByVal hHasta As String, ByVal tipoTraza As String, ByVal tipoError As String) As DataSet

        Try
            If Not String.IsNullOrEmpty(fecha) Or Not String.IsNullOrEmpty(detalle) Or Not String.IsNullOrEmpty(encuesta) _
                        Or Not String.IsNullOrEmpty(funcion) Or Not String.IsNullOrEmpty(numc) Or Not String.IsNullOrEmpty(perfil) _
                        Or Not String.IsNullOrEmpty(hDesde) Or Not String.IsNullOrEmpty(hHasta) _
                        Or (Not String.IsNullOrEmpty(tipoTraza) AndAlso tipoTraza <> "-1") _
                        Or (Not String.IsNullOrEmpty(tipoError) AndAlso tipoError <> "-1") Then

                If Not String.IsNullOrEmpty(fecha) Then
                    If IsDate(fecha) Then
                        _filtro = " to_char(" & Globales.COL_ACCESO_FECHA & ",'dd/mm/yyyy') = '" & fecha & "'"
                    End If
                End If
                If (Not String.IsNullOrEmpty(hDesde)) And (Not String.IsNullOrEmpty(hHasta)) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & Globales.COL_ACCESO_FECHA & " >= (to_date('" & fecha & " " & hDesde & "', 'dd/MM/yyyy hh24:mi')) AND " & _
                        Globales.COL_ACCESO_FECHA & " <= (to_date('" & fecha & " " & hHasta & "', 'dd/MM/yyyy hh24:mi'))"
                Else
                    If Not String.IsNullOrEmpty(hDesde) Then
                        If Not String.IsNullOrEmpty(_filtro) Then
                            _filtro = _filtro & " AND "
                        End If
                        _filtro = _filtro & Globales.COL_ACCESO_FECHA & " >= (to_date('" & fecha & " " & hDesde & "', 'dd/MM/yyyy hh24:mi'))"
                    End If

                    If Not String.IsNullOrEmpty(hHasta) Then
                        If Not String.IsNullOrEmpty(_filtro) Then
                            _filtro = _filtro & " AND "
                        End If
                        _filtro = _filtro & " AND " & Globales.COL_ACCESO_FECHA & " <= (to_date('" & fecha & " " & hHasta & "', 'dd/MM/yyyy hh24:mi'))"
                    End If
                End If

                If Not String.IsNullOrEmpty(funcion) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & " UPPER(" & Globales.COL_ACCESO_FUNCION & ") like UPPER('" & funcion & "%')"
                End If
                If Not String.IsNullOrEmpty(encuesta) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & " UPPER(" & Globales.COL_ACCESO_ENCUESTA & ") like UPPER('" & encuesta & "%')"
                End If
                If Not String.IsNullOrEmpty(detalle) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & " UPPER(" & Globales.COL_ACCESO_DETALLETECNICO & ") like UPPER('" & detalle & "%')"
                End If
                If Not String.IsNullOrEmpty(numc) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & Globales.COL_ACCESO_NUMC & " like '" & numc & "%'"
                End If
                If Not String.IsNullOrEmpty(perfil) Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & " UPPER(" & Globales.COL_ACCESO_AGENTE & ")  like UPPER('" & perfil & "%')"
                End If
                If Not String.IsNullOrEmpty(tipoError) AndAlso tipoError <> "-1" Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & Globales.COL_ACCESO_TIPOERROR & " = " & tipoError
                End If
                If Not String.IsNullOrEmpty(tipoTraza) AndAlso tipoTraza <> "-1" Then
                    If Not String.IsNullOrEmpty(_filtro) Then
                        _filtro = _filtro & " AND "
                    End If
                    _filtro = _filtro & Globales.COL_ACCESO_TIPOTRAZA & " = " & tipoTraza
                End If
            End If
            Me.Cargar()
            Return _dsAccesos
        Catch ex As Exception
            Throw New AccesosException(Globales.EX_ACCESOS, ex.InnerException)
        End Try
    End Function
#End Region
#End Region
End Class
