<%@include file="/WEB-INF/includeTemplate.inc"%>

<div class="container ng-scope">
	<ol class="breadcrumb">
	  <li><a href="<c:url value="/inicio" />"><spring:message code="migas.inicio" /></a></li>
	  <li id="migasBuscarRecurso"><a href="<c:url value="/oficina/buscarRecurso?filtro=S" />"><spring:message code="migas.busquedaRecursos" /></a></li>
	  <li class="active"><spring:message code="menu.precios" /></li>
	</ol>
	
	<div class="alert alert-info alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		<span><spring:message code="recursos.avisoPrecios"></spring:message></span>
	</div>
	
	<header>
		<div class="row cabeceraDatosComunes">
			<div class="col-sm-6 col-xs-12"> 
				<h2>${recurso.nombre}</h2>
			</div>
			<div class="col-sm-6 col-xs-12 text-right">
				<a href="${recurso.urlPortal}" target="_blank" class="linkFicha"><i class="icon material-icons">visibility</i><spring:message code="recursos.verFichaPortal" /></a>
			</div>
        </div>
	</header>
	<section>
		<div class="alertPanel" id="divAlert"></div>
		<input type="hidden" id="codRecurso" value="${recurso.codigo}" />
		<input type="hidden" id="tipoRecurso" value="${recurso.tipo}" />
		<input type="hidden" id="subtipoRecurso" value="${recurso.subtipo}" />
		<div class="panel panel-default">
			<div class="panel-heading"><label><spring:message code="recursos.precios" /></label></div>
			<div class="panel-body">					
				<div id="divToolbarTabla">
					<button type="button" class="btn btn-light" id="btnNuevo"><span class="btn-add material-icons">add</span><span><spring:message code="comun.anadir"/></span></button>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<table id="tblPrecios"></table>
					</div>
				</div>
				
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<button class="btn btn-primary" type="button" id="btnGuardarTodo"><spring:message code="comun.guardar"/></button>
			</div>
		</div>
		<form id="frmControlPrecios"></form> <!-- para control cambios de la pantalla -->
		
	</section>
	
	<!-- Aqui va la modal para añadir precios-->
	<div class="modal fade" id="modalPrecio">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close btnCerrarModalPrecio" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><spring:message code="recursos.precios" /></h4>
				</div>
				<div class="modal-body">					
					<form class="form-horizontal" id="frmPrecio">
						<input type="hidden" name="id" />
						<div class="alertPanel" id="divAlertPrecio"></div>										
						<div class="panel panel-default">
							<div class="panel-heading"><label><spring:message code="recursos.detallePrecio" /></label></div>
							<div class="panel-body">
								<div class="row">										
									<div class="col-xs-12 form-group">
										<label><spring:message code="recursos.tipoPrecio" /></label>
										<form:select class="form-control" path="codTipoPrecio" id="cmbTipoPrecio" name="codigoPrecio">
											<form:option value="" label="" />
											<form:options items="${tiposPrecio}" />
										</form:select>
									</div>
								</div>	<!-- fin fila -->
				
								<div class="row ocultar" id="divCapacidad">
									<div class="col-xs-12 form-group">
										<label><spring:message code="recursos.capacidad" /></label>
										<input type="text" class="campoNumerico form-control" name="capacidad" id="capacidad" data-v-max="999" maxlength="3" />
									</div>
								</div>	<!-- fin fila -->
				
								<div class="row">
									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="recursos.precioMinimo" /></label>
										<input type="text" class="form-control campoNumerico" name="precioMinimo" id="precioMinimo" data-a-sign="€" data-v-max="99999999.99" data-m-dec="2" maxlength="11" />
									</div>
									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="recursos.precioMaximo" /></label>
										<input type="text" class="form-control campoNumerico" name="precioMaximo" id="precioMaximo" data-a-sign="€" data-v-max="99999999.99" data-m-dec="2" maxlength="11"  />
									</div>
								</div><!-- fin fila -->
								
								<div class="panel panel-default ocultar" id="divPanelParcela">
									<div class="panel-heading"><label><spring:message code="recursos.precioParcelaIncluye" /></label></div>
									<div class="panel-body">
										<div class="row">
											<div class="col-sm-6 col-xs-12 form-group">
												<label><spring:message code="recursos.adultos" /></label>
												<input type="text" class="form-control campoNumerico" name="parcelaAdulto" id="parcelaAdulto" data-v-max="99" maxlength="2" />
											</div>
											<div class="col-sm-6 col-xs-12 form-group">
												<label><spring:message code="recursos.ninos" /></label>
												<input type="text" class="form-control campoNumerico" name="parcelaInfantil" id="parcelaInfantil" data-v-max="99" maxlength="2" />
											</div>
										</div><!-- fin fila -->
										
										<div class="row">
											<div class="col-sm-6 col-xs-12 form-group">
												<label><spring:message code="recursos.tiendas" /></label>
												<input type="text" class="form-control campoNumerico" name="parcelaTienda" id="parcelaTienda" data-v-max="99" maxlength="2" />
											</div>
											<div class="col-sm-6 col-xs-12 form-group">
												<label><spring:message code="recursos.automoviles" /></label>
												<input type="text" class="form-control campoNumerico" name="parcelaAutomovil" id="parcelaAutomovil" data-v-max="99" maxlength="2" />
											</div>
										</div><!-- fin fila -->
										
										<div class="row">
											<div class="col-sm-6 col-xs-12 form-group">
												<label><spring:message code="recursos.conexionElectrica" /></label>
												<input type="text" class="form-control campoNumerico" name="parcelaConexionElectrica" id="parcelaConexionElectrica" data-v-max="99" maxlength="2" />
											</div>
										</div><!-- fin fila -->
									</div>
								</div>
								
						
							</div><!-- Fin panel-body-->
						</div><!-- Fin panel-default-->							
						
						
					</form>
				</div>
				<div class="modal-footer">
					<button class="btn btn-light btnCerrarModalPrecio" type="button"><spring:message code="comun.cancelar"/></button>
					<button class="btn btn-primary" type="button" id="btnAceptarPrecio"><spring:message code="comun.aceptar"/></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</div><!-- /.modal -->
	
	
</div>